import os, setuptools, sys, sysconfig;
from pkg_resources import packaging

# https://stackoverflow.com/questions/14320220/testing-python-c-libraries-get-build-path
def distutils_dir_name( dir_name ):
    """Returns the name of a distutils build directory"""
    f = "{dirname}.{platform}-{cache_tag}"
    my_cache_tag = sys.implementation.cache_tag
    if packaging.version.parse( setuptools.__version__) < packaging.version.parse( "62.1.0"):
        my_cache_tag = str( sys.version_info.major) + '.' + str( sys.version_info.minor)
    return f.format(dirname = dir_name,
                    platform = sysconfig.get_platform(),
                    cache_tag = my_cache_tag)

# get build path of module
python_so_extension = sysconfig.get_config_var('EXT_SUFFIX')

module_path = os.path.join('build', distutils_dir_name( 'lib'))
sys.path.insert( 1, module_path)

import gidpost

def error_exit( filename, code, msg):
    print( "* ERROR writing file " + filename)
    print( "* ", msg)
    print( "* code =", code)
    exit( 1)

format = gidpost.GiD_PostHDF5
# format = gidpost.GiD_PostAscii

test_filename = "gidpost-test.post.h5"
if ( format == gidpost.GiD_PostAscii):
    test_filename = "gidpost-test.post.msh"

fail = 0

print( "version =", gidpost.GiD_PostGetVersion())
print( "is thread safe =", "yes" if gidpost.GiD_PostIsThreadSafe( gidpost.GiD_PostHDF5) else "no")

fail = gidpost.GiD_PostInit()
if ( fail): error_exit( test_filename, fail, "in GiD_PostInit()")

# ascii post output writes 2 files : *.post.msh and *.post.res
# hdf5 post output writes 1 file
file_id = 0;
if ( format == gidpost.GiD_PostAscii):
    file_id = gidpost.GiD_fOpenPostMeshFile( test_filename, format)
    if ( file_id == 0): fail = 1
    if ( fail): error_exit( test_filename, fail, "in GiD_fOpenPostMeshFile()")
else:
    file_id = gidpost.GiD_fOpenPostResultFile( test_filename, format)
    if ( file_id == 0): fail = 1
    if ( fail): error_exit( test_filename, fail, "in GiD_fOpenPostResultFile()")

# create connectivity array for each element
# two triangles
elem_connec_1 = gidpost.new_intArray( 3)
elem_connec_2 = gidpost.new_intArray( 3)
# 1 quadrilateral
elem_connec_3 = gidpost.new_intArray( 4)               # Create an array

# id's begin at 1
gidpost.intArray_setitem( elem_connec_1, 0, 1)
gidpost.intArray_setitem( elem_connec_1, 1, 2)
gidpost.intArray_setitem( elem_connec_1, 2, 3)
gidpost.intArray_setitem( elem_connec_2, 0, 1)
gidpost.intArray_setitem( elem_connec_2, 1, 3)
gidpost.intArray_setitem( elem_connec_2, 2, 4)
gidpost.intArray_setitem( elem_connec_3, 0, 2)
gidpost.intArray_setitem( elem_connec_3, 1, 5)
gidpost.intArray_setitem( elem_connec_3, 2, 6)
gidpost.intArray_setitem( elem_connec_3, 3, 3)

# fail = gidpost.GiD_BeginMesh( "test gidpost python module", gidpost.GiD_3D, gidpost.GiD_Triangle, 3)
# if ( fail): error_exit( test_filename, fail, "in creating intArrays")
gidpost.GiD_fBeginMeshColor( file_id, "test gp_py triangles", gidpost.GiD_3D, gidpost.GiD_Triangle, 3, 0.6, 0.5, 0.4)
gidpost.GiD_fBeginCoordinates( file_id)
gidpost.GiD_fWriteCoordinates( file_id, 1, 0.0, 0.0, 0.0)
gidpost.GiD_fWriteCoordinates( file_id, 2, 1.0, 0.0, 0.0)
gidpost.GiD_fWriteCoordinates( file_id, 3, 1.0, 1.0, 0.0)
gidpost.GiD_fWriteCoordinates( file_id, 4, 0.0, 1.0, 0.0)
# coordinates of other meshes can be written here or at each mesh
gidpost.GiD_fWriteCoordinates( file_id, 5, 2.0, 0.0, 0.0)
gidpost.GiD_fWriteCoordinates( file_id, 6, 2.0, 1.0, 0.0)
fail = gidpost.GiD_EndCoordinates()
if ( fail): error_exit( test_filename, fail, "in GiD_BeginMeshColor()/GiD_EndCoordinates() triangles")
gidpost.GiD_fBeginElements( file_id)
gidpost.GiD_fWriteElement( file_id, 1, elem_connec_1)
gidpost.GiD_fWriteElement( file_id, 2, elem_connec_2)
fail = gidpost.GiD_fEndElements( file_id)
if ( fail): error_exit( test_filename, fail, "in GiD_EndElements() triangles")

gidpost.GiD_fBeginMeshColor( file_id, "test gp_py quadrilaterals", gidpost.GiD_3D, gidpost.GiD_Quadrilateral, 4, 0.8, 0.2, 0.5)
# coordinates of other meshes can be written in the first mesh or at each mesh
# gidpost.GiD_BeginCoordinates()
# gidpost.GiD_WriteCoordinates( 5, 2.0, 0.0, 0.0)
# gidpost.GiD_WriteCoordinates( 6, 2.0, 1.0, 0.0)
# fail = gidpost.GiD_EndCoordinates()
# if ( fail): error_exit( test_filename, fail, "in GiD_BeginMeshColor()/GiD_EndCoordinates() quads")
gidpost.GiD_fBeginElements( file_id)
gidpost.GiD_fWriteElement( file_id, 3, elem_connec_3)
fail = gidpost.GiD_fEndElements( file_id)
if ( fail): error_exit( test_filename, fail, "in GiD_EndElements() quads")

# ascii post output writes 2 files : *.post.msh and *.post.res
# hdf5 post output writes 1 file
if ( format == gidpost.GiD_PostAscii):
    fail = gidpost.GiD_fClosePostMeshFile( file_id)
    if ( fail): error_exit( test_filename, fail, "in GiD_fClosePostMeshFile()")
    test_filename = "gidpost-test.post.res"
    file_id = gidpost.GiD_fOpenPostResultFile( test_filename, format)
    if ( file_id == 0): fail = 1
    if ( fail): error_exit( test_filename, fail, "in GiD_fOpenPostResultFile()")

# define gauss point 'elemental' or use standard GP_ELEMENT_1
# gidpost.GiD_BeginGaussPoint( "elemental", gidpost.GiD_Triangle, "__all__", 1, 0, 1)
# fail = gidpost.GiD_EndGaussPoint();
# if ( fail): error_exit( test_filename, fail, "in ")

fail = gidpost.GiD_fBeginResultHeader( file_id, "test nodal", "gidpost", 1.0, gidpost.GiD_Scalar, gidpost.GiD_OnNodes, "")

# id's begin at 1
gidpost.GiD_fWriteScalar( file_id, 1, 10.1)
gidpost.GiD_fWriteScalar( file_id, 2, 20.2)
gidpost.GiD_fWriteScalar( file_id, 3, 30.3)
gidpost.GiD_fWriteScalar( file_id, 4, 40.4)
gidpost.GiD_fWriteScalar( file_id, 5, 50.5)
gidpost.GiD_fWriteScalar( file_id, 6, 60.6)
fail = gidpost.GiD_fEndResult( file_id)
if ( fail): error_exit( test_filename, fail, "in writing result test nodal")
# gidpost.GiD_fBeginResultHeader( file_id, "test elemental", "gidpost", 1.0, gidpost.GiD_Scalar, gidpost.GiD_OnGaussPoints, "elemental")
gidpost.GiD_fBeginResultHeader( file_id, "test elemental", "gidpost", 1.0, gidpost.GiD_Scalar, gidpost.GiD_OnGaussPoints, "GP_ELEMENT_1")
# id's begin at 1
gidpost.GiD_fWriteScalar( file_id, 1, 11.1)
gidpost.GiD_fWriteScalar( file_id, 2, 22.2)
gidpost.GiD_fWriteScalar( file_id, 3, 33.3)
fail = gidpost.GiD_fEndResult( file_id)
if ( fail): error_exit( test_filename, fail, "in writing result test elemental")

fail = gidpost.fGiD_ClosePostResultFile( file_id)
if ( fail): error_exit( test_filename, fail, "in GiD_ClosePostResultFile()")
fail = gidpost.GiD_PostDone()
if ( fail): error_exit( test_filename, fail, "in GiD_PostDone()")

gidpost.delete_intArray( elem_connec_1)
gidpost.delete_intArray( elem_connec_2)
gidpost.delete_intArray( elem_connec_3)

print( '* gidpost file created: ' + test_filename)
