# Build

```shell
make
# or :
swig -python gidpost_module.i
python3 setup.py build
```

**Note:** make sure you are not using GiDs python. Some modules are missing, like 'msvcrt'. Check your PATH variable.

# Test

```shell
make test         ;# test python module by writing a simple example using 'deprecated' API
                  ;# and with the file API and the new array-block.
```

# run local without installing:

**Previous API, as in [gidpost_test.py](gidpost_test.py)**

```python
$ python3
Type "help", "copyright", "credits" or "license" for more information.
>>> import os, sys; sys.path.insert( 1, os.getcwd() + '/build/lib.linux-x86_64-cpython-310'); import gidpost
gidpost.GiD_PostInit()
gidpost.GiD_OpenPostResultFile( "gidpost-test.post.h5", gidpost.GiD_PostHDF5)

# create connectivity array for each element
# two triangles
elem_connec_1 = gidpost.new_intArray( 3)
elem_connec_2 = gidpost.new_intArray( 3)
# 1 quadrilateral
elem_connec_3 = gidpost.new_intArray( 4)               # Create an array
# id's begin at 1
gidpost.intArray_setitem( elem_connec_1, 0, 1)
gidpost.intArray_setitem( elem_connec_1, 1, 2)
gidpost.intArray_setitem( elem_connec_1, 2, 3)
gidpost.intArray_setitem( elem_connec_2, 0, 1)
gidpost.intArray_setitem( elem_connec_2, 1, 3)
gidpost.intArray_setitem( elem_connec_2, 2, 4)
gidpost.intArray_setitem( elem_connec_3, 0, 2)
gidpost.intArray_setitem( elem_connec_3, 1, 5)
gidpost.intArray_setitem( elem_connec_3, 2, 6)
gidpost.intArray_setitem( elem_connec_3, 3, 3)

gidpost.GiD_BeginMeshColor( "test gp_py triangles", gidpost.GiD_3D, gidpost.GiD_Triangle, 3, 0.6, 0.5, 0.4)
gidpost.GiD_BeginCoordinates()
gidpost.GiD_WriteCoordinates( 1, 0.0, 0.0, 0.0)
gidpost.GiD_WriteCoordinates( 2, 1.0, 0.0, 0.0)
gidpost.GiD_WriteCoordinates( 3, 1.0, 1.0, 0.0)
gidpost.GiD_WriteCoordinates( 4, 0.0, 1.0, 0.0)
# coordinates of other meshes can be written here or at each mesh
gidpost.GiD_WriteCoordinates( 5, 2.0, 0.0, 0.0)
gidpost.GiD_WriteCoordinates( 6, 2.0, 1.0, 0.0)
gidpost.GiD_EndCoordinates()
gidpost.GiD_BeginElements()
gidpost.GiD_WriteElement( 1, elem_connec_1)
gidpost.GiD_WriteElement( 2, elem_connec_2)
gidpost.GiD_EndElements()

gidpost.GiD_BeginMeshColor( "test gp_py quadrilaterals", gidpost.GiD_3D, gidpost.GiD_Quadrilateral, 4, 0.8, 0.2, 0.5)
# coordinates of other meshes can be written in the first mesh or at each mesh
# gidpost.GiD_BeginCoordinates()
# gidpost.GiD_WriteCoordinates( 5, 2.0, 0.0, 0.0)
# gidpost.GiD_WriteCoordinates( 6, 2.0, 1.0, 0.0)
# gidpost.GiD_EndCoordinates()
gidpost.GiD_BeginElements()
gidpost.GiD_WriteElement( 3, elem_connec_3)
gidpost.GiD_EndElements()

# Writing results
gidpost.GiD_BeginResultHeader( "test nodal", "gidpost", 1.0, gidpost.GiD_Scalar, gidpost.GiD_OnNodes, "")
# id's begin at 1
gidpost.GiD_WriteScalar( 1, 10.0)
gidpost.GiD_WriteScalar( 2, 20.0)
gidpost.GiD_WriteScalar( 3, 30.0)
gidpost.GiD_WriteScalar( 4, 40.0)
gidpost.GiD_WriteScalar( 5, 50.0)
gidpost.GiD_WriteScalar( 6, 60.0)
gidpost.GiD_EndResult()

gidpost.GiD_BeginResultHeader( "test elemental", "gidpost", 1.0, gidpost.GiD_Scalar, gidpost.GiD_OnGaussPoints, "GP_ELEMENT_1")
# id's begin at 1
gidpost.GiD_WriteScalar( 1, 11.0)
gidpost.GiD_WriteScalar( 2, 22.0)
gidpost.GiD_WriteScalar( 3, 33.0)
gidpost.GiD_EndResult()

gidpost.GiD_ClosePostResultFile()
gidpost.GiD_PostDone()

gidpost.delete_intArray( elem_connec_1)
gidpost.delete_intArray( elem_connec_2)
gidpost.delete_intArray( elem_connec_3)

```

**File and Block/array API, as in [gidpost_test_array.py](gidpost_test_array.py)**

```python
$ python3
Type "help", "copyright", "credits" or "license" for more information.
>>> import os, sys; sys.path.insert( 1, os.getcwd() + '/build/lib.linux-x86_64-cpython-310'); import gidpost
gidpost.GiD_PostInit()
file_id = gidpost.GiD_fOpenPostResultFile( "gidpost-test-array.post.h5", gidpost.GiD_PostHDF5)

# helper functions
def copy_to_intArray( int_array, list):
    idx = 0
    for value in list:
        gidpost.intArray_setitem( int_array, idx, value)
        idx = idx + 1

def copy_to_doubleArray( double_array, list):
    idx = 0
    for value in list:
        gidpost.doubleArray_setitem( double_array, idx, value)
        idx = idx + 1

# define mesh
# Create coordinates:
num_nodes = 6
# we could have skipped the id's as they are all consecutive
coords_list_ids = gidpost.new_intArray( num_nodes)
copy_to_intArray( coords_list_ids, range( 1, 7))  # list = 1, 2, 3, 4, 5, 6
coords_list_xyz = gidpost.new_doubleArray( num_nodes * 3)
copy_to_doubleArray( coords_list_xyz, [ 
    0.0, 0.0, 0.0,
    1.0, 0.0, 0.0,
    1.0, 1.0, 0.0,
    0.0, 1.0, 0.0,
    2.0, 0.0, 0.0, 
    2.0, 1.0, 0.0
    ])
# Create connectivity array
# two triangles
num_triangles = 2
triangs_list_ids = gidpost.new_intArray( num_triangles)
copy_to_intArray( triangs_list_ids, [ 1, 2])
triangs_connectivities = gidpost.new_intArray( num_triangles * 3)
copy_to_intArray( triangs_connectivities, [ 
    1 , 2, 3,
    1 , 3, 4
    ])
# 1 quadrilateral
num_quads = 1
quads_list_ids = gidpost.new_intArray( num_quads)
copy_to_intArray( quads_list_ids, [ 3])
quads_connectivities = gidpost.new_intArray( num_quads * 4)
copy_to_intArray( quads_connectivities, [ 2 , 5, 6, 3])

gidpost.GiD_fBeginMeshColor( file_id, "test gp_py triangles", gidpost.GiD_3D, gidpost.GiD_Triangle, 3, 0.6, 0.5, 0.4)
fail = gidpost.GiD_fWriteCoordinatesIdBlock( file_id, num_nodes, coords_list_ids, coords_list_xyz)

fail = gidpost.GiD_fWriteElementsIdBlock( file_id, num_triangles, triangs_list_ids, triangs_connectivities)

gidpost.GiD_fBeginMeshColor( file_id, "test gp_py quadrilaterals", gidpost.GiD_3D, gidpost.GiD_Quadrilateral, 4, 0.8, 0.2, 0.5)
# if we had more coordinates, like nodes 5 and 6 above, we could have written them here...
fail = gidpost.GiD_fWriteElementsIdBlock( file_id, num_quads, quads_list_ids, quads_connectivities)

# Create results
# nodal result for all nodes
scalar_nodes = gidpost.new_doubleArray( num_nodes * 1)
copy_to_doubleArray( scalar_nodes, [ 10.1, 20.2, 30.3, 40.4, 50.5, 60.6])
# elemental result for all elements
num_elements = num_triangles + num_quads
elements_list_ids = gidpost.new_intArray( num_elements)
copy_to_intArray( elements_list_ids, range( 1, num_elements + 1)),
scalar_elemental = gidpost.new_doubleArray( num_elements * 1)
copy_to_doubleArray( scalar_elemental, [ 11.1, 22.2, 33.3])

# Writing results
# id's are the same as nodes
list_comp_names = gidpost.new_stringArray( 0);
fail = gidpost.GiD_fWriteResultBlock( file_id, "test nodal", "gidpost", 1.0, 
                                     gidpost.GiD_Scalar, gidpost.GiD_OnNodes, "", "", 0, list_comp_names, 
                                     num_nodes, coords_list_ids, 1, scalar_nodes)

fail = gidpost.GiD_fWriteResultBlock( file_id, "test elemental", "gidpost", 1.0, 
                                     gidpost.GiD_Scalar, gidpost.GiD_OnGaussPoints, "GP_ELEMENT_1", "", 0, list_comp_names, 
                                     num_elements, elements_list_ids, 1, scalar_elemental)

fail = gidpost.GiD_fClosePostResultFile( file_id)
fail = gidpost.GiD_PostDone()

gidpost.delete_intArray( coords_list_ids)
gidpost.delete_intArray( triangs_list_ids)
gidpost.delete_intArray( triangs_connectivities)
gidpost.delete_intArray( quads_list_ids)
gidpost.delete_intArray( quads_connectivities)
gidpost.delete_intArray( elements_list_ids)

gidpost.delete_doubleArray( coords_list_xyz)
gidpost.delete_doubleArray( scalar_nodes)
gidpost.delete_doubleArray( scalar_elemental)
```



# install

    pip install gidpost
    # or
    python3 setup.py install --record files.txt

# uninstall

    pip uninstall gidpost
    # or
    xargs rm -rf < files.txt
    rm -rf $HOME/lib/python3.10/site-packages/gidpost-1.0-py3.10-linux-x86_64.egg

