      PROGRAM EXAMPLE

      INTEGER iargc
      REAL*8 nodes(1:9,1:3), rx, ry, rz, value
      INTEGER elems(1:4,1:4)
      INTEGER*4 idx, x, y, nid(1:4)
      CHARACTER*4 NULL
      CHARACTER*1024 prefix
      integer len_prefix
      CHARACTER*1024 prefix_utf8
      integer len_prefix_utf8
      CHARACTER*1024 filename

      if ( iargc() .GT. 0) THEN
        call getarg( 1, prefix)
      else
        prefix = 'testfortran77'
      end if
      len_prefix = len_trim(prefix)
      NULL = CHAR(0)//CHAR(0)//CHAR(0)//CHAR(0)
      idx = 1
      do x=0,2
         do y=0,2
            nodes(idx,1) = x
            nodes(idx,2) = y
            nodes(idx,3) = 0
            idx = idx + 1
         end do
      end do
      idx = 1
      do x=1,2
         do y=1,2
            elems(idx,1) = x + (y-1)*3
            elems(idx,2) = elems(idx,1) + 1
            elems(idx,4) = elems(idx,1) + 3
            elems(idx,3) = elems(idx,4) + 1
            idx = idx + 1
         end do
      end do

      
      CALL ENCODE_TO_UTF8( prefix, prefix_utf8)
      len_prefix_utf8 = len_trim(prefix_utf8)
      PRINT *, 'Original string: ', trim(prefix)
      PRINT *, 'UTF-8 encoded string: ', trim(prefix_utf8)
      
c      filename = prefix_utf8( 1:len_prefix_utf8) // '.post.msh'
C      CALL GID_OPENPOSTMESHFILE( filename, 0)
c      filename = prefix_utf8( 1:len_prefix_utf8) // '.post.res'
c      CALL GID_OPENPOSTRESULTFILE( filename, 0)   ! 0 = GiD_PostAscii (gidpost.h)
      filename = prefix_utf8( 1:len_prefix_utf8) // '.post.res'
      CALL GID_OPENPOSTRESULTFILE( filename,2)    ! 2 = GiD_PostBinary (gidpost.h)
c      filename = prefix_utf8( 1:len_prefix_utf8) // '.post.h5'
c      CALL GID_OPENPOSTRESULTFILE( filename, 3)    ! 3 = GiD_PostHDF5 (gidpost.h)
      print *, "Filename : ", trim(filename)
      CALL GID_BEGINMESHCOLOR('quadmesh',2,4,4,0.7d0,0.7d0,0.4d0)
      CALL GID_MESHUNIT('mm')
      CALL GID_BEGINCOORDINATES
      idx = 1
      do x=0,2
         do y=0,2
            rx = x
            ry = y
            rz = 0.0     
            CALL GID_WRITECOORDINATES(idx, rx, ry, rz)
            idx = idx + 1
         end do
      end do
      CALL GID_ENDCOORDINATES
      CALL GID_BEGINELEMENTS
      idx = 1
      
      do x=1,2
         do y=1,2
            nid(1) = x + (y-1)*3
            nid(2) = nid(1) + 1
            nid(4) = nid(1) + 3
            nid(3) = nid(4) + 1
            CALL GID_WRITEELEMENT(idx, nid)
            idx = idx + 1
         end do
      end do      
      CALL GID_ENDELEMENTS
      CALL GID_ENDMESH
C     Scalar result
      CALL GID_BEGINSCALARRESULT('Pressure','Analysis',
     .1.0,0,NULL,NULL,NULL)
      do idx=1,9
         value=idx*1.5
         CALL GID_WRITESCALAR(idx,value)
      end do
      CALL GID_ENDRESULT
      CALL GID_FLUSHPOSTFILE
C     Vectorial result
      CALL GID_BEGINRESULTHEADER('Velocity'//char(0),
     .'Analysis'//char(0), 1.0, 1, 0, NULL)
      CALL GID_VECTORCOMP('Comp X','Comp Y','Comp Z','Module')
      CALL GID_RESULTUNIT('m/s')
      CALL GID_RESULTVALUES
      do idx=1,9
         value=idx*1.5
         CALL GID_WRITEVECTOR(idx,value,value*3,value*5)
      end do
      CALL GID_ENDRESULT
      
C     Complex scalar result
      CALL GID_BEGINRESULTHEADER('Potential','Analysis',1.0,6,0,NULL)
      CALL GID_VECTORCOMP('real_part','imaginary_part','','')
      CALL GID_RESULTUNIT('Volt')
      CALL GID_RESULTVALUES
      do idx=1,9
         value=idx*1.5
         CALL GID_WRITECOMPLEXSCALAR(idx,value,value*1.2)
      end do
      CALL GID_ENDRESULT      

C      CALL GID_CLOSEPOSTMESHFILE
      CALL GID_CLOSEPOSTRESULTFILE
      END
      
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC      
      SUBROUTINE ENCODE_TO_UTF8(EXTERNAL_STRING, UTF8_STRING)
      CHARACTER*(*) EXTERNAL_STRING, UTF8_STRING
      INTEGER I, N
      CHARACTER CHAR

      N = LEN_TRIM(EXTERNAL_STRING)
      UTF8_STRING = ' '

      DO 10 I = 1, N
        CHAR = EXTERNAL_STRING(I:I)
        IF (ICHAR(CHAR) .GT. 127) THEN
          PRINT *, 'Non-ASCII character detected at position ', I
          UTF8_STRING(I:I) = CHAR
        ELSE
          UTF8_STRING(I:I) = CHAR
        END IF
 10   CONTINUE

      RETURN
      END

