module encoding_module
    use, intrinsic :: iso_fortran_env, only: int8
    implicit none
contains

    function encode_to_utf8(external_string) result(utf8_string)
        character(len=*), intent(in) :: external_string
        character(len=100) :: utf8_string
        integer :: i, n, c

        n = len_trim(external_string)
        utf8_string = ' '

        do i = 1, n
            !if (iachar(external_string(i:i), kind=int8) > 127) then
            c = iachar( external_string(i:i))
            if ( c > 127) then
                write(*,*) "Non-ASCII character detected at position ", i
                utf8_string(i:i) = char(iachar(external_string(i:i), kind=int8))
            else
                utf8_string(i:i) = external_string(i:i)
            end if
        end do

    end function encode_to_utf8

end module encoding_module
