#to be used by gid_cross_platform::run_as_administrator gid.exe -tclsh webclient_filesizelimit.tcl "webclient_set_filesizelimit 4294967295"
#(to do this action as administrator)

proc webclient_get_filesizelimit { } {
    package require registry
    set current_size_bytes ""
    set key {HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\WebClient\Parameters}
    set err [catch { set current_size_bytes [registry get $key FileSizeLimitInBytes] } msg]
    return $current_size_bytes
}

proc webclient_set_filesizelimit { {size_bytes 4294967295} } {
    package require registry
    set msg ""  
    set key {HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\WebClient\Parameters}
    set err [catch { registry set $key FileSizeLimitInBytes $size_bytes dword } msg]
    return $err
}

proc webclient_restart_service { } {
    package require twapi
    catch {twapi::stop_service WebClient} msg
    catch {twapi::start_service WebClient} msg
}

proc webclient_set_filesizelimit_and_restart_webclient { {size_bytes 4294967295} } {
    set filesizelimit_prev [webclient_get_filesizelimit]
    if { $size_bytes != $filesizelimit_prev } {
        webclient_set_filesizelimit $size_bytes
        if { [webclient_get_filesizelimit] != $filesizelimit_prev } {
            webclient_restart_service
        }
    }
}

if { [llength $::argv] == 1 } {
    set size_bytes [lindex $::argv 0]
    webclient_set_filesizelimit_and_restart_webclient $size_bytes
}
#foreach cmd $::argv {
#  eval $cmd
#}
