# default Macros file for GiD v1.0

#::list_imagenes_macros is list (ordered) of themed toolbar images that are created by default to be used in macros
#and redundantly saved inside user file 'gid_macros.tcl' to be compatible with old GiDs
#trick for back compatibility
#instead of the old printed Icon content
#{note.png imported_images}
#now they are added two more items: note.png themed_image, e.g.
#{note.png imported_images note.png themed_image}
#but in memory macrosdata(xx,Icon) only maintain two
#new themed GiDs use for its macros toolbar the last two items (and the themed image obtained at runtime from \themes GiD folder
#old unthemed GiDs will use the first two items (and the image saved in 'gid_macros.tcl')



#to avoid showing the bar with more that one column (will hide last icons if there is not space enought)
array set preferences {toolbar_one_col 1}

#********definition of default macros ****************

#[_ "Open a simple editor to save small notes with the model"]
set macrosdata(Notes,Active) 1
set macrosdata(Notes,Description) {Open a simple editor to save small notes with the model}
set macrosdata(Notes,Group) Tools
set macrosdata(Notes,PrePost) prepost
set macrosdata(Notes,Icon) {note.png themed_image}
set macrosdata(Notes,InToolbar) 1
set macrosdata(Notes,IsStandard) 1
set macrosdata(Notes,CreationDate) {2006-01-20 17:17:27}
set macrosdata(Notes,ModificationDate) {2011-11-04 11:03:51}
set macrosdata(Notes,Accelerators) {}

proc Notes {} {
    OpenNotes
}

#[_ "Resize Graphical Window"]
set {macrosdata(Resize Graphical Window,Accelerators)} {}
set {macrosdata(Resize Graphical Window,IsStandard)} 1
set {macrosdata(Resize Graphical Window,InToolbar)} 1
set {macrosdata(Resize Graphical Window,Active)} 1
set {macrosdata(Resize Graphical Window,PrePost)} prepost
set {macrosdata(Resize Graphical Window,Group)} View
set {macrosdata(Resize Graphical Window,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Resize Graphical Window,Description)} {Resize Graphical Window}
set {macrosdata(Resize Graphical Window,Icon)} {screen_resize.png themed_image}
set {macrosdata(Resize Graphical Window,CreationDate)} {2010-02-12 13:01:02}

proc {Resize Graphical Window} {} {
    lassign [ GidUtils::GetMainDrawAreaSize ] grWidth grHeight
    set value [MessageBoxEntry [_ "get new size"] [_ "Enter new size of the graphical window (format WIDTH or WIDTHxHEIGHT, for instance 500 or 800x600)"] \
        word ${grWidth}x${grHeight} 0 question.png]
    if { $value != ""} {
        if { [regexp {([0-9]*)x([0-9]*)} $value trozo newWidth newHeight] } {
            if { $grWidth != $newWidth || $grHeight != $newHeight } {
                GidUtils::SetMainDrawAreaSize $newWidth $newHeight
            }
        } elseif { [regexp {([0-9]*)} $value trozo newWidth] } {
            if { $grWidth != $newWidth } {
                set newHeight $grHeight
                GidUtils::SetMainDrawAreaSize $newWidth $newHeight
            }
        } else {
            WarnWin [_ "Can not read neither width nor height: %s" $value]
        }
    }
}

#[_ "Dimension angle beween three points"]
set {macrosdata(Dimension angle,CreationDate)} {2006-02-14 17:36:29}
set {macrosdata(Dimension angle,Description)} {Dimension angle beween three points}
set {macrosdata(Dimension angle,InToolbar)} 0
set {macrosdata(Dimension angle,Accelerators)} {}
set {macrosdata(Dimension angle,Group)} Dimension
set {macrosdata(Dimension angle,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Dimension angle,PrePost)} prepost
set {macrosdata(Dimension angle,IsStandard)} 1
set {macrosdata(Dimension angle,Icon)} {dimension_angle.png themed_image}
set {macrosdata(Dimension angle,Active)} 1

proc {Dimension angle} {} {
    GiD_Process escape escape escape escape Utilities Dimension Create Angle
}

#[_ "Dimension pointing to a vertex"]
set {macrosdata(Dimension vertex,Description)} {Dimension pointing to a vertex}
set {macrosdata(Dimension vertex,IsStandard)} 1
set {macrosdata(Dimension vertex,Group)} Dimension
set {macrosdata(Dimension vertex,PrePost)} prepost
set {macrosdata(Dimension vertex,InToolbar)} 0
set {macrosdata(Dimension vertex,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Dimension vertex,CreationDate)} {2006-02-14 17:51:53}
set {macrosdata(Dimension vertex,Icon)} {dimension_vertex.png themed_image}
set {macrosdata(Dimension vertex,Accelerators)} {}
set {macrosdata(Dimension vertex,Active)} 1

proc {Dimension vertex} {} {
    GiD_Process MEscape Utilities Dimension Create Vertex
}

#[_ "Dimension pointing to an arc center"]
set {macrosdata(Dimension arc,Accelerators)} {}
set {macrosdata(Dimension arc,Active)} 1
set {macrosdata(Dimension arc,Description)} {Dimension pointing to an arc center}
set {macrosdata(Dimension arc,IsStandard)} 1
set {macrosdata(Dimension arc,Group)} Dimension
set {macrosdata(Dimension arc,PrePost)} prepost
set {macrosdata(Dimension arc,InToolbar)} 0
set {macrosdata(Dimension arc,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Dimension arc,CreationDate)} {2006-02-14 21:00:15}
set {macrosdata(Dimension arc,Icon)} {dimension_arc.png themed_image}

proc {Dimension arc} {} {
    GiD_Process MEscape Utilities Dimension Create Arc
}

#[_ "Modify the dimension text"]
set {macrosdata(Dimension edit,Group)} Dimension
set {macrosdata(Dimension edit,PrePost)} prepost
set {macrosdata(Dimension edit,InToolbar)} 1
set {macrosdata(Dimension edit,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Dimension edit,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Dimension edit,Icon)} {dimension_edit.png themed_image}
set {macrosdata(Dimension edit,Accelerators)} {}
set {macrosdata(Dimension edit,Active)} 1
set {macrosdata(Dimension edit,Description)} {Modify the dimension text}
set {macrosdata(Dimension edit,IsStandard)} 1

proc {Dimension edit} {} {
    GiD_Process MEscape Utilities Dimension Edit
}

#[_ "Delete a dimension"]
set {macrosdata(Dimension delete,Active)} 1
set {macrosdata(Dimension delete,Description)} {Delete a dimension}
set {macrosdata(Dimension delete,Group)} Dimension
set {macrosdata(Dimension delete,PrePost)} prepost
set {macrosdata(Dimension delete,Icon)} {dimension_delete.png themed_image}
set {macrosdata(Dimension delete,InToolbar)} 0
set {macrosdata(Dimension delete,IsStandard)} 1
set {macrosdata(Dimension delete,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Dimension delete,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Dimension delete,Accelerators)} {}

proc {Dimension delete} {} {
    GiD_Process MEscape Utilities Dimension Delete
}
#[_ "Separate element in layers by its material"]
set macrosdata(CreateLayersFromElementMaterials,Active) 0
set macrosdata(CreateLayersFromElementMaterials,Description) {Separate element in layers by its material}
set macrosdata(CreateLayersFromElementMaterials,Group) Layers
set macrosdata(CreateLayersFromElementMaterials,PrePost) pre
set macrosdata(CreateLayersFromElementMaterials,Icon) {sendto.png themed_image}
set macrosdata(CreateLayersFromElementMaterials,InToolbar) 0
set macrosdata(CreateLayersFromElementMaterials,IsStandard) 1
set macrosdata(CreateLayersFromElementMaterials,CreationDate) {2012-12-14 22:39:32}
set macrosdata(CreateLayersFromElementMaterials,ModificationDate) {2012-12-14 22:44:00}
set macrosdata(CreateLayersFromElementMaterials,Accelerators) {}

proc CreateLayersFromElementMaterials {} {
    GidUtils::CreateLayersFromElementMaterials
}

#[_ "Average of Current result"]
set {macrosdata(Average of current result,Group)} {}
set {macrosdata(Average of current result,Accelerators)} {}
set {macrosdata(Average of current result,Description)} {Average of Current result}
set {macrosdata(Average of current result,ModificationDate)} {2017-05-30 10:09:37}
set {macrosdata(Average of current result,Icon)} {AverageResult.png themed_image}
set {macrosdata(Average of current result,Active)} 1
set {macrosdata(Average of current result,PrePost)} post
set {macrosdata(Average of current result,CreationDate)} {2017-05-30 10:08:04}
set {macrosdata(Average of current result,IsStandard)} 0
set {macrosdata(Average of current result,InToolbar)} 1

proc {Average of current result} {} {
    set curr_analysis [ GiD_Info postprocess get cur_analysis]
    set curr_step [ GiD_Info postprocess get cur_step $curr_analysis]
    set curr_view [ GiD_Info postprocess get cur_results_view]
    set curr_result [ GiD_Info postprocess get cur_result]
    if { $curr_result == ""} {
        WarnWin "Please select a result to visualize."
    } else {

        foreach type [ list volumesets surfacesets cutsets] {
            foreach current_set [  GiD_Info postprocess get cur_$type] {
                set result_set [ GiD_Result get -sets [ list $current_set] [ list $curr_result $curr_analysis $curr_step]]
                set component_names [ lindex $result_set 2]
                # values start at index 3
                set len [ llength $result_set]
                # put it in an array for the case when several meshes share vertices, to count their results only once
                for { set idx 3} { $idx < $len} { incr idx} {
                    set entry [ lindex $result_set $idx]
                    set idx_node [ lindex $entry 0]
                    set res_value [ lindex $entry 1]
                    set array_values($idx_node) $res_value
                }
            }
        }

        # Now do the average:
        set max_comp 30
        for { set idx_comp 0} { $idx_comp < $max_comp} { incr idx_comp} {
            set accum($idx_comp) 0
        }

        set num_results 0
        foreach [ list idx_node res_value] [ array get array_values] {
            set num_comp 0
            foreach component $res_value {
                set accum($num_comp) [ expr $accum($num_comp) + $component]
                incr num_comp
            }
            incr num_results
        }

        if { $num_comp == 9} {
            lappend component_names Si Sii Siii
        }

        # do and print averages:
        set msg [ list "Average of $curr_result:"]
        for { set idx_comp 0} { $idx_comp < $num_comp} { incr idx_comp} {
            lappend msg "   [ lindex $component_names [ expr $idx_comp + 1]] = [ expr $accum($idx_comp) / $num_results]"
        }
        InfoWin [ join $msg \n] .gid
    }
}

#[_ "Separate each volume in a different layer"]
set macrosdata(SeparateTopGeometryInLayers,Active) 1
set macrosdata(SeparateTopGeometryInLayers,Description) {Separate each top geometric figure in a different layer}
set macrosdata(SeparateTopGeometryInLayers,Group) Layers
set macrosdata(SeparateTopGeometryInLayers,PrePost) pre
set macrosdata(SeparateTopGeometryInLayers,Icon) {sendto.png themed_image}
set macrosdata(SeparateTopGeometryInLayers,InToolbar) 1
set macrosdata(SeparateTopGeometryInLayers,IsStandard) 1
set macrosdata(SeparateTopGeometryInLayers,CreationDate) {2017-02-27 15:50:00}
set macrosdata(SeparateTopGeometryInLayers,ModificationDate) {2017-02-27 15:50:00}
set macrosdata(SeparateTopGeometryInLayers,Accelerators) {}

proc SeparateTopGeometryInLayers {} {
    GidUtils::SeparateTopGeometryInLayers
}


#[_ "Import a selection of multiple IGES files and send then to layers named with file names."]
set macrosdata(IgesFilesToLayers,Active) 1
set macrosdata(IgesFilesToLayers,Description) {Import a selection of multiple IGES files and send then to layers named with file names.}
set macrosdata(IgesFilesToLayers,Group) {Geometry Creation}
set macrosdata(IgesFilesToLayers,PrePost) pre
set macrosdata(IgesFilesToLayers,Icon) {folder.png themed_image}
set macrosdata(IgesFilesToLayers,InToolbar) 1
set macrosdata(IgesFilesToLayers,IsStandard) 1
set macrosdata(IgesFilesToLayers,CreationDate) {2013-01-23 12:17:04}
set macrosdata(IgesFilesToLayers,ModificationDate) {2013-01-23 12:36:33}
set macrosdata(IgesFilesToLayers,Accelerators) {}

proc IgesFilesToLayers {} {
    proc _IgesFilesToLayers { } {
        set multiple 1
        set filenames [MessageBoxGetFilename file read [_ "Read IGES files"] \
            {} {{{IGES} {.igs }} {{All files} {.*}}} {} $multiple \
            ""]
        if { $filenames != "" } {
            GidUtils::WaitState
            GidUtils::DisableGraphics
            set old_value_IGES_CreateAllInLayerToUse [GiD_Set IGES(CreateAllInLayerToUse)]
            GiD_Set IGES(CreateAllInLayerToUse) 1
            set auto_collapse [GiD_Set AutoCollapseAfterImport]
            if { $auto_collapse } {
                GiD_Set AutoCollapseAfterImport 0 ;#temporary disable it to do the collapse only once
                set old_value_CollapseIgnoringLayers [GiD_Set CollapseIgnoringLayers]
                GiD_Set CollapseIgnoringLayers 0 ;#to not join entities of different files
            }
            foreach filename $filenames {
                set layername [file tail $filename]
                if { [lsearch [GiD_Info layers] $layername] == -1 } {
                    GiD_Process 'Layers New $layername
                } else {
                    GiD_Process 'Layers ToUse $layername
                }
                GiD_Process Mescape Files IgesRead $filename
            }
            GiD_Process 'Layers Delete Layer0 ;#delete this layer if empty
            if { $auto_collapse } {
                GiD_Process Mescape Utilities Collapse Model Yes
                GiD_Set CollapseIgnoringLayers $old_value_CollapseIgnoringLayers
            }
            GiD_Set IGES(CreateAllInLayerToUse) $old_value_IGES_CreateAllInLayerToUse
            GidUtils::EnableGraphics
            GidUtils::EndWaitState
            Layers::FillInfo
            GiD_Process 'Zoom Frame
            GidUtils::SetWarnLine [_ "Read %s files" [llength $filenames]]
        }
        return 0
    }

    _IgesFilesToLayers
}

#[_ "Import a selection of multiple OBJ files and send then to the current working layer."]
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,Active) 1
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,Description) {Import a selection of multiple Wavefront Object files and send then to the current working layer.}
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,Group) {Mesh Creation}
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,PrePost) pre
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,Icon) {folder.png themed_image}
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,InToolbar) 0
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,IsStandard) 1
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,CreationDate) {2013-01-23 12:17:04}
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,ModificationDate) {2013-01-23 12:36:33}
set macrosdata(MultipleWavefrontObjectsToCurrentLayer,Accelerators) {}

proc MultipleWavefrontObjectsToCurrentLayer {} {
    proc _MultipleWavefrontObjectsToCurrentLayer { } {
        set multiple 1
        set filenames [MessageBoxGetFilename file read [_ "Read OBJ files"] \
            {} {{{Wavefront Object mesh files} {.obj }} {{All files} {.*}}} {} $multiple \
            ""]
        if { $filenames != "" } {
            set num_files [ llength $filenames]
            if { $num_files > 10} {
                set resp [MessageBoxOptionsButtons [_ "Confirm"] \
                    [_ "%d Wavefront Object files are to be imported. Continue ?" $num_files] \
                    {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
                if { $resp == 1} {
                    set resp "no"
                }
                if { [ string equal $resp "no"]} {
                    return
                }
            }
            GidUtils::WaitState
            GidUtils::DisableGraphics
            set auto_collapse [GiD_Set AutoCollapseAfterImport]
            if { $auto_collapse } {
                GiD_Set AutoCollapseAfterImport 0 ;#temporary disable it to do the collapse only once
                set old_value_CollapseIgnoringLayers [GiD_Set CollapseIgnoringLayers]
                GiD_Set CollapseIgnoringLayers 0 ;#to not join entities of different files
            }
            # add collapsing
            set end_progress [ expr $num_files + 1]
            # GidUtils::EnableGraphics
            PostProgressBar 0 $end_progress [_ "Importing %d Wavefront Object files" $num_files] \
                [_ "Importing %d Wavefront Object files" $num_files]
            # update idletasks
            # GidUtils::DisableGraphics
            set idx_files 0
            foreach filename $filenames {
                # set layername [file tail $filename]
                # if { [lsearch [GiD_Info layers] $layername] == -1 } {
                #     GiD_Process 'Layers New $layername
                # } else {
                #     GiD_Process 'Layers ToUse $layername
                # }
                GiD_Process Mescape Files OBJRead $filename
                incr idx_files
                # GidUtils::EnableGraphics
                PostProgressBar $idx_files $end_progress [_ "Imported %d of %d Wavefront Objects" $idx_files $num_files]
                # update idletasks
                # GidUtils::DisableGraphics
            }
            # GiD_Process 'Layers Delete Layer0 ;#delete this layer if empty
            if { $auto_collapse } {
                # GidUtils::EnableGraphics
                PostProgressBar $num_files $end_progress [_ "Collapsing imported objects"]
                # update idletasks
                # GidUtils::DisableGraphics
                GiD_Process Mescape Utilities Collapse Model Yes
                GiD_Set AutoCollapseAfterImport $auto_collapse
                GiD_Set CollapseIgnoringLayers $old_value_CollapseIgnoringLayers
            }
            PostProgressBar $end_progress $end_progress
            GidUtils::EnableGraphics
            GidUtils::EndWaitState
            Layers::FillInfo
            MeshView 0
            GiD_Process 'Zoom Frame
            GidUtils::SetWarnLine [_ "Read %s Wavefront OBJect files" [llength $filenames]]
        }
        return 0
    }

    _MultipleWavefrontObjectsToCurrentLayer
}

#[_ "Send entities to the back (hidden) part of a layer"]
set {macrosdata(Send to back,Group)} Layers
set {macrosdata(Send to back,Icon)} {send_to_back.png themed_image}
set {macrosdata(Send to back,Description)} {Send entities to the back (hidden) part of a layer}
set {macrosdata(Send to back,PrePost)} pre
set {macrosdata(Send to back,Active)} 1
set {macrosdata(Send to back,InToolbar)} 0
set {macrosdata(Send to back,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Send to back,Accelerators)} Ctrl-F1
set {macrosdata(Send to back,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Send to back,IsStandard)} 1

proc {Send to back} {} {
    GiD_Process 'Layers SendToBack LowerEntities Surfaces
}

#[_ "Send unselected entities to the back (hidden) part of a layer"]
set {macrosdata(Send to back (Opposite),Icon)} {send_to_back_opposite.png themed_image}
set {macrosdata(Send to back (Opposite),Active)} 1
set {macrosdata(Send to back (Opposite),IsStandard)} 1
set {macrosdata(Send to back (Opposite),ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Send to back (Opposite),InToolbar)} 0
set {macrosdata(Send to back (Opposite),PrePost)} pre
set {macrosdata(Send to back (Opposite),Group)} Layers
set {macrosdata(Send to back (Opposite),CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Send to back (Opposite),Accelerators)} Ctrl-F2
set {macrosdata(Send to back (Opposite),Description)} {Send unselected entities to the back (hidden) part of a layer}

proc {Send to back (Opposite)} {} {
    GiD_Process 'Layers SendToBackOpposite LowerEntities Surfaces
}

#[_ "Send to the visible front part entities in back layers"]
set {macrosdata(Bring to front,Group)} Layers
set {macrosdata(Bring to front,IsStandard)} 1
set {macrosdata(Bring to front,CreationDate)} {2004-11-30 18:57:31}
set {macrosdata(Bring to front,Accelerators)} {}
set {macrosdata(Bring to front,InToolbar)} 0
set {macrosdata(Bring to front,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Bring to front,Active)} 1
set {macrosdata(Bring to front,Description)} {Send to the visible front part entities in back layers}
set {macrosdata(Bring to front,PrePost)} pre
set {macrosdata(Bring to front,Icon)} {bring_to_front.png themed_image}

proc {Bring to front} {} {
    GiD_Process 'Layers BringToFrontAll Escape
}

#[_ "Send to back"]
set {macrosdata(Send to back E,Group)} Layers
set {macrosdata(Send to back E,Active)} 0
set {macrosdata(Send to back E,CreationDate)} {2004-11-30 20:20:29}
set {macrosdata(Send to back E,Accelerators)} Ctrl-F1
set {macrosdata(Send to back E,InToolbar)} 0
set {macrosdata(Send to back E,Icon)} {send_to_back.png themed_image}
set {macrosdata(Send to back E,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Send to back E,IsStandard)} 1
set {macrosdata(Send to back E,PrePost)} post
set {macrosdata(Send to back E,Description)} {Send to back}

proc {Send to back E} {} {
    set ::GidPriv(LayersBackOpposite) 0
    PDSendToBack ""  Elements
}

#[_ "Send to back (Opposite)"]
set {macrosdata(Send to back E (opposite),Description)} {Send to back (Opposite)}
set {macrosdata(Send to back E (opposite),ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Send to back E (opposite),Group)} Layers
set {macrosdata(Send to back E (opposite),PrePost)} post
set {macrosdata(Send to back E (opposite),InToolbar)} 0
set {macrosdata(Send to back E (opposite),Active)} 0
set {macrosdata(Send to back E (opposite),CreationDate)} {2004-11-30 20:24:54}
set {macrosdata(Send to back E (opposite),IsStandard)} 1
set {macrosdata(Send to back E (opposite),Accelerators)} Ctrl-F2
set {macrosdata(Send to back E (opposite),Icon)} {send_to_back_opposite.png themed_image}

proc {Send to back E (opposite)} {} {
    set ::GidPriv(LayersBackOpposite) 1
    PDSendToBack ""  Elements
}

#[_ "Bring to front"]
set {macrosdata(Bring to front E,InToolbar)} 0
set {macrosdata(Bring to front E,IsStandard)} 1
set {macrosdata(Bring to front E,Group)} Layers
set {macrosdata(Bring to front E,CreationDate)} {2004-11-30 20:21:40}
set {macrosdata(Bring to front E,Accelerators)} {}
set {macrosdata(Bring to front E,PrePost)} post
set {macrosdata(Bring to front E,Active)} 0
set {macrosdata(Bring to front E,Icon)} {bring_to_front.png themed_image}
set {macrosdata(Bring to front E,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Bring to front E,Description)} {Bring to front}

proc {Bring to front E} {} {
    PDSendToBack "" AllToFront
}

#[_ "Create a trimmed surface from a base surface and a new boundary"]
set {macrosdata(Trimmed surface,PrePost)} pre
set {macrosdata(Trimmed surface,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Trimmed surface,Description)} {Create a trimmed surface from a base surface and a new boundary}
set {macrosdata(Trimmed surface,Accelerators)} {}
set {macrosdata(Trimmed surface,Group)} {Geometry Creation}
set {macrosdata(Trimmed surface,Icon)} {surface_trim.png themed_image}
set {macrosdata(Trimmed surface,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Trimmed surface,IsStandard)} 1
set {macrosdata(Trimmed surface,InToolbar)} 1
set {macrosdata(Trimmed surface,Active)} 1

proc {Trimmed surface} {} {
    GiD_Process MEscape Geometry Create TrimmedNurb
}

#[_ "Create a hole in a surface from a line's loop "]
set {macrosdata(Hole surface,Icon)} {surface_hole.png themed_image}
set {macrosdata(Hole surface,Description)} {Create a hole in a surface from a line's loop }
set {macrosdata(Hole surface,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Hole surface,PrePost)} pre
set {macrosdata(Hole surface,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Hole surface,Active)} 1
set {macrosdata(Hole surface,Accelerators)} {}
set {macrosdata(Hole surface,Group)} {Geometry Edit}
set {macrosdata(Hole surface,IsStandard)} 1
set {macrosdata(Hole surface,InToolbar)} 1

proc {Hole surface} {} {
    GiD_Process MEscape Geometry Edit HoleNurb
}

#[_ "Create a new surface from a family of parallel lines"]
set {macrosdata(Surfaces from parallel lines,Active)} 1
set {macrosdata(Surfaces from parallel lines,PrePost)} pre
set {macrosdata(Surfaces from parallel lines,Description)} {Create a new surface from a family of parallel lines}
set {macrosdata(Surfaces from parallel lines,InToolbar)} 1
set {macrosdata(Surfaces from parallel lines,CreationDate)} {2006-02-14 21:44:20}
set {macrosdata(Surfaces from parallel lines,Icon)} {surface_parallel_lines.png themed_image}
set {macrosdata(Surfaces from parallel lines,Accelerators)} {}
set {macrosdata(Surfaces from parallel lines,IsStandard)} 1
set {macrosdata(Surfaces from parallel lines,Group)} {Geometry Creation}
set {macrosdata(Surfaces from parallel lines,ModificationDate)} {2011-11-04 11:03:51}

proc {Surfaces from parallel lines} {} {
    GiD_Process MEscape Geometry Create NurbsSurface ParallelLines
}

#[_ "Move a point (Warning: surfaces can't support big deformation)"]
set {macrosdata(move point,Group)} {Geometry Edit}
set {macrosdata(move point,IsStandard)} 1
set {macrosdata(move point,InToolbar)} 1
set {macrosdata(move point,Icon)} {point_move.png themed_image}
set {macrosdata(move point,Description)} {Move a point (Warning: surfaces can't support big deformation)}
set {macrosdata(move point,CreationDate)} {2006-02-14 22:13:38}
set {macrosdata(move point,PrePost)} pre
set {macrosdata(move point,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(move point,Active)} 1
set {macrosdata(move point,Accelerators)} {}

proc {move point} {} {
    GiD_Process MEscape Geometry Edit MovePoint
}

#[_ "Divide a line in a number of divisions"]
set {macrosdata(Divide line num divisions,Description)} {Divide a line in a number of divisions}
set {macrosdata(Divide line num divisions,InToolbar)} 1
set {macrosdata(Divide line num divisions,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Divide line num divisions,IsStandard)} 1
set {macrosdata(Divide line num divisions,Group)} {Geometry Edit}
set {macrosdata(Divide line num divisions,Icon)} {line_divide_nparts.png themed_image}
set {macrosdata(Divide line num divisions,Active)} 1
set {macrosdata(Divide line num divisions,CreationDate)} {2006-02-14 22:32:48}
set {macrosdata(Divide line num divisions,Accelerators)} {}
set {macrosdata(Divide line num divisions,PrePost)} pre

proc {Divide line num divisions} {} {
    GiD_Process MEscape Geometry Edit DivideLine Multiple NumDivisions
}

#[_ "Divide a line near a point"]
set {macrosdata(Divide line near point,IsStandard)} 1
set {macrosdata(Divide line near point,Group)} {Geometry Edit}
set {macrosdata(Divide line near point,Icon)} {line_divide_nearpoint.png themed_image}
set {macrosdata(Divide line near point,Active)} 1
set {macrosdata(Divide line near point,CreationDate)} {2006-02-14 22:22:00}
set {macrosdata(Divide line near point,Accelerators)} {}
set {macrosdata(Divide line near point,PrePost)} pre
set {macrosdata(Divide line near point,Description)} {Divide a line near a point}
set {macrosdata(Divide line near point,InToolbar)} 1
set {macrosdata(Divide line near point,ModificationDate)} {2011-11-04 11:03:51}

proc {Divide line near point} {} {
    GiD_Process MEscape Geometry Edit DivideLine Multiple Point PointInLine
}

#[_ " geometry create IntersectLines"]
set {macrosdata(Intersect lines,PrePost)} pre
set {macrosdata(Intersect lines,Active)} 1
set {macrosdata(Intersect lines,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Intersect lines,Group)} {Geometry Edit}
set {macrosdata(Intersect lines,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Intersect lines,IsStandard)} 1
set {macrosdata(Intersect lines,Icon)} {intersect_lines.png themed_image}
set {macrosdata(Intersect lines,Accelerators)} {}
set {macrosdata(Intersect lines,InToolbar)} 1
set {macrosdata(Intersect lines,Description)} { geometry create IntersectLines}

proc {Intersect lines} {} {
    GiD_Process Mescape Geometry Create IntMultLines
}

#[_ " geometry create IntersectLines NoDivideLines "]
set {macrosdata(Intersect lines (no divide),IsStandard)} 1
set {macrosdata(Intersect lines (no divide),Accelerators)} {}
set {macrosdata(Intersect lines (no divide),Icon)} {intersect_lines_nodivide.png themed_image}
set {macrosdata(Intersect lines (no divide),Description)} { geometry create IntersectLines NoDivideLines }
set {macrosdata(Intersect lines (no divide),ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Intersect lines (no divide),Group)} {Geometry Edit}
set {macrosdata(Intersect lines (no divide),PrePost)} pre
set {macrosdata(Intersect lines (no divide),InToolbar)} 0
set {macrosdata(Intersect lines (no divide),Active)} 1
set {macrosdata(Intersect lines (no divide),CreationDate)} {2004-11-18 21:53:33}

proc {Intersect lines (no divide)} {} {
    GiD_Process MEscape Geometry Create IntersectLines NoDivideLines
}

#[_ "Divide a surface in n parts in u or v direction"]
set {macrosdata(Divide surface,Icon)} {surface_divide_nparts.png themed_image}
set {macrosdata(Divide surface,InToolbar)} 1
set {macrosdata(Divide surface,IsStandard)} 1
set {macrosdata(Divide surface,Description)} {Divide a surface in n parts in u or v direction}
set {macrosdata(Divide surface,PrePost)} pre
set {macrosdata(Divide surface,CreationDate)} {2006-02-15 23:30:30}
set {macrosdata(Divide surface,Accelerators)} {}
set {macrosdata(Divide surface,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Divide surface,Group)} {Geometry Edit}
set {macrosdata(Divide surface,Active)} 1

proc {Divide surface} {} {
    if { [GidUtils::VersionCmp 13.1.5d] >= 0 } {
        DoDivideSurfaceNumDivisions
    } else {
        #back compatibility, Macros are shared by all versions
        GiD_Process MEscape Geometry Edit DivideSurf NumDivisions
    }
}

#[_ "Split a surface from a path of lines"]
set {macrosdata(Split surface,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Split surface,PrePost)} pre
set {macrosdata(Split surface,IsStandard)} 1
set {macrosdata(Split surface,Icon)} {surface_divide_split.png themed_image}
set {macrosdata(Split surface,Active)} 1
set {macrosdata(Split surface,CreationDate)} {2006-02-15 23:19:26}
set {macrosdata(Split surface,Description)} {Split a surface from a path of lines}
set {macrosdata(Split surface,InToolbar)} 1
set {macrosdata(Split surface,Accelerators)} {}
set {macrosdata(Split surface,Group)} {Geometry Edit}

proc {Split surface} {} {
    GiD_Process MEscape Geometry Edit SplitSurf
}

#[_ "Intersect a surface with lines"]
set {macrosdata(Intersect surface lines,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Intersect surface lines,PrePost)} pre
set {macrosdata(Intersect surface lines,IsStandard)} 1
set {macrosdata(Intersect surface lines,Icon)} {intersect_line_surface.png themed_image}
set {macrosdata(Intersect surface lines,Active)} 1
set {macrosdata(Intersect surface lines,CreationDate)} {2006-02-16 13:39:46}
set {macrosdata(Intersect surface lines,Description)} {Intersect a surface with lines}
set {macrosdata(Intersect surface lines,InToolbar)} 1
set {macrosdata(Intersect surface lines,Accelerators)} {}
set {macrosdata(Intersect surface lines,Group)} {Geometry Edit}

proc {Intersect surface lines} {} {
    GiD_Process MEscape Geometry Create IntSurfLine
}

#[_ "Intersect multiple surfaces"]
set {macrosdata(Intersect surfaces,Description)} {Intersect multiple surfaces}
set {macrosdata(Intersect surfaces,Icon)} {intersect_surfaces.png themed_image}
set {macrosdata(Intersect surfaces,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Intersect surfaces,Accelerators)} {}
set {macrosdata(Intersect surfaces,IsStandard)} 1
set {macrosdata(Intersect surfaces,InToolbar)} 1
set {macrosdata(Intersect surfaces,Active)} 1
set {macrosdata(Intersect surfaces,PrePost)} pre
set {macrosdata(Intersect surfaces,Group)} {Geometry Edit}
set {macrosdata(Intersect surfaces,ModificationDate)} {2011-11-04 11:03:51}

proc {Intersect surfaces} {} {
    GiD_Process MEscape Geometry Create IntMultSurfs
}

#[_ "Creates a construction horizontal line in a temporal layer, containing one point defined by the user.\n    Length of the line depends on current geometry size"]
set {macrosdata(Construction line horizontal,Active)} 1
set {macrosdata(Construction line horizontal,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Construction line horizontal,Accelerators)} {}
set {macrosdata(Construction line horizontal,PrePost)} pre
set {macrosdata(Construction line horizontal,Description)} {Creates a construction horizontal line in a temporal layer, containing one point defined by the user.
Length of the line depends on current geometry size}
set {macrosdata(Construction line horizontal,InToolbar)} 0
set {macrosdata(Construction line horizontal,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Construction line horizontal,IsStandard)} 1
set {macrosdata(Construction line horizontal,Group)} {Constr. line}
set {macrosdata(Construction line horizontal,Icon)} {border_horizontal.png themed_image}

proc {Construction line horizontal} {} {
    set layers [GiD_Info Layers]
    set ipos [lsearch -exact $layers *construction_lines*]
    if { $ipos == -1 } {
        GiD_Process 'Layers New *construction_lines* escape
        GiD_Process 'Layers Color *construction_lines* 255255000 escape
    } else {
        set layers [lreplace $layers $ipos $ipos]
    }
    set current_layer [GiD_Info Project LayerToUse]
    GiD_Process 'Layers ToUse *construction_lines* escape
    set bbox [GiD_Info layers -bbox {*}$layers]
    set max_size [expr {60*[CEGiveSizeFromBBox $bbox]}]
    set p [GidUtils::GetCoordinates "Enter point for H line"]
    if { $p != "" } {
        set p1 [MathUtils::VectorSum $p [list [expr -0.5*$max_size] 0 0]]
        set p2 [MathUtils::VectorSum $p [list [expr 0.5*$max_size] 0 0]]
        GiD_Process MEscape Geometry Create Line FNoJoin [join $p1 ,] [join $p2 ,] escape escape
    }
    GiD_Process 'Layers ToUse $current_layer escape
}

#[_ "Creates a construction vertical line in a temporal layer, containing one point defined by the user.\n    Length of the line depends on current geometry size"]
set {macrosdata(Construction line vertical,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Construction line vertical,Accelerators)} {}
set {macrosdata(Construction line vertical,IsStandard)} 1
set {macrosdata(Construction line vertical,InToolbar)} 0
set {macrosdata(Construction line vertical,Active)} 1
set {macrosdata(Construction line vertical,PrePost)} pre
set {macrosdata(Construction line vertical,Group)} {Constr. line}
set {macrosdata(Construction line vertical,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Construction line vertical,Description)} {Creates a construction vertical line in a temporal layer, containing one point defined by the user.
Length of the line depends on current geometry size}
set {macrosdata(Construction line vertical,Icon)} {border_vertical.png themed_image}

proc {Construction line vertical} {} {
    set layers [GiD_Info Layers]
    set ipos [lsearch -exact $layers *construction_lines*]
    if { $ipos == -1 } {
        GiD_Process 'Layers New *construction_lines* escape
        GiD_Process 'Layers Color *construction_lines* 255255000 escape
    } else {
        set layers [lreplace $layers $ipos $ipos]
    }
    set current_layer [GiD_Info Project LayerToUse]
    GiD_Process 'Layers ToUse *construction_lines* escape
    set bbox [GiD_Info layers -bbox {*}$layers]
    set max_size [expr {60*[CEGiveSizeFromBBox $bbox]}]
    set p [GidUtils::GetCoordinates "Enter point for V line"]
    if { $p != "" } {
        set p1 [MathUtils::VectorSum $p [list 0 [expr -0.5*$max_size] 0]]
        set p2 [MathUtils::VectorSum $p [list 0 [expr 0.5*$max_size] 0]]
        GiD_Process MEscape Geometry Create Line FNoJoin [join $p1 ,] [join $p2 ,] escape escape
    }
    GiD_Process 'Layers ToUse $current_layer escape
}

#[_ "Split all triangles with edge size greater than an user size"]
set {macrosdata(Split Big Triangles,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Split Big Triangles,Description)} {Split all triangles with edge size greater than an user size}
set {macrosdata(Split Big Triangles,Active)} 1
set {macrosdata(Split Big Triangles,CreationDate)} {2006-01-31 12:53:02}
set {macrosdata(Split Big Triangles,IsStandard)} 1
set {macrosdata(Split Big Triangles,Accelerators)} {}
set {macrosdata(Split Big Triangles,Icon)} {split_elements.png themed_image}
set {macrosdata(Split Big Triangles,PrePost)} pre
set {macrosdata(Split Big Triangles,Group)} {Mesh Edit}
set {macrosdata(Split Big Triangles,InToolbar)} 0

proc {Split Big Triangles} {} {
    proc SplitTrianglesEdgeMaxSize { size } {
        if { $size <= 0 } return
        GiD_Process escape escape escape escape Meshing EditMesh SplitElems TriaToTria
        GiD_Process Filter:MAXLENGTH=[string trim $size]
        GiD_Process 1:
        GiD_Process MEscape Meshing EditMesh Smoothing
        GiD_Process 1:
        GiD_Process MEscape
    }
    proc SplitTrianglesEdgeMaxSizeW { } {
        if { ![info exists ::MaxEdgeSize] } {
            set ::MaxEdgeSize 1.0
        }
        set size [MessageBoxEntry [_ "Split triangles"] [_ "Enter edge size"] real+ $::MaxEdgeSize 0 question.png]
        if { $size == "" } {
            return 1
        } else {
            set ::MaxEdgeSize $size
            SplitTrianglesEdgeMaxSize $size
        }
    }
    SplitTrianglesEdgeMaxSizeW
}

#[_ "Collapse all triangles with edge size smaller than an user size"]
set {macrosdata(Collapse Small Triangles,InToolbar)} 0
set {macrosdata(Collapse Small Triangles,Accelerators)} {}
set {macrosdata(Collapse Small Triangles,Group)} {Mesh Edit}
set {macrosdata(Collapse Small Triangles,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Collapse Small Triangles,PrePost)} pre
set {macrosdata(Collapse Small Triangles,IsStandard)} 1
set {macrosdata(Collapse Small Triangles,Icon)} {collapse_edges.png themed_image}
set {macrosdata(Collapse Small Triangles,Active)} 1
set {macrosdata(Collapse Small Triangles,CreationDate)} {2006-01-31 15:41:36}
set {macrosdata(Collapse Small Triangles,Description)} {Collapse all triangles with edge size smaller than an user size}

proc {Collapse Small Triangles} {} {
    proc CollapseTrianglesEdgeMinSize { size } {
        if { $size <= 0 } return
        GiD_Process escape escape escape escape Utilities Collapse Edges
        GiD_Process Tolerance [string trim $size]
        GiD_Process 1:
        GiD_Process MEscape Meshing EditMesh Smoothing
        GiD_Process 1:
        GiD_Process MEscape
    }
    proc CollapseTrianglesEdgeMinSizeW { } {
        if { ![info exists ::MinEdgeSize] } {
            set ::MinEdgeSize 1.0
        }
        set size [MessageBoxEntry [_ "Edge size"] [_ "Enter edge size"] real+ $::MinEdgeSize 0 question.png]
        if { $size == "" } {
            return 1
        } else {
            set ::MinEdgeSize $size
            CollapseTrianglesEdgeMinSize $size
        }
    }
    CollapseTrianglesEdgeMinSizeW
}

#[_ "Align the quadratic nodes to the mid edges"]
set {macrosdata(Align Quadratic Nodes,Description)} {Align the quadratic nodes to the mid edges}
set {macrosdata(Align Quadratic Nodes,Icon)} {align_quadratic_nodes.png themed_image}
set {macrosdata(Align Quadratic Nodes,Active)} 1
set {macrosdata(Align Quadratic Nodes,IsStandard)} 1
set {macrosdata(Align Quadratic Nodes,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Align Quadratic Nodes,InToolbar)} 0
set {macrosdata(Align Quadratic Nodes,PrePost)} pre
set {macrosdata(Align Quadratic Nodes,Group)} {Mesh Edit}
set {macrosdata(Align Quadratic Nodes,CreationDate)} {2007-05-03 21:01:46}
set {macrosdata(Align Quadratic Nodes,Accelerators)} {}

proc {Align Quadratic Nodes} {} {
    proc CenterQuadraticNodes { } {
        set isquadratic [GiD_Set Model(QuadraticType)]
        if { !$isquadratic } {
            return 1
        }
        ::GidUtils::WaitState
        set t0 [clock seconds]
        foreach elemtype [lrange [GiD_Info mesh] 1 end] {
            set elems [GiD_Info mesh elements $elemtype]
            if { $elemtype == "Linear" } {
                foreach {num na nb ni mat} $elems {
                    set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                    set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                    set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                    GiD_Mesh edit node $ni $pi
                }
            } elseif { $elemtype == "Triangle" } {
                foreach {num n0 n1 n2 n3 n4 n5 mat} $elems {
                    foreach ni [list $n3 $n4 $n5] na [list $n0 $n1 $n2] nb [list $n1 $n2 $n0] {
                        set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                        set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                        set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                        GiD_Mesh edit node $ni $pi
                    }
                }
            } elseif { $elemtype == "Quadrilateral" } {
                if { $isquadratic == 1 } {
                    foreach {num n0 n1 n2 n3 n4 n5 n6 n7 mat} $elems {
                        foreach ni [list $n4 $n5 $n6 $n7] na [list $n0 $n1 $n2 $n3] nb [list $n1 $n2 $n3 $n0] {
                            set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                            set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                            set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                            GiD_Mesh edit node $ni $pi
                        }
                    }
                } else {
                    foreach {num n0 n1 n2 n3 n4 n5 n6 n7 n8 mat} $elems {
                        foreach ni [list $n4 $n5 $n6 $n7] na [list $n0 $n1 $n2 $n3] nb [list $n1 $n2 $n3 $n0] {
                            set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                            set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                            set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                            GiD_Mesh edit node $ni $pi
                        }
                        set pi [lindex [GiD_Info Coordinates $n0 mesh] 0]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n1 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n2 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n3 mesh] 0]]
                        set pi [MathUtils::ScalarByVectorProd 0.25 $pi]
                        GiD_Mesh edit node $n8 $pi
                    }
                }
            } elseif { $elemtype == "Tetrahedra" } {
                foreach {num n1 n2 n3 n4 n5 n6 n7 n8 n9 n10 mat} $elems {
                    foreach ni [list $n5 $n6 $n7 $n8 $n9 $n10]  na [list $n1 $n2 $n1 $n1 $n2 $n3]  nb [list $n2 $n3 $n3 $n4 $n4 $n4] {
                        set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                        set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                        set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                        GiD_Mesh edit node $ni $pi
                    }
                }
            } elseif { $elemtype == "Hexahedra" } {
                if { $isquadratic == 1 } {
                    foreach {num n1 n2 n3 n4 n5 n6 n7 n8 n9 n10 n11 n12 n13 n14 n15 n16 n17 n18 n19 n20 mat} $elems {
                        foreach ni [list $n9 $n10 $n11 $n12 $n13 $n14 $n15 $n16 $n17 $n18 $n19 $n20]  na [list $n1 $n2  $n3  $n1  $n1  $n2  $n3  $n4  $n5  $n6  $n7  $n5 ]  nb [list $n2 $n3  $n4  $n4  $n5  $n6  $n7  $n8  $n6  $n7  $n8  $n8 ] {
                            set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                            set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                            set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                            GiD_Mesh edit node $ni $pi
                        }
                    }
                } else {
                    foreach {num n1 n2 n3 n4 n5 n6 n7 n8 n9 n10 n11 n12 n13 n14 n15 n16 n17 n18 n19 n20  n21 n22 n23 n24 n25 n26 n27 mat} $elems {
                        foreach ni [list $n9 $n10 $n11 $n12 $n13 $n14 $n15 $n16 $n17 $n18 $n19 $n20]  na [list $n1 $n2  $n3  $n1  $n1  $n2  $n3  $n4  $n5  $n6  $n7  $n5 ]  nb [list $n2 $n3  $n4  $n4  $n5  $n6  $n7  $n8  $n6  $n7  $n8  $n8 ] {
                            set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                            set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                            set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                            GiD_Mesh edit node $ni $pi
                        }
                        foreach ni [list $n21 $n22 $n23 $n24 $n25 $n26]  na [list $n1  $n1  $n2  $n3  $n1  $n5 ]  nb [list $n2  $n2  $n3  $n7  $n4  $n6 ]  nc [list $n3  $n6  $n7  $n8  $n8  $n7 ]  nd [list $n4  $n5  $n6  $n4  $n5  $n8 ] {
                            set pi [lindex [GiD_Info Coordinates $na mesh] 0]
                            set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $nb mesh] 0]]
                            set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $nc mesh] 0]]
                            set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $nd mesh] 0]]
                            set pi [MathUtils::ScalarByVectorProd 0.25 $pi]
                            GiD_Mesh edit node $ni $pi
                        }
                        set pi [lindex [GiD_Info Coordinates $n1 mesh] 0]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n2 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n3 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n4 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n5 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n6 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n7 mesh] 0]]
                        set pi [MathUtils::VectorSum $pi [lindex [GiD_Info Coordinates $n8 mesh] 0]]
                        set pi [MathUtils::ScalarByVectorProd 0.125 $pi]
                    }
                }
            } elseif { $elemtype == "Tetrahedra" } {
                foreach {num n1 n2 n3 n4 n5 n6 n7 n8 n9 n10 n11 n12 n13 n14 n15 mat} $elems {
                    foreach ni [list $n7 $n8 $n9 $n10 $n11 $n12 $n13 $n14 $n15]  na [list $n1 $n2 $n1 $n1  $n2  $n3  $n4  $n5  $n4 ]  nb [list $n2 $n3 $n3 $n4  $n5  $n6  $n5  $n6  $n6 ] {
                        set pa [lindex [GiD_Info Coordinates $na mesh] 0]
                        set pb [lindex [GiD_Info Coordinates $nb mesh] 0]
                        set pi [MathUtils::ScalarByVectorProd 0.5 [MathUtils::VectorSum $pa $pb]]
                        GiD_Mesh edit node $ni $pi
                    }
                }
            } else {
                #other elements
            }
        }
        ::GidUtils::EndWaitState
        ::GidUtils::SetWarnLine [_ "Quadratic elements set to linear shape. Time= %s seconds" [expr [clock seconds]-$t0]]
        GiD_Redraw
    }
    CenterQuadraticNodes
}

#[_ "Read preferences from a file (to avoid restart the system with other user)"]
set {macrosdata(Read Preferences,Group)} Tools
set {macrosdata(Read Preferences,IsStandard)} 1
set {macrosdata(Read Preferences,CreationDate)} {2006-02-13 20:59:36}
set {macrosdata(Read Preferences,Accelerators)} {}
set {macrosdata(Read Preferences,InToolbar)} 0
set {macrosdata(Read Preferences,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Read Preferences,Active)} 1
set {macrosdata(Read Preferences,Description)} {Read preferences from a file (to avoid restart the system with other user)}
set {macrosdata(Read Preferences,PrePost)} pre
set {macrosdata(Read Preferences,Icon)} {user_open.png themed_image}

proc {Read Preferences} {} {
    proc ReadDefaultsFromFile { filename } {
        set cloud 0
        set raise_events 0
        ReadPreferences $filename $cloud $raise_events
        GidUtils::UpdateWindow PREFERENCES
    }
    proc ReadDefaultsFromFileW { } {
        set w .gid
        set types [list [list [_ "Preferences file"] ".ini"] [list [_ "All files"] ".*"]]
        set filename [MessageBoxGetFilename file read [_ "Read preferences file"] "" $types .ini 0]
        if { $filename == "" } { return }
        ReadDefaultsFromFile $filename
    }
    ReadDefaultsFromFileW
}

#[_ "Save preferences to a file (to avoid restart the system with other user)"]
set {macrosdata(Save Preferences,InToolbar)} 0
set {macrosdata(Save Preferences,Icon)} {user_save.png themed_image}
set {macrosdata(Save Preferences,Description)} {Save preferences to a file (to avoid restart the system with other user)}
set {macrosdata(Save Preferences,CreationDate)} {2006-02-13 21:49:11}
set {macrosdata(Save Preferences,PrePost)} pre
set {macrosdata(Save Preferences,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Save Preferences,Active)} 1
set {macrosdata(Save Preferences,Accelerators)} {}
set {macrosdata(Save Preferences,Group)} Tools
set {macrosdata(Save Preferences,IsStandard)} 1

proc {Save Preferences} {} {
    proc SaveDefaultsToFileW { } {
        set w .gid
        set types [list [list [_ "Preferences file"] ".ini"] [list [_ "All files"] ".*"]]
        set filename [MessageBoxGetFilename file write [_ "Save preferences file"] "" $types .ini 0]
        if { $filename == "" } { return }
        set raise_events 0
        SavePreferences $filename 0 $raise_events
    }
    SaveDefaultsToFileW
}

#[_ "Delete duplicated near points with a tolerance"]
set {macrosdata(Collapse points,IsStandard)} 1
set {macrosdata(Collapse points,CreationDate)} {2006-02-14 23:37:21}
set {macrosdata(Collapse points,Active)} 1
set {macrosdata(Collapse points,Icon)} {collapse_points.png themed_image}
set {macrosdata(Collapse points,Accelerators)} {}
set {macrosdata(Collapse points,InToolbar)} 0
set {macrosdata(Collapse points,PrePost)} pre
set {macrosdata(Collapse points,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Collapse points,Group)} {Geometry Edit}
set {macrosdata(Collapse points,Description)} {Delete duplicated near points with a tolerance}

proc {Collapse points} {} {
    GiD_Process MEscape Utilities Collapse Points
}

#[_ "Delete duplicated near lines with a tolerance"]
set {macrosdata(Collapse lines,Active)} 1
set {macrosdata(Collapse lines,CreationDate)} {2006-02-14 23:42:43}
set {macrosdata(Collapse lines,Group)} {Geometry Edit}
set {macrosdata(Collapse lines,Accelerators)} {}
set {macrosdata(Collapse lines,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Collapse lines,Description)} {Delete duplicated near lines with a tolerance}
set {macrosdata(Collapse lines,PrePost)} pre
set {macrosdata(Collapse lines,IsStandard)} 1
set {macrosdata(Collapse lines,InToolbar)} 0
set {macrosdata(Collapse lines,Icon)} {collapse_lines.png themed_image}

proc {Collapse lines} {} {
    GiD_Process MEscape Utilities Collapse Lines
}

#[_ "Delete duplicated entities of the model with a tolerance"]
set {macrosdata(Collapse  model,Active)} 1
set {macrosdata(Collapse  model,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Collapse  model,Group)} {Geometry Edit}
set {macrosdata(Collapse  model,CreationDate)} {2006-02-14 23:39:16}
set {macrosdata(Collapse  model,IsStandard)} 1
set {macrosdata(Collapse  model,Icon)} {collapse_alltypes.png themed_image}
set {macrosdata(Collapse  model,Accelerators)} {}
set {macrosdata(Collapse  model,InToolbar)} 1
set {macrosdata(Collapse  model,Description)} {Delete duplicated entities of the model with a tolerance}
set {macrosdata(Collapse  model,PrePost)} pre

proc {Collapse  model} {} {
    GiD_Process MEscape Utilities Collapse Model
}

#[_ "List some filtered results"]
set macrosdata(ListResults,Active) 1
set macrosdata(ListResults,InToolbar) 1
set macrosdata(ListResults,CreationDate) {2006-02-15 11:38:42}
set macrosdata(ListResults,Accelerators) {}
set macrosdata(ListResults,ModificationDate) {2011-11-04 11:03:51}
set macrosdata(ListResults,IsStandard) 1
set macrosdata(ListResults,Group) View
set macrosdata(ListResults,Icon) {align_text_left.png themed_image}
set macrosdata(ListResults,Description) {List some filtered results}
set macrosdata(ListResults,PrePost) post

proc ListResults {} {
    namespace eval ::PostUtils {
    }
    #over: nodes or elements
    #results: list with this possible options: nodesnum, nodescoord, elemsnum,
    #         elemsconec, elemstype, elemslayer, <result name>
    #selection: list of id's (can be used a:b)
    #presentation: TEXT or LIST
    proc ::PostUtils::SelectResults { results over selection {presentation TEXT} } {
        #scan from info of first item the kind of data returned
        set first_item_selection [lindex [GidUtils::UnCompactNumberList $selection] 0]
        if { $first_item_selection == "" } {
            return ""
        }
        set info_first_item [lrange [split [GiD_Info list_entities $over {*}$first_item_selection] \n] 1 end-1]
        set infoitems [list]
        foreach line $info_first_item {
            set key [lindex $line 0]
            if { $key == "Num:" } {
                lappend infoitems numinfo
            } elseif { $key == "Used" } {
                lappend infoitems usedbyinfo
            } elseif { $key == "Current" } {
                lappend infoitems currentinfo
            } elseif { $key == "Gauss" } {
                lappend infoitems gausspoints
            } elseif { $key == "More" } {
                lappend infoitems moreinfo
            } else {
                error "unexpected key: $key. $info_first_item"
            }
        }
        #
        set info [lrange [split [GiD_Info list_entities $over {*}$selection] \n] 1 end-1]
        set res ""
        if { $over == "nodes" } {
            foreach $infoitems $info {
                set res2 ""
                if { [lsearch $results "nodesnum"] != -1 } {
                    lappend res2 [lindex $numinfo 1]
                }
                if { [lsearch $results "nodescoord"] != -1 } {
                    lappend res2 [string trim [lindex $numinfo 2]]
                }
                if { [info exists moreinfo] } {
                    foreach resultinfo [lindex $moreinfo 2] {
                        set name [lindex $resultinfo 0]
                        if { [lsearch $results $name] != -1 } {
                            if { [string trim [lindex $resultinfo 1]] != "" } {
                                set resultnames($name) ""
                                foreach item [string trim [lindex $resultinfo 1]] {
                                    lappend resultnames($name) $item
                                }
                            }
                            lappend res2 [string trim [lindex [lindex $resultinfo 2] 0]]
                        }
                    }
                }
                lappend res $res2
            }
        } elseif { $over == "elements" } {
            foreach $infoitems $info {
                set res2 ""
                if { [lsearch $results "elemsnum"] != -1 } {
                    lappend res2 [lindex $numinfo 1]
                }
                if { [lsearch $results "elemsconec"] != -1 } {
                    lappend res2 [string trim [lindex $numinfo 2]]
                }
                if { [lsearch $results "elemstype"] != -1 } {
                    lappend res2 [string trim [lindex $numinfo 3]]
                }
                if { [lsearch $results "elemslayer"] != -1 } {
                    lappend res2 [string trim [lindex $numinfo 4]]
                }
                if { [info exists moreinfo] } {
                    foreach resultinfo [lindex $moreinfo 2] {
                        set name [lindex $resultinfo 0]
                        if { [lsearch $results $name] != -1 } {
                            if { [string trim [lindex $resultinfo 2]] != "" } {
                                set resultnames($name) ""
                                foreach item [string trim [lindex $resultinfo 2]] {
                                    lappend resultnames($name) $item
                                }
                            }
                            lappend res2 [string trim [lindex $resultinfo 3]]
                        }
                    }
                }
                lappend res $res2
            }
        }
        if { $presentation == "TEXT" } {
            set newres ""
            foreach item $results {
                if { [info exists resultnames($item)] && $resultnames($item) != "" } {
                    foreach component $resultnames($item) {
                        set txt $item:$component
                        regsub -all { } $txt _ txt
                        append newres $txt " "
                    }
                } else {
                    if { $item == "nodesnum" || $item == "elemsnum" } {
                        set txt [_ "Number"]
                        regsub -all { } $txt _ txt
                    } elseif { $item == "nodescoord" } {
                        set txt "X Y Z"
                    } elseif { $item == "elemsconec" } {
                        set txt [_ "connectivities"]
                    } else {
                        set txt $item
                        regsub -all { } $txt _ txt
                    }
                    append newres $txt " "
                }
            }
            set newres [string trim $newres]\n
            foreach item $res {
                append newres [eval concat $item]\n
            }
            set res $newres
        }
        WarnWinText $res
        return $res
    }

    proc ::PostUtils::ApplySelectResults { w } {
        global PostUtils
        set results ""
        if { $PostUtils(over) == "nodes" } {
            if { $PostUtils(output,number) } {
                lappend results nodesnum
            }
            if { $PostUtils(output,coordinates) } {
                lappend results nodescoord
            }
        } else {
            if { $PostUtils(output,number) } {
                lappend results elemsnum
            }
            if { $PostUtils(output,connectivities) } {
                lappend results elemsconec
            }
        }
        foreach item [GiD_Info postprocess get cur_results_list contour_fill] {
            if { $PostUtils(over,$item) == $PostUtils(over) && $PostUtils(output,$item) } {
                lappend results $item
            }
        }
        if { [llength $results] > 0 } {
            set SmallWinSelecting [GiD_Set SmallWinSelecting]
            FinishButton $w $w.buts [_ "Press 'Finish' to end selection"] "" disableall $SmallWinSelecting
            set entities [GidUtils::PickEntities $PostUtils(over) multiple]
            EndFinishButton $w "" $SmallWinSelecting
            if { $entities != "" } {
                ::PostUtils::SelectResults $results $PostUtils(over) $entities
            } else {
                GidUtils::SetWarnLine [_ "Must select some entity"]
            }
        } else {
            GidUtils::SetWarnLine [_ "Must select some result"]
        }
    }

    proc ::PostUtils::SelectResultsW { { w .gid.selectresults } } {
        global PostUtils
        InitWindow2 $w -title [_ "Select Results"] \
            -geometryvariable PostSelectResultsWindowGeom \
            -initcommand ::PostUtils::SelectResultsW -ontop
        ttk::frame $w.f -style ridge.TFrame -borderwidth 2
        ttk::frame $w.f.f0
        ttk::radiobutton $w.f.f0.rb0 -text [_ "Nodes"] -value nodes -variable PostUtils(over)
        ttk::radiobutton $w.f.f0.rb1 -text [_ "Elements"] -value elements -variable PostUtils(over)
        if { ![info exists PostUtils(over)] || ($PostUtils(over) != "nodes" && $PostUtils(over) != "elements") } {
            set PostUtils(over) nodes
        }
        if { ![info exists PostUtils(output,number)] } {
            set PostUtils(output,number) 1
        }
        if { ![info exists PostUtils(output,coordinates)] } { set PostUtils(output,coordinates) 0 }
        ttk::checkbutton $w.f.f0.cbcoordinates -text [_ "Coordinates"] -variable PostUtils(output,coordinates)
        if { $PostUtils(over) == "nodes" } {
            $w.f.f0.cbcoordinates configure -state normal
        } else {
            $w.f.f0.cbcoordinates configure -state disable
        }
        if { ![info exists PostUtils(output,connectivities)] } { set PostUtils(output,connectivities) 0 }
        ttk::checkbutton $w.f.f0.cbconnectivities -text [_ "Connectivities"] -variable PostUtils(output,connectivities)
        if { $PostUtils(over) == "nodes" } {
            $w.f.f0.cbconnectivities configure -state disable
        } else {
            $w.f.f0.cbconnectivities configure -state normal
        }
        if { ![info exists PostUtils(output,number)] } { set PostUtils(output,number) 0 }
        ttk::checkbutton $w.f.number -text [_ "Number"] -variable PostUtils(output,number)
        #array unset PostUtils output,*
        set results [GiD_Info postprocess get cur_results_list contour_fill]
        set cont 0
        foreach item $results {
            set header [GiD_Result get -info [list $item [GiD_Info postprocess get cur_analysis] [GiD_Info postprocess get cur_step]]]
            if { [lindex [lindex $header 0] 5] == "OnNodes" } {
                set PostUtils(over,$item) nodes
            } else {
                set PostUtils(over,$item) elements
            }
            if { ![info exists PostUtils(output,$item)] } { set PostUtils(output,$item) 0 }
            regsub -all _ $item { } item_label
            ttk::checkbutton $w.f.cb$cont -text [TranslateResultName $item_label] -variable PostUtils(output,$item)
            if { $PostUtils(over,$item) == $PostUtils(over) } {
                $w.f.cb$cont configure -state normal
            } else {
                $w.f.cb$cont configure -state disable
            }
            incr cont
        }
        grid $w.f.f0.rb0 $w.f.f0.rb1 -sticky w
        grid $w.f.f0.cbcoordinates $w.f.f0.cbconnectivities -sticky w
        grid $w.f.f0 -sticky ew
        grid $w.f.number -sticky w
        for {set i 0} {$i < $cont} {incr i} {
            grid $w.f.cb$i -sticky w
        }
        grid rowconfigure $w.f [expr {$cont+2}] -weight 1
        grid columnconfigure $w.f 0 -weight 1
        grid $w.f -sticky nsew
        ttk::frame $w.buts -style BottomFrame.TFrame
        ttk::button $w.buts.apply -text [_ "Select"] -command "::PostUtils::ApplySelectResults $w" -style BottomFrame.TButton
        ttk::button $w.buts.close -text [_ "Close"] -command "destroy $w" -style BottomFrame.TButton

        grid $w.buts.apply $w.buts.close -sticky ew -padx 5 -pady 6
        grid $w.buts -sticky sew
        grid anchor $w.buts center
        grid columnconfigure $w 0 -weight 1
        grid rowconfigure $w 0 -weight 1
        bind $w <Destroy> [list +::PostUtils::DestroySelectResults %W $w] ;# + to add to previous script
        trace add variable PostUtils(over) write "::PostUtils::ChangeSelectResultsOver $w ;#"
    }

    proc ::PostUtils::DestroySelectResults { W w } {
        if { $W != $w } return
        #reenter multiple times, one by toplevel child, only interest w
        global PostUtils
        #catch { array unset PostUtils result,* } ;#remove also traces
        trace remove variable PostUtils(over) write "::PostUtils::ChangeSelectResultsOver $w ;#"
    }

    proc ::PostUtils::ChangeSelectResultsOver { w } {
        global PostUtils
        if { $PostUtils(over) == "nodes" } {
            $w.f.f0.cbcoordinates configure -state normal
            $w.f.f0.cbconnectivities configure -state disable
        } else {
            $w.f.f0.cbcoordinates configure -state disable
            $w.f.f0.cbconnectivities configure -state normal
        }
        set results [GiD_Info postprocess get cur_results_list contour_fill]
        set cont 0
        foreach item $results {
            if { $PostUtils(over,$item) == $PostUtils(over) } {
                $w.f.cb$cont configure -state normal
            } else {
                $w.f.cb$cont configure -state disable
            }
            incr cont
        }
    }
    ::PostUtils::SelectResultsW
}

#[_ "set all labels on/off"]
set {macrosdata(Label on/off,CreationDate)} {2006-02-15 23:50:41}
set {macrosdata(Label on/off,Group)} View
set {macrosdata(Label on/off,InToolbar)} 1
set {macrosdata(Label on/off,Accelerators)} {}
set {macrosdata(Label on/off,Description)} {set all labels on/off}
set {macrosdata(Label on/off,Icon)} {view_labels.png themed_image}
set {macrosdata(Label on/off,Active)} 1
set {macrosdata(Label on/off,PrePost)} prepost
set {macrosdata(Label on/off,IsStandard)} 1
set {macrosdata(Label on/off,ModificationDate)} {2011-11-04 11:03:51}

proc {Label on/off} {} {
    proc SetLabelsOnOff { } {
        global GidPriv
        if { ![info exists GidPriv(labelson)] } {
            set GidPriv(labelson) 0
        }
        if { $GidPriv(labelson) } {
            set  GidPriv(labelson) 0
            GiD_Process 'Label Off
        } else {
            set  GidPriv(labelson) 1
            GiD_Process 'Label All
        }
    }
    SetLabelsOnOff
}

#[_ "Draw normals of surfaces by color"]
set {macrosdata(Draw normals surfaces color,Group)} View
set {macrosdata(Draw normals surfaces color,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Draw normals surfaces color,Description)} {Draw normals of surfaces by color}
set {macrosdata(Draw normals surfaces color,Icon)} {view_normals_surface.png themed_image}
set {macrosdata(Draw normals surfaces color,CreationDate)} {2006-02-16 13:04:57}
set {macrosdata(Draw normals surfaces color,Accelerators)} {}
set {macrosdata(Draw normals surfaces color,IsStandard)} 1
set {macrosdata(Draw normals surfaces color,InToolbar)} 1
set {macrosdata(Draw normals surfaces color,Active)} 1
set {macrosdata(Draw normals surfaces color,PrePost)} pre

proc {Draw normals surfaces color} {} {
    proc DrawNormalsColor { } {
        if { [GiD_Info project ViewMode] == "GEOMETRYUSE" } {
            GiD_Process Mescape Utilities DrawNormals Surfaces Color
        } else {
            GiD_Process Mescape Utilities DrawNormals Color
        }
        foreach layer [GiD_Info Layers] {
            foreach {on frozen} [lrange [lindex [GiD_Info Layers $layer] 0]  0 1] break
            if { $on && !$frozen } {
                GiD_Process 'Layer:$layer
            }
        }
    }
    DrawNormalsColor
}

#[_ "Show number of higerentities (parents) of lines"]
set {macrosdata(Higherentities lines,CreationDate)} {2006-02-16 13:23:38}
set {macrosdata(Higherentities lines,PrePost)} pre
set {macrosdata(Higherentities lines,Accelerators)} {}
set {macrosdata(Higherentities lines,Icon)} {view_higherentity_lines.png themed_image}
set {macrosdata(Higherentities lines,Active)} 1
set {macrosdata(Higherentities lines,Group)} View
set {macrosdata(Higherentities lines,InToolbar)} 1
set {macrosdata(Higherentities lines,IsStandard)} 1
set {macrosdata(Higherentities lines,Description)} {Show number of higerentities (parents) of lines}
set {macrosdata(Higherentities lines,ModificationDate)} {2011-11-04 11:03:51}

proc {Higherentities lines} {} {
    if { [GiD_Info Project ViewMode] == "GEOMETRYUSE" } {
        GiD_Process Mescape Utilities DrawHigher Lines
    } else {
        GiD_Process Mescape Utilities DrawHigher Edges
    }
}

#[_ "Draw assigned mesh sizes"]
set {macrosdata(Draw mesh sizes,InToolbar)} 1
set {macrosdata(Draw mesh sizes,Icon)} {view_assigned_meshsizes.png themed_image}
set {macrosdata(Draw mesh sizes,Description)} {Draw assigned mesh sizes}
set {macrosdata(Draw mesh sizes,CreationDate)} {2006-02-16 16:52:44}
set {macrosdata(Draw mesh sizes,PrePost)} pre
set {macrosdata(Draw mesh sizes,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Draw mesh sizes,Active)} 1
set {macrosdata(Draw mesh sizes,Accelerators)} {}
set {macrosdata(Draw mesh sizes,Group)} View
set {macrosdata(Draw mesh sizes,IsStandard)} 1

proc {Draw mesh sizes} {} {
    GiD_Process Mescape Meshing DrawSizes All
}

#[_ "View XY plane"]
set {macrosdata(XY View,Group)} View
set {macrosdata(XY View,PrePost)} prepost
set {macrosdata(XY View,InToolbar)} 1
set {macrosdata(XY View,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(XY View,CreationDate)} {2006-02-16 20:33:42}
set {macrosdata(XY View,Icon)} {view_rotate_xy.png themed_image}
set {macrosdata(XY View,Accelerators)} {}
set {macrosdata(XY View,Active)} 1
set {macrosdata(XY View,Description)} {View XY plane}
set {macrosdata(XY View,IsStandard)} 1

proc {XY View} {} {
    GidRotateView::PlaneXY
}

#[_ "View XZ plane"]
set {macrosdata(XZ View,Icon)} {view_rotate_xz.png themed_image}
set {macrosdata(XZ View,PrePost)} prepost
set {macrosdata(XZ View,CreationDate)} {2006-02-16 20:36:44}
set {macrosdata(XZ View,Group)} View
set {macrosdata(XZ View,Accelerators)} {}
set {macrosdata(XZ View,IsStandard)} 1
set {macrosdata(XZ View,Description)} {View XZ plane}
set {macrosdata(XZ View,Active)} 1
set {macrosdata(XZ View,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(XZ View,InToolbar)} 0

proc {XZ View} {} {
    GidRotateView::PlaneXZ
}

#[_ "View YZ plane"]
set {macrosdata(YZ View,Group)} View
set {macrosdata(YZ View,Icon)} {view_rotate_yz.png themed_image}
set {macrosdata(YZ View,Description)} {View YZ plane}
set {macrosdata(YZ View,PrePost)} prepost
set {macrosdata(YZ View,Active)} 1
set {macrosdata(YZ View,InToolbar)} 0
set {macrosdata(YZ View,CreationDate)} {2006-02-16 20:37:05}
set {macrosdata(YZ View,Accelerators)} {}
set {macrosdata(YZ View,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(YZ View,IsStandard)} 1

proc {YZ View} {} {
    GidRotateView::PlaneYZ
}

#[_ "View -XY plane"]
set {macrosdata(-XY View,Group)} View
set {macrosdata(-XY View,CreationDate)} {2006-02-16 20:37:56}
set {macrosdata(-XY View,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(-XY View,Active)} 1
set {macrosdata(-XY View,Accelerators)} {}
set {macrosdata(-XY View,InToolbar)} 0
set {macrosdata(-XY View,Description)} {View - XY plane}
set {macrosdata(-XY View,IsStandard)} 1
set {macrosdata(-XY View,PrePost)} prepost
set {macrosdata(-XY View,Icon)} {view_rotate_-xy.png themed_image}

proc {-XY View} {} {
    GidRotateView::PlaneMinusXY
}

#[_ "View -YZ plane"]
set {macrosdata(-YZ View,Group)} View
set {macrosdata(-YZ View,Active)} 1
set {macrosdata(-YZ View,CreationDate)} {2006-02-16 20:38:46}
set {macrosdata(-YZ View,Accelerators)} {}
set {macrosdata(-YZ View,InToolbar)} 0
set {macrosdata(-YZ View,Icon)} {view_rotate_-yz.png themed_image}
set {macrosdata(-YZ View,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(-YZ View,IsStandard)} 1
set {macrosdata(-YZ View,PrePost)} prepost
set {macrosdata(-YZ View,Description)} {View - YZ plane}

proc {-YZ View} {} {
    GidRotateView::PlaneMinusYZ
}

#[_ "Change the render mode"]
set macrosdata(SwapRender,InToolbar) 0
set macrosdata(SwapRender,CreationDate) {2008-11-03 21:44:46}
set macrosdata(SwapRender,Accelerators) F3
set macrosdata(SwapRender,Active) 1
set macrosdata(SwapRender,Icon) {view_swap_render.png themed_image}
set macrosdata(SwapRender,ModificationDate) {2011-11-04 11:03:51}
set macrosdata(SwapRender,Group) View
set macrosdata(SwapRender,PrePost) prepost
set macrosdata(SwapRender,Description) {Change the render mode}
set macrosdata(SwapRender,IsStandard) 1

proc SwapRender {} {
    set render_mode [ GiD_Info Project RenderMode]
    if { $render_mode != "postprocess"} {
        if { $render_mode !=  "normal" } {
            GiD_Process 'Render Normal
        } else {
            GiD_Process 'Render Flat
        }
    } else {
        set postrender [ GiD_Info postprocess get cur_display_render]

        set lstRender [ list Normal Flat Smooth]
        set idxRender [ lsearch $lstRender $postrender]
        set nRender [ llength $lstRender]
        set nextRender [ expr ( $idxRender + $nRender + 1) % $nRender]
        GiD_Process 'Render [ lindex $lstRender $nextRender]
    }
}

#[_ "converts scalar results to a vector"]
set {macrosdata(Scalar 2 vector,IsStandard)} 1
set {macrosdata(Scalar 2 vector,Group)} Tools
set {macrosdata(Scalar 2 vector,CreationDate)} {2007-02-28 17:41:13}
set {macrosdata(Scalar 2 vector,Accelerators)} {}
set {macrosdata(Scalar 2 vector,PrePost)} post
set {macrosdata(Scalar 2 vector,Active)} 1
set {macrosdata(Scalar 2 vector,Icon)} {Scalar2Vector.png themed_image}
set {macrosdata(Scalar 2 vector,Description)} {converts scalar results to a vector}
set {macrosdata(Scalar 2 vector,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Scalar 2 vector,InToolbar)} 1

proc {Scalar 2 vector} {} {
    ::PostUtils::ResultScalarToVector
}


#[_ "View -XZ plane"]
set {macrosdata(-XZ View,CreationDate)} {2006-02-16 20:38:30}
set {macrosdata(-XZ View,InToolbar)} 0
set {macrosdata(-XZ View,Description)} {View - XZ plane}
set {macrosdata(-XZ View,Accelerators)} {}
set {macrosdata(-XZ View,Active)} 1
set {macrosdata(-XZ View,Group)} View
set {macrosdata(-XZ View,IsStandard)} 1
set {macrosdata(-XZ View,Icon)} {view_rotate_-xz.png themed_image}
set {macrosdata(-XZ View,PrePost)} prepost
set {macrosdata(-XZ View,ModificationDate)} {2011-11-04 11:03:51}

proc {-XZ View} {} {
    GidRotateView::PlaneMinusXZ
}

#[_ "Pan dynamic\n    Useful to assign one keyboard accelerator"]
set {macrosdata(Pan dynamic,Description)} {Pan dynamic
Useful to assign one keyboard accelerator}
set {macrosdata(Pan dynamic,PrePost)} prepost
set {macrosdata(Pan dynamic,Active)} 1
set {macrosdata(Pan dynamic,ModificationDate)} {2006-03-01 12:33:53}
set {macrosdata(Pan dynamic,Group)} View
set {macrosdata(Pan dynamic,CreationDate)} {2006-03-01 12:27:08}
set {macrosdata(Pan dynamic,IsStandard)} 1
set {macrosdata(Pan dynamic,Icon)} {pan.png themed_image}
set {macrosdata(Pan dynamic,Accelerators)} F10
set {macrosdata(Pan dynamic,InToolbar)} 0

proc {Pan dynamic} {} {
    GiD_Process 'DynamicPan
}

#[_ "Previous view\n    Useful to assign one keyboard accelerator"]
set {macrosdata(Previous view,CreationDate)} {2006-03-01 12:30:27}
set {macrosdata(Previous view,Icon)} {viewprev.png themed_image}
set {macrosdata(Previous view,Accelerators)} F9
set {macrosdata(Previous view,PrePost)} prepost
set {macrosdata(Previous view,IsStandard)} 1
set {macrosdata(Previous view,Description)} {Previous view
Useful to assign one keyboard accelerator}
set {macrosdata(Previous view,ModificationDate)} {2006-03-01 12:34:11}
set {macrosdata(Previous view,InToolbar)} 0
set {macrosdata(Previous view,Active)} 1
set {macrosdata(Previous view,Group)} View

proc {Previous view} {} {
    GiD_Process 'Zoom previous
}

#[_ "Zoom dynamic\n    Useful to assign one keyboard accelerator"]
set {macrosdata(Zoom dynamic,Icon)} {zoomin.png themed_image}
set {macrosdata(Zoom dynamic,InToolbar)} 0
set {macrosdata(Zoom dynamic,Description)} {Zoom dynamic
Useful to assign one keyboard accelerator}
set {macrosdata(Zoom dynamic,Group)} View
set {macrosdata(Zoom dynamic,ModificationDate)} {2006-03-01 12:39:22}
set {macrosdata(Zoom dynamic,CreationDate)} {2006-03-01 12:35:26}
set {macrosdata(Zoom dynamic,PrePost)} prepost
set {macrosdata(Zoom dynamic,Accelerators)} F8
set {macrosdata(Zoom dynamic,Active)} 1
set {macrosdata(Zoom dynamic,IsStandard)} 1

proc {Zoom dynamic} {} {
    GiD_Process 'Zoom Dynamic
}

#[_ "Rotate trackball\n    Useful to assign one keyboard accelerator"]
set {macrosdata(Rotate trackball,Icon)} {rotate.png themed_image}
set {macrosdata(Rotate trackball,Active)} 1
set {macrosdata(Rotate trackball,PrePost)} prepost
set {macrosdata(Rotate trackball,IsStandard)} 1
set {macrosdata(Rotate trackball,ModificationDate)} {2006-03-01 12:34:26}
set {macrosdata(Rotate trackball,CreationDate)} {2006-03-01 12:32:22}
set {macrosdata(Rotate trackball,Group)} View
set {macrosdata(Rotate trackball,InToolbar)} 0
set {macrosdata(Rotate trackball,Accelerators)} F7
set {macrosdata(Rotate trackball,Description)} {Rotate trackball
Useful to assign one keyboard accelerator}

proc {Rotate trackball} {} {
    GiD_Process 'Rotate Trackball
}

#[_ "Rotate center\n    Useful to assign one keyboard accelerator"]
set {macrosdata(Rotate center,ModificationDate)} {2006-03-01 12:35:02}
set {macrosdata(Rotate center,InToolbar)} 0
set {macrosdata(Rotate center,IsStandard)} 1
set {macrosdata(Rotate center,PrePost)} prepost
set {macrosdata(Rotate center,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Rotate center,Active)} 1
set {macrosdata(Rotate center,Icon)} {rotate.png themed_image}
set {macrosdata(Rotate center,Group)} View
set {macrosdata(Rotate center,Accelerators)} F6
set {macrosdata(Rotate center,Description)} {Rotate center
Useful to assign one keyboard accelerator}

proc {Rotate center} {} {
    GiD_Process 'Rotate Center FJoin
}

#[_ "Info Graphical Window"]
set {macrosdata(Info Graphical Window,ModificationDate)} {2011-11-04 11:03:51}
set {macrosdata(Info Graphical Window,Description)} {Info Graphical Window}
set {macrosdata(Info Graphical Window,Active)} 1
set {macrosdata(Info Graphical Window,CreationDate)} {2010-02-12 12:57:44}
set {macrosdata(Info Graphical Window,IsStandard)} 1
set {macrosdata(Info Graphical Window,Accelerators)} {}
set {macrosdata(Info Graphical Window,Icon)} {screen_info.png themed_image}
set {macrosdata(Info Graphical Window,PrePost)} prepost
set {macrosdata(Info Graphical Window,Group)} View
set {macrosdata(Info Graphical Window,InToolbar)} 1

proc {Info Graphical Window} {} {
    lassign [GidUtils::GetMainDrawAreaSize] w h
    WarnWin "${w}x${h}"
}

#[_ "Zoom all\n    Useful to assign one keyboard accelerator"]
set {macrosdata(Zoom frame,Accelerators)} {}
set {macrosdata(Zoom frame,PrePost)} prepost
set {macrosdata(Zoom frame,IsStandard)} 1
set {macrosdata(Zoom frame,Description)} {Zoom all
Useful to assign one keyboard accelerator}
set {macrosdata(Zoom frame,ModificationDate)} {2006-03-01 12:47:33}
set {macrosdata(Zoom frame,InToolbar)} 0
set {macrosdata(Zoom frame,Active)} 1
set {macrosdata(Zoom frame,Group)} View
set {macrosdata(Zoom frame,CreationDate)} {2006-03-01 12:46:29}
set {macrosdata(Zoom frame,Icon)} {zframe.png themed_image}

proc {Zoom frame} {} {
    GiD_Process 'Zoom Frame
}

#[_ "Dimension distance between two points"]
set {macrosdata(Dimension distance,Accelerators)} {}
set {macrosdata(Dimension distance,Active)} 1
set {macrosdata(Dimension distance,Description)} {Dimension distance between two points}
set {macrosdata(Dimension distance,Group)} Dimension
set {macrosdata(Dimension distance,PrePost)} prepost
set {macrosdata(Dimension distance,Icon)} {dimension_dist.png themed_image}
set {macrosdata(Dimension distance,InToolbar)} 1
set {macrosdata(Dimension distance,IsStandard)} 1
set {macrosdata(Dimension distance,CreationDate)} {2004-11-18 21:53:33}
set {macrosdata(Dimension distance,ModificationDate)} {2011-11-04 11:03:51}

proc {Dimension distance} {} {
    GiD_Process Mescape Utilities Dimension Create Distance
}

#[_ "Redraw\n    Useful to assign one keyboard accelerator"]
set macrosdata(Redraw,Description) {Redraw
Useful to assign one keyboard accelerator}
set macrosdata(Redraw,InToolbar) 0
set macrosdata(Redraw,ModificationDate) {2006-03-01 12:42:09}
set macrosdata(Redraw,IsStandard) 1
set macrosdata(Redraw,Group) View
set macrosdata(Redraw,Icon) {redraw.png themed_image}
set macrosdata(Redraw,Active) 1
set macrosdata(Redraw,CreationDate) {2006-03-01 12:41:13}
set macrosdata(Redraw,Accelerators) Ctrl-less
set macrosdata(Redraw,PrePost) prepost

proc Redraw {} {
    GiD_Redraw
}

#[_ "To create a graph of gaussian result along the time"]
set macrosdata(GraphGaussResult,Description) {To create a graph of gaussian result along the time}
set macrosdata(GraphGaussResult,InToolbar) 1
set macrosdata(GraphGaussResult,ModificationDate) {2019-11-14 20:06:13}
set macrosdata(GraphGaussResult,IsStandard) 1
set macrosdata(GraphGaussResult,Group) View
set macrosdata(GraphGaussResult,Icon) {PostBarGraphPointEvolution.png imported_images PostBarGraphPointEvolution.png themed_image}
set macrosdata(GraphGaussResult,Active) 1
set macrosdata(GraphGaussResult,CreationDate) {2019-11-14 20:04:16}
set macrosdata(GraphGaussResult,Accelerators) {}
set macrosdata(GraphGaussResult,PrePost) post

proc GraphGaussResult {} {
    #procedures to allow create a graph along the time of a result on a gauss point without any smoothing or extrapolation

    #result_id : list with 3 items: { result_name analysis_name time_step }
    proc GraphElementResult_GetElementResult { result_id element_id component_i gauss_i } {
        set err [ catch {
            set data [GiD_Result get -selection [list $element_id] $result_id]
            lassign $data result_header result_unit result_components result_values
            set gauss_i_values [lindex $result_values [expr $gauss_i+1]]
            set value [lindex $gauss_i_values $component_i]
        }]
        if { $err} {
            # result value does not exists for this step/analysis
            set value ""   ;# so that it will not be added to the graph
        }
        return $value
    }

    proc GraphElementResult_GetResultAllTimeSteps { analysis_name result_name element_id component_i gauss_i } {
        set time_steps [list]
        set values [list]
        if { [lsearch [GiD_Info postprocess get all_analysis] $analysis_name] == -1 } {
            error "Analysis '$analysis_name' doesn't found"
        } else {
            set all_time_steps [GiD_Info postprocess get all_steps $analysis_name]
            foreach time_step $all_time_steps {
                set result_id [list $result_name $analysis_name $time_step]
                set value [GraphElementResult_GetElementResult $result_id $element_id $component_i $gauss_i]
                if { [string is double -strict $value] } {
                    lappend time_steps $time_step
                    lappend values $value
                }
            }
        }
        return [list $time_steps $values]
    }

    #get an unused graph_name, adding a suffix -2, ...-3 if base_name already exists
    proc GraphElementResult_GetUnusedGraphName { base_name } {
        set graph_name $base_name
        if { [GiD_Graph exists $graph_name] } {
            for {set i 2} {$i < 10000} {incr i} {
                set graph_name $base_name-$i
                if { ![GiD_Graph exists $graph_name] } {
                    break
                }
            }
        }
        return $graph_name
    }

    #result_component: "" for scalar result, or the component name for vector or tensor results, to get only a scalar component
    #gauss_i: local gauss index starting from 0 (always 0 for one single gauss point result)
    proc GraphElementResult_NewGraph { analysis_name result_name result_component element_id gauss_i } {
        if { $result_component == "" } {
            set component_i 0
            set label_y $result_name
        } else {
            set component_i [lsearch [GiD_Info postprocess get cur_components_list $result_name] $result_component]
            if { $component_i == -1 } {
                error "result_component '$result_component' doesn't found"
            } else {
                set label_y $result_component
            }
        }
        set graph_values [GraphElementResult_GetResultAllTimeSteps $analysis_name $result_name $element_id $component_i $gauss_i]
        if { [llength [lindex $graph_values 0]] } {
            set graph_name [GraphElementResult_GetUnusedGraphName "Evolution element ${element_id}:[expr $gauss_i+1]"]
            GiD_Graph create $graph_name Time $label_y {*}$graph_values "Sec" "" ""
        }
    }

    proc GraphElementResult_SelectedResult { args } {
        lassign $args result_name result_component
        set current_analysis [GiD_Info postprocess get cur_analysis]
        set current_step [GiD_Info postprocess get cur_step]
        set header [GiD_Result get -info [list $result_name $current_analysis $current_step]]
        if { [lindex [lindex $header 0] 5] != "OnGaussPoints" } {
            W "This tool is only valid for elemental gauss-points results"
        } else {
            set gauss_name [lindex [lindex $header 0] 6]
            set gauss_n [lindex [GiD_Result gauss_point get $gauss_name] 1]
            #set gauss_i 0 ;#set hardcoded the first gauss point of the element (can allow user selection in case of more than one)
            set element_ids [GidUtils::PickEntities Elements multiple]
            if { $element_ids != "" } {
                foreach element_id $element_ids {
                    for {set gauss_i 0} {$gauss_i < $gauss_n } {incr gauss_i} {
                        GraphElementResult_NewGraph $current_analysis $result_name $result_component $element_id $gauss_i
                    }
                }
                GidUtils::OpenWindow GRAPHS
                GiD_Redraw
            }
        }
    }

    proc GraphElementResult_ShowMenuResults { w } {
        set r_menu .gid.mGraphGaussResult
        if { ![ winfo exists $r_menu]} {
            menu $r_menu
        }
        #trick, must prefix with [namespace current] because macros are defined in the "toolbarmacros::macrospace" namespaceto not pollute the global names
        AddGraphsResultsToMenu $r_menu [namespace current]::GraphElementResult_SelectedResult Point_Evolution
        set x [expr {[winfo rootx $w]+[winfo width $w]}]
        set y [winfo rooty $w]
        tk_popup $r_menu $x $y
    }

    #trick to be able to show the menu on the right of a macro button (because macros doesn't provide the button name to its command)
    proc GraphElementResult_FindParentButton { } {
        set command [info level -1]
        set b ""
        set w .gid.bitmapsMacrosToolbar
        set inum 0
        while { [winfo exists $w.w$inum] } {
            if { [winfo class $w.w$inum] == "TButton" && [$w.w$inum cget -command] == $command } {
                set b $w.w$inum
                break
            }
            incr inum
        }
        return $b
    }

    proc GraphElementResult_Window { } {
        set w .gid.graphelementresult
        global PostUtils
        InitWindow2 $w -title [_ "Graph element result"] \
            -geometryvariable GraphElementResultWindowGeom \
            -initcommand GraphElementResultWindow -ontop
        ttk::frame $w.f -style ridge.TFrame -borderwidth 2

        ttk::button $w.f.bresults -image [gid_themes::GetImage PostBarGraphPointEvolution.png small_icons] -command [list [namespace current]::GraphElementResult_ShowMenuResults $w.f.bresults]
        grid $w.f.bresults -sticky w

        grid rowconfigure $w.f 1 -weight 1
        grid columnconfigure $w.f 1 -weight 1
        grid $w.f -sticky nsew

        ttk::frame $w.buts -style BottomFrame.TFrame
        ttk::button $w.buts.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton
        grid $w.buts.close -sticky ew -padx 5 -pady 6
        grid $w.buts -sticky sew
        grid anchor $w.buts center
        grid columnconfigure $w 0 -weight 1
        grid rowconfigure $w 0 -weight 1
        bind $w <Alt-c> [list $w.buts.close invoke]
        bind $w <Escape> [list $w.buts.close invoke]
    }


    #GraphElementResult_NewGraph Hydraulic "Depth (m)" "" 676 0]
    #GraphElementResult_Window ;#to be used without set as a macro
    GraphElementResult_ShowMenuResults [GraphElementResult_FindParentButton] ;#to be used from a macro button
}

#ordered names, to implicilty set its Number (to avoid need to manually renumber inserting a new default macro)

set ordered_names { Notes {Resize Graphical Window} {Dimension angle} {Dimension vertex} {Dimension arc} \
    {Dimension edit} {Dimension delete} CreateLayersFromElementMaterials \
    SeparateTopGeometryInLayers IgesFilesToLayers \
    MultipleWavefrontObjectsToCurrentLayer \
    {Send to back} {Send to back (Opposite)} \
    {Bring to front} {Send to back E} {Send to back E (opposite)} {Bring to front E} \
    {Trimmed surface} {Hole surface} {Surfaces from parallel lines} \
    {move point} {Divide line num divisions} {Divide line near point} \
    {Intersect lines} {Intersect lines (no divide)} {Divide surface} {Split surface} \
    {Intersect surface lines} {Intersect surfaces} {Construction line horizontal} \
    {Construction line vertical} {Split Big Triangles} {Collapse Small Triangles} \
    {Align Quadratic Nodes} {Read Preferences} {Save Preferences} {Collapse points} \
    {Collapse lines} {Collapse  model} {Average of current result} ListResults GraphGaussResult {Label on/off} \
    {Draw normals surfaces color} {Higherentities lines} {Draw mesh sizes} {XY View} \
    {XZ View} {YZ View} {-XY View} {-YZ View} SwapRender \
    {Scalar 2 vector} {-XZ View} {Pan dynamic} \
    {Previous view} {Zoom dynamic} {Rotate trackball} {Rotate center} \
    {Info Graphical Window} {Zoom frame} {Dimension distance} Redraw }
set id 0
foreach name $ordered_names {
    set macrosdata($name,Number) [incr id]
}
if { [llength $ordered_names] != [llength [array names macrosdata *,Description]] } {
    WarnWinText [format "Error in file toolbarmacros_defaults.tcl: declared %s macros but defined %s" \
        [llength $ordered_names] [llength [array names macrosdata *,Description]]]
}
