# https://github.com/flightaware/tohil/
# https://flightaware.github.io/tohil-docs/

proc load_library_tohil  { dir basename } {
    if { $::tcl_platform(pointerSize) == 8 } {
	    set bits 64
    } else {
	    set bits 32
    }
    if { $::tcl_platform(platform) eq "windows"} {
        set library ${basename}[info sharedlibextension]
        set library_with_path [file join $dir x${bits} $library]
        set ::env(PYTHONHOME) [file join $dir python]
        set ::env(PYTHONPATH) [file join $dir python bin x${bits}]
    } else {
        set library lib${basename}_${bits}[ info sharedlibextension]
        set library_with_path [file join $dir $library]
        set python_base [file join $dir python]
        # set ::env(PYTHONHOME) [file join $dir python] 
        set ::env(PYTHONHOME) [file join $dir python x64]
        # set ::env(PYTHONPATH) "[file join $dir python bin]:[file join $dir python x${bits} bin]:[file join $dir python bin x${bits}]"
        set python_version 3.12
        set python_path {}
        foreach ff [ list bin lib \
                         [ file join lib site-packages] \
                         [ file join lib python$python_version] \
                         [ file join lib python$python_version site-packages]] {
            lappend python_path [ file join $python_base $ff]
            lappend python_path [ file join $python_base x64 $ff]
        }
        set ::env(PYTHONPATH) [ join $python_path :]
    }
    #add it to env(PATH) to find tohil.dll dependent python dll libraries
    package require gid_cross_platform
    gid_cross_platform::path_append $::env(PYTHONPATH) 1
    
    load $library_with_path $basename
    #load {C:\gid_project\gid\tohil\vs\x64\Debug\tohil.dll} tohil
    #load {C:\gid_project\gid\tohil\vs\x64\Release\tohil.dll} tohil
    #load {C:\gid_project\gidvs\x64\Debug\tohil.dll} tohil
    #load {C:\gid_project\gidvs\x64\Release\tohil.dll} tohil
    source [file join $dir tohil.tcl]
    package provide tohil 4.4.2
}

package ifneeded tohil 4.4.2 [list load_library_tohil $dir tohil]
