proc load_library_tls  { dir basename } {
    if { $::tcl_platform(pointerSize) == 8 } {
	set bits 64
    } else {
	set bits 32
    }
    if { $::tcl_platform(platform) eq "windows"} {        
	set library ${basename}_${bits}[info sharedlibextension]	
    } else {
	set library lib${basename}_${bits}[info sharedlibextension]
    }
    source [file join $dir tls.tcl]

    #tls::initlib $dir $library
    load [file join $dir $library] $basename        
}

   
package ifneeded tls 1.7.22 [list load_library_tls $dir tls]
