#file with auxiliary procedures, used only doing automatic tests with our tester application

namespace eval GiD_Test {
}

#to have a value relating the length of line elements (of the group) and the length 
#of its intersections with the hexahedra of the model, to check it in the tester
proc GiD_Test::GetRatioErrorGiD_ToolsMeshIntersectvolumeslines { group_line_elements } {
    set cuts_length 0.0
    set data [GiD_Tools mesh intersectvolumeslines $group_line_elements]
    lassign $data element_ids xyz_starts xyz_ends    
    foreach {x0 y0 z0} $xyz_starts {x1 y1 z1} $xyz_ends {
	set d [MathUtils::VectorDistance "$x0 $y0 $z0" "$x1 $y1 $z1"]
	set cuts_length [expr {$cuts_length+$d}]
    }
    set element_ids [GiD_EntitiesGroups get $group_line_elements elements -element_type linear]  
    set elements_length [lindex [split [lindex [GiD_Info ListMassProperties Elements {*}$element_ids] end] =] 1]
    set ratio_error [expr {($elements_length-$cuts_length)/$elements_length}]
    return $ratio_error
}
