# some extra math functions for tcl expr, e.g. to be used in tester

namespace eval ::tcl::mathfunc {    
}

# add to expr some vector operations, p1 and p2 are a list of 3 coordinates
proc ::tcl::mathfunc::Distance3D { p1 p2 } {
    lassign $p1 p1x p1y p1z
    lassign $p2 p2x p2y p2z
    lassign [list [expr {$p2x-$p1x}] [expr {$p2y-$p1y}] [expr {$p2z-$p1z}]] px py pz
    set d [expr sqrt([expr $px*$px+$py*$py+$pz*$pz])]
    return $d
}

proc ::tcl::mathfunc::AreEqualScalar { v1 v2 tolerance } {
    return [expr abs($v1-$v2)<$tolerance]
}

proc ::tcl::mathfunc::AreEqualVector { p1 p2 tolerance } {
    set are_equal 1
    foreach  v1 $p1 v2 $p2 {
        if { ![::tcl::mathfunc::AreEqualScalar $v1 $v2 $tolerance] } {
            set are_equal 0
            break
        }
    }
    return $are_equal
}

# define the distance between two bounding boxes as the sum of the distances between the two corners
# bi: x1 y1 z1 x2 y2 z2 (min point and max point corners)
proc ::tcl::mathfunc::DistanceBoundingBox { b1 b2 } {
    set d_a [::tcl::mathfunc::Distance3D [lrange $b1 0 2] [lrange $b2 0 2]]
    set d_b [::tcl::mathfunc::Distance3D [lrange $b1 3 5] [lrange $b2 3 5]]
    return [expr $d_a+$d_b]
}

package provide gid_tcl_mathfunc 0.1
