namespace eval GidLock {
    variable _filename_lock ""
    variable _file_lock ""
    variable _read_only 0
}

proc GidLock::ModelCreateLockFile { projectname } {
    if { [GiD_Set EnableFileLocking] } {
        if { [GidLock::GetReadOnly] } {
        #W "GidLock::ModelCreateLockFile $projectname do nothing because is read-only"
        } else {
            GidLock::ModelDeleteLockFile
            set filename_lock [file join ${projectname}.gid [file tail $projectname].lck]
            set fp [open $filename_lock w]
            if { $fp != "" } {
                package require gid_cross_platform
                puts $fp "[pid]"
                puts $fp "[ gid_cross_platform::getUsername]"
                puts $fp "[ gid_cross_platform::getHostname]"
                puts $fp "[clock format [clock seconds] -format %Y-%m-%d]"
                flush $fp
                #close $fp ;#to not close it to avoid unwanted manual deletion
                GidLock::SetLockFile $filename_lock $fp
            } else {
                #if cannot create the file consider that don't have write access, consider as read-only
                GidLock::SetReadOnly 1
            }
        }
    }
}

proc GidLock::SetLockFile { filename_lock file_lock } {
    variable _filename_lock
    variable _file_lock
    if { [GiD_Set EnableFileLocking] } {
        set _filename_lock $filename_lock
        set _file_lock $file_lock
        #W "GidLock::SetLockFile $filename_lock"
    }
}

proc GidLock::GetLockFile { } {
   variable _filename_lock
   return $_filename_lock
}

proc GidLock::SetReadOnly { value } {
    variable _read_only
    set _read_only $value
    #W "GidLock::SetReadOnly $value"
}

proc GidLock::GetReadOnly { } {
    variable _read_only
    return $_read_only
}

proc GidLock::CloseLockFile { } {
    variable _file_lock
    if { [GiD_Set EnableFileLocking] } {
        if { $_file_lock != "" } {
            close $_file_lock
            set _file_lock ""
        }
    }
}

proc GidLock::ModelDeleteLockFile {  } {
    if { [GiD_Set EnableFileLocking] } {
        if { [GidLock::GetLockFile] != "" } {
            if { [GidLock::GetReadOnly] } {
                #W "GidLock::ModelDeleteLockFile [GidLock::GetLockFile] do nothing because is read-only"
            } else {
                #W "GidLock::ModelDeleteLockFile [GidLock::GetLockFile]"
                GidLock::CloseLockFile
                file delete [GidLock::GetLockFile]
                GidLock::SetLockFile "" ""
            }
        }
    }
}

proc GidLock::ModelIsInUse { projectname } {
    set is_in_use 0
    set result [list $is_in_use]
    if { [GiD_Set EnableFileLocking] } {
        set filename_lock [file join ${projectname}.gid [file tail $projectname].lck]
        if { [file exists $filename_lock] } {
            #try to delete, if the owner process has not quit then will cannot be deleted because is open and not close
            #to avoid consider lock a model of a broken process
            if { $::tcl_platform(platform) == "windows" } {
                catch { file delete $filename_lock } msg
            } else {
                #on Linux, macOs the opened file is not blocked by the os and will be deleted, the previous approach is not valid to fix the problem that the owner gid has crashed
                package require gid_cross_platform
                set items [split [GidUtils::ReadFile $filename_lock "" 0] \n]
                lassign $items pid username machine date
                if { ![gid_cross_platform::process_exists $pid] } {
                    #delete it only if the process that opened it doesn't exists
                    catch { file delete $filename_lock } msg
                }
            }
        }
        if { [file exists $filename_lock] } {
            #do not consider as in use by the process that is using it
            set items [split [GidUtils::ReadFile $filename_lock "" 0] \n]
            lassign $items pid username machine date
            if { $pid != [pid] } {
                set is_in_use 1
                set result [list $is_in_use $pid $username $machine $date]
            }
        }
    }
    return $result
}
