#Auxiliary procedures to show and handle extra options in the lower frame of the file browser (of gidtkfbox.tcl)
#The proc result must be a variable where to left the state (open or close) of the container frame

array set ::VXLOptions {
    more_options    open
    isov            0
    method,names    { "Marching cubes" "Uniform Hexahedra" "Orthogonal Hexahedra" }
    method,codes    { "mc" "hu" "fd" }
    method,current  0
}

proc VxlOptsChangeMethod { w } {
    set ::VXLOptions(method,current) [$w getvalue]
}

proc BrowserExtraCreateReadVtkVoxels { f } {
    ttk::label $f.liso -text [_ "Iso-surface"]:
    ttk::entry $f.eiso -textvariable ::VXLOptions(isov)
    ttk::label $f.lmet -text [_ "Method"]:
    ComboBox $f.cbmet -values $::VXLOptions(method,names) -editable false -modifycmd [list VxlOptsChangeMethod $f.cbmet]
    $f.cbmet setvalue "@$::VXLOptions(method,current)"
    grid $f.liso $f.eiso $f.lmet $f.cbmet
    return ::VXLOptions(more_options)
}

proc BrowserExtraGetReadVtkVoxels { } {
    set method [lindex $::VXLOptions(method,codes) $::VXLOptions(method,current)]
    set options [list -isovalue:$::VXLOptions(isov) -method:$method --]
    return $options
}

proc BrowserExtraCreateImportShapefile { f } {
    BrowserExtraCreateOptionsImportGeom $f
    if { ![info exists ::ImportShapefileOptions(var,ignore_z)] } {
        set ::ImportShapefileOptions(var,ignore_z) 0
    }
    if { ![info exists ::ImportShapefileOptions(var,out_polylines)] } {
        set ::ImportShapefileOptions(var,out_polylines) 0
    }
    if { ![info exists ::ImportShapefileOptions(var,create_conditions)] } {
        set ::ImportShapefileOptions(var,create_conditions) 0
    }
    if { ![info exists ::ImportShapefileOptions(var,move_z_to_height)] } {
        set ::ImportShapefileOptions(var,move_z_to_height) 0
    }
    if { ![info exists ::ImportShapefileOptions(more_options)] } {
        set ::ImportShapefileOptions(more_options) open
    }
    ttk::checkbutton $f.chkignore_z -text [_ "Ignore z"] -variable ::ImportShapefileOptions(var,ignore_z)
    ttk::checkbutton $f.chkout_polylines -text [_ "Create polylines"] -variable ::ImportShapefileOptions(var,out_polylines)
    ttk::checkbutton $f.chkcreate_conditions -text [_ "Create conditions"] -variable ::ImportShapefileOptions(var,create_conditions)
    ttk::checkbutton $f.chkmove_z_to_height -text [_ "Move z to height"] -variable ::ImportShapefileOptions(var,move_z_to_height)
    grid $f.chkignore_z $f.chkout_polylines $f.chkcreate_conditions $f.chkmove_z_to_height -sticky w
    return ::ImportShapefileOptions(more_options)
}

proc BrowserExtraGetImportShapefile { } {
    set options [list -ignore_z:$::ImportShapefileOptions(var,ignore_z) -out_polylines:$::ImportShapefileOptions(var,out_polylines) \
        -create_conditions:$::ImportShapefileOptions(var,create_conditions) -move_z_to_height:$::ImportShapefileOptions(var,move_z_to_height)]
    lappend options {*}[BrowserExtraGetOptionsImportGeom]
    return $options
}

proc BrowserExtraCreateImportXYZ { f } {
    BrowserExtraCreateOptionsImportGeom $f
    if { ![info exists ::ImportXYZOptions(var,connect)] } {
        set ::ImportXYZOptions(var,connect) 0
    }
    if { ![info exists ::ImportXYZOptions(more_options)] } {
        set ::ImportXYZOptions(more_options) open
    }
    ttk::frame $f.fconnect
    ttk::radiobutton $f.fconnect.rbnotconnect -text [_ "Not connect"] -variable ::ImportXYZOptions(var,connect) -value 0
    ttk::radiobutton $f.fconnect.rbtriangulate -text [_ "Triangulate"] -variable ::ImportXYZOptions(var,connect) -value 1
    ttk::radiobutton $f.fconnect.rbtetrahedrize -text [_ "Tetrahedrize"] -variable ::ImportXYZOptions(var,connect) -value 2
    grid $f.fconnect.rbnotconnect $f.fconnect.rbtriangulate $f.fconnect.rbtetrahedrize -sticky w
    grid $f.fconnect -sticky ew
    return ::ImportXYZOptions(more_options)
}

proc BrowserExtraGetImportXYZ { } {
    set options [list -connect:$::ImportXYZOptions(var,connect)]
    lappend options {*}[BrowserExtraGetOptionsImportGeom]
    return $options
}

#MessageBoxGetFilename more options
array set ::AviMSVCOptions {
    more_options open
    widget ""
    var 0
}

proc BrowserExtraCreateExportAviMSVC { f } {
    ttk::label $f.lqavimsvc -text [_ "Compression option"]:
    if { ![info exists ::AviMSVCOptions(var)] } { set ::AviMSVCOptions(var) 0 }
    set ::AviMSVCOptions(widget) [ttk::checkbutton $f.cbAviMSVCusePrev -text [_ "Use info of previous frame"] -variable ::AviMSVCOptions(var)]
    set ::AviMSVCOptions(var) [ GiD_Set "AviMSVCUsePreviousInfo"]
    grid $f.lqavimsvc $f.cbAviMSVCusePrev -sticky "s"
    if { ![ info exists ::AviMSVCOptions(more_options)]} {
        #trick to show the more options
        set ::AviMSVCOptions(more_options) open
    }
    return ::AviMSVCOptions(more_options)
}

proc BrowserExtraGetExportAviMSVC { } {
    set options [list -avimsvcuseprevious:[$::AviMSVCOptions(widget) get] --]
    return $options
}

array set ::JPEGOptions {
    more_options open
    widget ""
}

proc BrowserExtraCreateExportJPEG { f } {
    ttk::label $f.lquality -text [_ "JPEG quality"]:
    set ::JPEGOptions(widget) \
        [ gidscale $f.quality -from 0 -to 100 -orient "horizontal" \
        -showbuttons 0 ]
    $f.quality set [ GiD_Set "JPEGQuality"]
    grid $f.lquality $f.quality -sticky "s"
    if { ![ info exists ::JPEGOptions(dir)]} {
        #trick to show the more options
        set ::JPEGOptions(more_options) open
    }
    return ::JPEGOptions(more_options)
}

proc BrowserExtraGetExportJPEG { } {
    set options [list -jpegquality:[$::JPEGOptions(widget) get] --]
    return $options
}

array set ::AnimationOptions {
    more_options open
    jpegwidget ""
    msvcwidget ""
    msvc_var 0
}

proc BrowserExtraCreateAnimation { f } {
    ttk::label $f.lquality -text [_ "AVI/msjpg quality"]:
    set ::AnimationOptions(jpegwidget) \
        [ gidscale $f.quality -from 0 -to 100 \
        -showbuttons 0 \
        -orient "horizontal" ]
    $f.quality set [ GiD_Set "JPEGQuality"]
    grid $f.lquality $f.quality -sticky "s" -pady 0 -padx 2
    gridconfigure $f.lquality -sticky w

    ttk::label $f.lqavimsvc -text [_ "AVI/msvc compression"]:
    if { ![info exists ::AnimationOptions(msvc_var)] } { set ::AnimationOptions(msvc_var) 0 }
    set ::AnimationOptions(msvcwidget) [ttk::checkbutton $f.cbAviMSVCusePrev -text [_ "use info of previous frame"] -variable ::AnimationOptions(msvc_var)]
    set ::AnimationOptions(msvc_var) [ GiD_Set "AviMSVCUsePreviousInfo"]
    grid $f.lqavimsvc $f.cbAviMSVCusePrev -sticky "s" -pady 2 -padx 2
    gridconfigure $f.lqavimsvc -sticky w

    if { ![ info exists ::AnimationOptions(more_options)]} {
        #trick to show the more options
        set ::AnimationOptions(more_options) open
    }
    return ::AnimationOptions(more_options)
}

proc BrowserExtraGetAnimation { } {
    set options [list -jpegquality:[ $::AnimationOptions(jpegwidget) get] \
        -avimsvcuseprevious:[ $::AnimationOptions(msvcwidget) get]
    --]
    return $options
}

array set ::GIFOptions {
    more_options open
    widget ""
}

proc BrowserExtraCreateExportGIF { f } {
    set textoAyuda [_ "Dithering uses a noise function to prevent color banding on images."]
    ttk::label $f.ldither -text [_ "Dither mode"]:
    ttk::label $f.ldither2 -text "( $textoAyuda )"
    set fmt [_ "Red %d, Green %d, Blue %d"]
    ttk::radiobutton $f.r1dither -text [_ "None"] -variable ::GIFOptions(dither) -value "None"
    ttk::radiobutton $f.r2dither -text [ format $fmt 6 6 6] -variable ::GIFOptions(dither) -value Dither666
    ttk::radiobutton $f.r3dither -text [ format $fmt 5 9 5] -variable ::GIFOptions(dither) -value Dither595
    set ::GIFOptions(dither) [ GiD_Set "GIFDithering"]
    grid $f.ldither -sticky "ws"
    grid $f.ldither2 -sticky "ws" -columnspan 4
    grid $f.r1dither $f.r2dither $f.r3dither -sticky "ews" -padx 4
    grid configure $f.r1dither -column 1 -row 2
    grid configure $f.r2dither -column 2 -row 2
    grid configure $f.r3dither -column 3 -row 2

    if { ![ info exists ::GIFOptions(more_options)]} {
        #trick to show the more options
        set ::GIFOptions(more_options) open
    }
    return ::GIFOptions(more_options)
}

proc BrowserExtraGetExportGIF { } {
    set options [list -dither:$::GIFOptions(dither) --]
    return $options
}

proc BrowserExtraCreateExportSTL { f } {
    if { ![info exists ::STLOptions(binary)] } {
        set ::STLOptions(binary) [GiD_Set STLExportBinary]
    }
    if { ![info exists ::STLOptions(quads4triangs)] } {
        set ::STLOptions(quads4triangs) [GiD_Set STLQuads4Triangles]
    }
    ttk::label $f.ltype -text [_ "STL file type"]:
    ttk::radiobutton $f.r1type -text [_ "Ascii"] -variable ::STLOptions(binary) -value 0
    ttk::radiobutton $f.r2type -text [_ "Binary"] -variable ::STLOptions(binary) -value 1
    ttk::checkbutton $f.quads4triangs -text [_ "Divide quads to 4 triangles"] -variable ::STLOptions(quads4triangs)

    grid $f.ltype $f.r1type $f.r2type -sticky "ews" -padx 4
    grid configure $f.ltype -sticky "ws"
    grid $f.quads4triangs -sticky "ews" -padx 4 -columnspan 3
    if { ![info exists ::STLOptions(more_options)]} {
        #trick to show the more options
        set ::STLOptions(more_options) open
    }
    return ::STLOptions(more_options)
}

proc BrowserExtraGetExportSTL { } {
    set options [list -binary:$::STLOptions(binary) -quads4triangs:$::STLOptions(quads4triangs) --]
    return $options
}

proc BrowserExtraCreateExportPLY { f } {
    if { ![info exists ::PLYOptions(binary)] } {
        set ::PLYOptions(binary) [GiD_Set "PLYExportBinary"]
    }
    if { ![info exists ::PLYOptions(result2export)] } {
        set ::PLYOptions(result2export) [GiD_Set "PLYResultsToExport"]
    }
    ttk::label $f.ltype -text [_ "PLY file type"]:
    ttk::radiobutton $f.r1type -text [_ "Ascii"] -variable ::PLYOptions(binary) -value 0
    ttk::radiobutton $f.r2type -text [_ "Binary"] -variable ::PLYOptions(binary) -value 1

    # setting 3 columns
    grid $f.ltype $f.r1type $f.r2type -sticky "ews" -padx 4
    grid configure $f.ltype -sticky "ws"

    ttk::label $f.lresult2export -text [_ "Results to export"]:
    ttk::radiobutton $f.r1result2export -text [_ "Current nodal Contour Fill result as texture"] -variable ::PLYOptions(result2export) -value "CurrentResultAsTexture"
    ttk::radiobutton $f.r2result2export -text [_ "All results from current step"] -variable ::PLYOptions(result2export) -value "ResultsCurrentStep"

    grid $f.lresult2export  -sticky "ws" -padx 4 -columnspan 3
    grid $f.r1result2export -sticky "ews" -padx 4 -column 1 -columnspan 2
    grid $f.r2result2export -sticky "ews" -padx 4 -column 1 -columnspan 2

    if { ![ info exists ::PLYOptions(more_options)]} {
        #trick to show the more options
        set ::PLYOptions(more_options) open
    }
    return ::PLYOptions(more_options)
}

proc BrowserExtraGetExportPLY { } {
    set options [list -binary:$::PLYOptions(binary) -result2export:$::PLYOptions(result2export) --]
    return $options
}

proc BrowserExtraCreateImportXYZascii { f } {
    if { ![ info exists ::XYZasciiOptions(comment)]} {
        set ::XYZasciiOptions(comment) ""
    }
    ttk::label $f.lcomment -text [_ "Comments start with"]:
    ttk::entry $f.ecomment -textvariable ::XYZasciiOptions(comment)
    ttk::label $f.lcomment2 -text [_ "until the end of the line."]
    grid $f.lcomment $f.ecomment $f.lcomment2 -sticky "ws" -padx 4
    grid configure $f.ecomment -sticky "ews"

    if { ![ info exists ::XYZasciiOptions(format)]} {
        set ::XYZasciiOptions(format) ""
    }
    ttk::label $f.linputFormat -text [_ "Format of lines"]:
    ttk::entry $f.einputFormat -textvariable ::XYZasciiOptions(format)

    set textoAyuda [_ "Enter format to parse X, Y and Z coordinates\nFor instance:\n\
        \t%g %g %g\t\tto parse X Y Z with spaces in between\n\
        \t%*d %g %g %g\tto skip the initial index\n\
        \t%g, %g, %g\t\tto parse X Y Z with commas"]

    setTooltip $f.einputFormat $textoAyuda
    ttk::button $f.bh -image [ gid_themes::GetImage "help.png" small_icons] \
        -command "showTooltip $f.bh [ list [ list $textoAyuda]]"

    if { ![ info exists ::XYZasciiOptions(delaunay)]} {
        set ::XYZasciiOptions(delaunay) no
    }
    ttk::checkbutton $f.cbDelaunay -text [_ "Create Delaunay mesh after import."] -variable ::XYZasciiOptions(delaunay) -onvalue yes -offvalue no
    set txtDelaunay [_ "Click here to triangulate or tetraedrizate the input point cloud using delaunay."]
    setTooltip $f.cbDelaunay $txtDelaunay

    grid $f.linputFormat $f.einputFormat $f.bh -sticky "w" -padx 4
    grid configure $f.einputFormat -sticky "ew"
    grid $f.cbDelaunay -sticky w -padx 4 -columnspan 3

    if { ![ info exists ::XYZasciiOptions(more_options)]} {
        #trick to show the more options
        set ::XYZasciiOptions(more_options) open
    }
    return ::XYZasciiOptions(more_options)
}

proc BrowserExtraGetImportXYZascii { } {
    set options [list]
    if { [ info exists ::XYZasciiOptions(comment)] && ( $::XYZasciiOptions(comment) != "")} {
        lappend options -commentDelimiter:$::XYZasciiOptions(comment)
    }
    if { [ info exists ::XYZasciiOptions(format)] && ( $::XYZasciiOptions(format) != "")} {
        lappend options -inputFormat:$::XYZasciiOptions(format)
    }
    if { [ info exists ::XYZasciiOptions(delaunay)] && ( $::XYZasciiOptions(delaunay) != "")} {
        lappend options -createDelaunay:$::XYZasciiOptions(delaunay)
    }
    lappend options --
    return $options
}

proc BrowserExtraCreatePostBinaryRead { f } {
    ttk::checkbutton $f.cbDeleteIndex -text [_ "Rebuild binary results index file."] -variable ::PostBinaryReadOpts(rebuildIndex)
    set ::PostBinaryReadOpts(rebuildIndex) 0
    if { ![ info exists ::PostBinaryReadOpts(more_options)]} {
        #trick to show the more options
        set ::PostBinaryReadOpts(more_options) open
    }

    set ::PostBinaryReadOpts(everyXsteps) [GiD_Set PostResultReadEveryXSteps]
    frame $f.every_x_steps -border 0
    label $f.every_x_steps.l -text [_ "Read every X steps:" ]
    ttk::spinbox $f.every_x_steps.sb -width 5 -increment 1.0 -from 1 -to 1000 \
        -textvariable ::PostBinaryReadOpts(everyXsteps)    
    grid $f.every_x_steps.l  $f.every_x_steps.sb -padx 2
    grid $f.cbDeleteIndex $f.every_x_steps -sticky "ews" -padx 4
    return ::PostBinaryReadOpts(more_options)
}

proc BrowserExtraGetPostBinaryRead { } {
    return [list -rebuildIndex:$::PostBinaryReadOpts(rebuildIndex) -everyXsteps:$::PostBinaryReadOpts(everyXsteps) --]
}

proc BrowserExtraCreatePostBinaryMerge { f } {
    ttk::checkbutton $f.cbDeleteIndex -text [_ "Rebuild binary results index file."] -variable ::PostBinaryMergeOpts(rebuildIndex)
    set ::PostBinaryMergeOpts(rebuildIndex) 0
    ttk::checkbutton $f.cbRenumber -text [_ "Renumber nodes and elements."] -variable ::PostBinaryMergeOpts(renumber)
    set ::PostBinaryMergeOpts(renumber) 0
    # grid $f.cbRenumber -sticky "ews" -padx 4
    grid $f.cbDeleteIndex -sticky "ews" -padx 4
    if { ![ info exists ::PostBinaryMergeOpts(dir)]} {
        #trick to show the more options
        set ::PostBinaryMergeOpts(dir) "open"
    }
    return "::PostBinaryMergeOpts(dir)"
}

proc BrowserExtraGetPostBinaryMerge { } {
    set options [list -rebuildIndex:$::PostBinaryMergeOpts(rebuildIndex) -renumber:$::PostBinaryMergeOpts(renumber) --]
    return $options
}

proc OnCheckIfCollapse { } {
    set f $::ImportGeomOptions(widget,f)
    if {$::ImportGeomOptions(var,AutoCollapseAfterImport)} {
        $f.lf.iglayer configure -state "normal"
        $f.lf.autotol configure -state "normal"
        OnCheckAutoTol
    } else {
        $f.lf.iglayer configure -state "disabled"
        $f.lf.autotol configure -state "disabled"
        $f.lf.etol configure -state "disabled"
    }
}

proc OnCheckAutoTol { } {
    set f $::ImportGeomOptions(widget,f)
    set state [expr {$::ImportGeomOptions(var,AutoImportTolerance)?"disabled":"normal"}]
    $f.lf.etol configure -state $state
}

proc BrowserExtraOptionsImportGeomClearCache { } {
    foreach variable [list AutoCollapseAfterImport AutoImportTolerance CollapseAllowMoreTasks CollapseIgnoringLayers ImportTolerance] {
        unset -nocomplain ::ImportGeomOptions(var,$variable)
    }
}

proc BrowserExtraCreateOptionsImportGeom { f } {
    set ::ImportGeomOptions(widget,f) $f
    foreach variable [list AutoCollapseAfterImport AutoImportTolerance CollapseAllowMoreTasks CollapseIgnoringLayers ImportTolerance] {
        if { ![info exists ::ImportGeomOptions(var,$variable)] } {
            set ::ImportGeomOptions(var,$variable) [GiD_Set $variable]
        }
    }
    ttk::checkbutton $f.chkCollapse -text [_ "Automatic collapse after import"] -variable ::ImportGeomOptions(var,AutoCollapseAfterImport) -command OnCheckIfCollapse
    ttk::labelframe $f.lf -labelwidget $f.chkCollapse
    ttk::checkbutton $f.lf.autotol -text [_ "Use automatic collapse tolerance"] -variable ::ImportGeomOptions(var,AutoImportTolerance) -command OnCheckAutoTol
    ttk::label $f.lf.ltol -text [_ "Tolerance"]:
    ttk::entry $f.lf.etol -textvariable ::ImportGeomOptions(var,ImportTolerance)
    ttk::checkbutton $f.lf.iglayer -text [_ "Collapse ignoring layers"] -variable ::ImportGeomOptions(var,CollapseIgnoringLayers)
    ttk::checkbutton $f.lf.collapse_allow_more_tasks -text [_ "Collapse allow more tasks"] -variable ::ImportGeomOptions(var,CollapseAllowMoreTasks)

    OnCheckIfCollapse
    grid columnconfigure $f 1 -weight 1
    grid $f.lf.autotol -sticky w -columnspan 2
    grid $f.lf.ltol $f.lf.etol
    grid $f.lf.iglayer $f.lf.collapse_allow_more_tasks -sticky w
    grid $f.lf -sticky "snew" -columnspan 3
    if { ![info exists ::ImportGeomOptions(more_options)] } {
        set ::ImportGeomOptions(more_options) open
    }
    return ::ImportGeomOptions(more_options)
}

proc BrowserExtraGetOptionsImportGeom { } {
    global ImportGeomOptions
    set options [list -collapse:$::ImportGeomOptions(var,AutoCollapseAfterImport) \
        -autotol:$::ImportGeomOptions(var,AutoImportTolerance) \
        -tolerance:$::ImportGeomOptions(var,ImportTolerance) \
        -ignorelayer:$::ImportGeomOptions(var,CollapseIgnoringLayers) \
        -collapse_allow_more_tasks:$::ImportGeomOptions(var,CollapseAllowMoreTasks) \
        --
    ]
    return $options
}

proc BrowserExtraCreateSaveAs { f } {
    global SaveAs
    if { ![info exists ::SaveAs(include_results)] } {
        set ::SaveAs(include_results) 1
    }
    if { ![info exists ::SaveAs(old_format)] } {
        set ::SaveAs(old_format) 0
    }
    if { ![info exists ::SaveAs(ASCII)] } {
        set ::SaveAs(ASCII) 0
    }
    ttk::checkbutton $f.alsores -text [_ "Include results"] -variable ::SaveAs(include_results)
    ttk::checkbutton $f.old_format -text [_ "Old %s project" $::GidPriv(ProgName)] -variable ::SaveAs(old_format)
    ttk::checkbutton $f.ascii -text [_ "ASCII"] -variable ::SaveAs(ASCII)
    grid $f.alsores $f.old_format $f.ascii -sticky w
    if { ![info exists ::SaveAs(more_options)] } {
        #trick to show the more options, could be open or close
        set ::SaveAs(more_options) open
    }
    return ::SaveAs(more_options)
}

#not delete this proc because can be called from C++ with old style
proc BrowserExtraGetSaveAs { } {
    global SaveAs
    set options [list]
    lappend options -alsoresults:$::SaveAs(include_results)
    if { $::SaveAs(old_format) } {
        lappend options -geoversion:2.24
    } else {
        lappend options -geoversion:current
    }
    if { $::SaveAs(ASCII) } {
        lappend options -ascii:1
    }
    lappend options --
    return $options
}

proc BrowserExtraCreateImportNastran { f } {
    global BrowserOptionsImportNastran
    if { ![info exists ::BrowserOptionsImportNastran(append)] } {
        set ::BrowserOptionsImportNastran(append) 1
    }
    ttk::checkbutton $f.cb_append -text [_ "Append"] -variable ::BrowserOptionsImportNastran(append)
    grid $f.cb_append -sticky "ews" -padx 4
    if { ![ info exists ::BrowserOptionsImportNastran(more_options)]} {
        set ::BrowserOptionsImportNastran(more_options) open ;#trick to show the more options
    }
    return ::BrowserOptionsImportNastran(more_options)
}


#if existe mesh append before the filename the extra word Append or Erase

proc BrowserExtraCreateImportMeshCommon { f } {
    if { ![info exists ::BrowserOptionsImportMeshCommon(append)] } {
        set ::BrowserOptionsImportMeshCommon(append) 1
    }
    ttk::checkbutton $f.cb_append -text [_ "Append"] -variable ::BrowserOptionsImportMeshCommon(append)
    grid $f.cb_append -sticky "ews" -padx 4
    if { ![ info exists ::BrowserOptionsImportMeshCommon(more_options)]} {
        set ::BrowserOptionsImportMeshCommon(more_options) open ;#trick to show the more options
    }
    return ::BrowserOptionsImportMeshCommon(more_options)
}

proc BrowserExtraGetOptionsImportMeshCommon { } {
    set options [list]
    if { [GidUtils::ExistsMesh] } {
        if { $::BrowserOptionsImportMeshCommon(append) } {
            lappend options Append
        } else {
            lappend options Erase
        }
    }
    return $options
}

proc BrowserExtraCreateGIDMeshReadOptions { f } {
    BrowserExtraCreateImportMeshCommon $f
    ttk::checkbutton $f.cbDeleteIndex -text [_ "Read different meshes in separate layers."] -variable ::BrowserOptionsGIDMeshRead(CreateLayers))
    set ::BrowserOptionsGIDMeshRead(CreateLayers) 0
    grid $f.cbDeleteIndex -sticky "ews" -padx 4
    if { ![ info exists ::BrowserOptionsGIDMeshRead(more_options)]} {
        #trick to show the more options
        set ::BrowserOptionsGIDMeshRead(more_options) open
    }
    return ::BrowserOptionsGIDMeshRead(more_options)
}

proc BrowserExtraGetGIDMeshReadOptions { } {
    set options [BrowserExtraGetOptionsImportMeshCommon]
    lappend options -createLayers:$::BrowserOptionsGIDMeshRead(CreateLayers) --
    return $options
}

proc OnCheckFarPointsNodata { } {
    set f $::ExportRASTEROptions(widget,f)
    set state [expr {$::ExportRASTEROptions(var,far_points_set_nodata)?"normal":"disabled"}]
    $f.etol configure -state $state
}

proc BrowserExtraCreateExportMesh { f } {
    if { ![info exists ::ExportMeshOptions(more_options)] } {
        set ::ExportMeshOptions(more_options) open
    }
    if { ![info exists ::ExportMeshOptions(var,export_mesh_by_entities)] } {
        set ::ExportMeshOptions(var,export_mesh_by_entities) 0
    }
    ttk::checkbutton $f.cbexport_mesh_by_entities -text [_ "Export mesh by entities"] -variable ::ExportMeshOptions(var,export_mesh_by_entities)
    GidHelp $f.cbexport_mesh_by_entities [_ "If selected then export a mesh by geometric entity, if available"]
    grid $f.cbexport_mesh_by_entities -sticky w -padx 2
    return ::ExportMeshOptions(more_options)
}

proc BrowserExtraGetExportMesh { } {
    set options [list]
    lappend options -export_mesh_by_entities:$::ExportMeshOptions(var,export_mesh_by_entities) --
    return $options
}

proc BrowserExtraCreateExportRASTER { f } {
    set ::ExportRASTEROptions(widget,f) $f
    if { ![info exists ::ExportRASTEROptions(more_options)] } {
        set ::ExportRASTEROptions(more_options) open
    }
    if { ![info exists ::ExportRASTEROptions(var,far_points_set_nodata)] } {
        set ::ExportRASTEROptions(var,far_points_set_nodata) 0
    }
    if { ![info exists ::ExportRASTEROptions(var,far_points_distance)] } {
        set ::ExportRASTEROptions(var,far_points_distance) 0.0
    }
    ttk::checkbutton $f.cbfar_points_set_nodata -text [_ "Far points set nodata"] -variable ::ExportRASTEROptions(var,far_points_set_nodata) -command OnCheckFarPointsNodata
    GidHelp $f.cbfar_points_set_nodata [_ "If selected then grid points far (of distance) of nodes will have special nodata value instead an interpolated z, and won't generate cells"]
    ttk::label $f.ltol -text [_ "Distance"]:
    ttk::entry $f.etol -textvariable ::ExportRASTEROptions(var,far_points_distance)
    grid $f.cbfar_points_set_nodata $f.ltol $f.etol -sticky w -padx 2
    OnCheckFarPointsNodata
    return ::ExportRASTEROptions(more_options)
}

proc BrowserExtraGetExportRASTER { } {
    set options [list -far_points_set_nodata:$::ExportRASTEROptions(var,far_points_set_nodata)]
    lappend options -far_points_distance:$::ExportRASTEROptions(var,far_points_distance) --
    return $options
}

array set ::HDF5GidPost {
    more_options    open
    write_double_precision   false
}

proc BrowserExtraCreateExportHDF5GidPost { f } {
    ttk::checkbutton $f.post_h5_precission -text [_ "Write double precision"] -variable ::HDF5GidPost(write_double_precision)
    set textoAyuda [_ "Dithering uses a noise function to prevent color banding on images."]
    grid $f.post_h5_precission -sticky "ws"

    # get previous / default value
    set ::HDF5GidPost(write_double_precision) [ GiD_Set Hdf5gidpostWriteDoublePrecision]
    if { ![info exists ::HDF5GidPost(more_options)] } {
        # trick to show the more options
        set ::HDF5GidPost(more_options) open
    }
    return ::HDF5GidPost(more_options)
}

proc BrowserExtraGetExportHDF5GidPost { } {
    set options [list -hdf5gidpost_write_double_precision:$::HDF5GidPost(write_double_precision) --]
    return $options
}
