
#Boton o Canvas
#set ::VREPriv(usa) Boton
set ::VREPriv(usa) Canvas

set ::VREPriv(ClockImagen) 0

set ::VREPriv(Debug)   0

proc EscogeLoQueToca { w title var {file_types ""}} {
    upvar $var initial_filename
    set d [MessageBoxGetFilename file read $title $initial_filename $file_types] 	      
    if { $d != ""} {
	   set $var $d
    }
}

proc EstadoRestoFileFrame { w var_estado} {
    upvar $var_estado estado
    if { !$estado} {
	$w.e1 configure -state readonly
	$w.b1 configure -state disabled
    } elseif { $estado} {
	$w.e1 configure -state normal
	$w.b1 configure -state normal
    }
}

proc CheckFileFrame { w txt var_check var_file {filtro ""}} {
    upvar $var_check contenido_check    
    upvar $var_file contenido_file

    ttk::frame $w -borderwidth 0
    #label $w.l1 -text $txt
    if { ![info exists $var_check] } { set $var_check 0 }
    ttk::checkbutton $w.cb -text $txt -variable $var_check \
	-onvalue 1 -offvalue 0 -command "EstadoRestoFileFrame $w $var_check"
    ttk::entry $w.e1 -textvariable $var_file
    #grid $w.l1 $w.e1 -sticky en -padx 4 -pady 2
    #button $w.b1 -image $::VREPriv(img_$tipo) -height 16 \
	#-command "set $var_check 1; EscogeLoQueToca $w [ list $txt] $var_file $tipo [ list $filtro]"
	
	ttk::button $w.b1 -image [gid_themes::GetImage folder.png small_icons] \
	-command "set $var_check 1; EscogeLoQueToca $w [ list $txt] $var_file [ list $filtro]"
	
    #grid $w.l1 $w.e1 $w.b1 -sticky en -padx 2 -pady 2
    grid $w.cb $w.e1 $w.b1 -sticky en -padx 2 -pady 2
    grid configure $w.e1 -sticky ewn
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 1 -weight 1
    return $w
}

proc EstadoCheckFileFrame { w estado} {
    if { $estado == "disabled"} {
	$w.cb configure -state normal
	$w.e1 configure  -state readonly -foreground grey60
	$w.b1 configure  -state disabled
    } elseif { $estado == "normal"} {
	$w.cb configure -state normal
	$w.e1 configure -state normal -foreground black
	$w.b1 configure -state normal
    }
}


proc VRETodosIguales { } {
    set raiz $::VREPriv(ArchivosIguales,RaizWidget)
    set estado normal
    if { $::VREPriv(ArchivosIguales)} {
	set estado disabled
    }
    EstadoCheckFileFrame ${raiz}Left normal
    foreach i "Right Top Bottom Back Front" {
	EstadoCheckFileFrame $raiz$i $estado
    }
}

proc EstadoFrameArchivos { w estado} {
    if { $estado == "disabled"} {
	$w.cb configure -state disabled
	set raiz $::VREPriv(ArchivosIguales,RaizWidget)
	foreach i "Left Right Top Bottom Back Front" {
	    EstadoCheckFileFrame $raiz$i disabled
	}
    } elseif { $estado == "normal"} {
	$w.cb configure -state normal
	set raiz $::VREPriv(ArchivosIguales,RaizWidget)
	foreach i "Left Right Top Bottom Back Front" {
	    EstadoCheckFileFrame $raiz$i normal
	}
    }
}

proc EstadoFramePatron { w estado} {
    if { $estado == "disabled"} {
	$w.resolucion.rd1 configure -state disabled
	$w.resolucion.rd2 configure -state disabled
	$w.resolucion.rd3 configure -state disabled
	if { $::VREPriv(usa) == "Boton"} {
	    $w.muestra configure -state disabled
	} elseif { $::VREPriv(usa) == "Canvas"} {
	    foreach lid { $w.muestra find all} {
		$w.muestra itemconfigure $lid -fill grey60
	    }
	    $w.muestra configure -state disabled
	}
	foreach i {1 2 3 4 5 6} {
	    $w.p$i configure -state disabled
	}
	$w.fcol.bg configure -state disabled
	$w.fcol.fg configure -state disabled
	$w.fcol.sc configure -state disabled
	foreach i "Left Right Top Bottom Back Front" {
	    $w.fQCaras.cb$i configure -state disabled
	}
    } elseif { $estado == "normal"} {
	$w.resolucion.rd1 configure -state normal
	$w.resolucion.rd2 configure -state normal
	$w.resolucion.rd3 configure -state normal
	if { $::VREPriv(usa) == "Boton"} {
	    $w.muestra configure -state disabled
	} elseif { $::VREPriv(usa) == "Canvas"} {
	    foreach lid { $w.muestra find all} {
		$w.muestra itemconfigure $lid -fill $::VREPriv(Patron,FG)
	    }
	    $w.muestra configure -state normal
	}
	foreach i {1 2 3 4 5 6} {
	    $w.p$i configure -state normal
	}
	$w.fcol.bg configure -state normal
	$w.fcol.fg configure -state normal
	$w.fcol.sc configure -state normal
	foreach i "Left Right Top Bottom Back Front" {
	    $w.fQCaras.cb$i configure -state normal
	}
    }
}

proc VRECambiaEstadoLabelFrames { } {
#para que actualize el canvas
update
update idletasks

    set w1 $::VREPriv(Archivos,frame)
    set w2 $::VREPriv(Patron,frame)
    if { $::VREPriv(TipoDatos) == "Files" } {
	EstadoFrameArchivos $w1 normal
	EstadoFramePatron $w2 disabled
	VRETodosIguales
    } elseif { $::VREPriv(TipoDatos) == "Data" } {
	EstadoFrameArchivos $w1 disabled
	EstadoFramePatron $w2 normal
    }
}

proc ConvierteMapaImagenAPPM { id_img} {
    upvar img $id_img
    set ppm "P6\n$img(ancho) $img(alto)\n255\n"

    set ascii ""
    for { set y 0} { $y < $img(alto)} { incr y} {
	for { set x 0} { $x < $img(ancho)} { incr x} {
	    append ascii " $img($x,$y)"
	}
    }
    append ppm [ binary format c* $ascii]
    return $ppm
}

proc ConvierteStringImagenAPPM { ancho alto img} {
    set ppm "P6\n$ancho $alto\n255\n"

    append ppm [ binary format c* $img]
    return $ppm
}

proc VRECreaImagenPatron { tam tipo { invertido 0}} {
    set hay_vertical 0
    set hay_horizontal 0
    set hay_dividir 0
    set hay_contrabarra 0
    switch -- $tipo {
	"-" {
	    set hay_horizontal 1
	}
	"|" {
	    set hay_vertical 1
	}
	"+" {
	    set hay_horizontal 1
	    set hay_vertical 1
	}
	"/" {
	    set hay_dividir 1
	}
	"\\" {
	    set hay_contrabarra 1
	}
	"x" {
	    set hay_dividir 1
	    set hay_contrabarra 1
	}
	"X" {
	    set hay_dividir 1
	    set hay_contrabarra 1
	}
    }
    scan $::VREPriv(Patron,FG) \#%2x%2x%2x r g b
    set col_fg "$r $g $b"
    scan $::VREPriv(Patron,BG) \#%2x%2x%2x r g b
    set col_bg "$r $g $b"
    if { $invertido} {
	set tt $col_fg
	set col_fg $col_bg
	set col_bg $tt
    }
    set cada_cuanto [ expr $::VREPriv(EspacioEntreLineas) + 1]
    if { $::VREPriv(ClockImagen)} {
	set antes [ clock seconds]
    }

    set ancho $tam
    set alto $tam
    set fin [ expr $alto * $ancho]
    set img ""
    #set img {}
    set ix 0
    set iy 0
    set iiy 0
    for { set y 0} { $y < $alto} { incr y} {
	set ix 0
	for { set x 0} { $x < $ancho} { incr x} {
	    set col $col_bg
	    if { $hay_horizontal && !$ix} {
		set col $col_fg
	    }
	    if { $hay_vertical && !$iy} {
		set col $col_fg
	    }
	    if { $hay_dividir } {
		if { $ix == $iiy} {
		    set col $col_fg
		}
	    }
	    if { $hay_contrabarra} {
		if { $ix == $iy} {
		    set col $col_fg
		}
	    }
	    append img " $col"
	    #lappend img $col
	
	    incr ix
	    if { $ix == $cada_cuanto} { set ix 0}
	}
	incr iy
	if { $iy == $cada_cuanto} { set iy 0}
	if { $iiy == 0} { set iiy $cada_cuanto}
	incr iiy -1
    }
    if { $::VREPriv(ClockImagen)} {
	set medio [ clock seconds]
    }
    set ppmimg [ ConvierteStringImagenAPPM $ancho $alto $img]
    #set ppmimg [ ConvierteStringImagenAPPM $ancho $alto [ join $img]]

    if { $::VREPriv(ClockImagen)} {
	set despues [ clock seconds]
	set medio1 [ clock format [ expr $medio - $antes] -format %M:%S]
	set medio2 [ clock format [ expr $despues - $medio] -format %M:%S]
	set total [ clock format [ expr $despues - $antes] -format %M:%S]
	WarnWinText "$tam $tipo = ${medio1} + ${medio2} = ${total}s."
    }
    unset img
    return $ppmimg
}

proc VREPintaPatron { w tam tipo { invertido 0}} {
    set hay_vertical 0
    set hay_horizontal 0
    set hay_dividir 0
    set hay_contrabarra 0
    switch -- $tipo {
	"-" {
	    set hay_horizontal 1
	}
	"|" {
	    set hay_vertical 1
	}
	"+" {
	    set hay_horizontal 1
	    set hay_vertical 1
	}
	"/" {
	    set hay_dividir 1
	}
	"\\" {
	    set hay_contrabarra 1
	}
	"x" {
	    set hay_dividir 1
	    set hay_contrabarra 1
	}
	"X" {
	    set hay_dividir 1
	    set hay_contrabarra 1
	}
    }
    scan $::VREPriv(Patron,FG) \#%2x%2x%2x r g b
    set col_fg "$r $g $b"
    scan $::VREPriv(Patron,BG) \#%2x%2x%2x r g b
    set col_bg "$r $g $b"
    if { $invertido} {
	set tt $col_fg
	set col_fg $col_bg
	set col_bg $tt
    }
    set cada_cuanto [ expr $::VREPriv(EspacioEntreLineas) + 1]

    set estado_ant [ $w get -state]
    $w configure -state normal

    $w delete all
    $w configure -background $::VREPriv(Patron,BG)

    set ancho $tam
    set alto $tam

    if { $hay_horizontal} {
	for { set x 0} { $x < $ancho} { incr x $cada_cuanto} {
	    $w create line $x 0 $x $alto
	}
    }
    if { $hay_vertical} {
	for { set y 0} { $y < $alto} { incr y $cada_cuanto} {
	    $w create line 0 $y $ancho $y
	}
    }
    if { $hay_dividir} {
	set fin -$alto
	for { set y 0} { $y <= [ expr 2 * $alto]} { incr y $cada_cuanto} {
	    $w create line 0 $y $ancho $fin
	    incr fin $cada_cuanto
	}
    }
    if { $hay_contrabarra} {
	set fin $alto
	set fin2 $alto
	for { set y 0} { $y < $alto} { incr y $cada_cuanto} {
	    $w create line 0 $y $ancho $fin
	    $w create line 0 -$y $ancho $fin2
	    incr fin $cada_cuanto
	    incr fin2 -$cada_cuanto
	}
    }

    $w configure -state $estado_ant
}

proc VREActualizaPatronMuestra { { p ""}} {
    set bm $::VREPriv(Patron,Muestra,wid)
    if { $p == ""} {
	if { [ info exists ::VREPriv(Patron,Tipo)]} {
	    if { $::VREPriv(Patron,Tipo) == "Personal"} {
		return
	    }
	    set p $::VREPriv(Patron,Tipo)
	}
    }

    if { $::VREPriv(usa) == "Boton"} {
	set img_nueva [ image create photo -data [ VRECreaImagenPatron 128 $p]]
	$bm configure -image $img_nueva
	if { [ info exists ::VREPriv(Patron,Muestra)]} {
	    image delete $::VREPriv(Patron,Muestra)
	}
	set ::VREPriv(Patron,Muestra) $img_nueva
    } elseif { $::VREPriv(usa) == "Canvas"} {
	VREPintaPatron $bm 128 $p
    }
    set ::VREPriv(Patron,Tipo) $p
}

proc VREActualizaImagenMuestra { img_nueva} {
    set bm $::VREPriv(Patron,Muestra,wid)

    $bm configure -image $img_nueva
    if { [ info exists ::VREPriv(Patron,Muestra)]} {
	image delete $::VREPriv(Patron,Muestra)
    }
    set ::VREPriv(Patron,Muestra) $img_nueva
    #set ::VREPriv(Patron,Tipo) "Personal"
}

proc VREActualizaBotonesPatrones { w} {
    if { ![winfo exists $w] } {
	return
    }
    foreach i {1 2 3 4 5 6} p {| - + / \\ x} {
	set img_nueva [ image create photo -data [ VRECreaImagenPatron 16 $p]]
	$w$i configure -image $img_nueva
	if { [ info exists ::VREPriv(Patron$p)]} {
	    image delete $::VREPriv(Patron$p)
	}
	set ::VREPriv(Patron$p) $img_nueva
    }
}

proc VREInicializarVariables { } {
    global GIDDEFAULT

    if { [ info exists ::VREPriv(Inicializado)] && $::VREPriv(Inicializado)} {
	return
    }
    set ::VREPriv(Inicializado) 1

    # On o Off
    set ::VREPriv(HayReflejoEntorno) Off
    # RE_IZQUIERDA = 0, RE_DERECHA = 1, RE_ARRIBA = 2, RE_ABAJO = 3, RE_DETRAS = 4, RE_DELANTE = 5;
    foreach i "Left Right Top Bottom Back Front" {
	set ::VREPriv(Archivo,$i) ""
	set ::VREPriv(Usa,$i) 1
    }
    set ::VREPriv(PerspectiveMode) NORMAL
    set ::VREPriv(PerspectiveModeAnterior) $::VREPriv(PerspectiveMode)
    set ::VREPriv(ModoRender) Nice

    set ::VREPriv(ArchivosIguales) 0

    if { ![ info exists ::VREPriv(Patron,FG)]} {
	set ::VREPriv(Patron,FG) \#000000
    }
    if { ![ info exists ::VREPriv(Patron,BG)]} {
	set ::VREPriv(Patron,BG) \#ffffff
    }

    # puede ser Files o Dara
    set ::VREPriv(TipoDatos) Files

    set ::VREPriv(EspacioEntreLineas) 6

    set ::VREPriv(Patron,Tamanyo) 128

    set ::VREPriv(Aplicando) 0

    set ::VREPriv(UseLayerColor) Yes
    set ::VREPriv(Color1) \#cc33cc
    set ::VREPriv(Color2) \#33cc33
}

proc VREActualizaVariables { } {
    global tcl_platform

    if { [ info exists ::VREPriv(Aplicando)] && $::VREPriv(Aplicando)} {
	    return
    }
    if { ![winfo exists .gid.wEnvironmentReflection] } {
	return
    }


    # NORMAL o PERSPECTIVE
    set ::VREPriv(PerspectiveMode) [ GiD_Info perspectivemode ]
    set ::VREPriv(PerspectiveModeAnterior) $::VREPriv(PerspectiveMode)

    set reflejo [ GiD_Reflection get state]

    # On o Off, Fast o Nice, Files o Data, UseLayerColor Yes/no, Color1&2
    set ::VREPriv(HayReflejoEntorno) [ lindex $reflejo 0]
    set ::VREPriv(ModoRender) [ lindex $reflejo 1]

    set ::VREPriv(UseLayerColor) [ lindex [ lindex $reflejo 3] 1]
    set ::VREPriv(Color1) [ lindex [ lindex $reflejo 4] 0]
    set ::VREPriv(Color2) [ lindex [ lindex $reflejo 4] 1]
    $::VREPriv(CarasVacias,frame).fcol.col1 configure -background $::VREPriv(Color1)
    $::VREPriv(CarasVacias,frame).fcol.col2 configure -background $::VREPriv(Color2)

    set archivos [ GiD_Reflection get files]
    set archivo0 [ lindex $archivos 0]
    set todos_iguales 1
    foreach i {Left Right Top Bottom Back Front} f $archivos {
	set ::VREPriv(Archivo,$i) $f
	if { $::tcl_platform(platform) == "windows" } {
	    if { ![ string equal -nocase $archivo0 $f]} {
		set todos_iguales 0
	    }
	} else {
	    if { ![ string equal $archivo0 $f]} {
		set todos_iguales 0
	    }
	}
	if { [ llength $f]} {
	    set ::VREPriv(Usa,$i) 1
	} else {
	    # no hay archivo es cara_2_colores
	    set ::VREPriv(Usa,$i) 0
	}
    }

    set ::VREPriv(ArchivosIguales) $todos_iguales
    VRETodosIguales

    set ::VREPriv(TipoDatos) [ lindex $reflejo 2]
    if { $::VREPriv(TipoDatos) == "Data"} {
	# todas las caras son iguales, al menos en esta ventana
	set lst_ppm [ GiD_Reflection get data]
	if { $::VREPriv(usa) == "Boton"} {
	    set ppm [ lindex $lst_ppm 0]
	    set mm [ image create photo -data $ppm]
	    VREActualizaImagenMuestra $mm
	    #toplevel .qwerty
	    #button .qwerty.b -image $mm
	    #button .qwerty.c -text close -command "destroy .qwerty"
	    #pack .qwerty.b
	    #pack .qwerty.c
	}
	foreach i {Left Right Top Bottom Back Front} data $lst_ppm {
	if { [ llength $data]} {
	    set ::VREPriv(Usa,$i) 1
	} else {
	    # no hay datos es cara_2_colores
	    set ::VREPriv(Usa,$i) 0
	}
	}
    } else {
	VREActualizaPatronMuestra +
    }

    VRECambiaEstadoLabelFrames

    foreach iv {PerspectiveMode HayReflejoEntorno ModoRender TipoDatos UseLayerColor Color1 Color2} {
	set ::VREPriv(Old,$iv) $::VREPriv($iv)
    }
    foreach iv {Left Right Top Bottom Back Front} {
	set ::VREPriv(Old,Archivo,$iv) $::VREPriv(Archivo,$iv)
    }

}

proc VREAplicar { } {

    set ::VREPriv(Aplicando) 1

    if { $::VREPriv(Old,PerspectiveMode) != $::VREPriv(PerspectiveMode)} {
	GiD_Process 'Projection $::VREPriv(PerspectiveMode)
	set ::VREPriv(Old,PerspectiveMode) $::VREPriv(PerspectiveMode)
    }

    if { $::VREPriv(Old,ModoRender) != $::VREPriv(ModoRender)} {
	GiD_Process 'Render ReflectEnvironment Render$::VREPriv(ModoRender)
	set ::VREPriv(Old,ModoRender) $::VREPriv(ModoRender)
    }

    set hay_cambios 0
    if { $::VREPriv(Old,TipoDatos) != $::VREPriv(TipoDatos)} {
	set res [ GiD_Reflection set type $::VREPriv(TipoDatos)]
	if { $res != ""} {
	    WarnWin $res
	}
	set ::VREPriv(Old,TipoDatos) $::VREPriv(TipoDatos)
	set hay_cambios 1
    }
    if { $::VREPriv(TipoDatos) == "Files" } {
	foreach iv {Left Right Top Bottom Back Front} {
	    if { $::VREPriv(Usa,$iv)} {
		set nuevo_archivo $::VREPriv(Archivo,$iv)
		if { $::VREPriv(ArchivosIguales)} {
		    set nuevo_archivo $::VREPriv(Archivo,Left)
		}
		#if { $::VREPriv(Old,Archivo,$iv) != $nuevo_archivo} {
		    GiD_Process 'Render ReflectEnvironment ${iv}Image $nuevo_archivo
		    set ::VREPriv(Old,Archivo,$iv) $nuevo_archivo
		    set hay_cambios 1
		#}
	    } else {
		GiD_Process 'Render ReflectEnvironment ${iv}2colors
		set hay_cambios 1
	    }
	}
    } elseif { $::VREPriv(TipoDatos) == "Data"} {	
	set ppm [ image create photo -data \
		      [ VRECreaImagenPatron $::VREPriv(Patron,Tamanyo) $::VREPriv(Patron,Tipo)]]
	set res [ GiD_Reflection set data [ list $ppm]]
	image delete $ppm
	if { $res != ""} {
	    WarnWin $res
	}
	foreach iv {Left Right Top Bottom Back Front} {
	    if { !$::VREPriv(Usa,$iv)} {
		GiD_Process 'Render ReflectEnvironment ${iv}2colors
	    }
	}
	set hay_cambios 1
    }

    foreach prop "UseLayerColor Color1 Color2" {
	if { $::VREPriv(Old,$prop) != $::VREPriv($prop)} {
	    GiD_Process 'Render ReflectEnvironment $prop $::VREPriv($prop)
	}
    }

    if { $hay_cambios} {
	GiD_Process 'Render ReflectEnvironment Actualise
    }

    if { $::VREPriv(Old,HayReflejoEntorno) != $::VREPriv(HayReflejoEntorno)} {
	GiD_Process 'Render ReflectEnvironment $::VREPriv(HayReflejoEntorno)
	set ::VREPriv(Old,HayReflejoEntorno) $::VREPriv(HayReflejoEntorno)
    }

    set ::VREPriv(Aplicando) 0
    VREActualizaVariables
}

proc VREReload { w} {
    destroy $w
    EnvironmentReflectionWindow
}

proc VERVerificaPerspectiva { wcb } {
    set modo_deseado "PERSPECTIVE"

    # restauramos el valor anterior de la perspectiva cuando desactivamos el reflejo
    if { $::VREPriv(HayReflejoEntorno) == "Off"} {
	set modo_deseado $::VREPriv(PerspectiveModeAnterior)
    }

    if { $::VREPriv(PerspectiveMode) != $modo_deseado} {
	$wcb invoke
    }
}

proc EnvironmentReflectionWindow { { w .gid.wEnvironmentReflection }} {

    InitWindow2 $w -title [_ "Environment reflection"] \
        -geometryvariable PrePostEnvironmentReflectionWindowGeom \
        -initcommand EnvironmentReflectionWindow  \
        -ontop
   
    VREInicializarVariables

    ttk::frame $w.f -border 0 -style ridge.TFrame
    ttk::frame $w.f.fVista -border 0 -style groove.TFrame

    if { ![info exists ::VREPriv(HayReflejoEntorno)] } { set ::VREPriv(HayReflejoEntorno) Off }
    ttk::checkbutton $w.f.fVista.cb1 -text [_ "Reflection"] -variable ::VREPriv(HayReflejoEntorno) \
	-onvalue On -offvalue Off -command "VERVerificaPerspectiva $w.f.fVista.persp.cb2"

    ttk::frame $w.f.fVista.persp -borderwidth 0
    if { ![info exists ::VREPriv(PerspectiveMode)] } { set ::VREPriv(PerspectiveMode) NORMAL }
    ttk::checkbutton $w.f.fVista.persp.cb2 -text [_ "Perspective"] -variable ::VREPriv(PerspectiveMode) \
	-onvalue PERSPECTIVE -offvalue NORMAL

    ttk::button $w.f.fVista.persp.bp -text "-->" -command PerspectiveW

    grid $w.f.fVista.persp.cb2 $w.f.fVista.persp.bp -sticky en
    grid configure $w.f.fVista.persp.bp -sticky wn
    grid rowconfigure $w.f.fVista.persp 0 -weight 1
    grid columnconfigure $w.f.fVista.persp 0 -weight 1

    ttk::label $w.f.fVista.l2 -text [_ "Render"]:
    ttk::radiobutton $w.f.fVista.rd1 -text [_ "Sharp"] -variable ::VREPriv(ModoRender) -value Fast
    ttk::radiobutton $w.f.fVista.rd2 -text [_ "Smooth"] -variable ::VREPriv(ModoRender) -value Nice

    grid $w.f.fVista.cb1 $w.f.fVista.persp $w.f.fVista.l2 $w.f.fVista.rd1 $w.f.fVista.rd2 \
	-sticky nw -padx 4 -pady 1
    grid configure $w.f.fVista.l2 -sticky ne -padx 2 -pady 2
    grid configure $w.f.fVista.rd1 $w.f.fVista.rd2 -padx 2
    grid rowconfigure $w.f.fVista 0 -weight 1
    #grid columnconfigure $w.f.fVista 0 -weight 1
    #grid columnconfigure $w.f.fVista 1 -weight 1
    grid columnconfigure $w.f.fVista 2 -weight 1

    # opcion archivos
    ttk::radiobutton $w.f.rd1 -variable ::VREPriv(TipoDatos) -value Files \
	-text [_ "Environment files"]: -command VRECambiaEstadoLabelFrames
    set ::VREPriv(Archivos,frame) $w.f.fFiles
    ttk::labelframe $w.f.fFiles -labelwidget $w.f.rd1

    set ::VREPriv(ArchivosIguales,RaizWidget) $w.f.fFiles.ar
    if { ![info exists ::VREPriv(ArchivosIguales)] } { set ::VREPriv(ArchivosIguales) 0 }
    ttk::checkbutton $w.f.fFiles.cb -text [_ "All the same"] -variable ::VREPriv(ArchivosIguales) \
	-onvalue 1 -offvalue 0 -command VRETodosIguales
    grid $w.f.fFiles.cb -sticky wn

    foreach i "Left Right Top Bottom Back Front" {
	CheckFileFrame $::VREPriv(ArchivosIguales,RaizWidget)$i [_ "%s image" $i]: ::VREPriv(Usa,$i) \
	    ::VREPriv(Archivo,$i) \
	    [ list [ list [_ "Image"] {.bmp .jpg .jpeg .ppm .png .tga .tif .tiff}] \
		  [ list [_ "All files"] {*}]]
	grid $w.f.fFiles.ar$i -sticky new
    }

    ttk::label $w.f.fFiles.ltxt -text [_ "( best if width = size = power of two)"]
    #label $w.f.fFiles.ltxt2 -text [_ "( unchecked faces will be drawn as 2 color)"]
    grid $w.f.fFiles.ltxt -sticky nwes

    grid columnconfigure $w.f.fFiles 0 -weight 1
    grid rowconfigure $w.f.fFiles 0 -weight 1
    grid rowconfigure $w.f.fFiles 1 -weight 1
    grid rowconfigure $w.f.fFiles 2 -weight 1
    grid rowconfigure $w.f.fFiles 3 -weight 1
    grid rowconfigure $w.f.fFiles 4 -weight 1
    grid rowconfigure $w.f.fFiles 5 -weight 1
    grid rowconfigure $w.f.fFiles 6 -weight 1
    grid rowconfigure $w.f.fFiles 7 -weight 1

    # opcion patron de lineas
    ttk::radiobutton $w.f.rd2 -variable ::VREPriv(TipoDatos) -value Data \
	-text [_ "Pattern definition"]: -command VRECambiaEstadoLabelFrames
    set ::VREPriv(Patron,frame) $w.f.fPatron
    ttk::labelframe $w.f.fPatron -labelwidget $w.f.rd2    

    tk::frame $w.f.fPatron.resolucion -borderwidth 0 -background red
    ttk::radiobutton $w.f.fPatron.resolucion.rd1 \
	-variable ::VREPriv(Patron,Tamanyo) -value 64 \
	-text [_ "Coarse#C#resolution"]
    ttk::radiobutton $w.f.fPatron.resolucion.rd2 \
	-variable ::VREPriv(Patron,Tamanyo) -value 128 \
	-text [_ "Medium#C#resolution"]
    ttk::radiobutton $w.f.fPatron.resolucion.rd3 \
	-variable ::VREPriv(Patron,Tamanyo) -value 256 \
	-text [_ "Fine#C#resolution"]
    grid $w.f.fPatron.resolucion.rd1 $w.f.fPatron.resolucion.rd2 $w.f.fPatron.resolucion.rd3 \
	-sticky nw -padx 0 -pady 0

    if { $::VREPriv(usa) == "Boton"} {
	ttk::button $w.f.fPatron.muestra          
    } elseif { $::VREPriv(usa) == "Canvas"} {
	canvas $w.f.fPatron.muestra -borderwidth 0 -relief flat -width 128 -height 128 \
	    -borderwidth 0 -highlightthickness 0
    }

    set ::VREPriv(Patron,Muestra,wid) $w.f.fPatron.muestra
    foreach i {1 2 3 4 5 6} p {| - + / \\ x} {
	if { ![ info exists ::VREPriv(Patron$p)]} {
	    set ::VREPriv(Patron$p) [ image create photo -data [ VRECreaImagenPatron 16 $p]]
	}
	ttk::button $w.f.fPatron.p$i -image $::VREPriv(Patron$p) \
	    -command "VREActualizaPatronMuestra $p"
    }

    ttk::frame $w.f.fPatron.fcol -borderwidth 0
    # button $w.f.fPatron.fcol.bg -width 3 -bg $::VREPriv(Patron,BG) \
    #         -command "CCCambiaColor $w.f.fPatron.fcol.bg ::VREPriv(Patron,BG); \
    #                   VREActualizaBotonesPatrones $w.f.fPatron.p; \
    #                   VREActualizaPatronMuestra"
    # button $w.f.fPatron.fcol.fg -width 3 -bg $::VREPriv(Patron,FG) \
    #         -command "CCCambiaColor $w.f.fPatron.fcol.fg ::VREPriv(Patron,FG); \
    #                   VREActualizaBotonesPatrones $w.f.fPatron.p; \
    #                   VREActualizaPatronMuestra"
    LabelButton $w.f.fPatron.fcol.bg -width 3 -background $::VREPriv(Patron,BG) \
	-borderwidth 1 -relief sunken \
	-command "CCCambiaColor $w.f.fPatron.fcol.bg ::VREPriv(Patron,BG); \
		  VREActualizaBotonesPatrones $w.f.fPatron.p; \
		  VREActualizaPatronMuestra"
    LabelButton $w.f.fPatron.fcol.fg -width 3 -background $::VREPriv(Patron,FG) \
	-borderwidth 1 -relief sunken \
	-command "CCCambiaColor $w.f.fPatron.fcol.fg ::VREPriv(Patron,FG); \
		  VREActualizaBotonesPatrones $w.f.fPatron.p; \
		  VREActualizaPatronMuestra"
    ttk::label $w.f.fPatron.fcol.l1 -text [_ "Line spacing"]:
    ttk::label $w.f.fPatron.fcol.l2 -width 2 -textvariable ::VREPriv(EspacioEntreLineas)
    if { ![info exists ::VREPriv(EspacioEntreLineas)] } {
        set ::VREPriv(EspacioEntreLineas) 0
    }
    gidscale $w.f.fPatron.fcol.sc -orient horizontal \
        -from 1 -to 15 -resolution 1 -showvalue 0 \
	-variable ::VREPriv(EspacioEntreLineas) \
	-command "VREActualizaBotonesPatrones $w.f.fPatron.p; \
		  VREActualizaPatronMuestra ;\#"
	
    grid $w.f.fPatron.fcol.bg $w.f.fPatron.fcol.fg \
	$w.f.fPatron.fcol.l1 $w.f.fPatron.fcol.l2 -sticky nw -padx 4 -pady 2
    grid configure $w.f.fPatron.fcol.l1 -sticky se -padx 2
    grid configure $w.f.fPatron.fcol.l2 -sticky se -padx 2
    grid $w.f.fPatron.fcol.sc -columnspan 4 -sticky new -padx 4 -pady 2
    grid rowconfigure $w.f.fPatron.fcol 0 -weight 1
    grid columnconfigure $w.f.fPatron.fcol 2 -weight 1

    ttk::frame $w.f.fPatron.fQCaras -borderwidth 0
    foreach i "Left Right Top Bottom Back Front" j {{0 0} {1 0} {0 1} {1 1} {0 2} {1 2}} {
	if { ![info exists ::VREPriv(Usa,$i)] } { set ::VREPriv(Usa,$i) 0 }
	ttk::checkbutton $w.f.fPatron.fQCaras.cb$i -text [_ "%s face" $i] \
	    -variable ::VREPriv(Usa,$i) -onvalue 1 -offvalue 0
	grid $w.f.fPatron.fQCaras.cb$i -row [ lindex $j 0] -column [ lindex $j 1] \
	    -sticky nw -padx 2 -pady 0
    }

    grid $w.f.fPatron.resolucion -columnspan 2 -sticky nw -padx 4 -pady 2
    grid $w.f.fPatron.muestra -rowspan 6 -sticky nw -padx 4 -pady 2
    grid $w.f.fPatron.fcol -columnspan 2 -sticky nwe -padx 4 -pady 2
    foreach i {1 2 3 4 5 6} {
	grid $w.f.fPatron.p$i -row [ expr $i] -column 1 -sticky ne -padx 4 -pady 0
    }
    grid $w.f.fPatron.fQCaras -columnspan 2 -sticky swe -padx 4 -pady 2
    grid rowconfigure $w.f.fPatron 7 -weight 1
    grid columnconfigure $w.f.fPatron 0 -weight 1

    # el comportamiento de las caras que no hemos definido:
    ttk::frame $w.f.fCarasVacias -borderwidth 0
    ttk::radiobutton $w.f.fCarasVacias.rd1 -text [_ "Use color of layer for unchecked faces"] \
	-variable ::VREPriv(UseLayerColor) -value Yes
    ttk::radiobutton $w.f.fCarasVacias.rd2 -text [_ "Use these two colors for unchecked faces"]: \
	-variable ::VREPriv(UseLayerColor) -value No

    set ::VREPriv(CarasVacias,frame) $w.f.fCarasVacias
    ttk::frame $w.f.fCarasVacias.fcol -borderwidth 0
    ttk::label $w.f.fCarasVacias.fcol.lc1 -text [_ "Color 1"]:

    # button $w.f.fCarasVacias.fcol.col1 -width 3 -bg $::VREPriv(Color1) \
    #         -command "CCCambiaColor $w.f.fCarasVacias.fcol.col1 ::VREPriv(Color1)"

    LabelButton $w.f.fCarasVacias.fcol.col1 -width 3 -background $::VREPriv(Color1) \
	-borderwidth 1 -relief sunken \
	-command "CCCambiaColor $w.f.fCarasVacias.fcol.col1 ::VREPriv(Color1)"

    ttk::label $w.f.fCarasVacias.fcol.lc2 -text [_ "Color 2"]:
    # button $w.f.fCarasVacias.fcol.col2 -width 3 -bg $::VREPriv(Color2) \
    #     -command "CCCambiaColor $w.f.fCarasVacias.fcol.col2 ::VREPriv(Color2)"
    LabelButton $w.f.fCarasVacias.fcol.col2 -width 3 -background $::VREPriv(Color2) \
	-borderwidth 1 -relief sunken \
	-command "CCCambiaColor $w.f.fCarasVacias.fcol.col2 ::VREPriv(Color2)"
    grid $w.f.fCarasVacias.fcol.lc1 $w.f.fCarasVacias.fcol.col1 \
	$w.f.fCarasVacias.fcol.lc2 $w.f.fCarasVacias.fcol.col2 \
	-padx 2 -pady 0 -sticky ne
    grid configure $w.f.fCarasVacias.fcol.col1 -sticky nw
    grid configure $w.f.fCarasVacias.fcol.col2 -sticky nw

    grid $w.f.fCarasVacias.rd1 -padx 2 -pady 0 -sticky nw -columnspan 2
    grid $w.f.fCarasVacias.rd2 $w.f.fCarasVacias.fcol -padx 2 -pady 0 -sticky nw
    #grid -padx 2 -pady 0 -sticky nw


    # empaquetamos todo:
    grid $w.f.fVista -sticky nwe -columnspan 2 -padx 4 -pady 2
    grid $w.f.fFiles $w.f.fPatron -sticky news -padx 4 -pady 2
    grid $w.f.fCarasVacias -sticky nw -columnspan 2 -padx 4 -pady 2
    #grid rowconfigure $w.f 0 -weight 1
    grid rowconfigure $w.f 1 -weight 1
    grid columnconfigure $w.f 0 -weight 1
    grid columnconfigure $w.f 1 -weight 1
    grid columnconfigure $w.f 2 -weight 1


    # marco de los botones
    ttk::frame $w.but -style BottomFrame.TFrame
   
    ttk::button $w.but.apply -text [_ "Apply"] -command VREAplicar -takefocus 1 -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -takefocus 1 -style BottomFrame.TButton
    ttk::button $w.but.reload -text [_ "Reload"] -command "VREReload $w" -takefocus 1 -style BottomFrame.TButton

    grid $w.but.apply -sticky ews -padx 4 -pady 10
    grid $w.but.close -sticky ews -padx 4 -pady 10 -row 0 -column 1
    if { $::VREPriv(Debug)} {
	grid $w.but.reload -sticky es -padx 4 -pady 10 -row 0 -column 2
    }

    #enpaquetamos marcos
    grid $w.f -sticky news -padx 0 -pady 0
    grid $w.but -sticky wes
    grid anchor $w.but center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    bind $w <Return> "+ $w.but.apply invoke"   
    update idletasks
    VREActualizaVariables
}
