
namespace eval ::ExchangeMaterials {
    variable CurrMaterials
    variable DataMaterials
    variable ModifiedCurrMaterials
    variable ModifiedDataMaterials
}

proc saveMaterialsWindow {filename Book {w .saveMatWin}} {

    InitWindow2 $w -title [_ "Exchange materials"] \
        -geometryvariable PreExchangeMaterialsWindowGeom \
        -ontop

    ttk::frame $w.top -style raised.TFrame -borderwidth 2

    # Show the current database materials
    ttk::frame $w.top.finternal -style raised.TFrame -borderwidth 2
    ttk::label $w.top.finternal.label -text [_ "Internal materials"]
    set sw1 [ScrolledWindow $w.top.finternal.swinternmat -relief sunken -borderwidth 2 -auto both]
    set tree1 [Tree $sw1.tree -relief flat -borderwidth 0 \
                   -highlightthickness 0 -selectbackground "darkblue" \
                   -selectforeground yellow \
                   -highlightbackground yellow -width 30 -redraw 1]

    $sw1 setwidget $tree1
    ttk::frame $w.top.finternal.fbut -style BottomFrame.TFrame
    ttk::button $w.top.finternal.fbut.rename -text [_ "Rename"] \
            -style BottomFrame.TButton \
            -command "::ExchangeMaterials::RenameSelMaterial $tree1 CurrMaterials"
           
    ttk::button $w.top.finternal.fbut.delete -text [_ "Delete"] \
            -style BottomFrame.TButton \
            -command "::ExchangeMaterials::RemoveSelNode $tree1 CurrMaterials"            
    ttk::button $w.top.finternal.fbut.apply -text [_ "Apply"] \
            -style BottomFrame.TButton \
            -command [list ::ExchangeMaterials::UpdateGiDMaterials $w]         


    # Show the external database materials
    ttk::frame $w.top.fexternal -style raised.TFrame -borderwidth 2
    ttk::label $w.top.fexternal.label -text [_ "External materials"]
    set sw2 [ScrolledWindow $w.top.fexternal.swexternmat -relief sunken -borderwidth 2 -auto both]
    set tree2 [Tree $sw2.tree -relief flat -borderwidth 0 \
                   -highlightthickness 0 -selectbackground "darkblue" \
                   -selectforeground yellow \
                   -highlightbackground yellow -width 30 -redraw 1]

    $sw2 setwidget $tree2
    ttk::frame $w.top.fexternal.fbut -style BottomFrame.TFrame
    ttk::button $w.top.fexternal.fbut.rename -text [_ "Rename"] \
        -style BottomFrame.TButton \
        -command "::ExchangeMaterials::RenameSelMaterial $tree2 DataMaterials"       
    ttk::button $w.top.fexternal.fbut.delete -text [_ "Delete"] \
        -style BottomFrame.TButton \
        -command "::ExchangeMaterials::RemoveSelNode $tree2 DataMaterials"       
    ttk::button $w.top.fexternal.fbut.save -text [_ "Save"] \
        -style BottomFrame.TButton \
        -command [list ::ExchangeMaterials::matSaveButton $filename $w]     

    # Create the transfer buttons
    ttk::frame $w.top.fbut
    ttk::button $w.top.fbut.assign -text > -width "3"\
            -command "::ExchangeMaterials::CopySelMaterial $tree1 $tree2 DataMaterials"
    ttk::button $w.top.fbut.assignall -text >> -width "3" \
            -command "::ExchangeMaterials::CopyAllMaterials $tree1 $tree2 DataMaterials"
    ttk::button $w.top.fbut.deassign -text < -width "3" \
            -command "::ExchangeMaterials::CopySelMaterial $tree2 $tree1 CurrMaterials"
    ttk::button $w.top.fbut.deassignall  -text << -width "3" \
            -command "::ExchangeMaterials::CopyAllMaterials $tree2 $tree1 CurrMaterials"

    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
            -command "destroy $w" \
            -underline 0 -style BottomFrame.TButton

    grid $w.top.fexternal.label -sticky nsew
    grid $sw2 -sticky nsew
    grid $w.top.fexternal.fbut.rename $w.top.fexternal.fbut.delete $w.top.fexternal.fbut.save -pady 5 -padx 5 -sticky ew
    grid $w.top.fexternal.fbut -sticky sew


    grid $w.top.fbut.assign -pady 5 -padx 5
    grid $w.top.fbut.assignall -pady 5 -padx 5
    grid $w.top.fbut.deassign -pady 5 -padx 5
    grid $w.top.fbut.deassignall -pady 5 -padx 5

    grid $w.top.finternal.label -sticky nsew
    grid $sw1 -sticky nsew
    grid $w.top.finternal.fbut.rename $w.top.finternal.fbut.delete $w.top.finternal.fbut.apply -pady 5 -padx 5 -sticky ew
    grid $w.top.finternal.fbut -sticky sew

    grid $w.top.finternal $w.top.fbut $w.top.fexternal -pady 5 -padx 6 -sticky nsew
    grid columnconfigure $w.top.finternal "0" -weight 1
    grid rowconfigure $w.top.finternal "1" -weight 1
    grid columnconfigure $w.top.fexternal "0" -weight 1
    grid rowconfigure $w.top.fexternal "1" -weight 1
    grid $w.top -sticky nsew

    grid $w.frmButtons -sticky ews -columnspan 7
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconfigure $w.top "0 2" -weight 1
    grid rowconfigure $w.top "0" -weight 1

    grid columnconfigure $w "0" -weight 1
    grid rowconfigure $w "0" -weight 1


    ::ExchangeMaterials::InitMaterials $filename $Book
    #UpdateMaterialsPrim $w.top.fassigned databaseMaterials $Book
    #UpdateMaterialsPrim $w.top.flayers currentMaterials $Book

    ::ExchangeMaterials::FillTreeExchangeMaterials $tree1 CurrMaterials
    ::ExchangeMaterials::FillTreeExchangeMaterials $tree2 DataMaterials  

    #bind $tree2 <Delete> "::ExchangeMaterials::RemoveNode $tree2 DataMaterials"

    focus $w.frmButtons.btnclose
}

proc ::ExchangeMaterials::InitMaterials { filename Book } {
    ::ExchangeMaterials::ReadCurrMaterials $Book
    ::ExchangeMaterials::DWReadMatfile $filename
}

proc ::ExchangeMaterials::DWReadMatfile { filename } {
    variable DataMaterials
    variable ModifiedDataMaterials

    catch { unset DataMaterials }
    set bookname ""
    set f [open $filename r]
    if { $f == "" } {
        WarnWin [_ "Error, cannot open file '%s'" $filename]
        return
    }
    while { ![eof $f] } {
        gets $f aa
        if { $aa == "" || [string index $aa 0] == "#" } {
            continue
        } elseif { [regexp -nocase {BOOK:[ ]*([^ ]*)} $aa {} bookname] } {
            if { ![info exists DataMaterials(MAT,bookslist)] ||
                [lsearch $DataMaterials(MAT,bookslist) $bookname] == -1 } {
                lappend DataMaterials(MAT,bookslist) $bookname
            }
        } elseif { [regexp -nocase {[NUMBER:[ ]*([0-9]*)[ ]*]?MATERIAL:?[ ]*([^ ]*)} $aa {} matnum matname] } {
            lappend DataMaterials(MAT,nameslist) $matname
            set DataMaterials(MAT,$matname,BOOK) $bookname
            set inum 0
            while { ![eof $f] } {
                gets $f aa
                if { $aa == "" || [string index $aa 0] == "#" } { continue }
                if { [regexp {^([^:]*):(.*)$} $aa {} field value] } {
                    set field [string trim $field]
                    set value [string trim $value]
                    if { $field == "QUESTION" } { incr inum }
                    if { $field == "DEPENDENCIES" } {
                        #can exists dependecies written with multiple lines
                        if { [info exists DataMaterials(MAT,$matname,$field,$inum)] } {
                            append DataMaterials(MAT,$matname,$field,$inum) $value
                        } else {
                            set DataMaterials(MAT,$matname,$field,$inum) $value
                        }
                    } else {
                        set DataMaterials(MAT,$matname,$field,$inum) $value
                    }
                } elseif { [regexp -nocase {^[ ]*END MATERIAL[ ]*$} $aa {}] } {
                    break
                } else {
                    WarnWin [_ "Error reading material, bad line '%s'" $aa]
                    close $f
                    return
                }
            }
        } else {
            WarnWin [_ "Error reading material, bad line '%s'" $aa]
            break
        }
    }
    close $f

    foreach i [array names DataMaterials MAT,*,VALUE*] {
        if { [lindex $DataMaterials($i) 0] == "#N#" } {
            set DataMaterials($i,0) [lindex $DataMaterials($i) 1]
            for { set j 1 } { $j <= $DataMaterials($i,0) } { incr j } {
                set DataMaterials($i,$j) [lindex $DataMaterials($i) [expr $j+1]]
            }
        }
    }
    set ModifiedDataMaterials 0
}

proc ::ExchangeMaterials::DWSaveMatfile { filename } {
    variable DataMaterials
    variable ModifiedDataMaterials
    set lastbookname ""
    set f [open $filename w]
    if { $f == "" } {
        WarnWin [_ "Error, cannot open file '%s'" $filename]
        return
    }
    set otherfields "HELP STATE IMAGE DEPENDENCIES TKWIDGET TITLE"
    set matnum 1
    foreach matname $DataMaterials(MAT,nameslist) {
        if { [info exists DataMaterials(MAT,$matname,BOOK)] && $DataMaterials(MAT,$matname,BOOK) != "" } {
            if { $DataMaterials(MAT,$matname,BOOK) != $lastbookname } {
                set lastbookname $DataMaterials(MAT,$matname,BOOK)
                puts $f "BOOK:$DataMaterials(MAT,$matname,BOOK)"
            }
        }
        puts $f "NUMBER:$matnum MATERIAL:$matname"
        # Write fields
        #can exists title before any question
        set nquest 0
        set i "TITLE"
        if { [info exists CurrMaterials(MAT,$matname,$i,$nquest)] } {
            puts $f "$i:$DataMaterials(MAT,$matname,$i,$nquest)"
            set value $CurrMaterials(MAT,$matname,$i,$nquest)
        }
        set nquest 1
        while {[info exists DataMaterials(MAT,$matname,QUESTION,$nquest)]} {
            puts $f "QUESTION:$DataMaterials(MAT,$matname,QUESTION,$nquest)"
            puts $f "VALUE:$DataMaterials(MAT,$matname,VALUE,$nquest)"
            foreach i $otherfields {
                if {[info exists DataMaterials(MAT,$matname,$i,$nquest)]} {
                    puts $f "$i:$DataMaterials(MAT,$matname,$i,$nquest)"
                }
            }
            # Increase question
            incr nquest
        }
        puts $f "END MATERIAL"

        # Increase material number
        incr matnum
    }
    close $f
    set ModifiedDataMaterials 0
}


proc ::ExchangeMaterials::ReadCurrMaterials { Book } {

    variable CurrMaterials
    variable ModifiedCurrMaterials
    # Obtain materials from GiD
    catch { unset CurrMaterials }

    foreach matname [GiD_Info materials] {
        set bookname [GiD_Info materials $matname BOOK]
        if { $bookname == "Default" } {
            set bookname ""
        }
        #if { $bookname != $Book } continue
        if { $bookname != "" && ( ![info exists CurrMaterials(MAT,bookslist)] ||
            [lsearch $CurrMaterials(MAT,bookslist) $bookname] == -1 ) } {
            lappend CurrMaterials(MAT,bookslist) $bookname
        }

        lappend CurrMaterials(MAT,nameslist) $matname
                
        set CurrMaterials(MAT,$matname,BOOK) $bookname

        set matparams [GiD_Info materials $matname]
        set matparams [lrange $matparams 1 end]
        set inum  1
        foreach "field value" $matparams {
            set CurrMaterials(MAT,$matname,QUESTION,$inum) $field
            set CurrMaterials(MAT,$matname,VALUE,$inum) $value
            incr inum
        }
        set otherfields [GiD_Info materials $matname OTHERFIELDS]
        if { $otherfields != "" } {
            set otherfields [lrange $$otherfields 1 end]
            foreach "field value inum" $otherfields {
                set CurrMaterials(MAT,$matname,$field,$inum) $value
            }
        
        }
    }

    foreach i [array names CurrMaterials MAT,*,VALUE*] {
        if { [lindex $CurrMaterials($i) 0] == "#N#" } {
            set CurrMaterials($i,0) [lindex $CurrMaterials($i) 1]
            for { set j 1 } { $j <= $CurrMaterials($i,0) } { incr j } {
                set CurrMaterials($i,$j) [lindex $CurrMaterials($i) [expr $j+1]]
            }
        }
    }
    set ModifiedCurrMaterials 0
}

#dataname must be DataMaterials or CurrMaterials
proc ::ExchangeMaterials::FillTreeExchangeMaterials { tree dataname } {
    upvar #0 ::ExchangeMaterials::$dataname Data
    $tree delete [$tree nodes root]
    #materials without any book
    if { [info exists Data(MAT,nameslist)] } {
        foreach matname $Data(MAT,nameslist) {
            if { ![info exists Data(MAT,$matname,BOOK)] ||
            $Data(MAT,$matname,BOOK) == "" } {
                $tree insert end root "->$matname" -text $matname \
                        -image [gid_themes::GetImage point.png small_icons]
            }
        }
    }
    if { [info exists Data(MAT,bookslist) ] } {
        foreach bookname $Data(MAT,bookslist) {
            $tree insert end root $bookname -text $bookname \
                    -image [gid_themes::GetImage folder.png small_icons]
            foreach matname $Data(MAT,nameslist) {
                if { [info exists Data(MAT,$matname,BOOK)] &&
                $Data(MAT,$matname,BOOK) == $bookname } {
                    $tree insert end $bookname "$bookname->$matname" -text $matname \
                            -image [gid_themes::GetImage point.png small_icons]
                }
            }
        }
    }
}

proc ::ExchangeMaterials::matSaveButton { filename w } {
    variable ModifiedDataMaterials
    if { $ModifiedDataMaterials == "0" } return

    if {[file writable $filename]==1} {
        set ret [MessageBoxOptionsButtons [_ "Dialog window"] \
                [_ "Are you sure to modify external materials file?"] \
                {0 1} [list [_ "OK"] [_ "Cancel"]] question ""]
        if { $ret == 0 } {
            ::ExchangeMaterials::DWSaveMatfile $filename
        }
    } else {
        WarnWin [_ "The selected file is write protected"]
    }
}

proc ::ExchangeMaterials::UpdateGiDMaterials { w } {
    variable CurrMaterials
    variable ModifiedCurrMaterials
    if { $ModifiedCurrMaterials == "0" } return

    set ret [MessageBoxOptionsButtons [_ "Dialog window"] \
            [_ "Are you sure to modify the current materials?"] \
            {0 1} [list [_ "OK"] [_ "Cancel"]] question ""]
    if { $ret != 0 } {
        return
    }

    set otherfields {HELP STATE IMAGE DEPENDENCIES TKWIDGET TITLE}

    # Add/Remove materials loaded from database to GiD
    set memMaterials [GiD_Info materials]
    # Add materials
    foreach matname $CurrMaterials(MAT,nameslist) {
        set found [lsearch $memMaterials $matname]
        if {$found == -1} {
            # Add a new material to GiD            
            # Write fields
            set cmd2 [list]
            if { [info exists CurrMaterials(MAT,$matname,BOOK)] } {
                set Book $CurrMaterials(MAT,$matname,BOOK)
            }
            set notherfields 0
            set cmd3 [list]
            #can exists title before any question
            set nquest 0
            set i TITLE
            if { [info exists CurrMaterials(MAT,$matname,$i,$nquest)] } {
                set value $CurrMaterials(MAT,$matname,$i,$nquest)
                lappend cmd3 $i $value [expr $nquest-1]
                incr notherfields
            }
            set nquest 1
            while {[info exists CurrMaterials(MAT,$matname,QUESTION,$nquest)]} {
                set question $CurrMaterials(MAT,$matname,QUESTION,$nquest)
                set value $CurrMaterials(MAT,$matname,VALUE,$nquest)                
                lappend cmd2 $question $value
                foreach i $otherfields {
                    if { [info exists CurrMaterials(MAT,$matname,$i,$nquest)] } {
                        set value $CurrMaterials(MAT,$matname,$i,$nquest)
                        lappend cmd3 $i $value [expr $nquest-1]
                        incr notherfields
                    }
                }
                incr nquest
            }
            incr nquest -1
            
            set cmd [list Data Defaults BaseMaterial $matname $nquest {*}$cmd2]
            if { [info exists CurrMaterials(MAT,$matname,BOOK)] && $CurrMaterials(MAT,$matname,BOOK) != "" } {
                lappend cmd Book $CurrMaterials(MAT,$matname,BOOK)
            }
            if { $notherfields } {
                lappend cmd OtherFields $notherfields {*}$cmd3
            }
            lappend cmd escape        
            GiD_Process Mescape {*}$cmd
        }
    }
    # Remove materials
    foreach matname $memMaterials {
        set found [lsearch $CurrMaterials(MAT,nameslist) $matname]
        if {$found == -1} {
            #remove material from GiD
            GiD_Process Mescape Data Materials DeleteMaterial $matname escape
        }
    }
}

#dataname must be DataMaterials or CurrMaterials
proc ::ExchangeMaterials::RemoveSelNode { tree dataname } {
    variable Modified$dataname
    upvar #0 ::ExchangeMaterials::$dataname Data

    set node [$tree selection get]
    if { [string equal $node ""] } return

    #set bookname [lindex [split $node "->"] 0]
    #set matname [lindex [split $node "->"] 2]
    set bookname ""
    set matname ""
    regexp {(.*)->(.*)} $node dummy bookname matname

    if { $bookname != "" && $matname == "" } {
        #delete all the book
        foreach node [$tree nodes $bookname] {
            $tree delete $node
            #set matname [lindex [split $node "->"] 2]
            set matname ""
            regexp {(.*)->(.*)} $node dummy bookname matname
            set pos [lsearch $Data(MAT,nameslist) $matname]
            if { $pos != -1 } {
                set Data(MAT,nameslist) [lreplace $Data(MAT,nameslist) $pos $pos]
                array unset Data MAT,$matname,*
            }
        }
        $tree delete $bookname
        if { [info exists Data(MAT,bookslist)] } {
            set pos [lsearch $Data(MAT,bookslist) $bookname]
            if { $pos != -1 } {
                set Data(MAT,bookslist) [lreplace $Data(MAT,bookslist) $pos $pos]
            }
        }
    } else {
        set parent [$tree parent $node]
        $tree delete $node
        if { ![llength [$tree nodes $parent]] } {
            #delete void book
            $tree delete $parent
            set bookname $parent
            if { [info exists Data(MAT,bookslist)] } {
                set pos [lsearch $Data(MAT,bookslist) $bookname]
                if { $pos != -1 } {
                    set Data(MAT,bookslist) [lreplace $Data(MAT,bookslist) $pos $pos]
                }
            }
        }
        set pos [lsearch $Data(MAT,nameslist) $matname]
        if { $pos != -1 } {
            set Data(MAT,nameslist) [lreplace $Data(MAT,nameslist) $pos $pos]
            array unset Data MAT,$matname,*
        }
    }
    set Modified$dataname 1
}

#dataname must be DataMaterials or CurrMaterials
proc ::ExchangeMaterials::CreateBook { tree dataname bookname } {
    variable Modified$dataname
    upvar #0 ::ExchangeMaterials::$dataname Data
    if { ![$tree exists $bookname] } {
        $tree insert end root $bookname -text $bookname \
            -image [gid_themes::GetImage folder.png small_icons]
    }
    if { ![info exists Data(MAT,bookslist)] || \
            [lsearch $Data(MAT,bookslist) $bookname] == -1 } {
        lappend Data(MAT,bookslist) $bookname
    }
    set Modified$dataname 1
}

#dataname must be DataMaterials or CurrMaterials
proc ::ExchangeMaterials::CreateMaterial { tree dataname bookname matname } {
    variable Modified$dataname
    upvar #0 ::ExchangeMaterials::$dataname Data
    if { $dataname == "DataMaterials" } {
        upvar #0 ::ExchangeMaterials::CurrMaterials SourceData
    } else {
        upvar #0 ::ExchangeMaterials::DataMaterials SourceData
    }


    if { $bookname != "" && ![$tree exists $bookname] } {
        ::ExchangeMaterials::CreateBook $tree $dataname $bookname
    }
    if { ![$tree exists "$bookname->$matname"] } {
        if { $bookname != "" } {
            $tree insert end $bookname "$bookname->$matname" -text $matname \
                -image [gid_themes::GetImage point.png small_icons]
        } else {
            $tree insert end root "->$matname" -text $matname \
                -image [gid_themes::GetImage point.png small_icons]
        }
    }
    if { [lsearch $Data(MAT,nameslist) $matname] == -1 } {
        lappend Data(MAT,nameslist) $matname
        foreach i [array names SourceData MAT,$matname,*] {
            set Data($i) $SourceData($i)
        }
    }
    set Modified$dataname 1
}

proc ::ExchangeMaterials::CopyMaterial { tree dataname bookname matname } {
  if { [$tree exists "$bookname->$matname"] } return
  if { $bookname != "" && ![$tree exists $bookname] } {
    CreateBook $tree $dataname $bookname
  }
  CreateMaterial $tree $dataname $bookname $matname
}

proc ::ExchangeMaterials::CopySelMaterial { treesrc treedst datanamedst } {
    set node [$treesrc selection get]
    if { $node == "" } return
#     set bookname [lindex [split $node "->"] 0]
#     set matname [lindex [split $node "->"] 2]
    set bookname ""
    set matname ""
    regexp {(.*)->(.*)} $node dummy bookname matname
    if { $bookname != "" && $matname == "" } {
        foreach node [$treesrc nodes $bookname] {
#             set matname [lindex [split $node "->"] 2]
            set matname ""
            regexp {(.*)->(.*)} $node dummy bookname matname
            CopyMaterial $treedst $datanamedst $bookname $matname
        }
    } else {
        CopyMaterial $treedst $datanamedst $bookname $matname
    }
}

proc ::ExchangeMaterials::CopyAllMaterials { treesrc treedst datanamedst } {
    foreach bookname [$treesrc nodes root] {
#         set matname [lindex [split $bookname "->"] 2]
        set matname ""
        regexp {(.*)->(.*)} $bookname dummy b matname
        if { $matname == "" } {
            foreach node [$treesrc nodes $bookname] {
#                 set matname [lindex [split $node "->"] 2]
                set matname ""
                regexp {(.*)->(.*)} $node dummy b matname
                CopyMaterial $treedst $datanamedst $bookname $matname
            }
        } else {
            #matname without book
            CopyMaterial $treedst $datanamedst "" $matname
        }
    }
}

proc ::ExchangeMaterials::RenameSelMaterial { tree dataname } {
    set node [$tree selection get]
    if { $node == "" } return
    #set bookname [lindex [split $node "->"] 0]
    #set matname [lindex [split $node "->"] 2]
    set matname ""
    regexp {(.*)->(.*)} $node dummy bookname matname
    if { $matname != "" } {
        set newname [MessageBoxEntry [_ "Material name"] [_ "Enter the new name of %s" $matname] any $matname 0 question.png]
        if { $newname != "" } {
            RenameMaterial $tree $dataname $matname $newname
        }        
    }
}

proc ::ExchangeMaterials::RenameMaterial { tree dataname matname newname } {
    variable Modified$dataname
    upvar #0 ::ExchangeMaterials::$dataname Data

    set bookname $Data(MAT,$matname,BOOK)
    set node "$bookname->$matname"
    #$tree edit $node $newname
    set pos [$tree index $node]
    $tree delete $node
    set node "$bookname->$newname"
    if { $bookname != "" } {
        $tree insert $pos $bookname $node -text $newname -image [gid_themes::GetImage point.png small_icons]
    } else {
        $tree insert $pos root $node -text $newname -image [gid_themes::GetImage point.png small_icons]
    }

    foreach i [array names Data MAT,$matname,*] {
        # this is bad: regsub ",$matname," $i ",$newname," newi
        set newi [string map [list $matname $newname] $i]
        set Data($newi) $Data($i)
    }
    array unset Data MAT,$matname,*
    set pos [lsearch $Data(MAT,nameslist) $matname]
    if { $pos != -1 } {
        set Data(MAT,nameslist) [lreplace $Data(MAT,nameslist) $pos $pos $newname]
    }
    set Modified$dataname 1
}
