
namespace eval GIDReport {
    variable _w
    variable _Archivo
    variable _DirectorioBase
    variable _DirectorioFotos
    variable _Titulo
    variable _Descripcion
    variable _IncluirResumenProyecto
    variable _PieFoto
    variable _Parrafo
    variable _images
    variable _HayCambios
    variable _Informe
    variable _NumFotos
    variable _NumParrafos
    variable _wPreview
    variable _ArchivoTemporal
    variable _DirectorioTemporalBase
    variable _DirectorioTemporalFotos
    variable _Inicializando
    variable _HayAlgo

    proc HayCambios { { sino ""}} {
        variable _HayCambios
        variable _Inicializando
        variable _HayAlgo

        if { [ info exists _Inicializando] && $_Inicializando && ( "$sino" != "")} { return}
        set que [ string tolower $sino]
        if { "$que" == "si"} {
            set _HayAlgo 1
            set _HayCambios 1
            # se lo decimos a GiD
            GiD_ModifiedFileFlag Set
        } elseif { "$que" == "no"} {
            set _HayCambios 0
        } else {
            set ret 0
            if { [ info exists _HayAlgo] && $_HayAlgo && \
                [ info exists _HayCambios] && $_HayCambios} {
                set ret 1
            }
            return $ret
        }
    }

    proc InitVariables { { reset 0}} {
        variable _Titulo
        variable _Descripcion
        variable _IncluirResumenProyecto
        variable _PieFoto
        variable _Parrafo
        variable _Archivo
        variable _DirectorioBase
        variable _DirectorioFotos
        variable _Informe
        variable _NumFotos
        variable _NumParrafos
        variable _ArchivoTemporal
        variable _DirectorioTemporalBase
        variable _DirectorioTemporalFotos
        variable _Inicializando

        set _Inicializando 1
        set _Titulo ""
        set _Descripcion ""
        set _PieFoto ""
        set _Parrafo ""
        set _IncluirResumenProyecto 0

        if { !$reset} {
            if { 0} {
                set proyecto [GiD_Info Project ModelName]
                # de momento en el directorio temporal
                set _DirectorioBase ${proyecto}.gid
                set _Archivo [ file tail $proyecto]
                if { [ file pathtype $_DirectorioBase] == "relative"} {
                    set _DirectorioBase [ file join [ pwd] $_DirectorioBase]
                }
                set _Archivo [ file join ${_DirectorioBase} ${_Archivo}_GIDReport.html]
                set _DirectorioFotos [ file rootname [ file tail $_Archivo]]_images
            }
            GetNombreProyecto

            set _ArchivoTemporal [ GetNombreTemporal]
            set _DirectorioTemporalBase [file dirname $_ArchivoTemporal]
            set _DirectorioTemporalFotos [ file rootname [ file tail $_ArchivoTemporal]]_images
        } else {
            BorraTemporalUsado
        }

        if { [ info exists _Informe]} { unset _Informe}
        set _Informe(NumElementos) 0
        set _NumFotos 0
        set _NumParrafos 0

        set _HayAlgo 0

        set _Inicializando 0
        HayCambios no
    }

    proc GetNombreTemporal { } {
        set tmp_dir [GiD_Info project TmpDirectory]
        set id 0
        set tmpfile [ file join $tmp_dir _GIDReport_${id}.html]
        for { set id 0} { $id < 100000} { incr id} {
            set tmpfile [ file join $tmp_dir _GIDReport_${id}.html]
            if { ![ file exists $tmpfile]} {
                set ret [ catch { set fo [ open $tmpfile w]; close $fo; file delete -force $tmpfile}]
                if { !$ret} { break}
            }
        }
        return $tmpfile
    }

    proc GetNombreProyecto { } {
        variable _Archivo
        variable _DirectorioBase
        variable _DirectorioFotos
        variable _HayAlgo
        variable _HayCambios

        set proyecto [GiD_Info Project ModelName]
        set dir_base ${proyecto}.gid
        set archivo [ file tail $proyecto]
        if { [ file pathtype $dir_base] == "relative"} {
            set dir_base [ file join [ pwd] $dir_base]
        }
        set archivo [ file join ${dir_base} ${archivo}_GIDReport.html]


        set _Archivo $archivo
        set _DirectorioBase [file dirname $_Archivo]
        set _DirectorioFotos [ file rootname [ file tail $_Archivo]]_images
        if { [ info exists _HayAlgo] && $_HayAlgo } {
            set _HayCambios 1
        }
        return
    }

    proc BorraTemporalUsado { } {
        variable _ArchivoTemporal
        variable _DirectorioTemporalBase
        variable _DirectorioTemporalFotos

        file delete -force $_ArchivoTemporal [ file join $_DirectorioTemporalBase $_DirectorioTemporalFotos]
    }

    proc CreaImagenes { } {
        variable _images
        global GIDDEFAULT

        if { ![ info exists _images(Carpeta)]} {
            set _images(Carpeta) [ image create bitmap -data {
                #define folder_open_width 20
                #define folder_open_height 16
                static unsigned char folder_open_bits[] = {
                    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00,
                    0xf8, 0x83, 0x00, 0xf8, 0xff, 0x00, 0xf8, 0xff, 0x00, 0x38, 0x00, 0x08,
                    0x38, 0x00, 0x04, 0x18, 0x00, 0x04, 0x18, 0x00, 0x02, 0x08, 0x00, 0x02,
                    0x08, 0x00, 0x01, 0x00, 0x00, 0x01, 0xf8, 0xff, 0x00, 0x00, 0x00, 0x00
                }
            } -maskdata {
                #define folder_open_msk_width 20
                #define folder_open_msk_height 16
                static unsigned char folder_open_msk_bits[] = {
                    0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0xf8, 0x03, 0x00, 0xfc, 0x07, 0x00,
                    0x04, 0xbc, 0x00, 0x04, 0x80, 0x00, 0x04, 0x80, 0x00, 0xc4, 0xff, 0x0f,
                    0xc4, 0xff, 0x07, 0x64, 0x77, 0x07, 0xe4, 0xdd, 0x03, 0x74, 0x77, 0x03,
                    0xd4, 0xdd, 0x01, 0x7c, 0x77, 0x01, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00
                }
                } -background yellow -foreground black
                ]
                set _images(Carpeta,ayuda) [_ "Choose report file"]
            }

            foreach fi "new open save saveas search exit sep_vert Report ToReport ArrowUp ArrowDown help" \
                nombre { Nuevo Abrir Guardar GuardarComo VistaPrevia Close Separador Report ToReport \
                FlechaArriba FlechaAbajo Ayuda} \
                ayuda [list [_ "New report"] [_ "Open report"] [_ "Save report"] \
                [_ "Export report to"]... [_ "Preview"] [_ "Close"] "" \
                [_ "Report"] [_ "Send to report"] [_ "Move element up"] \
                [_ "Move element down"] [_ "Help"] ] {
                    if { ![ info exists _images($nombre)]} {
                        set _images($nombre) [ gid_themes::GetImage $fi.png medium_icons]
                    set _images($nombre,ayuda) $ayuda
                }
            }
        }

        proc Help { } {
            variable _w
            set Ayuda    [_ "This window provides some tools to create an HTML report."]\n\n
            append Ayuda -[_ "Report header, description: to write the title and a description of the report."]\n
            append Ayuda -[_ "Project summary: adds a table with the status of the current project."]\n
            append Ayuda \t[_ "In post it also adds analysis, steps and result lists."]\n
            append Ayuda -[_ "Insert view: add the current view as JPEG image to the report."]\n
            append Ayuda \t[_ "The images are stored into the 'REPORTNAME_images' directory, where the 'REPORTNAME.html' is saved."]\n
            append Ayuda -[_ "Insert text paragraph: inserts a text paragraph to the current report."]\n
            append Ayuda -[_ "Report summary: a list of elements of the current report, which can be edited."]
            TextWindow $_w Ayuda [_ "%s report help" $::GidPriv(ProgName)] [_ "About %s report" $::GidPriv(ProgName)] \
                -state disabled -width 100 -height 11 -wrap word
        }

        proc GetHelpForImage { nombre} {
            variable _images

            CreaImagenes
            return $_images($nombre,ayuda)
        }

        proc AnyadeElemento { que valor} {
            variable _Informe

            #set nombre ${que}_${_Informe(NumElementos)}
            #set elemento {}
            #lappend elemento $nombre
            #lappend elemento $valor
            #lappend _Informe(ListaElementos) $elemento
            set nombre ${que}
            set _Informe($_Informe(NumElementos),nombre) $nombre
            set _Informe($_Informe(NumElementos),valor) $valor
            incr _Informe(NumElementos)
            HayCambios si
            return $nombre
        }

        proc BuscaElemento { que} {
            variable _Informe

            set ret -1
            for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
                if { [ string match $que $_Informe($i,nombre)]} {
                    set ret $i
                }
            }
            return $ret
        }

        proc BorraElemento { que} {
            variable _Informe

            set idx [ BuscaElemento $que]
            if { $idx != -1} {
                set n [ expr $_Informe(NumElementos) - 1]
                for { set i $idx} { $i < $n} { incr i} {
                    set sig [ expr $i + 1]
                    set _Informe($i,nombre) $_Informe($sig,nombre)
                    set _Informe($i,valor) $_Informe($sig,valor)
                }
                unset _Informe($n,nombre)
                unset _Informe($n,valor)
                set _Informe(NumElementos) $n
                HayCambios si
            }
        }

        proc CambiaElemento { que valor} {
            variable _Informe

            set idx [ BuscaElemento $que]
            HayCambios si
            if { $idx != -1} {
                set _Informe($idx,valor) $valor
            } else {
                AnyadeElemento $que $valor
            }
        }

        proc IntercambiaElementos { idx1 idx2 } {
            variable _Informe

            if { ( $idx1 < 0) || ( $idx1 > $_Informe(NumElementos)) || \
                ( $idx2 < 0) || ( $idx2 > $_Informe(NumElementos))} {
                return
            }

            HayCambios si
            set nombre $_Informe($idx1,nombre)
            set valor $_Informe($idx1,valor)
            set _Informe($idx1,nombre) $_Informe($idx2,nombre)
            set _Informe($idx1,valor) $_Informe($idx2,valor)
            set _Informe($idx2,nombre) $nombre
            set _Informe($idx2,valor) $valor
        }

        proc InsertarTexto { texto} {
            variable _NumParrafos

            incr _NumParrafos
            set nombre Paragraph_${_NumParrafos}
            AnyadeElemento $nombre <p>$texto</p>
            ActualizaVistaPreviaInforme
        }

        proc Cambiar { name1 name2 op } {
            variable _NumFotos
            variable _NumParrafos
            variable _Parrafo

            HayCambios si
            switch "$name1" {
                "GIDReport::_Titulo" -
                "_Titulo" {
                    # ya los usamos al hacer el HTML
                }
                "GIDReport::_Descripcion" -
                "_Descripcion" {
                    # ya los usamos al hacer el HTML
                }
                "GIDReport::_Parrafo" -
                "_Parrafo" {
                    InsertarTexto $_Parrafo
                    set _Parrafo ""
                }
                "GIDReport::_PieFoto" -
                "_PieFoto" {
                    # ya los usamos al hacer el HTML
                }
                "GIDReport::_IncluirResumenProyecto" -
                "_IncluirResumenProyecto" {
                    #nada que hacer
                }
            }
        }

        proc TraceVariables { } {
            trace variable GIDReport::_Titulo w GIDReport::Cambiar
            trace variable GIDReport::_Descripcion w GIDReport::Cambiar
            trace variable GIDReport::_Parrafo w GIDReport::Cambiar
            trace variable GIDReport::_IncluirResumenProyecto w GIDReport::Cambiar
            # el del piefoto no hace falta, lo anyadimos al insertar la imagen
            # trace variable w GIDReport::_PieFoto Cambiar
        }

        proc UnTraceVariables { } {
            trace vdelete GIDReport::_Titulo w GIDReport::Cambiar
            trace vdelete GIDReport::_Descripcion w GIDReport::Cambiar
            trace vdelete GIDReport::_Parrafo w GIDReport::Cambiar
            trace vdelete GIDReport::_IncluirResumenProyecto w GIDReport::Cambiar
            # el del piefoto no hace falta, lo anyadimos al insertar la imagen
            # trace vdelete w GIDReport::_PieFoto Cambiar
        }

        proc CreaDirectorioSiNoExiste { dir} {
            if { ![ file isdirectory $dir]} {
                if { [ file exists $dir]} { file delete -force $dir}
                file mkdir $dir
            }
        }

        proc CreaDirectorio { dir} {
            if { ![ file isdirectory $dir]} {
                if { [ file exists $dir]} {
                    set retval [MessageBoxOptionsButtons [_ "Warning"] \
                        [_ "Are you sure to delete the file '%s'?" $dir_fotos] \
                        {0 1} [list [_ "OK"] [_ "Cancel"]] warning ""]
                    if { $retval == 1 } { return }
                    file delete -force $dir
                }
            } else {
                # borramos lo que haya dentro
                file delete -force $dir
            }
            file mkdir $dir
        }

        proc InsertarVista { } {
            variable _w
            variable _NumFotos
            variable _PieFoto
            #variable _DirectorioBase
            #variable _DirectorioFotos
            variable _DirectorioTemporalBase
            variable _DirectorioTemporalFotos

            incr _NumFotos
            set nombre View_${_NumFotos}

            # creamos la foto
            set dir_fotos [ file join $_DirectorioTemporalBase $_DirectorioTemporalFotos]
            #foreach vv "_DirectorioBase _DirectorioFotos dir_fotos" {
            #    eval WarnWinText "\"$vv -> $$vv\""
            #}
            #return
            #WarnWinText "$dir_fotos =  file join $_DirectorioTemporalBase $_DirectorioTemporalFotos"
            CreaDirectorioSiNoExiste $dir_fotos

            set ext .jpg
            set nombre_abs_foto [ file join $dir_fotos ${nombre}${ext}]
            set nombre_foto [ file join $_DirectorioTemporalFotos ${nombre}${ext}]

            GiD_Process 'Hardcopy JPEG $nombre_abs_foto escape

            # la anyadimos al informe
            set valor "<table border=0>\n"
            append valor "<tr><td>"
            if { [set GIDReport::InsertImgWidth?] && [string is integer -strict $GIDReport::InsertImgWidth] } {
                append valor "<img src=\"$nombre_foto\" border=0 align=\"center\" alt=\"$nombre\" "
                append valor "width=\"$GIDReport::InsertImgWidth\">"
            } else {
                append valor "<img src=\"$nombre_foto\" border=0 align=\"center\" alt=\"$nombre\">"
            }
            append valor "</td></tr>\n"
            append valor "<tr><td>"
            append valor "<center>$_PieFoto</center>"
            append valor "</td></tr>\n"
            append valor "</table>"
            AnyadeElemento $nombre $valor
            ActualizaVistaPreviaInforme
        }

        proc ActualizaVistaPreviaInforme { } {
            variable _Titulo
            variable _Descripcion
            variable _Informe
            variable _wPreview

            $_wPreview delete 0 end
            for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
                set nombre $_Informe($i,nombre)
                set valor $_Informe($i,valor)
                $_wPreview insert end "${nombre}: ${valor}"
            }
            $_wPreview see end
        }

        proc BorraElementoLista { } {
            variable _w
            variable _wPreview

            if { [ $_wPreview size] == 1} {
                $_wPreview selection set 0
            }
            set idx [ $_wPreview curselection]
            if { "$idx" == ""} {
                WarnWin [_ "Sorry, no element selected."] $_w
                return
            }
            set entrada [ $_wPreview get $idx]
            if { [ regexp {^([^:]+): (.*)} $entrada pepe nombre valor]} {
                BorraElemento $nombre
                ActualizaVistaPreviaInforme
            } else {
                WarnWin $entrada
            }
        }

        proc EditaTextoElementoLista { } {
            variable _w
            variable _wPreview
            variable _Informe

            if { [ $_wPreview size] == 1} {
                $_wPreview selection set 0
            }
            set idx [ $_wPreview curselection]
            if { "$idx" == ""} {
                WarnWin [_ "Sorry, no element selected."] $_w
                return
            }
            set entrada [ $_wPreview get $idx]
            if { [ regexp {^([^:]+): (.*)} $entrada pepe nombre valor]} {
                set idx [ BuscaElemento $nombre]
                set ttrad [_ "Edit element text"]
                append ttrad " '$nombre'"

                set old $GIDReport::_Informe($idx,valor)
                TextWindow $_w GIDReport::_Informe($idx,valor) "$ttrad" "$ttrad" \
                    -width 80 -height 30 -wrap none
                if { ![ string equal $GIDReport::_Informe($idx,valor) $old]} {
                    HayCambios si
                    ActualizaVistaPreviaInforme
                }
            } else {
                WarnWin $entrada
            }
        }

        proc MueveElementoArriba { } {
            variable _w
            variable _wPreview

            if { [ $_wPreview size] == 1} {
                return
            }
            set idx [ $_wPreview curselection]
            if { "$idx" == ""} {
                WarnWin [_ "Sorry, no element selected."] $_w
                return
            }
            if { $idx == 0} {
                return
            }
            set entrada [ $_wPreview get $idx]
            if { [ regexp {^([^:]+): (.*)} $entrada pepe nombre valor]} {
                set idx [ BuscaElemento $nombre]
                set encima [ expr $idx - 1]
                IntercambiaElementos $idx $encima
                ActualizaVistaPreviaInforme
                $_wPreview selection set $encima
                $_wPreview see $encima
            } else {
                WarnWin $entrada
            }
        }

        proc MueveElementoAbajo { } {
            variable _w
            variable _wPreview

            if { [ $_wPreview size] == 1} {
                return
            }
            set idx [ $_wPreview curselection]
            if { "$idx" == ""} {
                WarnWin [_ "Sorry, no element selected."] $_w
                return
            }
            if { $idx == [ expr [ $_wPreview size] - 1]} {
                return
            }
            set entrada [ $_wPreview get $idx]
            if { [ regexp {^([^:]+): (.*)} $entrada pepe nombre valor]} {
                set idx [ BuscaElemento $nombre]
                set debajo [ expr $idx + 1]
                IntercambiaElementos $idx $debajo
                ActualizaVistaPreviaInforme
                $_wPreview selection set $debajo
                $_wPreview see $debajo
            } else {
                WarnWin $entrada
            }
        }

        proc GuardarSiHaceFalta { } {
            variable _w
            variable _Archivo

            if { [ HayCambios]} {
                set retval [MessageBoxOptionsButtons [_ "Warning"] \
                    [_ "The last changes have not been saved. Do you want to save them?"] \
                    {0 1 2} [list [_ "Yes"] [_ "No"] [_ "Cancel"]] warning ""]
                if { $retval == 2 } { return 0 }
                if { $retval == 1 } { return 1 }
                if { "$_Archivo" == ""} {
                    if { ![ GIDReport::EscogeArchivoOrigen]} { return 0}
                }
                if { ![ GIDReport::GuardarHTML]} { return 0}
            }
            return 1
        }

        proc LeeHTML { } {
            variable _w
            variable _Archivo
            variable _DirectorioBase
            variable _DirectorioFotos
            variable _Titulo
            variable _Descripcion
            variable _Informe
            variable _NumFotos
            variable _NumParrafos
            variable _IncluirResumenProyecto
            variable _DirectorioTemporalBase
            variable _DirectorioTemporalFotos
            variable _Inicializando

            if { ![ file exists $_Archivo] } {
                WarnWin [_ "File '%s' does not exists" $_Archivo]
                return
            }

            InitVariables 1
            set _Inicializando 1
            set fi [ open $_Archivo]
            gets $fi linea
            while { ![ eof $fi]} {
                if { [ regexp {<title>([^<]*)</title>} $linea hola tmp]} {
                    set _Titulo [ getfromhtml $tmp]
                } elseif { [ regexp {<h3>([^<]*)</h3>} $linea hola tmp]} {
                    set _Descripcion [ getfromhtml $tmp]
                } elseif { [ regexp {<h3>(.*)} $linea hola tmp]} {
                    set _Descripcion [ getfromhtml $tmp]
                    while { ![ eof $fi]} {
                        gets $fi linea
                        if { "$_Descripcion" != ""} { append _Descripcion \n}
                        if { [ regexp {(.*)</h3>} $linea hola tmp]} {
                            append _Descripcion [ getfromhtml $tmp]
                            break
                        } else {
                            append _Descripcion [ getfromhtml $linea]
                        }
                    }
                } elseif { [ regexp {<a[ ]+name=\"Ini_([^\"]+)\"} $linea hola nombre]} {
                    if { [ regexp {^([^_]+)_([0-9]+)$} $nombre hola type num]} {
                        set valor ""
                        set otra_seccion 0
                        while { ![ eof $fi]} {
                            gets $fi linea
                            if { [ regexp {<a[ ]+name=\"(Ini|Fin)_([^\"]+)\"} $linea hola que nombre2]} {
                                if { "$que" == "Fin"} {
                                    break;
                                } else {
                                    set otra_seccion 1
                                }
                            } else {
                                if { "$valor" != ""} { append valor \n }
                                append valor [ getfromhtml $linea]
                            }
                        }
                        if { "$type" == "Paragraph"} {
                            if { $num > $_NumParrafos} {
                                set _NumParrafos $num
                            }
                            AnyadeElemento $nombre $valor
                        } elseif { "$type" == "View"} {
                            if { $num > $_NumFotos} {
                                set _NumFotos $num
                            }
                            AnyadeElemento $nombre $valor
                        } elseif { "$type" == "ProjectSummary"} {
                            set _IncluirResumenProyecto 1
                        }
                        if { $otra_seccion} {
                            # reiniciamos
                            continue
                        }
                    }
                }
                gets $fi linea
            }
            close $fi
            set _Inicializando 0

            # lo guardamos en el temporal
            GuardarHTML 1
            set tmpdir [ file join $_DirectorioTemporalBase $_DirectorioTemporalFotos]
            set srcdir [ file join $_DirectorioBase $_DirectorioFotos]
            #WarnWinText "CopiaImagenes $tmpdir $dstdir"
            CopiaImagenes $srcdir $tmpdir
            # y actualizamos links
            for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
                set nombre $_Informe($i,nombre)
                set valor $_Informe($i,valor)
                regsub -all $_DirectorioFotos $valor $_DirectorioTemporalFotos _Informe($i,valor)
            }

            # como lo acabamos de leer
            HayCambios no
            ActualizaVistaPreviaInforme
        }

        proc GetResumenProyecto { } {
            set estado_pre [GiD_Info list_entities prestatus]
            set estado_post ""
            if { [GiD_Info Project ViewMode] == "POSTUSE" } {
                set estado_post [GiD_Info list_entities status]
            }

            set info [ split $estado_pre \n]
            set out_txt "<table border=1>"
            append out_txt "\n<tr><th colspan=2 align=center><font size=+1>Model information</font></th></tr>"
            set malla_txt ""
            set hay_entidades_pre 0
            foreach linea $info {
                switch -regexp $linea {
                    "Project name:" {
                        if { [ regexp {Project name: (.*)$} $linea hola txt]} {
                            append out_txt "\n<tr><td><b>Project name</b></td><td>$txt</td></tr>"
                        }
                    }
                    "Problem type:" {
                        if { [ regexp {Problem type: (.*)$} $linea hola txt]} {
                            append out_txt "\n<tr><td><b>Problem type</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of points:" {
                        if { [ regexp {number of points: (.*)$} $linea hola txt]} {
                            append out_txt "\n<tr><td><b>Number of points</b></td><td>$txt</td></tr>"
                            if { "$txt" != "0"} {
                                set hay_entidades_pre 1
                            }
                        }
                    }
                    "number of lines:" {
                        if { [ regexp {number of lines: (.*)$} $linea hola txt]} {
                            append out_txt "\n<tr><td><b>Number of lines</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of surfaces:" {
                        if { [ regexp {number of surfaces: (.*)$} $linea hola txt]} {
                            append out_txt "\n<tr><td><b>Number of surfaces</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of volumes:" {
                        if { [ regexp {number of volumes: (.*)$} $linea hola txt]} {
                            append out_txt "\n<tr><td><b>Number of volumes</b></td><td>$txt</td></tr>"
                        }
                    }

                    "Degree of elements is:" {
                        if { [ regexp {Degree of elements is: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Degree of elements</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of nodes:" {
                        if { [ regexp {number of nodes: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of nodes</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of Tetrahedra elements:" {
                        if { [ regexp {number of Tetrahedra elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of tetrahedras</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of Hexahedra elements:" {
                        if { [ regexp {number of Hexahedra elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of hexahedras</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of Triangle elements:" {
                        if { [ regexp {number of Triangle elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of triangles</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of Quadrilateral elements:" {
                        if { [ regexp {number of Quadrilateral elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of quadrilaterals</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of Linear elements:" {
                        if { [ regexp {number of Linear elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of lines</b></td><td>$txt</td></tr>"
                        }
                    }
                    "number of Points elements:" {
                        if { [ regexp {number of Point elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Number of points</b></td><td>$txt</td></tr>"
                        }
                    }
                    "Total number of elements:" {
                        if { [ regexp {Total number of elements: (.*)$} $linea hola txt]} {
                            append malla_txt "\n<tr><td><b>Total number of elements</b></td><td>$txt</td></tr>"
                        }
                    }
                }
            }
            if { "$malla_txt" != ""} {
                append out_txt "\n<tr><th colspan=2 align=center><font size=+1>Mesh information</font></th></tr>"
                append out_txt $malla_txt
            }

            if { !$hay_entidades_pre} {
                set out_txt "<table border=1>"
            }

            if { "$estado_post" != ""} {
                set info [ split $estado_post \n]
                append out_txt "\n<tr><th colspan=2 align=center><font size=+1>Postprocess information</font></th></tr>"
                set hay_entidades_post 0
                foreach linea $info {
                    set parsed 0
                    switch -regexp $linea {
                        "number of nodes:" {
                            if { [ regexp {number of nodes: (.*)$} $linea hola txt]} {
                                append out_txt "\n<tr><td><b>Number of nodes</b></td><td>$txt</td></tr>"
                                set parsed 1
                                set hay_entidades_post 1
                            }
                        }
                        "Total number of elements:" {
                            if { [ regexp {Total number of elements: (.*)$} $linea hola txt]} {
                                append out_txt "\n<tr><td><b>Total number of elements</b></td><td>$txt</td></tr>"
                                set parsed 1
                            }
                        }
                    }
                    if { !$parsed} {
                        foreach eltyp {{points} {lines} {triangles} {quadratic triangles} {quadrilaterals} \
                            {quadratic quadrilaterals with 8 nodes} {quadratic quadrilaterals with 9 nodes} \
                            {tetrahedras} {hexahedras} {quadratic lines} {quadratic tetrahedras} \
                            {quadratic hexahedras with 20 nodes} {quadratic hexahedras with 27 nodes}} {
                                set clave "^\\+ ${eltyp}: (.+)"
                            if { [ regexp $clave $linea hola txt]} {
                                append out_txt "\n<tr><td><b>Number of $eltyp</b></td><td>$txt</td></tr>"
                                set parsed 1
                                break
                            }
                        }
                    }
                    if { !$parsed} {
                        if { [ regexp {^     (.+) with ([0-9]+) steps: (.*)$} $linea hola nombre_analisis num_steps which_steps]} {
                            regsub -all {_} $nombre_analisis { } txt_analisis
                            append out_txt "\n<tr><td><b>Analysis name</b></td><td>$txt_analisis</td></tr>"
                            append out_txt "\n<tr><td><b>Number of steps</b></td><td>$num_steps</td></tr>"
                            append out_txt "\n<tr><td><b>Steps</b></td><td>$which_steps</td></tr>"
                            set lst_res [ GiD_Info postprocess get results_list Contour_Fill $nombre_analisis [ lindex $which_steps 0]]
                            if { "$lst_res" != ""} {
                                append out_txt "\n<tr><td align=right>Results for '$txt_analisis', step '[ lindex $which_steps 0]'</td>\n   <td>"
                                set coma ""
                                foreach res $lst_res {
                                    regsub -all {_} $res { } txt
                                    append out_txt "$coma $txt"
                                    set coma ","
                                }
                                append out_txt "\n   </td></tr>"
                            }
                        }
                    }
                }
            }

            append out_txt "\n</table>"

            return $out_txt
        }

        proc putshtml { fo texto} {
            set mapa {
                �  "&aacute;"
                �  "&eacute;"
                �  "&iacute;"
                �  "&oacute;"
                �  "&uacute;"
                �  "&agrave;"
                �  "&egrave;"
                �  "&igrave;"
                �  "&ograve;"
                �  "&ugrave;"
                �  "&auml;"
                �  "&euml;"
                �  "&iuml;"
                �  "&ouml;"
                �  "&uuml;"
                �  "&acirc;"
                �  "&ecirc;"
                �  "&icirc;"
                �  "&ocirc;"
                �  "&ucirc;"
                �  "&ntilde;"
                �  "&ccedil;"
                �  "&Aacute;"
                �  "&Eacute;"
                �  "&Iacute;"
                �  "&Oacute;"
                �  "&Uacute;"
                �  "&Agrave;"
                �  "&Egrave;"
                �  "&Igrave;"
                �  "&Ograve;"
                �  "&Ugrave;"
                �  "&auml;"
                �  "&euml;"
                �  "&iuml;"
                �  "&ouml;"
                �  "&uuml;"
                �  "&acirc;"
                �  "&ecirc;"
                �  "&icirc;"
                �  "&ocirc;"
                �  "&ucirc;"
                �  "&Ntilde;"
                �  "&Ccedil;"
                �  "&middot;"
                �  "&iexcl;"
                �  "&iquest;"
            }

            set texto [string map $mapa $texto]
            puts $fo $texto
        }

        proc getfromhtml { texto} {
            set mapa {
                "&aacute;" �
                "&eacute;" �
                "&iacute;" �
                "&oacute;" �
                "&uacute;" �
                "&agrave;" �
                "&egrave;" �
                "&igrave;" �
                "&ograve;" �
                "&ugrave;" �
                "&auml;"   �
                "&euml;"   �
                "&iuml;"   �
                "&ouml;"   �
                "&uuml;"   �
                "&acirc;"  �
                "&ecirc;"  �
                "&icirc;"  �
                "&ocirc;"  �
                "&ucirc;"  �
                "&ntilde;" �
                "&ccedil;" �
                "&Aacute;" �
                "&Eacute;" �
                "&Iacute;" �
                "&Oacute;" �
                "&Uacute;" �
                "&Agrave;" �
                "&Egrave;" �
                "&Igrave;" �
                "&Ograve;" �
                "&Ugrave;" �
                "&auml;"   �
                "&euml;"   �
                "&iuml;"   �
                "&ouml;"   �
                "&uuml;"   �
                "&acirc;"  �
                "&ecirc;"  �
                "&icirc;"  �
                "&ocirc;"  �
                "&ucirc;"  �
                "&Ntilde;" �
                "&Ccedil;" �
                "&middot;" �
                "&iexcl;"  �
                "&iquest;" �
            }

            return [string map $mapa $texto]
        }

        proc SaveGiDReport { } {
            if { ![ HayCambios]} { return}
            GuardarHTML
        }

        proc GuardarHTML { { temporal 0}} {
            variable _w
            variable _Archivo
            variable _DirectorioBase
            variable _DirectorioFotos
            variable _Titulo
            variable _Descripcion
            variable _IncluirResumenProyecto
            variable _Informe
            variable _ArchivoTemporal
            variable _DirectorioTemporalBase
            variable _DirectorioTemporalFotos

            #if { ( "$_Archivo" == "") } {
            #    WarnWin "There is no report to view. Create it first and save it."
            #    return
            #}

            set archivo $_Archivo
            set directoriobase $_DirectorioBase
            set directoriofotos $_DirectorioFotos
            if { $temporal} {
                set archivo $_ArchivoTemporal
                set directoriobase $_DirectorioTemporalBase
                set directoriofotos $_DirectorioTemporalFotos
            }

            if { !$temporal} {
                if { ( "$archivo" == "") || \
                    ( [ string first UNNAMED $archivo] != -1) || \
                        ( [ string first [GiD_Info project TmpDirectory] $directoriobase] != -1) } {
                        return [ GuardarComoHTML]
                }

                if { [ file exist $archivo] && ![ file writable $archivo] } {
                    WarnWin [_ "Report cannot be modified. Please, check permissions of '%s'." $archivo]
                    return 0
                }
            }

            set titulo $_Titulo
            if { "$titulo" == ""} {
                set titulo [_ "Empty title"]
            }

            set fo [ open $archivo w]
            puts $fo "<html>"
            puts $fo "<head>"
            putshtml $fo "<title>$titulo</title>"
            puts $fo "</head>"
            puts $fo "<body text=#000000 bgcolor=#ffffff>"
            putshtml $fo "<h1>$titulo</h1>"

            if { "$_Descripcion" != ""} {
                putshtml $fo "<h3>$_Descripcion</h3>"
            }

            # tabla de contenido:
            if { $_IncluirResumenProyecto || ( $_Informe(NumElementos) > 0) } {
                puts $fo [concat "<a name=\"Contents\">" [_ "Report contents"]: "</a><ul>\n"]
                if { $_IncluirResumenProyecto} {
                    set nombre ProjectSummary_0
                    puts $fo [concat "<li><a href=\"#Ini_$nombre'>" [_ "Project summary"] "</a></li>\n"]
                }
                for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
                    set nombre $_Informe($i,nombre)
                    set valor $_Informe($i,valor)
                    puts $fo "<li><a href=\"#Ini_$nombre\">$nombre</a></li>\n"
                }
                puts $fo "</ul><br><br>\n"
            }



            if { $_IncluirResumenProyecto} {
                set txt [ GetResumenProyecto]
                if { "$txt" != ""} {
                    set nombre ProjectSummary_0
                    puts $fo "<a name=\"Ini_$nombre\"></a>"
                    putshtml $fo $txt
                    puts $fo "<a name=\"Fin_$nombre\"></a><a href=\"#Contents\">Top</a>"
                }
            }

            for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
                set nombre $_Informe($i,nombre)
                set valor $_Informe($i,valor)
                #if { [ regexp {([^_]+)_+} $nombre tmp type]} {
                #         switch "$type" {
                #             "Paragraph" {
                #             }
                #             "View" {
                #             }
                #         }
                #}
                puts $fo "<br clear=all>\n"
                puts $fo "<a name=\"Ini_$nombre\"></a>"
                if { !$temporal} {
                    regsub -all $_DirectorioTemporalFotos $valor $_DirectorioFotos tmp
                    set valor $tmp
                }
                putshtml $fo "$valor"
                puts $fo [concat "<a name=\"Fin_$nombre\"></a><a href=\"#Contents\">" [_ "Top"] "</a>"]
            }


            puts $fo "<br clear=all>\n"
            puts $fo "</body>"
            puts $fo "</html>"

            close $fo

            # las imagenes
            if { !$temporal} {
                set tmpdir [ file join $_DirectorioTemporalBase $_DirectorioTemporalFotos]
                set dstdir [ file join $_DirectorioBase $_DirectorioFotos]
                #WarnWinText "CopiaImagenes $tmpdir $dstdir"
                CopiaImagenes $tmpdir $dstdir
            }

            #esta ventana de confirmacion no es necesaria, y saldra cada vez que se guarda el modelo
            #ademas no siempre existe $_w
            #if { !$temporal} {
            #    WarnWin [_ "%s saved." $archivo] $_w
            #}

            if { !$temporal} {
                HayCambios no
            }
            return 1
        }

        proc CopiaImagenes { origen destino} {
            variable _Informe
            set fail 0
            # set origen [ file join $base_origen $html_origen]
            # set destino [ file join $base_destino $html_origen]
            CreaDirectorio $destino
            # for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
            #     set nombre $_Informe($i,nombre)
            #     set valor $_Informe($i,valor)
            #     regsub -all $html_origen $valor $html_destino _Informe($i,valor)
            # }
            foreach fi [ glob -nocomplain [ file join $origen *]] {
                set fail [GidUtils::CatchFileCopyForce $fi $destino]
                if { $fail } {
                    break
                }
            }
            return $fail
        }

        proc GuardarComoHTML { } {
            variable _Archivo
            variable _DirectorioBase
            variable _DirectorioFotos
            variable _Informe

            set OldDirectorioFotos $_DirectorioFotos
            set OldDirectorioBase $_DirectorioBase
            set OldArchivo $_Archivo

            if { ![ EscogeArchivoDestino]} { return 0}

            # set dir_fotos [ file join $_DirectorioBase $_DirectorioFotos]
            # set old_dir_fotos [ file join $OldDirectorioBase $OldDirectorioFotos]
            # CopiaImagenes $OldDirectorioBase $OldDirectorioFotos $_DirectorioBase $_DirectorioFotos
            # CreaDirectorio $dir_fotos
            # for { set i 0} { $i < $_Informe(NumElementos)} { incr i} {
            #     set nombre $_Informe($i,nombre)
            #     set valor $_Informe($i,valor)
            #     regsub -all $OldDirectorioFotos $valor $_DirectorioFotos _Informe($i,valor)
            # }
            # foreach fi [ glob -nocomplain [ file join $old_dir_fotos *]] {
            #     set fail [GidUtils::CatchFileCopyForce $fi $dir_fotos]
            # }

            return [ GuardarHTML]
        }

        proc VerInformeHTML { } {
            #variable _Archivo
            variable _w
            variable _ArchivoTemporal

            if { ![ HayCambios] && ( ( "$_ArchivoTemporal" == "") || ![ file exists $_ArchivoTemporal]) } {
                WarnWin [_ "There is no report to view. Create it first and save it."]
                return
            }

            if { ![ GIDReport::GuardarHTML 1]} { return}

            if { ![file exists $_ArchivoTemporal] } {
                WarnWin [_ "File '%s' does not exists" $_ArchivoTemporal]
                return
            }
            GiDHelpWindow -type REPORT -dir $_ArchivoTemporal
        }

        proc Reset { } {

            if { ![ GuardarSiHaceFalta] } { return }

            InitVariables
            ActualizaVistaPreviaInforme
        }

        proc Close { } {
            variable _w
            if { ![ GuardarSiHaceFalta] } { return }
            BorraTemporalUsado
            UnTraceVariables
            if { [winfo exists $_w] } { destroy $_w }
        }

        proc EscogeArchivoOrigen { { wWarn ""}} {
            variable _Archivo
            variable _DirectorioBase
            variable _DirectorioFotos
            variable _w

            if { ![ GuardarSiHaceFalta] } { return 0}

            set ini_dir $_DirectorioBase
            set ini_archivo $_Archivo
            if { ( "$ini_archivo" == "") || \
                ( [ string first UNNAMED $ini_archivo] != -1) || \
                    ( [ string first [GiD_Info project TmpDirectory] $ini_dir] != -1) } {
                    set proyecto [GiD_Info Project ModelName]
                set ini_dir ${proyecto}.gid
                set ini_archivo [ file tail $proyecto]
                if { ![GidUtils::ModelHasName] } {
                    set ini_dir [ pwd]
                    set ini_archivo ""
                }
                if { "[ file pathtype $ini_dir]" == "relative"} {
                    set ini_dir [ file join [ pwd] $ini_dir]
                }
                set ini_archivo [ file join ${ini_dir} ${ini_archivo}_GIDReport.html]
            }

            # no preseleccionamos ninguno
            set ini_archivo ""

            set types [ list \
                [ list [_ "Html file"] [ list .html .htm]] \
                [ list [_ "All files"] .*]]

            set tmp [ MessageBoxGetFilename file read [_ "Read report"] $ini_archivo \
                $types .html 0]

            if { "$tmp" == ""} { return 0}
            set _Archivo $tmp
            set _DirectorioBase [ file dirname $_Archivo]
            set _DirectorioFotos [ file rootname [ file tail $_Archivo]]_images

            set dir_fotos [ file join $_DirectorioBase $_DirectorioFotos]
            if { ![ file exist $dir_fotos] || ![ file isdirectory $dir_fotos]} {
                if { "$wWarn" != ""} {
                    $wWarn configure -state normal
                    $wWarn delete 0.0 end
                    $wWarn insert end [_ "Inside the directory '%s' a directory named '%s' will be created to store images." \
                        $_DirectorioBase $_DirectorioFotos]
                    $wWarn configure -state disabled
                } else {
                    WarnWin [_ "Inside the directory '%s' a directory named '%s' will be created to store images." \
                        $_DirectorioBase $_DirectorioFotos] $_w
                }
            }
            LeeHTML
            return 1
        }

        proc EscogeArchivoDestino { { wWarn ""}} {
            variable _Archivo
            variable _DirectorioBase
            variable _DirectorioFotos
            variable _w

            set ini_dir $_DirectorioBase
            set ini_archivo $_Archivo

            if { ( "$ini_archivo" == "") || \
                ( [ string first UNNAMED $ini_archivo] != -1) || \
                    ( [ string first [GiD_Info project TmpDirectory] $ini_dir] != -1) } {
                    set proyecto [GiD_Info Project ModelName]
                set ini_dir ${proyecto}.gid
                set ini_archivo [ file tail $proyecto]
                if { ![GidUtils::ModelHasName] } {
                    set ini_dir [ pwd]
                    set ini_archivo ""
                }
                if { "[ file pathtype $ini_dir]" == "relative"} {
                    set ini_dir [ file join [ pwd] $ini_dir]
                }
                set ini_archivo [ file join ${ini_dir} ${ini_archivo}_GIDReport.html]
            }

            # no preseleccionamos ninguno
            set ini_archivo ""
            set types [ list \
                [ list [_ "Html file"] [list .htm .html]] \
                [ list [_ "All files"] .*]]
            set tmp [ MessageBoxGetFilename file write [_ "Save report"] \
                $ini_archivo $types .html 0]

            if { "$tmp" == ""} { return 0}
            set _Archivo $tmp
            set _DirectorioBase [ file dirname $_Archivo]
            set _DirectorioFotos [ file rootname [ file tail $_Archivo]]_images
            if { "$wWarn" != ""} {
                $wWarn configure -state normal
                $wWarn delete 0.0 end
                $wWarn insert end [_ "Inside the directory '%s' a directory named '%s' will be created to store images." \
                    $_DirectorioBase $_DirectorioFotos]
                $wWarn configure -state disabled
            }
            return 1
        }

        proc Create { { w .gid.wGIDReport} } {
            variable _w
            variable _images
            variable _Archivo
            variable _DirectorioBase
            variable _DirectorioFotos
            variable _wPreview
            variable _IncluirResumenProyecto

            if { [ winfo exists $w]} {
                raise $w
                return
            }

            InitWindow2 $w -title [_ "%s report" $::GidPriv(ProgName)] \
                -geometryvariable PrePostGIDReportWindowGeom
            if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
            set _w $w

            # no la quiero transient
            set ::GidPriv(Transient,$w) 0
            ToggleTransientWin $w

            InitVariables
            CreaImagenes

            set color_fondo [ CCGetRGB $w [ $w cget -background]]
            set fondo_menu [ CCColorActivo $color_fondo]
            ttk::frame $w.menuiconos

            set icol 0
            ttk::frame $w.menuiconos.c
            # Guardar
            # GIDReport::GuardarHTML
            foreach nombre "Ayuda -- Nuevo Abrir Guardar GuardarComo VistaPrevia Close --" \
                cmd { GIDReport::Help "" GIDReport::Reset GIDReport::EscogeArchivoOrigen \
                GIDReport::GuardarHTML GIDReport::GuardarComoHTML \
                GIDReport::VerInformeHTML GIDReport::Close ""} {
                    set id_bt $w.menuiconos.c.i$icol
                if { "$nombre" != "--"} {
                    set ayuda $_images($nombre,ayuda)
                    ttk::button $id_bt -image $_images($nombre) -command $cmd
                    bind $id_bt <Enter> "catch { wm title $w.menuiconos \"$ayuda\" }"

                    if { "$ayuda" != ""} { GidHelp $id_bt $ayuda}
                } else {
                    # separador
                    ttk::label $id_bt -image $_images(Separador) -background $fondo_menu
                }
                grid $id_bt -row 0 -column $icol -sticky w
                incr icol
            }

            ttk::entry $w.menuiconos.c.e -width 20 -textvariable GIDReport::_Archivo -state disabled
            grid $w.menuiconos.c.e -row 0 -column $icol -sticky we
            grid rowconfigure $w.menuiconos.c 0 -weight 1
            grid columnconfigure $w.menuiconos.c $icol -weight 1
            incr icol

            grid $w.menuiconos.c -sticky ew -pady 2 -padx 4
            grid rowconfigure $w.menuiconos 0 -weight 1
            grid columnconfigure $w.menuiconos 0 -weight 1

            ttk::frame $w.ventana -borderwidth 0 -style ridge.TFrame


            # Titulo y descripcion
            set f [ttk::labelframe $w.ventana.rh -text [_ "Report header"]]

            ttk::frame $f.ft -borderwidth 0
            ttk::label $f.ft.l1 -text [_ "Title"]:
            ttk::entry $f.ft.e1 -width 20 -textvariable GIDReport::_Titulo
            grid $f.ft.l1 $f.ft.e1 -padx 4 -pady 2 -ipadx 2 -sticky e
            grid configure $f.ft.e1 -sticky ew
            grid rowconfigure $f.ft 0 -weight 1
            grid columnconfigure $f.ft 1 -weight 1

            ttk::frame $f.fd -borderwidth 0
            set wt [_ "Report description"]
            ttk::button $f.fd.desc -text [_ "Write description"] \
                -command "TextWindow $w GIDReport::_Descripcion \"$wt\" \"$wt\" -width 60 -height 10 -wrap none"
            grid $f.fd.desc -pady 2 -padx 4 -sticky ews

            grid $f.ft -sticky new
            grid $f.fd -sticky ews

            grid rowconfigure $f 1 -weight 1
            grid columnconfigure $f 0 -weight 1

            grid $w.ventana.rh -sticky new -padx 2

            focus $f.ft.e1

            # Insertar resumen proyecto
            set f [ttk::labelframe $w.ventana.ps -text [_ "Project summary"]]
            if { ![info exists GIDReport::_IncluirResumenProyecto] } { set GIDReport::_IncluirResumenProyecto 0 }
            ttk::checkbutton $f.cb -text [_ "Include project summary"] -variable GIDReport::_IncluirResumenProyecto
            grid $f.cb -pady 2 -padx 4 -sticky n
            grid rowconfigure $f 0 -weight 1
            grid columnconfigure $f 0 -weight 1
            grid $w.ventana.ps -sticky new -padx 2

            # insertar fotos
            set f [ttk::labelframe $w.ventana.iv -text [_ "Insert view"]]
            ttk::frame $f.ft -borderwidth 0
            ttk::label $f.ft.l1 -text [_ "Foot text"]:
            ttk::entry $f.ft.e1 -width 20 -textvariable GIDReport::_PieFoto
            grid $f.ft.l1 $f.ft.e1 -padx 4 -pady 2 -ipadx 2 -sticky e
            grid configure $f.ft.e1 -sticky ew
            grid rowconfigure $f.ft 0 -weight 1
            grid columnconfigure $f.ft 1 -weight 1

            ttk::frame $f.bot -borderwidth 0
            ttk::button $f.bot.insert -text [_ "Insert current view"] -command GIDReport::InsertarVista
            set fin [ttk::labelframe $f.bot.tf -text [_ "predefined width"]]

            if { ![info exists GIDReport::InsertImgWidth?] } {
                set ::GIDReport::InsertImgWidth? 0
                set ::GIDReport::InsertImgWidth 500
            }

            if { ![info exists GIDReport::InsertImgWidth?] } { set GIDReport::InsertImgWidth? 0 }
            ttk::checkbutton $fin.cb1 -text [_ "Width"]: -variable GIDReport::InsertImgWidth? \
                -command [string map [list SPINBOX $fin.e1] {
                    if { [set GIDReport::InsertImgWidth?] } {
                        SPINBOX configure -state normal
                    } else { SPINBOX configure -state disabled }
                    }]

                    ttk::spinbox $fin.e1 -from 1 -to 100000 -increment 50 -width 4 \
                        -textvariable GIDReport::InsertImgWidth
                    if { ![set GIDReport::InsertImgWidth?] } { $fin.e1 configure -state disabled }
                    grid $fin.cb1 $fin.e1
                    grid $f.bot.insert $f.bot.tf -pady 2 -padx 4 -sticky ews

                    grid $f.ft -sticky new
                    grid $f.bot -sticky ews

                    grid rowconfigure $f 0 -weight 1
                    grid columnconfigure $f 0 -weight 1

                    grid $w.ventana.iv -sticky new -padx 2


                    # insertar p�rrafo
                    set f [ttk::labelframe $w.ventana.ip -text [_ "Insert text paragraph"]]
                    set wt [_ "Insert text paragraph"]
                    ttk::button $f.par -text [_ "Insert paragraph"] \
                        -command "TextWindow $w GIDReport::_Parrafo \"$wt\" \"$wt\" \
                        -width 80 -height 30 -wrap none"
                    grid $f.par -pady 2 -padx 4 -sticky n

                    grid rowconfigure $f 0 -weight 1
                    grid columnconfigure $f 0 -weight 1

                    grid $w.ventana.ip -sticky new -padx 2


                    # resumen informe
                    set f [ttk::labelframe $w.ventana.rs -text [_ "Report summary"]]
                    ttk::frame $f.lb -borderwidth 0
                    ttk::scrollbar $f.lb.xscroll -orient horizontal \
                        -command "$f.lb.list xview"

                    ttk::scrollbar $f.lb.yscroll -orient vertical \
                        -command "$f.lb.list yview"

                    listbox $f.lb.list -height 5 -width 20 \
                        -xscroll "$f.lb.xscroll set" \
                        -yscroll "$f.lb.yscroll set" \
                        -selectmode browse -relief sunken -borderwidth 1

                    set _wPreview $f.lb.list

                    #bind $f.lb.list <ButtonRelease-1> ""
                    #bind $f.lb.list <Double-1> ""

                    grid $f.lb.list -sticky ewns
                    grid $f.lb.xscroll -sticky ew
                    grid $f.lb.yscroll -sticky ns -rowspan 2 -row 0 -column 1
                    grid rowconfigure $f.lb 0 -weight 1
                    grid columnconfigure $f.lb 0 -weight 1

                    ttk::frame $f.bot -borderwidth 0
                    ttk::button $f.bot.edit -text [_ "Edit"] -command GIDReport::EditaTextoElementoLista
                    ttk::frame $f.bot.updown -borderwidth 0
                    ttk::button $f.bot.updown.arriba -image $_images(FlechaArriba) -command GIDReport::MueveElementoArriba
                    ttk::button $f.bot.updown.abajo -image $_images(FlechaAbajo) -command GIDReport::MueveElementoAbajo
                    grid $f.bot.updown.arriba -sticky new -padx 2 -pady 1
                    grid $f.bot.updown.abajo -sticky sew -padx 2 -pady 1

                    ttk::button $f.bot.del -text [_ "Delete"] -command GIDReport::BorraElementoLista
                    bind $f.lb.list <Double-Button-1> GIDReport::EditaTextoElementoLista
                    bind $f.lb.list <Return> GIDReport::EditaTextoElementoLista
                    bind $f.lb.list <Delete> GIDReport::BorraElementoLista

                    GidHelp $f.bot.edit [_ "Edit current element"]
                    GidHelp $f.bot.updown.arriba $_images(FlechaArriba,ayuda)
                    GidHelp $f.bot.updown.abajo $_images(FlechaAbajo,ayuda)
                    GidHelp $f.bot.del [_ "Delete current element from report"]

                    #ttk::button $f.bot.view -text [_ "View"] -command GIDReport::VerInformeHTML
                    #grid $f.bot.del $f.bot.view -sticky w
                    #grid configure $f.bot.view -sticky e
                    grid $f.bot.edit $f.bot.updown $f.bot.del -sticky w -padx 4 -pady 2
                    grid rowconfigure $f.bot 0 -weight 1
                    #grid columnconfigure $f.bot 0 -weight 1
                    #grid columnconfigure $f.bot 1 -weight 1
                    #grid columnconfigure $f.bot 1 -weight 1

                    grid $f.lb -sticky nsew
                    grid $f.bot -sticky ew

                    grid rowconfigure $f 0 -weight 1
                    grid columnconfigure $f 0 -weight 1



                    grid $w.ventana.rs -sticky news -row 0 -column 1 -rowspan 4 -padx 2

                    grid rowconfigure $w.ventana 0 -weight 1
                    grid rowconfigure $w.ventana 1 -weight 1
                    grid rowconfigure $w.ventana 2 -weight 1
                    grid rowconfigure $w.ventana 3 -weight 1
                    grid columnconfigure $w.ventana 0 -weight 1
                    grid columnconfigure $w.ventana 1 -weight 4

                    ####################################
                    ### Botones
                    ####################################

                    ttk::frame $w.botones -style BottomFrame.TFrame
                    ttk::button $w.botones.guardar -text [_ "Save"] -style BottomFrame.TButton \
                        -command GIDReport::GuardarHTML
                    ttk::button $w.botones.guardarcomo -text [_ "Save as"]... -style BottomFrame.TButton \
                        -command GIDReport::GuardarComoHTML
                    ttk::button $w.botones.reset -text [_ "Reset"] -style BottomFrame.TButton \
                        -command GIDReport::Reset
                    ttk::button $w.botones.close -text [_ "Close"] -style BottomFrame.TButton \
                        -command GIDReport::Close

                    GidHelp $w.botones.guardar [_ "Save the HTML report"]
                    GidHelp $w.botones.guardarcomo [_ "Save the HTML report with another name"]

                    GidHelp $w.botones.reset [_ "Values of this window will be restored to the ones used before the window was openned."]

                    GidHelp $w.botones.close [_ "The window will be closed losing the changes made but not applied."]

                    grid $w.botones.guardar $w.botones.guardarcomo $w.botones.reset $w.botones.close \
                        -pady 10 -padx 4 -sticky ews

                    grid $w.menuiconos -sticky new
                    grid $w.ventana -sticky wens -pady 4 -padx 4
                    #grid $w.botones -sticky sew
                    #grid anchor $w.botones center

                    grid rowconfigure $w 1 -weight 1
                    grid columnconfigure $w 0 -weight 1

                    TraceVariables

                    wm protocol $w WM_DELETE_WINDOW GIDReport::Close

                    LeeHTML
                }

                proc AnyadeAlInforme { texto} {
                    variable _w

                    if { ![ info exists _w] || ![ winfo exists $_w]} {
                        set retval [MessageBoxOptionsButtons [_ "Warning"] \
                            [_ "There is no active report. Do you want to create one?"] \
                            {0 1} [list [_ "Ok"] [_ "Cancel"]] warning ""]
                        if { $retval == 1 } { return 1 }
                        Create
                    }
                    InsertarTexto $texto
                    raise $_w
                }

                proc AddToReport { texto} { AnyadeAlInforme $texto}

            }

            namespace eval GIDReportData {
                variable _Inicializado
                variable _Datos

                proc Reset { } {
                    variable _Inicializado
                    variable _Datos

                    set _Inicializado 1
                    set _Datos {}
                }

                proc VerificaEstado { } {
                    variable _Inicializado

                    if { ![ info exists _Inicializado] || !$_Inicializado} {
                        Reset
                    }
                }

                proc AnyadeDatos { args} {
                    variable _Datos

                    VerificaEstado
                    lappend _Datos $args
                }

                proc AddData { args} {
                    variable _Datos

                    VerificaEstado
                    lappend _Datos $args
                }

                proc GetDatosHTML { { como_tabla 0}} {
                    variable _Datos

                    VerificaEstado
                    if { [ llength $_Datos] == 0} {
                        return ""
                    }
                    if { $como_tabla} {
                        set max_cols 0
                        foreach fila $_Datos {
                            set ncols [ llength $fila]
                            if { $ncols > $max_cols} { set max_cols $ncols}
                        }
                        set texto "<table border=1>"
                        foreach fila $_Datos {
                            set ncols [ llength $fila]
                            set columnspan 0
                            if { $ncols < $max_cols} {
                                set columnspan [ expr $max_cols - $ncols + 1]
                            }
                            append texto "\n<tr>"
                            set i 0
                            for { set i 0} { $i < [ expr $ncols - 1]} { incr i} {
                                set align left
                                if { !$i} { set align right}
                                append texto "<td align=$align>[ lindex $fila $i]</td>"
                            }
                            if { $columnspan > 1} {
                                set align left
                                if { !$i} { set align center}
                                append texto "<td colspan=$columnspan align=$align>"
                            } else {
                                append texto "<td align=left>"
                            }
                            append texto "[ lindex $fila $i]</td></tr>"
                        }
                        append texto "\n</table>"
                    } else {
                        set texto ""
                        foreach fila $_Datos {
                            foreach dd $fila {
                                append texto "$dd; "
                            }
                            append texto \n
                        }
                    }
                    return $texto
                }

                proc GetDataHTML { { como_tabla 0}} {
                    return [ GetDatosHTML $como_tabla]
                }
            }

