# interface generated by SpecTcl version 1.1 from /usr2/people/ramsan/bin/specsamples/ProcWin.ui
#   root     is the parent window for this user interface

proc GiD_GetNumProcessesRunning { } {
    set num_running 0
    if { [info exists ::RunProcInfo] } {
        set num_running [llength $::RunProcInfo]
    }
    return $num_running
}

proc ProcWin_ui {root args} {

        # this treats "." as a special case

        if {$root == "."} {
            set base ""
        } else {
            set base $root
        }
        
        ttk::frame $base.frame#2 -style groove.TFrame -borderwidth 3
        ttk::frame $base.frame#6 -style BottomFrame.TFrame        
        ttk::frame $base.frame#1 -borderwidth 2 -style groove.TFrame
        label $base.label#1 -text [_ "Project     Start time    UID     Priority"]
        listbox $base.listbox#1 -height 8 -width 40 \
                -xscrollcommand "$base.scrollbar#1 set" \
                -yscrollcommand "$base.scrollbar#2 set" -selectmode browse

        ttk::scrollbar $base.scrollbar#2 -command [list $base.listbox#1 yview] -orient vertical
        ttk::scrollbar $base.scrollbar#1 -command [list $base.listbox#1 xview] -orient horizontal

        menu $base.runprocmenu
        bind $base.listbox#1 <1> "focus $base.listbox#1"
        if { [esMac] } {
            bind $base.listbox#1 <$::gid_central_button> "event generate $base.listbox#1 <1> -rootx %X -rooty %Y ; ShowRunprocMenu $base %X %Y"
        } else {
            bind $base.listbox#1 <$::gid_right_button> "event generate $base.listbox#1 <1> -rootx %X -rooty %Y ; ShowRunprocMenu $base %X %Y"
        }

        ttk::button $base.button#1 -text [_ "Output view"] -command [list PWViewOutput window]                           
        ttk::button $base.button#2 -text [_ "Terminate"] -command [list PWKillProc window]                          
                          
        # label $base.lblPriority -text [_ "Priority"]:
        # TTKMenubutton $base.mbPriority -state readonly \
            #     -labels [ list [_ "Above Normal"] [_ "Normal"] [_ "Below normal"] [_ "Low"]] \
            #     -values [ list 3 4 5 6] 
        # #-variable ::RunProcInfo(priority)

        ttk::button $base.button#4 -text [_ "Start"] -command {GiD_Process Mescape Utilities Calculate} -style BottomFrame.TButton                            
        focus $base.button#4

        ttk::button $base.button#45 -text [_ "Start remote"] -command {GiD_Process Mescape Utilities RemoteCalc} -style BottomFrame.TButton                           
        ttk::button $base.button#47 -text [_ "Remote"]... -command [list PWUpdate $base.update] -style BottomFrame.TButton                            
        ttk::button $base.button#5 -text [_ "Close"] -command [list destroy $base] -style BottomFrame.TButton

        # Geometry management
        grid $base.frame#2 -in $base.frame#1 -row 4 -column 1 -sticky nw -padx 1 -pady 1
        grid $base.frame#6 -in $root -row 3 -column 1 -sticky ew
        grid anchor $base.frame#6 center
        grid $base.frame#1 -in $root -row 1 -column 1 -sticky nesw -columnspan 2  -padx 3 -pady 3
        grid $base.label#1 -in $base.frame#1 -row 1 -column 1 -sticky w -pady 3 -padx 3
        grid $base.listbox#1 -in $base.frame#1 -row 2 -column 1  -sticky nesw
        grid $base.scrollbar#2 -in $base.frame#1  -row 2 -column 2 -sticky ns
        grid $base.scrollbar#1 -in $base.frame#1 -row 3 -column 1 -sticky ew
        grid $base.button#1 -in $base.frame#2 -row 1 -column 1 -sticky w -padx 3
        grid $base.button#2 -in $base.frame#2 -row 1 -column 2 -sticky w -padx 3
        # grid $base.lblPriority -in $base.frame#2 -row 1 -column 3 -sticky e -padx 3
        # grid $base.mbPriority -in $base.frame#2 -row 1 -column 4 -sticky w -padx 3

        grid $base.button#4 $base.button#45 $base.button#47 $base.button#5 -in $base.frame#6 -padx 3 -pady 3

        # Resize behavior management
#         grid rowconfigure $base.frame#6 1 -weight 0
#         grid columnconfigure $base.frame#6 "1 2 3 4" -weight 1

        grid columnconfigure $base.frame#2 "1 2" -weight 1

        grid rowconfigure $root 1 -weight 1
        grid columnconfigure $root 1 -weight 1

        grid rowconfigure $base.frame#1 2 -weight 1
        grid columnconfigure $base.frame#1 1 -weight 1
}

# prioridades como en unix:
# 0 - normal
# 1, 2 - below normal, idle/baja
# -1, -2, -3 - above normal, high, realtime
proc getPriorityStr { numPri} {
    if { $::tcl_platform(platform) == "windows"} {
        return [ lindex [ list [_ "Real time"] [_ "High"] [_ "Above Normal"] [_ "Normal"] [_ "Below normal"] [_ "Low"]] [ expr $numPri + 3]]
    } elseif { $::tcl_platform(platform) == "unix"} {
        set txt [_ "normal"]
        if { $numPri < 0} {
            set txt [_ "higher"]
        } elseif { $numPri > 0} {
            set txt [_ "lower"]
        }
        set txt "$numPri ( $txt)"
    }
}

proc PWChangePriority { procID newPriority oldPri} {
    if { $procID == "remote" } {
        WarnWin [_ "Priority can't be changed for a remote process"]
        return
    }
    set txtPriority [ getPriorityStr $newPriority]
    set old [ getPriorityStr $oldPri]
    set addTXT ""
    if { [ esMac]} {
        set addTXT [_ "Be aware that on Mac OS X, once the priority of a process has been lowered, it may not be possible to increase it."]
        set addTXT \n${addTXT}\n\n
    }
    set resp [GID_tk_messageBox -parent $::GidProcWin(w).listbox\#1 -default no -title [_ "Confirm"] -type yesno \
                   -message [_ "Warning: If you change the priority of this process, \nundesired results may occur, \nincluding the inestability of the system. \n%s Are you sure you want to change the priority \nfrom '%s' to '%s'?" $addTXT $old $txtPriority]]
    if { $resp == "yes"} {        
        gidproc configure $procID -priority $newPriority
    }
}

proc getCPUlist { aff { max_cpus 8}} {
    set cpus {}
    for { set id 0} { $id < $max_cpus} { incr id} {
        if { $aff & ( 1 << $id)} { 
            lappend cpus $id
        }
    }
    return $cpus
}

proc PWChangeAffinity { procID cpu oldAff} {
    if { $procID == "remote" } {
        WarnWin [_ "Affinity can't be changed for a remote process"]
        return
    }
    set newAff [ expr ( 1 << $cpu) ^ $oldAff]

    set oldCPUs ""
    foreach c [ getCPUlist $oldAff] {
        lappend oldCPUs [ expr $c + 1]
    }
    set newCPUs ""
    foreach c [ getCPUlist $newAff] {
        lappend newCPUs [ expr $c + 1]
    }

    set resp [GID_tk_messageBox -parent $::GidProcWin(w).listbox\#1 -default no -title [_ "Confirm"] -type yesno \
                   -message [_ "Warning: If you change the affinity of this process, \nundesired results may occur, \nincluding the inestability of the system. \nAre you sure you want to change the affinity \nfrom CPU ids: %s \nto CPU ids: %s?" \
                                 $oldCPUs $newCPUs]]
    if { $resp == "yes"} {
        gidproc configure $procID -affinity $newAff
    }
}

proc setPriorityMenuForWindows { wmenu wbase idx} {

    set procID [ lindex [ lindex $::RunProcInfo $idx] 2]   

    # Priority entry
    $wmenu add cascade -label [_ "Set priority"] -menu $wmenu.priority
    if { [ winfo exists $wmenu.priority]} {
        $wmenu.priority delete 0 end
    } else {
        menu $wmenu.priority 
    }    
    if { $procID == "remote" } {
        #priority can't be changed for a remote process
    } else {
        set ::RunprocMenu(actPri) [ gidproc configure $procID -priority]
        foreach lbl [ list [_ "Above normal"] [_ "Normal"] [_ "Below normal"] [_ "Low"]] val [ list -1 0 1 2] {
                # set chk 0
                # if { $val == $actPri} {
                #         set chk 1
                # }
                # -indicatoron $chk <-- esto no funciona
                $wmenu.priority add checkbutton -label $lbl \
                    -onvalue $val -offvalue 0 -variable ::RunprocMenu(actPri) \
                    -command "PWChangePriority $procID $val $::RunprocMenu(actPri); ActualizeProcsListBox $wbase"
            }
        set ::RunprocMenu(actPri) $::RunprocMenu(actPri)
    }
}

proc setPriorityMenuForUnix { wmenu wbase idx} {

    set procID [ lindex [ lindex $::RunProcInfo $idx] 2]

    # Priority entry
    $wmenu add cascade -label [_ "Set priority"] -menu $wmenu.priority
    if { [ winfo exists $wmenu.priority]} {
        $wmenu.priority delete 0 end
    } else {
        menu $wmenu.priority 
    }
    if { $procID == "remote" } {
        #priority can't be changd for a remote process
    } else {
        set ::RunprocMenu(actPri) [ gidproc configure $procID -priority]
        for { set val -2} { $val <= 20} { incr val} {
            # set chk 0
            # if { $val == $actPri} {
            #         set chk 1
            # }
            # -indicatoron $chk <-- esto no funciona
            set lbl [ getPriorityStr $val]
            if { [ esMac]} { # si algo comienza con '-' en Mac pone una linea divisoria
                set lbl " $lbl"
            }
            $wmenu.priority add checkbutton -label $lbl \
                -onvalue $val -offvalue 0 -variable ::RunprocMenu(actPri) \
                -command "PWChangePriority $procID $val $::RunprocMenu(actPri); ActualizeProcsListBox $wbase"
        }
        set ::RunprocMenu(actPri) $::RunprocMenu(actPri)
    }
}

proc setAffinityMenu { wmenu wbase idx} {
    set procID [ lindex [ lindex $::RunProcInfo $idx] 2]
    
    # Affinity entry
    $wmenu add cascade -label [_ "Set affinity"] -menu $wmenu.affinity
    if { [ winfo exists $wmenu.affinity]} {
        $wmenu.affinity delete 0 end
    } else {
        menu $wmenu.affinity 
    }
    if { $procID == "remote" } {
        #affinity can't be changd for a remote process
    } else {
        set actAff [ gidproc configure $procID -affinity]
        set actCpuLst [ getCPUlist $actAff]
        foreach idCPU {0 1 2 3 4 5 6 7} {
            set lbl "CPU [ expr $idCPU + 1]"
            set chk 0
            if { [ lsearch $actCpuLst $idCPU] != -1} {
                set chk 1
            }
            # no funciona el -indicatoron 1 / 0, asi que toca hacer esto
            set ::RunprocMenu(cpu$idCPU) $chk
            $wmenu.affinity add checkbutton -label $lbl \
                -onvalue 1 -offvalue 0 -variable ::RunprocMenu(cpu$idCPU) \
                -command "PWChangeAffinity $procID $idCPU $actAff; ActualizeProcsListBox $wbase"
        }
    }
}

proc ShowRunprocMenu { base X Y } {
    global GidProcWin RunProcInfo
    if { ![info exists RunProcInfo] } return
    if { ![info exists ::GidProcWin(w)] || ![winfo exists $::GidProcWin(w).listbox#1] } {
        set wbase .gid
        set w ""
    } else {
        set wbase $::GidProcWin(w)
        set w $::GidProcWin(w).listbox#1
    }

    set i [$w curselection]
    if { $i < 0 } return

    $wbase.runprocmenu delete 0 end
    set state [lindex [lindex $RunProcInfo $i] 9]
    if { [lindex $state 0] == "RESULTSINSERVER" } {
        set name [lindex [lindex $RunProcInfo $i] 0]
        $wbase.runprocmenu add command -label [_ "Download results"] -command "update ; [list PWBeginCommand DOWNLOADRESULTS $name]"
        $wbase.runprocmenu add command -label [_ "Delete remote results"] -command [list PWKillProc window]
    } else {
        $wbase.runprocmenu add command -label [_ "Output view"] -command [list PWViewOutput window]
        $wbase.runprocmenu add command -label [_ "Terminate"] -command [list PWKillProc window]
        if { $::tcl_platform(platform) == "windows"} {
            setPriorityMenuForWindows $wbase.runprocmenu $wbase $i
        } elseif { $::tcl_platform(platform) == "unix"} {
            setPriorityMenuForUnix $wbase.runprocmenu $wbase $i
        }
        if { ![ esMac]} {
            setAffinityMenu $wbase.runprocmenu $wbase $i
        }
    }
    tk_popup $wbase.runprocmenu $X $Y
}

proc PWUpdateDefaults { w } {
    global GidProcWin
    set msg [_ "Revert to user defaults or to program defaults?"]
    set retval [MessageBoxOptionsButtons [_ "defaults type"] $msg [list user program -cancel-] [list [_ "User"] [_ "Program"] [_ "Cancel"]] question ""]
    switch $retval {
        user {
            set ::GidProcWin(remoteauto) $::GidProcWin(remoteautoold)
            set ::GidProcWin(remotetime) $::GidProcWin(remotetimeold)
            set ::GidProcWin(remoteport) $::GidProcWin(remoteportold)
            set ::GidProcWin(remotetimeout) $::GidProcWin(remotetimeoutold)
            set ::GidProcWin(securemode) $::GidProcWin(securemodeold)
            set ::GidProcWin(remoteresultsdownload) $::GidProcWin(remoteresultsdownloadold)
            set ::GidProcWin(remoteresultsdelete) $::GidProcWin(remoteresultsdeleteold)        
        }
        program {
            set ::GidProcWin(remoteauto) 1
            set ::GidProcWin(remotetime) 10
            set ::GidProcWin(remoteport) 2048
            set ::GidProcWin(remotetimeout) 30
            set ::GidProcWin(securemode) "BF"
            set ::GidProcWin(remoteresultsdownload) "Automatic"
            set ::GidProcWin(remoteresultsdelete) "Automatic"
        }
        -cancel- {
            #do nothing
        }
    }
}

proc PWUpdate { w } {
    global GidProcWin

    InitWindow2 $w -title [_ "Remote analysis properties"] \
        -geometryvariable PreRemoteAnalysisPropertiesWindowGeom \
        -initcommand PWUpdate -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    if { ![info exists ::GidProcWin(remoteauto)] } {
        set ::GidProcWin(remoteauto) 1
    }
    if { ![info exists ::GidProcWin(remotetime)] } {
        set ::GidProcWin(remotetime) 10
    }
    if { ![info exists ::GidProcWin(remoteport)] } {
        set ::GidProcWin(remoteport) 2048
    }
    if { ![info exists ::GidProcWin(remotetimeout)] } {
        set ::GidProcWin(remotetimeout) 30
    }

    set ::GidProcWin(remoteautoold) $::GidProcWin(remoteauto)
    set ::GidProcWin(remotetimeold) $::GidProcWin(remotetime)
    set ::GidProcWin(remoteportold) $::GidProcWin(remoteport)
    set ::GidProcWin(remotetimeoutold) $::GidProcWin(remotetimeout)
    set ::GidProcWin(securemodeold) $::GidProcWin(securemode)
    set ::GidProcWin(remoteresultsdownloadold) $::GidProcWin(remoteresultsdownload)
    set ::GidProcWin(remoteresultsdeleteold) $::GidProcWin(remoteresultsdelete)

    framelabel $w.f1 [_ "Remote Options"]
    ttk::frame $w.f1.f1 -borderwidth 2 -style groove.TFrame
    if { ![info exists ::GidProcWin(remoteauto)] } { set ::GidProcWin(remoteauto) 0 }
    ttk::checkbutton $w.f1.f1.l -text [_ "Automatic remote update"] -variable ::GidProcWin(remoteauto)
    ttk::label $w.f1.f1.l1 -text [_ "Every"]:
    ttk::entry $w.f1.f1.e -width 5 -textvar ::GidProcWin(remotetime)
    ttk::label $w.f1.f1.l2 -text [_ "sec"]

    GidHelp "$w.f1.f1.l $w.f1.f1.l1 $w.f1.f1.e $w.f1.f1.l2" [_ "If remote update is set, program will\
            contact automatically with the sever one time every given seconds, to check if\
            process has finished and also to get status information"]

    ttk::label $w.f1.f1.l3 -text [_ "Timeout"]:
    ttk::entry $w.f1.f1.e2 -width 5 -textvar ::GidProcWin(remotetimeout)
    ttk::label $w.f1.f1.l4 -text [_ "sec"]

    GidHelp "$w.f1.f1.l3 $w.f1.f1.e2 $w.f1.f1.l4" [_ "this is the time that program will wait for server to\
            respond. After this time it will consider that connection has failed. Increase the\
            time if your connection is slow."]

    grid $w.f1.f1.l -row 1 -column 1 -columnspan 3 -sticky w -pady 1
    grid $w.f1.f1.l1 -row 2 -column 1
    grid $w.f1.f1.e -row 2 -column 2 -sticky ew
    grid $w.f1.f1.l2 -row 2 -column 3
    grid $w.f1.f1.l3 -row 3 -column 1
    grid $w.f1.f1.e2 -row 3 -column 2 -sticky ew
    grid $w.f1.f1.l4 -row 3 -column 3
    grid columnconf $w.f1.f1 2 -weight 1

    ttk::frame $w.f1.f2 -borderwidth 2 -style groove.TFrame

    ttk::label $w.f1.f2.l5 -text [_ "Port"]:
    ttk::entry $w.f1.f2.e3 -width 5 -textvar ::GidProcWin(remoteport)
    GidHelp "$w.f1.f2.l5 $w.f1.f2.e3" [_ "This is the connection port. Do not change it unless your are\
            notified that your server use another port."]

    if { ![info exists ::GidProcWin(securemode)] } { set ::GidProcWin(securemode) "NONE" }
    ttk::checkbutton $w.f1.f2.cbt -text [_ "Secure connection"] -variable ::GidProcWin(securemode) -onvalue "BF" -offvalue "NONE"
    GidHelp "$w.f1.f2.cbt" [_ "Check for a encryted secure connection with the server."]

    grid $w.f1.f2.l5 -row 1 -column 1
    grid $w.f1.f2.e3 -row 1 -column 2 -sticky ew
    grid $w.f1.f2.cbt -row 2 -column 1 -columnspan 3  -sticky w
    grid columnconf $w.f1.f2 2 -weight 1

    grid $w.f1.f1 $w.f1.f2 -sticky nsew
    grid columnconf $w.f1 "0 1" -weight 1

    framelabel $w.f2 [_ "Remote results"]
    ttk::frame $w.f2.f1 -borderwidth 2 -style groove.TFrame
    ttk::frame $w.f2.f2 -borderwidth 2 -style groove.TFrame
    ttk::label $w.f2.f1.lb1 -text [_ "Download"]
    ttk::radiobutton $w.f2.f1.rbt1 -text [_ "Automatic"] -variable ::GidProcWin(remoteresultsdownload) -value "Automatic"
    ttk::radiobutton $w.f2.f1.rbt2 -text [_ "Manual"] -variable ::GidProcWin(remoteresultsdownload) -value "Manual"
    GidHelp "$w.f2.f1.lb1 $w.f2.f1.rbt1 $w.f2.f1.rbt2" \
            [_ "If automatic, when the analysis is finished, the results are automatically downloaded."]
    ttk::label $w.f2.f2.lb1 -text [_ "File Storage after download"]
    ttk::radiobutton $w.f2.f2.rbt1 -text [_ "Delete"] -variable ::GidProcWin(remoteresultsdelete) -value "Automatic"
    ttk::radiobutton $w.f2.f2.rbt2 -text [_ "Mantain"] -variable ::GidProcWin(remoteresultsdelete) -value "Manual"
    GidHelp  "$w.f2.f2.lb1 $w.f2.f2.rbt1 $w.f2.f2.rbt1" \
            [_ "If automatic, after a download the results are automatically deleted from the server."]
    grid $w.f2.f1.lb1 -sticky w -pady 1
    grid $w.f2.f1.rbt1 -sticky w -pady 1
    grid $w.f2.f1.rbt2  -sticky w -pady 1
    grid $w.f2.f2.lb1  -sticky w -pady 1
    grid $w.f2.f2.rbt1 -sticky w -pady 1
    grid $w.f2.f2.rbt2  -sticky w -pady 1
    grid $w.f2.f1 $w.f2.f2 -sticky nsew
    grid columnconf $w.f2 "0 1" -weight 1

    framelabel $w.f3 [_ "Status"]
    ttk::label $w.f3.ltext -textvar ::GidProcWin(remotemessages) -justify left -anchor nw
    grid $w.f3.ltext -column 1 -row 1 -sticky nsew -padx 2 -pady 2
    grid columnconf $w.f3 1 -weight 1
    grid rowconf $w.f3 1 -weight 1

    bind $w.f3.ltext <Configure> "after idle $w.f3.ltext configure -wraplength \[winfo width $w.f3.ltext]"

    ttk::frame $w.buts -style BottomFrame.TFrame   

    ttk::button $w.buts.un -text [_ "Update now"] -style BottomFrame.TButton -command "ActualizeProcInfo force" -underline 0
    ttk::button $w.buts.ok -text [_ "Defaults"]... -style BottomFrame.TButton -command [list PWUpdateDefaults $w] -underline 0
    ttk::button $w.buts.infoserver -text [_ "Info"]... -style BottomFrame.TButton -command "PWMainRemoteCommand USERINFO" -underline 0
    ttk::button $w.buts.queueinfo -text [_ "Queue info"] -style BottomFrame.TButton -command "PWMainRemoteCommand {QUEUE INFO}" -underline 0
    ttk::button $w.buts.jobparams -text [_ "Job params"] -style BottomFrame.TButton -command "PWMainRemoteCommand {JOB INFO}" -underline 0
    ttk::button $w.buts.logout -text [_ "Logout"] -style BottomFrame.TButton -command PWForgetPassword -underline 0
    ttk::button $w.buts.close -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w] -underline 0
    focus $w.buts.ok

    bind $w <Alt-u> "$w.buts.un invoke"
    bind $w <Alt-d> "$w.buts.ok invoke"   

    grid $w.buts.un $w.buts.ok $w.buts.infoserver $w.buts.logout $w.buts.close -padx 2 -pady 3
    # grid $w.buts.un $w.buts.ok $w.buts.infoserver $w.buts.queueinfo $w.buts.jobparams $w.buts.close -padx 2 -pady 3    

    set FramesSeparation [framelabelsep]
    grid $w.f1 -column 1 -row 1 -sticky ew -pady $FramesSeparation
    grid $w.f2 -column 1 -row 2 -sticky ew -pady $FramesSeparation
    grid $w.f3 -column 1 -row 3 -sticky ewns -pady [expr $FramesSeparation-4]
    grid $w.buts -column 1 -row 4 -sticky ewns
    grid anchor $w.buts center
    grid columnconf $w 1 -weight 1
    grid rowconf $w 3 -weight 1
}

# type can be error or warning
proc PWViewOutputError { type name filename } {
    set w .gid.viewoutputerror
    set text_error ""
    if { [gid_filesystem::file exists $filename] } {
        set text_error [string trim [gid_filesystem::read_file $filename "" 0]]
    }
    if { $text_error == "" } {
        return 1
    }
    if { [GidUtils::IsTkDisabled] } {
        #flag -n , without load Tk
        return 0
    }

    set text ""
    set title ""
    if { $type == "error" } {
        set title [_ "Process errors"]
        set text [_ "Process '%s' has finished with errors." $name]
    } else {
        set title [_ "Process warnings"]
        set text [_ "Process '%s' has finished correctly but with warnings" $name]
    }
    InitWindow2 $w -title $title -geometryvariable PreViewOutputErrorWindowGeom \
        -onlygeometry -ontop
    if { ![winfo exists $w] } {
        return 0;# windows disabled || UseMoreWindows == 0
    }
        
    # The following command has been removed because if it is present
    # the dialog won't be posted if [winfo parent $w] is iconified.

    ttk::frame $w.bottom -style BottomFrame.TFrame   
    ttk::frame $w.top -style raised.TFrame -borderwidth 1
    
    ttk::label $w.top.bitmap -image [gid_themes::GetImage error.png]
    ttk::label $w.top.msg -justify left -text $text -wraplength 75m -font BigFont
   
    grid $w.top.bitmap $w.top.msg -padx 12 -pady 12

    ttk::frame $w.err
    set T [text $w.err.t -xscrollcommand [list $w.err.scrollbar#1 set] -yscrollcommand [list $w.err.scrollbar#2 set] -width 20 -height 10]
    set vsb [ttk::scrollbar $w.err.scrollbar#2 -command [list $w.err.t yview] -orient vertical]
    set hsb [ttk::scrollbar $w.err.scrollbar#1 -command [list $w.err.t xview] -orient horizontal]    
    $w.err.t delete 1.0 end 
    $w.err.t insert end $text_error
    $w.err.t configure -state disabled
    bind $w.err.t <1> [list focus $w.err.t]
    
    grid $w.err.t $w.err.scrollbar#2 -sticky nesw
    grid configure $w.err.scrollbar#2 -sticky ns
    grid $w.err.scrollbar#1 -sticky ew
    grid columnconfigure $w.err 0 -weight 1
    grid rowconfigure $w.err 0 -weight 1
    grid remove $vsb $hsb
    bind $T <Configure> [list ConfigureListScrollbars $T $hsb $vsb]
    
    ttk::button $w.bottom.button1 -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w]       
    grid $w.bottom.button1

    grid $w.top -sticky ew
    grid $w.err -sticky nsew
    grid $w.bottom -sticky ew
    grid anchor $w.bottom center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 1 -weight 1

    set parent [winfo toplevel [winfo parent $w]]
    set x [expr [winfo x $parent]+[winfo width $parent]/2-[winfo reqwidth $w]/2]
    set y [expr [winfo y $parent]+[winfo height $parent]/2-[winfo reqheight $w]]
    if { $x < 0 } { set x 0 }
    if { $y < 0 } { set y 0 }    
    WmGidGeom $w +$x+$y
    focus $w.bottom.button1
    bind $w.bottom.button1 <Return> [list $w.bottom.button1 invoke]
    return 0
}

proc RaiseEventBeforeRunCalculation { filename basename directory problem_dir gidexecutable args } {
    #deprecated, invoke it for back compatibility
    set result [GiD_RaiseEvent -raise_reversed BeforeRunCalculation $filename $basename $directory $problem_dir $gidexecutable $args]
    if { $result != "-cancel-" } {
        #-raise_reversed to invoke before the direct event to allow cancel the private event
        set result [GiD_RaiseEvent -raise_reversed GiD_Event_BeforeRunCalculation $filename $basename $directory $problem_dir $gidexecutable $args]
    }
    return $result
}

proc RaiseEventAfterRunCalculation { name directory problemtype uid error filenameerror } {
    set where $uid
    if { $where != "remote" } {
        set where "local"
    }
    #deprecated, invoke it for back compatibility
    set result [GiD_RaiseEvent AfterRunCalculation $name $directory $problemtype $where $error $filenameerror]
    if { $result != "-cancel-" } {
        #-raise_reversed to invoke before the direct event to allow cancel the private event
        set result [GiD_RaiseEvent -raise_reversed GiD_Event_AfterRunCalculation $name $directory $problemtype $where $error $filenameerror]
    }
    return $result
}

proc RaiseEventSelectGIDBatFile { directory basename } {
    #deprecated, invoke it for back compatibility
    set result [GiD_RaiseEvent ::SelectGIDBatFile $directory $basename]
    if { $result == "" } {
        set result [GiD_RaiseEvent GiD_Event_SelectGIDBatFile $directory $basename]
    }
    return $result
}

# drives only for windows------------------------------------------|--------------|
#                                                                  v              v
# RunProcInfo: $basename $time $uid $outputfiles $errorfiles $warningfiles
        #{$local_drives} {$net_drives}
# RunProcInfo (remote): $basename $time remote $outputfiles $errorfiles $warningfiles $server \
#                       $user $channel $state $dir $PT $args $timeaccess

# what can be: auto ; autoupdate ; firsttime ; force
set ::ActualizeProcInfoWaitingUserAnswer 0 ;#set to 1 to avoid reenter when expecting user answer to a question

proc ActualizeProcInfo { { what auto } } {
    global ActualizeProcInfoWaitingUserAnswer
    if { $::ActualizeProcInfoWaitingUserAnswer } {
        return
    }
    global GidProcWin RunProcInfo
    after cancel ActualizeProcInfo

    if { $RunProcInfo == "" } return

    if { [info exists ::GidProcWin(w)] && [winfo exists $::GidProcWin(w)] } {
        set w $::GidProcWin(w)
    } else {
        set w ""
    }
    set namewin ".gid.tmpwin"
    if { $w != "" } {
        set namewin $w.tmpwin
    }

    set thereareremoteprocesses 0
    set ToDissapear ""
    set ipos 0
    foreach i $RunProcInfo {
        set uid [lindex $i 2]
        set name [file tail [lindex $i 0]]
        set directory [lindex $i 10]
        set problemtype [lindex $i 11]
        set state [lindex $i 9]
        if { $uid == "remote" } {
            switch -glob $state {
                FINISHED* { 
                    set res 0
                }
                RESULTSINSERVER* { 
                    set res 0
                }
                ERROR* {
                    set res 0
                }
                FILETOCLIENT* {
                    set res 1
                }
                ENDFILETOCLIENT* {
                    set res 1
                }
                FILETOSERVER* {
                    set res 1
                }
                ENDFILETOSERVER* {
                    set res 1
                }
                KILLED* {
                    set res 0
                }
                default {
                    if { $what == "force" } {
                        PWCheckIfAlive $namewin $name 2
                    } elseif { $what == "firsttime" } {
                        PWCheckIfAlive $namewin $name 1
                    } else {
                        PWCheckIfAlive $namewin $name 0
                    }
                    set res 1
                    set thereareremoteprocesses 1
                }
            }
        } elseif { $what != "firsttime" } {
            set res [gidproc isalive $uid]
        } else {
            set res [gidproc isalive $uid [lindex $i 1]]
        }

        if { $res != 0 } {
            #still running
            if { $what == "firsttime" && $uid != "remote" } {
                if { ![GidUtils::IsTkDisabled] } {
                    set time [lrange [clock format [lindex $i 1]] 0 3]
                    set msg [_ "Process '%1\$s' started at %2\$s is still running." $name $time]
                    ::GidUtils::SetWarnLine $msg
                    set ::ActualizeProcInfoWaitingUserAnswer 1
                    MessageBoxOk [_ "Process info"] $msg info
                    set ::ActualizeProcInfoWaitingUserAnswer 0
                }
            }
        } else {
            #not running
            set time [lrange [clock format [lindex $i 1]] 0 3]
            set filenameserror [lindex $i 4]
            set errorflag 0
            if { $state != "ERROR" && [llength $filenameserror] != 0} {
                foreach filenameerror $filenameserror {
                    if { [file exists $filenameerror] && [file size $filenameerror] > 0 } {
                        set errorflag 1
                        # note: windows drives are unset in RunProcInfoDeleteJob
                        break
                    }
                }
            }
            if { $errorflag } {
                set error 1
                set filenames $filenameserror
            } else {
                set filenameswarning [lindex $i 5]
                set warningflag 0
                foreach filenamewarning $filenameswarning {
                    if { [file exists $filenamewarning] && [file size $filenamewarning] > 0 } {
                        set warningflag 1
                        break
                    }
                }
                if { $warningflag } {
                    set error -1 ;#ok but with warnings
                    set filenames $filenameswarning
                } else {
                    set error 0
                    if { $uid == "remote" } {
                        #dark trick, are not filenames but a status like "FINISHED", "RESULTSINSERVER" or "KILLED"
                        set filenames [lindex $state 0]
                    } else {
                        set filenames [list]
                    }
                }
            }
            RaiseEventAfterRunCalculation $name $directory $problemtype $uid $error $filenames
            if { [lindex $state 0] != "RESULTSINSERVER" } {
                lappend ToDissapear $name
            }
        }

        incr ipos
    }

    foreach name $ToDissapear {
        RunProcInfoDeleteJob $name
    }

    if { ($what == "autoupdate" || $ToDissapear != "") && $w != "" } {
        ActualizeProcsListBox $w
    }
    set CalculationNotFinished 0

    foreach i $RunProcInfo {
        set state [lindex $i 9]
        if { [lindex $state 0] != "RESULTSINSERVER" } {
            set CalculationNotFinished 1
            break
        }
    }


    if { $CalculationNotFinished } {
        if { ![info exists ::GidProcWin(nexttime)] } {
            set ::GidProcWin(nexttime) 0.5
        }
        set ::GidProcWin(nexttime) [expr $::GidProcWin(nexttime)*1.1]
        if { $::GidProcWin(nexttime) > 3 } { set ::GidProcWin(nexttime) 3 }
        after [expr int(1000*$::GidProcWin(nexttime))] "ActualizeProcInfo auto"
    }

    if { !$thereareremoteprocesses && $what == "force" } {
        WarnWin [_ "There are no remote processes to update"]
    }
}

proc ActualizeProcInfoBegin {} {
    global RunProcInfo GidProcWin

    if { [info exists ::GidProcWin(Called_ActualizeProcInfoBegin)] } {
        ActualizeProcInfo auto
    } else {
        set ::GidProcWin(Called_ActualizeProcInfoBegin) 1 ;#to avoid reenter
        set ipos 0
        foreach i $RunProcInfo {
            set uid [lindex $i 2]
            if { $uid == "remote" } {
                set state [lindex $i 9]
                if {[lindex $state 0] != "FINISHED" && [lindex $state 0] != "ERROR" && [lindex $state 0] != "RESULTSINSERVER"} {
                    set state "EXECUTING"
                }
                set newi [lreplace $i 8 9 "" $state]
                set RunProcInfo [lreplace $RunProcInfo $ipos $ipos $newi]
            }
            incr ipos
        }
        ActualizeProcInfo firsttime
        #unset ::GidProcWin(Called_ActualizeProcInfoBegin) ;#to reenter
    }
}

proc ActualizeProcsListBox { w } {
    global RunProcInfo

    if { [GidUtils::AreWindowsDisabled] } {
        return
    }  
    if { ![winfo exists $w] } { 
        return 
    }
    if { $w == ".gid" } { 
        return 
    }

    $w.listbox#1 delete 0 end
    foreach i $RunProcInfo {
        set name [file tail [lindex $i 0]]
        set time [lrange [clock format [lindex $i 1]] 0 3]
        set uid [lindex $i 2]
        if { $uid == "remote" } {
            set txtPriority ? 
        } else {
            set priority [ gidproc configure $uid -priority]
            set txtPriority [ getPriorityStr $priority]
        }
        set state [lindex $i 9]
        if { [lindex $state 0] == "RESULTSINSERVER" } {
            set status [_ "results stored in server"]
        } elseif { [lindex $state 0] == "DELETING" } {
            set status [_ "deleting remote results"]...
        } elseif { [lindex $state 0] == "FILETOCLIENT" || [lindex $state 0] == "ENDFILETOCLIENT" || [lindex $state 0] == "DOWNLOADRESULTS" } {
            set status [_ "downloading results"]...
        } elseif { [lindex $state 0] == "FILETOSERVER" || [lindex $state 0] == "ENDFILETOSERVER" || [lindex $state 0] == "DOWNLOADRESULTS" } {
            set status [_ "uploading data"]...
        } else {
            set status [_ "Calculating"]...
        }
        $w.listbox#1 insert end [format "%20s %20s %s %s %s" $name $time $uid $txtPriority $status]
    }
}


#return a list with the number of processes running locally and remotelly
proc AreProcessRunning {} {
    global RunProcInfo

    if { ![info exists RunProcInfo] || $RunProcInfo == "" } { 
        return {0 0 0}
    }

    set runninglocal 0
    set comunicatingremote 0
    set runningremote 0
    set storedremote 0

    set num_iterations 0
    set max_iterations 10
    set done 0
    while { !$done } {
        set runninglocal 0
        set comunicatingremote 0
        set runningremote 0
        set storedremote 0
        foreach i $RunProcInfo {
            set uid [lindex $i 2]
            if { $uid == "remote" } {
                set channel [lindex $i 8]
                set state [lindex $i 9]
                if { $channel != "" } {
                    if { [string match *EXECUTING* $state] } {
                        CloseChannel $channel
                        incr runningremote
                    } elseif { $state == "RESULTSINSERVER" } {
                        CloseChannel $channel
                        incr storedremote
                    } else {
                        incr comunicatingremote
                    }
                } else {
                    if { $state == "RESULTSINSERVER" } {
                        incr storedremote
                    } else {
                        incr runningremote
                    }
                }
            } else {
                incr runninglocal
            }
        }
        if { $comunicatingremote } {
            if { $num_iterations < $max_iterations } {
                after 1000 ;#wait a second
                incr num_iterations
                update        
            } else {
                #to avoid infinite loop
                set done 2
            }
        } else { 
            set done 1 
        }
    }   
    return [list $runninglocal $runningremote $comunicatingremote]
}

#return 0 if ok, >0 if don't know because is communicating with procserver
proc WaitUntilAllProcessTerminate { } {          
    lassign [AreProcessRunning] runninglocal runningremote comunicatingremote    
    while { $runninglocal || $runningremote } {
        after 100
        update
        lassign [AreProcessRunning] runninglocal runningremote comunicatingremote                 
    }       
    return $comunicatingremote
}

#return 0 if continue quit, 1 if cancel quit
proc PWQuittingGiD {} {  
    set runninglocal 0
    set runningremote 0
    set comunicatingremote 0
    lassign [AreProcessRunning] runninglocal runningremote comunicatingremote
    if { $comunicatingremote } {
        set msg [_ "There are %d processes comunicating with server. If you quit, you may loose some processes. Do you want to wait some seconds?" $comunicatingremote]
        set res [MessageBoxOptionsButtons [_ "Processes"] $msg [list wait quit -cancel-] [list [_ "Wait"] [_ "Quit"] [_ "Cancel"]] question ""]
        if { $res == "wait" } {
            after 3000 PWQuittingGiD
            return 1
        } elseif { $res == "quit" } {
            return 0
        } else {
            #"-cancel-"
            return 1
        }
    }

    if { $runninglocal || $runningremote } {
        if { $runninglocal } {
            set msg [_ "There are %d processes running. " $runninglocal]
        }
        if { $runningremote } {
            set msg [_ "There are %d remote processes running. " $runningremote]
        }
        append msg [_ "Terminate them?"]        
        set res [MessageBoxOptionsButtons [_ "Processes"] $msg [list yes no -cancel-] [list [_ "Yes"] [_ "No#C#I don't want to do that"] [_ "Cancel"]] question ""]
        if { $res == "yes" } {
            PWKillAllProc
        } elseif { $res == "no" } {
            return 0
        } else {
            return 1
        }
    }

    return 0
}

proc PWKillAllProc {} {
    global RunProcInfo

    set killed_items [list]
    if { ![info exists RunProcInfo] } {
        set RunProcInfo ""
    }
    foreach i $RunProcInfo {
        set name [file tail [lindex $i 0]]
        set uid [lindex $i 2]        
        set state [lindex $i 9]
        set directory [lindex $i 10]
        set problemtype [lindex $i 11]
        
        if { $uid == "remote" } {
            PWBeginCommand KILLINGFORCE $name
        } else {
            gidproc kill $uid
        }
        if { $uid != "remote" && $::tcl_platform(platform) == "windows"} {
            set drives [ lindex $i 6]
            set local_drives [ lindex $drives 0]
            set net_drives [ lindex $drives 1]
            foreach i $local_drives {
                set res [gidproc unsetdrive $i]
                if { "$res" != ""} {
                    WarnWin [_ "unsetdrive %1\$s: - %2\$s" $i $res]
                }
            }
            foreach i $net_drives {
                set res [gidproc unsetnetdrive $i]
                if { "$res" != ""} {
                    WarnWin [_ "unsetnetdrive %1\$s: - %2\$s" $i $res]
                }
            }
        } else {
            # nothing
        }
        lappend killed_items [list $name $directory $problemtype $uid 1 ""]
    }
    set RunProcInfo ""
    foreach killed_item $killed_items {
        set ret [RaiseEventAfterRunCalculation {*}$killed_item]        
    }
}

#this proc is invoked from C++ when processing Utilities Calculate
#must show messages calling events, not directly showing any window
# what can be: current or window
proc PWKillProc { { what current } { forced_answer no } } {
    if { [GidUtils::IsTkDisabled] } {
        set with_tk 0
    } else {
        set with_tk 1
    }
    set msg [PWKillProc_do $what $with_tk $forced_answer]
    if { $msg != "" } {                
        GiD_RaiseEvent GiD_Event_MessageBoxOk [_ "Kill process"] $msg info
    }
    return 0
}

proc PWKillProc_do { what with_tk {forced_answer no}} {
    global GidProcWin RunProcInfo
    set fail 0
    set msg ""

    if { ![info exists RunProcInfo] } {
        set RunProcInfo ""
    }

    if { [info exists ::GidProcWin(w)] && [winfo exists $::GidProcWin(w).listbox#1] } {
        set wbase $::GidProcWin(w)
        set w $::GidProcWin(w).listbox#1
    } else {
        set wbase .gid
        set w ""
    }

    if { [llength $RunProcInfo] == 0 } {
        set msg [_ "There are no processes running."]
        return $msg
    }

    set ToDissapear ""
    if { $what == "current" } {
        set project_name [GiD_Info Project ModelName]
        if { [file extension $project_name] == ".gid" } {
            set project_name [file root $project_name]
        }
        set basename [file tail $project_name]
        foreach i $RunProcInfo {
            set name [file tail [lindex $i 0]]
            if { $name == $basename } {
                set ToDissapear [list $name]
                break
            }
        }
        if { $ToDissapear == "" } {
            if { [llength $RunProcInfo] == 0 } {
                set msg [_ "Current project '%s' is not running." $basename]
            } else {
                set msg [_ "Current project '%s' is not running. To terminate other processes use the Calculate window" $basename]
            }
            return $msg
        }
    } else {
        if { [$w size] == 1 } { $w sel set 0}
        for { set i 0 } { $i < [$w size] } { incr i } {
            if { [$w sel includes $i] } {
                set aa [$w get $i]
                set name [string trim [string range $aa 0 19]]
                set ii 20
                while { [string index $aa $ii] != " " } {
                    append name [string index $aa $ii]
                    incr ii
                }
                lappend ToDissapear $name
            }
        }
        if { $ToDissapear == "" } {
            set msg [_ "Please, select a process first."]
            return $msg
        }
    }

    set ReallyDead ""
    foreach i $ToDissapear {
        foreach j $RunProcInfo {
            set name [file tail [lindex $j 0]]
            if { $i == $name } {
                set uid [lindex $j 2]
                set time [lrange [clock format [lindex $j 1]] 0 3]
                set state [lindex $j 9]
                if {$forced_answer != "yes"} {
                    if { [lindex $state 0] == "RESULTSINSERVER" } {
                        set msg [_ "Are you sure you want to delete the remote results of process: '%1\$s' started at %2\$s ?" $name $time]
                    } else {
                        set msg [_ "Are you sure you want to terminate the process: '%1\$s' started at %2\$s ?" $name $time]
                    }
                    set ret [MessageBoxOptionsButtons [_ "Processes"] $msg [list yes no] [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
                    update
                } else {
                    set ret yes
                }
                if { $ret == "yes" } {
                    if { $uid == "remote" } {
                        PWBeginCommand KILLING $name
                    } else {
                        if { $::tcl_platform(platform) eq "unix" } {
                            for { set times 0 } { $times < 5 } { incr times } {
                                gidproc kill -signal SIGTERM $uid
                                if { ![gidproc isalive $uid] } {
                                    break
                                }
                                after 500
                                update
                            }
                            if { [gidproc isalive $uid] } {
                                gidproc kill -signal SIGKILL $uid
                            }
                        } else {
                            gidproc kill $uid
                        }
                        lappend ReallyDead $name
                    }
                } else {
                    set msg "" ;# to avoid show again this message if doesn't want to kill it
                }
                break
            }
        }
    }
    if { $ReallyDead != "" } {
        set uid [lindex $j 2]
        set name [file tail [lindex $j 0]]
        set directory [lindex $j 10]
        set problemtype [lindex $j 11]
        set state [lindex $j 9]
        set text ""
        foreach i $ReallyDead {
            RunProcInfoDeleteJob $i
            append text " '$i'"
        }
        set ret [RaiseEventAfterRunCalculation $name $directory $problemtype $uid 1 ""]
        if { $with_tk && $ret ne "nowindow" } {
            if { [lindex $state 0] == "RESULTSINSERVER" } {
                set msg [_ "Deleted results of  process:%s" $text]
            } else {
                set msg [_ "Terminated process:%s" $text]
            }            
        }
    }
    ActualizeProcInfo auto
    if { [info exists ::GidProcWin(w)] && [winfo exists $::GidProcWin(w).listbox#1] } {
        ActualizeProcsListBox $::GidProcWin(w)
    }
    return $msg
}

proc PWViewOutputFill { text filename do_update } {
    global GidProcWin
    set fd ""
    if { [info exists ::GidProcWin(fd,$filename)] } {
        set fd $::GidProcWin(fd,$filename)
    }
    if { $text == "" || ![winfo exists $text] } {
        if { $fd != "" } {
            catch { close $fd }
            set fd ""
            set ::GidProcWin(fd,$filename) $fd
        }
        return
    }
    if { $fd == "" } {
        set just_open 1
        if { [catch { set fd [open $filename r] } ] } {
            set fd ""            
        } else {
            bind $text <Destroy> [list PWViewOutputFill "" $filename 0]
            $text configure -state normal
            $text delete 1.0 end
            $text configure -state disabled
        }
        set ::GidProcWin(fd,$filename) $fd
    } else { 
        set just_open 0 
    }
    
    if { $fd != "" } {
        $text configure -state normal
        set textinserted 0
        set aa [gets $fd]
        while { ![fblocked $fd] && ![eof $fd]} {
            set textinserted 1            
            $text insert end "$aa\n"            
            set aa [gets $fd]
            if { $::tcl_platform(platform) != "windows"} {
                if { ![info exists ::GidProcWin(tempstopupdates)] || $::GidProcWin(tempstopupdates) == 0  } {
                    $text see end
                }
            }
        }
        if { $::tcl_platform(platform) == "windows" && $textinserted == 1 } {
            if { ![info exists ::GidProcWin(tempstopupdates)] || $::GidProcWin(tempstopupdates) == 0  } {
                $text see end
            }
        }
        $text configure -state disabled
        if { !$textinserted && $just_open } {
            catch { close $fd }
            set fd ""
            set ::GidProcWin(fd,$filename) $fd
        } else {
            update idletasks
            if { !$textinserted && (![info exists ::RunProcInfo] || $::RunProcInfo == "") } {
                catch { close $fd }
                set fd ""
                set ::GidProcWin(fd,$filename) $fd
                set do_update 0
            }
        }
    }
    global PW_auto_update_enabled
    if { $do_update && $PW_auto_update_enabled} {
        # 100 ms consumes too much cpu.
        after 1000 [list PWViewOutputFill $text $filename $do_update]
    }
}

proc PWViewOutput_CloseAll {} {
    global GidProcWin

    if { ![info exists ::GidProcWin(max_outputwindow_num)] } {
        set ::GidProcWin(max_outputwindow_num) 0
    }
    for { set inum 1 } { $inum <= $::GidProcWin(max_outputwindow_num) } { incr inum } {
        if { [winfo exists .gid.outputview$inum] } {
            destroy .gid.outputview$inum
        }
    }
    update
}

proc PWViewOutputWin { filename name date basename } {
    global GidProcWin

    # When the window is raised, autoload is always ON
    global PW_auto_update_enabled
    set PW_auto_update_enabled 1

    set title [_ "output info for '%1\$s' %2\$s" $name $date]

    set geom ""
    set inum 1
    set w .gid.outputview$inum
    while { [winfo exists $w] } {
        if { [wm title $w] == $title } {
            raise $w
            return
        }
        set geom +[expr {[winfo rootx $w]+40}]
        append geom +[expr {[winfo rooty $w]+40}]
        incr inum        
        set w .gid.outputview$inum
    }
    
    if { ![info exists ::GidProcWin(max_outputwindow_num)] || $inum > $::GidProcWin(max_outputwindow_num) } {
        set ::GidProcWin(max_outputwindow_num) $inum
    }

    if { ![winfo exists $w] } {
        InitWindow2 $w -title $title \
            -geometryvariable PreOutput${inum}WindowGeom \
            -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        if { $geom != "" } { wm geometry $w $geom }

        ttk::scrollbar $w.scrollbar#2 -command [list $w.t yview] -orient vertical
        ttk::scrollbar $w.scrollbar#1 -command [list $w.t xview] -orient horizontal
        
        text $w.t -xscrollcommand [list $w.scrollbar#1 set] -yscrollcommand [list $w.scrollbar#2 set] \
            -font FixedFont -state disabled

        set mfont [ WarnWinTextRightButtonMenu $w.t]
        
        bind $w.scrollbar#2 <ButtonPress-1> "set ::GidProcWin(tempstopupdates) 1"
        bind $w.scrollbar#1 <ButtonPress-1> "set ::GidProcWin(tempstopupdates) 1"
        bind $w.scrollbar#2 <ButtonRelease-1> "set ::GidProcWin(tempstopupdates) 0"
        bind $w.scrollbar#1 <ButtonRelease-1> "set ::GidProcWin(tempstopupdates) 0"
        ttk::frame $w.buts -style BottomFrame.TFrame
        ttk::button $w.buts.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton
        set but_autoupdate $w.buts.autoupdate
        ttk::checkbutton $but_autoupdate -text [_ "Real time log"] \
            -variable PW_auto_update_enabled -command [list PWSwitchPauseAutoupdate $w.t $filename] \
            -style BottomFrame.TCheckbutton
        if { $basename != "" } {
            ttk::button $w.buts.update -text [_ "Update"] -command [list PWCheckIfAlive $w.tmpwin $basename 2]
            grid $w.buts.update -row 0 -column 3 -padx 5 -pady 6
        }
        grid $but_autoupdate -row 0 -column 0 -padx 5 -pady 6
        grid $w.buts.close -row 0 -column 1 -padx {5 80} -pady 6
        grid $w.t -sticky nesw
        grid $w.scrollbar#2 -row 0 -column 1 -rowspan 2 -sticky ns
        grid $w.scrollbar#1 -row 1 -column 0 -sticky ew
        grid $w.buts -columnspan 2 -sticky sew
        grid columnconfigure $w.buts 1 -weight 1
        grid rowconfigure $w 0 -weight 1
        grid columnconfigure $w 0 -weight 1
        focus $w.buts.close
    }
    
    PWViewOutputFill $w.t $filename 1
}

# what can be: current or window
proc PWViewOutput { { what current } } {
    global GidProcWin RunProcInfo
   
    if { ![info exists RunProcInfo] } {
        set RunProcInfo ""
    }

    if { ![info exists ::GidProcWin(w)] || ![winfo exists $::GidProcWin(w).listbox#1] } {
        set wbase .gid
        set w ""
    } else {
        set wbase $::GidProcWin(w)
        set w $::GidProcWin(w).listbox#1
    }

    if { $what == "current" } {
        set project_name [GiD_Info Project ModelName]
        if { [file extension $project_name] == ".gid" } {
            set project_name [file root $project_name]
        }
        set basename [file tail $project_name]
        set uid ""
        
        foreach i $RunProcInfo {
            set name [file tail [lindex $i 0]]
            if { $name == $basename } {
                set filenames [lindex $i 3]
                set uid [lindex $i 2]
                set time [lindex $i 1]
                break
            }
        }
        if { $uid == "" } {
            set filenames [PWFIndOutputFilenameCurrent]
        }
        if { [info procs ::GiD_Event_SelectOutputFilenames] != "" } {
            set selected_filenames [GiD_RaiseEvent GiD_Event_SelectOutputFilenames $filenames]
            set filenames $selected_filenames
        }

        if { $filenames == "" } {
            MessageBoxOk [_ "Process info"] [_ "There is no information to visualize for current project '%s'." $basename] error
            return
        }
        set index 0
        foreach filename $filenames {
            if { $uid == "" && ![file exists $filename] } {
                MessageBoxOk [_ "Process info"] [_ "There is no information to visualize for current project."] error
                return
            }
            set name current
            if {$index > 0} {
                set name "$name-$index"
            }
            if { $uid == "" } {
                PWViewOutputWin $filename $name "" ""
            } elseif { $uid == "remote" } {
                PWViewOutputWin $filename $name [lrange [clock format [list $time]] 0 3] $basename
            } else {
                PWViewOutputWin $filename $name [lrange [clock format [list $time]] 0 3] ""
            }
            incr index
        }
        return
    }

    if { [llength $RunProcInfo] == 0 } {
        PWViewOutput "current"
        return
    }

    set inum 0
    if { [$w size] == 1 } { $w sel set 0}
    for { set i 0 } { $i < [$w size] } { incr i } {
        if { [$w sel includes $i] } {
            incr inum
            set aa [$w get $i]
            set name [string trim [string range $aa 0 19]]
            set ii 20
            while { [string index $aa $ii] != " " } {
                append name [string index $aa $ii]
                incr ii
            }
            set filenames ""
            foreach j $RunProcInfo {
                set namein [file tail [lindex $j 0]]
                if { [string comp $namein $name] == 0 } {
                    set filenames [lindex $j 3]
                    set uid [lindex $j 2]
                    set time [lindex $j 1]
                    break
                }
            }
            if { $filenames == "" } {
                MessageBoxOk [_ "Process info"] [_ "There is no information to visualize for project '%s'." $name] error
                continue
            }
            set index 0
            foreach filename $filenames {
                if {$index > 0} {
                    set name "$name-$index"
                }
                if { $uid == "remote" } {
                    PWViewOutputWin $filename $name [lrange [clock format [list $time]] 0 3] $name
                } else {
                    PWViewOutputWin $filename $name [lrange [clock format [list $time]] 0 3] ""
                }
                incr index
            }
        }
    }
    if { $inum == 0 } {
        MessageBoxOk [_ "Process info"] [_ "Please, select a process first."] error
        return
    }
}

proc PWFIndOutputFilename { word batfile basename directory problem_directory } {
    
    set GiDpath [file join [gid_filesystem::get_folder_gid] gid]
    set project_name [GiD_Info Project ModelName]
    if { [file extension $project_name] == ".gid" } {
        set project_name [file root $project_name]
    }
    if { ![file exists $batfile] } return
    set fd [open $batfile r]
    set filename ""
    set filenames [list ]

    set regexp [format {%s:[ ]+([^ ]*).*$} [string toupper $word]]

    regsub -all {\\} $directory {\\\\} directory
    while { ![eof $fd] } {
        gets $fd aa
        if { [regexp -nocase $regexp $aa trash filename] } {
        
            if { $filename == "" } { return "" }

            if { $::tcl_platform(platform) == "windows" } {
                set filename [string map [list %1 $basename] $filename]
                set filename [string map [list %2 $directory] $filename]
                set filename [string map [list %3 $problem_directory] $filename]
                set filename [string map [list %4 $GiDpath] $filename]
            } else {
                set filename [string map [list \$1 $basename] $filename]
                set filename [string map [list \$2 $directory] $filename]
                set filename [string map [list \$3 $problem_directory] $filename]
                set filename [string map [list \$4 $GiDpath] $filename]
            }
        
            set filename [string trim $filename \"]
            if { [file pathtype [list $filename]] == "relative" } {
                set filename [file join $project_name.gid $filename]
            }
            if { [file pathtype $filename] == "relative" } {
                set filename [file join [pwd] $filename]
            }
            lappend filenames $filename
            set filename ""
        }
    }
    close $fd
    return $filenames
}

proc PWFIndOutputFilenameCurrent {} {
    global GidCache
    set problemtype [GiD_Info Project ProblemType]
    if { $problemtype == "UNKNOWN" } {
        return ""
    }
    set project_name [GidUtils::GetDirectoryModel]
    if { [file extension $project_name] == ".gid" } {
        set project_name [file root $project_name]
    }
    if { [info exists ::GidCache(outfilenames,$problemtype,$project_name)] } {
        #cache to avoid filesystem slow access
        return $::GidCache(outfilenames,$problemtype,$project_name)
    }
    
    set basename [file tail $project_name]
    set problem_directory [GidUtils::GiveProblemTypeFullname $problemtype].gid
    if { ![file isdirectory $problem_directory] } {
        return ""
    }
    
    #if { ![GidUtils::ModelHasName] } {
    #    return ""
    #}

    set directory [GidUtils::GetDirectoryModel]
    set list [RaiseEventSelectGIDBatFile $directory $basename]
    if {$list != ""} {
        set filename [file join $problem_directory [lindex $list 0]]
        # if " is added, an argument list will be treated as one argument
    } else {
        set filename ""
        if { $::tcl_platform(platform) == "windows" } {
            set tmpfile [file join $problem_directory [file tail $problemtype].win.bat]
            if { [file exists $tmpfile] } {
                set filename $tmpfile
            }
        } else {
            set tmpfile [file join $problem_directory [file tail $problemtype].unix.bat]
            if { [file exists $tmpfile] } {
                set filename $tmpfile
            }
        }
        if { $filename == "" } {
            set filename [file join $problem_directory [file tail $problemtype].bat]
        }
    }
    set outfilenames [PWFIndOutputFilename OutputFile $filename $basename $directory $problem_directory]
    set ::GidCache(outfilenames,$problemtype,$project_name) $outfilenames
    return $outfilenames
}

#this proc is invoked from C++ when processing Utilities Calculate
#must show messages calling events, not directly showing any window
proc PWStartProc { {isremote 0} } {
    if { [GidUtils::IsTkDisabled] } {
        set with_tk 0
    } else {
        set with_tk 1
    }
    set msg [PWStartProc_do $isremote $with_tk]
    if { $msg != "" } {
        GiD_RaiseEvent GiD_Event_MessageBoxOk [_ "Start process"] $msg info
    }
    return 0
}

proc PWStartProc_do { isremote with_tk } {
    global GidProcWin RunProcInfo
    set fail 0
    set msg ""
    if { [info exists ::GidProcWin(w)] && [winfo exists $::GidProcWin(w)]} {
        set w $::GidProcWin(w)
    } else {
        set w .gid
    }
    set problemtype [GiD_Info Project ProblemType]
    set project_name [GiD_Info Project ModelName]
    if { [file extension $project_name] == ".gid" } {
        set project_name [file root $project_name]
    }

    set basename [file tail $project_name]
    #if { ![GidUtils::ModelHasName] } {
    #    set msg [_ "Before calculating, a project title is needed. Save project to get it"]        
    #    return $msg
    #}

    if { $problemtype == "UNKNOWN" } {
        set msg [_ "In order to perform a calculation, a problemtype must be loaded. Use Data->Problemtypes."]
        return $msg
    }

    set problem_directory [GidUtils::GiveProblemTypeFullname $problemtype].gid
    if { ![file isdirectory $problem_directory] } {
        set msg [_ "Problem type '%s' can't be found" $problemtype]
        return $msg
    }

    set directory [GidUtils::GetDirectoryModel]
    if { [GidUtils::ModelHasName] } {
        if { [file pathtype $directory] == "relative" } {
            set directory [file join [pwd] $directory]
        }
    } else {
        if { [file exists $directory] } {
            file delete -force $directory
        }
        file mkdir $directory
    }

    set gidexecutable [info nameofexecutable]

    if { ![GiD_Set CalcWithoutMesh] } {
        if { ![GidUtils::ExistsMesh] } {
            set msg [_ "Don't forget to generate the mesh"]
            return $msg
        }
    }

    if { [info exists RunProcInfo] } {
        set ipos 0
        foreach i $RunProcInfo {
            if { $basename == [lindex $i 0] } {
                if { [lindex $i 9] == "RESULTSINSERVER" } {
                    set RunProcInfo [lreplace $RunProcInfo $ipos $ipos]
                    ActualizeProcInfo autoupdate
                    #PWBeginCommand KILLINGFORCE $basename
                } else {
                    set msg [_ "This problem is already running"]
                    return $msg
                }
            }
            incr ipos
        }
    }

    if { $with_tk } {
        PWViewOutput_CloseAll
        set oldfocus [focus]
        mkDialog $w.calc [list -text [_ "Initializing process. Wait, please"]... -aspect 250 -justify left]  [list [_ "Stop"] ""]
        update
    }

    set command [list MEscape Files WriteCalcFile]
    if { ![GidUtils::ModelHasName] } {
        lappend command [file join $directory UNNAMED.dat]
    }
    set DefaultFileNameInCalcFile [GiD_Set DefaultFileNameInCalcFile]
    if { $DefaultFileNameInCalcFile == 0 } {
        GiD_Set DefaultFileNameInCalcFile 1
    }
    GiD_Process {*}$command
    if { $DefaultFileNameInCalcFile == 0 } {
        GiD_Set DefaultFileNameInCalcFile 0
    }

    if { $with_tk } {
        if { [ winfo exists $w.calc]} {
            destroy $w.calc
        }
        if { [winfo exists $oldfocus] } {
            focus -force $oldfocus
        }
    }

    set LastOutCalcFailFlag [GiD_Info LastOutCalcFailFlag]
    if { $LastOutCalcFailFlag != 0 } {
        if { $LastOutCalcFailFlag  != 2 } {
            #value 2 mean that is canceled by -cancel- in GiD_Event_AfterWriteCalculationFile              
            set msg  [_ "Error running process."]
        }
        return $msg
    }
    set args ""
    set list [RaiseEventSelectGIDBatFile $directory $basename]
    if {$list != ""} {
        set filename [file join $problem_directory [lindex $list 0]]
        # if " is added, an argument list will be treated as one argument "
        set args [lrange $list 1 end]
        if { ![file exists $filename] } {
            set msg [_ "SelectGIDBatFile. File '%s' does not exists" $filename]
            return $msg
        }
    } else {
        set filename ""
        if { $::tcl_platform(platform) == "windows" } {
            set tmpfile [file join $problem_directory [file tail $problemtype].win.bat]
            if { [file exists $tmpfile] } {
                set filename $tmpfile
            }
        } else {
            set tmpfile [file join $problem_directory [file tail $problemtype].unix.bat]
            if { [file exists $tmpfile] } {
                set filename $tmpfile
            }
        }
        if { $filename == "" } {
            set filename [file join $problem_directory [file tail $problemtype].bat]
        }
        set args ""
    }

    if { [catch {
        set outfilenames [PWFIndOutputFilename OutputFile $filename $basename $directory $problem_directory]
        if { $outfilenames != "" } {
            foreach f $outfilenames {
                file delete $f
            }
        }
        set outfilenameserror [PWFIndOutputFilename ErrorFile $filename $basename $directory $problem_directory]
        if { $outfilenameserror != "" } {
            foreach f $outfilenameserror {
                file delete $f
            }
        }
        set outfilenameswarning [PWFIndOutputFilename WarningFile $filename $basename $directory $problem_directory]
        if { $outfilenameswarning != "" } {
            foreach f $outfilenameswarning {
                file delete $f
            }
        }
    } err] } {
        set msg [_ "Error deleting old file (%s). Correct the problem and execute again" $err]        
        return $msg
    }
    set olddir [pwd]
    cd $directory
    if { !$isremote && [file exists [file join $problem_directory password.txt]] } {
        file copy -force [file join $problem_directory password.txt] .
    }
    set AnexoRunProcInfo ""
    if { $isremote } {
        set res [PWCalcRemote $w.calremote "$basename" "$directory" $problemtype $args]
        set AnexoRunProcInfo [lrange $res 2 end]
        set res [lrange $res 0 1]
    } elseif { $::tcl_platform(platform) != "windows" } {
        set problem_dir $problem_directory
        set answer [RaiseEventBeforeRunCalculation $filename $basename $directory $problem_dir $gidexecutable $args]
        if { [lindex $answer 0] == "-cancel-" } {
            set res "end"
            if { [lindex $answer 1] != "" } {
                set msg [lindex $answer 1]
            }
        } else {
            set res [gidproc exec "$filename" "$basename" "$directory" "$problem_directory" "$gidexecutable" $args]
        }
        set AnexoRunProcInfo [list {} {} {} {} [list $directory] [list $problem_directory]]
    } else {
        set problem_dir $problem_directory
        set local_drives ""
        set net_drives ""
        if { [file exists [file join [gid_filesystem::get_folder_gid] command.exe]] } {
            set usedrives 0
        } else { set usedrives 1 }

        if { $usedrives } {
            # Como el tamano(commandline) < 128
            # hemos de subst disco: $basename
            # hemos de subst disco: problem_dir
            set res [gidproc getvolumes]
            regsub -all {:\\} $res {} drives
            set net_drives ""
            set local_drives ""

            set net_proj_dir ""
            # foreach i { z y x w v u t s r q p o n m l k j i h g f e d c b a 0}
            foreach i { e f g h i j k l m n o p q r s t u v w x y z 0} {
                if { [ string first $i $drives] == -1} {
                    break
                }
            }
            if { "$i" == "0"} {
                cd $olddir
                set msg [_ "Sorry but, couldn't find a free drive letter."]
                return $msg
            }
            set proj_drv $i
            lappend drives $i

            #el directorio del proyecto es un directorio de red?
            if { [string range $directory 0 1] == "\\\\"} {
                set recurso "$directory"
                if { ![ regexp {^(\\\\[^\\]+\\[^\\]+)\\(.*)} $recurso dumm net_dir resto]} {                                     
                    cd $olddir
                    set msg [_ "Sorry, but couldn't use '%s' as project directory to calculate." $recurso]
                    return $msg
                }

                set net_proj_dir $net_dir
                set res [ gidproc setnetdrive $proj_drv $net_dir]
                if { $res != ""} {
                    cd $olddir
                    set msg [_ "setnetdrive %1\$s: '%2\$s' - %3\$s" $proj_drv $net_dir $res] 
                    return $msg
                }

                lappend net_drives $proj_drv
                set directory [file join $proj_drv: $resto]
                cd $directory
            } else {
                set res [gidproc setdrive $proj_drv "[ file dirname $directory]"]
                if { $res != ""} {
                    cd $olddir
                    set msg [_ "setdrive %1\$s: '%2\$s' - %3\$s" $proj_drv [file dirname $directory] $res]
                    return $msg
                }
                lappend local_drives $proj_drv
                set directory [file join $proj_drv: [file tail $directory]]
            }

            set problem_dir $problem_directory
            # foreach i { z y x w v u t s r q p o n m l k j i h g f e d c b a 0}
            foreach i { e f g h i j k l m n o p q r s t u v w x y z 0} {
                if { [ string first $i $drives] == -1} {
                    break
                }
            }
            if { $i == "0"} {
                cd $olddir
                set msg [_ "Sorry but, culdn't find a free drive letter."]
                return $msg
            }
            set prob_drv $i
            lappend drives $i

            #el directorio del tipo de problema es un directorio de red?
            if { [string range $problem_dir 0 1] == "\\\\"} {
                set recurso $problem_dir
                if { ![ regexp {^(\\\\[^\\]+\\[^\\]+)\\(.*)} $recurso dumm net_dir resto]} {                                        
                    cd $olddir
                    if { [ string first $proj_drv $net_drives] == -1} {
                        gidproc unsetdrive $proj_drv
                    } else {
                        gidproc unsetnetdrive $proj_drv
                    }
                    set msg [_ "Sorry, but couldn't use '%s' as problem directory to calculate." $recurso]
                    return $msg
                }

                if { $net_dir != $net_proj_dir} {
                    set res [ gidproc setnetdrive $prob_drv $net_dir]
                    if { "$res" != ""} {
                        cd $olddir
                        if { [ string first $proj_drv $net_drives] == -1} {
                            gidproc unsetdrive $proj_drv
                        } else {
                            gidproc unsetnetdrive $proj_drv
                        }
                        set msg [_ "setnetdrive %1\$s: '%2\$s' - %3\$s" $prob_drv $net_dir $res]
                        return $msg
                    }
                    lappend net_drives $prob_drv
                } else {
                    # en guindous NT no podemos mapear dos veces el mismo recurso, asin que . . .
                    set prob_drv $proj_drv
                }

                set problem_dir [file join $prob_drv: $resto]
            } else {
                # es local
                set res [gidproc setdrive $prob_drv "[ file dirname $problem_dir]"]
                if { $res != ""} {
                    cd $olddir
                    if { [ string first $proj_drv $net_drives] == -1} {
                        gidproc unsetdrive $proj_drv
                    } else {
                        gidproc unsetnetdrive $proj_drv
                    }
                    set msg [_ "setdrive %1\$s: '%2\$s' - %3\$s" $prob_drv $[ file dirname $problem_dir] $res]
                    return $msg
                }
                lappend local_drives $prob_drv
                set problem_dir [file join $prob_drv: [file tail $problem_dir]]
            }
        }
       
        set problem_directory [ file join $problem_dir]
        set outfilenames [PWFIndOutputFilename OutputFile $filename $basename $directory $problem_directory]
        foreach f $outfilenames {
            file delete $f
        }
        set outfilenameserror [PWFIndOutputFilename ErrorFile $filename $basename $directory $problem_directory]
        foreach f $outfilenameserror {
            file delete $f
        }
        set outfilenameswarning [PWFIndOutputFilename WarningFile $filename $basename $directory $problem_directory]
        foreach f $outfilenameswarning {
            file delete $f
        }
        set answer [RaiseEventBeforeRunCalculation $filename $basename $directory $problem_dir $gidexecutable $args]
        if { [lindex $answer 0] == "-cancel-" } {
            set res "end"
            if { [lindex $answer 1] != "" } {
                set msg [lindex $answer 1]
            }
        } else {
            regsub -all {\\} "gidproc exec \"$filename\" \"$basename\" \"$directory\" \"$problem_dir\" \"$gidexecutable\" $args" {\\\\} ss
            if { [catch { set res [eval $ss] } error_msg] } {
                set res 0
            } else {
                set AnexoRunProcInfo [list [ format "{%s} {%s}" $local_drives $net_drives] {} {} {} [list $directory] [list $problem_directory]]
            }
        }
    }
    cd $olddir

    if { [lindex $res 0] == "end" } {
        #canceled ?
        return $msg
    } elseif { [lindex $res 0] == "remote" || [lindex $res 0] != 0 } {
        after 1000
        lappend RunProcInfo [list $basename [lindex $res 1] [lindex $res 0] $outfilenames $outfilenameserror $outfilenameswarning {*}$AnexoRunProcInfo]
        unset -nocomplain ::GidProcWin(nexttime)
        after idle "ActualizeProcInfo auto ; ActualizeProcsListBox $w"
    } else {
        if { ![file exists $filename] } {
            set msg [_ "File '%s' doesn't exist" $filename]
        } else {
            set msg [concat [_ "Error executing"] " '$filename $basename $directory " "$problem_directory $gidexecutable'"]            
        }
        return $msg
    }
    return $msg
}

proc OpenProcWin { { w .gid.wrun  }  } {
    global GidProcWin RunProcInfo
    set ::GidProcWin(w) $w
    if { ![info exists RunProcInfo] } {
        set RunProcInfo ""
    }

    if { [winfo exists $w] } {
        raise $w
    } else {
        InitWindow2 $w -title [_ "Process window"] \
            -geometryvariable PreProcessWindowGeom -initcommand OpenProcWin
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
        ProcWin_ui $w
    }

    update idletasks

    ActualizeProcInfoBegin

    ActualizeProcsListBox $w
}

proc RunProcInfoDeleteJob { name } {
    global RunProcInfo

    set ipos 0
    foreach i $RunProcInfo {
        set inname [file tail [lindex $i 0]]
        if { $name == $inname } {
            set uid [lindex $i 2]
            if { $uid != "remote"  && $::tcl_platform(platform) == "windows"} {
                set drives [ lindex $i 6]
                set local_drives [ lindex $drives 0]
                set net_drives [ lindex $drives 1]
                foreach i $local_drives {
                    set res [gidproc unsetdrive $i]
                    if { "$res" != ""} {
                        WarnWin [_ "unsetdrive %1\$s: - %2\$s" $i $res]
                    }
                }
                foreach i $net_drives {
                    set res [gidproc unsetnetdrive $i]
                    if { "$res" != ""} {
                        WarnWin [_ "unsetnetdrive %1\$s: - %2\$s" $i $res]
                    }
                }
            }

            set RunProcInfo [lreplace $RunProcInfo $ipos $ipos]
            return
        }
        incr ipos
    }
}

proc GiveRunProcInfoName { channel } {
    global RunProcInfo

    foreach i $RunProcInfo {
        set channelin [lindex $i 8]
        if { $channel == $channelin } {
            return [file tail [lindex $i 0]]
        }
    }
    return ""
}

proc GiveRunProcInfoState { channel } {
    global RunProcInfo

    foreach i $RunProcInfo {
        set channelin [lindex $i 8]
        if { $channel == $channelin } {
            return [lindex $i 9]
        }
    }
    return ""
}

proc GiveRunProcInfoServer { channel } {
    global RunProcInfo

    foreach i $RunProcInfo {
        set channelin [lindex $i 8]
        if { $channel == $channelin } {
            return [lindex $i 6]
        }
    }
    return ""
}

proc SetRunProcInfoState { channel state } {
    global RunProcInfo
    set fail 1
    set ipos 0
    foreach i $RunProcInfo {
        set channelin [lindex $i 8]
        if { $channel == $channelin } {
            set newi [lreplace $i 9 9 $state]
            set RunProcInfo [lreplace $RunProcInfo $ipos $ipos $newi]
            set fail 0
            break
        }
        incr ipos
    }
    return $fail
}

proc SetRunProcInfoCloseChannel { channel } {
    global RunProcInfo
    set fail 1
    set ipos 0
    foreach i $RunProcInfo {
        set channelin [lindex $i 8]
        if { $channel == $channelin } {
            set newi [lreplace $i 8 8 ""]
            set newi [lreplace $newi 13 13 [clock seconds]]
            set RunProcInfo [lreplace $RunProcInfo $ipos $ipos $newi]
            set fail 0
            break
        }
        incr ipos
    }
    return $fail
}

proc on_answer_process_finished_window { name answer } {
    if { $answer == "download" } {
        PWBeginCommand DOWNLOADRESULT $name
    } elseif { $answer == "postprocess" } {
        DoPostprocess
    } else {
        #do nothing
    }
}

proc gid_client_after_run_calculation { name directory problemtype uid status filenames } {
    global GidProcWin
    if { [GidUtils::IsTkDisabled] || [GiD_Set UseMoreWindows] == 0 } {
        return 0
    }
    if { [GiD_Set Sound] == 1 } {
        playaudio [file join [gid_filesystem::get_folder_standard resources] audio Select2.wav]
    }
    if { [info exists ::GidProcWin(w)] && [winfo exists $::GidProcWin(w)] } {        
        ActualizeProcsListBox $::GidProcWin(w)
    }
    if { $status == 1 } {
        foreach filename $filenames {
            PWViewOutputError error $name $filename
        }
    } elseif { $status == -1 } {
        foreach filename $filenames {
            PWViewOutputError warning $name $filename
        }
    } else {
        if { $uid == "remote" } {
            if { $filenames == "FINISHED" } {
                set msg [_ "Process '%s' has finished." $name]
                ::GidUtils::SetWarnLine $msg
                set ::ActualizeProcInfoWaitingUserAnswer 1
                #verify if the finished calculation is the same as the current model to ask to postprocess
                set model_name [file join [GiD_Info Project ModelName].gid]
                set calculation_name [file join [lindex $directory 0]]
                if { [GetCurrentPrePostMode] == "PRE" && $model_name == $calculation_name } {
                    set options [list ok postprocess]
                    set labels [list [_ "Ok"] [_ "Postprocess"]]
                } else {
                    set options [list ok]
                    set labels [list [_ "Ok"]]
                }
                set image info
                MessageBoxOptionsButtonsModeless [_ "Process info"] $msg $options $labels $image [list on_answer_process_finished_window $name] ""
                set ::ActualizeProcInfoWaitingUserAnswer 0
            } elseif { $filenames == "RESULTSINSERVER" } {
                set msg [_ "Remote process '%s' has finished. Results stored in the server" $name]
                ::GidUtils::SetWarnLine $msg
                set options [list ok download]
                set labels [list [_ "Ok"] [_ "Download"]]
                set image info
                MessageBoxOptionsButtonsModeless [_ "Process info"] $msg $options $labels $image [list on_answer_process_finished_window $name] ""
            } elseif { $filenames == "KILLED" } {
                #do nothing, the user has killed the process
            } elseif { $filenames == "ERROR" } {
                #do not show message here, probably it was showed before (e.g. if calculation server is off)
            } else {
                W "gid_client_after_run_calculation: unexpected remote status=$filenames"
            }
        } else {
            #it is a local process id
            set msg [_ "Process '%s' has finished." $name]
            ::GidUtils::SetWarnLine $msg
            #verify if the finished calculation is the same as the current model to ask to postprocess
            set model_name [GidUtils::GetDirectoryModel]
            set calculation_name [file join [lindex $directory 0]]
            if { [GetCurrentPrePostMode] == "PRE" && $model_name == $calculation_name } {
                set options [list ok postprocess]
                set labels [list [_ "Ok"] [_ "Postprocess"]]
            } else {
                set options [list ok]
                set labels [list [_ "Ok"]]
            }
            set image info
            MessageBoxOptionsButtonsModeless [_ "Process info"] $msg $options $labels $image [list on_answer_process_finished_window $name] ""
        }
    }
    return 0
}

proc PWSwitchPauseAutoupdate {t filename} {
    # Global variable
    global PW_auto_update_enabled
    # Execute destination action
    PWViewOutputFill $t $filename $PW_auto_update_enabled    
}
