
#Post widgets:

# ResultSelectionTree pahtName options

# UpDownEntry: campo con flechitas de incrmento/decremento
# ScrolledCanvas: canvas con barritas de scroll a la derecha y abajo

##############################
# Funciones que crean un ScrolledCanvas
# donde se pueden meter widgets, ...
#
# CreateScrolledCanvas widget_name -> retun canvas name
# AddToScrolledCanvas widget_name thing_to_add -> add the widget to the canvas
# ResizeScrolledCanvas widget_name -> resize scroll bars
# ResetScrolledCanvas widget_name -> delete all drawn canvas items, without destroy widgets

##############################
# CCformatFloat2Hex { lstFloats} --> dado una lista de, al menos, 3 floats (rgb o rgba) devuelve #rrggbb, como quiere Tk
# CCGetRGB { w color} -> dado un color encuentra su #rrggbb
# CCColorActivo { color { factor 17}} -> dado un color #rrggbb lo eleva segun factor
# CCColorSombra { color { factor 17}} ->  dado un color #rrggbb lo eleva segun factor

# SwitchButton { w on_command off_command args} -> crea un button $args
#                        que si se clickea queda apretado y ejecuta on_command y
#                        si se clickea otra vez vuleve como antes y ejecuta off_command
##############################

# GiDPopUpHelp { w args} -> bocado de ayuda ( texto ayuda en args) sobre el widget w
#                           al cabo de un rato aparece la ayuda y despues de otro
#                           rato, dependiendo de la longitud del texto en args,
#                           desaparece, o al moverse el raton.
# args = { ShowMiliSeconds max( 3000, 500 * \[ string length text\])} Text

# UpDownEntry widget_name arguments
#         arguments:
#                    -up-command "command when up button is pressed"
#                    -down-command "command when down button is pressed"
#                    -show-double-buttons          <- shows rapid incrment buttons, by default disabled
#                    -up-up-command "command when up up button is pressed"
#                    -down-down-command "command when down down button is pressed"
#                    -variable variable_for_the_entry
#                    -textvariable variable_for_the_entry
#                    -foreground fore_color_for_entry_and_buttons
#                    -background back_color_for_entry_and_buttons
#                    -up-color fore_color_for_bitmap_on_up_button
#                    -up-up-color fore_color_for_bitmap_on_up_up_button
#                    -down-color fore_color_for_bitmap_on_down__button
#                    -down-down-color fore_color_for_bitmap_on_down_down_button
#                    -entry-options "Options for the entry widget"
#                    -button-options "Options for the button widgets"
#                    -up-button-options "Options for the up button widget"
#                    -down-button-options "Options for the down button widget"
#                    -up-up-button-options "Options for the up up button widget"
#                    -down-down-button-options "Options for the down down button widget"

# UpDownEntryConf widget_name arguments
#         argumenst:
#                    -state normal/disabled
#                    -foreground fore_color_for_entry_and_buttons
#                    -background back_color_for_entry_and_buttons
#                    -entry-options "Options for the entry widget"
#                    -button-options "Options for the button widgets"
#                    -up-button-options "Options for the up button widget"
#                    -down-button-options "Options for the down button widget"

# proc TextWindow wparent varname title label_text args
#         displays a window asking for some text which is stored in 'varname'
#         it waits until the user click on 'Apply' or 'Close'
#         there is a couple of bindings:
#         <Alt-Return> and <Alt-KP_Enter> which invoques the 'Apply' button
#         <Escape> which invoques the 'Colse' button
#         argumenst:
#                    wparent - parent window to appear over tit
#                    varname - variable with the text to be showed / edited
#                    title - title of the window
#                    label_text - text of the label wich appears on the surrounding frame
#                    args - arguments passed directly to the text widget
#         returns the window name
##########################################################################################
### ScrolledCanvas
##########################################################################################

################################
# TTKMenubutton:
# TTKMenubutton widget
#         opciones validas:
#         -labels lista_etiquetas
#         -values lista_valores
#         -textvariable variable_para_guardar_el_valor
#         -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
#         -commands lista_comandos_para_cada_label/value
#         -images list of images for each label/value
#      tambien admite las opciones estandard:
#         -width -height -state -style -takefocus -text -image -compound -cursor -underline -direction
# TTKMenubuttonInvoke widget TextoEntradaMenu
#                     --> selecciona e invoca la entrada de menu con texto TextoEntradaMenu
# TTKMenubuttonSelect widget TextoEntradaMenu
#                     --> muestra la entrada de menu con texto TextoEntradaMenu en el boton
# TTKMenubuttonConfigure widget opciones
#                     --> para redefinir opcionesl del widget
# TTKMenubuttonCGet widget opcion
#                     --> para conseguir informacion de alguna opcion del widget
################################

################################
# TTKMessagebox:
# TTKMessagebox widget como el messagebox, pero con una lista de etiquetas/valores donde elegir
#         la etiqueta/valor seleccionado devuelve el valor
#         opciones validas:
#         -title titulo
#         -message mensaje_de_la_ventana
#         -labels lista_etiquetas
#         -values lista_valores
#         -textvariable variable_para_guardar_el_valor
#         -images list of images for each label/value
#      tambien admite las opciones estandard:
#         -parent
#         -icon nombre del icono a mostrar
################################

################################
# TTKComboBox:
# TTKComboBox widget
#         opciones validas:
#         -labels lista_etiquetas
#         -values lista_valores
#         -textvariable variable_para_guardar_el_valor
#         -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
#  ( QUITADO)        -commands lista_comandos_para_cada_label/value
#  ( QUITADO)        -images list of images for each label/value
#      tambien admite las opciones estandard:
#         -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction
# TTKComboBoxConfigure widget opciones
#                     --> para redefinir opcionesl del widget
# TTKComboBoxCGet widget opcion
#                     --> para conseguir informacion de alguna opcion del widget
#                     get --> devuelve la etiqueta actual seleccionada, no el value actual
################################


################################
# LabelButton:
# boton para poder definir un color. el boton cambia de color al seleccionar un color
# se implementa con un label, pues en mac no se pueden poner colores en los botones
################################
# setTooltip para definir globos de ayuda, tb en los menus
# set Tooltip widget opciones
# opciones validas:
#   texto                        --> texto a aparecer
#   -text texto                  --> texto a aparecer
#   -textvariable nombreVariable --> variable con la que el balon se actualizara ( para menus)
#   -delay user_delay_in_ms      --> to set the pop-up delay of the tooltip, default is 2000
#   -bottom widget               --> para que aparezca el tooltip en la parte de abajo de otro widget
# para el balon de los menus, se usa en conjuncion con el DynamicHelp de BWidget
# ejemplo con menus:
#
# menu .m -type menubar
# # associate menubar to toplevel BEFORE DynamicHelp::register
# # to make it works with menu clone name
# . configure -menu .m
# .m add cascade -label "File" -menu .m.file
# menu .m.file
# .m.file add command -label "Open..."
# .m.file add command -label "Quit"
#
# # la variable donde se guardara el texto de ayuda que toca
# set ::varinfo ""
# # associate all entries of menu .m.file to variable varinfo
# DynamicHelp::register .m.file menu ::varinfo
# # then declare entries of .m.file
# DynamicHelp::register .m.file menuentry 0 "Detach menu"
# DynamicHelp::register .m.file menuentry 1 "Open a file"
# DynamicHelp::register .m.file menuentry 2 "Exit demo"
# setTooltip .m.file -textvariable ::varinfo

##############################
# CreateApplyCloseDecorationWindow { window top_frame but_frame apply_cmd close_cmd}
##############################
# creates window decoration, top_frame and but_frame with Apply and Close buttons
##############################
# CreateDecorationWindow { window top_frame but_frame lst_button_labels lst_button_cmds lst_button_keys}
##############################
# creates window decoration, top_frame, but_frame and the list of buttons with commands and key bindings

#################################################################################
# CloseInsideMainWindow $w           - This procedure take account new panedwindow 
#                                      GidPriv(pwCentral) to manage several windows
# PutInsideMainWindow $w $cmd $loc   - Procedure to open window inside, includes
#                                      creation of panedwindow to manage several windows
#                     $w           --> window name
#                     $cmd         --> $cmd $w OUTSIDE / LEFT / RIGHT 
#                                      command executed to create the contents of the 
#                                      window OUTSIDE or LEFT or RIGHT
#                     $loc         --> location to open inside window: LEFT or RIGHT
#################################################################################

########################################################################
# PostProgressBar numerator divisor ?message? ?title?
# to destroy it make numerator >= divisor
# if divisor < 0 --> progres bar with no end == bouncing progress bar
# to destroy it make divisor = 0
########################################################################

########################################################################
# CheckNewVersion {}
# - returns the version number if there is a new version of GiD
#   and displays a message in the WarnLine
# - returns an empty string if not
# - return -1 if connection error
# PopupCheckNewVersion { wx wy { wParent .gid}}
# - popsup a window telling whether:
#   - This version is up to date.
#   - a new version is available
#   - connection error
########################################################################

proc CreateScrolledCanvas { { w .scw}} {
    if { [ winfo exists $w]} {
        puts "widget name $w already exists."
        return
    }    
    ttk::frame $w -relief solid -borderwidth 1
    set v [ ttk::scrollbar $w.vscroll -orient vertical]   
    set h [ ttk::scrollbar $w.hscroll -orient horizontal]   
    set c [ canvas $w.c -width 100 -height 100 -borderwidth 0 \
            -xscrollcommand "$h set" -yscrollcommand "$v set" \
            -highlightthickness 0]
    $h config -command "$c xview"
    $v config -command "$c yview"
    #$c config -scrollregion [ $c bbox all]
    grid $c -column 0 -row 0 -sticky news
    grid $v -column 1 -row 0 -rowspan 2 -sticky ns
    grid $h -column 0 -row 1 -sticky ew
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1
    
    set bbox [ $c bbox all]
    #set bboxgrid [grid bbox $w 0 0]
    
    #for {set i 0} {$i<4} {incr i} {
    #    lremplace $bbox $i $i [expr max([lindex $bbox [expr $i],[lindex $bboxgrid $i])]
    #}
    $c config -scrollregion $bbox  
  
    bind $w <Configure> " ResizeScrolledCanvas $w"   

    
    
    # With kratos Dem-pack problemtype, although the scrolled canvas is destroyed, 
    # still the bindings are called ... so adding a catch as quick patch
    bind [winfo toplevel $w] <4> [subst "catch {$c yview scroll -1 units}"]
    bind [winfo toplevel $w] <5> [subst "catch {$c yview scroll 1 units}"]
    
    #problems "bind [winfo toplevel $w] <MouseWheel>" with bindings of widgets inside canvas and errors on resize
    #enabled only over scrollbar
    # MouseWheel on MS Windows does a -120 or 120, so reducing it to 1 line:
    bind $v <MouseWheel> [subst "catch { if { %D > 0} { $c yview scroll -1 units} else { $c yview scroll 1 units}}"]

    return $w.c
}

proc AddToScrolledCanvas { { w .scw} { what ""}} {
    if { ![ winfo exists $w]} {
        puts "widget name $w does not exist."
        return
    }

    if { "$what" == ""} {
        puts "Nothing to add to the Scrolled Canvas"
        return
    }

    update idletasks

    set region [ $w.c bbox all]
    if { [ llength $region] == 4 } {
        set posx [ lindex $region 3]
    } else {
        set posx 0
    }
    $w.c create window 0 $posx -anchor nw -window $what
    $w.c config -scrollregion [ $w.c bbox all]
}

proc ResetScrolledCanvas { { w .scw}} {
    if { ![ winfo exists $w]} {
        puts "widget name $w does not exist."
        return
    }

    $w.c delete all
    $w.c config -scrollregion [ $w.c bbox all]
}

proc ResizeItemInsideCanvas { { w .scw}} {
    if { ![winfo exists $w.c] } {
        return
    }
    #$w.c itemconfigure 1 -height 0 -width 0
    #$w.c config -scrollregion [ $w.c bbox all]
    $w.c itemconfigure 1 -height 0 -width 0
    set bbox [ $w.c bbox all]
    $w.c config -scrollregion $bbox    
    
    set recalc_width 0
    set recalc_height 0
    
    set bboxgrid [grid bbox $w 0 0]
    set borderwidth 2
    if { [llength $bbox] == 4 } {
        set bboxwidth [expr [lindex $bbox 2]-[lindex $bbox 0]]
    } else {
        set bboxwidth 0
    }
    set bboxgridwidth [expr [lindex $bboxgrid 2]-[lindex $bboxgrid 0]-$borderwidth]
    if { $bboxwidth > $bboxgridwidth } {
        set width $bboxwidth
        grid $w.hscroll
    } else {
        grid remove $w.hscroll
        set width $bboxgridwidth
        set recalc_width 1        
    }
    if { [llength $bbox] == 4 } {
        set bboxheight [expr [lindex $bbox 3]-[lindex $bbox 1]]
    } else {
        set bboxheight 0
    }
    set bboxgridheight [expr [lindex $bboxgrid 3]-[lindex $bboxgrid 1]-$borderwidth]
    if { $bboxheight > $bboxgridheight } {
        set height $bboxheight
        grid $w.vscroll        
    } else {
        grid remove $w.vscroll 
        set height $bboxgridheight
        set recalc_height 1       
    }
    #always is a good aproximation (don't blink)
    $w.c itemconfigure 1 -height $height -width $width
    
    if { $recalc_width || $recalc_height } {
        #some scrollbar has changed so we have to recalculate after redraw
        update idletasks
        set bboxgrid [grid bbox $w 0 0]
        if { $recalc_width } {
            set width [expr [lindex $bboxgrid 2]-[lindex $bboxgrid 0]-$borderwidth]            
        }
        if { $recalc_height } {
            set height [expr [lindex $bboxgrid 3]-[lindex $bboxgrid 1]-$borderwidth]            
        } 
        $w.c itemconfigure 1 -height $height -width $width
    }    
}

proc ResizeScrolledCanvas { { w .scw}} {
    if { ![ winfo exists $w]} {
        puts "widget name $w does not exist."
        return
    }
    # in macOS this 'update' causes an infinite loop
    # the CopyMove Window sometime will not appear
    if { ![ esMac]} {
      update 
    }
    ResizeItemInsideCanvas $w
}

##########################################################################################
### UpDownEntry
##########################################################################################

proc __UpDownEntry_Incr_Cmd { w step } {

    if { "$::UpDownEntry($w,Variable)" != ""} {
        set nuevo [ eval expr $$::UpDownEntry($w,Variable) + $step]
        if { $nuevo > $::UpDownEntry($w,To)} {
            set nuevo $::UpDownEntry($w,To)
        }
        if { $nuevo < $::UpDownEntry($w,From)} {
            set nuevo $::UpDownEntry($w,From)
        }
        set $::UpDownEntry($w,Variable) $nuevo
    }
}

proc UpDownEntry { w args} {
    global UpDownEntry
    
    #----------------
    # define Styles taken from Spinbox
    
        ttk::style layout TSpinboxUparrow {
            Spinbox.uparrow -side top -sticky ens -children {
                Button.label -side top -expand false
            }
        }
        ttk::style layout TSpinboxDownarrow {
            Spinbox.downarrow -side top -sticky ens -children {
                Button.label -side top -expand false
            }
        }
        ttk::style configure TSpinboxUparrow -anchor center
        ttk::style configure TSpinboxDownarrow -anchor center
    #--------------
    
    

    set flags_entry ""
    set flags_up_button ""
    set flags_down_button ""
    set up_command ""
    set down_command ""
    set flags_up_up_button ""
    set flags_down_down_button ""
    set up_up_command ""
    set down_down_command ""
    set variable_entry ""
    set show_double_buttons 0
    set up_color default
    set up_up_color default
    set down_color default
    set down_down_color default
    set increment 1
    set big_increment 10
    set limit_from 0
    set limit_to 10

    set ll [ llength $args]
    for { set i 0} { $i < $ll} { incr i} {
        # parejas "-opcion cosas"
        set toca [ lindex $args $i]
        incr i
        if { $i >= $ll} { break}
        switch -- "$toca" {
            "-up-command" {
                set up_command [ lindex $args $i]
            }
            "-down-command" {
                set down_command [ lindex $args $i]
            }
            "-show-double-buttons" {
                set show_double_buttons 1
                set i [ expr $i - 1]
            }
            "-up-up-command" {
                set up_up_command [ lindex $args $i]
            }
            "-down-down-command" {
                set down_down_command [ lindex $args $i]
            }
            "-variable" {
                set variable_entry [ lindex $args $i]
            }
            "-textvariable" {
                set variable_entry [ lindex $args $i]
            }
            "-entry-options" {
                append flags_entry " [ lindex $args $i]"
            }
            "-button-options" {
                append flags_up_button " [ lindex $args $i]"
                append flags_down_button " [ lindex $args $i]"
                append flags_up_up_button " [ lindex $args $i]"
                append flags_down_down_button " [ lindex $args $i]"
            }
            "-up-button-options" {
                append flags_up_button " [ lindex $args $i]"
            }
            "-down-button-options" {
                append flags_down_button " [ lindex $args $i]"
            }
            "-up-up-button-options" {
                append flags_up_up_button " [ lindex $args $i]"
            }
            "-down-down-button-options" {
                append flags_down_down_button " [ lindex $args $i]"
            }
            "-foreground" {
                append flags_entry " -foreground [ lindex $args $i]"
                append flags_up_button " -foreground [ lindex $args $i]"
                append flags_down_button " -foreground [ lindex $args $i]"
                append flags_up_up_button " -foreground [ lindex $args $i]"
                append flags_down_down_button " -foreground [ lindex $args $i]"
            }
            "-background" {
                append flags_entry " -background [ lindex $args $i]"
                append flags_up_button " -background [ lindex $args $i]"
                append flags_down_button " -background [ lindex $args $i]"
                append flags_up_up_button " -background [ lindex $args $i]"
                append flags_down_down_button " -background [ lindex $args $i]"
            }
            "-up-color" {
                set up_color [ lindex $args $i]
            }
            "-down-color" {
                set down_color [ lindex $args $i]
            }
            "-up-up-color" {
                set up_up_color [ lindex $args $i]
            }
            "-down-down-color" {
                set down_down_color [ lindex $args $i]
            }
            "-increment" {
                set increment [ lindex $args $i]
            }
            "-big-increment" {
                set big_increment [ lindex $args $i]
            }
            "-from" {
                set limit_from [ lindex $args $i]
            }
            "-to" {
                set limit_to [ lindex $args $i]
            }
        }
    }

    ttk::frame $w   
    ttk::entry $w.e
    set UpDownEntry($w,Variable) $variable_entry
    if { "$variable_entry" != ""} {
        $w.e configure -textvariable $variable_entry
        set ::UpDownEntry($w,From) $limit_from
        set ::UpDownEntry($w,To) $limit_to
        if { $up_command == ""} {
            set up_command "__UpDownEntry_Incr_Cmd $w $increment"
        }
        if { $down_command == ""} {
            set down_command "__UpDownEntry_Incr_Cmd $w  [ expr -1 * $increment]"
        }
        if { $up_up_command == ""} {
            set up_up_command "__UpDownEntry_Incr_Cmd $w  $big_increment"
        }
        if { $down_down_command == ""} {
            set down_down_command "__UpDownEntry_Incr_Cmd $w [ expr -1 * $big_increment]"
        }
    }
    if { "$flags_entry" != ""} {
        eval [ concat $w.e configure $flags_entry]
    }

    if { ![ info exists UpDownEntry(triangle_up_image,$up_color)] } {
        if { $up_color == "default" } {
            set UpDownEntry(triangle_up_image,$up_color) [ image create photo ]
        } else {
            set UpDownEntry(triangle_up_image,$up_color) [ image create bitmap -data {
                #define triangle_up_width 15
                #define triangle_up_height 9
                static unsigned char triangle_up_bits[ ] = {
                    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x07,
                    0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00};
                } -foreground $up_color ]
        }
    }

    if { ![ info exists UpDownEntry(triangle_down_image,$down_color)] } {
        if { $down_color == "default" } {
            set UpDownEntry(triangle_down_image,$down_color) [ image create photo ]
        } else {
            set UpDownEntry(triangle_down_image,$down_color) [ image create bitmap -data {
                #define triangle_down_width 15
                #define triangle_down_height 9
                static unsigned char triangle_down_bits[ ] = {
                    0x00, 0x00, 0x00, 0x00, 0xf8, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0, 0x01,
                    0x80, 0x00, 0x00, 0x00, 0x00, 0x00};
                } -foreground $down_color ]
        }
    }

    if { ![ info exists UpDownEntry(triangle_up_up_image,$up_up_color)] } {
        if { $up_up_color == "default" } {
            set UpDownEntry(triangle_up_up_image,$up_up_color) [ image create photo ]
        } else {
            set UpDownEntry(triangle_up_up_image,$up_up_color) [ image create bitmap -data {
                #define triangle_up_up_width 15
                #define triangle_up_up_height 9
                static unsigned char triangle_up_up_bits[ ] = {
                    0x00, 0x00, 0x80, 0x00, 0x40, 0x01, 0x20, 0x02, 0x90, 0x04, 0xc8, 0x09,
                    0xe4, 0x13, 0x00, 0x00, 0x00, 0x00};
                } -foreground $up_up_color ]
        }
    }

    if { ![ info exists UpDownEntry(triangle_down_down_image,$down_down_color)] } {
         if { $down_down_color == "default" } {
            set UpDownEntry(triangle_down_down_image,$down_down_color) [ image create photo ]
        } else {
            set UpDownEntry(triangle_down_down_image,$down_down_color) [ image create bitmap -data {
                #define triangle_down_down_width 15
                #define triangle_down_down_height 9
                static unsigned char triangle_down_down_bits[ ] = {
                    0x00, 0x00, 0x00, 0x00, 0xe4, 0x13, 0xc8, 0x09, 0x90, 0x04, 0x20, 0x02,
                    0x40, 0x01, 0x80, 0x00, 0x00, 0x00};
                } -foreground $down_down_color ]
        }
    }

    ttk::frame $w.fb   
    ttk::button $w.fb.up -image $UpDownEntry(triangle_up_image,$up_color) -style TSpinboxUparrow
    if { "$up_command" != ""} {
        $w.fb.up configure -command $up_command
    }
    if { "$flags_up_button" != ""} {
        eval [ concat $w.fb.up configure $flags_up_button]
    }

    ttk::button $w.fb.down -image $UpDownEntry(triangle_down_image,$down_color) -style TSpinboxDownarrow
    if { "$down_command" != ""} {
        $w.fb.down configure -command $down_command
    }
    if { "$flags_down_button" != ""} {
        eval [ concat $w.fb.down configure $flags_down_button]
    }

    if { $show_double_buttons} {
        ttk::button $w.fb.upup -image $UpDownEntry(triangle_up_up_image,$up_up_color) -style TSpinboxUparrow
        if { "$up_up_command" != ""} {
            $w.fb.upup configure -command $up_up_command
        }
        if { "$flags_up_up_button" != ""} {
            eval [ concat $w.fb.upup configure $flags_up_up_button]
        }
        
        ttk::button $w.fb.downdown -image $UpDownEntry(triangle_down_down_image,$down_down_color) -style TSpinboxDownarrow
        if { "$down_down_command" != ""} {
            $w.fb.downdown configure -command $down_down_command
        }
        if { "$flags_down_down_button" != ""} {
            eval [ concat $w.fb.downdown configure $flags_down_down_button]
        }
    }

    grid $w.fb.up -row 0 -column 0 -sticky s
    grid $w.fb.down -row 1 -column 0 -sticky n    
    if { $show_double_buttons} {
        grid $w.fb.upup -row 0 -column 1 -sticky s
        grid $w.fb.downdown -row 1 -column 1  -sticky n
        grid columnconfigure $w.fb 0 -weight 1
    }
    grid rowconfigure $w.fb 0 -weight 1
    grid rowconfigure $w.fb 1 -weight 1
    grid columnconfigure $w.fb 0 -weight 1

    grid $w.e -sticky ew -row 0 -column 0
    grid $w.fb -sticky ns -row 0 -column 1
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1

    set UpDownEntry(ShowDoubles) $show_double_buttons
}

proc UpDownEntryConf { w args} {
    global UpDownEntry

    set flags_entry ""
    set flags_up_button ""
    set flags_down_button ""
    set flags_up_up_button ""
    set flags_down_down_button ""
    set flag_estado ""

    set ll [ llength $args]
    for { set i 0} { $i < $ll} { incr i} {
        # parejas "-opcion cosas"
        set toca [ lindex $args $i]
        incr i
        if { $i >= $ll} { break}
        switch -- "$toca" {
            "-state" {
                set flag_estado [ lindex $args $i]
            }
            "-entry-options" {
                append flags_entry " [ lindex $args $i]"
            }
            "-button-options" {
                append flags_up_button " [ lindex $args $i]"
                append flags_down_button " [ lindex $args $i]"
                append flags_up_up_button " [ lindex $args $i]"
                append flags_down_down_button " [ lindex $args $i]"
            }
            "-up-button-options" {
                append flags_up_button " [ lindex $args $i]"
            }
            "-down-button-options" {
                append flags_down_button " [ lindex $args $i]"
            }
            "-up-up-button-options" {
                append flags_up_up_button " [ lindex $args $i]"
            }
            "-down-down-button-options" {
                append flags_down_down_button " [ lindex $args $i]"
            }
            "-foreground" {
                append flags_entry " -foreground [ lindex $args $i]"
                append flags_up_button " -foreground [ lindex $args $i]"
                append flags_down_button " -foreground [ lindex $args $i]"
                append flags_up_up_button " -foreground [ lindex $args $i]"
                append flags_down_down_button " -foreground [ lindex $args $i]"
            }
            "-background" {
                append flags_entry " -background [ lindex $args $i]"
                append flags_up_button " -background [ lindex $args $i]"
                append flags_down_button " -background [ lindex $args $i]"
                append flags_up_up_button " -background [ lindex $args $i]"
                append flags_down_down_button " -background [ lindex $args $i]"
            }
        }
    }

    switch "$flag_estado" {
        "normal" {
            $w.e configure -state normal
            $w.fb.up configure -state normal
            $w.fb.down configure -state normal
            if { $UpDownEntry(ShowDoubles)} {
                $w.fb.upup configure -state normal
                $w.fb.downdown configure -state normal
            }
        }
        "disabled" {
            $w.e configure -state disabled
            $w.fb.up configure -state disabled
            $w.fb.down configure -state disabled
            if { $UpDownEntry(ShowDoubles)} {
                $w.fb.upup configure -state disabled
                $w.fb.downdown configure -state disabled
            }
        }
    }

    if { "$flags_entry" != ""} {
        eval [ concat $w.e configure $flags_entry]
    }

    if { "$flags_up_button" != ""} {
        eval [ concat $w.fb.up configure $flags_up_button]
    }

    if { "$flags_down_button" != ""} {
        eval [ concat $w.fb.down configure $flags_down_button]
    }

    if { $UpDownEntry(ShowDoubles)} {
        if { "$flags_up_up_button" != ""} {
            eval [ concat $w.fb.upup configure $flags_up_up_button]
        }
        
        if { "$flags_down_down_button" != ""} {
            eval [ concat $w.fb.downdown configure $flags_down_down_button]
        }
    }
}


proc HidePopUpHelp { w} {
    global GiDPrivPopUpHelp

    if { [ info exists GiDPrivPopUpHelp($w)]} {
        while { "$GiDPrivPopUpHelp($w)" == "Busy"} {
            update idletasks
            after 100
        }
        if { [ info exists GiDPrivPopUpHelp($w)]} {
            after cancel $GiDPrivPopUpHelp($w)
        }
    }

    set GiDPrivPopUpHelp($w) Busy

    if { [ winfo exists $w.__popup_help]} {
        destroy $w.__popup_help
    }

    bind $w <Motion> ""
    bind $w <Button-$::gid_right_button> ""
    unset GiDPrivPopUpHelp($w)
}

proc ShowPopUpHelp { w hide_delay text } {
    global GiDPrivPopUpHelp

    if { [ info exists GiDPrivPopUpHelp($w)]} {
        if { "$GiDPrivPopUpHelp($w)" == "Busy"} {
            return
        }
        #while { "$GiDPrivPopUpHelp($w)" == "Busy"} {
        #    update idletasks
        #    after 100
        #}
        after cancel $GiDPrivPopUpHelp($w)
    }
    set GiDPrivPopUpHelp($w) Busy

    if { [ winfo exists $w.__popup_help]} {
        destroy $w.__popup_help
    }

    if { ![ winfo exists $w]} {
        return
    }

    set x [ winfo pointerx $w]
    set y [ winfo pointery $w]

    if { $y < [ expr [ winfo screenheight $w]/2.0] } {
        set y +[ expr $y+3]
    } else {
        set y -[ expr [ winfo screenheight $w]-$y+3]
    }
    if { $x < [ expr [ winfo screenwidth $w]/2.0] } {
        set x +[ expr $x+3]
    } else {
        set x -[ expr [ winfo screenwidth $w]-$x+3]
    }

    toplevel $w.__popup_help

    wm overrideredirect $w.__popup_help 1
    wm geometry $w.__popup_help $x$y
    # ttk::label does not support multiline texts
    label $w.__popup_help.l -background #fff7e7 -foreground black \
            -justify left -text $text -wraplength 10c
    #  -relief ridge
    pack $w.__popup_help.l

    set GiDPrivPopUpHelp($w) [ after $hide_delay "HidePopUpHelp $w"]
    bind $w <Motion> "HidePopUpHelp $w"
    bind $w <Button-$::gid_right_button> "HidePopUpHelp $w"
}

proc ShowPopUpHelpDelayed { w delay hide_delay text} {
    global GiDPrivPopUpHelp

    set par [ winfo parent $w]
    set top [ winfo toplevel $w]
    while { ( "$par" != "") && ( $par != $top)} {
        if { [ info exists GiDPrivPopUpHelp($par)]} {
            while { "$GiDPrivPopUpHelp($par)" == "Busy"} {
                update idletasks
                after 100
            }
            after cancel $GiDPrivPopUpHelp($par)
        }
        if { [ winfo exists $par.__popup_help]} {
            destroy $par.__popup_help
        }
        set par [ winfo parent $par]
    }

    set GiDPrivPopUpHelp($w) [ after $delay "ShowPopUpHelp $w $hide_delay \"$text\""]
    bind $w <Button-$::gid_right_button> "ShowPopUpHelp $w $hide_delay \"$text\""
}

proc GiDPopUpHelp { w args } {
    global GiDPrivPopUpHelp
    #set hide_delay 3000
    # el tiempo durante el cual se muestra el mensaje
    #set hide_delay [ expr int( 1100 * [ llength [ join $args ]] / 3)]
    set hide_delay [ expr int( 500 * [ string length [ join $args ]] / 3)]
    if { $hide_delay < 3000} {
        set hide_delay 3000
    }
    if { [ llength $args] > 1} {
        if { [ string is integer [ lindex $args 0]] } {
            set del [ lindex $args 0]
            if { $del > 0} {
                set hide_delay $del
                set args [ lrange $args 1 end]
            }
        }
    }

    bind $w <Enter> "+ShowPopUpHelpDelayed $w 1500 $hide_delay \"[ join $args]\""
    bind $w <Leave> "+HidePopUpHelp $w"
    bind $w <Motion> "+HidePopUpHelp $w"
    bind $w <ButtonPress-1> "+HidePopUpHelp $w"
    bind $w <ButtonPress-$::gid_central_button> "+HidePopUpHelp $w"
    #bind $w <ButtonPress-$::gid_right_button> "+HidePopUpHelp $w"
    bind $w <Button-1> "+HidePopUpHelp $w"
    bind $w <Button-$::gid_central_button> "+HidePopUpHelp $w"
    #bind $w <Button-$::gid_right_button> "+HidePopUpHelp $w"
    #bind $w <Button-$::gid_right_button> "ShowPopUpHelp $w $hide_delay \"[ join $args]\""
    #foreach ww [ winfo children $w] {
    #         bind $ww <Enter> "+ShowPopUpHelpDelayed $w 1500 $hide_delay \"[ join $args]\""
    #         bind $ww <Leave> "+HidePopUpHelp $w"
    #         bind $ww <Motion> "+HidePopUpHelp $w"
    #         bind $ww <ButtonPress-1> "+HidePopUpHelp $w"
    #         bind $ww <ButtonPress-$::gid_central_button> "+HidePopUpHelp $w"
    #         #bind $w <ButtonPress-$::gid_right_button> "+HidePopUpHelp $w"
    #         bind $ww <Button-1> "+HidePopUpHelp $w"
    #         bind $ww <Button-$::gid_central_button> "+HidePopUpHelp $w"
    #         #bind $w <Button-$::gid_right_button> "+HidePopUpHelp $w"
    #         bind $ww <Button-$::gid_right_button> "ShowPopUpHelp $w $hide_delay \"[ join $args]\""
    #}
}



##########################################################################################
### CCformatFloat2Hex CCGetRGB CCColorActivo CCColorSombra -> para ContourColores
##########################################################################################

proc CCformatFloat2Hex { lstFloats} {
    set r [ expr int( 0.5 + [ lindex $lstFloats 0] * 255.0)]
    set g [ expr int( 0.5 + [ lindex $lstFloats 1] * 255.0)]
    set b [ expr int( 0.5 + [ lindex $lstFloats 2] * 255.0)]
    set ret [ format #%02x%02x%02x $r $g $b]
}

proc CCGetRGB { w color} {
    set ret $color
    set n [ scan $color #%2x%2x%2x r g b]
    if { $n != 3} {
        set rgb [ winfo rgb $w $color]
        #set r [ expr int( 0.5 + [ lindex $rgb 0]/256.0)]
        #set g [ expr int( 0.5 + [ lindex $rgb 1]/256.0)]
        #set b [ expr int( 0.5 + [ lindex $rgb 2]/256.0)]
        set r [ expr int( [ lindex $rgb 0]/256.0)]
        set g [ expr int( [ lindex $rgb 1]/256.0)]
        set b [ expr int( [ lindex $rgb 2]/256.0)]
        set ret [ format #%02x%02x%02x $r $g $b]
    }
    return $ret
}

proc CCColorActivo { color_usuario { factor 17} } {
    set ret $color_usuario
    catch {
        set color_nuevo [ CCGetRGB . $color_usuario]
        set n [ scan $color_nuevo #%2x%2x%2x r g b]
        if { $n == 3} {
            set r [ expr $r + $factor]
            if { $r > 255} { set r 255}
            set g [ expr $g + $factor]
            if { $g > 255} { set g 255}
            set b [ expr $b + $factor]
            if { $b > 255} { set b 255}
            set ret [ format #%02x%02x%02x $r $g $b]
        }
    }
    return $ret
}

proc CCColorComponente { color_usuario { factor_r 17} { factor_g 17} { factor_b 17} } {
    set ret $color_usuario
    catch {
        set color_nuevo [ CCGetRGB . $color_usuario]
        set n [ scan $color_nuevo #%2x%2x%2x r g b]
        if { $n == 3} {
            set r [ expr $r + $factor_r]
            if { $r > 255} { set r 255}
            set g [ expr $g + $factor_g]
            if { $g > 255} { set g 255}
            set b [ expr $b + $factor_b]
            if { $b > 255} { set b 255}
            set ret [ format #%02x%02x%02x $r $g $b]
        }
    }
    return $ret
}

proc CCColorSombra { color_usuario { factor 17} } {
    set ret $color_usuario
    catch {
        set color_nuevo [ CCGetRGB . $color_usuario]
        set n [ scan $color_nuevo #%2x%2x%2x r g b]
        if { $n == 3} {
            set r [ expr $r - $factor]
            if { $r < 0} { set r 0}
            set g [ expr $g - $factor]
            if { $g < 0} { set g 0}
            set b [ expr $b - $factor]
            if { $b < 0} { set b 0}
            set ret [ format #%02x%02x%02x $r $g $b]
        }
    }
    return $ret
}

##########################################################################################
### Switch Button
##########################################################################################

proc SwitchButtonOn { w } {
    global SwitchButton

    set ret [ eval $SwitchButton($w,on_cmd)]

    if { [string tolower $ret] != "error"} {
        $w configure -foreground $SwitchButton($w,activeforeground) \
                -background $SwitchButton($w,activebackground) \
                -relief sunken

        $w invoke
        bind $w <1> "SwitchButtonOff $w; break"
    }
}

proc SwitchButtonOff { w } {
    global SwitchButton

    set ret [ eval $SwitchButton($w,off_cmd)]

    if { "[ string tolower $ret]" != "error"} {
        $w configure -foreground $SwitchButton($w,foreground) \
                -background $SwitchButton($w,background) \
                -relief $SwitchButton($w,relief)
        
        bind $w <1> "SwitchButtonOn $w; break"
    }
}

proc SwitchButton { w on_command off_command args} {
    global SwitchButton

    eval [ concat button $w $args]
    foreach attr "foreground background activeforeground activebackground relief" {
        set SwitchButton($w,$attr) [ $w cget -$attr]
    }
    set SwitchButton($w,on_cmd) $on_command
    set SwitchButton($w,off_cmd) $off_command

    bind $w <1> "SwitchButtonOn $w; break"
}


##########################################################################################
### BotonPlano
##########################################################################################

proc BotonPlano { w texto comando color_fondo_normal color_fondo_activo { color_normal ""} { color_activo ""}} {
    global Plano

    if { $::tcl_platform(os) != "Darwin"} {
        tk::button $w -text $texto -command $comando -borderwidth 0 -background $color_fondo_normal \
            -highlightthickness 1 -highlightbackground $color_fondo_normal
    } else {
        LabelButton $w -text $texto -command $comando -borderwidth 0 -background $color_fondo_normal \
            -highlightthickness 1 -highlightbackground $color_fondo_normal
    }
    set ::BotonPlano($w,color_fondo_normal) $color_fondo_normal
    proc ::BotonPlano_Enter { w color_fondo_activo} {
        set ::BotonPlano($w,color_fondo_normal) [ $w cget -background]
        $w configure -background $color_fondo_activo -highlightbackground #ffffff
    }
    proc ::BotonPlano_Leave { w } {
        set color_fondo_normal $::BotonPlano($w,color_fondo_normal)
        $w configure -background $color_fondo_normal -highlightbackground $color_fondo_normal
    }
    set enter_cmd "::BotonPlano_Enter $w $color_fondo_activo"
    set leave_cmd "::BotonPlano_Leave $w"
    if { "$color_normal" != ""} {
        $w configure -foreground $color_normal
        append leave_cmd "; $w configure -foreground $color_normal"
    }
    if { "$color_activo" != ""} {
        append enter_cmd "; $w configure -foreground $color_activo"
    }
    #-takefocus 0 -borderwidth 1
    bind $w <Enter> $enter_cmd
    bind $w <Leave> $leave_cmd
    set Plano($w,Enter) $enter_cmd
    set Plano($w,Leave) $leave_cmd
}

proc BotonMenuPlano { w texto menu color_fondo_normal color_fondo_activo { color_normal ""} { color_activo ""}} {
    global Plano

    menubutton $w -text $texto -menu $menu -borderwidth 0 -background $color_fondo_normal \
            -highlightthickness 1 -highlightbackground $color_fondo_normal
    set enter_cmd "$w configure -background $color_fondo_activo -highlightbackground #ffffff"
    set leave_cmd "$w configure -background $color_fondo_normal -highlightbackground $color_fondo_normal"
    if { "$color_normal" != ""} {
        $w configure -foreground $color_normal
        append leave_cmd " -foreground $color_normal"
    }
    if { "$color_activo" != ""} {
        append enter_cmd " -foreground $color_activo"
    }
    #-takefocus 0 -borderwidth 1
    bind $w <Enter> $enter_cmd
    bind $w <Leave> $leave_cmd
    set Plano($w,Enter) $enter_cmd
    set Plano($w,Leave) $leave_cmd
}

proc GIDChooseColorGetProperPathForTtkTheme { w} {
    # need to use winfo toplevel for correct ttk theme usage inside bwidget
    # otherwise, a raised border appears on frames
    if { [ regexp {(.*)(\.[^.]+)$} $w dum w_parent w_tail] == 1} {
        #  make choose color widget to be direct child of toplevel to avoid problems described above
        set w [ winfo toplevel $w_parent]$w_tail
    }
    return $w
}

proc GIDChooseColor { w args} {
    # ensure GIDChooseColor appears over the GiD window and not hidden anywhere
    if { [lsearch $args -parent] == -1} {
        # make it a little bit smarter,
        # try first [ file rootname $w] so that it appears above the calling widget
        set try_w [ file rootname $w] ; # if w == .my_toplevel.button_w.col, then try_w = .my_toplevel.button_w
        if { ( $try_w != "") && [ winfo exists $try_w]} {
            lappend args -parent $try_w
        } else {
            lappend args -parent .gid
        }
    }

    # need to use winfo toplevel for correct ttk theme usage inside bwidget
    set w [ GIDChooseColorGetProperPathForTtkTheme $w]
    set nuevo [GiDSelectColor::dialog $w {*}$args]
    return $nuevo
}

# where puede ser: [ list { "at" "center" "left" "right" "above" "below"} $widget]
proc GIDChooseColorMenu { w where args} {
    # need to use winfo toplevel for correct ttk theme usage inside bwidget
    set w [ GIDChooseColorGetProperPathForTtkTheme $w]
    set nuevo [GiDSelectColor::menu $w $where {*}$args]
    if { [ string length $nuevo] == 13} {
        # es de la forma #rrrrggggbbbb -> cada componente 0..65535
        scan $nuevo #%4x%4x%4x r g b
        set r [ expr int( 0.5 + $r * 255.0 / 65535.0)]
        set g [ expr int( 0.5 + $g * 255.0 / 65535.0)]
        set b [ expr int( 0.5 + $b * 255.0 / 65535.0)]
        set nuevo [ format #%02x%02x%02x $r $g $b]
    }
    return $nuevo
}



proc AdjustPosition { w parent_w} {
    # ajuste geometria
    wm withdraw $w
    update idletasks

    # # centrada en la pantalla
    # set x [ expr {[ winfo screenwidth $w]/2 - [ winfo reqwidth $w]/2 \
    #               - [ winfo vrootx [ winfo parent $w]]}]
    # set y [ expr {[ winfo screenheight $w]/2 - [ winfo reqheight $w]/2 \
    #               - [ winfo vrooty [ winfo parent $w]]}]
    set w2 [ expr [ winfo reqwidth $w] / 2]
    set h2 [ expr [ winfo reqheight $w] / 2]
    set x [ expr [ winfo pointerx $parent_w] - $w2]
    set y [ expr [ winfo pointery $parent_w] - $h2]

    # miramos si sale la X
    set off_scr_x [ expr ( $x + $w2 + $w2) - [ winfo screenwidth $w]]
    if { $off_scr_x >= 0} {
        set x [ expr $x - $off_scr_x - 10]
    }
    if { $x < 0} { set x 0}
    # miramos si sale la Y
    set off_scr_y [ expr ( $y + $h2 + $h2) - [ winfo screenheight $w]]
    if { $off_scr_y >= 0} {
        set y [ expr $y - $off_scr_y - 20]
    }
    if { $y < 0} { set y 0}
    wm geometry $w +$x+$y
    wm deiconify $w
}

proc TextWindow { wparent varname title label_text args} {
    upvar $varname __textvar

    if { "$wparent" == "."} {
        set w ".__TextWindow"
    } else {
        set w $wparent.__TextWindow
    }

    # algo de informacion de los argumentos
    # miramos si es editable
    # si hacen falta las barras de scroll
    set solo_lectura 0
    set hay_barras_scroll 0
    set nargs_1 [ expr [ llength $args] - 1]
    for { set i 0} { $i < $nargs_1} { incr i} {
        set toca [ string tolower [ lindex $args $i]]
        set sig [ string tolower [ lindex $args [ expr $i + 1]]]
        if { ( "$toca" == "-state") && ( "$sig" == "disabled")} {
            set solo_lectura 1
        }
        if { ( "$toca" == "-wrap") && ( "$sig" == "none")} {
            set hay_barras_scroll 1
        }
    }


    toplevel $w
    if { $::tcl_platform(platform) == "windows" } {
        wm attributes $w -toolwindow 1
    }
    wm title $w $title

    set color_fondo [ CCGetRGB $w [ $w cget -background]]

    # Titulo y descripcion
    set ftext [ttk::labelframe $w.tf -text $label_text]

    if { $hay_barras_scroll} {
        ttk::scrollbar $ftext.yscroll -orient vertical \
                -command "$ftext.t1 yview" \
                -takefocus 0
        ttk::scrollbar $ftext.xscroll -orient horizontal \
                -command "$ftext.t1 xview" \
                -takefocus 0
        set txt_args "-yscroll \"$ftext.yscroll set\" -xscroll \"$ftext.xscroll set\" -wrap none "
    } else {
        set txt_args " -takefocus 0"
    }
    if { "$args" == ""} { \
        append txt_args " -width 20 -height 3 -borderwidth 1"
    } else {
        append txt_args " $args"
    }
    eval text $ftext.t1 $txt_args
    grid $ftext.t1 -sticky ewns
    if { $hay_barras_scroll} {
        grid  $ftext.xscroll -sticky ew
        grid  $ftext.yscroll -rowspan 2 -row 0 -column 1 -sticky ns
    }
    grid rowconfigure $ftext 0 -weight 1
    grid columnconfigure $ftext 0 -weight 1

    if { $solo_lectura} {
        # to allow add text
        $ftext.t1 configure -state normal
    }
    $ftext.t1 delete 0.0 end
    $ftext.t1 insert end $__textvar
    if { $solo_lectura} {
        $ftext.t1 configure -state disabled
    }

    ####################################
    ### Botones
    ####################################
    ttk::frame $w.botones -style BottomFrame.TFrame   
    
    proc ActualizaVariable { var wtext} {
        #upvar $var __tt
        set tmp [ $wtext get 0.0 end]
        # quitamos el lf del final
        set $var [ string range $tmp 0 [ expr [ string length $tmp] - 2]]
    }

    ttk::button $w.botones.close -text [_ "Close"] \
        -style BottomFrame.TButton \
            -command "if { !$solo_lectura} { \
            bind $ftext.t1 <Alt-Return> {} \
        }; \
        bind $w.tf <Escape> {}; \
        bind $ftext.t1 <Escape> {}; \
        destroy $w"    

    if { !$solo_lectura} {
        ttk::button $w.botones.aceptar -text [ _ "Apply"] -style BottomFrame.TButton \
                -command  "ActualizaVariable $varname $ftext.t1 ; after idle destroy $w"
        grid $w.botones.aceptar $w.botones.close -pady 10 -padx 4 -sticky ews
    } else {
        grid $w.botones.close -pady 10 -padx 4 -sticky ews
    }

    grid $w.tf -sticky wens -pady 4 -padx 4
    grid $w.botones -sticky sew
    grid anchor $w.botones center

    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1

    #bind $w.tf <Shift-Return> "$w.botones.aceptar invoke"
    #bind $ftext.t1 <Shift-Return> "$w.botones.aceptar invoke"
    if { !$solo_lectura} {
        bind $ftext.t1 <Alt-Return> "$w.botones.aceptar invoke"
        bind $ftext.t1 <Alt-KP_Enter> "$w.botones.aceptar invoke"
    }
    bind $w.tf <Escape> "$w.botones.close invoke"
    bind $ftext.t1 <Escape> "$w.botones.close invoke"

    if { "$wparent" == "."} {
        set wp2 [ expr [ winfo screenwidth $wparent] / 2]
        set hp2 [ expr [ winfo screenheight $wparent] / 2]
    } else {
        set wp2 [ expr [ winfo width $wparent] / 2]
        set hp2 [ expr [ winfo height $wparent] / 2]
    }

    set cpx [ expr [ winfo rootx $wparent] + $wp2]
    set cpy [ expr [ winfo rooty $wparent] + $hp2]

    set wp2 [ expr [ winfo reqwidth $w] / 2]
    set hp2 [ expr [ winfo reqheight $w] / 2]

    set wx [ expr $cpx - $wp2]
    set wy [ expr $cpy - $hp2]
    if { $wx < 0} { set wx 1}
    if { $wy < 0} { set wy 1}

    wm geometry $w +${wx}+${wy}
    if { !$solo_lectura} {
        focus $ftext.t1
    } else {
        focus $w.botones.close
    }

    tkwait window $w
    return $w
}

########################################################################
### ResultSelectionWidget pahtName options
### options: -analysis { all | current } # default: all
###          -step { all | current}      # default: all
###          -result { all | current }   # default: all
###          -type { scalar | vector | matrix | localaxes}
###                                      # default:  scalar
###          -showcurrent { 0 | 1}       # default: 1
###          -show {{analysis} {step} {result} ?{component}?}
###          -variable var_name_dst      # a list with:
###                    # {analysis} {step} {result} ?{component}?
########################################################################

namespace eval ResultSelectionWidget {
    variable _opciones
    variable _opciones_posibles
    variable _lista_widgets    {}
    variable _tabla_widgets

    # opciones por defecto:
    array set _opciones {
        -analysis     all
        -step         all
        -result       all
        -type         scalar
        -showcurrent  1
    }

    # opciones posibles:
    array set _opciones_posibles \
        [ list \
              -analysis    [ list all current] \
              -step        [ list all current] \
              -result      [ list all current] \
              -type        [ list scalar vector matrix localaxes] \
              -showcurrent [ list 0 1] \
              -show        {} \
              -variable    {} \
             ]
            
}

proc ResultSelectionWidget::Destroy { nombre} {
    variable _lista_widgets
    variable _tabla_widgets

    set idx [ lsearch $_lista_widgets $nombre]
    if { $idx != -1} {
        # borramos el procedimiento
        #rename $nombre
        set _lista_widgets [ lreplace $_lista_widgets $idx $idx]
        array unset _tabla_widgets ${nombre},*
    }
}

proc ResultSelectionWidget::ResultSelectionWidget { nombre args} {
    variable _lista_widgets
    variable _tabla_widgets
    variable _opciones
    global _opciones_posibles

    set err 0
    set err_msg ""
    foreach {opt val} $args {
        if { ![ info exists _opciones_posibles($opt)]} {
            set err 1
            set err_msg [ format [ _ "incorrect option %s, should be one of %s"] \
                              $opt [ array names _opciones_posibles]]
            break
        }
        if { "$val" == ""} {
            set err 1
            if { [ llength $_opciones_posibles($opt)] != 0} {
                set err_msg [ format [ _ "empty value for option %s, should be one of %s"] \
                                  $opt $_opciones_posibles($opt)]
            } else {
                set err_msg [ format [ _ "empty value for option %s"] $opt]
            }
            break
        }
        if { ( [ llength $_opciones_posibles($opt)] != 0) && \
                 [ lsearch -exact $_opciones_posibles($opt) $val] == -1} {
            set err 1
            set err_msg [ format [ _ "incorrect value %s for option %s, should be one of %s"] \
                              $val $opt $_opciones_posibles($opt)]
            break
        }
        set _opciones($opt) $val
    }

    if { $err} {
        puts $err_msg
        return -1
    }

    bind <Destroy> "+ResultSelectionWidget::Destroy %W"
    lappend _lista_widgets $nombre
    # por poner algo y acordarme donde lo tengo que meter
    set _tabla_widgets($nombre,args) $args
}

proc VerificaReal { msg texto { w .}} {
    set ret 1
    if { ![ regexp {^[  ]*([ +-]?[ 0-9]*\.?[ 0-9]+([ eE][ +-]?[ 0-9]+)?)[  ]*$} $texto] } {
        WarnWin [ format "%s %s" $msg [ _ "One number must be entered"]. ] $w
        set ret 0
    }
    return $ret
}

################################
# TTKMenubutton:
# TTKMenubutton widget
#         opciones validas:
#         -labels lista_etiquetas
#         -values lista_valores
#         -textvariable variable_para_guardar_el_valor
#         -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
#         -commands lista_comandos_para_cada_label/value
#         -images list of images for each label/value
#      tambien admite las opciones estandard:
#         -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction
# TTKMenubuttonInvoke widget TextoEntradaMenu
#                     --> selecciona e invoca la entrada de menu con texto TextoEntradaMenu
# TTKMenubuttonSelect widget TextoEntradaMenu
#                     --> muestra la entrada de menu con texto TextoEntradaMenu en el boton
# TTKMenubuttonConfigure widget opciones
#                     --> para redefinir opcionesl del widget
# TTKMenubuttonCGet widget opcion
#                     --> para conseguir informacion de alguna opcion del widget
################################

proc TTKMenubutton { w args} {
    if { $w == "."} {
        error ". can not be used as TTKMenubutton."
        return $w
    }
    array set opciones $args

    # opciones validas:
    # -labels lista_etiquetas
    # -values lista_valores
    # -textvariable variable_para_guardar_el_valor
    # -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
    # -commands lista_comandos_para_cada_label/value
    # -images list of images for each label/value

    # las no definidas las ponemos vacias
    foreach opc [ list -labels -values -textvariable -modifycmd -commands -images] {
        if { ![ info exists opciones($opc)]} {
            set opciones($opc) ""
        }
        set ::TTKMenubuttonOpciones($w,$opc) $opciones($opc)
    }

    set var_name ::ttkmb[ string map {. _ \# _} $w]
    if { $opciones(-textvariable) != "" } {
        set var_name $opciones(-textvariable)
    }

    # demas parsing de opciones
    # $::tcl_platform(os) != "Linux"
    #if { [ tk windowingsystem] != "x11"} { # win32, x11 (linux/MacOSX), aqua, classic (MacOS)
        # si queremos distinguir diferentes versiones de Windows:
        # (platform) == "windows" && (osVersion) >= 5.1 (xp)
        ttk::menubutton $w -menu $w.m
    #} else {
    #   menubutton $w -menu $w.m -indicatoron 1
    #}
    menu $w.m -tearoff 0
    foreach txt $opciones(-labels) val $opciones(-values) cmd $opciones(-commands) img $opciones(-images) {
        if { $txt == "---" } {
            $w.m add separator
        } else {
            if { ( $txt != "") && ( $val == "")} {
                set val $txt
            }
            if { ( $txt == "") && ( $val != "")} {
                set txt $val
            }
            set act_cmd "update; set $var_name [ list $val]; $cmd; $opciones(-modifycmd)"
            if { $img != ""} {
                set cmd_menu "$w configure -text [ list $txt] -image $img -compound left; $act_cmd"
                $w.m add command -label $txt -command $cmd_menu \
                    -image $img -compound left
            } else {
                set cmd_menu "$w configure -text [ list $txt] -image {} -compound left; $act_cmd"
                $w.m add command -label $txt -command $cmd_menu
            }
        }
    }

    foreach std_opc [ list -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction] {
        if { [ info exists opciones($std_opc)]} {
            $w configure $std_opc $opciones($std_opc)
        }
    }

    # por compatibilidad con ComboBox
    trace add variable $var_name write [ list TTKMenubuttonSelectEntry $w $var_name]
    if { [ info exists $var_name]} {
        set $var_name [set $var_name]
    } else {
        set $var_name ""
    }

    bind $w <Destroy> [ list +TTKMenubuttonDestroy %W $w $var_name] ;# + to add to previous script
    return $w
}

proc TTKMenubuttonDestroy { W w var_name } {
    if { $W != $w } return
    trace remove variable $var_name write [ list TTKMenubuttonSelectEntry $w $var_name]
}

proc TTKMenubuttonSelectEntry { w var_name name1 name2 op} {
    if { [ winfo exists $w]} {
        #WarnWinText [ subst "TTKMenubuttonSelectEntry $w '$$var_name'"]
        TTKMenubuttonSelect $w [set $var_name]
    }
}

proc BuscaEntradaMenu { w str} {
    # set n [ $w.m index end]
    # for { set i 0} { $i <= $n} { incr i} {
    #         if { [ string equal $str [ $w.m entrycget $i -label]]} {
    #             return $i
    #         }
    # }
    # tenemos que tener encuenta que str es el valor de la variable
    set lst $::TTKMenubuttonOpciones($w,-values)
    if { [ llength $lst] == 0} {
        set lst $::TTKMenubuttonOpciones($w,-labels)
    }
    #WarnWinText "$str --> $lst"
    set idx [ lsearch -exact $lst $str]
    return $idx
}

proc TTKMenubuttonSelect { w str} {
    if { $w == "."} {
        error ". can not be used as TTKMenubutton."
        return $w
    }
    set idx -1
    # si str es una palabra, busca entre los labels de las entradas del menu
    # pero si es un numero o 'end' lo trata como un numero y no como texto de la entrada del menu
    # set err [ catch {
    #         set idx [ $w.m index $str]
    # }]
    set idx [ BuscaEntradaMenu $w $str]
    #WarnWin "$idx|$str"
    #WarnWinText "TTKMenubuttonSelect $w '$str'"
    if { $idx != -1} {
        $w configure -text [ $w.m entrycget $idx -label] \
            -image [ $w.m entrycget $idx -image] -compound left
    }
    return $w
}

proc TTKMenubuttonInvoke { w str} {
    set idx -1
    # si str es una palabra, busca entre los labels de las entradas del menu
    # pero si es un numero o 'end' lo trata como un numero y no como texto de la entrada del menu
    # set err [ catch {
    #         set idx [ $w.m index $str]
    # }]
    set idx [ BuscaEntradaMenu $w $str]
    if { $idx != -1} {
        $w.m invoke $idx
    }
    return $w
}

proc TTKMenubuttonConfigure { w args} {
    if { $w == "."} {
        error ". can not be used as TTKMenubutton."
        return $w
    }
    if { ![ winfo exists $w]} {
        error "TTKMenubutton $w does not exist."
        return $w
    }
    array set opciones $args

    # opciones validas:
    # -labels lista_etiquetas
    # -values lista_valores
    # -textvariable variable_para_guardar_el_valor
    # -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
    # -commands lista_comandos_para_cada_label/value
    # -images list of images for each label/value

    set prev_textvariable $::TTKMenubuttonOpciones($w,-textvariable)
    # las no definidas las ponemos vacias
    foreach opc [ list -labels -values -textvariable -modifycmd -commands -images] {
        if { ![ info exists opciones($opc)]} {
            set opciones($opc) $::TTKMenubuttonOpciones($w,$opc)
        }
        set ::TTKMenubuttonOpciones($w,$opc) $opciones($opc)
    }
    
    set var_name $opciones(-textvariable)
    
    # si la variable es diferente, quitamos el trace anterior
    if { $prev_textvariable != "" && $prev_textvariable != $opciones(-textvariable)} {
        set trace_inf [ trace info variable $prev_textvariable]
        foreach it $trace_inf {
            trace remove variable $prev_textvariable [ lindex $it 0] [ lindex $it 1]
        }
    }

    # demas parsing de opciones
    $w.m delete 0 end
    foreach txt $opciones(-labels) val $opciones(-values) cmd $opciones(-commands) img $opciones(-images) {
        if { $txt == "---" } {
            $w.m add separator
        } else {
            if { ( $txt != "") && ( $val == "")} {
                set val $txt
            }
            if { ( $txt == "") && ( $val != "")} {
                set txt $val
            }
            set act_cmd "update; set $var_name [ list $val]; $cmd; $opciones(-modifycmd)"
            if { $img != ""} {
                set cmd_menu "$w configure -text [ list $txt] -image $img -compound left; $act_cmd"
                $w.m add command -label $txt -command $cmd_menu \
                    -image $img -compound left
            } else {
                set cmd_menu "$w configure -text [ list $txt] -image {} -compound left; $act_cmd"
                $w.m add command -label $txt -command $cmd_menu
            }
        }        
    }

    # las opciones estandard
    foreach std_opc [ list -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction] {
        if { [ info exists opciones($std_opc)]} {
            $w configure $std_opc $opciones($std_opc)
        }
    }

    # por compatibilidad con ComboBox
    # si la variable es diferente, la hemos quitado antes y ahora hay que registrarla    
    if { $prev_textvariable != $var_name} {
        trace add variable $var_name write [ list TTKMenubuttonSelectEntry $w $var_name]
    }
    if { [ info exists $var_name]} {
        set $var_name [set $var_name]
    } else {
        set $var_name ""
    }
    #
    # foreach it $trace_inf {
    #         trace add variable $var_name [ lindex $it 0] [ lindex $it 1]
    # }

    return $w
}

proc TTKMenubuttonCGet { w opc} {
    set lst_opc [ list -labels -values -textvariable -modifycmd -commands -images]
    set std_opc [ list -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction]
    if { [ lsearch -exact $lst_opc $opc] != -1} {
        return $::TTKMenubuttonOpciones($w,$opc)
    } elseif { [ lsearch -exact $std_opc $opc]} {
        return $w cget $opc
    } else {
        error "Incorrect cget-option '$opc' for $w. should be one of '[ join $lst_opc]' or '[ join $std_opc]'"
        return {}
    }
}

proc TTKMB_CreateOrConfigure { w} {
    if { [ winfo exists $w]} {
        return TTKMenubuttonConfigure
    } else {
        return TTKMenubutton
    }
}

################################
# TTKMessagebox:
# TTKMessagebox widget como el messagebox, pero con una lista de etiquetas/valores donde elegir
#         la etiqueta/valor seleccionado devuelve el valor
#         opciones validas:
#         -title titulo
#         -message mensaje_de_la_ventana
#         -labels lista_etiquetas
#         -values lista_valores
#         -textvariable variable_para_guardar_el_valor
#         -images list of images for each label/value
#      tambien admite las opciones estandard:
#         -parent
#         -icon nombre del icono a mostrar
################################

proc TTKMessagebox { args} {
    array set opciones $args
    set windowingsystem [ tk windowingsystem]

    # opciones validas:
    # -title titulo_de_la_ventana
    # -message mensaje_de_la_ventana
    # -labels lista_etiquetas
    # -values lista_valores
    # -textvariable variable_para_guardar_el_valor
    # -images list of images for each label/value
    # -parent aunque de momento no se usa para nada
    # -icon nombre del icono a mostrar
    # devuelve el valor seleccionado

    # las no definidas las ponemos vacias
    foreach opc [ list -title -message -labels -values -textvariable -images -parent -icon] {
        if { ![ info exists opciones($opc)]} {
            set opciones($opc) ""
        }
    }

    if { $opciones(-parent) == ""} {
        set opciones(-parent) .
    }

    if { $opciones(-parent) != "."} {
        set w $opciones(-parent).___TTKMessagebox_tmp_
    } else {
        set w .___TTKMessagebox_tmp_
    }
    if { $w == "."} {
        error ". can not be used as TTKMessagebox."
        return $w
    }

    foreach opc [ list -title -message -labels -values -textvariable -images -parent -icon] {
        set ::TTKMessageboxOpciones($w,$opc) $opciones($opc)
    }

    set var_name ::ttkmb[ string map {. _ \# _} $w]
    if { $opciones(-textvariable) != "" } {
        set var_name $opciones(-textvariable)
    }

    # set def_back [ $w cget -background]
    set def_back [ ttk::style lookup . -background]

    if { [ winfo exists $w]} {
        error "$w already exists"
        return {}
    }

    # creacion de la ventana
    toplevel $w -class Dialog -background $def_back
    if { $::tcl_platform(platform) == "windows" } {
        wm attributes $w -toolwindow 1
    }
    if { $opciones(-title) != ""} {
        wm title $w $opciones(-title)
    } else {
        wm title $w TTKMessagebox
    }
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    if { [ winfo viewable [ winfo toplevel $opciones(-parent)]] } {
        wm transient $w $opciones(-parent)
    }

    if {$windowingsystem eq "aqua"} {
        ::tk::unsupported::MacWindowStyle style $w moveableModal {}
    }

    # top frame
    set f [ ttk::frame $w.fTop -style flat.TFrame]

    # ttk::label does not support multiline texts
    label $f.tMes -anchor nw -justify left -text $opciones(-message)
    if { $opciones(-icon) != ""} {
        label $f.lIcon -image $opciones(-icon)
        grid $f.lIcon $f.tMes -sticky news -padx 4 -pady 2
        grid columnconfigure $f 1 -weight 1
    } else  {
        grid columnconfigure $f 0 -weight 1
    }
    grid rowconfigure $f 0 -weight 1

    # bottom frame   
    set f [ ttk::frame $w.fBot -style BottomFrame.TFrame]   
    set numBotonesLinea 4
    set ifila 0
    set icol 0
    set iBoton 0
    foreach txt $opciones(-labels) val $opciones(-values) img $opciones(-images) {
        if { ( $txt != "") && ( $val == "")} {
            set val $txt
        }
        if { ( $txt == "") && ( $val != "")} {
            set txt $val
        }
        set cmd "set $var_name [ list $val]; destroy $w"
        if { $img != ""} {
            set opts [ list -text $txt -image $img -style BottomFrame.TButton]
        } else {
            set opts [ list -text $txt -style BottomFrame.TButton]
        }
        eval [ list tk::AmpWidget ttk::button $f.b$iBoton] $opts \
            [ list -command $cmd]

        grid $f.b$iBoton -row $ifila -column $icol -padx 12 -pady 8
        incr icol
        if { $icol == $numBotonesLinea} {
            incr ifila
            set icol 0
        }
        incr iBoton
    }

    grid $w.fTop -sticky news
    grid $w.fBot -sticky ew
    grid rowconfigure $w 0 -weight 1
    grid rowconfigure $w 1 -weight 1
    grid columnconfigure $w 0 -weight 1

    # foreach std_opc [ list -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction] {
    #         if { [ info exists opciones($std_opc)]} {
    #             $w configure $std_opc $opciones($std_opc)
    #         }
    # }

    # por compatibilidad con ComboBox
    tkwait window $w

    return [set $var_name]
}


################################
# TTKComboBox:
# TTKComboBox widget
#         opciones validas:
#         -labels lista_etiquetas
#         -values lista_valores
#         -textvariable variable_para_guardar_el_valor
#         -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
#  ( QUITADO)        -commands lista_comandos_para_cada_label/value
#  ( QUITADO)        -images list of images for each label/value
#      tambien admite las opciones estandard:
#         -width -height -state -style -takefocus -text -image -compount -cursor -underline -direction -state
# TTKComboBox_configure widget opciones
#                     --> para redefinir opcionesl del widget
# TTKComboBoxCGet widget opcion
#                     --> para conseguir informacion de alguna opcion del widget
################################

proc defineWidget_destroy { tipo w} {
    bind $w <1> ""
    foreach opc [ array names ::${tipo}Opciones ${w}*] {
        unset ::${tipo}Opciones($opc)
    }
    rename $w ""
    # rename ${w}_original $w
    destroy $w
}

proc defineWidgetProc { tipo w cmd args} {
    set nombreProc ${tipo}_$cmd
    if { [ llength [ info procs $nombreProc]] != 0} {
        return [ eval [ linsert $args 0 ${tipo}_$cmd [ list $w]]]
    } else {
        return [ eval ${w}_original $cmd $args]
    }
}

proc defineWidget { tipo w} {
    rename ${w} ${w}_original
    # proc ::$w { cmd args } \
    #         [ subst {return \[ eval \[ linsert \$args 0 ${tipo}_\$cmd [ list $w]\]\]}]
    proc ::$w { cmd args} \
        [ subst { return \[ eval defineWidgetProc ${tipo} $w \$cmd \$args\]}]

    bind $w <Destroy> [ list defineWidget_destroy $tipo $w]
}

proc TTKComboBox { w args} {
    if { $w == "."} {
        error ". can not be used as TTKComboBox."
        return $w
    }
    array set opciones $args

    # opciones validas:
    # -labels lista_etiquetas
    # -values lista_valores
    # -textvariable variable_para_guardar_el_valor
    # -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
    # -commands lista_comandos_para_cada_label/value
    # -images list of images for each label/value

    # las no definidas las ponemos vacias
    # -commands -images
    foreach opc [ list -labels -values -textvariable -modifycmd] {
        if { ![ info exists opciones($opc)]} {
            set opciones($opc) ""
        }
        set ::TTKComboBoxOpciones($w,$opc) $opciones($opc)
    }

    # para hacer las traducciones de etiquetas a valores se utiliza una variable interna
    set var_name_int ::ttkcb_int_[ string map {. _ \# _} $w]
    if { $opciones(-textvariable) != "" } {
        set var_name_int ::ttkcb_int_[ regsub -all {::} $opciones(-textvariable) {__}]
    }

    set var_name ::ttkcb[ string map {. _ \# _} $w]
    if { $opciones(-textvariable) != "" } {
        set var_name $opciones(-textvariable)
    }
    set ::TTKComboBoxOpciones($w,VariableInterna) $var_name_int
    set ::TTKComboBoxOpciones($w,VariableExterna) $var_name

    # demas parsing de opciones
    # $::tcl_platform(os) != "Linux"
    # if { [ tk windowingsystem] != "x11"} { # win32, x11 (linux/MacOSX), aqua, classic (MacOS)
    #         # si queremos distinguir diferentes versiones de Windows:
    #         # (platform) == "windows" && (osVersion) >= 5.1 (xp)
    #         ttk::combobox $w
    # } else {
    #         # menubutton $w -menu $w.m -indicatoron 1
    #         ComboBox $w -indicatoron 1
    # }

    set lst_lbl {}
    set lst_val {}
    # cmd $opciones(-commands) img $opciones(-images)
    foreach txt $opciones(-labels) val $opciones(-values) {
        if { ( $txt != "") && ( $val == "")} {
            set val $txt
        }
        if { ( $txt == "") && ( $val != "")} {
            set txt $val
        }
        # set act_cmd "update; set $var_name [ list $val]; $cmd; $opciones(-modifycmd)"
        # if { $img != ""} {
        #     set cmd_menu "$w configure -text [ list $txt] -image $img -compound left; $act_cmd"
        #     $w.m add command -label $txt -command $cmd_menu \
        #         -image $img -compound left
        # } else {
        #     set cmd_menu "$w configure -text [ list $txt] -image {} -compound left; $act_cmd"
        #     $w.m add command -label $txt -command $cmd_menu
        # }
        lappend lst_lbl $txt
        lappend lst_val $val
    }
    set ::TTKComboBoxOpciones($w,ListaEtiquetas) $lst_lbl
    set ::TTKComboBoxOpciones($w,ListaValores) $lst_val

    ttk::combobox $w -textvariable $var_name_int -values $lst_lbl
    # WarnWinText "ttk::combobox $w -textvariable $var_name_int -values $lst_lbl"

    # antes de definir que cree el widget, para que no llame al procedimiento equivocado
    defineWidget TTKComboBox $w

    # por compatibilidad con ComboBox
    if { [ info exists $var_name]} {
        set $var_name [set $var_name]
    } else {
        set $var_name ""
    }

    # mapeo de la entrada seleccionada del comobox al valor a poner en la variable del usuario
    trace add variable $var_name_int write [ list TTKComboBoxEntrySelected $w $var_name_int]
    # mapeo del valor puesto por el usuario en la variable a la entrada seleccionada en el combobox
    trace add variable $var_name write [ list TTKComboBoxSelectEntry $w $var_name]

    # definimos el resto de opciones despues de poner los valors por defecto
    # para evitar que se llame a -modifycmd cuando se esta creando y postniendo la variable
    # a su valor por defecto
    foreach std_opc [ list -width -height -state -style -takefocus -text -image \
                          -compount -cursor -underline -direction -state] {
        if { [ info exists opciones($std_opc)]} {
            $w configure $std_opc $opciones($std_opc)
        }
    }

    bind $w <Destroy> [ list +TTKComboBoxDestroy %W $w $var_name $var_name_int] ;# + to add to previous script
    return $w
}

proc TTKComboBoxDestroy { W w var_name var_name_int } {
    if { $W != $w } return     
    
    trace remove variable $var_name_int write [ list TTKComboBoxEntrySelected $w $var_name_int]
    trace remove variable $var_name write [ list TTKComboBoxSelectEntry $w $var_name]
}

# Etiqueta seleccionada en la combobox --> valor en la variable del usuario
proc TTKComboBoxEntrySelected { w var_name_int name1 name2 op} {
    # if { [ winfo exists $w]} {
    #         #WarnWinText [ subst "TTKComboBoxSelectEntry $w '$$var_name'"]
    #         TTKComboBoxSelect $w [set $var_name]
    # } else {
    #         trace remove variable $var_name write [ list TTKComboBoxSelectEntry $w $var_name]
    # }
    if { [ winfo exists $w] } {
        set idx [ lsearch -exact $::TTKComboBoxOpciones($w,ListaEtiquetas) [set $var_name_int]]
        if { $idx >= 0} {
            set val [ lindex $::TTKComboBoxOpciones($w,ListaValores) $idx]
        } else {
            set val [set $var_name_int]
        }
        # WarnWinText "--> set $::TTKComboBoxOpciones($w,VariableExterna) $val"
        set $::TTKComboBoxOpciones($w,VariableExterna) $val
        if { $::TTKComboBoxOpciones($w,-modifycmd) != ""} {
            eval $::TTKComboBoxOpciones($w,-modifycmd)
        }
    } else {
        trace remove variable $var_name_int write [ list TTKComboBoxEntrySelected $w $var_name_int]
    }
}

# valor puesto por el usuario en la variable --> seleccionar etiqueta en la combobox
proc TTKComboBoxSelectEntry { w var_name name1 name2 op} {
    if { [ winfo exists $w] } {
        set idx [ lsearch -exact $::TTKComboBoxOpciones($w,ListaValores) [set $var_name]]
        if { $idx >= 0} {
            set etiq [ lindex $::TTKComboBoxOpciones($w,ListaEtiquetas) $idx]
        } else {
            set etiq [set $var_name]
        }
        # WarnWinText "--> $idx: set $::TTKComboBoxOpciones($w,VariableInterna) $etiq"
        set $::TTKComboBoxOpciones($w,VariableInterna) $etiq
    }
}

proc TTKComboBox_state { w args} {
  #$w configure -state $args  
  ${w}_original state $args
}

proc TTKComboBox_configure { w args} {
    # WarnWin "TTKComboBox_configure $w $args"
    if { $w == "."} {
        error ". can not be used as TTKComboBox."
        return $w
    }
    if { ![ winfo exists $w]} {
        error "TTKComboBox $w does not exist."
        return $w
    }
    array set opciones $args

    # opciones validas:
    # -labels lista_etiquetas
    # -values lista_valores
    # -textvariable variable_para_guardar_el_valor
    # -modifycmd comando_a_llamar_cuando_se_selecciona_la_opcion
    # -commands lista_comandos_para_cada_label/value
    # -images list of images for each label/value

    # las no definidas las ponemos vacias
    #  -commands -images
    foreach opc [ list -labels -values -textvariable -modifycmd] {
        if { ![ info exists opciones($opc)]} {
            if { [ info exists ::TTKComboBoxOpciones($w,$opc)]} {
                set opciones($opc) $::TTKComboBoxOpciones($w,$opc)
            } else {
                set opciones($opc) ""
            }
        }
        set ::TTKComboBoxOpciones($w,$opc) $opciones($opc)
    }

    # para hacer las traducciones de etiquetas a valores se utiliza una variable interna
    set var_name_int ::ttkcb_int_[ string map {. _ \# _} $w]
    if { $opciones(-textvariable) != "" } {
            set var_name_int ::ttkcb_int_[ regsub -all {::} $opciones(-textvariable) {__}]
    }

    set var_name ::ttkcb[ string map {. _ \# _} $w]
    if { $opciones(-textvariable) != "" } {
            set var_name $opciones(-textvariable)
    }

    # si la variable es diferente, quitamos el trace anterior
    if { $var_name != $opciones(-textvariable)} {
        set trace_inf [ trace info variable $opciones(-textvariable)]
        foreach it $trace_inf {
            trace remove variable $opciones(-textvariable) [ lindex $it 0] [ lindex $it 1]
        }
    }

    # set var_name_int $::TTKComboBoxOpciones($w,VariableExterna)
    # set var_name $::TTKComboBoxOpciones($w,VariableInterna)
    #
    # # borramos nuestros trace's para evitar lanzarlos
    # trace remove variable $var_name_int write [ list TTKComboBoxEntrySelected $w $var_name_int]
    # # mapeo del valor puesto por el usuario en la variable a la entrada seleccionada en el combobox
    # trace remove variable $var_name w [ list TTKComboBoxSelectEntry $w $var_name]

    # demas parsing de opciones
    set lst_lbl {}
    set lst_val {}
    #  cmd $opciones(-commands) img $opciones(-images)
    foreach txt $opciones(-labels) val $opciones(-values) {
        if { ( $txt != "") && ( $val == "")} {
            set val $txt
        }
        if { ( $txt == "") && ( $val != "")} {
            set txt $val
        }
        # set act_cmd "update; set $var_name [ list $val]; $cmd; $opciones(-modifycmd)"
        # if { $img != ""} {
        #     set cmd_menu "$w configure -text [ list $txt] -image $img -compound left; $act_cmd"
        #     $w.m add command -label $txt -command $cmd_menu \
        #         -image $img -compound left
        # } else {
        #     set cmd_menu "$w configure -text [ list $txt] -image {} -compound left; $act_cmd"
        #     $w.m add command -label $txt -command $cmd_menu
        # }
        #WarnWinText "$w --> $txt --> $cmd_menu"
        lappend lst_lbl $txt
        lappend lst_val $val
    }
    set ::TTKComboBoxOpciones($w,ListaEtiquetas) $lst_lbl
    set ::TTKComboBoxOpciones($w,ListaValores) $lst_val

    # WarnWinText "${w}_original configure -values $lst_lbl [ llength $lst_lbl]"
    ${w}_original configure -values $lst_lbl
    # WarnWinText "${w}_original configure -values $lst_lbl"

    # las opciones estandard
    foreach std_opc [ list -width -height -state -style -takefocus -text -image \
                          -compount -cursor -underline -direction -state] {
        if { [ info exists opciones($std_opc)]} {
            ${w}_original configure $std_opc $opciones($std_opc)
        }
    }

    # por compatibilidad con ComboBox
    # si la variable es diferente, la hemos quitado antes y ahora hay que registrarla
    # mapeo del valor puesto por el usuario en la variable a la entrada seleccionada en el combobox


    if { [llength $args] == 2 && [lindex $args 0] == "-cursor" } {
        #trick: check if args is -cursor xx and then avoid set $var_name that could have trace that invoke procedures
        #e.g. MeshQuality window is invoking MQChangeQualityCriteria and MQDrawGraphCurrent when moving 
        #the cursor over TTKComboBox widgets with stacks like this!!
        # level 6 MQChangeQualityCriteria .gid.meshq
        # level 5 TTKComboBox_configure .gid.meshq.f.nb.fTriangle.type.m -cursor ibeam
        # level 4 defineWidgetProc TTKComboBox .gid.meshq.f.nb.fTriangle.type.m configure -cursor ibeam
        # level 3 .gid.meshq.f.nb.fTriangle.type.m configure -cursor ibeam
        # level 2 ttk::setCursor .gid.meshq.f.nb.fTriangle.type.m text
        # level 1 ttk::combobox::Motion .gid.meshq.f.nb.fTriangle.type.m 33 19
    } else {
        # para evitar lanzar modifycmd que no tocan:
        set antes $::TTKComboBoxOpciones($w,-modifycmd)
        set ::TTKComboBoxOpciones($w,-modifycmd) ""
        if { [ info exists $var_name]} {
            set $var_name [set $var_name]
        } else {
            set $var_name ""
        }
        set ::TTKComboBoxOpciones($w,-modifycmd) $antes
    }
        
    if { $var_name != $opciones(-textvariable)} {
        trace add variable $var_name write [ list TTKComboBoxSelectEntry $w $var_name]
    }

    # # volvemos a definir nuestros traces
    # trace add variable $var_name_int write [ list TTKComboBoxEntrySelected $w $var_name_int]
    # trace add variable $var_name write [ list TTKComboBoxSelectEntry $w $var_name]

    #
    # foreach it $trace_inf {
    #         trace add variable $var_name [ lindex $it 0] [ lindex $it 1]
    # }

    return $w
}

proc TTKComboBox_cget { w args} {
    # WarnWin "TTKComboBox_cget $w $args"
    # WarnWinText "TTKComboBox_cget $w $args"
    # WarnWinText "namespace: [ namespace current]"
    # set fr_level [ info frame]
    # while { $fr_level >= 0} {
    #         WarnWinText "     ${fr_level}:[ info frame $fr_level]"
    #         set fr_level [ expr $fr_level - 1]
    # }

    # desde donde nos llaman
    # si es desde ttk --> no hacemos nada
    # si es desde cualquier otro lado --> hacemos parsing de nuestras variables
    set desdeTTK 0
    set fr_level [ info frame]
    while { $fr_level >= 0} {
        array set infoLvl [ info frame $fr_level]
        # if { ![ info exists infoLvl(proc)] } {
        #     WarnWinText "$fr_level - [ array get infoLvl]"
        # }
        if { [ info exists infoLvl(proc)] && [ regexp {.*::ttk::combobox.*} $infoLvl(proc)] } {
            set desdeTTK 1
            break
        }
        set fr_level [ expr $fr_level - 1]
        unset infoLvl
    }

    # set lst_opc [ list -labels -values -textvariable -modifycmd -commands -images]
    # set std_opc [ list -width -height -state -style -takefocus -text -image \
    #                       -compount -cursor -underline -direction -state]
    # if { [ lsearch $lst_opc $opc] != -1} {
    #         return $::TTKComboBoxOpciones($w,$opc)
    # } elseif { [ lsearch $std_opc $opc]} {
    #         return ${w}_original cget $opc
    # } else {
    #         error "Incorrect cget-option '$opc' for $w. should be one of '[ join $lst_opc]' or '[ join $std_opc]'"
    #         return {}
    # }

    if { !$desdeTTK} {
        # opciones a interceptar:
        set lst_opc [ list -labels -values -textvariable -modifycmd -commands -images]
        
        set cuantos [ llength $args]
        set ret {}
        if { $cuantos == 0} {
            # todos
            set ret [ ${w}_original cget]
            foreach opc $lst_opc {
                if { [ info exists ::TTKComboBoxOpciones($w,$opc)]} {
                    lappend ret [ list $opc $::TTKComboBoxOpciones($w,$opc)]
                }
            }
        } else {
            # solo hacemos caso al primero
            set opc [ lindex $args 0]
            if { [ info exists ::TTKComboBoxOpciones($w,$opc)]} {
                set ret $::TTKComboBoxOpciones($w,$opc)
            } else {
                set ret [ ${w}_original cget $opc]
            }
        }
    } else {
        set ret [ ${w}_original cget $args]
    }

    return $ret
}

# # solo trato los comandos configure y cget, el resto:
# foreach cmd [ list current get identify instate set state selection] {
#     proc TTKComboBox_${cmd} { w args } \
#         [ subst {return \[ eval \${w}_original ${cmd} \$args \]}]
# }

proc TTKCB_CreateOrConfigure { w} {
    if { [ winfo exists $w]} {
        return TTKComboBox_configure
    } else {
        return TTKComboBox
    }
}

# setTooltip para definir globos de ayuda, tb en los menus
# set Tooltip widget opciones
# opciones validas:
#   texto                        --> texto a aparecer
#   -text texto                  --> texto a apareces
#   -textvariable nombreVariable --> variable con la que el balon se actualizara ( para menus)
#   -delay user_delay_in_ms      --> to set the pop-up delay of the tooltip, default is 2000
#   -bottom widget               --> para que aparezca el tooltip en la parte de abajo de otro widget
# para el balon de los menus, se usa en conjuncion con el DynamicHelp de BWidget
# ejemplo con menus:
#
# menu .m -type menubar
# # associate menubar to toplevel BEFORE DynamicHelp::register
# # to make it works with menu clone name
# . configure -menu .m
# .m add cascade -label "File" -menu .m.file
# menu .m.file
# .m.file add command -label "Open..."
# .m.file add command -label "Quit"
#
# # la variable donde se guardara el texto de ayuda que toca
# set ::varinfo ""
# # associate all entries of menu .m.file to variable varinfo
# DynamicHelp::register .m.file menu ::varinfo
# # then declare entries of .m.file
# DynamicHelp::register .m.file menuentry 0 "Detach menu"
# DynamicHelp::register .m.file menuentry 1 "Open a file"
# DynamicHelp::register .m.file menuentry 2 "Exit demo"
# setTooltip .m.file -textvariable ::varinfo

proc setTooltip { lst_widgets args} {
    if { $args != "" } {
        # WarnWinText "setting tooltip: $widget - [ llength $args] = $args"
        set delay_ms 2000
        set parsedArgs {}
        set next_is_delay 0
        foreach ar $args {
            if { "$ar" == "-delay"} {
                set next_is_delay 1
                continue
            } elseif { $next_is_delay} {
                set delay_ms $ar
                set next_is_delay 0
                continue
            }
            lappend parsedArgs [ regsub -all {%} $ar {%%}]
        }
        foreach widget $lst_widgets {
            if { ![winfo exists $widget] } {
                WarnWinText "widget $widget not exists"
                continue
            }
            # 2) Adjusted timings and added key and button bindings. These seem to
            # make artifacts tolerably rare.
            bind $widget <Any-Enter>    [ list after $delay_ms [ list showTooltip %W $parsedArgs]]
            # bind $widget <Motion>       [ list after    0 [ list destroy %W.tooltip]]
            bind $widget <Any-Leave>    [ list after  500 [ list destroyTooltip %W.tooltip]]
            bind $widget <Any-KeyPress> [ list after  500 [ list destroyTooltip %W.tooltip]]
            bind $widget <Any-Button>   [ list after  500 [ list destroyTooltip %W.tooltip]]
            # after 2000 [ list showTooltip $widget $args]
        }
    }
}

proc destroyTooltip { widget} {
    catch { destroy $widget }
}

proc countDestroyTooltip { widget ms} {
    if { ![ info exists ::ToolTip(BottomDestroyCount)]} {
        set ::ToolTip(BottomDestroyCount) 0
    }
    if { $::ToolTip(BottomDestroyCount) > 0} {
            incr ::ToolTip(BottomDestroyCount) -1
    }
    if { $::ToolTip(BottomDestroyCount) == 0} {
        destroyTooltip $widget
    }
}

proc showTooltip { widget lst_args { force 0}} {
    global tcl_platform
    
    if { !$force && [GiD_Set TooltipPopup] == "disabled"} {
        return
    }
    if { ![winfo exists $widget] } {
        return
    }
    
    catch { destroy $widget.tooltip }
    # WarnWinText "showing tooltip: $widget - [ llength $lst_args] $lst_args"
    
    set border_color black
    # parsing de parametros:
    set varName ""
    set text ""
    set args $lst_args
    set widget_bottom ""
    if { [ llength $args] == 1} {
        set text [ lindex $args 0]
    } else {
        array set opciones $args
        # opciones validas:
        # -text texto
        # -textvariable variable_para_actualizar el contenido de la ayuda
        # -bottom widget --> para que aparezca el tooltip en la parte de abajo de otro widget
        if { [ info exists opciones(-text)] } {
            set text $opciones(-text)
        }
        if { [ info exists opciones(-textvariable)] } {
            set varName $opciones(-textvariable)
        }
        if { [ info exists opciones(-bottom)]} {
            # catch { destroy $::ToolTip(LastBottomTip)}
            set widget_bottom $opciones(-bottom)
        }
    }
    # fin parsing parametros

    if { $widget_bottom == "" && \
             [ string match $widget* [ winfo containing  [ winfo pointerx .] [ winfo pointery .]] ] == 0  } {
        # WarnWinText "string did not match: got '[ winfo containing  [ winfo pointerx .] [ winfo pointery .]]'"
        return
    }   
    
    # two modes: beside the actual widget or
    # at the bottom of another widget
    
    if { $widget_bottom == "" } {
        # beside the actual widget        
        set scrh [ winfo screenheight $widget]    ; # 1) flashing window fix
        set scrw [ winfo screenwidth $widget]     ; # 1) flashing window fix
        set tooltip [ toplevel $widget.tooltip -borderwidth 1 -background $border_color]
        wm geometry $tooltip +$scrh+$scrw        ; # 1) flashing window fix
        wm overrideredirect $tooltip 1
        
        if {$tcl_platform(platform) == {windows}} { ; # 3) wm attributes...
            wm attributes $tooltip -topmost 1   ; # 3) assumes...
        }                                           ; # 3) Windows
        
        # ttk::label does not support multiline texts
        if { $varName == ""} {            
            pack [ label $tooltip.label -text $text -justify left]
        } else {
            pack [ label $tooltip.label -textvariable $varName -justify left] -fill x
        }
        
        set width [ winfo reqwidth $tooltip.label]
        set height [ winfo reqheight $tooltip.label]
        
        set positionX [ winfo pointerx .]
        set positionY [ expr [ winfo pointery .] + 25]
        
        # a.) Ad-hockery: Set positionX so the entire tooltip widget will be displayed.
        set scr_width [ winfo screenwidth .]
        if { $positionX > $scr_width} {
            # may be dual monitor setup
            set n [ expr 1 + $positionX / $scr_width]
            set scr_width [ expr $n * [ winfo screenwidth .]]
        }
        if  {[ expr $positionX + $width] > $scr_width} {
            set positionX [ expr ($positionX - (($positionX + $width) - $scr_width))]
        }
        
        if { $varName == ""} {
            wm geometry $tooltip [ join  "$width x $height + $positionX + $positionY" {}]
        } else {
            wm maxsize $tooltip [ winfo screenwidth .] $height
            wm geometry $tooltip [ join  "+ $positionX + $positionY" {}]
        }
        raise $tooltip
        
        # 2) Kludge: defeat rare artifact by passing mouse over a tooltip to destroy it.
        bind $widget.tooltip <Any-Enter> {destroy %W}
        bind $widget.tooltip <Any-Leave> {destroy %W}
        
        bind $widget <Any-Leave>    [ list after  500 [ list destroy %W.tooltip]]
        bind $widget <Any-KeyPress> [ list after  500 [ list destroy %W.tooltip]]
        #bind $widget <Any-Button>   [ list after  500 [ list destroy %W.tooltip]]
        # despues de un momento matarlo:
        # after  3000 [ list destroy $tooltip]
        
    } else {
        
        if { ![ info exists ::ToolTip(BottomDestroyCount)]} {
            set ::ToolTip(BottomDestroyCount) 1
        } else {
            incr ::ToolTip(BottomDestroyCount)
        }
        
        # bottom of another widget:
             
        
        
        set scrh [ winfo screenheight $widget]    ; # 1) flashing window fix
        set scrw [ winfo screenwidth $widget]     ; # 1) flashing window fix
        if { ![ winfo exists $widget_bottom.tooltip]} {
            set tooltip [ toplevel $widget_bottom.tooltip -borderwidth 1 -background $border_color]
        } else {
            $widget_bottom.tooltip configure -borderwidth 1 -background $border_color
            set tooltip $widget_bottom.tooltip
        }
        wm geometry $tooltip +$scrh+$scrw        ; # 1) flashing window fix
        wm overrideredirect $tooltip 1
        
        if {$tcl_platform(platform) == {windows}} { ; # 3) wm attributes...
            wm attributes $tooltip -topmost 1   ; # 3) assumes...
        }                                           ; # 3) Windows
        
        if { $varName == ""} {
            # ttk::label does not support multiline texts really?
            if { ![ winfo exists $tooltip.label]} {
                pack [ label $tooltip.label -text $text -justify left]
            } else {
                $tooltip.label configure -text $text -justify left
            }
        } else {
            if { ![ winfo exists $tooltip.label]} {
                pack [ label $tooltip.label -textvariable $varName -justify left] \
                    -fill x
            } else {
                $tooltip.label configure -textvariable $varName -justify left
            }
        }
        
        set width [ winfo reqwidth $tooltip.label]
        set height [ winfo reqheight $tooltip.label]

        set positionX [ winfo rootx $widget_bottom]
             set positionY [ expr [ winfo rooty $widget_bottom] + [ winfo height $widget_bottom] - $height]
        if { $varName == ""} {
            wm geometry $tooltip [ join  "$width x $height + $positionX + $positionY" {}]
        } else {
            wm maxsize $tooltip [ winfo width $widget_bottom] $height
            wm geometry $tooltip [ join  "+ $positionX + $positionY" {}]
        }
        raise $tooltip

        # 2) Kludge: defeat rare artifact by passing mouse over a tooltip to destroy it.
        # bind $widget.tooltip <Any-Enter> {destroy %W}
        # bind $widget.tooltip <Any-Leave> {destroy %W}
        bind $tooltip <Any-Enter> {destroy %W}
        bind $tooltip <Any-Leave> {destroy %W}
        
        # bind $widget <Any-Leave>    [ list after  500 [ list destroy $tooltip]]
        # bind $widget <Any-KeyPress> [ list after  500 [ list destroy $tooltip]]
        bind $widget <Any-Leave>    [ list after 500 [ list countDestroyTooltip $tooltip 500]]
        bind $widget <Any-KeyPress> [ list after 500 [ list countDestroyTooltip $tooltip 500]]

        #bind $widget <Any-Button>   [ list after  500 [ list destroy %W.tooltip]]
        # despues de un momento matarlo:
        # after  3000 [ list destroy $tooltip]
    }
}

################################
# LabelButton:
# boton para poder definir un color. el boton cambia de color al seleccionar un color
# se implementa con un label, pues en mac no se pueden poner colores en los botones
################################

proc LabelButtonExecuteCommand { w} {
    if { $::LabelButtonOpciones($w,-state) != "disabled"} {
        if { $::LabelButtonOpciones($w,-command) != ""} {
            # eval $::LabelButtonOpciones($w,-command)
            uplevel $::LabelButtonOpciones($w,-command)
        }
    }
}

proc LabelButton_configure { w args} {
    if { $w == "."} {
        error ". can not be used as LabelButton."
        return $w
    }
    if { ![ winfo exists $w]} {
        error "LabelButton $w does not exist."
        return $w
    }
    array set opciones $args

    # opciones a interceptar:
    # -command - un label no tiene command, asi que...
    foreach opc [ list -state -command] {
        if { ![ info exists opciones($opc)]} {
            if { [ info exists ::LabelButtonOpciones($w,$opc)]} {
                set opciones($opc) $::LabelButtonOpciones($w,$opc)
            } else {
                set opciones($opc) ""
            }
        }
        set ::LabelButtonOpciones($w,$opc) $opciones($opc)
    }
    unset opciones(-command)
    if { $::LabelButtonOpciones($w,-state) == "" } {
        set opciones(-state) normal
        set ::LabelButtonOpciones($w,-state) normal
    }
    set restoOpciones [ array get opciones]

    eval ${w}_original configure $restoOpciones
}

proc LabelButton_cget { w args} {
    if { $w == "."} {
        error ". can not be used as LabelButton."
        return $w
    }
    if { ![ winfo exists $w]} {
        error "LabelButton $w does not exist."
        return $w
    }

    # opciones a interceptar:
    # -state
    # -command - un label no tiene command, asi que...
    set cuantos [ llength $args]
    set ret {}
    if { $cuantos == 0} {
        # todos
        set ret [ ${w}_original cget]
        foreach opc [ list -state -command] {
            if { [ info exists ::LabelButtonOpciones($w,$opc)]} {
                lappend ret [ list $opc $::LabelButtonOpciones($w,$opc)]
            }
        }
    } else {
        # solo hacemos caso al primero
        set opc [ lindex $args 0]
        if { [ info exists ::LabelButtonOpciones($w,$opc)]} {
            set ret [ list $opc $::LabelButtonOpciones($w,$opc)]
        } else {
            set ret [ ${w}_original cget $opc]
        }
    }

    return $ret
}

proc LabelButton { w args} {
    if { $w == "."} {
        error ". can not be used as Colorbutton."
        return $w
    }
    array set opciones $args

    # opciones a interceptar:
    # -state - necesito la definicion, pues lo uso
    # -command - un label no tiene command, asi que...
    foreach opc [ list -state -command] {
        if { ![ info exists opciones($opc)]} {
            set opciones($opc) ""
        }
        set ::LabelButtonOpciones($w,$opc) $opciones($opc)
    }
    unset opciones(-command)
    if { $::LabelButtonOpciones($w,-state) == "" } {
        set opciones(-state) normal
        set ::LabelButtonOpciones($w,-state) normal
    }
    set restoOpciones [ array get opciones]

    # set ::LabelButtonOpciones($w,ListaEtiquetas) $lst_lbl
    # set ::LabelButtonOpciones($w,ListaValores) $lst_val

    # ttk::label $w
    # we need to be label, as ttk does not allow to change its background colour !!!
    label $w

    bind $w <1> [ list LabelButtonExecuteCommand $w]

    eval $w configure $restoOpciones

    # set class LabelButton
    #
    # rename ${w} ${w}_original
    # proc ::$w { cmd args } \
    #         [ subst {return \[ eval \[ linsert \$args 0 ${class}_\$cmd [ list $w]\]\]}]
    #
    # bind $w <Destroy> [ list LabelButton_destroy $w]

    defineWidget LabelButton $w

    return $w
}

#returns the window name
proc CreateApplyCloseDecorationWindow { window top_frame but_frame apply_cmd close_cmd} {
    set def_back [ $window cget -background]
    set realzado [ CCColorActivo $def_back]
    
    ttk::frame $top_frame -style ridge.TFrame -borderwidth 2

    # bottom part: botones ok, cancel ..
    set def_back [ $window cget -background]

    # marco de los botones
    ttk::frame $but_frame -style BottomFrame.TFrame    

    ttk::button $but_frame.apply -text [ _ "Apply"] -command $apply_cmd -takefocus 0 \
        -style BottomFrame.TButton    
    ttk::button $but_frame.close -text [ _ "Close"] -command $close_cmd -takefocus 0 \
        -style BottomFrame.TButton   
    # help
    setTooltip $but_frame.apply -text [_ "Any change in the window will be applied."]
    setTooltip $but_frame.close -text [_ "Window will be closed and all changes not already applied will be disregarded."]   

    grid $but_frame.apply -sticky ews -padx 6 -pady 12
    grid $but_frame.close -sticky ews -padx 6 -pady 12 -row 0 -column 1

    #enpaquetamos marcos
    grid $top_frame -sticky news -padx 0 -pady 0
    grid $but_frame -sticky wes
    grid anchor $but_frame center

    grid columnconfigure $window 0 -weight 1
    grid rowconfigure $window 0 -weight 1

    focus $but_frame.apply
    bind $window <Return> "+$but_frame.apply invoke"
    bind $window <Escape> "focus $but_frame.close; $but_frame.close invoke"
    return $window
}

proc CreateApplyDefaultsCloseDecorationWindow { window top_frame but_frame apply_cmd defaults_cmd close_cmd} {
    set def_back [ $window cget -background]
    set realzado [ CCColorActivo $def_back]
    
    ttk::frame $top_frame -style ridge.TFrame -borderwidth 2

    # bottom part: botones ok, cancel ..
    set def_back [ $window cget -background]

    # marco de los botones
    ttk::frame $but_frame -style BottomFrame.TFrame    

    ttk::button $but_frame.apply -text [ _ "Apply"] -command $apply_cmd -takefocus 0 \
        -style BottomFrame.TButton    
    ttk::button $but_frame.defaults -text [ _ "Defaults"] -command $defaults_cmd -takefocus 0 \
        -style BottomFrame.TButton    
    ttk::button $but_frame.close -text [ _ "Close"] -command $close_cmd -takefocus 0 \
        -style BottomFrame.TButton   
    # help
    setTooltip $but_frame.apply -text [_ "Any change in the window will be applied."]
    setTooltip $but_frame.defaults -text [_ "Default values for the entries in window."]
    setTooltip $but_frame.close -text [_ "Window will be closed and all changes not already applied will be disregarded."]   

    grid $but_frame.apply -sticky ews -padx 6 -pady 12
    grid $but_frame.defaults -sticky ews -padx 6 -pady 12 -row 0 -column 1
    grid $but_frame.close -sticky ews -padx 6 -pady 12 -row 0 -column 2

    #enpaquetamos marcos
    grid $top_frame -sticky news -padx 0 -pady 0
    grid $but_frame -sticky wes
    grid anchor $but_frame center

    grid columnconfigure $window 0 -weight 1
    grid rowconfigure $window 0 -weight 1

    focus $but_frame.apply
    bind $window <Return> "+$but_frame.apply invoke"
    bind $window <Escape> "focus $but_frame.close; $but_frame.close invoke"
    return $window
}

proc _CDW_launch_binding { bt} {
    $bt configure -relief sunken
    update
    $bt invoke
    if { [ winfo exists $bt]} { 
        $bt configure -relief raised
    }
}

proc CreateDecorationWindow { window top_frame but_frame lst_button_labels lst_button_cmds lst_button_keys} {
    set def_back [ $window cget -background]
    set realzado [ CCColorActivo $def_back]
    
    ttk::frame $top_frame -style ridge.TFrame -borderwidth 2

    # bottom part: botones ok, cancel ..
    set def_back [ $window cget -background]

    # marco de los botones
    ttk::frame $but_frame -style BottomFrame.TFrame
    
    set num_but 0
    foreach lbl $lst_button_labels cmd $lst_button_cmds key $lst_button_keys {
        set bt $but_frame.but$num_but
        ttk::button $bt -text $lbl -command "$cmd" -takefocus 0 -style BottomFrame.TButton       
        grid $bt -sticky ews -padx 4 -pady 10 -row 0 -column $num_but
        if { "$key" != ""} {            
            bind $window $key "+$bt invoke"
        }
        incr num_but
    }
    
    #enpaquetamos marcos
    grid $top_frame -sticky news -padx 0 -pady 0
    grid $but_frame -sticky wes
    grid anchor $but_frame center
    
    grid columnconfigure $window 0 -weight 1
    grid rowconfigure $window 0 -weight 1
    
    focus $but_frame.but0
    return $window
}

########################
#   This procedure take account new panedwindow GidPriv(pwCentral) to manage several windows
########################
proc CloseInsideMainWindow { p } { 
    global GidPriv
    
    if { ![ winfo exists $p]} return
    
    #######
    # pwCentral is a panedwindow to manage $grWindow with other windows in GiD
    if { ![ info exists GidPriv(pwCentral)]} { 
        destroy $p
        return
    }
    #######

    bind $p <Configure> ""
    # Layers::WriteLayerGeomToVar $p NONE PostDisplayWindowGeom PostDisplay
    WritePostDisplayGeomToVar $p NONE PostDisplayWindowGeom PostDisplay

    if { [ winfo exists $::GidPriv(pwCentral)] } { 
        if { [ winfo class $::GidPriv(pwCentral)] in "Panedwindow TPanedwindow" } { 
            set panes [ $::GidPriv(pwCentral) panes]
            set _pos [ lsearch -exact $panes $p]
            if { $_pos >= 0} { 
                if { [ llength $panes] == 2 } { 
                    set oldwin [ lreplace $panes $_pos $_pos]
                    set mg [ winfo manager $::GidPriv(pwCentral)]
                    set mginfo [ $mg info $::GidPriv(pwCentral)]        
                    $::GidPriv(pwCentral) forget $p
                    $mg $oldwin {*}$mginfo
                    update idletask
                    destroy $::GidPriv(pwCentral)
                    unset GidPriv(pwCentral)
                }
            }
        }
    } else { 
        unset GidPriv(pwCentral)
    }
    destroy $p
}

########################
#   Procedure to open window inside, include creation of panedwindow to manage several windows
########################
proc OpenInsideMainWindow { w cmd { loc "RIGHT"}} { 
    global GidPriv
    
    if { [ winfo exists $w] } { 
        CloseInsideMainWindow $w
    }
    
    ##if { [ lsearch -exact { GEOMETRYUSE MESHUSE} [ GiD_Info Project ViewMode]] == -1 } { 
    ##        return
    ##}
    
    ttk::frame $w
    
    set focus [ focus]
    
    set grWindow [GidUtils::GetMainDrawAreaWidget]
    
    #######
    # pwCentral is a panedwindow to manage $grWindow with other windows in GiD
    if { ![ info exists GidPriv(pwCentral)]} { 
        set GidPriv(pwCentral) .gid.central.pwCentral
    }
    #######
        
        
    if { ![ winfo exists $::GidPriv(pwCentral)]} { 
        set mg [ winfo manager $grWindow]
        set mginfo [ $mg info $grWindow]        
        $mg forget $grWindow

        panedwindow $::GidPriv(pwCentral) -borderwidth 0 -showhandle 0 -sashpad 1 -sashrelief sunken -opaqueresize 0       
        #ttk::panedwindow $::GidPriv(pwCentral) -orient horizontal

        $mg $::GidPriv(pwCentral) {*}$mginfo
        
        if { $loc == "RIGHT"} { 
            $::GidPriv(pwCentral) add $grWindow -stretch always
            $::GidPriv(pwCentral) add $w -stretch never
        } else { 
            $::GidPriv(pwCentral) add $w -stretch never
            $::GidPriv(pwCentral) add $grWindow -stretch always
        }
        raise $grWindow
        if { $grWindow == ".gid.central.wins"} { 
            raise .gid.central.s
        }               
        
        update idletasks
        if { [info exists ::GidPriv(PostDisplayWindowGeom)] } {
            set w1 [lindex [split [lindex $::GidPriv(PostDisplayWindowGeom) 1] x] 0]
        } else {
            if { [winfo exists $w.body] } {
                set w1 [winfo reqwidth $w.body]
            } else {
                set w1 300
            }
        }
        set sepw 4
        
        if { $loc == "RIGHT"} { 
            set w0 [expr [winfo width $GidPriv(pwCentral)]-$w1-$sepw]
            if { $w0<=0 || $w1<=0 } {
                set w0 750
                set w1 300
            }
        } else {
            set w0 $w1
            if { $w0<=0 || $w1<=0 } {
                set w0 300
                set w1 750
            }
        }

        set wsash [expr [lsearch -exact [$GidPriv(pwCentral) panes] $w]-1]
        if {$wsash < 0} {
            set wsash 0
        }
        
        if { [winfo class $GidPriv(pwCentral)] == "Panedwindow" } {
            update idletasks
            $GidPriv(pwCentral) sash place $wsash $w0 0
        } elseif { [winfo class $GidPriv(pwCentral)] == "TPanedwindow" } {
            $GidPriv(pwCentral) sashpos $wsash $w0
        }
        
        
        bind $w <Configure> [list WritePostDisplayGeomToVar $w OPEN PostDisplayWindowGeom PostDisplay] 

        raise $w
    } else { 
        set panes [ $::GidPriv(pwCentral) panes]
        set maxpane [ expr [ llength $panes]-1]
        # Are there any window after grWindow?
        if { [ lsearch -exact $panes $grWindow] < $maxpane } {
            CloseInsideMainWindow $w          
            # Layers::ChangeLayers_New $w 0
            if { "$cmd" != ""} { 
                $cmd $w OUTSIDE
            }
        } else { 
            if { $loc == "RIGHT"} { 
                $::GidPriv(pwCentral) add $grWindow -stretch always
                $::GidPriv(pwCentral) add $w -stretch never                
            } else { 
                $::GidPriv(pwCentral) add $w $grWindow -stretch always
            }
            raise $grWindow
            
            if { $grWindow == ".gid.central.wins"} { 
                raise .gid.central.s
            }
                        
            update idletasks
            if { [info exists ::GidPriv(PostDisplayWindowGeom)] } {
                set w1 [lindex [split [lindex $::GidPriv(PostDisplayWindowGeom) 1] x] 0]
            } else {
                if { [winfo exists $w.body] } {
                    set w1 [winfo reqwidth $w.body]
                } else {
                    set w1 300
                }
            }
            set sepw 4
            
 
            if { $loc == "RIGHT"} { 
                set w0 [expr [winfo width $GidPriv(pwCentral)]-$w1-$sepw]
                if { $w0<=0 || $w1<=0 } {
                    set w0 750
                    set w1 300
                }
            } else {
                set w0 $w1
                if { $w0<=0 || $w1<=0 } {
                    set w0 300
                    set w1 750
                }
            }

            set wsash [expr [lsearch -exact [$GidPriv(pwCentral) panes] $w]-1]
            if {$wsash < 0} {
                set wsash 0
            }
        
            if { [winfo class $GidPriv(pwCentral)] == "Panedwindow" } {
                update idletasks
                $GidPriv(pwCentral) sash place $wsash $w0 0
            } elseif { [winfo class $GidPriv(pwCentral)] == "TPanedwindow" } {
                $GidPriv(pwCentral) sashpos $wsash $w0
            }

            bind $w <Configure> [list WritePostDisplayGeomToVar $w OPEN PostDisplayWindowGeom PostDisplay] 

            raise $w
        }
    }
    
    if { $focus ne "" } { 
        update
        catch { focus -force $focus }
    }
    return $w
}

########################################################################
# PostProgressBar numerator divisor ?title?
# to destroy it make numerator >= divisor
# if divisor < 0 --> progres bar with no end == bouncing progress bar
# to destroy it make divisor = 0
########################################################################

proc PostProgressBarDestroy { w} {
    if { [ winfo exists $w]} {
        destroy $w
        # focus $::PostProgressBar($w,Parent)
        # restore previous focus
        # if { $::PostProgressBar($w,PreviousFocus) != "" } {
        #     focus $::PostProgressBar($w,PreviousFocus)
        # }
    }
    set ::PostProgressBar($w,Updating) 0
}

proc PostProgressBarStop { w} {
    set ::PostProgressBar($w,Stop) 1
    set ::GidPriv(StopLoading) 1
    after 1000 [ list PostProgressBarDestroy $w]
}

proc PostProgressBarPlace { w { parent .gid}} {
    if { [ winfo exists $w]} {
        destroy $w
    }

    if { [ info exists ::GidPriv(ProgressBar,Inside)]} {
        # modified by ttk::checkbutton in progressbar
        GiD_Set ProgressBarInMainWindow $::GidPriv(ProgressBar,Inside)
    }

    set inside [GiD_Set ProgressBarInMainWindow]
    set mode determinate
    if { !$::PostProgressBar($w,HasEnd)} {
        set mode indeterminate
    }

    set pb_width 360
    set pb_height 48    
    if { $inside } {
        if { ![info exists ::GidPriv(CoordFrame)] || ![winfo exists $::GidPriv(CoordFrame)] } {
            #unexpected case, but it happened to a quantech client...
            GiD_Set ProgressBarInMainWindow 0
            return 1
        }
        set parent [ winfo parent $::GidPriv(CoordFrame)]
        ttk::frame $w -style groove.TFrame
        set pb_width [ expr [ winfo width $parent] - 32 - 36 * 8 * 2]
        set pb_height 24
    } else {
        toplevel $w
        wm title $w [ _ "Progress"]...
    }

    ttk::frame $w.flbl
    ttk::label $w.flbl.lbl1 -text "$::PostProgressBar($w,Message)" -width 30
    ttk::label $w.flbl.lbl2 -justify right -width 6
    grid $w.flbl.lbl1 $w.flbl.lbl2 -sticky new -padx 4 -pady 2
    grid configure $w.flbl.lbl2 -sticky ne
    grid rowconfigure $w.flbl 0 -weight 1
    grid columnconfigure $w.flbl 0 -weight 1
    
    ttk::progressbar $w.progressBar -mode $mode -length $pb_width
    
    ttk::frame $w.fbut -style BottomFrame.TFrame

    set ::GidPriv(ProgressBar,Inside) $inside
    ttk::checkbutton $w.fbut.inside -text [ _ "Inside"] -variable ::GidPriv(ProgressBar,Inside) \
        -command [list PostProgressBarPlace $w] -style BottomFrame.TCheckbutton
    ttk::button $w.fbut.stop -text [ _ "Stop"] -command [ list PostProgressBarStop $w] -style BottomFrame.TButton
    grid x $w.fbut.inside $w.fbut.stop x -pady 5
    grid columnconfigure $w.fbut 0 -weight 1
    grid columnconfigure $w.fbut 3 -weight 1

    # place window
    set main_width [ winfo width $parent]
    set main_height [ winfo height $parent]
    set main_x [ winfo x $parent]
    set main_y [ winfo y $parent]
         
    if { $inside } {
        grid $w.flbl $w.progressBar $w.fbut -padx 2 -pady 2
        grid configure $w.flbl -sticky e
        grid configure $w.progressBar -sticky ew
        grid configure $w.fbut -sticky w
        grid rowconfigure $w 0 -weight 1
        grid columnconfigure $w 1 -weight 1
        set pb_x [ expr int( 0.5 + 0.5 * ( $main_width - $pb_width))]
        set pb_y [ expr int( 0.5 + 0.5 * ( $main_height - $pb_height))]
        if { $pb_x < 0} { set pb_x 0}
        if { $pb_y < 0} { set pb_y 0}
        set frame_width [ expr [ winfo width $parent] - 4]
        if { [winfo class $parent] == "Toplevel" } {            
            #if .gid.comm is a external Toplevel then can't place -in because are different toplevels
            update
            set y [expr [winfo height [winfo toplevel $w]]-[winfo reqheight $w]-2]
            set frame_width [expr [winfo width [winfo toplevel $w]]-4]
            place $w -x 2 -y $y -width $frame_width
        } else {
            place $w -x 2 -y 2 -in $parent -width $frame_width
        }
    } else {
        grid $w.flbl -sticky new -padx 0 -pady 0
        grid $w.progressBar -sticky news -padx 4 -pady 5
        grid $w.fbut -sticky sew -padx 0 -pady 0

        grid anchor $w.fbut center

        grid rowconfigure $w 2 -weight 1
        grid columnconfigure $w 0 -weight 1
    
        set pb_x [ expr int( 0.5 + $main_x + 0.5 * ( $main_width - $pb_width))]
        set pb_y [ expr int( 0.5 + $main_y + 0.5 * ( $main_height - $pb_height))]
        if { $pb_x < 0} { set pb_x 100}
        if { $pb_y < 0} { set pb_y 100}
        # wm geometry $w ${pb_width}x${pb_height}+${pb_x}+${pb_y}
        wm geometry $w +${pb_x}+${pb_y}
    }
}

proc PostProgressBar { numerator divisor { message ""} { title ""} { parent .gid}} {
    set w $parent.___post_progress_bar___
    if { $parent == "."} {
        set w .___post_progress_bar___
    }

    if { [info exists ::PostProgressBar($w,Updating)] && [winfo exists $w] && $::PostProgressBar($w,Updating)} {
        return 0
    }
    set ::PostProgressBar($w,Updating) 1
    set ::PostProgressBar($w,Title) $title
    set ::PostProgressBar($w,Message) $message
    set ::PostProgressBar($w,Parent) $parent
    set ::PostProgressBar($w,PreviousFocus) [ focus]

    if { ![winfo exists $w]} {
        set ::PostProgressBar($w,Stop) 0
        set ::PostProgressBar($w,HasEnd) 1
        if { ( $numerator < 0) || ( $divisor <= 0)} {
            set ::PostProgressBar($w,HasEnd) 0
        }
        PostProgressBarPlace $w $parent
        update
        update idletasks
    }

    if { ![winfo exists $w] } {
        #do not return 1 because then it is considered as an user stop!!
        return 0
    }
    # update title
    if { $title != "" && ![GiD_Set ProgressBarInMainWindow] } {
        wm title $w $title
    }
    # update message
    if { $message != ""} {
        $w.flbl.lbl1 configure -text $message
    }

    # update bar
    $w.progressBar configure -maximum [expr abs($divisor)] -value [expr abs($numerator)]
    

    # update number
    if { $::PostProgressBar($w,HasEnd)} {
        if { $divisor != 0 } {
            set per_cent [ expr 0.1 * int( 1000 * abs( $numerator) / abs( $divisor))]
            set str_lbl2 [ format "%g %%" $per_cent]
            $w.flbl.lbl2 configure -text "$str_lbl2" -justify right
        }
    } else {
        if { $numerator != 0} {
            set per_cent [ expr 0.1 * int( 1000 * abs( $numerator) / 100.0)]
            set str_lbl2 [ format "%8g" $per_cent]
            $w.flbl.lbl2 configure -text "$str_lbl2" -justify right
        }
    }
    raise $w

    set destroy_win 0
    if { $divisor == 0 } {
        set destroy_win 1
    }
    if { ( $numerator >= 0) && ( $divisor >= 0) && ( $numerator >= $divisor)} {
        set destroy_win 1
    }
    if { $destroy_win} {
        after 1000 [ list PostProgressBarDestroy $w]
    }

    update 
    update idletasks

    set ::PostProgressBar($w,Updating) 0
    return $::PostProgressBar($w,Stop)
}

    
proc PostProgressBarTest {} {
    for { set i 0} { $i <= 100.1} { set i [ expr $i+0.1]} { 
        if { [ PostProgressBar $i 100.0 "Doing $i <--" "Testing..."] == 1} { 
            break
        }
        update
        update idletasks
        after 10
    }
}

proc PostProgressBarTest2 {} {
    for { set i 0} { $i <= 100.1} { set i [ expr $i+0.1]} { 
        if { [ PostProgressBar $i -20.0 "Doing $i <--" "Testing..."] == 1} { 
            break
        }
        update
        update idletasks
        after 10
    }
    PostProgressBar 0 0
}

proc AddImagePostCommandToMenu { menu sub_menu img cmd { st normal}} {
    if { $::tcl_platform(platform) == "windows"} {
        $menu add cascade -menu $sub_menu -label "   " -compound left -image $img -hidemargin 1 -state $st
    } else {
        $menu add cascade -menu $sub_menu -image $img -hidemargin 1 -state $st
    }
    if { ![ winfo exists $sub_menu]} {
        menu $sub_menu -tearoff no -postcommand $cmd
    } else {
        $sub_menu configure -postcommand $cmd
    }
}

proc AddImageSubmenu { w lst_images_var lst_commands_var { lst_help_var ""}} {
    upvar $lst_images_var lst_images
    upvar $lst_commands_var lst_commands
    upvar $lst_help_var lst_help
    if { ![info exists lst_help] } {
        set lst_help ""
    }
    $w delete 0 end

    set menuIdx 0
    set ::txtHelpSubMenu$w ""
    DynamicHelp::register $w menu ::txtHelpSubMenu$w

    foreach img $lst_images cmd $lst_commands hlp $lst_help {
        set has_sub_menu 0
        switch -- [ lindex $cmd 0] {
            "-np-" {
                set cmd [ lrange $cmd 1 end]
            }
            "-npm-" {
                set cmd [ lrange $cmd 1 end]
                set has_sub_menu 1
            }
            "-ne-" {
                set cmd "GiD_Process [ lrange $cmd 1 end]"
            }
            default {
                set cmd "GiD_Process escape escape escape escape escape $cmd"
                # set vareval "$comm{GiD_Process Mescape $command}"
            }
        }
        if { !$has_sub_menu} {
            regsub -all {%W} $cmd $w cmd
            regsub -all {%I} $cmd $menuIdx cmd
            AddImageCommandToMenu $w [ gid_themes::GetImage $img toolbar] $cmd normal
        } else {
            set sub_menu $w.sub_m$menuIdx
            regsub -all {%W} $cmd $sub_menu cmd
            regsub -all {%I} $cmd $menuIdx cmd
            AddImagePostCommandToMenu $w $sub_menu [ gid_themes::GetImage $img toolbar] $cmd normal
        }

        DynamicHelp::register $w menuentry $menuIdx $hlp
        incr menuIdx
    }

    # el balon de ayuda:
    if { [GiD_Set TooltipPopup] != "bottom"} {
        setTooltip $w -textvariable ::txtHelpSubMenu$w
    } else {
        setTooltip $w -textvariable ::txtHelpSubMenu$w -delay 0 -bottom .gid
    }

}

proc VisitWebButton { w link txt} {
    array set def_font [ font actual NormalFont]
    set def_font(-underline) 1
    set fsub [ eval font create [ array get def_font]]
    button $w -text $txt -command "VisitWeb $link" \
        -borderwidth 0 -font $fsub -fg $::GidPriv(WebLinkColour)
    $w configure -cursor hand2
    font delete $fsub
    return $w
}

########################################################################
### CheckNewVersion
########################################################################


set ::G_CheckNewVersion_debug 0

proc HostAvailable { remote_host { timeout 5}} {
    set host_found 0
    set output ""

    set opc_count "-c"
    set opc_wait "-w"
    if { $::tcl_platform(platform) == "windows" } {
        set opc_count "-n"
    }
    if { $::tcl_platform(os) == "Darwin" } {
        set opc_wait "-W"
    }

    set err_txt ""
    catch {
        set output [ exec ping $opc_count 1 $opc_wait $timeout $remote_host]
    } err_txt
    if { $output != ""} {
        if { [ string first "100%" $output] != -1} {
            # output is windows: ... (100% lost) linux: ... 100% packet loss
            set host_found 0
        } else {
            set host_found 1
        }
    }
    
    if { $::G_CheckNewVersion_debug } {
        WarnWinText "HostAvailable: ping returned output = -$output-"
        WarnWinText "HostAvailable: ping returned err_txt = -$err_txt-"
    }

    return $host_found
}

proc FormatS3bucketQuery { path2look prefix} {
    return "?prefix=[ file join $path2look $prefix]"
}

proc HttpGETQueryAndWait { url} {    
    set token [ http::geturl $url -method GET]
    http::wait $token
    upvar #0 $token state
    set httpcode [lindex [split $state(http) " "] 1]
    if { ( $httpcode == 200)} {
        set err 0
        set err_txt ""
        set ok [ array get state]
    } else {
        set err 1
        set err_txt "HTTP-Status $httpcode [ array get state]"
        set ok $err_txt
    }
    return -code $err -errorinfo $err_txt $ok
}

# returns: [ list ${server} ${gid_ftp_dir} ${prefix} ${extension} ${os2look}]
proc GetNewVersionUrlVariables { { new_server 1 } } {
    set actual_version [ GiD_Info GiDVersion]
    set is_developer_version 0
    set ver_txt Official
    set version_pattern {([0-9]+)[.]([0-9]+)[.]?([0-9]*)([a-z]?)(?:-beta([0-9]+))?}
    set devel_num ""
    regexp -nocase $version_pattern $actual_version dummy major minor patch devel_char devel_num

    set gid_base_dir GiD_Official_Versions
    if { ( [ info exists devel_char]) && ( $devel_char != "")} {
        set is_developer_version 1
        set gid_base_dir GiD_Developer_Versions
        set ver_txt Developer
    }

    if { $new_server} {
        # set server downloads.gidsimulation.com
        set server gidsimulation-downloads-pro.s3-eu-west-1.amazonaws.com
        set gid_ftp_dir $gid_base_dir
        # as it is done now, a folder can not be browsed:
        # i.e. this query:
        # https://downloads.gidsimulation.com/#GiD_Developer_Versions/Windows/win-x64/
        # will provide an error.
        # but this:
        # https://gidsimulation-downloads-pro.s3-eu-west-1.amazonaws.com/?prefix=GiD_Developer_Versions/Windows/win-x64/GiD
        # returns an XML like this:
        #     <?xml version="1.0" encoding="UTF-8"?>
        #     <ListBucketResult xmlns="http://s3.amazonaws.com/doc/2006-03-01/">
        #         <Name>gidsimulation-downloads-pro</Name>
        #         <Prefix>GiD_Developer_Versions/Windows/win-x64/GiD</Prefix>
        #         <KeyCount>1</KeyCount>
        #         <MaxKeys>1000</MaxKeys>
        #         <IsTruncated>false</IsTruncated>
        #         <Contents>
        #             <Key>GiD_Developer_Versions/Windows/win-x64/GiD15.1.5d-win-x64-Install.exe</Key>
        #             <LastModified>2022-03-22T07:26:57.000Z</LastModified>
        #             <ETag>&quot;94d0638db5eb4981c0fc4ad85c50a1d0-1&quot;</ETag>
        #             <Size>120833116</Size>
        #             <StorageClass>STANDARD</StorageClass>
        #         </Contents>
        #         <Contents>
        #             <Key>GiD_Developer_Versions/Windows/win-x64/GiD15.1.6d-win-x64-Install.exe</Key>
        #             <LastModified>2022-03-23T15:09:39.000Z</LastModified>
        #             <ETag>&quot;4883545e3cecbab47241e66f7f05aee3-1&quot;</ETag>
        #             <Size>120833116</Size>
        #             <StorageClass>STANDARD</StorageClass>
        #         </Contents>
        #     </ListBucketResult>
    } else {
        #old server
        set server www.gidhome.com
        set gid_ftp_dir [ file join ftp pub $gid_base_dir]
    }

    # append s.o. to dir and architecture
    set prefix GiD
    set extension exe
    # instead of using tcl_platform(machine) to guess if it's 32 o 64 bits
    # even in Mac OS X 10.7 is misleading, it says i386 but pointerSize is 8 !!
    # use pointerSize instead

    set os2look ""
    if { $::tcl_platform(platform) == "windows" } {
        if { $::tcl_platform(pointerSize) == 8 } {
            set gid_ftp_dir [ file join $gid_ftp_dir Windows win-x64]
        } else {
            set gid_ftp_dir [ file join $gid_ftp_dir Windows win-x32]
        }
        set prefix GiD
        set extension exe
    } elseif { $::tcl_platform(os) == "Linux" } {
        if { $::tcl_platform(pointerSize) == 8 } {
            set gid_ftp_dir [ file join $gid_ftp_dir Linux amd64]
        } else {
            set gid_ftp_dir [ file join $gid_ftp_dir Linux x86_32]
        }
        set prefix gid
        set extension tar.gz
    } elseif { $::tcl_platform(os) == "Darwin" } {
        if { $::tcl_platform(machine) == "Power Macintosh" || $::tcl_platform(pointerSize) == 4 } {
            set gid_ftp_dir [ file join $gid_ftp_dir MacOSX Leopard-x32]
        } else {
            if { $::tcl_platform(pointerSize) == 4 } {
                # for >= 10.7 only 64 bits are supported, at the moment
                return ""
            } else {
                # os = Darin
                # osVersion == 11.0.0 ... 11.4.2 == Mac OS X 10.7.5
                # osVersion == 13.0.0 ... 13.4.0 == Mac OS X 10.9.5
                # osVersion == 14.x == Mac OS X 10.10.x
                # osVersion == 15.x == Mac OS X 10.11.x
                # osVersion == 16.x == Mac OS X 10.12.x
                # osVersion == 17.x == Mac OS X 10.13.x High Sierra
                # osVersion == 18.x == Mac OS X 10.14.x Mojave
                # osVersion == 19.x == Mac OS X 10.15.x Catalina
                # osVersion == 20.x == Mac OS X 11.x.x Big Sur
                # osVersion == 21.x == Mac OS X 12.x.x Monterey
                set os_version [ split $::tcl_platform(osVersion) .]
                set mac_dir macos-x64
                set os2look "Monterey"
                if { [ lindex $os_version 0] <= 20  } {
                    set mac_dir Mavericks-x64
                    set os2look "Catalina"
                    if { [ lindex $os_version 0] <= 18  } {
                        set os2look "High%20Sierra"
                        if { [ lindex $os_version 0] < 17  } {
                            set os2look "Mavericks"
                            if { [ lindex $os_version 0] < 13  } {
                                set mac_dir Lion-x64
                                set os2look "Lion"
                            }
                        }
                    }
                }
                set gid_ftp_dir [ file join $gid_ftp_dir MacOSX $mac_dir]
            }
         }
        set prefix GiD-
        set extension dmg
    } else {
        return ""
    }

    # set server downloads.gidsimulation.com
    return [ list ${server} ${gid_ftp_dir} ${prefix} ${extension} ${os2look}]
}

proc CheckNewVersion { } {
    set new_server 1
    lassign [ GetNewVersionUrlVariables $new_server] server gid_ftp_dir prefix extension os2look

    set actual_version [ GiD_Info GiDVersion]
    set is_developer_version 0
    set ver_txt Official
    set version_pattern {([0-9]+)[.]([0-9]+)[.]?([0-9]*)([a-z]?)(?:-beta([0-9]+))?}
    set devel_num ""
    regexp -nocase $version_pattern $actual_version dummy major minor patch devel_char devel_num
    
    set filename ""
    # using https
    package require http
    package require tls

    if { $::G_CheckNewVersion_debug } {
        WarnWinText "CheckNewVersion: using HTTPS"
    }
    
    if { [info exists ::env(http_proxy)] || [info exists ::env(https_proxy)] } {
        package require autoproxy
        autoproxy::init
        # it seems that here -autoservername 1 option is not valid
        http::register https 443 [list autoproxy::tls_socket]
    } else {
        http::register https 443 [list ::tls::socket -autoservername 1]
    }

    # We only want to see it's contents:
    if { $new_server} {
        set check_url https://${server}/[ FormatS3bucketQuery ${gid_ftp_dir} ${prefix}]
    } else {
        set check_url https://${server}/${gid_ftp_dir}/
    }

    # WV check_url
    set err_txt --
    set contents_body ---
    set err [ catch {
        if { $new_server} {
            array set contents [ HttpGETQueryAndWait $check_url]
            set contents_body $contents(body)
        } else {
            set contents [ ::http::geturl $check_url]
            set contents_body [ set ${contents}(body)]
        }
    } err_txt]
    if { $err} {
        W "error:"
        WV "contents_body err_txt"
        return -1
    }
    if { $::G_CheckNewVersion_debug } {
        WV check_url
        W "CheckNewVersion: ::http::geturl $check_url " 
        W "               = [ ::http::geturl $check_url]" 
        W [array get contents]
        WV contents_body
        # W "BODY = [ set ${contents}(body)]"
        # WV contents_body
    }
    
    # Now search the body for the filename
    if { $::G_CheckNewVersion_debug } {
        W "   looking for a link (href) that matches '${prefix}.*${extension}'"
        foreach ln [ split $contents_body] {
            if { [ regexp .*href="(${prefix}.*${extension})">.* $ln dd filename] == 1} {
                W "   contents = $ln"
            }
        }
    }

    if { $new_server} {
        # contents_body is an xml document
        package require tdom
        set xmldoc [ dom parse $contents_body]
        # attribute: type
        # -namespaces {d DAV:}
        # set filename [ $xmldoc selectNodes -namespaces {xmlns http://s3.amazonaws.com/doc/2006-03-01/} {string(/ListBucketResult/Contents/Key)}]
        set lst_filenames {}
        foreach nod [ $xmldoc getElementsByTagName "Key"] {
            set name [ $nod text]
            if { ( $os2look == "") || ( [ string first $os2look $filename] != -1)} {
                lappend lst_filenames $name
                if { $::G_CheckNewVersion_debug } {
                    W "found: "
                    WV "os2look name"
                }
            }
        }
        # get the latest one
        set filename [ lindex [ lsort -dictionary $lst_filenames] end]
        if { $::G_CheckNewVersion_debug } {
            W "latest: "
            WV "os2look filename"
        }
    } else {
        # may be there are severals, get greater(latest) one
        set lst_filenames {}
        foreach ln [ split $contents_body] {
            if { [ regexp .*href="(${prefix}.*${extension})">.* $ln dd name] == 1} {
                if { ( $os2look == "") || ( [ string first $os2look $name] != -1)} {
                    lappend lst_filenames $name
                    if { $::G_CheckNewVersion_debug } {
                        W "found: "
                        WV "os2look name"
                    }
                    # break
                }
            }
        }
        set filename [ lindex [ lsort -dictionary $lst_filenames] end]
        if { $::G_CheckNewVersion_debug } {
            W "latest: "
            WV "os2look filename"
        }
    }

    # May be
    # ::http::unregister https
    

    if { $filename == ""} {
        # nothing found
        # return ""
        if { $::G_CheckNewVersion_debug } {
            WarnWinText "CheckNewVersion: nothing found"
        }
        return -1
    }

    if { $::tcl_platform(os) == "Darwin" } {
        set file_version_pattern {[gG][iI][dD]-([0-9]+)[.]([0-9]+)[.]?([0-9]*)([a-z]?)(?:-beta([0-9]+))?.+}
    } else {
        set file_version_pattern {[gG][iI][dD]([0-9]+)[.]([0-9]+)[.]?([0-9]*)([a-z]?)(?:-beta([0-9]+))?.+}
    }
    set file_devel_num ""
    regexp -nocase $file_version_pattern $filename dummy file_major file_minor file_patch file_devel_char file_devel_num
    set is_new 0
    if { ( $file_major > $major)} {
        set is_new 1
    } elseif { ( $file_major == $major) && ( $file_minor > $minor)} {
        set is_new 1
    } elseif { ( $file_major == $major) && ( $file_minor == $minor) && ( $file_patch > $patch)} {
        set is_new 1
    } elseif { ( $file_major == $major) && ( $file_minor == $minor) && ( $file_patch == $patch)} {
        if { $is_developer_version} {
            if { ( $file_devel_char > $devel_char)} {
                set is_new 1
            } elseif { ( $file_devel_char == $devel_char) && ( "$file_devel_num" > "$devel_num")} {
                set is_new 1
            }
        }
    }
    if { $::G_CheckNewVersion_debug } {
        WarnWinText "CheckNewVersion: file_version_pattern = $file_version_pattern"
        WarnWinText "CheckNewVersion: file = ( $file_major - $file_minor - $file_patch - $file_devel_char)"
        WarnWinText "CheckNewVersion: current = ( $major - $minor - $patch - $devel_char)"
    }

    set res ""
    if { $is_new} {
        set res ${file_major}.${file_minor}.${file_patch}
        if { $is_developer_version} {
            append res ${file_devel_char}${file_devel_num}
        }
    }

    if { $::G_CheckNewVersion_debug } {
        WarnWinText "CheckNewVersion: returning -$res-"
    }
    return $res
}

proc ShowCheckNewVersion { { show_tip 0} { wParent .gid}} { 
    if { [GidUtils::AreWindowsDisabled] } {
        return
    }     
    set actual_version [ GiD_Info GiDVersion]
    set ver_txt Official
    set version_pattern {([0-9]+)[.]([0-9]+)[.]?([0-9]*)([a-z]?)(?:-beta([0-9]+))?}
    set devel_num ""
    regexp -nocase $version_pattern $actual_version dummy major minor patch devel_char devel_num
    if { ( [ info exists devel_char]) && ( $devel_char != "")} {
        set ver_txt Developer
    }

    set res [ CheckNewVersion]
    set msg ""
    set show_link 0
    if { $res == -1} {
        # no need to display message, too anoying sometimes
        # for instance on systems for users who can not install new versions
        if { $::G_CheckNewVersion_debug } {
            set txt1 [_ "Problems while checking updates"].
            set txt2 [_ "Could not connect to server"]
            set msg "$txt1 $txt2"
        }
    } elseif { $res != ""} {
        set msg [ format [_ "New %s version %s is available for download." $ver_txt $res]]
        set show_link 1
    } else {
        if { $show_tip} {
            set msg [_ "This version is up to date."]
        }
    }

    if { $msg != ""} {
        if { $show_tip && [winfo exists $wParent] } {
            # showTooltip $wParent [ list -text $msg -bottom $wParent] 1
            # after 5000 "destroyTooltip ${wParent}.tooltip"
            # PopupTransparentInfo $msg [ expr $wx - 100] [ expr $wy - 8] $wParent $show_link
            set wx [ winfo rootx $wParent]
            if { $::tcl_platform(platform) == "windows" } {
                set wy [ expr [ winfo rooty $wParent] + [ winfo height $wParent] - 26]
            } else {
                set wy [ expr [ winfo rooty $wParent] + [ winfo height $wParent] - 40]
            }
            PopupTransparentInfo $msg $wx $wy $wParent $show_link
        } else {
            GidUtils::SetWarnLine $msg
        }
    }
}

proc TransparentEffect { w what factor step} {
    if { ![ winfo exists $w]} {
        return
    }
    wm attributes $w -alpha $factor
    update
    if { $what == "FADE_IN"} {
        set next [ expr $factor + $step]
        if { $next <= 1.0} {
            after 150 "TransparentEffect $w $what $next $step"
        }
    } elseif { $what == "FADE_OUT"} {
        set next [ expr $factor - $step]
        if { $next >= 0.0} {
            after 150 "TransparentEffect $w $what $next $step"
        } else {
            destroy $w
        }
    }
}

proc PopupTransparentInfo { msg wx wy { wParent .gid} { show_link 1} {destroytime 5000} } {
    #destroytime can be -1 = no destroy

    if { $wx < 0} {
        set wx 0
    }
    if { $wy < 0} {
        set wy 0
    }
    set w ${wParent}.transpTip
    if { $wParent == "."} {
        set w .transpTip
    }
    if { [ winfo exists $w]} {
        destroy $w
    }
    set transp_effect 0
    
    toplevel $w
    wm overrideredirect $w 1
    if { ( $::tcl_platform(platform) == "windows") || ( $::tcl_platform(os) == "Darwin") } {
        set transp_effect 1
        wm attributes $w -alpha 0.0
    }
    # topmost forbidden
    # wm attributes $w -topmost 1
    GidUtils::WindowAboveGid $w
    set border_color black
    frame $w.f -borderwidth 0 -background $border_color
    frame $w.f.f    
    label $w.f.f.i -image [ gid_themes::GetImage info.png small_icons] \
        -borderwidth 0
    label $w.f.f.m -text $msg -justify left\
        -borderwidth 0
    button $w.f.f.c -image [ gid_themes::GetImage close17.png ] -command "destroy $w" \
        -borderwidth 0
    if { $show_link} {
        VisitWebButton $w.f.f.www $::GidPriv(WebDownload) [_ "download"]
        grid $w.f.f.i $w.f.f.m $w.f.f.www $w.f.f.c -sticky n -padx 4 -pady 2
    } else {
        grid $w.f.f.i $w.f.f.m $w.f.f.c -sticky n -padx 4 -pady 2
    }
    grid $w.f.f -padx 1 -pady 1
    grid $w.f

    wm geometry $w +${wx}+${wy}
    raise $w
    if { $transp_effect} {
        after 100 "TransparentEffect $w FADE_IN 0.0 0.2"
        if { $destroytime!= "-1" } {
            after $destroytime "TransparentEffect $w FADE_OUT 1.0 0.1"
        }
    } else {
        if { $destroytime!= "-1" } {
            after 5000 "if { [ winfo exists $w]} { destroy $w}"
        }
    }
}

proc PopupCheckNewVersion { wx wy { wParent .gid}} {
    set actual_version [ GiD_Info GiDVersion]
    set ver_txt Official
    set version_pattern {([0-9]+)[.]([0-9]+)[.]?([0-9]*)([a-z]?)(?:-beta([0-9]+))?}
    set devel_num ""
    regexp -nocase $version_pattern $actual_version dummy major minor patch devel_char devel_num
    if { [ info exists devel_char] } {
        set ver_txt Developer
    }
    set res [ CheckNewVersion]
    set msg ""
    set show_link 0
    if { $res == -1} {
        # no need to display message, too anoying sometimes
        # for instance on systems for users who can not install new versions
        if { $::G_CheckNewVersion_debug } {
            set txt1 [_ "Problems while checking updates"].
            set txt2 [_ "Could not connect to server"]
            set msg "$txt1 $txt2"
        }
    } elseif { $res != ""} {
        set msg [ format [_ "New %s version %s is available for download." $ver_txt $res]]
        set show_link 1
    } else {
        set msg [_ "This version is up to date."]
    }

    if { $msg != ""} {
        PopupTransparentInfo $msg [ expr $wx - 100] [ expr $wy - 8] $wParent $show_link
    }
}

proc PrintToPdfScreen { filename } {
    package require pdf4tcl
    package require Tk ;#for image
   
    set page_dim [GiD_Info postprocess get pagedimensions]
    # en pulgadas: PS_PAGE_X, PS_PAGE_Y, PS_TAM_X, PS_TAM_Y, PS_TAM_W, PS_TAM_H, landscape/portrait  
    set pagewidth [ expr [ lindex $page_dim 0] * 25.4]
    set pageheight [ expr [ lindex $page_dim 1] * 25.4]
    set leftmargin [ expr [ lindex $page_dim 2] * 25.4]
    set topmargin [ expr [ lindex $page_dim 3] * 25.4]
    set imgwidth [ expr [ lindex $page_dim 4] * 25.4]
    set imgheight [ expr [ lindex $page_dim 5] * 25.4]
    set orientation [ lindex $page_dim 6]
    set landscape 0
    if { $orientation == "landscape"} {
        set landscape 1
        set pagewidth [ expr [ lindex $page_dim 1] * 25.4]
        set pageheight [ expr [ lindex $page_dim 0] * 25.4]
        set leftmargin [ expr [ lindex $page_dim 3] * 25.4]
        set topmargin [ expr [ lindex $page_dim 2] * 25.4]
        set imgwidth [ expr [ lindex $page_dim 5] * 25.4]
        set imgheight [ expr [ lindex $page_dim 4] * 25.4]
    }
    # check limits
    catch {
        PageFillDefaults
    }
    
    pdf4tcl::new mypdf -paper a4 -margin 0 -orient true -landscape $landscape

    if { 0 } {
        #pass the image through a temporary file in png format
        set tmp_dir [GiD_Info project TmpDirectory]    
        set img_tmp_file [file join $tmp_dir __mypdf_png.png]
        GidUtils::Disable warnline  
        GiD_Process Mescape view hardcopy png $img_tmp_file
        GidUtils::Enable warnline    
        set img_id [mypdf addImage $img_tmp_file]
        file delete $img_tmp_file
    }

    lassign [GiD_Thumbnail get_pixels -format png] w h data
    set img [image create photo -data $data]

    # check dimensions for aspect
    set total_width [ expr $imgwidth + $leftmargin + $::PageSetup(DefaultMarginRight)]
    set total_height [ expr $imgheight + $topmargin + $::PageSetup(DefaultMarginBottom)]
    set fix_width 1
    if { $total_height > $::PageSetup(DefaultPageHeight)} {
        set fix_width 0
    }
    if { $fix_width} {
        #mypdf putImage $img_id ${leftmargin}mm ${topmargin}mm -width ${imgwidth}mm
        mypdf putRawImage [$img data] ${leftmargin}mm ${topmargin}mm -width ${imgwidth}mm        
    } else {
        #mypdf putImage $img_id ${leftmargin}mm ${topmargin}mm -height ${imgheight}mm
        mypdf putRawImage [$img data] ${leftmargin}mm ${topmargin}mm -height ${imgheight}mm        
    }
    if { [ file exists $filename]} {
        file delete $filename
    }
    mypdf write -file $filename
    mypdf destroy
    return 0
}

proc BrowserExtraCreateTakeSnapshot { f} {
    ttk::checkbutton $f.snapshotVectorial -text [_ "Vectorial output for EPS, PS or PDF formats"] \
        -variable ::Snapshot(vectorial) -onvalue 1 -offvalue 0
    setTooltip $f.snapshotVectorial \
        [_ "Vectorial output somehow translates graphical primitives\
\ninto drawing primitives of the target format,\
\nproviding resolution independent graphics with \
\nbetter quality than screen images at the expense\
\nof a greater file size."]
    grid $f.snapshotVectorial -sticky ws
    # variable to set state of open/close options frame
    return ::Snapshot(dir)
}

proc BrowserExtraGetTakeSnapshot { } {
    # now is not used, variable has already been set
    #set options [list -vectorial:$::Snapshot(vectorial) --]
    set options [list ]
    return $options
}

proc TakeSnapshot { } {
    if { ![ info exists ::Snapshot(vectorial)]} {
        set ::Snapshot(vectorial) 0
    }
    # variable to set state of open/close options frame
    if { ![ info exists ::Snapshot(dir)]} {
        # set ::Snapshot(dir) "close"
        #trick to show the more options
        set ::Snapshot(dir) "open"
    }
    set lst_formats [list PNG JPEG GIF TIFF TGA BMP VRML EPS PS PDF SVG PGF]
    set lst_extensions [list .png .jpg .gif .tif .tga .bmp .vrml .eps .ps .pdf .svg .pgf]
    set lst_helps_txts [list \
                            [_ "PNG images"] \
                            [_ "JPG images"] \
                            [_ "GIF images"] \
                            [_ "TIF images"] \
                            [_ "TarGA images"] \
                            [_ "MS Windows Bitmaps"] \
                            [_ "VRML models"] \
                            [_ "Encapsulated PostScript files"] \
                            [_ "PostScript files"] \
                            [_ "PDF files"] \
                            [_ "Scalable Vector Graphics files"] \
                            [_ "PGF Latex Graphics"]]   
    
    if { ![ info exists ::OpenGLInfo]} {
        array set ::OpenGLInfo [ GiD_Info opengl]
    }
    set page_dim [ GiD_Info postprocess get pagedimensions]
    # en pulgadas: PS_PAGE_X, PS_PAGE_Y, PS_TAM_X, PS_TAM_Y, PS_TAM_W, PS_TAM_H, landscape/portrait, resolution
    set resol [ lindex $page_dim 7]
    if { ![GiD_Set SoftwareOpenGL] && ( $resol != "Screen") && \
             ( [ string first "intel" [ string tolower $::OpenGLInfo(Renderer)]] != -1)} {
        set wid [ CreateWarnWinId [_ "Please, make sure no window is over the graphical view."]]
        WarnWin [_ "Please, make sure no window is over the graphical view."] . $wid
    }

    set default_filename "Snapshot.png"
    set default_extension .png
    if { [ info exists ::Snapshot(LastFileName)]} {
        set default_filename [GidUtils::AddNumberToFile $::Snapshot(LastFileName)]
        set default_extension [file extension $default_filename]
        if { $default_extension == "" } {
            set default_extension .png
        }
    }
    #put default_extension filter first, because MessageBoxGetFilename doesn't care about default extension
    set lst_filters {}
    foreach ext $lst_extensions txt $lst_helps_txts {
        if { $ext == $default_extension} {
            lappend lst_filters [ list $txt $ext]
            break
        }
    }
    # the other ones:
    foreach ext $lst_extensions txt $lst_helps_txts {
        if { $ext != $default_extension} {
            lappend lst_filters [ list $txt $ext]
        }
    }
    lappend lst_filters [ list [_ "All files"] ".*"]
    set multiple 0
    set more_opts [ list [_ "Snapshot options"] BrowserExtraCreateTakeSnapshot BrowserExtraGetTakeSnapshot]
    set filename [ MessageBoxGetFilename imagefile write [_ "Write snapshot"] \
                       $default_filename $lst_filters {} \
                       $multiple $more_opts]
    if { $filename == ""} {
        return
    }
    
    set selected_filter $::gidtk::dialog::file::__tk_filedialog(filter)
    #warning: selected_filter sometimes return something like "PNG images (*.png)" and sometimes "*.png" !!
    if { [regexp {[(](.*)[)]} $selected_filter dummy selected_extension] } {
        #e.g: "PNG images (*.png)" -> *.png
        #e.g: *.png -> remove * and set lowercase -> .png
        set selected_extension [string tolower [file extension $selected_extension]]
    } elseif { [string index $selected_filter 0] == "*" }  {
        #e.g: *.png -> remove * and set lowercase 
        set selected_extension [string tolower [file extension $selected_filter]]
    } else {
        set selected_extension ""
    }    
    set file_extension [string tolower [file extension $filename]]
    if { $file_extension != $selected_extension && $selected_extension != "" && $selected_extension != ".*" } {
        set filename [file rootname $filename]$selected_extension
        set file_extension $selected_extension
    }
    
    set idx_ext [lsearch -exact $lst_extensions $selected_extension]
    if { $idx_ext == -1 } {
        WarnWin [_ "Unknown extension '%s'" $selected_extension]
    } else {
        set format [lindex $lst_formats $idx_ext]
        set is_vectorial 0
        if { $format == "EPS" || $format == "PS" || $format == "PDF"} {
            #could be vectorial or pixmap, select depending on the checkbox variable
            if { $::Snapshot(vectorial)} {
                set answer_vectorial Yes
                set is_vectorial 1
            } else {
                set answer_vectorial No
            }
            GiD_Process 'Hardcopy Options VectorialPS $answer_vectorial Escape
        }
        if { $format == "SVG" || $format == "PGF" } {
            #could be only vectorial, not pixmap
            set is_vectorial 1
        }  
        set cmd [list 'Hardcopy $format]
        if { $is_vectorial && [GiD_Set OpenGL(ContourFillTexture)] } {
            set answer_allow_temporary_mode_change Yes ;#do not ask user
            lappend cmd $answer_allow_temporary_mode_change
        }
        lappend cmd $filename
        if { ![GiD_Set DialogWrowser] } {
            if { [file exists $filename] } {
                set answer_overwrite Yes ;#don't ask again, already asked by Browser-ramR
                lappend cmd $answer_overwrite
            }
        }
        GiD_Process {*}$cmd
        set ::Snapshot(LastFileName) $filename   
    }
}

