
#---------------------------------------------------------------
# Line Size Options
#---------------------------------------------------------------

proc FillPostStreamLineOptionsWInfo { } {
    global PStLinePriv GidPriv

    if { $PStLinePriv(AvoidUpdate) } { return }

    set w $GidPriv(PostStreamLineOptionsWindow)
    set info [ GiD_Info postprocess get $PStLinePriv(StLineTamInfoCMD)]

    $w.f1.s configure -state normal
    $w.f1.e configure -state normal

    set mi_valor [ lindex $info 0]
    set opciones [ lindex $info 1]
    set PStLinePriv(MinNice) [ lindex $opciones 0]
    set PStLinePriv(MaxNice) [ lindex $opciones 1]
    set PStLinePriv(StepNice) [ lindex $opciones 2]
    set PStLinePriv(DefaultValue) [ lindex $opciones 3]
    set PStLinePriv(MinQuick) -1.00000001
    set PStLinePriv(MaxQuick) -0.99999999
    set PStLinePriv(StepQuick) 1.0

    set info [ GiD_Info postprocess get $PStLinePriv(StLineTipoInfoCMD)]
    set PStLinePriv(TypeValue) [ lindex $info 0]
    set opciones [ lindex $info 1]
    set idx [ lsearch $opciones "4SidedPrism"]
    if { $idx != -1} {
	set PStLinePriv(DefaultTypeValue) [ lindex $opciones $idx]
    } else {
	set PStLinePriv(DefaultTypeValue) [ lindex $opciones 0]
    }

    if { $mi_valor < 0.0} {
	set PStLinePriv(Detail) Quick
	set PStLinePriv(Size) -1.0
    } else {
	set PStLinePriv(Detail) Nice
	set PStLinePriv(Size) $mi_valor
    }

    set PStLinePriv(ColourType) [ lindex $info 2]
    set opciones [ lindex $info 3]
    set idx [ lsearch $opciones "Monochrome"]
    if { $idx != -1} {
	set PStLinePriv(DefaultColourType) [ lindex $opciones $idx]
    } else {
	set PStLinePriv(DefaultColourType) [ lindex $opciones 0]
    }

    # el color de la stream linea
    set PStLinePriv(Colour) [ lindex $info 4]
    set PStLinePriv(DefaultColour) \#608f30
    $w.f4.stcol configure -background $PStLinePriv(Colour)

    # el giro inicial de la linea
    set PStLinePriv(GiroInicial) [ lindex $info 5]
    set PStLinePriv(MinGiroInicial) -90.0
    set PStLinePriv(MaxGiroInicial) 90.0
    set PStLinePriv(StepGiroInicial) 0.5
    set PStLinePriv(DefaultGiroInicial) 0.0

    # flechas
    set arrows_info [ GiD_Info postprocess get stream_draw_arrows Arrows]
    set arrows_info [lindex $arrows_info 0]
    set PStLinePriv(Arrows) [lindex $arrows_info 0]

    set color_info [ GiD_Info postprocess get stream_draw_arrows ArrowsColor]
    set color_info [lindex $color_info 0]
    set PStLinePriv(ArrowsColor) [lindex $color_info 0]

    set size_info [ GiD_Info postprocess get stream_draw_arrows ArrowsSize]
    set size_info [lindex $size_info 0]
    set PStLinePriv(ArrowsSize) [lindex $size_info 0]

    set freq_info [ GiD_Info postprocess get stream_draw_arrows ArrowsFreq]
    set freq_info [lindex $freq_info 0]
    set PStLinePriv(ArrowsFreq) [lindex $freq_info 0]

    UpdateColor

    set PStLinePriv(OldDetail) $PStLinePriv(Detail)
    foreach v {ColourType Colour GiroInicial Size TypeValue Arrows ArrowsColor ArrowsSize ArrowsFreq} {
	set PStLinePriv(Old$v) $PStLinePriv($v)
	set PStLinePriv(Acc$v) $PStLinePriv($v)
    }

    $w.f1.s configure -from $PStLinePriv(Min$PStLinePriv(Detail)) -to $PStLinePriv(Max$PStLinePriv(Detail)) -resolution $PStLinePriv(Step$PStLinePriv(Detail))
    $w.f1.s set $PStLinePriv(Size)

    $w.f5.s configure -from $PStLinePriv(MinGiroInicial) -to $PStLinePriv(MaxGiroInicial) \
	-resolution $PStLinePriv(StepGiroInicial)
    $w.f5.s set $PStLinePriv(GiroInicial)

    # (des)habilitamos el detalle
    if { $PStLinePriv(Size) <= 0.0} {
	$w.f2.rd1 configure -state disabled
	$w.f2.rd2 configure -state disabled
	$w.f2.rd3 configure -state disabled
	$w.f2 state disabled
	# deshabilitamos las opciones de las flechas
	$w.f6.arrows configure -state disabled
	$w.f6.color configure -state disabled
	$w.f6.size configure -state disabled
	$w.f6.entry configure -state disabled
	$w.f6.scale configure -state disabled
	$w.f6.color configure -background #ffffff
	if { $PStLinePriv(Size) < 0.0} {
	    # deshabilitamos la escala
	    #$w.f1.l configure -state disabled
	    $w.f1 state disabled
	    $w.f1.l configure -state disabled
	    $w.f1.e configure -state disabled
	    $w.f1.s configure -state disabled
	}
    } else {
	$w.f2.rd1 configure -state normal
	$w.f2.rd2 configure -state normal
	$w.f2.rd3 configure -state normal
	$w.f2 state !disabled
	# habilitamos la escala
	#$w.f1.l configure -foreground black
	$w.f1 state !disabled
	$w.f1.l configure -foreground black
	$w.f1.e configure -state normal
	$w.f1.s configure -state normal
	# habilitamos las opciones de las flechas
	$w.f6.arrows configure -state normal
	#$w.f6.color configure -state normal
	$w.f6.size configure -state normal
	$w.f6.entry configure -state normal
	$w.f6.scale configure -state normal
    }

    if { $PStLinePriv(ColourType) eq "StreamContourFilled"} {
	$w.f6.color configure -state disabled
	$w.f6.color configure -background #ffffff
    } else {
	#$w.f6.color configure -state normal
	#$w.f6.color configure -background $PStLinePriv(ArrowsColor)
    }
}

proc PostStreamLineAccept { } {
    global PStLinePriv
    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1
    if { $PStLinePriv(TypeValue) != $PStLinePriv(AccTypeValue)} {
	GiD_Process Mescape Results Options $PStLinePriv(StLineTypeCMD) $PStLinePriv(TypeValue)
	set PStLinePriv(AccSize) $PStLinePriv(TypeValue)
    }
    if { $PStLinePriv(ColourType) != $PStLinePriv(AccColourType)} {
	GiD_Process Mescape Results Options $PStLinePriv(StLineColourCMD) $PStLinePriv(ColourType)
	set PStLinePriv(AccColourType) $PStLinePriv(ColourType)
    }
    if { $PStLinePriv(Colour) != $PStLinePriv(AccColour)} {
	GiD_Process Mescape Results Options StreamColor ChangeMonoColour $PStLinePriv(Colour)
	set PStLinePriv(AccColour) $PStLinePriv(Colour)
    }
    if { $PStLinePriv(Size) != $PStLinePriv(AccSize)} {
	GiD_Process Mescape Results Options $PStLinePriv(StLineSizeCMD) $PStLinePriv(Size)
	set PStLinePriv(AccSize) $PStLinePriv(Size)
    }
    if { $PStLinePriv(GiroInicial) != $PStLinePriv(AccGiroInicial)} {
	GiD_Process Mescape Results Options $PStLinePriv(StLineGiroInicialCMD) $PStLinePriv(GiroInicial)
	set PStLinePriv(AccGiroInicial) $PStLinePriv(GiroInicial)
    }
    if { $PStLinePriv(Arrows) != $PStLinePriv(AccArrows)} {
	if {$PStLinePriv(Arrows) eq "1" } {
	    GiD_Process Mescape Results Options StDrawArrow ShowArrows Yes
	} else {
	    GiD_Process Mescape Results Options StDrawArrow ShowArrows No
	}
	set PStLinePriv(AccArrows) $PStLinePriv(Arrows)
    }
    if { $PStLinePriv(ArrowsColor) != $PStLinePriv(AccArrowsColor)} {
	GiD_Process escape escape escape escape Results Options StDrawArrow Color $PStLinePriv(ArrowsColor)
	set PStLinePriv(AccArrowsColor) $PStLinePriv(ArrowsColor)
    }
    if { $PStLinePriv(ArrowsSize) != $PStLinePriv(AccArrowsSize)} {
	GiD_Process escape escape escape escape Results Options StDrawArrow Size $PStLinePriv(ArrowsSize)
	set PStLinePriv(AccArrowsSize) $PStLinePriv(ArrowsSize)
    }
    if { $PStLinePriv(ArrowsFreq) != $PStLinePriv(AccArrowsFreq)} {
	GiD_Process escape escape escape escape Results Options StDrawArrow Frequency $PStLinePriv(ArrowsFreq)
	set PStLinePriv(AccArrowsFreq) $PStLinePriv(ArrowsFreq)
    }
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    set old $PStLinePriv(DynamicUpdate)
    set PStLinePriv(DynamicUpdate) 0
    FillPostStreamLineOptionsWInfo
    set PStLinePriv(DynamicUpdate) $old
    GiD_Redraw   
}

proc PostStreamLineOriginal { } {
    global PStLinePriv
    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1
    GiD_Process Mescape Results Options $PStLinePriv(StLineTypeCMD) $PStLinePriv(DefaultTypeValue)
    GiD_Process Mescape Results Options $PStLinePriv(StLineSizeCMD) $PStLinePriv(DefaultValue)
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Process Mescape Results Options StDrawArrow Reset
    GiD_Redraw   
    set old $PStLinePriv(DynamicUpdate)
    set PStLinePriv(DynamicUpdate) 0
    FillPostStreamLineOptionsWInfo
    set PStLinePriv(DynamicUpdate) $old
}

proc ChangeStreamLineSizeScale { nuevo_tamanno} { #{ name1 name2 op}
    global PStLinePriv GidPriv

    if { $PStLinePriv(Size) == $PStLinePriv(OldSize)} { return}

    set w $GidPriv(PostStreamLineOptionsWindow)

    set newval $PStLinePriv(Size)

    if { ![IsWord real $newval $w " In line size field"] } {
	$w.f1.e sel range 0 end
	set PStLinePriv(Size) $PStLinePriv(OldSize)
	return error
    }

    if { ( $newval < $PStLinePriv(Min$PStLinePriv(Detail))) || \
	     ( $newval > $PStLinePriv(Max$PStLinePriv(Detail))) } {
        WarnWin [_ "Value %1\$s out of limits ( must be between %2\$s and %3\$s in steps of %4\$s)" \
            $newval $PStLinePriv(Min$PStLinePriv(Detail)) \
            $PStLinePriv(Max$PStLinePriv(Detail)) $PStLinePriv(Step$PStLinePriv(Detail))]
        $w.f1.e sel range 0 end
        set PStLinePriv(Size) $PStLinePriv(OldSize)
        return error
    }

    set pp [ expr ($newval - $PStLinePriv(Min$PStLinePriv(Detail))) / $PStLinePriv(Step$PStLinePriv(Detail))]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
        WarnWin [_ "Value not %1\$s %2\$s correct ( must be between %3\$s and %4\$s in steps of %5\$s)" \
            $pp $ppi $PStLinePriv(Min$PStLinePriv(Detail)) \
            $PStLinePriv(Max$PStLinePriv(Detail)) $PStLinePriv(Step$PStLinePriv(Detail))]
        $w.f1.e sel range 0 end

        set PStLinePriv(Size) $PStLinePriv(OldSize)
        return error
    }

    set PStLinePriv(OldSize) $PStLinePriv(Size)

    if { $PStLinePriv(OldSize) <= 0.0} {
	$w.f2.rd1 configure -state disabled
	$w.f2.rd2 configure -state disabled
	$w.f2.rd3 configure -state disabled
	$w.f2 state disabled
	# deshabilitamos las opciones de las flechas
	$w.f6.arrows configure -state disabled
	$w.f6.color configure -state disabled
	$w.f6.size configure -state disabled
	$w.f6.entry configure -state disabled
	$w.f6.scale configure -state disabled
	$w.f6.color configure -background #ffffff
    } else {
	$w.f2.rd1 configure -state normal
	$w.f2.rd2 configure -state normal
	$w.f2.rd3 configure -state normal
	$w.f2 state !disabled
	# habilitamos las opciones de las flechas
	$w.f6.arrows configure -state normal
	$w.f6.color configure -state normal
	$w.f6.size configure -state normal
	$w.f6.entry configure -state normal
	$w.f6.scale configure -state normal
	$w.f6.color configure -background $PStLinePriv(ArrowsColor)
    }

    if { $PStLinePriv(ColourType) eq "StreamContourFilled"} {
	$w.f6.color configure -state disabled
	$w.f6.color configure -background #ffffff
    }

    #set PStLinePriv(Size) $newval

    # if { $PStLinePriv(Size) != [$w.f1.s get ] } {
    #           $w.f1.s set $PStLinePriv(Size)
    # }
    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeStreamLineGiroInicial { nuevo_tamanno} {
    global PStLinePriv GidPriv

    if { $PStLinePriv(GiroInicial) == $PStLinePriv(OldGiroInicial)} { return}

    set w $GidPriv(PostStreamLineOptionsWindow)

    set newval $PStLinePriv(GiroInicial)

    if { ![IsWord real $newval $w " In line size field"] } {
	$w.f1.e sel range 0 end
	set PStLinePriv(GiroInicial) $PStLinePriv(OldGiroInicial)
	return error
    }

    if { ( $newval < $PStLinePriv(MinGiroInicial)) || \
	     ( $newval > $PStLinePriv(MaxGiroInicial)) } {
        WarnWin [_ "Value %1\$s out of limits ( must be between %2\$s and %3\$s in steps of %4\$s)" \
            $newval $PStLinePriv(MinGiroInicial) \
            $PStLinePriv(MaxGiroInicial) $PStLinePriv(StepGiroInicial)]
        $w.f1.e sel range 0 end
        set PStLinePriv(GiroInicial) $PStLinePriv(OldGiroInicial)
        return error
    }

    set pp [ expr ($newval - $PStLinePriv(MinGiroInicial)) / $PStLinePriv(StepGiroInicial)]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
        WarnWin [_ "Value not %1\$s %2\$s correct ( must be between %3\$s and %4\$s in steps of %5\$s)" \
            $pp $ppi $PStLinePriv(MinGiroInicial) \
            $PStLinePriv(MaxGiroInicial) $PStLinePriv(StepGiroInicial)]
        $w.f1.e sel range 0 end

        set PStLinePriv(GiroInicial) $PStLinePriv(OldGiroInicial)
        return error
    }

    set PStLinePriv(OldGiroInicial) $PStLinePriv(GiroInicial)

    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeStreamLineTypeValue { } { #{ name1 name2 op}
    global PStLinePriv GidPriv

    if { $PStLinePriv(TypeValue) == $PStLinePriv(OldTypeValue)} { return}

    set PStLinePriv(OldSize) $PStLinePriv(Size)

    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeStreamLineColourType { } {
    global PStLinePriv GidPriv

    if { $PStLinePriv(ColourType) == $PStLinePriv(OldColourType)} { return}

    set PStLinePriv(OldColourType) $PStLinePriv(ColourType)

    if { $PStLinePriv(ColourType) == "StreamContourFilled"} {
	$PStLinePriv(labelcol) configure -state disabled
	$PStLinePriv(labelcol) configure -background #ffffff
    } else {
	$PStLinePriv(labelcol) configure -state normal
	$PStLinePriv(labelcol) configure -background $PStLinePriv(ArrowsColor)
    }

    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeStreamLineColour { w} {
    global PStLinePriv GidPriv

    CCCambiaColor $w ::PStLinePriv(Colour)
    if { $PStLinePriv(Colour) == $PStLinePriv(OldColour)} { return}
    set PStLinePriv(OldColour) $PStLinePriv(Colour)
    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeStreamLineArrowsColor { w} {
    global PStLinePriv GidPriv

    CCCambiaColor $w ::PStLinePriv(ArrowsColor)
    if { $PStLinePriv(ArrowsColor) == $PStLinePriv(OldColour)} { return}
    set PStLinePriv(OldColour) $PStLinePriv(ArrowsColor)
    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc SelectColor {} {
    global PStLinePriv GidPriv
    set base #ffffff

    set color [ GIDChooseColor $PStLinePriv(mainwin).selcolor -title [_ "Choose stream arrows color"]]
    set PStLinePriv(ArrowsColor) $color
    $PStLinePriv(labelcol) configure -background $color -foreground $base

}

proc UpdateColor {args} {
    global PStLinePriv GidPriv
    set base #ffffff

    set color $PStLinePriv(ArrowsColor)
    $PStLinePriv(labelcol) configure -background $color -foreground $base
    if { $::PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}

}

proc ChangeArrowsSizeScale { nuevo_tamanno } {
    global PStLinePriv GidPriv

    if { $::PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeArrows { } {
    global PStLinePriv GidPriv

    if { $PStLinePriv(Arrows) == $PStLinePriv(OldArrows)} { return}
    set PStLinePriv(OldArrows) $PStLinePriv(Arrows)
    if { $PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}
}

proc ChangeStreamLineDetail { } { #{ n1 n2 op}
    global PStLinePriv GidPriv

    if { $PStLinePriv(Detail) == $PStLinePriv(OldDetail)} { return}

    set PStLinePriv(OldDetail) $PStLinePriv(Detail)

    if { "$PStLinePriv(Detail)" == "Quick" } {
	if { $PStLinePriv(Size) > 0.0} {
	    set PStLinePriv(LastNiceValue) $PStLinePriv(Size)
	} else {
	    set PStLinePriv(LastNiceValue) $PStLinePriv(DefaultValue)
	}
    }

    set w $GidPriv(PostStreamLineOptionsWindow)

    $w.f1.s configure -from $PStLinePriv(Min$PStLinePriv(Detail)) -to $PStLinePriv(Max$PStLinePriv(Detail)) -resolution $PStLinePriv(Step$PStLinePriv(Detail))

    if { "$PStLinePriv(Detail)" == "Nice" } {
	#$w.f1.l configure -foreground black
	$w.f1 state !disabled
	$w.f1.l configure -foreground black
	$w.f1.e configure -state normal
	$w.f1.s configure -state normal
	set PStLinePriv(Size) $PStLinePriv(LastNiceValue)
	$w.f6.arrows configure -state normal
	$w.f6.color configure -state normal
	$w.f6.size configure -state normal
	$w.f6.entry configure -state normal
	$w.f6.scale configure -state normal
	$w.f6.color configure -background $PStLinePriv(ArrowsColor)
    } elseif { "$PStLinePriv(Detail)" == "Quick" } {
	#$w.f1.l configure -state disabled
	$w.f1 state disabled
	$w.f1.l configure -state disabled
	$w.f1.e configure -state disabled
	$w.f1.s configure -state disabled
	set PStLinePriv(Size) -1.0
	$w.f6.arrows configure -state disabled
	$w.f6.color configure -state disabled
	$w.f6.size configure -state disabled
	$w.f6.entry configure -state disabled
	$w.f6.scale configure -state disabled
	$w.f6.color configure -background #ffffff
    }
    $w.f1.s set $PStLinePriv(Size)
    #ChangeStreamLineTypeValue PlinePriv Value w
}

proc PostStreamLineOptions { { w .gid.wPostStreamLineOptions } } {
    global PStLinePriv

    InitWindow2 $w -title [_ "Stream line options"] \
        -geometryvariable PostStreamLineOptionsWindowGeom \
        -initcommand PostStreamLineOptions -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set PStLinePriv(mainwin) $w

    set PStLinePriv(DynamicUpdate) 0

    set PStLinePriv(Colour) \#608f30

    set PStLinePriv(StLineSizeCMD) StLineSize
    set PStLinePriv(StLineTypeCMD) StLineType
    set PStLinePriv(StLineGiroInicialCMD) StLineIniRotation
    set PStLinePriv(StLineColourCMD) StreamColor
    set PStLinePriv(StLineTamInfoCMD) info_stream_line_size
    set PStLinePriv(StLineTipoInfoCMD) result_stream_lines_options
    # catch {
    #         trace vdelete PStLinePriv(Size) w ChangeStreamLineSizeScale
    #         trace vdelete PStLinePriv(TypeValue) w ChangeStreamLineTypeValue
    #         trace vdelete PStLinePriv(Detail) w ChangeStreamLineDetail
    # }

    ttk::labelframe $w.f1 -text [_ "Size"]
    #ttk::frame $w.f1 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f1.l -text [_ "Stream Size"]:
    ttk::entry $w.f1.e -textvariable PStLinePriv(Size) -width 5   
    #bind $w.f1.e <Return> { ChangePerspective $PerspPriv(Distance) }
    if { ![info exists PStLinePriv(Size)] } {
	set PStLinePriv(Size) 0
    }
    gidscale $w.f1.s -orient horizontal -showvalue 0 \
	-variable PStLinePriv(Size) -command ChangeStreamLineSizeScale

    grid $w.f1.l -sticky ew -row 0 -column 0
    grid $w.f1.e -sticky ew -row 0 -column 1
    grid $w.f1.s -sticky ew -row 0 -column 2
    grid columnconfigure $w.f1 3 -weight 1

    ttk::labelframe $w.f2 -text [_ "Type"]
    #ttk::frame $w.f2 -style ridge.TFrame -borderwidth 2
    #ttk::label $w.f2.l -text [_ "Type of stream"]

    # [_ "8 sided prisms"]
    # "Points", "Ribbons", "4SidedPrism", "8SidedPrism",
    #grid $w.f2.l -sticky w -padx 2
    set names "Points Ribbons 4SidedPrism"
    set namesLabel [ list [_ "points"] [_ "ribbons"] [_ "4 sided prisms"]]
    foreach i {1 2 3} j $namesLabel k $names {
	ttk::radiobutton $w.f2.rd$i -text $j -value $k \
	    -variable PStLinePriv(TypeValue) -command ChangeStreamLineTypeValue
	#grid $w.f2.rd$i -sticky w -padx 2
    }
    grid $w.f2.rd1 -sticky ew -row 0 -column 0
    grid $w.f2.rd2 -sticky ew -row 0 -column 1
    grid $w.f2.rd3 -sticky ew -row 0 -column 2
    grid columnconfigure $w.f2 3 -weight 1

    ttk::labelframe $w.f3 -text [_ "Quality"]
    ttk::radiobutton $w.f3.rd1 -text [_ "Quick"] -value Quick \
	-variable PStLinePriv(Detail) -command ChangeStreamLineDetail
    ttk::radiobutton $w.f3.rd2 -text [_ "Nice"] -value Nice \
	-variable PStLinePriv(Detail) -command ChangeStreamLineDetail


    grid $w.f3.rd1 -sticky es -padx 0 -pady 3
    grid $w.f3.rd2 -sticky ws -padx 0 -pady 3 -row 0 -column 1
    #grid $w.f3.din -sticky ws -padx 3 -pady 3 -row 0 -column 2
    #grid $w.f3.rd1 $w.f3.rd2 $w.f3.din -sticky ws -padx 3 -pady 3 -columnspan 2

    ttk::labelframe $w.f4 -text [_ "Color"]
    set names "Monochrome StreamContourFilled ResultContourFilled"
    set namesLabel [ list [_ "Monochrome"] [_ "Stream contour filled"] [_ "Result contour filled"]]
    foreach i { 1 2 3} j $namesLabel k $names f {0 0 0} c {0 2 3} {
	ttk::radiobutton $w.f4.rd$i -text $j -value $k \
	    -variable PStLinePriv(ColourType) -command ChangeStreamLineColourType
	
    }
    grid $w.f4.rd1 -sticky w -row 0 -column 0
    grid $w.f4.rd2 -sticky w -row 0 -column 2
    grid $w.f4.rd3 -sticky w -row 0 -column 3

    
    if { $::tcl_platform(os) != "Darwin"} {
	tk::button $w.f4.stcol -width 3 -background $::PStLinePriv(Colour) \
	    -command "ChangeStreamLineColour $w.f4.stcol"
    } else {
	LabelButton $w.f4.stcol -width 3 -borderwidth 1 -background $::PStLinePriv(Colour) \
	    -command "ChangeStreamLineColour $w.f4.stcol"
    }

    grid $w.f4.stcol -sticky w -row 0 -column 1
    
    grid columnconfigure $w.f4 4 -weight 1

    # giro inicial para las cintas

    #ttk::frame $w.f5 -style ridge.TFrame -borderwidth 2
    ttk::labelframe $w.f5 -text [_ "Swirl"]
    ttk::label $w.f5.l -text [_ "Initial swirl"]:
    ttk::entry $w.f5.e -textvariable PStLinePriv(GiroInicial) -width 5   
    if { ![info exists PStLinePriv(GiroInicial)] } {
	set PStLinePriv(GiroInicial) 0
    }
    gidscale $w.f5.s -orient horizontal -showvalue 0 \
	-variable PStLinePriv(GiroInicial) -command ChangeStreamLineGiroInicial

    grid $w.f5.l -sticky w -row 1 -column 0
    grid $w.f5.e -sticky ew -row 1 -column 1
    grid $w.f5.s -sticky ew -row 1 -column 2
    grid columnconfigure $w.f5 3 -weight 1



    #ttk::frame $w.f6 -style ridge.TFrame -borderwidth 2
    ttk::labelframe $w.f6 -text [_ "Arrows"]
    trace remove variable PStLinePriv(ArrowsColor) write "UpdateColor"
    if { ![info exists PStLinePriv(Arrows)] } { set PStLinePriv(Arrows) "0" }
    ttk::checkbutton $w.f6.arrows -text [_ "Show Arrows"] -variable PStLinePriv(Arrows) -onvalue "1" -offvalue "0" -command ChangeArrows
    
    ttk::label $w.f6.colorlabel -text [_ "Color"]:
    tk::button $w.f6.color -width 3 -command "SelectColor"
    set PStLinePriv(labelcol) $w.f6.color

    ttk::label $w.f6.size -text [_ "Size"]:
    ttk::entry $w.f6.entry -textvariable PStLinePriv(ArrowsSize) -width 5 
    if { ![info exists PStLinePriv(ArrowsSize)] } {
	set PStLinePriv(ArrowsSize) 0
    }
    gidscale $w.f6.scale  -from 1 -to 100 -showvalue 0  -orient horizontal -variable PStLinePriv(ArrowsSize) -command ChangeArrowsSizeScale

    ttk::label $w.f6.freq -text [_ "Spacing"]:
    ttk::entry $w.f6.freqent -textvariable PStLinePriv(ArrowsFreq) -width 5  
    if { ![info exists PStLinePriv(ArrowsFreq)] } {
	set PStLinePriv(ArrowsFreq) 0
    }
    gidscale $w.f6.freqsc  -from 1 -to 100 -showvalue 0  -orient horizontal -variable PStLinePriv(ArrowsFreq) -command ChangeArrowsSizeScale

    trace add variable PStLinePriv(ArrowsColor) write "UpdateColor"

    grid $w.f6.arrows -sticky w -row 0   
    grid $w.f6.colorlabel $w.f6.color -sticky w -row 1  
    #grid $w.f6.color -sticky w -row 1 -column 1
    grid $w.f6.size $w.f6.entry $w.f6.scale -sticky w -row 2  
    #grid $w.f6.entry -sticky ew -row 2 -column 1
    #grid $w.f6.scale -sticky ew -row 2 -column 2
    
    grid $w.f6.freq $w.f6.freqent $w.f6.freqsc -sticky w -row 3    
    #grid $w.f6.freqent -sticky ew -row 3 -column 1
    #grid $w.f6.freqsc -sticky ew -row 3 -column 2
    
    #grid columnconfigure $w.f6 0 -weight 1
    #grid columnconfigure $w.f6 1 -weight 1
    #grid columnconfigure $w.f6 2 -weight 1
    #grid columnconfigure $w.f6 3 -weight 1

    
    ttk::frame $w.f7
    if { ![info exists PStLinePriv(DynamicUpdate)] } { set PStLinePriv(DynamicUpdate) 0 }
    ttk::checkbutton $w.f7.din -text [_ "Dynamic update"] \
	-variable PStLinePriv(DynamicUpdate) \
	-command { if { $::PStLinePriv(DynamicUpdate) } { PostStreamLineAccept}}
    
    grid $w.f7.din -sticky w -row 0 


    ttk::frame $w.but -style BottomFrame.TFrame
    ttk::button $w.but.accept -text [_ "Apply"] -style BottomFrame.TButton -command PostStreamLineAccept 
    ttk::button $w.but.original -text [_ "Reset"] -style BottomFrame.TButton -command PostStreamLineOriginal 
    ttk::button $w.but.close -text [_ "Close"] -style BottomFrame.TButton -command "destroy $w" 

    grid $w.but.accept $w.but.original $w.but.close -padx 4 -pady 2
    #grid $w.but.original -padx 4 -pady 2 -sticky ew
    #grid $w.but.close -padx 4 -pady 2 -sticky ew

    ## grid $w.f1 $w.f2 -sticky nsew -padx 3 -pady 3
    ## grid $w.f3 -sticky ws -padx 3 -pady 3 -columnspan 2
    ## grid $w.but -sticky nsew -column 2 -row 0 -rowspan 2 -padx 3 -pady 3
    ## grid anchor $w.but center
    ## grid columnconfigure $w 0 -weight 1
    ## #grid columnconfigure $w 1 -weight 1
    ## grid rowconfigure $w 0 -weight 1

    grid $w.f3 -sticky nsew -column 0 -row 0 -padx 2 -pady 3
    grid $w.f2 -sticky nsew -column 0 -row 1  -padx 2 -pady 3
    
    grid $w.f1 -sticky nsew -column 0 -row 2  -padx 2 -pady 3
    

    grid $w.f4 -sticky nsew -column 0 -row 3  -padx 2 -pady 3
    
    grid $w.f5 -sticky nsew -column 0 -row 4  -padx 2 -pady 3
    grid $w.f6 -sticky nsew -column 0 -row 5  -padx 2 -pady 3
    grid $w.f7 -sticky nsew -column 0 -row 6  -padx 2 -pady 3
    
    
    #grid $w.f5 -sticky w -padx 3 -pady 2 -columnspan 3
    grid $w.but -sticky nsew -column 0 -row 8 
    grid anchor $w.but center
    grid columnconfigure $w 0 -weight 1
    #grid columnconfigure $w 2 -weight 1
    #grid columnconfigure $w 1 -weight 1
    grid rowconfigure $w 7 -weight 1

    set PStLinePriv(AvoidUpdate) 0

    FillPostStreamLineOptionsWInfo
    if { $PStLinePriv(Size) < 0.0} {
	set PStLinePriv(LastNiceValue) $PStLinePriv(DefaultValue)
    } else {
	set PStLinePriv(LastNiceValue) $PStLinePriv(Size)
    }

    # trace variable PStLinePriv(Size) w ChangeStreamLineSizeScale
    # trace variable PStLinePriv(TypeValue) w ChangeStreamLineTypeValue
    # trace variable PStLinePriv(Detail) w ChangeStreamLineDetail

    focus $w.but.accept   
}
