
#---------------------------------------------------------------
# Line Size Options
#---------------------------------------------------------------

proc FillPostLineOptionsWInfo { } {
    global PLinePriv GidPriv

    if { $PLinePriv(AvoidUpdate) } { return }

    set w $GidPriv(PostLineOptionsWindow)
    set info [ GiD_Info postprocess get $PLinePriv(LineInfoCMD)]

    $w.f1.s configure -state normal
    $w.f1.e configure -state normal

    set mi_valor [ lindex $info 0]
    set opciones [ lindex $info 1]
    set PLinePriv(MinNice) [ lindex $opciones 0]
    set PLinePriv(MaxNice) [ lindex $opciones 1]
    set PLinePriv(StepNice) [ lindex $opciones 2]
    set PLinePriv(DefaultValue) [ lindex $opciones 3]
    set PLinePriv(MinQuick) -1.00000001
    set PLinePriv(MaxQuick) -0.99999999
    set PLinePriv(StepQuick) 1.0

    set PLinePriv(DetailValue) [ lindex $info 2]
    set opciones [ lindex $info 3]
    set PLinePriv(DefaultDetailValue) [ lindex $opciones 3]

    if { $mi_valor < 0.0} {
        set PLinePriv(Detail) Quick
        set PLinePriv(Value) -1.0
    } else {
        set PLinePriv(Detail) Nice
        set PLinePriv(Value) $mi_valor
    }

    set PLinePriv(OldDetail) $PLinePriv(Detail)
    set PLinePriv(OldValue) $PLinePriv(Value)
    set PLinePriv(AccValue) $PLinePriv(Value)
    set PLinePriv(OldDetailValue) $PLinePriv(DetailValue)
    set PLinePriv(AccDetailValue) $PLinePriv(DetailValue)

    $w.f1.s configure -from $PLinePriv(Min$PLinePriv(Detail)) -to $PLinePriv(Max$PLinePriv(Detail)) -resolution $PLinePriv(Step$PLinePriv(Detail))
    $w.f1.s set $PLinePriv(Value)


    # (des)habilitamos el detalle
    if { $PLinePriv(Value) <= 0.0} {
        $w.f2.rd1 configure -state disabled
        $w.f2.rd2 configure -state disabled
        if { $PLinePriv(Value) < 0.0} {
            # deshabilitamos la escala
            $w.f1.l configure
            $w.f1.e configure -state disabled
            $w.f1.s configure -state disabled
        }
    } else {
        $w.f2.rd1 configure -state normal
        $w.f2.rd2 configure -state normal
        # habilitamos la escala
        $w.f1.e configure -state normal
        $w.f1.s configure -state normal
    }
}

proc PostLineAccept { } {
    global PLinePriv
    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw
    if { $PLinePriv(DetailValue) != $PLinePriv(AccDetailValue)} {
        GiD_Process Mescape Results Options $PLinePriv(LineDetailCMD) $PLinePriv(DetailValue)
        set PLinePriv(AccValue) $PLinePriv(DetailValue)
    }
    if { $PLinePriv(Value) != $PLinePriv(AccValue)} {
        GiD_Process Mescape Results Options $PLinePriv(LineSizeCMD) $PLinePriv(Value)
        set PLinePriv(AccValue) $PLinePriv(Value)
    }
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    set old $PLinePriv(DynamicUpdate)
    set PLinePriv(DynamicUpdate) 0
    FillPostLineOptionsWInfo
    set PLinePriv(DynamicUpdate) $old        
    GiD_Redraw    
}

proc PostLineOriginal { } {
    global PLinePriv
    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1
    GiD_Process Mescape Results Options $PLinePriv(LineDetailCMD) $PLinePriv(DefaultDetailValue)
    GiD_Process Mescape Results Options $PLinePriv(LineSizeCMD) $PLinePriv(DefaultValue)
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw
    set old $PLinePriv(DynamicUpdate)
    set PLinePriv(DynamicUpdate) 0
    FillPostLineOptionsWInfo
    set PLinePriv(DynamicUpdate) $old
}

proc ChangeLineSizeScale { name1 name2 op} {
    global PLinePriv GidPriv

    if { $PLinePriv(Value) == $PLinePriv(OldValue)} { return}

    set w $GidPriv(PostLineOptionsWindow)

    set newval $PLinePriv(Value)

    if { $newval == ""} { return}

    if { ![string is double $newval] } {
        ErrorWin [_ "One number must be entered"]
        $w.f1.e sel range 0 end
        set PLinePriv(Value) $PLinePriv(OldValue)
        return error
    }

    if { ( $newval < $PLinePriv(Min$PLinePriv(Detail))) || ( $newval > $PLinePriv(Max$PLinePriv(Detail))) } {
        ErrorWin [_ "Value %1\$s out of limits ( must be between %2\$s and %3\$s in steps of %4\$s)" \
                 $newval $PLinePriv(Min$PLinePriv(Detail)) \
                 $PLinePriv(Max$PLinePriv(Detail)) $PLinePriv(Step$PLinePriv(Detail))]
        $w.f1.e selection range 0 end
        set PLinePriv(Value) $PLinePriv(OldValue)
        return error
    }

    set pp [ expr ($newval - $PLinePriv(Min$PLinePriv(Detail))) / $PLinePriv(Step$PLinePriv(Detail))]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
        ErrorWin [_ "Value %s not correct (must be between %s and %s in steps of %s)" \
                $newval $PLinePriv(Min$PLinePriv(Detail)) \
                $PLinePriv(Max$PLinePriv(Detail)) $PLinePriv(Step$PLinePriv(Detail))]
        $w.f1.e selection range 0 end
        set PLinePriv(Value) $PLinePriv(OldValue)
        return error
    }

    set PLinePriv(OldValue) $PLinePriv(Value)

    if { $PLinePriv(OldValue) <= 0.0} {
        $w.f2.rd1 configure -state disabled
        $w.f2.rd2 configure -state disabled
    } else {
        $w.f2.rd1 configure -state normal
        $w.f2.rd2 configure -state normal
    }

    #set PLinePriv(Value) $newval

    # if { $PLinePriv(Value) != [$w.f1.s get ] } {
    #           $w.f1.s set $PLinePriv(Value)
    # }
    if { $PLinePriv(DynamicUpdate) } { PostLineAccept}
}

proc ChangeLineDetailValue { name1 name2 op} {
    global PLinePriv GidPriv

    if { $PLinePriv(DetailValue) == $PLinePriv(OldDetailValue)} { return}

    set PLinePriv(OldValue) $PLinePriv(Value)

    if { $PLinePriv(DynamicUpdate) } { PostLineAccept}
}


proc ChangeLineDetail { n1 n2 op} {
    global PLinePriv GidPriv

    if { $PLinePriv(Detail) == $PLinePriv(OldDetail)} { return}

    set PLinePriv(OldDetail) $PLinePriv(Detail)

    if { "$PLinePriv(Detail)" == "Quick" } {
        if { $PLinePriv(Value) > 0.0} {
            set PLinePriv(LastNiceValue) $PLinePriv(Value)
        } else {
            set PLinePriv(LastNiceValue) $PLinePriv(DefaultValue)
        }
    }

    set w $GidPriv(PostLineOptionsWindow)

    $w.f1.s configure -from $PLinePriv(Min$PLinePriv(Detail)) -to $PLinePriv(Max$PLinePriv(Detail)) -resolution $PLinePriv(Step$PLinePriv(Detail))

    if { "$PLinePriv(Detail)" == "Nice" } {
        $w.f1.l configure 
        $w.f1.e configure -state normal 
        $w.f1.s configure -state normal 
        set PLinePriv(Value) $PLinePriv(LastNiceValue)
    } elseif { "$PLinePriv(Detail)" == "Quick" } {
        $w.f1.l configure 
        $w.f1.e configure -state disabled 
        $w.f1.s configure -state disabled 
        set PLinePriv(Value) -1.0
    }
    $w.f1.s set $PLinePriv(Value)
    #ChangeLineDetailValue PlinePriv Value w
}

#                      LineSize LineDetail info_line_size "Line options"
proc PostLineOptions { line_size_cmd line_detail_cmd line_info_cmd title { w .gid.wPostLineOptions } args} {
    global PLinePriv

    InitWindow2 $w -title $title -geometryvariable PostLineOptionsWindowGeom \
        -initcommand PostLineOptions -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set PLinePriv(DynamicUpdate) 0

    set PLinePriv(LineSizeCMD) $line_size_cmd
    set PLinePriv(LineDetailCMD) $line_detail_cmd
    set PLinePriv(LineInfoCMD) $line_info_cmd
    catch {
        trace vdelete PLinePriv(Value) w ChangeLineSizeScale
        trace vdelete PLinePriv(DetailValue) w ChangeLineDetailValue
        trace vdelete PLinePriv(Detail) w ChangeLineDetail
    }
    
    ttk::labelframe $w.f3 -text [_ "Quality"]
    ttk::radiobutton $w.f3.rd1 -text [_ "Quick"] -value Quick -variable PLinePriv(Detail)
    ttk::radiobutton $w.f3.rd2 -text [_ "Nice"] -value Nice -variable PLinePriv(Detail)

    grid $w.f3.rd1 -sticky we -row 0 -column 0
    grid $w.f3.rd2 -sticky we -row 0 -column 1
    
    
    ttk::labelframe $w.f2 -text [_ "Type"]
    ttk::radiobutton $w.f2.rd1 -text [_ "2 sides (ribbons)"] -value 2 -variable PLinePriv(DetailValue)
    ttk::radiobutton $w.f2.rd2 -text [_ "4 sides (prisms)"] -value 4 -variable PLinePriv(DetailValue)
    ttk::radiobutton $w.f2.rd3 -text [_ "8 sides (prisms)"] -value 8 -variable PLinePriv(DetailValue)
    
    grid $w.f2.rd1 -sticky we -row 0 -column 0
    grid $w.f2.rd2 -sticky we -row 0 -column 1
    grid $w.f2.rd3 -sticky we -row 0 -column 2
    
   
    ttk::labelframe $w.f1 -text [_ "Size"]
    ttk::label $w.f1.l -text [_ "Line size"]:
    ttk::entry $w.f1.e -textvariable PLinePriv(Value) -width 5
    if { ![info exists PLinePriv(Value)] } {
        set PLinePriv(Value) 0
    }
    gidscale $w.f1.s -orient horizontal -showvalue 0 -variable PLinePriv(Value)

    grid $w.f1.l -sticky w -row 0 -column 0
    grid $w.f1.e -sticky ew -row 0 -column 1
    grid $w.f1.s -sticky ew -row 0 -column 2 
    
    
    ttk::frame $w.f4
    if { ![info exists PLinePriv(DynamicUpdate)] } { set PLinePriv(DynamicUpdate) 0 }
    ttk::checkbutton $w.f4.din -text [_ "Dynamic update"] -variable PLinePriv(DynamicUpdate)

    grid $w.f4.din -sticky ws -columnspan 2
    
    ttk::frame $w.but -style BottomFrame.TFrame
    ttk::button $w.but.accept -text [_ "Apply"] -command PostLineAccept -style BottomFrame.TButton       
    ttk::button $w.but.original -text [_ "Original"] -command PostLineOriginal -style BottomFrame.TButton       
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton      

    grid $w.but.accept $w.but.original $w.but.close -padx 4 -pady 2 -sticky ew

    grid $w.f3 -sticky nsew -padx 3 -pady 3
    grid $w.f2 -sticky nsew -padx 3 -pady 3
    grid $w.f1 -sticky nsew -padx 3 -pady 3
    grid $w.f4 -sticky nsew -padx 3 -pady 3
    grid $w.but -sticky nsew -column 0 -row 5
    grid anchor $w.but center
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 4 -weight 1

    set PLinePriv(AvoidUpdate) 0

    FillPostLineOptionsWInfo
    if { $PLinePriv(Value) < 0.0} {
        set PLinePriv(LastNiceValue) $PLinePriv(DefaultValue)
    } else {
        set PLinePriv(LastNiceValue) $PLinePriv(Value)
    }

    trace variable PLinePriv(Value) w ChangeLineSizeScale
    trace variable PLinePriv(DetailValue) w ChangeLineDetailValue
    trace variable PLinePriv(Detail) w ChangeLineDetail

    focus $w.but.accept   
}
