#
#old code of PostAnimate.tcl 
#now it is unneded because is is possible to do it internally and interactive using process like this:
#Mescape Results Geometry Deformation $result_name_displacement $factor theta $theta_degrees
#$other_factor
#theta $other_theta
#...
#escape

proc PostAnimateCheckIfDeformationIsComplexVector {} {
    # From a single complex vector there can be 3 posibilities: vector//Real vector//Image and vector//|vector|
    # we accept all three to ask for the harmonic deformation
    set cur_deform [ GiD_Info postprocess get main_geom_cur_deform]
    set lst_results [GiD_Info postprocess get cur_results_list "Contour_Fill"]
    set found 0
    set complex_vector_name ""
    foreach res_name $lst_results {
        set idx 0
        set lst_comp [ GiD_Info postprocess get cur_components_list $res_name]
        foreach comp $lst_comp {
            if { "$res_name//$comp" == $cur_deform} {
                if { ( $idx == 8) || ( $idx == 7) || ( $idx == 6) } {
                    # the deformation uses the full complex vector, or the imaginary or real part
                    set found 1
                    set complex_vector_name $res_name
                    break
                }
            }
            incr idx
        }
        if { $found} {
            break
        }
    }
    return $complex_vector_name
}

proc PrepareHarmonicDeformationResults { complex_vector_name num_steps} {
    # Doing the harmonic animation of the complex vector.
    # get complex vector info
    # set res_info [ GiD_Result get [ list $complex_vector_name $cur_analysis $cur_step]]
    set cur_analysis [ GiD_Info postprocess get cur_analysis]
    set cur_step [GiD_Info postprocess get cur_step $cur_analysis]
    set res_info [ GiD_ResultGetArrayOnlyStrictComponents [ list $complex_vector_name $cur_analysis $cur_step]]
    lassign [lindex $res_info 3] ids values
    set num_components [llength $values]
    lassign $values vxr vxi vyr vyi vzr vzi
    # create num_steps temporary results to be animated afterwards
    # set new_analysis_name [_ "Harmonic animation of %s and %s" $cur_analysis $cur_step]
    # use a generic name to overwrite results....
    set new_analysis_name [_ "Harmonic animation"]
    set new_vector_name [_ "deformation"]
    set first_result_id ""
    set lst_res_ids {}
    for { set i 0} { $i < $num_steps} { incr i} {
        set theta [ expr -2.0 * 3.1415926535897932384626433832795 * double( $i) / double( $num_steps)]
        set new_dx [ objarray_map doublearray [ list {r i} "expr sqrt( \$r * \$r + \$i *\$i) * sin( atan2( \$i, \$r) + $theta)"] [ list $vxr $vxi]]
        set new_dy [ objarray_map doublearray [ list {r i} "expr sqrt( \$r * \$r + \$i *\$i) * sin( atan2( \$i, \$r) + $theta)"] [ list $vyr $vyi]]
        set new_dz [ objarray_map doublearray [ list {r i} "expr sqrt( \$r * \$r + \$i *\$i) * sin( atan2( \$i, \$r) + $theta)"] [ list $vzr $vzi]]
        set new_step [ expr $i + 1]
        set res_id [ list $new_vector_name $new_analysis_name $new_step]
        if { [ GiD_Result exists $res_id] } {
            GiD_Result delete $res_id
        }
        if { $first_result_id == ""} {
            set first_result_id $res_id
        }
        # so that they can be deleted afterwards
        lappend lst_res_idx $res_id        
        set res_header [list Result $new_vector_name $new_analysis_name $new_step Vector OnNodes]
        GiD_Result create -array $res_header {} {} [ list $ids [ list $new_dx $new_dy $new_dz]]
        GidUtils::SetWarnLine [_ "Result '%s' for %s step %s created" $new_vector_name $new_analysis_name $new_step].
    }
    set ::GidPriv(HarmonicAnimation,CreatedResults) $lst_res_idx
    return $first_result_id
}

proc PostAnimateHarmonicCheckForAnimation { w} {
    set complexVectorName [PostAnimateCheckIfDeformationIsComplexVector]    
    if { $complexVectorName != ""} {
        # ask if this is what the user wants to do
        set resp [GID_tk_messageBox -parent $w -default no -title [_ "Confirm"] -type yesno \
                       -icon warning \
                       -message [_ "Do you want to do an harmonic animation \nof the full complex vector? \n( this will create temporary results)"]]
        if { $resp == "no"} {
            set complexVectorName ""
        }
    }    
    if { $complexVectorName != ""} {        
        set num_steps [MessageBoxEntry [_ "Number of steps"] [_ "Number of steps for the harmonic animation:"] int+ 10 0 question.png]
        if { $num_steps == ""} {
            set complexVectorName ""
        } else {
            set ::GidPriv(HarmonicAnimation,NumSteps) $num_steps
        }
    }
    set ::GidPriv(HarmonicAnimation,ComplexVectorName) $complexVectorName
    set doHarmonicAnimation 0
    if { $complexVectorName != ""} {
        set doHarmonicAnimation 1
    }
    return $doHarmonicAnimation
}

proc PostAnimateHarmonicGoBack { w } {
    if { [ info exists ::GidPriv(HarmonicAnimation,PrevAnalysis)]} {
        # then everything else also exists
        GiD_Process Mescape Results AnalysisSel $::GidPriv(HarmonicAnimation,PrevAnalysis) $::GidPriv(HarmonicAnimation,PrevStep) escape escape
        GiD_Process Mescape Results Geometry Original \
            Geometry Deformation $::GidPriv(HarmonicAnimation,PrevDeformation) $::GidPriv(HarmonicAnimation,PrevDeformationFactor) escape escape 
        foreach res_id $::GidPriv(HarmonicAnimation,CreatedResults) {
            if { [ GiD_Result exists $res_id] } {
                GiD_Result delete $res_id
            }
        }
        # no need to restore the state again
        unset ::GidPriv(HarmonicAnimation,PrevAnalysis)
    }
    PostAnimateHarmonic_PostAnimateConfigureStaticAnimationButton profile $w
}

proc PostAnimateHarmonic_PostAnimateSelectSingleStepAnimation { } {
    # create temporary results to do an harmonic deformation with the complex vector
    set ::GidPriv(HarmonicAnimation,PrevAnalysis) [GiD_Info postprocess get cur_analysis]
    set ::GidPriv(HarmonicAnimation,PrevStep) [GiD_Info postprocess get cur_step $::GidPriv(HarmonicAnimation,PrevAnalysis)]
    set ::GidPriv(HarmonicAnimation,PrevDeformation) [GiD_Info postprocess get main_geom_cur_deform]
    set ::GidPriv(HarmonicAnimation,PrevDeformationFactor) [GiD_Info postprocess get main_geom_cur_factor]
    set first_result_id [PrepareHarmonicDeformationResults $::GidPriv(HarmonicAnimation,ComplexVectorName) $::GidPriv(HarmonicAnimation,NumSteps)]

    # now deform the mesh with the new created result
    # first_result_id = { res_name analysis_name step_value}
    lassign $first_result_id new_vector_name analysis_name step_value
    GiD_Process Mescape Results AnalysisSel $analysis_name $step_value escape escape escape
    set suggestedFactor [GiD_Info postprocess get main_geom_factor $analysis_name $step_value $new_vector_name]
    GiD_Process Mescape Results Geometry Original Geometry Deformation $new_vector_name $suggestedFactor escape
    set ::GidPriv(UserDeformationFactorValue) $suggestedFactor
    DoDeformationUpdateFactorValue .dummy2 .dummy3
    
    # now this is an all step animation
    set ::SingleStepAnimation(in_use) 0
    set ::GidPriv(PostAnimateProfileType) AllSteps
    # PostAnimateGetResultVisualizationState
    set ::GidPriv(PostAnimateRangeFrameTo) $::GidPriv(HarmonicAnimation,NumSteps)
    PostAnimateConfigureSlide
    
    PostAnimateHarmonic_PostAnimateConfigureStaticAnimationButton stopharmonic $::GidPriv(PostAnimateWindow)
    $::SingleStepAnimation(staticProfileButton) configure -state normal
    InfoWin [_ "Press the play button to do the harmonic animation.\nPress the 'Stop harmonic animation' button to delete the temporary results and return the previous state."] $::GidPriv(PostAnimateWindow)
}

proc PostAnimateHarmonic_PostAnimateConfigureStaticAnimationButton { what w } {
    if { $what == "profile"} {
        $::SingleStepAnimation(staticProfileButton) configure \
            -text [_ "Static analysis animation profile"]  \
            -command "PostAnimateSelectStaticAnimationProfile $w"
        setTooltip $::SingleStepAnimation(staticProfileButton) [_ "Configures the behaviour of the pseudo-animation\n \
            of the deformation for a single step."]
    } elseif { $what == "stopharmonic"} {
        $::SingleStepAnimation(staticProfileButton) configure \
            -text [_ "Stop harmonic animation"]  \
            -command "PostAnimateHarmonicGoBack $w"
        setTooltip $::SingleStepAnimation(staticProfileButton) [_ "Deletes the temporary results and \nreturns the state before doing the harmonic animation."]
    }
}
