proc PerspectiveWOriginal {} {
    global PerspPriv
    set PerspPriv(AvoidUpdate) 1
    set PerspPriv(Distance) [expr log10( 4.0)]
    set PerspPriv(DoIt) 0
    if { $PerspPriv(DynamicUpdate) } { 
	SendPerspectiveInfo no 
    }
    after idle set PerspPriv(AvoidUpdate) 0 ; FillPerspectiveWInfo
}

proc FillPerspectiveWInfo {} {
    global GidPriv PerspPriv
    if { ![winfo exists .gid.wPerspectiveW] } return
    if { $PerspPriv(AvoidUpdate) } { return }
    set w $GidPriv(PrePostPerspectiveWWindow)
    set perspmode [GiD_Info perspectivemode]
    set perspdist [GiD_Info perspectivefactor]
    # escala logaritmica:
    $w.f1.s configure -from [expr log10( 0.0001)] -to [expr log10( 100.0)] -resolution 0.1
    set PerspPriv(Distance) [expr log10( $perspdist) ]
    $w.f1.s set $PerspPriv(Distance)
    #apply resolution to variable
    set PerspPriv(Distance) [$w.f1.s get ]    
    set PerspPriv(DoIt) 0
    if { $perspmode == "NORMAL" } {
	set PerspPriv(DoIt) 0
	$w.f1.s configure -state disabled
	$w.f1.e configure -state disabled
    } else {
	set PerspPriv(DoIt) 1
	$w.f1.s configure -state !disabled
	$w.f1.e configure -state !disabled
    }
}

proc ChangePerspective { newval } {
    global GidPriv PerspPriv
    set w $GidPriv(PrePostPerspectiveWWindow)
    if { ![IsWord real $newval $w " In Distance field"] } {
	$w.f1.e sel range 0 end
	return error
    }
    if { $newval < [ expr log10( 0.000099999)] || $newval > [ expr log10( 100.0)] } {	
	$w.f1.e sel range 0 end
    WarnWin [_ "Value out of limits"]
	return error
    }    
    set PerspPriv(Distance) $newval
    if { $PerspPriv(Distance) != [$w.f1.s get ] } {
	$w.f1.s set $PerspPriv(Distance)
	#apply resolution to variable
	set PerspPriv(Distance) [$w.f1.s get ]
    }
    if { $PerspPriv(DynamicUpdate) } { 
	SendPerspectiveInfo no 
    }
}

proc SetPerspective { name1 name2 ops } {
    global GidPriv PerspPriv
    set w $GidPriv(PrePostPerspectiveWWindow)
    if { $PerspPriv(DoIt) } {
	$w.f1.e configure -state !disabled
	$w.f1.s configure -state !disabled
    } else {
	$w.f1.e configure -state disabled
	$w.f1.s configure -state disabled
    }
}

proc SendPerspectiveInfo { { DoTest yes } { Fastredraw yes } } {
    global GidPriv PerspPriv
    set w $GidPriv(PrePostPerspectiveWWindow)
    set PerspPriv(AvoidUpdate) 1
    if { $DoTest == "yes" } {
	if { [ChangePerspective $PerspPriv(Distance)] == "error" } { 
	    return 
	}
    }
    set old_perspmode [ GiD_Info perspectivemode ]
    set old_perspdist [ expr log10( [ GiD_Info perspectivefactor ])]
    set perspcmd 'Projection
    if { $Fastredraw == "yes" } {
	set perspcmd "$perspcmd FastDraw"
    }
    if { $PerspPriv(DoIt) } {
	if { $old_perspmode == "NORMAL" } {
	    set perspcmd "$perspcmd Perspective"
	}
    } else {
	if { $old_perspmode == "PERSPECTIVE" } {
	    set perspcmd "$perspcmd Normal"
	}
    }
    if { $PerspPriv(DoIt) && [expr abs( $old_perspdist - $PerspPriv(Distance) ) ] > 1.0e-7 } {
	set perspcmd "$perspcmd Distance [expr pow(10,$PerspPriv(Distance))]"
	if { $Fastredraw == "yes" } {
	    set perspcmd "$perspcmd NoFastDraw"
	}
    }
    GiD_Process {*}$perspcmd MEscape
    after idle set PerspPriv(AvoidUpdate) 0 ; FillPerspectiveWInfo
}

proc PerspectiveW { { w .gid.wPerspectiveW } } {
    global GIDDEFAULT PerspPriv
    InitWindow2 $w -title [_ "Perspective"] \
        -geometryvariable PrePostPerspectiveWWindowGeom \
        -initcommand PerspectiveW -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    set PerspPriv(DynamicUpdate) 0
    catch {
	trace vdelete PerspPriv(DoIt) w SetPerspective
    }
    ttk::frame $w.f0
    if { ![info exists PerspPriv(DoIt)] } { set PerspPriv(DoIt) 0 }
    ttk::checkbutton $w.f0.c -text [_ "Perspective projection"] -variable PerspPriv(DoIt)
    ttk::label $w.f0.l -text [_ "Log10 of Distance between \nObserver and Object Center"]:
    ttk::frame $w.f1 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f1.l -text [_ "log10(Distance)"]:
    ttk::entry $w.f1.e -textvariable PerspPriv(Distance)  
    bind $w.f1.e <Return> { ChangePerspective $PerspPriv(Distance) }
    gidscale $w.f1.s -orient horizontal -command "ChangePerspective"
    if { ![info exists PerspPriv(DynamicUpdate)] } { set PerspPriv(DynamicUpdate) 0 }
    ttk::checkbutton $w.din -text [_ "Dynamic update"] -variable PerspPriv(DynamicUpdate)  
    ttk::frame $w.but -style BottomFrame.TFrame   
    ttk::button $w.but.accept -text [_ "Apply"] -command "SendPerspectiveInfo yes no"  -underline 0 -style BottomFrame.TButton   
    ttk::button $w.but.original -text [_ "Default"] -command "PerspectiveWOriginal" -underline 0 -style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command "destroy $w" -underline 0 -style BottomFrame.TButton   
    grid $w.f0.c -sticky w
    grid $w.f0.l -sticky ew
    grid $w.f1.l -sticky w -row 0 -column 0
    grid $w.f1.e -sticky ew -row 0 -column 1
    grid $w.f1.s -sticky ew -row 1 -column 0 -columnspan 2
    grid columnconfigure $w.f1 1 -weight 1
    grid $w.but.accept -row 1 -column 1 -padx 5 -pady 6
    grid $w.but.original -row 1 -column 2 -padx 5 -pady 6
    grid $w.but.close -row 1 -column 3 -padx 5 -pady 6
    grid $w.but -row 4 -column 0  -sticky ews -columnspan 7
    grid anchor $w.but center
    grid $w.f0 -row 0 -padx 3 -pady 3 -sticky ew
    grid $w.f1 -row 1 -padx 3 -pady 3 -sticky ew
    grid $w.din -row 2 -padx 3 -pady 3 -sticky w
    grid $w.but -row 3 -sticky ews -columnspan 7
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 3 -weight 1

    # Resize behavior management
    # wm minsize $w 180 200
    set PerspPriv(AvoidUpdate) 0
    FillPerspectiveWInfo
    focus $w.but.accept
    bind $w <Alt-c> "$w.but.close invoke"
    bind $w <Escape> "$w.but.close invoke"
    trace variable PerspPriv(DoIt) w SetPerspective
}
