proc EditNURBS { LineOrSurface } {
    global GidPriv
    set w .gid.nurbsurfmove
    set GidPriv(FixBoundary) 1
    set GidPriv(Decrement) 0.4
    set GidPriv(LastDecrement) 0.4
    set GidPriv(FixBoundary) 1
    if { ![info exists GidPriv(EdNURBStolerance)] } {
        set GidPriv(EdNURBStolerance) [_ "Automatic"]
    } elseif {$GidPriv(EdNURBStolerance)==-1.0} {
        set GidPriv(EdNURBStolerance) [_ "Automatic"]
    }
    
    set entitytypename [_ $LineOrSurface]
    InitWindow2 $w -title [_ "Edit NURBS %s" $entitytypename] \
        -geometryvariable PreEditNURBSWindowGeom \
        -ontop
    if { ![winfo exists $w] } {
        # windows disabled || UseMoreWindows == 0
        return
    }
    ttk::frame $w.frmMovement -padding 5
    ttk::label $w.frmMovement.lblMoveType -text [_ "Movement type"] -padding 5
    
    if { ![info exists GidPriv(Movement)] } {
        set GidPriv(Movement) MoveScreen
    }
    
    if { [string equal -nocase $LineOrSurface "surface"] } {
        set labels [list [_ "Screen"] [_ "Normal"] [_ "Point"] [_ "X-Axis"] [_ "Y-Axis"] [_ "Z-Axis"]]
        
        ttk::combobox $w.frmMovement.mnuMovement -values $labels -state readonly
        
        bind .gid.nurbsurfmove.frmMovement.mnuMovement <<ComboboxSelected>> {
            global GidPriv
            set commands { MoveScreen MoveNormal MoveToPoint MoveXAxis MoveYAxis MoveZAxis }
            set GidPriv(Movement) [lindex $commands [.gid.nurbsurfmove.frmMovement.mnuMovement current]]
        }
        #Default value blank without any option selected
        #To select an option can be use:
        set indexcombobox 0
        $w.frmMovement.mnuMovement current $indexcombobox
        #Be careful, the binding hasn't been executed so:
        set commands { MoveScreen MoveNormal MoveToPoint MoveXAxis MoveYAxis MoveZAxis }
        set GidPriv(Movement) [lindex $commands $indexcombobox]                      
    } else {
        set labels [list [_ "Screen"] [_ "Point"] [_ "X-Axis"] [_ "Y-Axis"] [_ "Z-Axis"]]
        
        ttk::combobox $w.frmMovement.mnuMovement -values $labels -state readonly
        
        bind .gid.nurbsurfmove.frmMovement.mnuMovement <<ComboboxSelected>> {
            global GidPriv
            set commands { MoveScreen MoveToPoint MoveXAxis MoveYAxis MoveZAxis }
            set GidPriv(Movement) [lindex $commands [.gid.nurbsurfmove.frmMovement.mnuMovement current]]
        }
        
        set indexcombobox 0
        
        $w.frmMovement.mnuMovement current $indexcombobox
        
        set commands { MoveScreen MoveToPoint MoveXAxis MoveYAxis MoveZAxis }
        set GidPriv(Movement) [lindex $commands $indexcombobox]
        
    }    
        
    GidHelp $w.frmMovement.mnuMovement [_ "User can choose the mode of select points dinamically."]
        
    ##################scale tile
    
    ttk::frame $w.frmDecrement -borderwidth 2 -style ridge.TFrame            
    set scl [ttk::frame $w.sclDecrement -style solid.TFrame -borderwidth 2]    
    ttk::label $scl.label -text [_ "Influence factor"]
    
    #ttk::scale $scl.bar -from 0 -to 1 -orient horizontal -variable GidPriv(Decrement) -command DecrementMoving
    #ttk::label $scl.text -textvariable GidPriv(Decrement)
    #ttk::button $w.buttonMinus -text - -width 3
    #ttk::button $w.buttonPlus -text + -width 3
    gidscale $scl.bar -from 0 -to 1 -orient horizontal -variable GidPriv(Decrement) -command DecrementMoving -resolution 0.05
    
    grid $scl -row 2 -column 0 -padx 1 -pady 1 -sticky ew
    grid $scl.label -in $scl -row 1 -column 1 -sticky ew
    grid $scl.bar -in $scl -row 2 -column 1 -sticky ew
    #grid $scl.text -in $scl -row 3 -column 1 -sticky ew
    grid columnconfigure $scl 1 -weight 1
    grid rowconfigure $scl 1 -weight 1   
            
    proc DecrementMoving { val } {
        global GidPriv
        set GidPriv(Decrement) [format "%.2f" $val]
        if { $GidPriv(Decrement) != $GidPriv(LastDecrement) } {
            set GidPriv(LastDecrement) $GidPriv(Decrement)
            GiD_Process Decrement=$GidPriv(Decrement)
        }
    }
    set GidPriv(auxvar) $w.sclDecrement.bar
    
    #$w.buttonMinus configure -command { $GidPriv(auxvar) set [expr $GidPriv(Decrement)-0.05] }
    #$w.buttonPlus configure -command { $GidPriv(auxvar) set [expr $GidPriv(Decrement)+0.05] }
    #after idle [$w.sclDecrement.bar configure  -command DecrementMoving]
    
    ##################end scale tile   
    
    GidHelp $w.sclDecrement [_ "Value 0 only move the control point\n value 1 move all control points."]
            
    ttk::frame $w.frmFixBoundary
    if { ![info exists GidPriv(FixBoundary)] } { set GidPriv(FixBoundary) 0 }
    ttk::checkbutton $w.chkFixBoundary -text [_ "Fix boundary"] -variable GidPriv(FixBoundary) -command SetBoundary
    
    proc SetBoundary { } {
        global GidPriv
        if { $GidPriv(FixBoundary) } {
            GiD_Process FixBoundary
        } else {
            GiD_Process FreeBoundary
        }
    }
    
    GidHelp $w.chkFixBoundary [_ "Fix or free the boundary control points."]
    
    ttk::frame $w.frmLineSpecific -padding 5
    ttk::frame $w.frmSurfaceSpecific -padding 5
    ttk::button $w.btnInsertKnot -text [_ "Insert knot"] -command [list GiD_Process InsertKnot] -width 16
    ttk::button $w.btnDegreeElevate -text [_ "Elevate degree"] -command [list GiD_Process DegreeElevate] -width 16
    ttk::button $w.btnDegreeReduce -text [_ "Reduce degree"] -command [list SendTolAnd DegreeReduce] -width 16    
    ttk::button $w.btnWeightChange -text [_ "Change weight"] -command [list GiD_Process WeightChange] -width 16
    ttk::button $w.btnCancelWeights -text [_ "Cancel weights"] -command [list GiD_Process CancelWeights] -width 16    
    ttk::button $w.btnReparametrize -text [_ "Reparametrize"] -command [list GiD_Process Reparametrize] -width 16
    ttk::button $w.btnSimilarCubic -text [_ "Similar Cubic"] -command [list SendTolAnd SimilarCubic] -width 16    
    ttk::button $w.btnInsertUKnot -text [_ "Insert U knot"] -command [list GiD_Process InsertUKnot] -width 16
    ttk::button $w.btnInsertVKnot -text [_ "Insert V knot"] -command [list GiD_Process InsertVKnot] -width 16
    ttk::button $w.btnDegreeUElevate -text [_ "Elevate U degree"] -command [list GiD_Process DegreeUElevate] -width 16
    ttk::button $w.btnDegreeVElevate -text [_ "Elevate V degree"] -command [list GiD_Process DegreeVElevate] -width 16
    ttk::button $w.btnDegreeUReduce -text [_ "Reduce U degree"] -command [list SendTolAnd DegreeUReduce] -width 16
    ttk::button $w.btnDegreeVReduce -text [_ "Reduce V degree"] -command [list SendTolAnd DegreeVReduce] -width 16    
    ttk::button $w.btnKnotRemoval -text [_ "Knot Removal"] -command [list SendTolAnd KnotRemoval] -width 16
    ttk::button $w.btnUKnotRemoval -text [_ "Knot Removal in U"] -command [list SendTolAnd UKnotRemoval] -width 16
    ttk::button $w.btnVKnotRemoval -text [_ "Knot Removal in V"] -command [list SendTolAnd VKnotRemoval] -width 16
    ttk::button $w.btnBezier -text [_ "Bezier"] -command [list GiD_Process Bezier] -width 16
    
    GidHelp $w.btnBezier [_ "Convert to Bezier form repeating all knots until the degree+1"]
    
    ttk::label $w.labeltol -text [_ "Tolerance"]: -width 16
    ttk::entry $w.entrytol -textvariable GidPriv(EdNURBStolerance) -width 16    
    ttk::frame $w.blankframe
    ttk::frame $w.frmButtons -style BottomFrame.TFrame -padding 5    
    ttk::button $w.frmButtons.btnApply -style BottomFrame.TButton -text [_ "Apply"] -command [list EditNURBSApply $w $LineOrSurface] -underline 0    
    ttk::button $w.frmButtons.btnSelect -style BottomFrame.TButton -text [_ "Pick"] -command [list EditNURBSSelEntity $w $LineOrSurface] -underline 0    
    ttk::button $w.frmButtons.btnclose -style BottomFrame.TButton -text [_ "Close"] -command [list EditNURBSClose $w $LineOrSurface] -underline 0
    
    grid $w.frmMovement -row 1 -column 1 -sticky ewns
    grid $w.frmMovement.lblMoveType -row 1 -column 1 -sticky ewns
    grid $w.frmMovement.mnuMovement -row 1 -column 2 -sticky ewns
    
    grid $w.frmDecrement -row 2 -column 1 -sticky ewns
    #grid $w.buttonMinus -in $w.frmDecrement -row 1 -column 1
    grid $w.sclDecrement -in $w.frmDecrement -row 1 -column 2 -sticky ew
    #grid $w.buttonPlus -in $w.frmDecrement -row 1 -column 3
    grid columnconfigure $w.frmDecrement 1 -weight 0
    grid columnconfigure $w.frmDecrement 2 -weight 1
    grid columnconfigure $w.frmDecrement 3 -weight 0
    
    grid $w.frmFixBoundary -row 3 -column 1 -sticky news
    grid $w.chkFixBoundary -in $w.frmFixBoundary -row 1 -column 1 -sticky news
    grid $w.sclDecrement.bar -in $w.sclDecrement -row 2 -column 1 -sticky ew
    
    if { [string equal -nocase $LineOrSurface "surface"] } {
        grid $w.frmSurfaceSpecific -row 4 -column 1  -sticky news
        grid $w.btnInsertUKnot -in $w.frmSurfaceSpecific -row 1 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnUKnotRemoval -in $w.frmSurfaceSpecific -row 1 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnInsertVKnot -in $w.frmSurfaceSpecific -row 2 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnVKnotRemoval -in $w.frmSurfaceSpecific -row 2 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnDegreeUElevate -in $w.frmSurfaceSpecific -row 3 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnDegreeUReduce -in $w.frmSurfaceSpecific -row 3 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnDegreeVElevate -in $w.frmSurfaceSpecific -row 4 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnDegreeVReduce -in $w.frmSurfaceSpecific -row 4 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnWeightChange -in $w.frmSurfaceSpecific -row 5 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnCancelWeights -in $w.frmSurfaceSpecific -row 5 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnReparametrize -in $w.frmSurfaceSpecific -row 6 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnSimilarCubic -in $w.frmSurfaceSpecific -row 6 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnBezier -in $w.frmSurfaceSpecific -row 7 -column 1 -sticky new -padx 1 -pady 1
        grid $w.labeltol -in $w.frmSurfaceSpecific -row 8 -column 1 -sticky new -padx 1 -pady 1
        grid $w.entrytol -in $w.frmSurfaceSpecific -row 8 -column 2 -sticky new -padx 1 -pady 1
    } else {
        grid $w.frmLineSpecific -row 4 -column 1  -sticky ewns
        grid $w.btnInsertKnot -in $w.frmLineSpecific -row 1 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnKnotRemoval -in $w.frmLineSpecific -row 1 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnDegreeElevate -in $w.frmLineSpecific -row 2 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnDegreeReduce -in $w.frmLineSpecific -row 2 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnWeightChange -in $w.frmLineSpecific -row 3 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnCancelWeights -in $w.frmLineSpecific -row 3 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnReparametrize -in $w.frmLineSpecific -row 4 -column 1 -sticky new -padx 1 -pady 1
        grid $w.btnSimilarCubic -in $w.frmLineSpecific -row 4 -column 2 -sticky new -padx 1 -pady 1
        grid $w.btnBezier -in $w.frmLineSpecific -row 5 -column 1 -sticky new -padx 1 -pady 1
        grid $w.labeltol -in $w.frmLineSpecific -row 6 -column 1 -sticky new -padx 1 -pady 1
        grid $w.entrytol -in $w.frmLineSpecific -row 6 -column 2 -sticky new -padx 1 -pady 1
    }
    
    grid $w.blankframe -row 5 -column 1 -sticky news
    
    grid $w.frmButtons.btnApply -row 1 -column 1  -padx 5 -pady 6
    grid $w.frmButtons.btnSelect -row 1 -column 2 -padx 5 -pady 6
    grid $w.frmButtons.btnclose -row 1 -column 3  -padx 5 -pady 6
    grid $w.frmButtons -row 6 -column 1  -columnspan 7 -sticky ews
    
    grid $w.frmButtons.btnApply -row 1 -column 1 -padx 5 -pady 6
    grid $w.frmButtons.btnSelect -row 1 -column 2 -padx 5 -pady 6
    grid $w.frmButtons.btnclose -row 1 -column 3 -padx 5 -pady 6
    grid $w.frmButtons -row 6 -column 1  -sticky ews -columnspan 7
    grid anchor $w.frmButtons center
    
    # Resize behavior management
    grid columnconf $w 1 -minsize 80 -weight 1
    
    grid rowconfigure $w 1 -weight 1
    grid rowconfigure $w 2 -weight 1
    grid rowconfigure $w 3 -weight 1
    grid rowconfigure $w 4 -weight 1
    grid rowconfigure $w 5 -weight 10000
    grid rowconfigure $w 6 -weight 0
    
    # grid $w.lblNumEntity -row 5 -column 1
    
    #set GidPriv(auxvar) $w.sclDecrement.bar
    #$w.buttonMinus configure -command { $GidPriv(auxvar) set [expr $GidPriv(Decrement)-0.05] }    
    #$w.buttonPlus configure -command { $GidPriv(auxvar) set [expr $GidPriv(Decrement)+0.05] }    
    #after idle [$w.sclDecrement.bar configure -command DecrementMoving]
    
    EnabledDisabled $w $LineOrSurface disabled
    
    focus $w.frmButtons.btnSelect
    
    bind $w <Alt-s> "$w.frmButtons.btnSelect invoke"
    bind $w <Alt-c> "$w.frmButtons.btnclose invoke"
    bind $w <Escape> "$w.frmButtons.btnclose invoke"
    bind $w <Return> "$w.frmButtons.btnApply invoke"
    
    bind $w <Destroy> [list +DestroyEditNURBS %W $w]
    trace add variable GidPriv(Movement) write "EditNurbsChangeMovement ;#"
}

proc EditNURBSApply { w LineOrSurface } {
    GiD_Process MEscape
}

proc EditNURBSCancelPick { w LineOrSurface } {
    $w.frmButtons.btnSelect configure -command [list EditNURBSSelEntity $w $LineOrSurface] -text [_ "Pick"] 
    GiD_Process MEscape
}

proc EditNURBSClose { w LineOrSurface } {    
    destroy $w    
    GiD_Process Mescape
}

proc EditNURBSSelEntity { w LineOrSurface } {
    global GidPriv
    
    if { [trace vinfo GidPriv(selection)] != "" } { return }
    set old_disable_writebatch [GiD_Project set disable_writebatch]
    if { $old_disable_writebatch != 1 } {
        #try to hide the use of process by this proc to batch and Undo
        GiD_Project set disable_writebatch 1
    }
    if { [string equal -nocase $LineOrSurface "surface"] } {
        GiD_Process Mescape 'SelectEntities JustOne Surfaces SurfaceType NURBSURFACE
    } else { 
        GiD_Process Mescape 'SelectEntities JustOne Lines LineType NURBLINE
    }
    $w.frmButtons.btnSelect configure -command [list EditNURBSCancelPick $w $LineOrSurface] -text [_ "Cancel"] 
    trace var GidPriv(selection) w "EditNURBSEndSelEntity $w $LineOrSurface $old_disable_writebatch;#"
}

proc EditNURBSEndSelEntity { w LineOrSurface old_disable_writebatch} {
    global GidPriv
    
    if { $old_disable_writebatch != 1 } {
        GiD_Project set disable_writebatch $old_disable_writebatch
    }
    
    $w.frmButtons.btnSelect configure -command "cmdbreak $w $LineOrSurface" -text [_ "Cancel"]
    
    proc cmdbreak { w LineOrSurface } {
        GiD_Process Break
        $w.frmButtons.btnSelect configure -command [list EditNURBSSelEntity $w $LineOrSurface] -text [_ "Pick"]
    } 
    
    
    foreach i [trace vinfo GidPriv(selection)] {
        trace vdelete GidPriv(selection) [lindex $i 0] [lindex $i 1]
    }
    
    set num [lindex [lindex $GidPriv(selection) 0] 1]
    set nnum ""
    regexp {[0-9]*} $num nnum
    if { $nnum == "" } { return }
    set entitytypename [_ $LineOrSurface]
    wm title $w [_ "Edit NURBS %s %d" $entitytypename $nnum]
    
    set GidPriv(selection) ""
    
    EnabledDisabled $w $LineOrSurface normal
    if { [string equal -nocase $LineOrSurface "surface"] } {
        GiD_Process MEscape Geometry Edit EdNurbsSurf $nnum
    } else {
        GiD_Process MEscape Geometry Edit EdNurbsLine $nnum
    }
    after idle [list delayedop changefunc "EnabledDisabled $w $LineOrSurface disabled"]
}

proc EnabledDisabled { w LineOrSurface stat } {
    $w.frmMovement.mnuMovement configure -state $stat
    #$w.sclDecrement configure -state $stat
    if { $stat == "disabled" } {        
        set entitytypename [_ $LineOrSurface]
        wm title $w [_ "Edit NURBS %s" $entitytypename]
        $w.frmButtons.btnSelect configure -command [list EditNURBSSelEntity $w $LineOrSurface] -text [_ "Pick"]
        #$w.sclDecrement configure -foreground grey60
        $w.sclDecrement.bar configure -state disabled       
    } else {
        $w.sclDecrement.bar configure -state !disabled
    }
    #$w.sclDecrement.text configure -state $stat
    #$w.buttonMinus configure -state $stat
    #$w.buttonPlus configure -state $stat
    $w.chkFixBoundary configure -state $stat
    
    if { [string equal -nocase $LineOrSurface "surface"] } {
        #RecursiveChangeState $w.frmSurfaceSpecific $stat
        $w.btnInsertUKnot configure -state $stat
        $w.btnInsertVKnot configure -state $stat
        $w.btnUKnotRemoval configure -state $stat
        $w.btnVKnotRemoval configure -state $stat
        $w.btnDegreeUElevate configure -state $stat
        $w.btnDegreeVElevate configure -state $stat
        $w.btnDegreeUReduce configure -state $stat
        $w.btnDegreeVReduce configure -state $stat
        $w.btnWeightChange configure -state $stat
        $w.btnCancelWeights configure -state $stat
        $w.btnReparametrize configure -state $stat
        $w.btnSimilarCubic configure -state $stat
        $w.btnBezier configure -state $stat
        $w.labeltol configure -state $stat
    } else {
        #RecursiveChangeState $w.frmLineSpecific $stat
        $w.btnInsertKnot configure -state $stat
        $w.btnKnotRemoval configure -state $stat
        $w.btnDegreeElevate configure -state $stat
        $w.btnDegreeReduce configure -state $stat
        $w.btnWeightChange configure -state $stat
        $w.btnCancelWeights configure -state $stat
        $w.btnReparametrize configure -state $stat
        $w.btnSimilarCubic configure -state $stat
        $w.btnBezier configure -state $stat
        $w.labeltol configure -state $stat
    }    
    $w.frmButtons.btnApply configure -state $stat
}

proc DestroyEditNURBS { W w } {
    if { $W != $w } return
    global GidPriv
    trace remove variable GidPriv(Movement) write "EditNurbsChangeMovement ;#"
}

proc EditNurbsChangeMovement { } {
    global GidPriv
    if { ![info exists GidPriv(Movement)] } {
        set GidPriv(Movement) MoveScreen
    }
    GiD_Process $GidPriv(Movement)
}

proc SendTolAnd { value } {
    global GidPriv
    if { $GidPriv(EdNURBStolerance)==[_ "Automatic"] } {
        GiD_Process Tolerance 0.0 $value
    } else {
        GiD_Process Tolerance $GidPriv(EdNURBStolerance) $value
    }
}
