# interface generated by SpecTcl version 1.0 from CopyRot.ui
#   root     is the parent window for this user interface
# Edgar, 8-03-02

proc CopySweep_ui { root args } {
    global CopyMoveInfo GidPriv
    # this treats "." as a special case
    if { $root == "." } {
	set base ""
    } else {
	set base $root
    }
    set CopyMoveInfo(base) $base

    if { ![info exists CopyMoveInfo(TwistAngle)] || $CopyMoveInfo(TwistAngle) == "" } {
	set CopyMoveInfo(TwistAngle) 0.0
    }
    if { ![info exists CopyMoveInfo(EndScale)] || $CopyMoveInfo(EndScale) == "" } {
	set CopyMoveInfo(EndScale) 1.0
    }
    if { ![info exists CopyMoveInfo(EnabledCurveTwist)] } {
	set CopyMoveInfo(EnabledCurveTwist) 1
    }
    if { ![info exists CopyMoveInfo(TwistMode)] } {
	set CopyMoveInfo(TwistMode) NaturalTwist
    }

    ttk::frame $base.frame1 -style ridge.TFrame -borderwidth 2
    ttk::frame $base.framescale -style ridge.TFrame -borderwidth 2
    ttk::frame $base.frame2 -style ridge.TFrame -borderwidth 2


    # PATH FRAME ---------------------------

    ttk::label $base.label19 \
	    -text [_ "Path line"]
    ttk::button $base.button4 \
	    -command { set CopyMoveInfo(path) [::GidUtils::PickEntities Lines single] } \
	    -image [gid_themes::GetImage line.png small_icons]	   
	    
    ttk::entry $base.entry13 \
	    -textvariable CopyMoveInfo(path) \
	    -width 4	   

    #scale frame
    ttk::label $base.framescale.label1  -text [_ "End scale"]:
    ttk::entry $base.framescale.entry1 \
	    -textvariable CopyMoveInfo(EndScale) -width 4	   

    # TWIST FRAME -------------------------------

    ttk::label $base.label3 \
	    -text [_ "Twist options"]
    ttk::label $base.label14 \
	    -text [_ "Angle(degrees)"]:
    ttk::entry $base.entry11 \
	    -textvariable CopyMoveInfo(TwistAngle) \
	    -width 4	 
    ttk::frame $base.frame3 \
            -borderwidth 2\
    	    -style ridge.TFrame
	    
    ttk::label $base.label15 \
	    -text [_ "Direction"] -state disabled
    if { ![info exists ::CopyMoveInfo(TwistMode) ] } {
        set ::CopyMoveInfo(TwistMode) NaturalTwist
    }
    [ TTKMB_CreateOrConfigure $base.menubutton1] $base.menubutton1 -textvariable ::CopyMoveInfo(TwistMode) \
	    -labels [list [_ "NaturalTwist"] [_ "XY"] [_ "YZ"] [_ "XZ"] [_ "UserDirection"]  [_ "ByDer2"]] \
	    -values {NaturalTwist XY YZ XZ UserDirection ByDer2}

    ttk::label $base.label13 \
	    -state disabled \
	    -text x:
    ttk::entry $base.entry12 \
	    -state disabled \
	    -textvariable CopyMoveInfo(x,1) \
	    -width 6	 
    ttk::label $base.label12 \
	    -state disabled \
	    -text y:
    ttk::entry $base.entry9 \
	    -state disabled \
	    -textvariable CopyMoveInfo(y,1) \
	    -width 6	   
    ttk::label $base.label11 \
	    -state disabled \
	    -text z:
    ttk::entry $base.entry10 \
	    -state disabled \
	    -textvariable CopyMoveInfo(z,1) \
	    -width 6	   

	if { ![info exists CopyMoveInfo(EnabledCurveTwist)] } { set CopyMoveInfo(EnabledCurveTwist) 0 }
    ttk::checkbutton $base.checkbutton1 -text [_ "Twist modes"] \
	-variable CopyMoveInfo(EnabledCurveTwist) \
	-command "checkbuttonTwistModes $base"

    proc checkbuttonTwistModes { base } {
	global CopyMoveInfo
	if { $CopyMoveInfo(EnabledCurveTwist) == 0 } {
	    EnableDisableSweepGUI $base disable
	} else {
	    EnableDisableSweepGUI $base enable
	    ChangeTwistOptions a b c
	}
    }
    EnableDisableSweepGUI $base enable
    ChangeTwistOptions a b c

    #GID HELP -------------------------------

    GidHelp $base.menubutton1 [_ "Twist mode determines how figure\
	    rotates along the curve:\
	    \n NaturalTwist makes rotate the figure according to its\
	    curvature and torsion.\
	    \n XY, XZ and YZ correct the rotation\
	    occasioned by torsion, rotating the figure to mantain certain\
	    vector in the orthogonal plane of corresponding axis ( z, y or x,\
	    respectively).\
	    \n UserDirection allows user introduce directly the vector of\
	    the orthogonal plane when it is different from z, y or x axis.\
	    \n ByDer2 option corrects the rotation occasioned by torsion\
	    using the second derivate of the path curve."]
    GidHelp $base.checkbutton1 [_ "Twist mode determines how figure\
	    rotates along the curve:\
	    \n NaturalTwist makes rotate the figure according to its\
	    curvature and torsion.\
	    \n XY, XZ and YZ correct the rotation\
	    occasioned by torsion, rotating the figure to mantain certain\
	    vector in the orthogonal plane of corresponding axis ( z, y or x,\
	    respectively).\
	    \n UserDirection allows user introduce directly the vector of\
	    the orthogonal plane when it is different from z, y or x axis.\
	    \n ByDer2 option corrects the rotation occasioned by torsion\
	    using the second derivate of the path curve."]
    GidHelp $base.label15 [_ "This direction is the normal of a plane in which\
	    a specific vector, determined by the relative position of figure\
	    and path curve, lies making the necessary rotation of the figure\
	    along this curve."]
    GidHelp $base.label11 [_ "This direction is the normal of a plane in which\
	    a specific vector, determined by the relative position of figure\
	    and path curve, lies making the necessary rotation of the figure\
	    along this curve."]
    GidHelp $base.label12 [_ "This direction is the normal of a plane in which\
	    a specific vector, determined by the relative position of figure\
	    and path curve, lies making the necessary rotation of the figure\
	    along this curve."]
    GidHelp $base.label13 [_ "This direction is the normal of a plane in which\
	    a specific vector, determined by the relative position of figure\
	    and path curve, lies making the necessary rotation of the figure\
	    along this curve."]
    GidHelp $base.label14 [_ "It is the angle variation of the figure between\
	    start and final point of path curve."]
    GidHelp [list $base.label19 $base.button4] [_ "This line determines where are done the copies\
	    of the figure and how it rotates according to its curvature and\
	    torsion."]
    GidHelp [list $base.framescale.label1 $base.framescale.entry1] [_ "This final scale factor determines \
	    how the figure is scaled along the path curve."]

    # Geometry management -------------------------------
    grid $base.frame1 -in $root -padx 2 -ipadx 1 -pady 0 -ipady 0 -sticky ew
    grid $base.framescale -in $root -padx 2 -ipadx 1 -pady 0 -ipady 0 -sticky ew
    grid $base.frame2 -in $root -padx 2 -ipadx 1 -pady 0 -ipady 0 -sticky ew

    # PATH FRAME -------------------------------
    grid $base.label19 -in $base.frame1 -row 1 -column 1  \
	    -padx 2 -pady 0 -ipady 0 -sticky w
    grid $base.button4 -in $base.frame1 -row 1 -column 2 \
	    -padx 2 -pady 0 -ipady 0 -ipadx 0  -sticky w
    grid $base.entry13 -in $base.frame1 -row 1 -column 3 \
	    -padx 2 -pady 0 -ipady 0 -ipadx 0  -sticky ew

    #scale frame
    grid $base.framescale.label1 $base.framescale.entry1 -padx 2 -pady 0 -ipady 0 -ipadx 0 -sticky w
    grid configure $base.framescale.entry1 -sticky ew

    # TWIST FRAME -------------------------------
    grid $base.frame3 -in $base.frame2 -row 2 -column 1 \
	    -padx 2 -ipadx 0 \
	    -pady 2 -ipady 0 -columnspan 2
    grid $base.label14 -in $base.frame2 -row 1 -column 1 \
	    -sticky e -padx 2 -pady 0 -ipady 0
    grid $base.entry11 -in $base.frame2 -row 1 -column 2 \
	    -sticky ew -padx 2 -pady 0 -ipady 0
    grid $base.checkbutton1 -in $base.frame3 -row 1 -column 1 \
	    -sticky w -padx 2 -pady 0 -ipady 0 -columnspan 2
    grid $base.menubutton1 -in $base.frame3 -row 2 -column 1 \
	    -sticky e -padx 2 -pady 0 -ipady 0 -columnspan 2
    grid $base.label15 -in $base.frame3 -row 3 -column 1 \
	    -padx 2 -pady 0 -ipady 0 -columnspan 2
    grid $base.label13 -in $base.frame3 -row 4 -column 1 \
	    -sticky e -padx 2 -pady 0 -ipady 0
    grid $base.entry12 -in $base.frame3 -row 4 -column 2 \
	    -sticky ew -padx 2 -pady 0 -ipady 0
    grid $base.label12 -in $base.frame3 -row 5 -column 1 \
	    -sticky e -padx 2 -pady 0 -ipady 0
    grid $base.entry9 -in $base.frame3 -row 5 -column 2 \
	    -sticky ew -padx 2 -pady 0 -ipady 0
    grid $base.label11 -in $base.frame3 -row 6 -column 1 \
	    -sticky e -padx 2 -pady 0 -ipady 0
    grid $base.entry10 -in $base.frame3 -row 6 -column 2 \
	    -sticky ew -padx 2 -pady 0 -ipady 0

    # Resize behavior management -------------------------------
    grid rowconfigure $base.frame1 1 -weight 1
    grid columnconfigure $base.frame1 "1 2 3" -weight 1

    grid rowconfigure $base.framescale 0 -weight 1
    grid columnconfigure $base.framescale 1 -weight 1

    grid rowconfigure $base.frame2 "1 2 3 4 5 6" -weight 1
    grid columnconfigure $base.frame2 2 -weight 1

    grid rowconfigure $root 1 -weight 1
    grid columnconfigure $root 1 -weight 1



    # additional interface code -------------------------------

    set CopyMoveInfo(TwistMode) "NaturalTwist"
    trace var CopyMoveInfo(TwistMode) w ChangeTwistOptions

    # end additional interface code
}

proc EnableDisableSweepGUI { base what } {

    switch $what {
	enable {
	    $base.menubutton1 configure -state normal
	}
	disable {
	    $base.menubutton1 configure -state disabled
	    $base.label13 configure -state disabled
	    $base.label15 configure -state disabled
	    $base.label12 configure -state disabled
	    $base.label11 configure -state disabled
	    $base.entry12 configure -state disabled
	    $base.entry9 configure -state disabled
	    $base.entry10 configure -state disabled
	}
    }
}


proc ChangeTwistOptions { name1 name2 op } {
    global CopyMoveInfo
    set base $CopyMoveInfo(base)
    if { ![winfo exists $base.entry12] } return
    if { $CopyMoveInfo(TwistMode) == "NaturalTwist" } {
	$base.label15 configure -state disabled
	$base.entry12 configure -state disabled
	$base.entry9 configure -state disabled
	$base.entry10 configure -state disabled
	set CopyMoveInfo(x,1) 0.0
	set CopyMoveInfo(y,1) 0.0
	set CopyMoveInfo(z,1) 0.0
	$base.label13 configure -state disabled
	$base.label12 configure -state disabled
	$base.label11 configure -state disabled
    } elseif { $CopyMoveInfo(TwistMode) == "XY" } {
	$base.label15 configure -state normal
	$base.entry12 configure -state disabled
	$base.entry9 configure -state disabled
	$base.entry10 configure -state disabled
	set CopyMoveInfo(x,1) 0.0
	set CopyMoveInfo(y,1) 0.0
	set CopyMoveInfo(z,1) 1.0
	$base.label13 configure -state disabled
	$base.label12 configure -state disabled
	$base.label11 configure -state disabled
    } elseif { $CopyMoveInfo(TwistMode) == "XZ" } {
	$base.label15 configure -state normal
	$base.entry12 configure -state disabled
	$base.entry9 configure -state disabled
	$base.entry10 configure -state disabled
	set CopyMoveInfo(x,1) 0.0
	set CopyMoveInfo(y,1) 1.0
	set CopyMoveInfo(z,1) 0.0
	$base.label13 configure -state disabled
	$base.label12 configure -state disabled
	$base.label11 configure -state disabled
    } elseif { $CopyMoveInfo(TwistMode) == "YZ" } {
	$base.label15 configure -state normal
	$base.entry12 configure -state disabled
	$base.entry9 configure -state disabled
	$base.entry10 configure -state disabled
	set CopyMoveInfo(x,1) 1.0
	set CopyMoveInfo(y,1) 0.0
	set CopyMoveInfo(z,1) 0.0
	$base.label13 configure -state disabled
	$base.label12 configure -state disabled
	$base.label11 configure -state disabled
    } elseif { $CopyMoveInfo(TwistMode) == "UserDirection" } {
	$base.label15 configure -state normal
	$base.entry12 configure -state normal
	$base.entry9 configure -state normal
	$base.entry10 configure -state normal
	$base.label13 configure -state normal
	$base.label12 configure -state normal
	$base.label11 configure -state normal
    } elseif { $CopyMoveInfo(TwistMode) == "ByDer2" } {
	$base.label15 configure -state disabled
	$base.entry12 configure -state disabled
	$base.entry9 configure -state disabled
	$base.entry10 configure -state disabled
	set CopyMoveInfo(x,1) 0.0
	set CopyMoveInfo(y,1) 0.0
	set CopyMoveInfo(z,1) 0.0
	$base.label13 configure -state disabled
	$base.label12 configure -state disabled
	$base.label11 configure -state disabled
    }
}

# Allow interface to be run "stand-alone" for testing

catch {
    if {$argv0 == [info script]} {
	wm title . [_ "Testing CopySweep"]
	CopySweep_ui .
    }
}
