
proc CCGetDefaultPivotColourMap {} {
    # only the first two are important
    set colores [ CCListaColores Rainbow 50 "#000080" "#800000" "RGB" "Linear" \
            "old Design" [ list \#000080 \#808080 \#800000 \#808080 \#808080]]
    set num_key_cols 7
    set num_cols [ llength $colores]
    set istep [ expr $num_cols / ( $num_key_cols - 1)]
    set ret_lst {}
    for { set idx 0} { $idx < $num_cols} { incr idx $istep} {
        lappend ret_lst [ lindex $colores $idx]
    }
    return $ret_lst
}

proc CCInitValues { } {
    global ContourColors 
    set ContourColors(Original) [GiD_Info postprocess get cur_contour_color_config]
    set ContourColors(NumeroColores) [ lindex $ContourColors(Original) 0]
    set ContourColors(ColorMapType) [ lindex $ContourColors(Original) 1]
    set ContourColors(UserMinColor) [ lindex $ContourColors(Original) 2]
    set ContourColors(UserMaxColor) [ lindex $ContourColors(Original) 3]
    set ContourColors(MapScaleType) [ lindex $ContourColors(Original) 4]
    set ContourColors(MapScaleRamp) [ lindex $ContourColors(Original) 5]
    set ContourColors(UserMode) [ lindex $ContourColors(Original) 6]
    set ContourColors(OutMinColor) #333333
    set ContourColors(OutMaxColor) #666666
    set ContourColors(ColoresPivote) [ lindex $ContourColors(Original) 7]
    if { [ llength $ContourColors(ColoresPivote)] == 0} {
        set ::ContourColors(ColoresPivote) [ CCGetDefaultPivotColourMap]
    }
    set ContourColors(NumPivotes) [ llength $ContourColors(ColoresPivote)]
    set ContourColors(ColoresPivoteNombre) [ lindex $ContourColors(Original) 8]
    set ::ContourColors(ColourMapName) $ContourColors(ColoresPivoteNombre)
    array set ::ColourMapList [ GiD_Info postprocess get colour_map_list]
}

proc CCAceptar { w } {
    global ContourColors
    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    GiD_Set PostContours(NumberOfColors) $ContourColors(NumeroColores)
    GiD_Set PostContours(ByNumberOfColors) 1
    GiD_Set PostContours(ColourMapType) $ContourColors(ColorMapType)
    if { $ContourColors(ColorMapType) == "UserDefined" } {
        if { $ContourColors(UserMode) == "TwoColors" } {
            GiD_Process Mescape Results ContOptions SetMinOptions MinColor user $ContourColors(UserMinColor)
            GiD_Process Mescape Results ContOptions SetMaxOptions MaxColor user $ContourColors(UserMaxColor)
            GiD_Process Mescape Results ContOptions ColorRamp $ContourColors(MapScaleRamp)
            GiD_Process Mescape Results ContOptions ColorRamp $ContourColors(MapScaleType)
        } else {
            GiD_Process Mescape Results ContOptions ColorRamp DefineMap [llength $ContourColors(ColoresPivote)] {*}$ContourColors(ColoresPivote)
        }
    }
    GiD_Process Mescape Utilities Redisplay
    if { $ContourColors(ColorMapType) == "UserDefined" } {
        ColourMapAcceptAction $w 0
    }
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw
}

proc CCResetValores { w} {
    global ContourColors
    
    set ContourColors(NumeroColores) [ lindex $ContourColors(Original) 0]
    set ContourColors(ColorMapType) [ lindex $ContourColors(Original) 1]
    set ContourColors(UserMinColor) [ lindex $ContourColors(Original) 2]
    set ContourColors(UserMaxColor) [ lindex $ContourColors(Original) 3]
    set ContourColors(MapScaleType) [ lindex $ContourColors(Original) 4]
    set ContourColors(MapScaleRamp) [ lindex $ContourColors(Original) 5]
    set ContourColors(UserMode) [ lindex $ContourColors(Original) 6]
    set ContourColors(ColoresPivote) [ lindex $ContourColors(Original) 7]
    if { [ llength $ContourColors(ColoresPivote)] == 0} {
        set ContourColors(ColoresPivote) "$ContourColors(UserMinColor) $ContourColors(UserMaxColor)"
    }
    set ContourColors(NumPivotes) [ llength $ContourColors(ColoresPivote)]
    
    CCActualizaCanvas
}

proc CCCambiaColor { w colvar} {
    upvar $colvar UserColor
    set color_viejo $UserColor
    #set color_nuevo [ tk_chooseColor -parent $w -initialcolor $color_viejo]
    set color_nuevo [ GIDChooseColor $w.mc -color $color_viejo -parent $w]
    if { "$color_nuevo" != ""} {
        set n [ scan $color_nuevo #%2x%2x%2x r g b]
        if { $n == 3} {
            $w configure -background $color_nuevo           
            set UserColor $color_nuevo
        }
    }
}

proc CCNumColsChange { name1 name2 op} {
    global ContourColors
    
    after cancel CCActualizaCanvas
    
    set w $ContourColors(Window)
    if { $ContourColors(NumeroColores) != ""} {
        if { ![ regexp {^[0-9]*$} $ContourColors(NumeroColores) dum] } {
            set num 0
            scan $ContourColors(NumeroColores) %d num
            set ContourColors(NumeroColores) $num
            $ContourColors(NumeroColoresEntry) delete 0 end
            $ContourColors(NumeroColoresEntry) insert end $num
            bell -displayof $ContourColors(NumeroColoresEntry)
        }
        
    }
    
    after 1500 CCActualizaCanvas
}

proc CCColorMapTypeChange { name1 name2 op} {
    global ContourColors
    
    after cancel CCActualizaCanvas
    
    set w $ContourColors(Window)
    
    switch $ContourColors(ColorMapType) {
        "Rainbow" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }
        }
        "InvRainbow" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }
        }
        "Terrain" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }            
        }
        "BlackAndWhite" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }
        }
        "WhiteAndBlack" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }
        }
        "3DAnaglyphs" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }
        }
        "3DAnaglyphs2" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state disabled
            }
            if { [ llength $ContourColors(UserMode)] == 1} {
                set ContourColors(UserMode) "old $ContourColors(UserMode)"
            }
        }
        "UserDefined" {
            foreach iwd $ContourColors(lista_user_map_estado) {
                $iwd configure -state normal
            }
            if { [ llength $ContourColors(UserMode)] != 1} {
                set ContourColors(UserMode) [lindex $ContourColors(UserMode) 1]
            }
            # actualize colour map colours:
            set ::ContourColors(ColourMapName) $::ContourColors(ColourMapName)
        }
    }
    
    after 1500 CCActualizaCanvas
}

proc CCColorMapUserModeChange { name1 name2 op} {
    global ContourColors
    
    set w $ContourColors(Window)
    set color_fondo [ CCGetRGB $w [ $w cget -background]]
    
    switch $ContourColors(UserMode) {
        "TwoColors" {
            foreach iwd $ContourColors(lista_dos_colores_estado) {
                if { [ winfo class $iwd] != "TCombobox"} {
                    $iwd configure -state normal
                } else {
                    $iwd configure -state readonly
                }
                
            }
            foreach iwd $ContourColors(lista_dos_colores_colores) {
                $iwd configure -foreground black
            }
            foreach iwd $ContourColors(desing_states) {
                UpDownEntryConf $iwd -state disabled
            }
            foreach iwd $ContourColors(desing_colors) {
                $iwd configure -foreground [ CCColorActivo $color_fondo]
            }
        }
        
        "Design" {
            foreach iwd $ContourColors(lista_dos_colores_estado) {
                $iwd configure -state disabled
                
            }
            foreach iwd $ContourColors(lista_dos_colores_colores) {
                $iwd configure -foreground [ CCColorActivo $color_fondo]
            }
            foreach iwd $ContourColors(desing_states) {
                UpDownEntryConf $iwd -state normal
            }
            foreach iwd $ContourColors(desing_colors) {
                $iwd configure -foreground black
            }
        }
        
        default {
            foreach iwd $ContourColors(lista_dos_colores_estado) {
                $iwd configure -state disabled
                
            }
            foreach iwd $ContourColors(lista_dos_colores_colores) {
                $iwd configure -foreground [ CCColorActivo $color_fondo]
            }
            foreach iwd $ContourColors(desing_states) {
                UpDownEntryConf $iwd -state disabled
            }
            foreach iwd $ContourColors(desing_colors) {
                $iwd configure -foreground [ CCColorActivo $color_fondo]
            }
        }
    }
}


proc CCColorUserMapChange { name1 name2 op} {
    global ContourColors
    after cancel CCActualizaCanvas
    after 1500 CCActualizaCanvas
}

proc CCCreaEscalaColores { cols_pivote ncolor} {
    
    set n [ llength $cols_pivote]
    set ninterior [ expr ( $ncolor - 1) / ( $n - 1)]
    
    set lst_colores ""
    set jcolor 0
    for { set i 0} { ( $i < [ expr $n - 2]) && ( $jcolor < $ncolor)} { incr i} {
        set col_ini [ lindex $cols_pivote $i ]
        lappend lst_colores $col_ini
        incr jcolor
        
        set col_fin [ lindex $cols_pivote [ expr $i + 1]]
        scan $col_ini #%2x%2x%2x ci_red ci_green ci_blue
        scan $col_fin #%2x%2x%2x cf_red cf_green cf_blue
        
        set dif_red [ expr double( $cf_red - $ci_red)]
        set dif_green [ expr double( $cf_green - $ci_green)]
        set dif_blue [ expr double( $cf_blue - $ci_blue)]
        for { set j 1} { ( $j < $ninterior) && ( $jcolor < $ncolor)} { incr j} {
            set d [ expr double( $j) / double( $ninterior)]
            set new_red [ expr int( 0.5 + $d * $dif_red + double( $ci_red))]
            set new_green [ expr int( 0.5 + $d * $dif_green + double( $ci_green))]
            set new_blue [ expr int( 0.5 + $d * $dif_blue + double( $ci_blue))]
            lappend lst_colores [ format #%02x%02x%02x $new_red $new_green $new_blue]
            incr jcolor
        }
    }
    
    if { $jcolor < $ncolor} {
        set col_ini [ lindex $cols_pivote $i ]
        lappend lst_colores $col_ini
        incr jcolor
        
        set col_fin [ lindex $cols_pivote [ expr $i + 1]]
        
        scan $col_ini #%2x%2x%2x ci_red ci_green ci_blue
        scan $col_fin #%2x%2x%2x cf_red cf_green cf_blue
        
        set dif_red [ expr double( $cf_red - $ci_red)]
        set dif_green [ expr double( $cf_green - $ci_green)]
        set dif_blue [ expr double( $cf_blue - $ci_blue)]
        
        set ninterior [ expr $ncolor - $jcolor]
        for { set j 1} { ( $j < $ninterior) && ( $jcolor < $ncolor)} { incr j} {
            set d [ expr double( $j) / double( $ninterior)]
            set new_red [ expr int( 0.5 + $d * $dif_red + double( $ci_red))]
            set new_green [ expr int( 0.5 + $d * $dif_green + double( $ci_green))]
            set new_blue [ expr int( 0.5 + $d * $dif_blue + double( $ci_blue))]
            lappend lst_colores [ format #%02x%02x%02x $new_red $new_green $new_blue]
            incr jcolor
        }
    }
    
    if { $jcolor < $ncolor} {
        lappend lst_colores [ lindex $cols_pivote [ expr $n - 1]]
        incr jcolor
        if { $jcolor < $ncolor} {
            WarnWin [_ "Something happens with the colors: %1\$s - %2\$s" $jcolor $ncolor]
        }
    }
    
    return $lst_colores
}

proc rgb2hsv { r g b} {
    set h 0.0
    set s 0.0
    set v 0.0
    #  real m, rl, gl, bl;
    
    set v $r
    if { $g > $v} { set v $g}
    if { $b > $v} { set v $b}
    
    set m $r
    if { $g < $m} { set m $g}
    if { $b < $m} { set m $b}
    
    if { $v != 0} {
        set s [ expr double( $v - $m) / double( $v)]
    } else {
        set s 0.0
    }
    
    if { $s != 0.0} {
        set dm [ expr double( $v - $m)]
        if { [ expr abs( $dm)] > 1e-20} {
            #dist( color, rojo)
            set rl [ expr double( $v - $r) / double( $dm)]
            #dist( color, verde)
            set gl [ expr double( $v - $g) / double( $dm)]
            #dist( color, blue)
            set bl [ expr double( $v - $b) / double( $dm)]
        } else {
            set rl 0.0
            set gl 0.0
            set bl 0.0
        }
        if { $v == $r} {
            if { $m == $g} {
                set h [ expr 5.0 + $bl]
            } else {
                set h [ expr 1.0 - $gl]
            }
        } elseif { $v == $g} {
            if { $m == $b} {
                set h [ expr 1.0 + $rl]
            } else {
                set h [ expr 3.0 - $bl]
            }
        } else {
            if { $m == $r} {
                set h [ expr 3.0 + $gl]
            } else {
                set h [ expr 5.0 - $rl]
            }
        }
        set h [ expr $h * 60.0]
        if { $h == 360.0} { set h 0.0}
    } else { # h indefinido
        set h 0.0
    }
    
    return "$h $s $v"
}

proc hsv2rgb { h s v} {
    set r 0.0
    set g 0.0
    set b 0.0
    
    if { $h == 360.0} { set h 0.0}
    # h = 0..6;
    set h [ expr $h / 60.0]
    set i [ expr int( floor( $h))]
    set f [ expr $h - $i]
    set p1 [ expr $v * ( 1.0 - $s)]
    set p2 [ expr $v * ( 1.0 - $s * $f)]
    set p3 [ expr $v * ( 1.0 - $s * ( 1.0 - $f))]
    switch $i {
        0 {
            set r $v
            set g $p3
            set b $p1
        }
        1 {
            set r $p2
            set g $v
            set b $p1
        }
        2 {
            set r $p1
            set g $v
            set b $p3
        }
        3 {
            set r $p1
            set g $p2
            set b $v
        }
        4 {
            set r $p3
            set g $p1
            set b $v
        }
        5 {
            set r $v
            set g $p1
            set b $p2
        }
    }
    
    return "$r $g $b"
}

proc CCListaColores { tipo_mapa ncolores usermincolor usermaxcolor mapscaletype mapscaleramp usermode colorespivote} {
    set col_lst ""
    
    switch $tipo_mapa {
        "Rainbow" {
            set ncol [ expr $ncolores - 1]
            if { $ncol <= 0} { set ncol 1}
            set xfir [ expr $ncol * 0.10]
            set xqua [ expr $ncol * 0.35]
            set xmed [ expr $ncol * 0.50]
            set xthi [ expr $ncol * 0.65]
            set xlas [ expr $ncol * 0.90]
            set xdiv1 [ expr $xqua - $xfir]
            set xdiv2 [ expr $xmed - $xqua]
            
            for { set jcolor 1} { $jcolor <= $ncolores} { incr jcolor} {
                set xcolor [ expr $jcolor - 1]
                
                # Los Azules
                if { $xcolor <= $xfir } {
                    set blue [ expr 0.5 + $xcolor / ( $xfir * 2.0)]
                } elseif { $xcolor <= $xqua } {
                    set blue 1.0
                } elseif { $xcolor <= $xmed } {
                    set blue [ expr 1.0 - ( $xcolor - $xqua) / $xdiv2]
                } else { set blue 0.0 }
                
                # Los Verdes
                if { $xcolor <= $xfir } {
                    set green 0.0
                } elseif { $xcolor <= $xqua } {
                    set green [ expr ( $xcolor - $xfir) / $xdiv1]
                } elseif { $xcolor <= $xthi } {
                    set green 1.0
                } elseif { $xcolor <= $xlas } {
                    set green [ expr 1.0 - ( $xcolor - $xthi) / $xdiv1]
                } else { set green 0.0 }
                
                # I los Rohos
                if { $xcolor <= $xmed } {
                    set red 0.0
                } elseif { $xcolor <= $xthi} {
                    set red [ expr ( $xcolor - $xmed) / $xdiv2]
                } elseif { $xcolor <= $xlas} {
                    set red 1.0
                } else {
                    set red [ expr 1.0 - ( $xcolor - $xlas) / ( $xfir * 2.0)]
                }
                
                if { $red < 0.0 } { set red 0.0 }
                if { $green < 0.0 } { set green 0.0 }
                if { $blue < 0.0 } { set blue 0.0 }
                if { $red > 1.0 } { set red 1.0 }
                if { $green > 1.0 } { set green 1.0 }
                if { $blue > 1.0 } { set blue 1.0 }
                
                set red [ expr int( $red * 255.0)]
                set green [ expr int( $green * 255.0)]
                set blue [ expr int( $blue * 255.0)]
                lappend col_lst [ format #%02x%02x%02x $red $green $blue]
            }
        }
        "InvRainbow" {
            set ncol [ expr $ncolores - 1]
            if { $ncol <= 0} { set ncol 1}
            set xfir [ expr $ncol * 0.10]
            set xqua [ expr $ncol * 0.35]
            set xmed [ expr $ncol * 0.50]
            set xthi [ expr $ncol * 0.65]
            set xlas [ expr $ncol * 0.90]
            set xdiv1 [ expr $xqua - $xfir]
            set xdiv2 [ expr $xmed - $xqua]
            
            for { set jcolor 1} { $jcolor <= $ncolores} { incr jcolor} {
                set xcolor [ expr $ncolores - $jcolor]
                
                # Los Azules
                if { $xcolor <= $xfir } {
                    set blue [ expr 0.5 + $xcolor / ( $xfir * 2.0)]
                } elseif { $xcolor <= $xqua } {
                    set blue 1.0
                } elseif { $xcolor <= $xmed } {
                    set blue [ expr 1.0 - ( $xcolor - $xqua) / $xdiv2]
                } else { set blue 0.0 }
                
                # Los Verdes
                if { $xcolor <= $xfir } {
                    set green 0.0
                } elseif { $xcolor <= $xqua } {
                    set green [ expr ( $xcolor - $xfir) / $xdiv1]
                } elseif { $xcolor <= $xthi } {
                    set green 1.0
                } elseif { $xcolor <= $xlas } {
                    set green [ expr 1.0 - ( $xcolor - $xthi) / $xdiv1]
                } else { set green 0.0 }
                
                # I los Rohos
                if { $xcolor <= $xmed } {
                    set red 0.0
                } elseif { $xcolor <= $xthi} {
                    set red [ expr ( $xcolor - $xmed) / $xdiv2]
                } elseif { $xcolor <= $xlas} {
                    set red 1.0
                } else {
                    set red [ expr 1.0 - ( $xcolor - $xlas) / ( $xfir * 2.0)]
                }
                
                if { $red < 0.0 } { set red 0.0 }
                if { $green < 0.0 } { set green 0.0 }
                if { $blue < 0.0 } { set blue 0.0 }
                if { $red > 1.0 } { set red 1.0 }
                if { $green > 1.0 } { set green 1.0 }
                if { $blue > 1.0 } { set blue 1.0 }
                
                set red [ expr int( 0.5 + $red * 255.0)]
                set green [ expr int( 0.5 + $green * 255.0)]
                set blue [ expr int( 0.5 + $blue * 255.0)]
                lappend col_lst [ format #%02x%02x%02x $red $green $blue]
            }
        }
        "Terrain" {
            set pivotes_terreno "#3f5f00 #a0a000 #ffa000 #7f6f4f #fffffb"
            set col_lst [ CCCreaEscalaColores $pivotes_terreno $ncolores]
        }
        "BlackAndWhite" {
            set ncol [ expr $ncolores - 1]
            if { $ncol <= 0} { set ncol 1}
            for { set j  0} { $j < $ncolores} { incr j} {
                set d [ expr double( $j) / double( $ncol)]
                set d [ expr log10( 1.0 + 9.0 * $d) ]
                set d [ expr int( 0.5 + $d * 255.0)]
                lappend col_lst [ format \#%02x%02x%02x $d $d $d]
            }
        }
        "WhiteAndBlack" {
            set ncol [ expr $ncolores - 1]
            if { $ncol <= 0} { set ncol 1}
            for { set j  0} { $j < $ncolores} { incr j} {
                set d [ expr double( $j) / double( $ncol)]
                set d [ expr log10( 1.0 + 9.0 * $d) ]
                
                set d [ expr int( 0.5 + $d * 255.0)]
                lappend col_lst [ format \#%02x%02x%02x $d $d $d]
            }
            set col_lst [ lreverse $col_lst]
        }
        "3DAnaglyphs" {
            set pivotes_3danaglyphs "#000000 #ff00bf #aabf00 #ffffff"
            set col_lst [ CCCreaEscalaColores $pivotes_3danaglyphs $ncolores]
        }
        "3DAnaglyphs2" {
            set pivotes_3danaglyphs2 "#000000 #bf00bf #bfbf00 #bfbfbf"
            set col_lst [ CCCreaEscalaColores $pivotes_3danaglyphs2 $ncolores]
        }
        "UserDefined" {
            if { $usermode == "TwoColors" } {
                set ci_1 0.0
                set ci_2 0.0
                set ci_3 0.0
                set cf_1 0.0
                set cf_2 0.0
                set cf_3 0.0
                switch $mapscaletype {
                    RGB {
                        scan $usermincolor #%2x%2x%2x ci_1 ci_2 ci_3
                        scan $usermaxcolor #%2x%2x%2x cf_1 cf_2 cf_3
                    }
                    HSV {
                        scan $usermincolor #%2x%2x%2x r g b
                        set ci [ rgb2hsv [ expr $r / 255.0] [ expr $g / 255.0] [ expr $b / 255.0]]
                        set ci_1 [ lindex $ci 0]
                        set ci_2 [ lindex $ci 1]
                        set ci_3 [ lindex $ci 2]
                        scan $usermaxcolor #%2x%2x%2x r g b
                        set cf [ rgb2hsv [ expr $r / 255.0] [ expr $g / 255.0] [ expr $b / 255.0]]
                        set cf_1 [ lindex $cf 0]
                        set cf_2 [ lindex $cf 1]
                        set cf_3 [ lindex $cf 2]
                    }
                }
                set col_lst $usermincolor
                if { $ncolores == 1} {
                } elseif { $ncolores == 2} {
                    lappend col_lst $usermaxcolor
                } else {
                    set dif_1 [ expr $cf_1 - $ci_1]
                    set dif_2 [ expr $cf_2 - $ci_2]
                    set dif_3 [ expr $cf_3 - $ci_3]
                    set pi 3.14159265358979323846
                    set atanpi [ expr atan( $pi)]
                    set atanpi2 [ expr $atanpi + $atanpi]
                    set inv2atanpi [ expr 1.0 / $atanpi2]
                    set inv2pi [ expr 1.0 / ( $pi + $pi)]
                    for { set jcolor 0} { $jcolor < [ expr $ncolores - 1]} { incr jcolor} {
                        set d [ expr double( $jcolor) / double( $ncolores - 2)]
                        switch "[ string tolower $mapscaleramp]" {
                            "arctangent" {
                                set d [ expr atan( $pi * ( $d + $d - 1.0)) * $inv2atanpi + 0.5]
                            }
                            "tangent" {
                                set d [ expr tan( $atanpi * ( $d + $d - 1.0)) * $inv2pi + 0.5]
                            }
                            "linear" {
                            }
                        }
                        set new_1 [ expr $d * $dif_1 + $ci_1]
                        set new_2 [ expr $d * $dif_2 + $ci_2]
                        set new_3 [ expr $d * $dif_3 + $ci_3]
                        if { "$mapscaletype" == "HSV"} {
                            set new [ hsv2rgb $new_1 $new_2 $new_3]
                            set new_1 [ expr int( 0.5 + 255.0 * [ lindex $new 0])]
                            set new_2 [ expr int( 0.5 + 255.0 * [ lindex $new 1])]
                            set new_3 [ expr int( 0.5 + 255.0 * [ lindex $new 2])]
                        } else {
                            set new_1 [ expr int( $new_1)]
                            set new_2 [ expr int( $new_2)]
                            set new_3 [ expr int( $new_3)]
                        }
                        lappend col_lst [ format #%02x%02x%02x $new_1 $new_2 $new_3]
                    }
                }
            } else {
                # $usermode == "Design"
                set col_lst [ CCCreaEscalaColores $colorespivote $ncolores]
            }
        }
    }
    return $col_lst
}


proc CCActualizaCanvas { } {
    global ContourColors
    
    after cancel CCActualizaCanvas
    
    set w $ContourColors(Window)
    if { ![winfo exists $w] } return
    
    if { $ContourColors(NumeroColores) == 0} {
        return
    }
    #set color_fondo [ CCGetRGB $w [ $w cget -background]]
    set colores [ CCListaColores $ContourColors(ColorMapType) $ContourColors(NumeroColores) \
            $ContourColors(UserMinColor) $ContourColors(UserMaxColor) $ContourColors(MapScaleType) \
            $ContourColors(MapScaleRamp) $ContourColors(UserMode) $ContourColors(ColoresPivote)]   
    
    set canvas_ampliado 0
    if { $ContourColors(ColorMapType) == "UserDefined" && $ContourColors(UserMode) == "Design" } {
        # this is user defined map with key colors
        set canvas_ampliado 1
        # $ContourColors(canvasColours) configure -width 50
        # first time user modifies it, don't update key colour values
        set ContourColors(FirstTimePivotValues) 1
    } else {
        # $ContourColors(canvasColours) configure -width 50
        set x_off 25
        # these are the other modes: standars maps or user 2 colour maps
        # try to actualize key values with selected ones, so that the first time user selects
        # the design scale it does have nicer values
        if { ![ info exists ContourColors(FirstTimePivotValues)] || !$ContourColors(FirstTimePivotValues)} {
            set num_key_cols [ llength $ContourColors(ColoresPivote)]
            set num_key_cols 7
            set num_cols [ llength $colores]
            set istep [ expr $num_cols / ( $num_key_cols - 1)]
            set ContourColors(ColoresPivote) {}
            if { $istep > 0} {
                for { set idx 0} { $idx < $num_cols} { incr idx $istep} {
                    lappend ContourColors(ColoresPivote) [ lindex $colores $idx]
                }
            } else {
                # less than 6 colors
                for { set idx 0} { $idx < $num_cols} { incr idx} {
                    lappend ContourColors(ColoresPivote) [ lindex $colores $idx]
                }
            }
            set ContourColors(FirstTimePivotValues) 0
        }
    }
    
    # limpiamos
    $ContourColors(canvasColours) delete all
    
    set hcanvas [ $ContourColors(canvasColours) cget -height]
    set wcanvas [ $ContourColors(canvasColours) cget -width]
    # WarnWinText "canvas $ContourColors(canvasColours) = $wcanvas x $hcanvas"
    # $ContourColors(canvasColours) create rectangle 2.5 2.5 [ expr $wcanvas * 0.8] [ expr $hcanvas * 0.8] -fill blue
    
    # for { set hcolor 0} { [ expr $hcolor * $ContourColors(NumeroColores)] < $hcanvas} { incr hcolor} {
        # }
    # if { $hcolor > 0} { set hcolor [ expr $hcolor - 1]}
    set margin 15
    set hcolor [ expr ( double( $hcanvas - $margin)) / double( $ContourColors(NumeroColores))]
    #WarnWinText "hcolor = $hcolor"
    set hoff [ expr int( 0.5 + ( $hcanvas - $hcolor * $ContourColors(NumeroColores)) * 0.5)]
    
    # WarnWinText "$hcanvas > $hcolor * $ContourColors(NumeroColores) + $hoff"
    
    set wcolor 15
    set woff 0
    if { $canvas_ampliado } {
        ## tambien hay que dibujar los pivotes
        if { $wcanvas <= 50} {
            set woff [ expr $wcanvas - $wcolor - 4]
        } else {
            set woff [ expr 50 - $wcolor - 4]
        }
    } else {
        ## solo la leyenda
        set woff [ expr 6 + $x_off]
    }
    
    set ncol [ llength $colores]
    
    for { set icol 0} { $icol < $ncol } { incr icol} {
        set color_relleno [ lindex $colores [ expr $ncol - $icol - 1]]
        $ContourColors(canvasColours) create rectangle \
            $woff [ expr $hoff + $icol * $hcolor] \
            [ expr $woff + $wcolor] [ expr $hoff + ( $icol + 1) * $hcolor] \
            -fill $color_relleno -outline ""
    }
    
    # to design the colour scale
    if { $canvas_ampliado } {
        ## pintar colores pivote
        set n [ llength $ContourColors(ColoresPivote)]
        set tam_piv 10
        
        set woff [ expr $woff - 10 - $tam_piv]
        
        set h_min_piv $hoff
        set h_max_piv [ expr $hoff + $ncol * $hcolor]
        
        #set pivotes_id ""
        
        if { [ expr ( $n + 1) * $tam_piv] >= $hcanvas} {
            # there are mor pivots * size than space in canvas
            for { set hcolor 0} { [ expr $hcolor * $n] < $hcanvas} { incr hcolor} {
            }
            if { $hcolor > 0} { set hcolor [ expr $hcolor - 1]}
            set hoff [ expr int( 0.5 + ( $hcanvas - $hcolor * $n) * 0.5)]
            
            for { set icol 0} { $icol < $n } { incr icol} {
                set color_relleno [ lindex $ContourColors(ColoresPivote) [ expr $n - $icol - 1]]
                # lappend pivotes_id [ $ContourColors(canvasColours) create rectangle \
                    #         $woff [ expr $hoff + $icol * $hcolor] \
                    #         [ expr $woff + $tam_piv] [ expr $hoff + ( $icol + 1) * $hcolor] \
                    #         -fill $color_relleno -outline ""]
            }
            
        } else {
            set hpiv [ expr $h_max_piv - $h_min_piv - $tam_piv]
            set hdif [ expr double( $hpiv) / double( $n - 1.0)]
            set hoff $h_min_piv
            for { set icol 0} { $icol < $n } { incr icol} {
                set color_relleno [ lindex $ContourColors(ColoresPivote) [ expr $n - $icol - 1]]
                set id_col [ $ContourColors(canvasColours) create rectangle \
                        $woff [ expr $hoff + $icol * $hdif] \
                        [ expr $woff + $tam_piv] [ expr $hoff + $icol * $hdif + $tam_piv] \
                        -fill $color_relleno -outline  $color_relleno]
                #lappend pivotes_id $id_col
                $ContourColors(canvasColours) bind $id_col <Any-Enter> \
                    "$ContourColors(canvasColours) itemconfig current -outline white"
                $ContourColors(canvasColours) bind $id_col <Any-Leave> \
                    "$ContourColors(canvasColours) itemconfig current -outline $color_relleno"
                $ContourColors(canvasColours) bind $id_col <1> \
                    "CCCambiaColorPivote $w [ expr $n - $icol - 1] $id_col"
            }
        }
        
        # add and remove pivot buttons
        
        set tam_bot 20.0
        set tam_bot_2 [ expr $tam_bot * 0.5]
        set woff [ expr $woff - 12 - $tam_bot]
        
        set hbot [ expr $hcanvas]
        set hdif [ expr double( $hbot) / 3.0]
        set hoff [ expr $hdif - $tam_bot_2]
        
        if { 0} {
            
            ## boton mas
            if { [ winfo exists $ContourColors(canvasColours).mas]} { destroy  $ContourColors(canvasColours).mas}
            if { ![ info exists ContourColors(mas_bitmap)] } {
                # mas invertido
                # set ContourColors(mas_bitmap) [ image create bitmap -data {
                    #     #define boton_mas_width 15
                    #     #define boton_mas_height 15
                    #     static unsigned char boton_mas_bits[] = {
                        #           0x00, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0xfc, 0x1f, 0x7c, 0x1f, 0x7c, 0x1f,
                        #           0x7c, 0x1f, 0x0c, 0x18, 0x7c, 0x1f, 0x7c, 0x1f, 0x7c, 0x1f, 0xfc, 0x1f,
                        #           0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00};
                    #     }  -foreground red]
                # mas normal
                set ContourColors(mas_bitmap) [ image create bitmap -data {
                        #define boton_mas_width 15
                        #define boton_mas_height 15
                        static unsigned char boton_mas_bits[] = {
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00,
                            0x80, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
                    }  -foreground red]
            }
            ttk::button $ContourColors(canvasColours).mas -image $ContourColors(mas_bitmap) \
                -command "CCAnyadeColorPivote"
            
            $ContourColors(canvasColours) create window $woff $hoff -anchor nw -window $ContourColors(canvasColours).mas
            
            # set mas_base [ $ContourColors(canvasColours) create rectangle \
                #           $woff $hoff \
                #           [ expr $woff + $tam_bot] [ expr $hoff + $tam_bot] \
                #           -fill black -outline ""]
            #
            # set mas_rect [ $ContourColors(canvasColours) create rectangle \
                #           [ expr $woff + 1] [ expr $hoff + 1] \
                #           [ expr $woff + $tam_bot - 2] [ expr $hoff + $tam_bot - 2] \
                #           -outline $color_fondo]
            #
            # set mas_line_1 [ $ContourColors(canvasColours) create line \
                #           [ expr $woff + 4] [ expr $hoff + $tam_bot_2] \
                #           [ expr $woff + $tam_bot - 4] [ expr $hoff + $tam_bot_2] \
                #           -fill $color_fondo]
            #
            # set mas_line_2 [ $ContourColors(canvasColours) create line \
                #           [ expr $woff + $tam_bot_2 - 1.0] [ expr $hoff + 4] \
                #           [ expr $woff + $tam_bot_2 - 1.0] [ expr $hoff + $tam_bot - 4] \
                #           -fill $color_fondo]
            #
            # foreach id_tag "$mas_rect $mas_line_1 $mas_line_2" {
                #     $ContourColors(canvasColours) bind $id_tag <Any-Enter> \
                    #               "$ContourColors(canvasColours) itemconfig $mas_rect -outline white; \
                    #               $ContourColors(canvasColours) itemconfig $mas_line_1 -fill white; \
                    #               $ContourColors(canvasColours) itemconfig $mas_line_2 -fill white;"
                #     $ContourColors(canvasColours) bind $id_tag <Any-Leave> \
                    #               "$ContourColors(canvasColours) itemconfig $mas_rect -outline $color_fondo; \
                    #               $ContourColors(canvasColours) itemconfig $mas_line_1 -fill $color_fondo; \
                    #               $ContourColors(canvasColours) itemconfig $mas_line_2 -fill $color_fondo;"
                # }
            
            ## boton menos
            if { [ winfo exists $ContourColors(canvasColours).menos]} { destroy  $ContourColors(canvasColours).menos}
            if { ![ info exists ContourColors(menos_bitmap)] } {
                # menos invertido
                # set ContourColors(menos_bitmap) [ image create bitmap -data {
                    #     #define boton_menos_width 15
                    #     #define boton_menos_height 15
                    #     static unsigned char boton_menos_bits[] = {
                        #           0x00, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f,
                        #           0xfc, 0x1f, 0x0c, 0x18, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f, 0xfc, 0x1f,
                        #           0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00};
                    #     } -foreground blue]
                # menos normal
                set ContourColors(menos_bitmap) [ image create bitmap -data {
                        #define boton_menos_width 15
                        #define boton_menos_height 15
                        static unsigned char boton_menos_bits[] = {
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                            0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
                    } -foreground blue]
            }
            ttk::button $ContourColors(canvasColours).menos -image $ContourColors(menos_bitmap) \
                -command "CCQuitaColorPivote"
            
            $ContourColors(canvasColours) create window $woff [ expr $hoff + $hdif] -anchor nw -window $ContourColors(canvasColours).menos
            
            # $ContourColors(canvasColours) create rectangle \
                #           $woff [ expr $hoff + $hdif] \
                #           [ expr $woff + $tam_bot] [ expr $hoff + $hdif + $tam_bot] \
                #           -fill black -outline ""
            #
            # set menos_rect [ $ContourColors(canvasColours) create rectangle \
                #           [ expr $woff + 1] [ expr $hoff + $hdif + 1] \
                #           [ expr $woff + $tam_bot - 2] [ expr $hoff + $hdif + $tam_bot - 2] \
                #           -outline $color_fondo]
            #
            # set  menos_line [ $ContourColors(canvasColours) create line \
                #           [ expr $woff + 4] [ expr $hoff + $tam_bot_2] \
                #           [ expr $woff + $tam_bot - 4] [ expr $hoff + $tam_bot_2] \
                #           -fill $color_fondo]
            
            
        }
    }
    
}

proc CCAnyadeColorPivote { } {
    global ContourColors
    
    lappend ContourColors(ColoresPivote) #808080
    incr ContourColors(NumPivotes)
    CCActualizaCanvas
    ColourMapSetAcceptState normal
}

proc CCNumPivotesChange { op name1 name2} {
    global ContourColors
    
    if { "$ContourColors(NumPivotes)" == ""} { return}
    
    set l [ llength $ContourColors(ColoresPivote)]
    
    if { $ContourColors(NumPivotes) < 3} {
        set ContourColors(NumPivotes) 3
        bell
        return
    }
    
    if { $ContourColors(NumPivotes) > $l} {
        after cancel CCActualizaCanvas
        for { set i $l } { $i < $ContourColors(NumPivotes)} { incr i} {
            lappend ContourColors(ColoresPivote) #808080
        }
        after 1500 CCActualizaCanvas
    } elseif { $ContourColors(NumPivotes) < $l} {
        after cancel CCActualizaCanvas
        set ContourColors(ColoresPivote) [ lrange $ContourColors(ColoresPivote) 0 [ expr $ContourColors(NumPivotes) - 1]]
        after 1500 CCActualizaCanvas
    }
    
}

proc CCQuitaColorPivote { } {
    global ContourColors
    
    if { [ llength $ContourColors(ColoresPivote)] > 3} {
        set ContourColors(ColoresPivote) [ lrange $ContourColors(ColoresPivote) 0 [ expr [ llength $ContourColors(ColoresPivote)] - 2]]
        
        set ContourColors(NumPivotes) [ expr $ContourColors(NumPivotes) - 1]
        CCActualizaCanvas
        
        ColourMapSetAcceptState normal
    } else {
        bell
    }
}

proc CCCambiaColorPivote { w num_pivote tag_pivote} {
    global ContourColors
    
    set color_viejo [ $ContourColors(canvasColours) itemcget $tag_pivote -fill]
    # set color_nuevo [ tk_chooseColor -parent $ContourColors(canvasColours) -initialcolor $color_viejo]
    set color_nuevo [ GIDChooseColor $ContourColors(canvasColours).mc \
                          -color $color_viejo -parent $w]
    
    if { "$color_nuevo" != ""} {
        set n [ scan $color_nuevo \#%2x%2x%2x r g b]
        if { $n == 3} {
            $ContourColors(canvasColours) itemconfig $tag_pivote -fill $color_nuevo
            #WarnWinText "$ContourColors(ColoresPivote)"
            #WarnWinText "$num_pivote -> $color_nuevo"
            set new_lst ""
            set np [ llength $ContourColors(ColoresPivote)]
            for { set ip 0 } { $ip < $np} { incr ip} {
                if { $ip != $num_pivote} {
                    lappend new_lst [ lindex $ContourColors(ColoresPivote) $ip]
                } else {
                    lappend new_lst $color_nuevo
                }
            }
            set ContourColors(ColoresPivote) $new_lst
            #WarnWinText "$ContourColors(ColoresPivote)"
            after 1500 CCActualizaCanvas
            
            ColourMapSetAcceptState normal
        }
    }
}

proc CCActualizeColourMapList { } {
    array set ::ColourMapList [ GiD_Info postprocess get colour_map_list]
    
    set w $::ContourColours(ColourMapListW)
    $w configure -labels [ array names ::ColourMapList] \
        -values [ array names ::ColourMapList]
}

proc ColourMapGetAction { w} {
    if { $::ContourColors(ColorMapType) != "UserDefined" } {
        return
    }
    if { [ info exists ::ColourMapList($::ContourColors(ColourMapName))]} {
        set old $::ContourColors(lista_user_map_estado)
        set ::ContourColors(lista_user_map_estado) {}
        GiD_Process escape escape escape escape Results ContOptions ColorRamp GetMap $::ContourColors(ColourMapName)
        CCInitValues
        # for the terrain map, 3d anaglyphs color maps
        set ::ContourColors(ColorMapType) "UserDefined"
        CCActualizaCanvas
        set ::ContourColors(lista_user_map_estado) $old
        
        ColourMapSetAcceptState disabled
    } else {
        ColourMapSetAcceptState normal
    }
}

proc ColourMapAddAction { w} {   
    set ::ContourColors(ColourMapName) ""
}

proc ColourMapAcceptAction { w { do_accept 1}} {
    # if already exists, delete it
    if { [ info exists ::ColourMapList($::ContourColors(ColourMapName))]} {
        GiD_Process escape escape escape escape Results ContOptions ColorRamp DeleteMap $::ContourColors(ColourMapName) Yes
    }
    if { $do_accept} {
        # accept defined colours, calls ColourMapAcceptAction with do_accept = 0
        CCAceptar $w
        GiD_Process escape escape escape escape Results ContOptions ColorRamp SetMapName $::ContourColors(ColourMapName)
        GiD_Process escape escape escape escape Results ContOptions ColorRamp SaveMap
        CCActualizeColourMapList
        ColourMapSetAcceptState disabled
    }
}

proc ColourMapDeleteAction { w} {
    if { [ info exists ::ColourMapList($::ContourColors(ColourMapName))]} {
        set resp [MessageBoxOptionsButtons [_ "Confirmation"] \
                [_ "Should the colourmap '%s' be deleted?" $::ContourColors(ColourMapName)] \
                {yes no} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
        if { $resp == "yes"} {
            GiD_Process escape escape escape escape Results ContOptions ColorRamp DeleteMap $::ContourColors(ColourMapName) Yes
            CCInitValues
            CCActualizeColourMapList
            # select first from list
            set first_cm [ lindex [ array names ::ColourMapList] 0]
            set ::ContourColors(ColourMapName) $first_cm
            ColourMapGetAction $w
        }
    }
}

proc ColourMapSetAcceptState { { state disabled}} {
    if { $state == "disabled"} {
        $::ContourColours(ColourMapUpdateW) configure -state disabled
    } else {
        $::ContourColours(ColourMapUpdateW) configure -state normal
    }
}

proc ContourColorsResizeCanvas { w canvas width height} {
    
    bind $w <Configure> ""
    
    $canvas configure -height $height
    
    update idletasks
    
    CCActualizaCanvas
    
    bind $w <Configure> "ContourColorsResizeCanvas %W $canvas %w %h"
}

proc CCClose { w } {
    set ::ContourColors(FirstTimePivotValues) 0
}

# args is needed because it's called from the preferences window
proc PostContourColors { { w .gid.wContourColors} {new_colormap_type {User defined}} args } {
    global ContourColors GIDDEFAULT
    
    InitWindow2 $w -title [_ "Contour colors"] \
        -geometryvariable PostContourColorsWindowGeom \
        -initcommand PostContourColors \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    
    set ContourColors(Window) $w
    
    catch {
        trace vdelete ContourColors(NumeroColores) w CCNumColsChange
        trace vdelete ContourColors(ColorMapType) w CCColorMapTypeChange
        trace vdelete ContourColors(UserMode) w CCColorMapUserModeChange
        trace vdelete ContourColors(UserMinColor) w CCColorUserMapChange
        trace vdelete ContourColors(UserMaxColor) w CCColorUserMapChange
        trace vdelete ContourColors(MapScaleType) w CCColorUserMapChange
        trace vdelete ContourColors(MapScaleRamp) w CCColorUserMapChange
        trace vdelete ContourColors(NumPivotes) w CCNumPivotesChange
    }
    
    CCInitValues

    set lst_colormap_type_labels [list [_ "Rainbow"] [_ "Inv. rainbow"] [_ "Terrain"] [_ "Black/white"] [_ "White/black"] \
                                      [_ "3D Anaglyphs"] [_ "3D Anaglyphs 2"] [_ "User defined"]]
    set lst_colormap_type_values [ list "Rainbow" "InvRainbow" "Terrain" "BlackAndWhite" "WhiteAndBlack" \
                                       "3DAnaglyphs" "3DAnaglyphs2" "UserDefined"]
    if { [ lsearch $lst_colormap_type_values $new_colormap_type] == -1} {
        set new_colormap_type ""
    }
    
    
    ttk::frame $w.basico -style ridge.TFrame
    
    set color_fondo [ CCGetRGB $w [ $w cget -background]]
    
    # Number of colors
    ttk::frame $w.basico.nc -style groove.TFrame
    ttk::label $w.basico.nc.num_cols_txt -text [_ "Number of colors: "]
    ttk::entry $w.basico.nc.num_cols -width 4 -textvariable ContourColors(NumeroColores)
    
    
    grid $w.basico.nc.num_cols_txt $w.basico.nc.num_cols -pady 4 -padx 4 -sticky wn
    set ContourColors(NumeroColoresEntry) $w.basico.nc.num_cols
    
    GidHelp $w.basico.nc [_ "The color map for contours will use this amount of colors"]
        
    # Color map
    ttk::frame $w.basico.cm -style groove.TFrame
    
    # left part
    ttk::frame $w.basico.cm.left
    set f_left $w.basico.cm.left
    
    ttk::frame $f_left.map  
    ttk::label $f_left.map.txt -text [_ "Color map"]:
    TTKComboBox $f_left.map.om -textvariable ::ContourColors(ColorMapType) \
        -labels $lst_colormap_type_labels \
        -values $lst_colormap_type_values \
        -state readonly
    if { ![ info exists ::ContourColors(ColorMapType)] } {
        set ::ContourColors(ColorMapType) [ lindex $lst_colormap_type_values 0]
    }
    if { $new_colormap_type != ""} {
        set ::ContourColors(ColorMapType) $new_colormap_type
    }
    
    $f_left.map.om configure -width 11
    grid $f_left.map.txt $f_left.map.om -pady 2 -padx 4 -sticky wn
    
    GidHelp $f_left.map [_ "Type of color map to be used for contours: \n \
            four predefined ones and one customizable"]
    
    # right part
    ttk::frame $w.basico.cm.right   
    set f_right $w.basico.cm.right
        
    canvas $f_right.c -width 50 -height 180
    grid  $f_right.c -sticky nws
    grid rowconfigure $f_right 0 -weight 1
    grid columnconfigure $f_right 0 -weight 1
    set ContourColors(canvasColours) $f_right.c
    
    GidHelp $f_right [_ "Preview of the contour map which interactivelly shows the changes \
            on the options in this window. \n \
            Changes will only be used after pressing the 'Apply' button.\
            In 'Design' mode, the 'Key colors' can also be defined just clicking over them."]
    
    ttk::frame $f_left.bas -padding 0
    ttk::radiobutton $f_left.bas.dos_colores_1 -text [_ "Two colors scale"]: -variable ContourColors(UserMode) \
        -value TwoColors -command "CCActualizaCanvas"
    
    GidHelp $f_left.bas.dos_colores_1 [_ "The 'User defined' color map will be defined by two colors"]

    if { ![info exists ContourColors(UserMaxColor)] || $ContourColors(UserMaxColor) == "" } {
        set ContourColors(UserMaxColor) \#800000
    }    
    if { ![info exists ContourColors(UserMinColor)] || $ContourColors(UserMinColor) == "" } {
       set ContourColors(UserMinColor) \#000080
    }
    ttk::frame $f_left.bas.max
    ttk::label $f_left.bas.max.txt -text [_ "Max"]:
    LabelButton $f_left.bas.max.b -command [list CCCambiaColor $f_left.bas.max.b ContourColors(UserMaxColor)] \
        -borderwidth 1 -background $ContourColors(UserMaxColor)      
    
    $f_left.bas.max.b configure -width 3
    grid $f_left.bas.max.txt -row 0 -column 0 -pady 2 -padx 4 -sticky en
    grid $f_left.bas.max.b -row 0 -column 1 -pady 2 -padx 4 -sticky en
    
    GidHelp $f_left.bas.max [_ "Selection of the Maximum color for the \
            'Two colors' 'User defined' contour color map"]
    
    ttk::frame $f_left.bas.min
    ttk::label $f_left.bas.min.txt -text [_ "Min"]:
    LabelButton $f_left.bas.min.b -command [list CCCambiaColor $f_left.bas.min.b ContourColors(UserMinColor)] \
        -borderwidth 1 -background $ContourColors(UserMinColor) 
    
    
    $f_left.bas.min.b configure -width 3
    grid $f_left.bas.min.txt -row 0 -column 0 -pady 2 -padx 4 -sticky en
    grid $f_left.bas.min.b -row 0 -column 1 -pady 2 -padx 4 -sticky en
    
    GidHelp $f_left.bas.min [_ "Selection of the Minimum color for the \
            'Two colors' 'User defined' contour color map" ]
    
    TTKComboBox $f_left.bas.om -textvariable ::ContourColors(MapScaleType) \
        -labels [list "RGB" "HSV"] \
        -values {"RGB" "HSV"} \
        -state readonly
    if { ![ info exists ::ContourColors(MapScaleType)]} {
        set ::ContourColors(MapScaleType) [ lindex [ $f_left.bas.om cget -values] 0]
    }
    
    
    GidHelp $f_left.bas.om [_ "Type of color 'interpolation' between the two choosen ones: \n\
            HSV: a rotation along the colors according the HSV convention, \n\
            RGB: a gradual change of the Red, Green and Blue components."]
       
    TTKComboBox $f_left.bas.om2 -textvariable ::ContourColors(MapScaleRamp) \
        -labels [list [_ "Linear"] [_ "Tangent"] [_ "ArcTangent"]] \
        -values {"Linear" "Tangent" "ArcTangent"} \
        -state readonly
    if { ![ info exists ::ContourColors(ColorScaleRamp)]} {
        set ::ContourColors(ColorScaleRamp) [ lindex [ $f_left.bas.om2 cget -values] 0]
    }
    
    
    GidHelp $f_left.bas.om2 [_ "Distribution of the colors between the two choosen ones: \n\
            Linear: colors distributed uniformly, \n\
            Tangent: colors concentrated in the middle of the 'interpolation', \n\
            ArcTangent: colors concentrated in the ends. \n"]
        
    set ContourColors(lista_dos_colores_colores) "$f_left.bas.max.txt $f_left.bas.min.txt"
    set ContourColors(lista_dos_colores_estado) "$f_left.bas.max.b $f_left.bas.min.b $f_left.bas.om $f_left.bas.om2"
    
    # gridding two colors scale
    grid $f_left.bas.dos_colores_1 -row 0 -column 0 -padx 4 -pady 2 -sticky wn  -columnspan 2
    grid $f_left.bas.max -row 1 -column 1 -padx 4 -pady 2 -sticky en
    grid $f_left.bas.min -row 2 -column 1 -padx 4 -pady 2 -sticky en
    grid $f_left.bas.om -row 1 -column 0 -pady 2 -padx 4 -sticky en -padx 4
    grid $f_left.bas.om2 -row 2 -column 0  -pady 2 -padx 4 -sticky en -padx 4
    
    ttk::frame $f_left.avz -padding 0
    ttk::radiobutton $f_left.avz.dos_colores_2 -text [_ "Design"]: -variable ContourColors(UserMode) \
        -value Design -command "CCActualizaCanvas"
    ttk::label $f_left.avz.avanzado -text [_ "Key colors"]:
    UpDownEntry $f_left.avz.e -variable ContourColors(NumPivotes)\
        -up-command "CCAnyadeColorPivote" -down-command "CCQuitaColorPivote" \
        -entry-options "-width 4"
    
    ttk::frame $f_left.avz.col_map
    TTKComboBox $f_left.avz.col_map.list \
        -labels [ array names ::ColourMapList] \
        -values [ array names ::ColourMapList] \
        -textvariable ::ContourColors(ColourMapName) \
        -state normal \
        -width 10 \
        -modifycmd "ColourMapGetAction $w"
    set ::ContourColours(ColourMapListW) $f_left.avz.col_map.list
    
    ttk::button $f_left.avz.col_map.add -image [gid_themes::GetImage Mas.png small_icons] \
        -command "ColourMapAddAction $w"
    ttk::button $f_left.avz.col_map.del -image [gid_themes::GetImage Menos.png small_icons] \
        -command "ColourMapDeleteAction $w"
    ttk::button $f_left.avz.col_map.acp -image [gid_themes::GetImage ok.png small_icons] \
        -command "ColourMapAcceptAction $w"
    grid $f_left.avz.col_map.list \
        $f_left.avz.col_map.add $f_left.avz.col_map.del $f_left.avz.col_map.acp \
        -padx 0 -pady 0 -sticky w
    grid configure $f_left.avz.col_map.list -sticky ew
    
    set ::ContourColours(ColourMapUpdateW) $f_left.avz.col_map.acp
    ColourMapSetAcceptState disabled
    
    grid $f_left.avz.dos_colores_2 -row 0 -column 0 -sticky wn -pady 2 -padx 4
    grid $f_left.avz.avanzado -row 0 -column 1 -sticky en -pady 2
    grid $f_left.avz.e -row 0 -column 2 -sticky en -pady 2 -padx 2
    grid $f_left.avz.col_map -sticky ew -padx 2 -columnspan 3
    
    grid columnconfigure $f_left.avz 1 -weight 1
    grid columnconfigure $f_left.avz 2 -weight 1
    grid rowconfigure $f_left.avz 0 -weight 1
    grid rowconfigure $f_left.avz 1 -weight 1
    
    GidHelp $f_left.avz.e [_ "Number of colors to be used as 'Key colors' \
            in the 'Design' 'User defined' contour color map."]
    
    GidHelp $f_left.avz [_ "The 'User defined' color map \
            will be defined by several 'Key colors', which can be choosed by the user. \
            These 'Key colors' are equally spaced along the map."]
    
    set ContourColors(desing_colors) "$f_left.avz.avanzado"
    set ContourColors(desing_states) "$f_left.avz.e"    
    
    grid $f_left.map -row 0 -column 0 -padx 4 -pady 2 -sticky wn
    grid $f_left.bas -row 1 -column 0 -padx 4 -pady 2 -sticky wn
    grid $f_left.avz -row 2 -column 0 -padx 4 -pady 2 -sticky ewn
    
    grid rowconfigure $f_left 2 -weight 1
    grid columnconfigure $f_left 0 -weight 1
    
    grid $f_left -row 0 -column 0 -padx 4 -pady 2 -sticky new
    grid $f_right -row 0 -column 1 -padx 4 -pady 2 -sticky nws
    
    grid rowconfigure $w.basico.cm 0 -weight 1
    grid columnconfigure $w.basico.cm 0 -weight 1
    grid columnconfigure $w.basico.cm 1 -weight 1
    
    set ContourColors(lista_user_map_estado) \
        [ list $f_left.bas.dos_colores_1 $f_left.avz.dos_colores_2 \
            $f_left.avz.col_map.list $f_left.avz.col_map.add \
            $f_left.avz.col_map.del $f_left.avz.col_map.acp]
    
    
    grid $w.basico.nc -sticky nwe
    grid $w.basico.cm -sticky nwes
    
    grid rowconfigure $w.basico 1 -weight 1
    grid columnconfigure $w.basico 0 -weight 1
    
    ####################################
    ### Botones
    ####################################
    
    ttk::frame $w.botones -style BottomFrame.TFrame
    ttk::button $w.botones.aceptar -text [_ "Apply"] -command "CCAceptar $w" -style BottomFrame.TButton
    ttk::button $w.botones.reset -text [_ "Reset"] -command "CCResetValores $w" -style BottomFrame.TButton
    ttk::button $w.botones.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton
    
    GidHelp $w.botones.aceptar [_ "The color map defined in this window will be used \
            when contours, isosurfaces, etc. are displayed."]
    
    GidHelp $w.botones.reset [_ "Values of this window will be restored to the ones used \
            before the window was openned."]
    
    GidHelp $w.botones.close [_ "The window will be closed losing the changes made but not applied."]
    
    grid $w.botones.aceptar $w.botones.reset $w.botones.close -pady 10 -padx 4 -sticky ews
    
    grid $w.basico -sticky wens -pady 4 -padx 4
    grid $w.botones -sticky sew
    grid anchor $w.botones center
    
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1
    
    focus $w.basico.nc.num_cols
    
    trace variable ContourColors(NumeroColores) w CCNumColsChange
    trace variable ContourColors(ColorMapType) w CCColorMapTypeChange
    trace variable ContourColors(UserMode) w CCColorMapUserModeChange
    trace variable ContourColors(UserMinColor) w CCColorUserMapChange
    trace variable ContourColors(UserMaxColor) w CCColorUserMapChange
    trace variable ContourColors(MapScaleType) w CCColorUserMapChange
    trace variable ContourColors(MapScaleRamp) w CCColorUserMapChange
    trace variable ContourColors(NumPivotes) w CCNumPivotesChange
    
    set ContourColors(NumeroColores) $ContourColors(NumeroColores)
    set ContourColors(UserMode) $ContourColors(UserMode)
    set ContourColors(ColorMapType) $ContourColors(ColorMapType)
    
    bind $w <Destroy> [list +CCClose $w] ;# + to add to previous script
    
    focus $w.botones.aceptar
    
    # to actualize button state's and combobox entry
    set ::ContourColors(ColourMapName) $::ContourColors(ColourMapName)
    
    after idle [list bind $f_right <Configure> "ContourColorsResizeCanvas %W $::ContourColors(canvasColours) %w %h"]
    
}

