# ConfigureProgram -*- TCL -*-
#----------------------Configuration section-----------------------------

# set to 0 to show the upper-right login button
set ::GID_LOGIN_HIDE 0
# set to 1 to mount data manager share as local folder & direct http upload and download & gui preferences
# set to 2 to only use direct http upload and download
set ::GID_ENABLE_DATAMANAGER 1
# set ::GID_ENABLE_DATAMANAGER 1
# set ::GID_ENABLE_DATAMANAGER 2
set ::GID_USER_PREFERENCES_CLOUD 0
if { $::GID_USER_PREFERENCES_CLOUD == 0 } {
	GiD_Set Cloud(SynchronizePreferences) 0
}
# ::GID_USER_PREFERENCES_CLOUD 0 to hide the variable of preferences in cloud in preferences window, and consider as 0
# if ::GID_ENABLE_DATAMANAGER==1 nexcloud is used for storage and map a network unit to access
# if ::GID_ENABLE_DATAMANAGER==2 use directly WebDav acces to storage

# name of the game
set ::GidPriv(ProgName,Default) GiD
set ::GidPriv(ProgVersion,Default) [GiD_Info gidversion]
set ::GidPriv(Organization,Default) "CIMNE - International Center for Numerical Methods in Engineering"

# web page of the program
# needs http:// for VisitWeb to work in Linux
set ::GidPriv(ProgWeb,Default) "https://www.gidsimulation.com"
# web page to obtain a password to register the program
set ::GidPriv(PassWeb,Default) "https://www.gidsimulation.com/password"
set ::GidPriv(WebDownload,Default) "https://www.gidsimulation.com/downloads"
set ::GidPriv(WebForum,Default) "https://forum.gidsimulation.com"
set ::GidPriv(WebDownloadsDirect,Default) "https://downloads.gidsimulation.com"

set ::GidPriv(WebLinkColour,Default) \#0000ff
# contact mail
set ::GidPriv(ContactMail,Default) "gid@cimne.upc.edu"

#similar but related to the problemtype
set ::GidPriv(ProblemtypeWeb,Default) $::GidPriv(ProgWeb,Default)
set ::GidPriv(ProblemtypeWebPassword,Default) $::GidPriv(PassWeb,Default)
set ::GidPriv(ProblemtypeWebDownload,Default) $::GidPriv(WebDownload,Default)
set ::GidPriv(ProblemtypeWebDownloadsDirect,Default) $::GidPriv(WebDownloadsDirect,Default)
set ::GidPriv(ProblemtypeContactMail,Default) $::GidPriv(ContactMail,Default)

# used by Quantech problem-types ( Incremental.gid)
set ::GidPriv(Texturas) 1

#to change in the help->About, the showed internal GiD version number
#for another alternative text version of a particular developer
#(e.g set ::GidPriv(TextOfVersion) "MyProgram 4.0" )
set ::GidPriv(TextOfVersion,Default) ""


#images to be customized:

set ::GidPriv(SplashWindow) GiDsplash.png ;#used in the splash window        
set ::GidPriv(AboutWindow) about.png ;# used in the about window (also ::GidPriv(AboutWindow)_grey.png)

set ::GidPriv(InfoGiDBitmapName) info_gid.png ;#used in the standar toolbar, on the upper-right corner, to show the password status
#are expected three more images for the status {a p t} info_gid_{status}.png  ,for evaluation (academic), professional or temporal

set ::GidPriv(InfoGiDProc) "CreateGiDInfo_win" ;#procedure to invoke when clicking the previous image
set ::GidPriv(FolderGiDBitmapName) GiDdirectory.png ;#used in the file browser and register problem type window

# now for printed and screen capture images it is used: resources/textures/GiDlogo.png ( hi-res logo) and GiDlogo32.png ( 32pix height)
# for window decoration:
# \resources\images\scalable\gid.svg
# is a vectorial svg image (they are created internally images with different size: 16 24 32 48 64 128 256 512) named gid${size}.png
#
# \resources\images\gid.ico (for Windows it is the icon compiled in the exe, the copy gid_project\gid\rc\gid.ico, and the installer put it in the desktop)
# gid.icns (for macOS it is the icon used in the Application folder and that shows up in finder)

#to customize the default extension of the calculation file, for example ".nas" for Nastran
set ::GidPriv(CalculationFileExtension,Default) ".dat"

#variables to hide entity level menus and tools
set ::GidPriv(HideSurfaceLevel,Default) 0
set ::GidPriv(HideVolumeLevel,Default) 0 
#variable to hide quadratic options: Normal (linear), Quadratic, Quadratic9
#integer value representing a binary array of 3 bits from left to right, 1 to hide 0 to show
#e.g. values: 0=000 not hide nothing
#             1=001 to hide linear
#             4=100 to hide quadratic9
#             6=110 to hide quadratic and quadratic9
set ::GidPriv(HideQuadraticTypeLevel,Default) 0
set ::GidPriv(HideUndo,Default) 0
set ::GidPriv(ShowGroupsTab,Default) 1 ;#0 to not show a tab for groups inside the layers frame ('GiD_Groups window open' an external window)

#if a procedure 'configure_program_proc' exists, it will be executed as the last step
#can be implemented to do some special initialization. Its prototype is:
#proc configure_program_proc { } { ...body... }

# 3D or 2D (to restrict integrals and stream lines to be like 2d discarding z)
set ::GidPriv(PostSpaceDimension) 3D

set ::GidPriv(Configuration) release ;#relase or debug
set ::GidPriv(ShowPackages) 0 ;#show packages information loading GiD
set ::GidPriv(ChangeButtonMeaning) 1 ;# use of mouse button changes:0 old_bindings , 1 new_bindings
#To customize some widget colors see gid_themes
set ::GidPriv(ThemeSelection) 1

# experimental features
set ::GidPriv(EnableVolumeRendering) 1
set ::GidPriv(EnableAnimationInIconBar) 1

set ::GidPriv(EnableVolumeRendering) 1

#preserve_z 0: set the z interpolated
#           1: set the z intepolated only if is bigger than current
#           2: set the z intepolated only if is smaller than current
set ::GidPriv(MoveNodesToZRasterPreserveZ) 0

#----------------------End configuration section-------------------------


proc ConfigureProgramSetVariablesDefault { } {   
    foreach item {ProgName ProgVersion Organization ProgWeb PassWeb WebDownload WebDownloadsDirect WebForum WebLinkColour ContactMail TextOfVersion \
		      CalculationFileExtension HideSurfaceLevel HideVolumeLevel HideQuadraticTypeLevel HideUndo ShowGroupsTab \
		      ProblemtypeWeb ProblemtypeWebPassword ProblemtypeWebDownload ProblemtypeContactMail } {
	#temporary remove raise trace events, like GidPriv(HideSurfaceLevel) that raise UpdateMenusAndToolbars
	#temporary remove raise trace events, like GidPriv(HideVolumeLevel) that raise UpdateMenusAndToolbars
	set infotrace [trace info variable ::GidPriv($item)]
	if { $infotrace != "" } {	   
	    foreach data $infotrace {
		trace remove variable ::GidPriv($item) {*}$data
	    }
	}
	set ::GidPriv($item) $::GidPriv($item,Default)
	if { $infotrace != "" } {
	    foreach data $infotrace {
		trace add variable ::GidPriv($item) {*}$data
	    }
	}
    }
}

ConfigureProgramSetVariablesDefault
