
proc doRestartGiD { } {    
    if { [info exists ::UseLocalOpenGL] } {
        if { [GiD_Set SoftwareOpenGL] != $::UseLocalOpenGL} {
            GiD_Set SoftwareOpenGL $::UseLocalOpenGL
            after 1000 GiD_Set OpenGL(EmulateFrontBuffer) $::UseLocalOpenGL
        }
        GiD_Set OpenGL(Configured) 1
    }
    if { [info exists ::UseLocalTheme] } {
        #always apply beginning color options (example change from black to black)
        gid_themes::SetCurrentTheme $::UseLocalTheme 0
    }

    set args $::argv
    if { $::GidPriv(restartCurrentProject) != "UNNAMED"} {
        # avoid appending the current project again, may be we've already restarted GiD 
        if { [ lsearch $args $::GidPriv(restartCurrentProject)] == -1 } {
            lappend args $::GidPriv(restartCurrentProject)
        }
    }

    if { [GiD_Set SaveGidDefaults] } {
        set raise_events 1
        SavePreferences [GiD_GetUserSettingsFilename -create_folders] 0 $raise_events
    }

    if { [ info exists ::env(INI_ARG_0)]} {
        set exec_prog $::env(INI_ARG_0)
    } else {
        set exec_prog $::argv0
    }
    update
    set err [ catch {
        if { [llength $args] == 0} {
            exec $exec_prog &
        } else {
            exec $exec_prog {*}$args &
        }
    } errTxt ]
    exit
}

 proc checkMaxAttemptsRestart { } {
    if { $::GidPriv(restartMaxAttempts) <= 0} {
        # max number of attempts, now aborting restart.
        set message [_ "%s could not be restarted automatically.\nPlease, as soon as you can quit the program\nand start it again so that the new settings\ncan be applied." $::GidPriv(ProgName)]
        MessageBoxOk [_ "Warning"] $message info
        return 0
    } else {
        return 1
    }
}

proc checkChangesAndRestart { } {
    if { ![ checkMaxAttemptsRestart]} {
        return
    }
    set notSaved [GiD_Info Project AreChanges]
    if { $notSaved} {
        incr ::GidPriv(restartMaxAttempts) -1
        after 1000 checkChangesAndRestart
    } else {
        doRestartGiD
    }
}

proc checkIfInPreAndRestart {} {    
    if { ![checkMaxAttemptsRestart]} {
        return
    }    
    if { [GetCurrentPrePostMode] == "POST" } {
        incr ::GidPriv(restartMaxAttempts) -1
        after 1000 checkIfInPreAndRestart
    } else {
        # ask the user to save any modifications:
        set cancel [DoFilesNew]
        if { $cancel } {
            set message [_ "Please, restart %s as soon as you can\n so that the new settings\ncan be applied." $::GidPriv(ProgName)]
            MessageBoxOk [_ "Warning"] $message info
        } else {
            after 1000 checkChangesAndRestart
        }
    }
}

proc RestartGiD { { w .gid}} {    
    # focus on parent so that the message appears above it and not below all other windows
    set old_focus [focus]
    focus $w
    set title [_ "%s restart" $::GidPriv(ProgName)]
    set message [_ "In order to apply the new settings %s needs to be restarted.\nRestart %s now?" $::GidPriv(ProgName) $::GidPriv(ProgName)]    
    set resp [MessageBoxOptionsButtons $title $message [list yes no] [list [_ "Yes"] [_ "No"]] question ""]
    if { $resp == "no" } {
        if { $old_focus != ""} {
            focus $old_focus
        }
        return
    }
    
    # close preference window if open
    ::CreateWidgetsFromXml::DestroyWindow
    # give some time to preferences window to check if any changes...
    # <Destroy> calls DestroyingCheckChanges, lots of DestroyTraceVar, AuxDestroyTraceFunc
    after 1000

    # if we are in Post mode, change to pre
    if { [GetCurrentPrePostMode] == "POST" } {
        GiD_Process escape Mescape escape Preprocess yes
    }

    # wait at max. 15 seconds to solve for all issues: in post, save changes, ....
    # if not, abort restart
    set ::GidPriv(restartMaxAttempts) 15
    set ::GidPriv(restartCurrentProject) [GiD_Info Project ModelName]

    checkIfInPreAndRestart
}

proc GUI_UpdateMenus { } {
    if { [GidUtils::AreWindowsDisabled] } {
        return
    }
    SetAllMenusVariables
    UpdateTopMenus
    UpdateMouseMenu
    UpdateMouseMenuGraph
    DWInitUserDataOptions
    # UpdateRightButtons
}
    

proc GUI_UpdateWidgetsLanguage { } {
    global GidPriv
    GUI_UpdateMenus
    OpenOutsideWindows [GetCurrentPrePostMode]    
    if { [info exists GidPriv(InitWindowList)] } {
        foreach geomwinname $GidPriv(InitWindowList) {
            if { $geomwinname == "PrePostTopMenuWindow" } {
                continue
            }
            if { [info exists GidPriv($geomwinname)] && [winfo exists $GidPriv($geomwinname)] } {
                if { [catch { eval $GidPriv($geomwinname,InitComm) } msg] } {
                    WarnWinText "GUI_UpdateWidgetsLanguage $msg"
                }
            }
        }
    }
    #lower command
    if { [info exists GidPriv(PrePostEntryWindowGeom)] } {
        BottomEntryFrame [lindex $GidPriv(PrePostEntryWindowGeom) 0]
    }
    ChangeWindowTitle "" ""
}

# Eventualy missing to restart/rebuild customlib tree so that the tree uses the new Font changes
proc GUI_UpdateFontsScale { } {
    if { ![ info exist ::FontScaleFactor]} {
        # if not defined then it's 1, when the NormalFont & co. preferences where read
        set ::FontScaleFactor 1
    }
    set new_scale_factor [GiD_Set Theme(HighResolutionFontScaleFactor)]
    if { $::FontScaleFactor != $new_scale_factor} {
        # rebuild fonts
        set all_fonts [ font names]
        foreach fnt [ list NormalFont BoldFont SmallFont WarnWinTextFont TkDefaultFont FixedFont BigFont] {
            if { [ lsearch $all_fonts $fnt] != -1} {
                set org_size [ font configure $fnt -size]
                set new_size [ expr int( 0.5 + double( $org_size * $new_scale_factor) / double( $::FontScaleFactor))]
                font configure $fnt -size $new_size
            }
        }
        set ::FontScaleFactor $new_scale_factor
    }
}

proc GUI_UpdateImages { } {
    #if delete the images raise a tcl error changing from theme Black to Light (only when right buttons are visible and the window is small)
    #                                       also opening the list - report window chaning from black to classic and again to black
    #foreach key [array names ::GidPrivImages] {
    #    # maybe image doesn't exists
    #    catch { image delete $::GidPrivImages($key) }
    #}
    array unset ::GidPrivImages
    array unset ::ModulePrivImages
    
    array unset icon_chooser::_default_macro_images
    icon_chooser::AfterReadMacros
}

proc GUI_Update { } {
    if { [GidUtils::AreWindowsDisabled] } {
        return
    }
    if { [winfo exists .gid] } {
        GUI_UpdateFontsScale
        GUI_UpdateImages
        GUI_UpdateWidgetsLanguage
    }        
}



proc PreferencesWindow { {groupname ""} } {
    if { [GidUtils::ExistsWindow PREFERENCES] } {
       GidUtils::CloseWindow PREFERENCES
    }
    #trick to remove post items because by now is not possible to apply them in preprocess
    #set hide_groups {postprocess_geometry postprocess_legends postprocess_contours postprocess_vectors postprocess_iso-surfaces \
    #  postprocess_streamlines postprocess_result_surface postprocess_line_diagrams postprocess_others}
    set hide_groups ""
    set xmlfile Preferences.xml
    if { [info exists CreateWidgetsFromXml::fileread($xmlfile)] } {
        if { [GetCurrentPrePostMode] == "POST" } {
            CreateWidgetsFromXml::IniWin $CreateWidgetsFromXml::fileread($xmlfile) $groupname "PreferencesWindow" "" 
        } else {
            CreateWidgetsFromXml::IniWin $CreateWidgetsFromXml::fileread($xmlfile) $groupname "PreferencesWindow" $hide_groups
        }
    } else {
        if { [GetCurrentPrePostMode] == "POST" } {
            CreateWidgetsFromXml::ReadXmlFile Preferences.xml $groupname "PreferencesWindow" 1 ""
        } else {
            CreateWidgetsFromXml::ReadXmlFile Preferences.xml $groupname "PreferencesWindow" 1 $hide_groups
        }
    }
}
