# Ver TODO al final del archivo.

namespace eval ::GlobalAxis {
  variable data
}

# Post reference axis
proc ::GlobalAxis::ChangeAxis {{w .gid.axis}} {
    variable data  
    InitWindow2 $w -title [_ "Reference axes"] \
        -geometryvariable PostChangeAxisWindowGeom \
        -initcommand ::GlobalAxis::ChangeAxis \
        -ontop
    if { ![winfo exists $w] } return ;

    set data(wid,main) $w

    set nb [ttk::notebook $w.nb -padding 6]
    ttk::notebook::enableTraversal $nb
 
    set ::GlobalAxis::data(wid,nb) $w.nb

    $nb add [axis.pane $nb.axis]   -text [_ "Axes"] -sticky nwes -padding 6 -underline 0
    $nb add [grid.pane $nb.grid]   -text [_ "Grid" ] -sticky nwes -padding 6 -underline 0
    $nb add [label.pane $nb.label] -text [_ "Labels"] -sticky nwes -padding 6 -underline 0
    #$nb add [arrow.pane $nb.arrow] -text [_ "Arrows"] -sticky nwes -padding 6 -underline 4


    set statusbar [ttk::frame $w.statusbar]
    pack [ttk::sizegrip $statusbar.grip] -side right -anchor se

    set cmd [ttk::frame $w.cmd -style BottomFrame.TFrame]
    set data(wid,cmd) $cmd
    ttk::button $cmd.ok -text [_ "Apply"] -command ::GlobalAxis::OnApply -style BottomFrame.TButton
    ttk::button $cmd.reset -text [_ "Reset"] -underline 0 -command ::GlobalAxis::OnReset -style BottomFrame.TButton
    set data(wid,reset) $cmd.reset
    ttk::button $cmd.close -text [_ "Close"] -underline 0 -command ::GlobalAxis::OnClose -style BottomFrame.TButton

    focus $nb

    grid x $cmd.ok $cmd.reset $cmd.close -pady 6 -padx 6
    grid anchor $w.cmd center

    #makeThemeControl $::BASE.control

    #pack $w.statusbar -side bottom -expand false -fill x
    pack $w.cmd -side bottom -expand false -fill x
    pack $w.nb -side left -expand true -fill both 
    #pack $BASE.control -side right -expand false -fill y -padx 6 -pady 6

    focus $cmd.ok       
    bind $w <Return> "::GlobalAxis::OnApply"
    bind $w <Destroy> "+::GlobalAxis::OnClose" ;#+ to not lost the binding of InitWindow to remember its size
}


### Axis pane
#
proc axis.pane {axis} {
    variable data

    ttk::frame $axis

    set ::GlobalAxis::data(wid,current) "axis"

    set back 000000
    set base ffffff

    if { ![info exists ::GlobalAxis::data(axis)] } { set ::GlobalAxis::data(axis) "NoAxes" }
    ttk::checkbutton $axis.show -text [_ "Show axes"] -underline 3 -variable ::GlobalAxis::data(axis) -onvalue "Yes" -offvalue "NoAxes"
    GidHelp $axis.show [_ "If this option is set the axes will be shown"]

    ttk::label $axis.type -text [_ "Axes type"]:
    ttk::radiobutton $axis.basic -text [_ "Basic"] -variable ::GlobalAxis::data(type) -value "Basic" -underline 0
    ttk::radiobutton $axis.box   -text [_ "Box"]   -variable ::GlobalAxis::data(type) -value "Box"   -underline 2
    #ttk::radiobutton $axis.no    -text [_ "No"]    -variable ::GlobalAxis::data(axis) -value "NoAxes"    -underline 0
    GidHelp $axis.basic [_ "If this option is set the axes will be shown in basic mode"]
    GidHelp $axis.box [_ "If this option is set the axes will be shown in box mode"]

    ttk::label $axis.width -text [_ "Width"]
    ttk::spinbox $axis.spin -from 1 -to 15 -increment 1 -width 8 -textvariable ::GlobalAxis::data(width)
    set ::GlobalAxis::data(widthnum) $axis.spin
    GidHelp $axis.spin [_ "Set the axes width"]

    if { ![info exists ::GlobalAxis::data(arrow)] } { set ::GlobalAxis::data(arrow) "No" }
    ttk::checkbutton $axis.arrows -text [_ "Show arrows"] -underline 5 -variable ::GlobalAxis::data(arrow) -onvalue "Yes" -offvalue "No"
    GidHelp $axis.arrows [_ "If this option is set the axes arrows will be shown"]

	if { ![info exists ::GlobalAxis::data(xyz)] } { set ::GlobalAxis::data(xyz) "No" }
    ttk::checkbutton $axis.xyz -text [_ "Show xyz labels"] -underline 7 -variable ::GlobalAxis::data(xyz) -onvalue "Yes" -offvalue "No"
    GidHelp $axis.xyz [_ "If this option is set the xyz labels will be shown"]

    ttk::label $axis.color  -text [_ "Color"]:

    trace remove variable data(axis,color,x) write "::GlobalAxis::UpdateColor"
    trace remove variable data(axis,color,y) write "::GlobalAxis::UpdateColor"
    trace remove variable data(axis,color,z) write "::GlobalAxis::UpdateColor"

    ttk::label $axis.colorx -text [_ "X Axis"] -width 10 -anchor center -relief groove
    ttk::label $axis.colory -text [_ "Y Axis"] -width 10 -anchor center -relief groove
    ttk::label $axis.colorz -text [_ "Z Axis"] -width 10 -anchor center -relief groove

    bind $axis.colorx <1> "::GlobalAxis::SelectColorx"
    bind $axis.colory <1> "::GlobalAxis::SelectColory"
    bind $axis.colorz <1> "::GlobalAxis::SelectColorz"

    set ::GlobalAxis::data(axis,labelcol,x) $axis.colorx
    set ::GlobalAxis::data(axis,labelcol,y) $axis.colory
    set ::GlobalAxis::data(axis,labelcol,z) $axis.colorz

    GidHelp $axis.colorx [_ "Click this label in order to change the X axis color"]
    GidHelp $axis.colory [_ "Click this label in order to change the Y axis color"]
    GidHelp $axis.colorz [_ "Click this label in order to change the Z axis color"]

    trace add variable data(axis,color,x) write "::GlobalAxis::UpdateColor"
    trace add variable data(axis,color,y) write "::GlobalAxis::UpdateColor"
    trace add variable data(axis,color,z) write "::GlobalAxis::UpdateColor"

    set ::GlobalAxis::data(nocolor) [$axis.type cget -background]

    # Geometry management
    grid columnconfigure $axis all -weight 1
    grid rowconfigure $axis all -weight 1

    #grid $axis.show  -row 0 -column 0 -sticky w
    #grid $axis.basic -row 0 -column 1 -sticky w
    #grid $axis.box   -row 0 -column 2 -sticky w
    #grid $axis.no    -row 0 -column 3 -sticky w

    #grid $axis.color  -row 2 -column 0 -sticky w
    #grid $axis.colorx -row 2 -column 1 -sticky w
    #grid $axis.colory -row 2 -column 2 -sticky w
    #grid $axis.colorz -row 2 -column 3 -sticky w

    #grid $axis.width -row 4 -column 0 -sticky w
    #grid $axis.spin  -row 4 -column 1 -sticky w

    #grid $axis.arrows -row 6 -column 0 -sticky w

    grid $axis.show -sticky w -pady 5
    grid $axis.type $axis.basic $axis.box -sticky w -pady 5
    grid $axis.color $axis.colorx $axis.colory $axis.colorz -sticky w -pady 5 -padx 5
    grid $axis.width $axis.spin -sticky w -pady 5
    grid $axis.arrows -sticky w -pady 5 -columnspan 4
    grid $axis.xyz -sticky w -pady 5 -columnspan 4

    ::GlobalAxis::FillAxisOp
    return $axis

}

### Axis Color
#
proc ::GlobalAxis::UpdateColor {args} {
    variable data
    set base #ffffff

    set colorx $data(axis,color,x)
    if {$colorx eq ""} {
	$data(axis,labelcol,x) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(axis,labelcol,x) configure -background $colorx -foreground $base
    }

    set colory $data(axis,color,y)
    if {$colory eq ""} {
	$data(axis,labelcol,y) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(axis,labelcol,y) configure -background $colory -foreground $base
    }

    set colorz $data(axis,color,z)
    if {$colorz eq ""} {
	$data(axis,labelcol,z) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(axis,labelcol,z) configure -background $colorz -foreground $base
    }
}

proc ::GlobalAxis::SelectColorx {} {
    variable data
    set base #ffffff

    if {[$data(axis,labelcol,x) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(axis,color,x) -title [_ "Choose X axis color"]]
	if {$color eq ""} {
	    set color $data(axis,color,x)
	} else {
	    set data(axis,color,x) $color
	}
	$data(axis,labelcol,x) configure -background $color -foreground $base
    }

}

proc ::GlobalAxis::SelectColory {} {
    variable data
    set base #ffffff

    if {[$data(axis,labelcol,y) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(axis,color,y) -title [_ "Choose Y axis color"]]
	if {$color eq ""} {
	    set color $data(axis,color,y)
	} else {
	    set data(axis,color,y) $color
	}
	$data(axis,labelcol,y) configure -background $color -foreground $base
    }

}

proc ::GlobalAxis::SelectColorz {} {
    variable data
    set base #ffffff

    if {[$data(axis,labelcol,z) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(axis,color,z) -title [_ "Choose Z axis color"]]
	if {$color eq ""} {
	    set color $data(axis,color,z)
	} else {
	    set data(axis,color,z) $color
	}
	$data(axis,labelcol,z) configure -background $color -foreground $base
    }

}


### Grid pane
#
proc grid.pane {grid} {
    variable data
    ttk::frame $grid

    set data(wid,current) "grids"

    set dot [ GiDTeXSymbols::Get {\mult}]
    set pat {".. .." "--------" "--  --  " "- . - . " "- - - - " ". . . . " "--- --- " "-   -   " ".-..-."}
    set patval {Default Continuous Slash SlashDot LittleSlash Dots BigSlash SlashSpace DotSlashDot}

    if { ![info exists ::GlobalAxis::data(grid)] } { set ::GlobalAxis::data(grid) "No" }
    ttk::checkbutton $grid.show -text [_ "Show grid"] -underline 3 -variable ::GlobalAxis::data(grid) -onvalue "Yes" -offvalue "No"
    set ::GlobalAxis::data(grid) $grid.show
    GidHelp $grid.show [_ "If this option is set the axes grid will be shown"]

    ttk::label $grid.pattern -text [_ "Grid pattern"]:

    TTKComboBox $grid.patterntype -state normal -labels $pat -values $patval -textvariable ::GlobalAxis::data(pattern) -width 6

    GidHelp $grid.patterntype [_ "Click this combo box in order to change the grid pattern"]

    ttk::label $grid.factor -text [_ "Pattern factor"]:
    ttk::spinbox $grid.factornum -from 1 -to 15 -increment 1 -width 8 -textvariable ::GlobalAxis::data(factor)
    set ::GlobalAxis::data(factornum) $grid.factornum
    GidHelp $grid.factor [_ "Choose the pattern factor for grid"]


    ttk::label $grid.color  -text [_ "Color"]:
    ttk::label $grid.x  -text "X:"
    ttk::label $grid.y  -text "Y:"
    ttk::label $grid.z  -text "Z:"

    trace remove variable data(grid,color,x) write "::GlobalAxis::UpdateGridColor"
    trace remove variable data(grid,color,y) write "::GlobalAxis::UpdateGridColor"
    trace remove variable data(grid,color,z) write "::GlobalAxis::UpdateGridColor"

    ttk::label $grid.colorx -text [_ "XY Plane"] -width 10 -anchor center -relief groove
    ttk::label $grid.colory -text [_ "YZ Plane"] -width 10 -anchor center -relief groove
    ttk::label $grid.colorz -text [_ "XZ Plane"] -width 10 -anchor center -relief groove

    bind $grid.colorx <1> "::GlobalAxis::SelectGridColorx"
    bind $grid.colory <1> "::GlobalAxis::SelectGridColory"
    bind $grid.colorz <1> "::GlobalAxis::SelectGridColorz"

    set ::GlobalAxis::data(grid,labelcol,x) $grid.colorx
    set ::GlobalAxis::data(grid,labelcol,y) $grid.colory
    set ::GlobalAxis::data(grid,labelcol,z) $grid.colorz

    GidHelp $grid.colorx  [_ "Click this label in order to change the X axis color"]
    GidHelp $grid.colory  [_ "Click this label in order to change the Y axis color"]
    GidHelp $grid.colorz  [_ "Click this label in order to change the Z axis color"]

    trace add variable data(grid,color,x) write "::GlobalAxis::UpdateGridColor"
    trace add variable data(grid,color,y) write "::GlobalAxis::UpdateGridColor"
    trace add variable data(grid,color,z) write "::GlobalAxis::UpdateGridColor"


    ttk::label $grid.div  -text [_ "Grid divisions"]:
    ttk::spinbox $grid.divx -from 1 -to 200 -increment 1 -width 3 -textvariable ::GlobalAxis::data(divx)
    set ::GlobalAxis::data(divxnum) $grid.divx

    ttk::spinbox $grid.divy -from 1 -to 200 -increment 1 -width 3 -textvariable ::GlobalAxis::data(divy)
    set ::GlobalAxis::data(divynum) $grid.divy

    ttk::spinbox $grid.divz -from 1 -to 200 -increment 1 -width 3 -textvariable ::GlobalAxis::data(divz)
    set ::GlobalAxis::data(divznum) $grid.divz

    GidHelp $grid.divx [_ "Set the number of divisions for X grid"]
    GidHelp $grid.divy [_ "Set the number of divisions for Y grid"]
    GidHelp $grid.divz [_ "Set the number of divisions for Z grid"]


    # Geometry management
    grid columnconfigure $grid all -weight 1
    grid rowconfigure $grid all -weight 1

    grid $grid.show -row 0 -column 0 -sticky w

    grid $grid.color $grid.colorx $grid.colorz $grid.colory -sticky w -pady 5 -padx 5

    #grid $grid.color  -row 2 -column 0 -sticky w -pady 5
    #grid $grid.colorx -row 2 -column 1 -sticky w -pady 5
    #grid $grid.colory -row 2 -column 2 -sticky w -pady 5
    #grid $grid.colorz -row 2 -column 3 -sticky w -pady 5

    grid $grid.div  -row 4 -column 0 -sticky w -pady 5
    grid $grid.x    -row 4 -column 1 -sticky w -padx 5
    grid $grid.divx -row 4 -column 1  -pady 5
    grid $grid.y    -row 4 -column 2 -sticky w -padx 5
    grid $grid.divy -row 4 -column 2 -pady 5
    grid $grid.z    -row 4 -column 3 -sticky w -padx 5
    grid $grid.divz -row 4 -column 3  -pady 5

    #grid $grid.pattern -row 6 -column 0 -sticky w -pady 5
    #grid $grid.patterntype -row 6 -column 1 -sticky w -pady 5

    #grid $grid.factor -row 8 -column 0 -sticky w -pady 5
    #grid $grid.factornum -row 8 -column 1 -sticky w -pady 5



    #grid $grid.div $grid.x $grid.divx $grid.y $grid.divy $grid.z $grid.divz -sticky w -pady 5
    grid $grid.pattern $grid.patterntype -sticky w -pady 5
    grid $grid.factor $grid.factornum -sticky w -pady 5

    ::GlobalAxis::FillGridOp
    return $grid
}


### Grid Color
#
proc ::GlobalAxis::UpdateGridColor {args} {
    variable data
    set base #ffffff

    set colorx $data(grid,color,x)
    if {$colorx eq ""} {
	$data(grid,labelcol,x) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(grid,labelcol,x) configure -background $colorx -foreground $base
    }

    set colory $data(grid,color,y)
    if {$colory eq ""} {
	$data(grid,labelcol,y) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(grid,labelcol,y) configure -background $colory -foreground $base
    }

    set colorz $data(grid,color,z)
    if {$colorz eq ""} {
	$data(grid,labelcol,z) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(grid,labelcol,z) configure -background $colorz -foreground $base
    }

}

proc ::GlobalAxis::SelectGridColorx {} {
    variable data
    set base #ffffff

    if {[$data(grid,labelcol,x) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(grid,color,x) -title [_ "Choose XY plane grid color"]]
	if {$color eq ""} {
	    set color $data(grid,color,x)
	} else {
	    set data(grid,color,x) $color
	}
	$data(grid,labelcol,x) configure -background $color -foreground $base
    }

}
	
proc ::GlobalAxis::SelectGridColory {} {
    variable data
    set base #ffffff

    if {[$data(grid,labelcol,y) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(grid,color,y) -title [_ "Choose YZ plane grid color"]]
	if {$color eq ""} {
	    set color $data(grid,color,y)
	} else {
	    set data(grid,color,y) $color
	}
	$data(grid,labelcol,y) configure -background $color -foreground $base
    }

}

proc ::GlobalAxis::SelectGridColorz {} {
    variable data
    set base #ffffff

    if {[$data(grid,labelcol,z) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(grid,color,z) -title [_ "Choose XZ plane grid color"]]
	if {$color eq ""} {
	    set color $data(grid,color,z)
	} else {
	    set data(grid,color,z) $color
	}
	$data(grid,labelcol,z) configure -background $color -foreground $base
    }

}


### Labels pane
#
proc ::GlobalAxis::OnChangeColor { args } {
    variable data

    if { $data(label,axescolor) eq "Yes"} {
	$::GlobalAxis::data(label,labelcol) configure -state disabled
	set data(label,color) ""
	UpdateLabColor
    }

    if { $data(label,axescolor) eq "No"} {
	$::GlobalAxis::data(label,labelcol) configure -state normal
	set labelcolor_info [ GiD_Info postprocess get axis_option LabelColor]
	set labelcolor_info [lindex $labelcolor_info 0]
	set data(label,color) [lindex $labelcolor_info 0]
	UpdateLabColor
    }
}

proc label.pane {label} {
    variable data
    ttk::frame $label

    set data(wid,current) "labels"

    set back 000000
    set base ffffff

    trace remove variable ::GlobalAxis::data(label,color) write "::GlobalAxis::UpdateLabColor"
    trace remove variable ::GlobalAxis::data(label,axescolor) write "::GlobalAxis::OnChangeColor"

    if { ![info exists ::GlobalAxis::data(label)] } { set ::GlobalAxis::data(label) "No" }
    ttk::checkbutton $label.show -text [_ "Show labels (The grid will be also shown)"] -underline 3 -variable ::GlobalAxis::data(label) -onvalue "Yes" -offvalue "No"
    GidHelp $label.show [_ "If this option is set the labels will be shown"]

    ttk::label $label.type -text [_ "Type"]:
    ttk::radiobutton $label.static  -text [_ "Static"]  -variable ::GlobalAxis::data(label,type) -value "Static"  -underline 0
    ttk::radiobutton $label.dynamic -text [_ "Dynamic"] -variable ::GlobalAxis::data(label,type) -value "Dynamic" -underline 0

    if { ![info exists ::GlobalAxis::data(label,font)] } { set ::GlobalAxis::data(label,font) "No" }
    ttk::checkbutton $label.font -text [_ "Scale labels"] -underline 13 -variable ::GlobalAxis::data(label,font) -onvalue "Yes" -offvalue "No" -underline 3
    GidHelp $label.font [_ "If this option is set the label font size will change according to the zoom"]

    ttk::label $label.color -text [_ "Color"]:
    ttk::radiobutton $label.asaxes -text [_ "as axes"]  -variable ::GlobalAxis::data(label,axescolor) -value "Yes" -underline 0
    ttk::radiobutton $label.altcolor -variable ::GlobalAxis::data(label,axescolor) -value "No" -underline 0
    GidHelp $label.asaxes [_ "If this option is set the labels color will be the same of the axes"]
    GidHelp $label.altcolor [_ "If this option is set the label color will be the choosen"]

    ttk::label $label.lcolor -text [_ "choose"] -width 10 -anchor center -relief groove
    GidHelp $label.lcolor [_ "Click this label in order to change the labels color"]

    bind $label.lcolor <1> "::GlobalAxis::SelectLabColor"
    set ::GlobalAxis::data(label,labelcol) $label.lcolor

    trace add variable ::GlobalAxis::data(label,axescolor) write "::GlobalAxis::OnChangeColor"
    trace add variable ::GlobalAxis::data(label,color) write "::GlobalAxis::UpdateLabColor"

    #trace remove variable data(label,color,x) write "::GlobalAxis::UpdateLabColor"
    #trace remove variable data(label,color,y) write "::GlobalAxis::UpdateLabColor"
    #trace remove variable data(label,color,z) write "::GlobalAxis::UpdateLabColor"

    #ttk::label $label.colorx -text [_ "X Axis"] -width 10 -anchor center -relief groove
    #ttk::label $label.colory -text [_ "Y Axis"] -width 10 -anchor center -relief groove
    #ttk::label $label.colorz -text [_ "Z Axis"] -width 10 -anchor center -relief groove

    #bind $label.colorx <1> "::GlobalAxis::SelectLabColorx"
    #bind $label.colory <1> "::GlobalAxis::SelectLabColory"
    #bind $label.colorz <1> "::GlobalAxis::SelectLabColorz"

    #set ::GlobalAxis::data(label,labelcol,x) $label.colorx
    #set ::GlobalAxis::data(label,labelcol,y) $label.colory
    #set ::GlobalAxis::data(label,labelcol,z) $label.colorz

    #GidHelp $label.colorx [_ "Click this label in order to change the X axis color"]
    #GidHelp $label.colory [_ "Click this label in order to change the Y axis color"]
    #GidHelp $label.colorz [_ "Click this label in order to change the Z axis color"]

    #trace add variable data(label,color,x) write "::GlobalAxis::UpdateLabColor"
    #trace add variable data(label,color,y) write "::GlobalAxis::UpdateLabColor"
    #trace add variable data(label,color,z) write "::GlobalAxis::UpdateLabColor"

    # Geometry management

    grid columnconfigure $label all -weight 1
    grid rowconfigure $label all -weight 1

    #grid $label.show -row 0 -column 0 -sticky w -columnspan 4

    #grid $label.color   -row 2 -column 0 -sticky w
    #grid $label.colorx  -row 2 -column 1 -sticky w
    #grid $label.colory  -row 2 -column 2 -sticky w
    #grid $label.colorz  -row 2 -column 3 -sticky w

    #grid $label.type    -row 4 -column 0 -sticky w
    #grid $label.static  -row 4 -column 1 -sticky w
    #grid $label.dynamic -row 4 -column 2 -sticky w

    #grid $label.font    -row 6 -column 0 -sticky w -columnspan 4

    grid $label.show -sticky w -pady 5 -columnspan 4
    grid $label.font -sticky w -pady 5 -columnspan 4
    #grid $label.color $label.colorx $label.colory $label.colorz -sticky w -pady 5
    grid $label.color $label.asaxes -sticky w -pady 5
    grid $label.altcolor -row 2 -column 2 -sticky w -pady 5
    grid $label.lcolor -row 2 -column 2 -sticky e -pady 5
    grid $label.type $label.static $label.dynamic -sticky w -pady 5


    ::GlobalAxis::FillLabelsOp
    return $label
}

### Labels Color
#
proc ::GlobalAxis::UpdateLabColor {args} {
    variable data
    set base #ffffff

    set color $data(label,color)
    if {$color eq ""} {
	$data(label,labelcol) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
    } else {
	$data(label,labelcol) configure -background $color -foreground $base
    }

    #set colorx $data(label,color,x)
    #if {$colorx eq ""} {
	#    $data(label,labelcol,x) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
	#} else {
	#    $data(label,labelcol,x) configure -background $colorx -foreground $base
	#}

    #set colory $data(label,color,y)
    #if {$colory eq ""} {
	#    $data(label,labelcol,y) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
	#} else {
	#    $data(label,labelcol,y) configure -background $colory -foreground $base
	#}

    #set colorz $data(label,color,z)
    #if {$colorz eq ""} {
	#    $data(label,labelcol,z) configure -background $::GlobalAxis::data(nocolor) -foreground $::GlobalAxis::data(nocolor)
	#} else {
	#    $data(label,labelcol,z) configure -background $colorz -foreground $base
	#}

}

proc ::GlobalAxis::SelectLabColor {} {
    variable data
    set base #ffffff

    if {[$data(label,labelcol) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(label,color) -title [_ "Choose labels color"]]
	if {$color eq ""} {
	    set color $data(label,color)
	} else {
	    set data(label,color) $color
	}
	$data(label,labelcol) configure -background $color -foreground $base
    }

}

proc ::GlobalAxis::SelectLabColorx {} {
    variable data
    set base #ffffff

    if {[$data(label,labelcol,x) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(label,color,x) -title [_ "Choose X axis label color"]]
	if {$color eq ""} {
	    set color $data(label,color,x)
	} else {
	    set data(label,color,x) $color
	}
	$data(label,labelcol,x) configure -background $color -foreground $base
    }

}
	
proc ::GlobalAxis::SelectLabColory {} {
    variable data
    set base #ffffff

    if {[$data(label,labelcol,y) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(label,color,y) -title [_ "Choose Y axis label color"]]
	if {$color eq ""} {
	    set color $data(label,color,y)
	} else {
	    set data(label,color,y) $color
	}
	$data(label,labelcol,y) configure -background $color -foreground $base
    }

}

proc ::GlobalAxis::SelectLabColorz {} {
    variable data
    set base #ffffff

    if {[$data(label,labelcol,z) cget -state] ne "disabled"} {
	set color [ GIDChooseColor $data(wid,main).selcolor -color $data(label,color,z) -title [_ "Choose Z axis label color"]]
	if {$color eq ""} {
	    set color $data(label,color,z)
	} else {
	    set data(label,color,z) $color
	}
	$data(label,labelcol,z) configure -background $color -foreground $base
    }

}

### Arrows pane
#
proc arrow.pane {arrow} {
    variable data
    ttk::frame $arrow

    set data(wid,current) "arrows"

    set back 000000
    set base ffffff

    if { ![info exists ::GlobalAxis::data(arrow)] } { set ::GlobalAxis::data(arrow) "No" }
    ttk::checkbutton $arrow.show -text [_ "Show arrows"] -underline 3 -variable ::GlobalAxis::data(arrow) -onvalue "Yes" -offvalue "No"
    GidHelp $arrow.show [_ "If this option is set the axes arrows will be shown"]

    ttk::label $arrow.color  -text [_ "Color"]:

    trace remove variable data(arrow,color,x) write "::GlobalAxis::UpdateArrowColor"
    trace remove variable data(arrow,color,y) write "::GlobalAxis::UpdateArrowColor"
    trace remove variable data(arrow,color,z) write "::GlobalAxis::UpdateArrowColor"

    ttk::label $arrow.colorx -text [_ "X Axis"] -width 10 -anchor center -relief groove
    ttk::label $arrow.colory -text [_ "Y Axis"] -width 10 -anchor center -relief groove
    ttk::label $arrow.colorz -text [_ "Z Axis"] -width 10 -anchor center -relief groove

    bind $arrow.colorx <1> "::GlobalAxis::SelectArrowColorx"
    bind $arrow.colory <1> "::GlobalAxis::SelectArrowColory"
    bind $arrow.colorz <1> "::GlobalAxis::SelectArrowColorz"

    set ::GlobalAxis::data(arrow,labelcol,x) $arrow.colorx
    set ::GlobalAxis::data(arrow,labelcol,y) $arrow.colory
    set ::GlobalAxis::data(arrow,labelcol,z) $arrow.colorz

    GidHelp $arrow.colorx [_ "Click this label in order to change the X axis color"]
    GidHelp $arrow.colory [_ "Click this label in order to change the Y axis color"]
    GidHelp $arrow.colorz [_ "Click this label in order to change the Z axis color"]

    trace add variable data(arrow,color,x) write "::GlobalAxis::UpdateArrowColor"
    trace add variable data(arrow,color,y) write "::GlobalAxis::UpdateArrowColor"
    trace add variable data(arrow,color,z) write "::GlobalAxis::UpdateArrowColor"

    # Geometry management

    grid columnconfigure $arrow all -weight 1
    grid rowconfigure $arrow all -weight 1

    grid $arrow.show -row 0 -column 0 -sticky w -columnspan 2

    grid $arrow.color  -row 2 -column 0 -sticky w
    grid $arrow.colorx -row 2 -column 1 -sticky w
    grid $arrow.colory -row 2 -column 2 -sticky w
    grid $arrow.colorz -row 2 -column 3 -sticky w

    ::GlobalAxis::FillArrowsOp
    return $arrow
}

### Arrows Color
#
proc ::GlobalAxis::UpdateArrowColor {args} {
    variable data
    set base #ffffff

    set colorx $data(arrow,color,x)
    $data(arrow,labelcol,x) configure -background $colorx -foreground $base

    set colory $data(arrow,color,y)
    $data(arrow,labelcol,y) configure -background $colory -foreground $base

    set colorz $data(arrow,color,z)
    $data(arrow,labelcol,z) configure -background $colorz -foreground $base

}

proc ::GlobalAxis::SelectArrowColorx {} {
    variable data
    set base #ffffff

    set color [ GIDChooseColor $data(wid,main).selcolor -title [_ "Choose X axis arrow color"]]
    set data(arrow,color,x) $color
    $data(arrow,labelcol,x) configure -background $color -foreground $base

}
	
proc ::GlobalAxis::SelectArrowColory {} {
    variable data
    set base #ffffff

    set color [ GIDChooseColor $data(wid,main).selcolor -title [_ "Choose Y axis arrow color"]]
    set data(arrow,color,y) $color
    $data(arrow,labelcol,y) configure -background $color -foreground $base

}
proc ::GlobalAxis::SelectArrowColorz {} {
    variable data
    set base #ffffff

    set color [ GIDChooseColor $data(wid,main).selcolor -title [_ "Choose Z axis arrow color"]]
    set data(arrow,color,z) $color
    $data(arrow,labelcol,z) configure -background $color -foreground $base

}


### Fill options
#
proc ::GlobalAxis::FillAxisOp { } {
    variable data

    # Axis
    set axis_info [ GiD_Info postprocess get axis_option ShowAxes]
    set axis_info [lindex $axis_info 0]
    set data(axis) [lindex $axis_info 0]

    set axis_info [ GiD_Info postprocess get axis_option Type]
    set axis_info [lindex $axis_info 0]
    set data(type) [lindex $axis_info 0]

    set axiswidth_info [ GiD_Info postprocess get axis_option AxesWidth]
    set axiswidth_info [lindex $axiswidth_info 0]
    set data(width) [lindex $axiswidth_info 0]

    set axiscolorx_info [ GiD_Info postprocess get axis_option AxisXColor]
    set axiscolorx_info [lindex $axiscolorx_info 0]
    set data(axis,color,x) [lindex $axiscolorx_info 0]

    set axiscolory_info [ GiD_Info postprocess get axis_option AxisYColor]
    set axiscolory_info [lindex $axiscolory_info 0]
    set data(axis,color,y) [lindex $axiscolory_info 0]

    set axiscolorz_info [ GiD_Info postprocess get axis_option AxisZColor]
    set axiscolorz_info [lindex $axiscolorz_info 0]
    set data(axis,color,z) [lindex $axiscolorz_info 0]

    set arrow_info [ GiD_Info postprocess get axis_option Arrow]
    set arrow_info [lindex $arrow_info 0]
    set data(arrow) [lindex $arrow_info 0]

    set xyz_info [ GiD_Info postprocess get axis_option XYZLabels]
    set xyz_info [lindex $xyz_info 0]
    set data(xyz) [lindex $xyz_info 0]

    # 2D, 3D?
    set axis_info [ GiD_Info postprocess get axis_option Dimensions]
    set axis_info [lindex $axis_info 0]
    set data(dimensions) [lindex $axis_info 0]

    if { $data(dimensions) eq "xyz"} {
	$::GlobalAxis::data(axis,labelcol,x) configure -state normal
	$::GlobalAxis::data(axis,labelcol,y) configure -state normal
	$::GlobalAxis::data(axis,labelcol,z) configure -state normal
    } elseif { $data(dimensions) eq "xy"} {
	$::GlobalAxis::data(axis,labelcol,x) configure -state normal
	$::GlobalAxis::data(axis,labelcol,y) configure -state normal
	$::GlobalAxis::data(axis,labelcol,z) configure -state disabled
	set data(axis,color,z) ""
	#set data(axis,color,z) $::GlobalAxis::data(nocolor)
    } elseif { $data(dimensions) eq "xz"} {
	$::GlobalAxis::data(axis,labelcol,x) configure -state normal
	$::GlobalAxis::data(axis,labelcol,y) configure -state disabled
	$::GlobalAxis::data(axis,labelcol,z) configure -state normal
	set data(axis,color,y) ""
	#set data(axis,color,y) $::GlobalAxis::data(nocolor)
    } else {
	$::GlobalAxis::data(axis,labelcol,x) configure -state disabled
	$::GlobalAxis::data(axis,labelcol,y) configure -state normal
	$::GlobalAxis::data(axis,labelcol,z) configure -state normal
	set data(axis,color,x) ""
	#set data(axis,color,x) $::GlobalAxis::data(nocolor)
    }

    ::GlobalAxis::UpdateColor
}

proc ::GlobalAxis::FillGridOp { } {
    variable data

    # Grid
    set grid_info [ GiD_Info postprocess get axis_option Grid]
    set grid_info [lindex $grid_info 0]
    set data(grid) [lindex $grid_info 0]

    set gridfactor_info [ GiD_Info postprocess get axis_option FactorPatron]
    set gridfactor_info [lindex $gridfactor_info 0]
    set data(factor) [lindex $gridfactor_info 0]

    set gridpattern_info [ GiD_Info postprocess get axis_option Patron]
    set gridpattern_info [lindex $gridpattern_info 0]
    set data(pattern) [lindex $gridpattern_info 0]

    set gridcolorx_info [ GiD_Info postprocess get axis_option GridXColor]
    set gridcolorx_info [lindex $gridcolorx_info 0]
    set data(grid,color,x) [lindex $gridcolorx_info 0]

    set gridcolory_info [ GiD_Info postprocess get axis_option GridYColor]
    set gridcolory_info [lindex $gridcolory_info 0]
    set data(grid,color,y) [lindex $gridcolory_info 0]

    set gridcolorz_info [ GiD_Info postprocess get axis_option GridZColor]
    set gridcolorz_info [lindex $gridcolorz_info 0]
    set data(grid,color,z) [lindex $gridcolorz_info 0]

    set griddivx_info [ GiD_Info postprocess get axis_option GridXDivisions]
    set griddivx_info [lindex $griddivx_info 0]
    set data(divx) [lindex $griddivx_info 0]

    set griddivy_info [ GiD_Info postprocess get axis_option GridYDivisions]
    set griddivy_info [lindex $griddivy_info 0]
    set data(divy) [lindex $griddivy_info 0]

    set griddivz_info [ GiD_Info postprocess get axis_option GridZDivisions]
    set griddivz_info [lindex $griddivz_info 0]
    set data(divz) [lindex $griddivz_info 0]

    # 2D, 3D?
    set axis_info [ GiD_Info postprocess get axis_option Dimensions]
    set axis_info [lindex $axis_info 0]
    set data(dimensions) [lindex $axis_info 0]

    if { $data(dimensions) eq "xyz"} {
	$::GlobalAxis::data(grid,labelcol,x) configure -state normal
	$::GlobalAxis::data(grid,labelcol,y) configure -state normal
	$::GlobalAxis::data(grid,labelcol,z) configure -state normal
    } elseif { $data(dimensions) eq "xy"} {
	$::GlobalAxis::data(grid,labelcol,x) configure -state normal
	$::GlobalAxis::data(grid,labelcol,y) configure -state disabled
	$::GlobalAxis::data(grid,labelcol,z) configure -state disabled
	set data(grid,color,y) ""
	set data(grid,color,z) ""
	#set data(grid,color,y) $::GlobalAxis::data(nocolor)
	#set data(grid,color,z) $::GlobalAxis::data(nocolor)
    } elseif { $data(dimensions) eq "xz"} {
	$::GlobalAxis::data(grid,labelcol,x) configure -state disabled
	$::GlobalAxis::data(grid,labelcol,y) configure -state disabled
	$::GlobalAxis::data(grid,labelcol,z) configure -state normal
	set data(grid,color,x) ""
	set data(grid,color,y) ""
	#set data(grid,color,x) $::GlobalAxis::data(nocolor)
	#set data(grid,color,y) $::GlobalAxis::data(nocolor)
    } else {
	$::GlobalAxis::data(grid,labelcol,x) configure -state disabled
	$::GlobalAxis::data(grid,labelcol,y) configure -state normal
	$::GlobalAxis::data(grid,labelcol,z) configure -state disabled
	set data(grid,color,x) ""
	set data(grid,color,z) ""
	#set data(grid,color,x) $::GlobalAxis::data(nocolor)
	#set data(grid,color,z) $::GlobalAxis::data(nocolor)
    }

    ::GlobalAxis::UpdateGridColor
}

proc ::GlobalAxis::FillLabelsOp { } {
    variable data

    # Labels
    set label_info [ GiD_Info postprocess get axis_option Label]
    set label_info [lindex $label_info 0]
    set data(label) [lindex $label_info 0]

    set labeltype_info [ GiD_Info postprocess get axis_option LabelType]
    set labeltype_info [lindex $labeltype_info 0]
    set data(label,type) [lindex $labeltype_info 0]

    set labelfont_info [ GiD_Info postprocess get axis_option VarFontSize]
    set labelfont_info [lindex $labelfont_info 0]
    set data(label,font) [lindex $labelfont_info 0]

    #set labelcolorx_info [ GiD_Info postprocess get axis_option LabelXColor]
    #set labelcolorx_info [lindex $labelcolorx_info 0]
    #set data(label,color,x) [lindex $labelcolorx_info 0]

    #set labelcolory_info [ GiD_Info postprocess get axis_option LabelYColor]
    #set labelcolory_info [lindex $labelcolory_info 0]
    #set data(label,color,y) [lindex $labelcolory_info 0]

    #set labelcolorz_info [ GiD_Info postprocess get axis_option LabelZColor]
    #set labelcolorz_info [lindex $labelcolorz_info 0]
    #set data(label,color,z) [lindex $labelcolorz_info 0]

    set labelaxescolor_info [ GiD_Info postprocess get axis_option LabelColorAxes]
    set labelaxescolor_info [lindex $labelaxescolor_info 0]
    set data(label,axescolor) [lindex $labelaxescolor_info 0]

    set labelcolor_info [ GiD_Info postprocess get axis_option LabelColor]
    set labelcolor_info [lindex $labelcolor_info 0]
    set data(label,color) [lindex $labelcolor_info 0]

    # 2D, 3D?
    set axis_info [ GiD_Info postprocess get axis_option Dimensions]
    set axis_info [lindex $axis_info 0]
    set data(dimensions) [lindex $axis_info 0]

    if { $data(dimensions) eq "xyz"} {
	#$::GlobalAxis::data(label,labelcol,x) configure -state normal
	#$::GlobalAxis::data(label,labelcol,y) configure -state normal
	#$::GlobalAxis::data(label,labelcol,z) configure -state normal
	$::GlobalAxis::data(divxnum) configure -state normal
	$::GlobalAxis::data(divynum) configure -state normal
	$::GlobalAxis::data(divznum) configure -state normal
    } elseif { $data(dimensions) eq "xy"} {
	#$::GlobalAxis::data(label,labelcol,x) configure -state normal
	#$::GlobalAxis::data(label,labelcol,y) configure -state normal
	#$::GlobalAxis::data(label,labelcol,z) configure -state disabled
	$::GlobalAxis::data(divxnum) configure -state normal
	$::GlobalAxis::data(divynum) configure -state normal
	$::GlobalAxis::data(divznum) configure -state disabled
	set data(label,color,z) ""
	#set data(label,color,z) $::GlobalAxis::data(nocolor)
    } elseif { $data(dimensions) eq "xz"} {
	#$::GlobalAxis::data(label,labelcol,x) configure -state normal
	#$::GlobalAxis::data(label,labelcol,y) configure -state disabled
	#$::GlobalAxis::data(label,labelcol,z) configure -state normal
	$::GlobalAxis::data(divxnum) configure -state normal
	$::GlobalAxis::data(divynum) configure -state disabled
	$::GlobalAxis::data(divznum) configure -state normal
	set data(label,color,y) ""
	#set data(label,color,y) $::GlobalAxis::data(nocolor)
    } else {
	#$::GlobalAxis::data(label,labelcol,x) configure -state disabled
	#$::GlobalAxis::data(label,labelcol,y) configure -state normal
	#$::GlobalAxis::data(label,labelcol,z) configure -state normal
	$::GlobalAxis::data(divxnum) configure -state disabled
	$::GlobalAxis::data(divynum) configure -state normal
	$::GlobalAxis::data(divznum) configure -state normal
	set data(label,color,x) ""
	#set data(label,color,x) $::GlobalAxis::data(nocolor)
    }

    ::GlobalAxis::OnChangeColor
    ::GlobalAxis::UpdateLabColor

}

proc ::GlobalAxis::FillArrowsOp { } {
    variable data

    # Arrows
    set arrow_info [ GiD_Info postprocess get axis_option Arrow]
    set arrow_info [lindex $arrow_info 0]
    set data(arrow) [lindex $arrow_info 0]

    set arrowcolorx_info [ GiD_Info postprocess get axis_option ArrowXColor]
    set arrowcolorx_info [lindex $arrowcolorx_info 0]
    set data(arrow,color,x) [lindex $arrowcolorx_info 0]

    set arrowcolory_info [ GiD_Info postprocess get axis_option ArrowYColor]
    set arrowcolory_info [lindex $arrowcolory_info 0]
    set data(arrow,color,y) [lindex $arrowcolory_info 0]

    set arrowcolorz_info [ GiD_Info postprocess get axis_option ArrowZColor]
    set arrowcolorz_info [lindex $arrowcolorz_info 0]
    set data(arrow,color,z) [lindex $arrowcolorz_info 0]

    ::GlobalAxis::UpdateArrowColor

}

### Close
#
proc ::GlobalAxis::OnClose { } {
  variable data

  destroy $data(wid,main)
}


### Apply
#
proc ::GlobalAxis::OnApply { } {
    variable data

    #set current [$data(wid,nb) index "current"]
    #switch $current {
    #    0 { ApplyAxisOp}
    #    1 { ApplyGridOp}
    #    2 { ApplyLabOp}
    #    3 { ApplyArrOp}
    #}
    GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs No

    ApplyAxisOp
    ApplyGridOp
    ApplyLabOp
    #ApplyArrOp
}

proc ::GlobalAxis::ApplyAxisOp { } {
    variable data

    #set cur [lindex [lindex [ GiD_Info postprocess get axis_option Axes] 0] 0]
    #if {$cur ne $data(axis)} {
	#    if {$data(axis) eq "Basic" } {
	    #        GiD_Process escape escape escape escape View GlobalAxes Basic
	    #    } elseif {$data(axis) eq "Box" } {
	    #        GiD_Process escape escape escape escape View GlobalAxes Box
	    #    } elseif {$data(axis) eq "NoAxes" }  {
	    #        GiD_Process escape escape escape escape View GlobalAxes NoAxes
	    #    }
	#}

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option ShowAxes] 0] 0]
    set cur2 [lindex [lindex [ GiD_Info postprocess get axis_option Type] 0] 0]
    if {$cur ne $data(axis) || $cur2 ne $data(type)} {
	if {$data(axis) eq "Yes" } {
	    if {$data(type) eq "Basic"} {
		GiD_Process escape escape escape escape View GlobalAxes Basic
	    } elseif {$data(type) eq "Box" } {
		GiD_Process escape escape escape escape View GlobalAxes Box
	    }
	} elseif {$data(axis) eq "NoAxes" }  {
	    GiD_Process escape escape escape escape View GlobalAxes NoAxes
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option AxesWidth] 0] 0]
    if {$cur ne $data(width)} {
	set width [$::GlobalAxis::data(widthnum) get]
	GiD_Process escape escape escape escape View GlobalAxes AxesWidth $width
    }

    if {$data(axis,color,x) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option AxisXColor] 0] 0]
	if {$cur ne $data(axis,color,x)} {
	    GiD_Process escape escape escape escape View GlobalAxes AxesColor XAxis $data(axis,color,x)
	}
    }

    if {$data(axis,color,y) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option AxisYColor] 0] 0]
	if {$cur ne $data(axis,color,y)} {
	    GiD_Process escape escape escape escape View GlobalAxes AxesColor YAxis $data(axis,color,y)
	}
    }

    if {$data(axis,color,z) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option AxisZColor] 0] 0]
	if {$cur ne $data(axis,color,z)} {
	    GiD_Process escape escape escape escape View GlobalAxes AxesColor ZAxis $data(axis,color,z)
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option Arrow] 0] 0]
    if {$cur ne $data(arrow)} {
	if {$data(arrow) eq "Yes" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowArrows Yes
	} elseif {$data(arrow) eq "No" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowArrows No
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option XYZLabels] 0] 0]
    if {$cur ne $data(xyz)} {
	if {$data(xyz) eq "Yes" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowXYZLabels Yes
	} elseif {$data(xyz) eq "No" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowXYZLabels No
	}
    }

    ::GlobalAxis::FillAxisOp
}

proc ::GlobalAxis::ApplyGridOp { } {
    variable data

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option Grid] 0] 0]
    if {$cur ne $data(grid)} {
	if {$data(grid) eq "Yes" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowGrid Yes
	} elseif {$data(grid) eq "No" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowGrid No
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option Patron] 0] 0]
    if {$cur ne $data(pattern)} {
	GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridPattern $::GlobalAxis::data(pattern)
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option FactorPatron] 0] 0]
    if {$cur ne $data(factor)} {
	set factor [$::GlobalAxis::data(factornum) get]
	GiD_Process escape escape escape escape View GlobalAxes ShowGrid PatternFactor $factor
    }

    if {$data(grid,color,x) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option GridXColor] 0] 0]
	if {$cur ne $data(grid,color,x)} {
	    GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridColor GridXColor $data(grid,color,x)
	}
    }

    if {$data(grid,color,y) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option GridYColor] 0] 0]
	if {$cur ne $data(grid,color,y)} {
	    GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridColor GridYColor $data(grid,color,y)
	}
    }

    if {$data(grid,color,z) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option GridZColor] 0] 0]
	if {$cur ne $data(grid,color,z)} {
	    GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridColor GridZColor $data(grid,color,z)
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option GridXDivisions] 0] 0]
    if {$cur ne $data(divx)} {
	set div [$::GlobalAxis::data(divxnum) get]
	GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridDivisions GridXDivisions $div
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option GridYDivisions] 0] 0]
    if {$cur ne $data(divy)} {
	set div [$::GlobalAxis::data(divynum) get]
	GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridDivisions GridYDivisions $div
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option GridZDivisions] 0] 0]
    if {$cur ne $data(divz)} {
	set div [$::GlobalAxis::data(divznum) get]
	GiD_Process escape escape escape escape View GlobalAxes ShowGrid GridDivisions GridZDivisions $div
    }

    ::GlobalAxis::FillGridOp
}

proc ::GlobalAxis::ApplyLabOp { } {
    variable data

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option Label] 0] 0]
    set cur2 [lindex [lindex [ GiD_Info postprocess get axis_option LabelType] 0] 0]
    if {$cur ne $data(label) || $cur2 ne $data(label,type)} {
	if {$data(label) eq "Yes" } {
	    if {$data(label,type) eq "Static" } {
		GiD_Process escape escape escape escape View GlobalAxes ShowLabels Static
		set data(grid) "Yes"
	    } else {
		GiD_Process escape escape escape escape View GlobalAxes ShowLabels Dynamic
		set data(grid) "Yes"
	    }
	} elseif {$data(label) eq "No" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowLabels No
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option VarFontSize] 0] 0]
    if {$cur ne $data(label,font)} {
	if {$data(label,font) eq "Yes" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowLabels VarFontSize Yes
	} elseif {$data(label,font) eq "No" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowLabels VarFontSize No
	}
    }

    set cur [lindex [lindex [ GiD_Info postprocess get axis_option LabelColorAxes] 0] 0]
    if {$cur ne $data(label,axescolor)} {
	if {$data(label,axescolor) eq "Yes" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowLabels LabelColor ColorAsAxes Yes
	} elseif {$data(label,axescolor) eq "No" } {
	    GiD_Process escape escape escape escape View GlobalAxes ShowLabels LabelColor ColorAsAxes No
	}
    }

    set prova $data(label,color)
    if {$data(label,color) ne $data(nocolor)} {
	set cur [lindex [lindex [ GiD_Info postprocess get axis_option LabelColor] 0] 0]
	if {$cur ne $data(label,color)} {
	    GiD_Process escape escape escape escape View GlobalAxes ShowLabels LabelColor AltColor $data(label,color)
	}
    }

    #if {$data(label,color,x) ne $data(nocolor)} {
	#    set cur [lindex [lindex [ GiD_Info postprocess get axis_option LabelXColor] 0] 0]
	#     if {$cur ne $data(label,color,x)} {
	    #        GiD_Process escape escape escape escape View GlobalAxes ShowLabels LabelColor LabelXColor $data(label,color,x)
	    #    }
	#}

    #if {$data(label,color,y) ne $data(nocolor)} {
	#    set cur [lindex [lindex [ GiD_Info postprocess get axis_option LabelYColor] 0] 0]
	#   if {$cur ne $data(label,color,y)} {
	    #        GiD_Process escape escape escape escape View GlobalAxes ShowLabels LabelColor LabelYColor $data(label,color,y)
	    #    }
	#}

    #if {$data(label,color,z) ne $data(nocolor)} {
	#    set cur [lindex [lindex [ GiD_Info postprocess get axis_option LabelZColor] 0] 0]
	#    if {$cur ne $data(label,color,z)} {
	    #        GiD_Process escape escape escape escape View GlobalAxes ShowLabels LabelColor LabelZColor $data(label,color,z)
	    #    }
	#}

    ::GlobalAxis::FillLabelsOp
}

proc ::GlobalAxis::ApplyArrOp { } {
    variable data

    if {$data(arrow) eq "Yes" } {
	GiD_Process escape escape escape escape View GlobalAxes ShowArrows Yes
    } elseif {$data(arrow) eq "No" } {
	GiD_Process escape escape escape escape View GlobalAxes ShowArrows No
    }

    GiD_Process escape escape escape escape View GlobalAxes ShowArrows ArrowsColor ArrowXColor $data(arrow,color,x)
    GiD_Process escape escape escape escape View GlobalAxes ShowArrows ArrowsColor ArrowYColor $data(arrow,color,y)
    GiD_Process escape escape escape escape View GlobalAxes ShowArrows ArrowsColor ArrowZColor $data(arrow,color,z)

    ::GlobalAxis::FillArrowsOp
}

proc ::GlobalAxis::OnReset { } {
  variable data

    GiD_Process Mescape Results Graphs OptionsGraph ShowGraphs No

    GiD_Process escape escape escape escape View GlobalAxes Reset

    ::GlobalAxis::FillAxisOp
    ::GlobalAxis::FillGridOp
    ::GlobalAxis::FillLabelsOp
    #::GlobalAxis::FillArrowsOp
}
