if {[catch {package present Tcl 8.6.5}]} { return }
## if {($::tcl_platform(platform) eq "unix") && ([info exists ::env(DISPLAY)]
## 	|| ([info exists ::argv] && ("-display" in $::argv)))} {
##     package ifneeded Tk 8.6.12 [list load [file join $dir .. .. bin libtk8.6.dll] Tk]
## } else {
##     package ifneeded Tk 8.6.12 [list load [file join $dir .. .. bin tk86t.dll] Tk]
## }
# if {($::tcl_platform(platform) eq "unix") && ([info exists ::env(DISPLAY)]
# 	|| ([info exists ::argv] && ("-display" in $::argv)))} {
# }
# on Mac OS X 10.9, there is no DISPLAY variable, and tk can be loaded without -display argument...
# so:

proc LoadLibraryTk { dir basename } {
    package require Tcl 8.6   
    if { $::tcl_platform(pointerSize) == 8} {
	set bits 64
    } else {
	set bits 32
    }
    set filename_library ""
    if { $::tcl_platform(platform) == "windows" } {
	set library tk86t[info sharedlibextension]
	#in development the library is inside lib/x32 or /lib/64 to allow on disk simultaneously both versions
	#in final packaging the library is in the same place that in the past, in the GiD folder (to be found by gid.exe)
	foreach relative_folder [list ".. .. lib x${bits}" ".. .."] {
	    set filename [file normalize [file join $dir {*}$relative_folder $library]]	    
	    if { [file exists $filename] } {
		set filename_library $filename
		break
	    }
	}	
    } else {
	set library libtk8.6[info sharedlibextension]	
	foreach relative_folder [list ".." ".. .." ".. .. .." "$::env(HOME)"] {
	    set filename [file normalize [file join $dir {*}$relative_folder "lib" $library]]
	    if { [file exists $filename] } {	
		set filename_library $filename	
		break
	    }
            if { $::tcl_platform(os) == "Darwin" } {
                set filename [file normalize [file join $dir {*}$relative_folder "MacOS" "lib" $library]]
                if { [file exists $filename] } {	
                    set filename_library $filename	
                    break
                }
            }
	}	
    }
    if { $filename_library != "" } {
	load $filename_library $basename
    } else {
	error "couldn't load library \"$library\": this library or a dependent library could not be found in library path"
    }
}

package ifneeded Tk 8.6.13 [list LoadLibraryTk $dir Tk]
