
proc test_GiD_Mesh { } {
    set fail 0
    #test create node
    GiD_Mesh create node append {-3.07042 1.78873 0.0}
    GiD_Mesh create node append {-1.49296 0.535211 0.0}
    if { [llength [GiD_Mesh list node]] != 2 } {
        incr fail
    }
    #test create element
    GiD_Mesh create element append Line 2 {1 2}
    if { [llength [GiD_Mesh list element]] != 1 } {
        incr fail
    }
    #test create with forced num=5
    GiD_Mesh create node 5 {-1.35211 -0.422535 0.0}
    if { [GiD_Mesh list node 5] != 5 } {
        incr fail
    }
    GiD_Mesh create node append {-3.04767 0.200466 0}
    if { [llength [GiD_Mesh list -higherentity 1 node]] != 2 } {
        incr fail
    }
    set data_out [GiD_Mesh get node 2]
    if { $data_out != "Layer0 -1.49296 0.535211 0.0" } {
        incr fail
    }
    set data_out [GiD_Mesh get element 1]
    if { $data_out != "Layer0 Linear 2 1 2" } {
        incr fail
    }
    if { [llength [GiD_Mesh list node]] != 4 } {
        incr fail
    }
    if { [llength [GiD_Mesh list node 1:]] != 4 } {
        incr fail
    }
    if { [llength [GiD_Mesh list node 1:end]] != 4 } {
        incr fail
    }
    if { [llength [GiD_Mesh list node 1:100]] != 4 } {
        incr fail
    }
    #check that now really returns an objarray, not a list
    if { [objarray length [GiD_Mesh list node]] != 4 } {
        incr fail
    }
    #test delete isolated nodes
    GiD_Mesh delete node [GiD_Mesh list -higherentity 0 node]
    if { [llength [GiD_Mesh list node]] != 2 } {
        incr fail
    }
    return $fail
}
