
proc test_GiD_Info-Mesh { } {
    set fail 0
    #create two rectangles
    DoFilesNew
    GiD_Process Mescape Geometry Create Object Rectangle 1.0,1.0,0.0 2.0,2.0,0.0 escape
    GiD_Layers create "Second rectangle"
    GiD_Layers edit to_use "Second rectangle"
    GiD_Process Mescape Geometry Create Object Rectangle 2.5.0,1.0,0.0 5.0,2.0,0.0 escape
    GiD_Groups create "group b"
    GiD_EntitiesGroups assign "group b" surfaces {2}
    #set second rectangle to be meshed with quadrilaterals
    GiD_MeshData element_type surfaces Quadrilateral {2}
    #generate a mesh
    GiD_Process Mescape Meshing Generate Yes 0.5 escape
    
    set expected_elements {Triangle Quadrilateral}

    #test GiD_Info mesh
    set info_mesh [GiD_Info mesh]
    set num_element_types [expr [llength $info_mesh] -1]
    if { [lindex $info_mesh 0] != 1  || $num_element_types != [llength $expected_elements] } {
	    incr fail
    }

    #test numelements and elements any -sublist
    set num_elements [GiD_Info mesh numelements]
    set elements_data_sublist [GiD_Info mesh elements any -sublist]
    if { [llength $elements_data_sublist] != $num_elements } {
	    incr fail
    }

    #test elements any -array
    set elements_data_array [GiD_Info mesh elements any -array]
    if { [llength $elements_data_array] != $num_element_types  } {
	    incr fail
    }
    foreach element_type $expected_elements {
      set pos [lsearch -index 0 $elements_data_array $element_type]
      if { $pos== -1} {
          incr fail
      } else {
          set n [llength [lindex [lindex [GiD_Info mesh elements any -array] $pos] 1]]
          if { $n != [GiD_Info mesh numelements $element_type] } {
              incr fail
          }
      }
    }

    #
    #set second rectangle to be meshed with triangles
    GiD_MeshData element_type surfaces Triangle {2}
    #generate a mesh
    GiD_Process Mescape Meshing Generate Yes 0.5 escape

    set expected_elements {Triangle}

    #test GiD_Info mesh
    set info_mesh [GiD_Info mesh]
    set num_element_types [expr [llength $info_mesh] -1]
    if { [lindex $info_mesh 0] != 1  || $num_element_types != [llength $expected_elements] } {
	    incr fail
    }

    #test numelements and elements any -sublist
    set num_elements [GiD_Info mesh numelements]
    set elements_data_sublist [GiD_Info mesh elements any -sublist]
    if { [llength $elements_data_sublist] != $num_elements } {
	    incr fail
    }

    #test elements any -array
    set elements_data_array [GiD_Info mesh elements any -array]
    if { [llength $elements_data_array] != $num_element_types  } {
	    incr fail
    }
    foreach element_type $expected_elements {
      set pos [lsearch -index 0 $elements_data_array $element_type]
      if { $pos== -1} {
          incr fail
      } else {
          set n [llength [lindex [lindex [GiD_Info mesh elements any -array] $pos] 1]]
          if { $n != [GiD_Info mesh numelements $element_type] } {
              incr fail
          }
      }
    }

    set elements_data_sublist_layer [GiD_Info mesh elements any -sublist -layer "Second rectangle"]
    set elements_data_sublist_group [GiD_Info mesh elements any -sublist -group "group b"]
    if { [llength $elements_data_sublist_layer] != [llength $elements_data_sublist_group] } {
	    incr fail
    } elseif { [llength $elements_data_sublist_layer] == 0 || [llength $elements_data_sublist_layer] >= $num_elements } {
        incr fail
    }

    return $fail
}
