
proc test_GiD_Geometry { } {
    set fail 0
    #test create points
    GiD_Geometry create point append Layer0 -3.07042 1.78873 0.0    
    GiD_Geometry create point append Layer0 -1.49296 0.535211 0.0
    if { [llength [GiD_Geometry list point 1:end]] != 2 } {
        incr fail
    }
    #test create stline 
    GiD_Geometry create line append stline Layer0 1 2
    if { [llength [GiD_Geometry list line 1:end]] != 1 } {
        incr fail
    }
    #test create with forced num=5
    GiD_Geometry create point 5 Layer0 -1.35211 -0.422535 0.0
    if { ![GiD_Geometry exists point 5] } {
        incr fail
    }
    #test create nurbsline syntax -v2 new better syntax (-v2 change for lines, surfaces and volumes)
    set nurbsline_data_v2 {nurbsline Layer0 2 5 {3 4 {-1.49296 0.535211 0.0 -1.43662 0.1521126 0.0 -1.40845 -0.03943659999999999 0.0 -1.35211 -0.422535 0.0} {} {0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0}}}
    GiD_Geometry -v2 create line append {*}$nurbsline_data_v2 
    if { [llength [GiD_Geometry list line 1:end]] != 2 } {
        incr fail
    }
    #test get nurbsline data -v2
    set data_out_v2 [GiD_Geometry -v2 get line 2]
    if { $data_out_v2 != $nurbsline_data_v2 } {
        incr fail
    }

    #test create nurbline syntax -v2 interpolating
    GiD_Geometry -v2 create line append nurbsline Layer0 2 5 {-interpolate {-3.07042 1.78873 0.0 -1.49296 0.535211 0.0 -1.35211 -0.422535 0.0}}
    if { [llength [GiD_Geometry list line 1:end]] != 3 } {
        incr fail
    } else {
       GiD_Geometry delete line 3
    }

    #test create arcline v1
    set arcline_data_v1 {arcline Layer0 5 1 {0.4541749083377887 0.3849513228129927} 1.4126290474725958 2.3641302470252725 5.240260395969488 {0.2470076446513308 0.9690135311149177 0.0 0.0 0.9690135311149177 -0.2470076446513309 0.0 0.0 0.0 0.0 -0.9999999999999998 0.0 -2.548852806656839 0.4527929440275824 0.0 1.0}}
    GiD_Geometry create line append {*}$arcline_data_v1
    if { [llength [GiD_Geometry list line 1:end]] != 3 } {
        incr fail
    }
    #test get arcline data -v2
    set arcline_data_v2 {arcline Layer0 5 1 {0.4541749083377887 0.3849513228129927 1.4126290474725958 2.3641302470252725 5.240260395969488 {0.2470076446513308 0.9690135311149177 0.0 0.0 0.9690135311149177 -0.2470076446513309 0.0 0.0 0.0 0.0 -0.9999999999999998 0.0 -2.548852806656839 0.4527929440275824 0.0 1.0}}}
    set data_out_v2 [GiD_Geometry -v2 get line 3]
    if { $data_out_v2 != $arcline_data_v2 } {
        incr fail
    }
    #-v2 is better because is more sistematic, e.g. the amount of items is the same for all type of lines
    if { [llength $data_out_v2] != 5 } {
        incr fail
    }
    #test create nurbsurface -v2
    set nurbsurface_data_v2 {nurbssurface Layer0 1 {3 2 1} {1 1 1} {1 1 2 2 {-3.6034038393001135 -0.9738067570360022 0.0 -0.7535148846316866 -0.9738067570360022 0.0 -3.6034038393001135 1.920279369382667 0.0 -0.7535148846316866 1.920279369382667 0.0} {} {0.0 0.0 1.0 1.0} {0.0 0.0 1.0 1.0}}}
    GiD_Geometry -v2 create surface append {*}$nurbsurface_data_v2 
    if { [llength [GiD_Geometry list surface 1:end]] != 1 } {
        incr fail
    }
    #test delete a line that belong to a surface, and then must not be deleted
    GiD_Geometry delete line 1
    if { [llength [GiD_Geometry list line 1:end]] != 3 } {
        incr fail
    }
    #test get nurbsurface -v1
    set data_out_v1 [GiD_Geometry get surface 1]
    #test delete surface
    GiD_Geometry delete surface 1
    if { [llength [GiD_Geometry list surface 1:end]] != 0 } {
        incr fail
    }
    #re-create nurbsurface -v1
    GiD_Geometry create surface append {*}$data_out_v1
    if { [llength [GiD_Geometry list surface 1:end]] != 1 } {
        incr fail
    }    
    #create surfaces by extrusion with GiD_Process commands (it doesn't exists any direct Tcl command like GiD_Geometry to do it now...)
    GiD_Process Mescape Utilities Copy Surfaces Duplicate DoExtrude Volumes MaintainLayers Translation FNoJoin 0,0,0 FNoJoin 0,0,2.5 1:end escape
    if { [llength [GiD_Geometry list volume 1:end]] != 1 } {
        incr fail
    }
    #test get volume -v1
    set data_out_v1 [GiD_Geometry get volume 1]
    #test delete volume
    GiD_Geometry delete volume 1
    if { [llength [GiD_Geometry list volume 1:end]] != 0 } {
        incr fail
    }
    #re-create volume -v1
    GiD_Geometry create volume append {*}$data_out_v1
    if { [llength [GiD_Geometry list volume 1:end]] != 1 } {
        incr fail
    }
    #test get volume -v2
    set data_out_v2 [GiD_Geometry -v2 get volume 1]
    #test delete volume
    GiD_Geometry delete volume 1
    if { [llength [GiD_Geometry list volume 1:end]] != 0 } {
        incr fail
    }
    #re-create volume -v2
    GiD_Geometry -v2 create volume append {*}$data_out_v2
    if { [llength [GiD_Geometry list volume 1:end]] != 1 } {
        incr fail
    }
    if { [llength [GiD_Geometry list line]] != 9 } {
        incr fail
    }
    if { [llength [GiD_Geometry list line 1:]] != 9 } {
        incr fail
    }
    if { [llength [GiD_Geometry list line 1:end]] != 9 } {
        incr fail
    }

    if { [llength [GiD_Geometry list line 1:9]] != 9 } {
        incr fail
    }
    #check that now really returns an objarray, not a list
    if { [objarray length [GiD_Geometry list line]] != 9 } {
        incr fail
    }

    #test get render_mesh. initially the render mesh of the surface is not created, use -force to force its creation
    set render_mesh [GiD_Geometry get surface 1 -force render_mesh]
    lassign $render_mesh element_type element_num_nodes coordinates connectivities normals uvs
    if { [llength $render_mesh] != 6 } {
        incr fail
    } elseif { $element_type != "triangle" || $element_num_nodes != 3 } {
        incr fail
    } elseif { [objarray minimum $coordinates] < -3.5 || [objarray maximum $coordinates] > 1.8 } {
        incr fail
    } elseif { [objarray minimum $connectivities] < 0 || [objarray maximum $connectivities] >= [objarray length $coordinates] } {
        incr fail
    } elseif { [objarray minimum $normals] < -1.0 || [objarray maximum $normals] > 1.0 } {
        incr fail
    } elseif { [objarray minimum $uvs] < 0.0 || [objarray maximum $uvs] > 1.0 } {
        incr fail
    }
    return $fail
}
