namespace eval ::PostUtils {
}

#Fills the values of the scalars list
proc ::PostUtils::Get_Resultados_Nodales_Escalares { } {
    set ret {}
    set all [ GiD_Info postprocess get cur_results_list "Result_Surface" ]
    foreach res $all {
        if { [ llength [ GiD_Info postprocess get cur_components_list $res ]] == 1} {
            lappend ret $res
        }
    }
    return $ret
}

#Vector's creation code
proc ::PostUtils::ConvierteEscalarAVector { w} {
    ::PostUtils::ActualizaListaEscalares $w all
    set i 1
    while { $i <= $::PostUtils::Number_vectors } {
        set scalar_name ::PostUtils::EscalarAConvertir$i
        if { [set $scalar_name] == "" } {
            WarnWin [_ "Please, select a valid scalar result for Scalar result $i"] $w
            return
        }
        incr i
    }
    set ::PostUtils::NombreVector $::PostUtils::TxtNombreVector
    if { $::PostUtils::NombreVector == ""} {
        WarnWin [_ "Please, enter a name for the vector result"] $w
        return
    }
    set analisis_actual $::PostUtils::Analisis
    set all_steps $::PostUtils::Step
    if { $::PostUtils::AllSteps} {
        set all_steps [ GiD_Info postprocess get all_steps $::PostUtils::Analisis]
    }
    set texto_salida ""
    foreach current_step $all_steps {
        set cabecera [ list Result $::PostUtils::NombreVector $analisis_actual $current_step "Vector" "OnNodes"]
        set res_salida {}
        lappend res_salida $cabecera
        set dict_values ""
        set all_exist 1
        #We fill a dictionary with the values of all the vectors for this step
        foreach i [list 1 2 3] {
            if {$i > $::PostUtils::Number_vectors} break
            set scalar_name ::PostUtils::EscalarAConvertir$i
            set res_info ""
            set err [ catch {
                    set res_info [GiD_Result get [list [set $scalar_name] $analisis_actual $current_step]]
                } ]
            if { $err} {
                set all_exist 0
                break
            }
            foreach entrada [ lrange $res_info 3 end] {
                if { ( [ llength $entrada] == 2) && ( [ scan $entrada "%d %g" idx_nodo escalar] == 2) } {
                    foreach coordinate [list x y z] {
                        set vector_name "::PostUtils::VectorAUsar$i\($coordinate\)"
                        if {[dict exists $dict_values $idx_nodo $coordinate] == "0"} {
                            set ancient_value 0
                        } else {
                            set ancient_value [dict get $dict_values $idx_nodo $coordinate]
                        }
                        set new_value [expr ($escalar * [set $vector_name])]
                        dict set dict_values $idx_nodo $coordinate [ expr ($ancient_value + $new_value)]
                    }
                }
            }
        }
        #If some vector is missing for this step, we evaluate the next one
        if {$all_exist == "1"} {
            #We convert our dictionary to the proper GiD format
            foreach nodeid [dict keys $dict_values] {
                set input_list [list $nodeid]
                foreach position [list x y z] {
                    lappend input_list [dict get $dict_values $nodeid $position]
                }
                lappend res_salida $input_list
            }
            GiD_Result create {*}$res_salida
            #We update the output text and we delete the ancient value if needed
            append texto_salida  [_ "\nVector result '%s'  ('%s', step '%s') created\n from" $::PostUtils::TxtNombreVector $analisis_actual $current_step]
            set i 1
            while { $i <= $::PostUtils::Number_vectors } {
                set scalar_name ::PostUtils::TxtEscalarAConvertir$i
                if {$::PostUtils::Delete_scalars == "1"} {                   
                    set erasing_list [list [set $scalar_name] $analisis_actual $current_step]
                    GiD_Result delete $erasing_list
                }
                set vector_x "::PostUtils::VectorAUsar$i\(x\)"
                set vector_y "::PostUtils::VectorAUsar$i\(y\)"
                set vector_z "::PostUtils::VectorAUsar$i\(z\)"
                if {$::PostUtils::Number_vectors != "1" && $i == $::PostUtils::Number_vectors} {
                    append texto_salida [_ " and"]
                }
                append texto_salida [_ " scalar %s using vector \(%s,%s,%s\)" [set $scalar_name] [set $vector_x] [set $vector_y] [set $vector_z]]
                incr i
            }
        }
    }
    if {$::PostUtils::Delete_scalars == "1"} {
        append texto_salida [_ "\n\nOriginal scalar results have been deleted"]
    }
    WarnWinText $texto_salida
}

#Fills the list of analysis
proc ::PostUtils::ActualizaListaAnalisis { w} {
    $w configure -values [lsort -dictionary [GiD_Info postprocess get all_analysis]]
}

#Dependencies of the analysis selection
proc ::PostUtils::UpdateListSteps { w w_local} {
    if { $::PostUtils::TxtAnalisis == "" } { return }
    set ::PostUtils::Analisis [ list $::PostUtils::TxtAnalisis]
    if { $::PostUtils::Analisis != ""} {
        set all_steps [ GiD_Info postprocess get all_steps $::PostUtils::Analisis]
        $w_local configure -values $all_steps
        set analisis_actual [ GiD_Info postprocess get cur_analysis]
        if { $analisis_actual == $::PostUtils::Analisis } {
            set current_step [ GiD_Info postprocess get cur_step $analisis_actual]
        } else {
            set current_step [ lindex $all_steps 0]
        }
        set ::PostUtils::Step $current_step
        if {$::PostUtils::Scalars_initialized == 1 } {
            ::PostUtils::ActualizaListaEscalares $w all
        }
    }
}

#Update the values of the scalar lists
proc ::PostUtils::ActualizaListaEscalares { w index } {
    if { $index == "all" } {
        set index_list [list 1 2 3]
        set windows_list [list $w.f.m11 $w.f.m12 $w.f.m13]
    } else {
        set index_list [list $index]
        set windows_list [list $w]
    }
    
    if { $::PostUtils::Analisis != "" } {
        if { $::PostUtils::Step != "" } {
            set ret {}
            set all [GiD_Info postprocess get results_list Result_Surface $::PostUtils::Analisis $::PostUtils::Step]
            foreach res $all {
                if { [ llength [GiD_Info postprocess get components_list Result_Surface $res $::PostUtils::Analisis $::PostUtils::Step]] == 1} {
                    lappend ret $res
                }
            }
            foreach window $windows_list {
                $window configure -values $ret
            }
            foreach position $index_list {
                set var_name ::PostUtils::EscalarAConvertir$position
                set var_txt_name ::PostUtils::TxtEscalarAConvertir$position
                if { [lsearch $ret [set $var_name]] == -1 } {
                    if { [llength $ret] != 0} {
                        set $var_name [lindex $ret 0]
                    } else {
                        set $var_name ""
                    }
                    set $var_name [set $var_txt_name]
                    if { $position == 1} {
                        ::PostUtils::ActualizaNombreVector
                    }
                }
            }
        }
    }
}

#Dependencies of the all steps check button
proc ::PostUtils::EnableDisableLista { w} {
    if { $::PostUtils::AllSteps} {
        $w configure -state disabled
    } else {
        $w configure -state normal
    }
}

#Define the dependencies of the dimension selector
proc ::PostUtils::Updatedimension { w } {
    foreach i [list 3 2] {
        if { $::PostUtils::Number_vectors >= $i} {
            $w.f.m1$i configure -state normal
            if { $::PostUtils::Conversion_mode == [_ "User_defined"]} {
                foreach j [list x y z] { $w.f.fv$i.e$j configure -state normal }
            }
        } else {
            $w.f.m1$i configure -state disabled
            foreach j [list x y z] { $w.f.fv$i.e$j configure -state disable }
        }
    }
    ::PostUtils::ActualizaNombreVector
}

#Define the dependencies of the Conversion mode selector
proc ::PostUtils::Updatestatevectors { w } {
    if { $::PostUtils::Conversion_mode == [_ "User_defined"] } {
        foreach i [list 1 2 3] {
            if { $::PostUtils::Number_vectors >= $i} {
                foreach j [list x y z] {
                    $w.f.fv$i.e$j configure -state normal
                }
            }
        }
    } else {
        ::PostUtils::Initializevectors
        foreach i [list 1 2 3] {
            foreach j [list x y z] {
                $w.f.fv$i.e$j configure -state disabled
            }
        }
    }
}

#Gives to the three vectors the main axes values
proc ::PostUtils::Initializevectors {} {
    set ::PostUtils::VectorAUsar1(x) 1.0
    set ::PostUtils::VectorAUsar1(y) 0.0
    set ::PostUtils::VectorAUsar1(z) 0.0
    set ::PostUtils::VectorAUsar2(x) 0.0
    set ::PostUtils::VectorAUsar2(y) 1.0
    set ::PostUtils::VectorAUsar2(z) 0.0
    set ::PostUtils::VectorAUsar3(x) 0.0
    set ::PostUtils::VectorAUsar3(y) 0.0
    set ::PostUtils::VectorAUsar3(z) 1.0
}

#Initialize the values related with the three scalars
proc ::PostUtils::Initializescalars {} {
    set ::PostUtils::EscalarAConvertir1 ""
    set ::PostUtils::EscalarAConvertir2 ""
    set ::PostUtils::EscalarAConvertir3 ""
}

#We suggest a name while dealing with a single vector
proc ::PostUtils::ActualizaNombreVector {} {
    if { $::PostUtils::Number_vectors == 1 } {
        if { $::PostUtils::TxtEscalarAConvertir1 == "" } {
            set ::PostUtils::EscalarAConvertir1 ""
            set ::PostUtils::NombreVector ""
            set ::PostUtils::TxtNombreVector ""
            return
        }
        set ::PostUtils::EscalarAConvertir1 $::PostUtils::TxtEscalarAConvertir1
        if { $::PostUtils::EscalarAConvertir1 != ""} {
            set ::PostUtils::NombreVector "$::PostUtils::EscalarAConvertir1 vector"
        } else {
            set ::PostUtils::NombreVector ""
        }
        set ::PostUtils::TxtNombreVector $::PostUtils::NombreVector
    }
}

#Build the window of the macro
proc ::PostUtils::ResultScalarToVector {  { w .gid.wEscalarAVector}} {
    package require BWidget

    set ::PostUtils::Analisis ""
    set ::PostUtils::Step ""
    set ::PostUtils::AllSteps 0
    set ::PostUtils::TxtNombreVector [_ "Vector1"]
    set ::PostUtils::Number_vectors "3"
    ::PostUtils::Initializescalars
    ::PostUtils::Initializevectors
    set ::PostUtils::Scalars_initialized 0
    set ::PostUtils::Conversion_mode [_ "Main_axes"]
    set ::PostUtils::Delete_scalars 0
    InitWindow2 $w -title [_ "Nodal scalars 2 vector"] \
        -geometryvariable PostEscalarAVectorWindowGeom \
        -initcommand ::PostUtils::ResultScalarToVector -ontop
    ttk::frame $w.f           
    #Analysis
    label $w.f.la -text [_ "Analysis"]:
    if { ![info exists ::PostUtils::TxtAnalisis] } {
        set ::PostUtils::TxtAnalisis ""
    }
    ComboBox $w.f.ma -textvariable ::PostUtils::TxtAnalisis -editable 0 -width 30 -borderwidth 1 -modifycmd [list ::PostUtils::UpdateListSteps $w $w.f.fp.mp]
    ::PostUtils::ActualizaListaAnalisis $w.f.ma
    #Step
    label $w.f.lp -text [_ "Step"]:
    ttk::frame $w.f.fp          
    if { ![info exists ::PostUtils::Step] } {
        set ::PostUtils::Step ""
    }
    ComboBox $w.f.fp.mp -textvariable ::PostUtils::Step -editable 0 -width 8 -borderwidth 1 -modifycmd [list ::PostUtils::ActualizaListaEscalares $w all]
    if { ![info exists ::PostUtils::AllSteps] } { 
        set ::PostUtils::AllSteps 0 
    }
    ttk::checkbutton $w.f.fp.cb -text [_ "all steps"] -variable ::PostUtils::AllSteps -command [list ::PostUtils::EnableDisableLista $w.f.fp.mp]
    grid $w.f.fp.mp $w.f.fp.cb -sticky w
    grid rowconfigure $w.f.fp 0 -weight 1
    grid columnconfigure $w.f.fp 0 -weight 1
    grid columnconfigure $w.f.fp 1 -weight 1
    #Vector Name selection
    ::PostUtils::ActualizaNombreVector
    label $w.f.l2 -text [_ "To vector result"]:
    ttk::entry $w.f.e2 -textvariable ::PostUtils::TxtNombreVector -width 30
    #Conversion mode
    label $w.f.lc1 -text [_ "Conversion mode"]:
    ttk::frame $w.f.fc           
    label $w.f.fc.lc2 -text [_ "Number of vectors"]:
    if { ![info exists ::PostUtils::Conversion_mode] } {
        set ::PostUtils::Conversion_mode ""
    }
    if { ![info exists ::PostUtils::Number_vectors] } {
        set ::PostUtils::Number_vectors ""
    }
    ComboBox $w.f.fc.mc1 -textvariable ::PostUtils::Conversion_mode -editable 0 -width 12 -borderwidth 1 -values [list [_ "Main_axes"] [_ "User_defined"]] -modifycmd [list ::PostUtils::Updatestatevectors $w]
    ComboBox $w.f.fc.mc2 -textvariable ::PostUtils::Number_vectors -editable 0 -width 4 -borderwidth 1 -values [list 1 2 3] -modifycmd [list ::PostUtils::Updatedimension $w]
    grid $w.f.fc.mc1 $w.f.fc.lc2 $w.f.fc.mc2 -sticky e
    grid rowconfigure $w.f.fc 0 -weight 1
    grid columnconfigure $w.f.fc 0 -weight 1
    grid columnconfigure $w.f.fc 1 -weight 1
    grid columnconfigure $w.f.fc 2 -weight 1
    
    set ::PostUtils::Analisis [ GiD_Info postprocess get cur_analysis]
    set ::PostUtils::TxtAnalisis $::PostUtils::Analisis
    ::PostUtils::UpdateListSteps $w $w.f.fp.mp
    
    #We define the graphical environement for the three scalars
    foreach index [list 1 2 3] {
        ttk::label $w.f.l1$index -text [_ "Scalar result $index"]:
        if { ![info exists ::PostUtils::TxtEscalarAConvertir$index] } {
            set ::PostUtils::TxtEscalarAConvertir$index ""
        }
        if {$index == 1} {
            ComboBox $w.f.m1$index -textvariable ::PostUtils::TxtEscalarAConvertir$index -editable 0 -width 30 -borderwidth 1 -modifycmd ::PostUtils::ActualizaNombreVector
        } else {
            ComboBox $w.f.m1$index -textvariable ::PostUtils::TxtEscalarAConvertir$index -editable 0 -width 30 -borderwidth 1
        }
        $w.f.m1$index configure -values [::PostUtils::Get_Resultados_Nodales_Escalares]
        ::PostUtils::ActualizaListaEscalares $w.f.m1$index $index
        ttk::label $w.f.l3$index -text [_ "Using Vector $index"]:
        ttk::frame $w.f.fv$index
        ttk::label $w.f.fv$index.lx -text "x:"
        ttk::entry $w.f.fv$index.ex -textvariable "::PostUtils::VectorAUsar$index\(x\)" -width 5 -state disabled
        ttk::label $w.f.fv$index.ly -text "y:"
        ttk::entry $w.f.fv$index.ey -textvariable "::PostUtils::VectorAUsar$index\(y\)" -width 5 -state disabled
        ttk::label $w.f.fv$index.lz -text "z:"
        ttk::entry $w.f.fv$index.ez -textvariable "::PostUtils::VectorAUsar$index\(z\)" -width 5 -state disabled
        grid $w.f.fv$index.lx $w.f.fv$index.ex $w.f.fv$index.ly $w.f.fv$index.ey $w.f.fv$index.lz $w.f.fv$index.ez -sticky e -padx 2 -pady 1
        grid configure $w.f.fv$index.ex $w.f.fv$index.ey $w.f.fv$index.ez -sticky w
        grid rowconfigure $w.f.fv$index 0 -weight 1
        grid columnconfigure $w.f.fv$index {1 3 5} -weight 1
    }
    
    # Scalars deletion option
    label $w.f.ldel -text [_ "Delete original results"]:
    if { ![info exists ::PostUtils::Delete_scalars] } { 
        set ::PostUtils::Delete_scalars 0 
    }
    ttk::checkbutton $w.f.cbdel -variable ::PostUtils::Delete_scalars
    
    set ::PostUtils::Scalars_initialized 1
    ::PostUtils::ActualizaListaEscalares $w all
    
    # analysis
    grid $w.f.la $w.f.ma -sticky e -padx 2 -pady 1
    grid configure $w.f.ma -sticky ew
    # step
    grid $w.f.lp $w.f.fp -sticky e -padx 2 -pady 1
    grid configure $w.f.fp -sticky w
    # vector's name
    grid $w.f.l2 $w.f.e2 -sticky e -padx 2 -pady 1
    grid configure $w.f.e2 -sticky ew
    # conversion
    grid $w.f.lc1 $w.f.fc -sticky e -padx 2 -pady 1
    grid configure $w.f.fc -sticky w
    #We display all the vectors
    foreach index [list 1 2 3] {
        # Scalar result
        grid $w.f.l1$index $w.f.m1$index -sticky e -padx 2 -pady 1
        grid configure $w.f.m1$index -sticky ew
        # Vector
        grid $w.f.l3$index $w.f.fv$index -sticky e -padx 2 -pady 1
        grid configure $w.f.fv$index -sticky w
    }
    # Scalars deletion
    grid $w.f.ldel $w.f.cbdel -sticky e -padx 2 -pady 1
    grid configure $w.f.cbdel -sticky w
    
    # General displaying
    grid rowconfigure $w.f 0 -weight 2
    grid rowconfigure $w.f 1 -weight 2
    grid rowconfigure $w.f 2 -weight 2
    grid rowconfigure $w.f 2 -weight 2
    grid rowconfigure $w.f 2 -weight 2
    grid rowconfigure $w.f 3 -weight 2
    grid rowconfigure $w.f 3 -weight 2
    grid rowconfigure $w.f 3 -weight 2
    
    grid columnconfigure $w.f 0 -weight 1
    grid columnconfigure $w.f 1 -weight 1
    
    ttk::frame $w.buts -style BottomFrame.TFrame    
    ttk::button $w.buts.apply -text [_ "Create"] -command [list ::PostUtils::ConvierteEscalarAVector $w] -style BottomFrame.TButton
    ttk::button $w.buts.close -text [_ "Close"] -command [list destroy $w] -style BottomFrame.TButton            
    
    grid $w.buts.apply $w.buts.close -sticky ew -padx 5 -pady 6
    # Upper part
    grid $w.f -sticky nsew
    # Lower part
    grid $w.buts -sticky sew

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1                      
}
