# tclfile -*- TCL -*-
proc InitStatusLabelVars { } {    
    set ::GiDStatus(ZoomFactor) "1"
    set ::GiDStatus(MeshInfo) "0 0"
    set ::GiDStatus(RenderMode) "normal"
    set ::GiDStatus(LayersOrSetsInfo) "1 0 0 0"
    set ::GiDStatus(CoordsUnits) "0 0 0"
    set ::GiDStatus(PrePost) "Pre"   
    # not used:
    # set ::GiDStatus(NumberOfNodes) "0"
    # set ::GiDStatus(NumberOfElements) "0"
    set ::GiDStatus(Units) ""
    set ::GiDStatus(ProblemTypeName) ""
}

proc GetLayersStatusBarInfo { } {
    lassign {0 0 0 0} num_layers num_off num_withback num_transparent
    foreach layer_name [GiD_Layers list] {
        incr num_layers
        if { ![GiD_Layers get visible $layer_name] } {
           incr num_off
        }
        if { [GiD_Layers get back $layer_name] } {
           incr num_withback
        }
        if { ![GiD_Layers get opaque $layer_name] } {
           incr num_transparent
        }
    }
    return [list $num_layers $num_off $num_withback $num_transparent]
}

#some subcommands doesn't exits, must be implemented...
#proc GetSetsStatusBarInfo { } {
#    foreach set_name [GiD_Sets list] {
#        incr num_sets
#        if { ![GiD_Sets get visible $layer_name] } {
#           incr num_off
#        }
#        if { [GiD_Sets get back $layer_name] } {
#           incr num_withback
#        }
#        if { ![GiD_Sets get opaque $layer_name] } {
#           incr num_transparent
#        }
#    }
#    return [list $num_sets $num_off $num_withback $num_transparent]
#}

proc StatusBarToPre {} {
    global ToolbarsPriv
    if { [GidUtils::IsTkDisabled]} {
        return
    }
    if { [GidUtils::ExistsWindow TOOLBAR_STATUSINFO] } {
        set name_i "Status & Information"
        if { [info exists ::ToolbarsPriv(Hide,$name_i)] && $::ToolbarsPriv(Hide,$name_i) } {
            GidUtils::CloseWindow TOOLBAR_STATUSINFO
            return
        }
    } else {
        return
    }

    global GidPriv
    if { ![info exists GidPriv(PrePostStatusWindowGeom)] } {    
        set GidPriv(PrePostStatusWindowGeom) ""
    }
    set action [lindex $GidPriv(PrePostStatusWindowGeom) 0]
    if { $action != "NONE" } {
        set w .gid.bottominfo
        putStatusButton $w.1 ::GiDStatus(ZoomFactor) [_ "Zoom"] \
            {WriteZoomFactor} {} [_ "Zoom"] {1} {60}
        putStatusButton $w.2 ::GiDStatus(MeshInfo) [list [_ "Nodes"] [_ "Elements"]] \
            {WriteMeshInfo} {ShowHideListStatusWindow} [_ "Number of total elements\n(Click for status list)"] {2} {105}
        putStatusButton $w.3 ::GiDStatus(RenderMode) [_ "Render"] \
            {WriteRenderMode} {RenderRing} [_ "Render status\n(Click to change)"] {3} {85}
        putStatusButton $w.4 ::GiDStatus(LayersOrSetsInfo) [list [_ "Layers"] [_ "Off"] [_ "Back"] [_ "Transparent"]] \
            {WriteLayerInfo} {} [_ "Layers information"] {4} {60}
        putStatusButton $w.5 ::GiDStatus(Coordinates) {} \
            {WriteCoordsUnits} {SetCoord} [_ "Coordinates and units"] {5} {105}
        putStatusButton $w.6 ::GiDStatus(PrePost) {} \
            {WritePrePost} {} [_ "Preprocess / Postprocess"] {6} {25}
    }
    
    if { $::gid_start_mode != "server" } {
        #to avoid automatic source of gid_client.tcl
        #number of layers could be different of number of sets
        gid_client_update_status_bar LayersOrSetsInfo [GetLayersStatusBarInfo]
        gid_client_update_status_bar PrePost Pre
    }
}

proc StatusBarToPost {} {
    global ToolbarsPriv
    if { [GidUtils::IsTkDisabled]} {
        return
    }
    set name_i "Status & Information"
    if { [info exists ::ToolbarsPriv(Hide,$name_i)] && $::ToolbarsPriv(Hide,$name_i) } {    
        if { [GidUtils::ExistsWindow TOOLBAR_STATUSINFO] } {
            GidUtils::CloseWindow TOOLBAR_STATUSINFO
        }
        return
    }
    global GidPriv
    if { ![info exists GidPriv(PrePostStatusWindowGeom)] } {
        set GidPriv(PrePostStatusWindowGeom) ""
    }
    set action [lindex $GidPriv(PrePostStatusWindowGeom) 0]

    if { $action != "NONE" } {
        set w .gid.bottominfo
        putStatusButton $w.1 ::GiDStatus(ZoomFactor) [_ "Zoom"] \
            {WriteZoomFactor} {} [_ "Zoom"] {1} {60}
        putStatusButton $w.2 ::GiDStatus(MeshInfo) [list [_ "Nodes"] [_ "Elements"]] \
            {WriteMeshInfo} {ShowHideListStatusWindow} [_ "Number of total elements\n(Click for status list)"]  {2} {105}
        putStatusButton $w.3 ::GiDStatus(RenderMode) [_ "Render"] \
            {WriteRenderMode} {RenderRing} [_ "Render status\n(Click to change)"] {3} {85}
        putStatusButton $w.4 ::GiDStatus(LayersOrSetsInfo) [list [_ "Sets"] [_ "Off"] [_ "Back"] [_ "Transparent"]] \
            {WriteSetsInfo} {} [_ "Sets information"] {4} {60}
        putStatusButton $w.5 ::GiDStatus(Coordinates) {} \
            {WriteCoordsUnits} {ChangeResultUnits} [_ "Coordinates and units | Results information"] {5} {105}
        putStatusButton $w.6 ::GiDStatus(PrePost) {} \
            {WritePrePost} {} [_ "Preprocess / Postprocess"] {6} {30}
    }
    if { $::gid_start_mode != "server" } {
        #to avoid automatic source of gid_client.tcl
        #number of layers could be different of number of sets, but this seems unnecessary because sets are created when changing to post
        #gid_client_update_status_bar LayersOrSetsInfo [GetSetsStatusBarInfo]
        gid_client_update_status_bar PrePost Post
    }
}


#Write functions txt is translated text, varvalue its comming from GiD
proc WriteZoomFactor { w txt varvalue } {
    if { ![winfo exists $w] } return
    $w configure -text "${txt}: ${varvalue}"
}

#this try to show instead the true integer number (e.g. num_nodes) a short number rounded to K, M, to show only its order of magnitude
proc FormatWithLetterNumber { number } {
    set num_len [ string length $number]
    if { $num_len > 3 } {
        if { $num_len > 6 } {
            if { $num_len > 9 } {
                if { $num_len > 12 } {
                    if { $num_len > 15 } {
                        return "[string range $number 0 end-15]P"
                    } else {
                        return "[string range $number 0 end-12]T"
                    }
                } else {
                    return "[string range $number 0 end-9]G"
                }
            } else {
                return "[string range $number 0 end-6]M"
            }
        } else {
            return "[string range $number 0 end-3]K"
        }
    } else {
        return $number
    }
}

proc WriteMeshInfo { w txt varvalue } {
  if { ![winfo exists $w] } return
  #set output "[lindex $txt 0]: "
  #append output [FormatWithLetterNumber [lindex $varvalue 0]]
  #append output ", [lindex $txt 1]: "
  #append output [FormatWithLetterNumber [lindex $varvalue 1]]
  lassign $txt text_nodes text_elements
  lassign $varvalue num_nodes num_elements
  set output "$text_nodes: $num_nodes, $text_elements $num_elements"
  $w configure -text "$output"
}

proc WriteLayerInfo { w txt varvalue } {
  if { ![winfo exists $w] } return
  set output "[lindex $txt 0]: "
  append output [lindex $varvalue 0]
  if { [lindex $varvalue 1] != 0 || [lindex $varvalue 2]!=0 } {
    append output "("
    if { [lindex $varvalue 1] != 0 } {
      append output "[lindex $txt 1]: "
      append output [lindex $varvalue 1]  
      if { [lindex $varvalue 2] != 0 } {
        append output ", "
      }
    }
    if { [lindex $varvalue 2] != 0 } {
      append output "[lindex $txt 2]: "
      append output [lindex $varvalue 2]
    }
    append output ")"
  }
  $w configure -text "$output"
}

proc WriteSetsInfo { w txt varvalue } {
  if { ![winfo exists $w] } return
  set output "[lindex $txt 0]: "
  append output [lindex $varvalue 0]
  if { [lindex $varvalue 1] != 0 || [lindex $varvalue 3]!=0 } {
    append output "("
    if { [lindex $varvalue 1] != 0 } {
      append output "[lindex $txt 1]: "
      append output [lindex $varvalue 1]  
      if { [lindex $varvalue 3] != 0 } {
        append output ", "
      }
    }
    if { [lindex $varvalue 3] != 0 } {
      append output "[lindex $txt 3]: "
      append output [lindex $varvalue 3]
    }
    append output ")"
  }
  $w configure -text "$output"
}

proc AddSpaceUntilLength { var length } {
    if { [regexp {[0-9]} [string index $var 0]] } {
        set var " $var"
    }
    while { [string length $var] < $length } {
        append var " "
    }
    return $var
}

proc WriteCoordsUnits { w txt varvalue } {
    if { ![winfo exists $w] } return
    # mouse inside draw window
    set output ""
    if { $varvalue == "orthogonal" } {
        set output [_ "Orthogonal view to Z"]
    } elseif { [lindex $varvalue 0] == "result" } {
        # information is "result <value> {<x> <y> <z>}"
        # or in case of contour ranges "result <value> <range_name> {<x> <y> <z>}"
        set real_format [GiD_Set RealFormat]
        set value ""
        if { [llength $varvalue] == 3 } {
            set value [format $real_format [lindex $varvalue 1]]
        } elseif { [llength $varvalue] == 4  } {
            #get contour range name
            set value [lindex $varvalue 2]
        }
        lassign [lindex $varvalue end] x y z
        set output [concat "([format $real_format $x],[format $real_format $y],[format $real_format $z])" [_ "Result"] $value]
        #W [list $x $y $value]
    } elseif { [lindex $varvalue 0] == "unknown" } {
        # information is unknown
        set output [_ "Unknown"]
    } elseif { $varvalue != "" } {
        set output "("
        append output [AddSpaceUntilLength [lindex $varvalue 0] 8]
        append output ","
        append output [AddSpaceUntilLength [lindex $varvalue 1] 8]
        append output ","
        append output [AddSpaceUntilLength [lindex $varvalue 2] 1]
        append output ")"
        if { $::GiDStatus(Units) != "" } {
            append output "  $::GiDStatus(Units)"
        }
    }
    if { $output != ""} {
        $w configure -text "$output"
    }
}

proc WriteRenderMode { w txt varvalue } {
  if { ![winfo exists $w] } return
    $w configure -text "${txt}: [_ $varvalue]"
}

proc WritePrePost { w txt varvalue } {
  if { ![winfo exists $w] } return
    $w configure -text "[_ $varvalue]"
}


proc actualizeStatusLabel { fillfunction w txt n1 n2 op} {
    if { ![winfo exists $w] } return
    #WarnWinText "Fill: $fillfunction Txt: $txt n1: $n1 n2: $n2 op: $op"
    $fillfunction $w $txt [set ::${n1}($n2)]
    #cut text to space available
    set acttext [$w cget -text]    
    while { [winfo reqwidth $w] > [winfo width $w] && [string length $acttext]>4} {        
        $w configure -text "[string range $acttext 0 end-4]..."
        set acttext [$w cget -text]
    }
}

proc readjustwidth { w var txt fillfunction } {
    #WarnWinText "readjustwidth $var"
    
    set acttext [$w cget -text]
    if { [string range $acttext end-2 end] == "..." } {     
      $fillfunction $w $txt [ set $var] 
      if { [winfo width $w] > "3" } { #it jumps first call before windows is well rendered
        set acttext [$w cget -text]        
        while { [winfo reqwidth $w] > [winfo width $w] && [string length $acttext]>4} {            
            $w configure -text "[string range $acttext 0 end-4]..."
            set acttext [$w cget -text]
            #WarnWinText "$acttext [winfo reqwidth $w] > [winfo width $w]"
        }
      }
    } else {        
        while { [winfo reqwidth $w] > [winfo width $w] && [string length $acttext]>4} {        
            $w configure -text "[string range $acttext 0 end-4]..."
            set acttext [$w cget -text]
        }   
    }
    #grid configure $w -sticky nes
    
}

proc putStatusButton {b var txt fillfunction command help column weight} {   
    if { ![info exists $var] } {
        set $var ""
    }
    if { [winfo exists $b] } { 
        destroy $b
    }
    if { $command != "" } { 
        ttk::button $b -text "" -command [list $command] -style TopMenu.IconButton
    } else {
        ttk::label $b -text "" -style ForcedLabel
    }
    bind $b <Destroy> [list trace remove variable $var write [list actualizeStatusLabel $fillfunction $b $txt]]
    $fillfunction $b $txt [set $var]
    trace add variable $var write [list actualizeStatusLabel $fillfunction $b $txt]
    GidHelp $b $help
    grid $b -row 0 -column $column -sticky nsew -pady 0
    set w [winfo parent $b]
    grid columnconfigure $w $column -weight $weight -uniform 1
    readjustwidth $b $var $txt $fillfunction
    bind $b <Configure> [list readjustwidth $b $var $txt $fillfunction]
}

proc RenderRing { } {
    if { ![ info exists ::GiDStatus(RenderMode)]} {
        return
    }
    set lstRender [list normal flat smooth]
    if { [GetCurrentPrePostMode] == "PRE" } {
        #in post it is not implemented Render Customized
        lappend lstRender {*}[GiD_Info customrenders]   
    }
    set idxRender [lsearch $lstRender $::GiDStatus(RenderMode)]
    set nextRender [expr $idxRender+1]
    if { $nextRender >= [llength $lstRender] } {
        set nextRender 0
    }
    set render [lindex $lstRender $nextRender]
    if { $nextRender < 3 } {
        GiD_Process 'Render $render
    } else {
        GiD_Process 'Render Customized ChangeCustom $render
    }
    set ::GiDStatus(RenderMode) $render
}

proc ShowHideListStatusWindow { } {
    if { [ winfo exists .gid.listent]} {
        GidUtils::CloseWindow STATUS
    } else {
        GidUtils::OpenWindow STATUS
    }
}

proc ChangeResultUnitsApply { w } {
  if { ![winfo exists $w] } return   
    if { $::GidPriv(ChangeResultUnits,WhichUnits) == "Original"} {
        GiD_Process Mescape escape escape Results Options UnitSettings \
            $::GidPriv(ChangeResultUnits,Result) \
            $::GidPriv(ChangeResultUnits,WhichSteps) \
            Original
    } else {
        GiD_Process Mescape escape escape Results Options UnitSettings \
            $::GidPriv(ChangeResultUnits,Result) \
            $::GidPriv(ChangeResultUnits,WhichSteps) \
            ChangeUnit \
            $::GidPriv(ChangeResultUnits,NewUnitName) \
            $::GidPriv(ChangeResultUnits,NewUnitMultFactor) \
            $::GidPriv(ChangeResultUnits,NewUnitAddFactor)
    }
}

proc CRU_EnableDisableResSel { frame} {
    if { $::GidPriv(ChangeResultUnits,WhichUnits) == "Original"} {
        foreach w [ winfo children $frame] {
            set cl [ winfo class $w]           
            switch $cl {
                TLabel {
                    $w configure -foreground grey60
                }
                TEntry {
                    $w configure -state disabled
                }
                default {
                }
            }
        }
    } else {
        foreach w [ winfo children $frame] {
            set cl [ winfo class $w]         
            switch $cl {
                TLabel {
                    $w configure -foreground black
                }
                TEntry {
                    $w configure -state normal
                }
                default {
                }
            }
        }
    }
}

proc CRUChangeUnitEntries { } {
    set resUnit [ lindex [ GiD_Info postprocess get result_unit $::GidPriv(ChangeResultUnits,Result)] 0]
    if { [ lindex $resUnit 0] != ""} {
        set ::GidPriv(ChangeResultUnits,NewUnitName) [ lindex $resUnit 0]
        set ::GidPriv(ChangeResultUnits,NewUnitMultFactor) [ lindex $resUnit 1]
        set ::GidPriv(ChangeResultUnits,NewUnitAddFactor) [ lindex $resUnit 2]
    } else {
        set ::GidPriv(ChangeResultUnits,NewUnitName) [_ "New unit name"]
        set ::GidPriv(ChangeResultUnits,NewUnitMultFactor) 1.0
        set ::GidPriv(ChangeResultUnits,NewUnitAddFactor) 0.0
    }
}

proc CRUSetTraces {} {
    trace variable ::GidPriv(ChangeResultUnits,Result) w "CRUChangeUnitEntries;\#"
}

proc CRUDeleteTraces { w_evento w_padre} {
    if { $w_evento == $w_padre} {
        trace vdelete ::GidPriv(ChangeResultUnits,Result) w "CRUChangeUnitEntries;\#"
    }
}

proc ChangeResultUnitsByHand { { w .gid.wPostChangeResultUnits}} {
    if { ![ info exists ::GiDStatus(Units)]} {
        return
    }

    InitWindow2 $w -title [_ "Change result units"] \
        -geometryvariable PostChangeUnitsWindowGeom \
        -initcommand ChangeResultUnits -ontop

    CRUDeleteTraces $w $w

    ttk::frame $w.ftop

    # selection of result
    set values [ lsort -dictionary [ GiD_Info postprocess get cur_results_list Contour_Fill]]
    set labels {}
    foreach j $values {
        lappend labels [TranslateResultName $j]
    }

    ttk::label $w.ftop.lbr -text [_ "Select result"]:
    TTKComboBox $w.ftop.cbr -textvariable ::GidPriv(ChangeResultUnits,Result) \
        -values $values -labels $labels \
        -state readonly -width 16 -command CRUChangeUnitEntries

    set curRes [ GiD_Info postprocess get cur_result]
    if { $curRes != ""} {        
        set ::GidPriv(ChangeResultUnits,Result) [TranslateResultName $curRes]
    } else {
        set ::GidPriv(ChangeResultUnits,Result) [ lindex $labels 0]
    }

    
    ttk::radiobutton $w.ftop.rbOriginal -text [_ "Original units"] -value Original \
            -variable ::GidPriv(ChangeResultUnits,WhichUnits) -command "CRU_EnableDisableResSel $w.ftop.fNewUnit"
    ttk::radiobutton $w.ftop.rbChange -text [_ "Change units to"]: -value ChangeUnit \
            -variable ::GidPriv(ChangeResultUnits,WhichUnits) -command "CRU_EnableDisableResSel $w.ftop.fNewUnit"


    # definition of frame - new unit
    ttk::frame $w.ftop.fNewUnit
    ttk::label $w.ftop.fNewUnit.lun -text [_ "New unit name"]:
    ttk::entry $w.ftop.fNewUnit.eun -textvariable ::GidPriv(ChangeResultUnits,NewUnitName) -width 12
    ttk::label $w.ftop.fNewUnit.lmf -text [_ "Multiplication factor"]:
    ttk::entry $w.ftop.fNewUnit.emf -textvariable ::GidPriv(ChangeResultUnits,NewUnitMultFactor) -width 8
    ttk::label $w.ftop.fNewUnit.laf -text [_ "Addition factor"]:
    ttk::entry $w.ftop.fNewUnit.eaf -textvariable ::GidPriv(ChangeResultUnits,NewUnitAddFactor) -width 8

    grid $w.ftop.fNewUnit.lun $w.ftop.fNewUnit.eun -sticky e
    grid configure $w.ftop.fNewUnit.eun -sticky ew
    grid $w.ftop.fNewUnit.lmf $w.ftop.fNewUnit.emf -sticky e
    grid configure $w.ftop.fNewUnit.emf -sticky w
    grid $w.ftop.fNewUnit.laf $w.ftop.fNewUnit.eaf -sticky e
    grid configure $w.ftop.fNewUnit.eaf -sticky w
    grid columnconfigure $w.ftop.fNewUnit 1 -weight 1
    grid rowconfigure $w.ftop 0 -weight 1
    grid rowconfigure $w.ftop 1 -weight 1
    grid rowconfigure $w.ftop 2 -weight 1
    # end of frame - new unit

    # apply changes for this or all steps
    if { ![info exists ::GidPriv(ChangeResultUnits,WhichSteps)] } { set ::GidPriv(ChangeResultUnits,WhichSteps) "ThisStep" }
    ttk::checkbutton $w.ftop.cbSteps -text [_ "Use unit changes for all steps"] \
        -onvalue "AllSteps" -offvalue "ThisStep" -variable ::GidPriv(ChangeResultUnits,WhichSteps)


    grid $w.ftop.lbr $w.ftop.cbr -sticky w -padx 8 -pady 1
    grid configure $w.ftop.cbr -sticky ew

    grid $w.ftop.rbOriginal -columnspan 2 -sticky ew -padx 8 -pady 1

    grid $w.ftop.rbChange -columnspan 2 -sticky ew -padx 8 -pady 1

    grid $w.ftop.fNewUnit -columnspan 2 -sticky news -padx 16 -pady 0

    grid $w.ftop.cbSteps -columnspan 2 -sticky ew -padx 8 -pady 1

    grid columnconfigure $w.ftop 1 -weight 1
    grid rowconfigure $w.ftop 0 -weight 1
    grid rowconfigure $w.ftop 1 -weight 1
    grid rowconfigure $w.ftop 2 -weight 1
    grid rowconfigure $w.ftop 3 -weight 1
    grid rowconfigure $w.ftop 4 -weight 1

    
    # botones inferiores
    ttk::frame $w.fbut -style BottomFrame.TFrame 

    ttk::button $w.fbut.apply -text [_ "Apply"] -command "ChangeResultUnitsApply $w" -takefocus 0 -style BottomFrame.TButton
    ttk::button $w.fbut.close -text [_ "Close"] -command [list destroy $w] -takefocus 0 -style BottomFrame.TButton  

    grid $w.fbut.apply -sticky ews -padx 4 -pady 10
    grid $w.fbut.close -sticky ews -padx 4 -pady 10 -row 0 -column 1

    #enpaquetamos marcos
    grid $w.ftop -sticky news -padx 4 -pady 4
    grid $w.fbut -sticky wes
    grid anchor $w.fbut center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    focus $w.fbut.apply
    bind $w <Return> "+$w.fbut.apply invoke"    
    bind $w <Destroy> "+ CRUDeleteTraces %W $w"

    #Default values
    CRUChangeUnitEntries
    set ::GidPriv(ChangeResultUnits,WhichSteps) AllSteps
    set ::GidPriv(ChangeResultUnits,WhichUnits) ChangeUnit

    CRUSetTraces
}

proc ChangeResultUnitsWithTable { { w .gid.wPostChangeResultUnits}} {
    if { ![ info exists ::GiDStatus(Units)]} {
        return
    }

    InitWindow2 $w -title [_ "Change result units"] \
        -geometryvariable PostChangeUnitsWindowGeom \
        -initcommand ChangeResultUnits -ontop

    # CRUDeleteTraces $w $w

    ttk::frame $w.ftop

    # selection of result
    set values [ lsort -dictionary [ GiD_Info postprocess get cur_results_list Contour_Fill]]
    set labels {}
    foreach j $values {
        lappend labels [TranslateResultName $j]
    }

    ttk::label $w.ftop.lbr -text [_ "Select result"]:
    TTKComboBox $w.ftop.cbr -textvariable ::GidPriv(ChangeResultUnits,Result) \
        -values $values -labels $labels \
        -state readonly -width 16 -command CRUChangeUnitEntries

    set curRes [ GiD_Info postprocess get cur_result]
    if { $curRes != ""} {        
        set ::GidPriv(ChangeResultUnits,Result) [TranslateResultName $curRes]
    } else {
        set ::GidPriv(ChangeResultUnits,Result) [ lindex $labels 0]
    }

    
    # ttk::radiobutton $w.ftop.rbOriginal -text [_ "Original units"] -value Original \
    #         -variable ::GidPriv(ChangeResultUnits,WhichUnits) -command "CRU_EnableDisableResSel $w.ftop.fNewUnit"
    # ttk::radiobutton $w.ftop.rbChange -text [_ "Change units to"]: -value ChangeUnit \
    #         -variable ::GidPriv(ChangeResultUnits,WhichUnits) -command "CRU_EnableDisableResSel $w.ftop.fNewUnit"
    # 
    # 
    # # definition of frame - new unit
    # ttk::frame $w.ftop.fNewUnit
    # ttk::label $w.ftop.fNewUnit.lun -text [_ "New unit name"]:
    # ttk::entry $w.ftop.fNewUnit.eun -textvariable ::GidPriv(ChangeResultUnits,NewUnitName) -width 12
    # ttk::label $w.ftop.fNewUnit.lmf -text [_ "Multiplication factor"]:
    # ttk::entry $w.ftop.fNewUnit.emf -textvariable ::GidPriv(ChangeResultUnits,NewUnitMultFactor) -width 8
    # ttk::label $w.ftop.fNewUnit.laf -text [_ "Addition factor"]:
    # ttk::entry $w.ftop.fNewUnit.eaf -textvariable ::GidPriv(ChangeResultUnits,NewUnitAddFactor) -width 8
    # 
    # grid $w.ftop.fNewUnit.lun $w.ftop.fNewUnit.eun -sticky e
    # grid configure $w.ftop.fNewUnit.eun -sticky ew
    # grid $w.ftop.fNewUnit.lmf $w.ftop.fNewUnit.emf -sticky e
    # grid configure $w.ftop.fNewUnit.emf -sticky w
    # grid $w.ftop.fNewUnit.laf $w.ftop.fNewUnit.eaf -sticky e
    # grid configure $w.ftop.fNewUnit.eaf -sticky w
    # grid columnconfigure $w.ftop.fNewUnit 1 -weight 1
    # grid rowconfigure $w.ftop 0 -weight 1
    # grid rowconfigure $w.ftop 1 -weight 1
    # grid rowconfigure $w.ftop 2 -weight 1
    # # end of frame - new unit
    # 
    # # apply changes for this or all steps
    # init variable
    # ttk::checkbutton $w.ftop.cbSteps -text [_ "Use unit changes for all steps"] \
    #         -onvalue "AllSteps" -offvalue "ThisStep" -variable ::GidPriv(ChangeResultUnits,WhichSteps)
    # 
    # 
    # grid $w.ftop.lbr $w.ftop.cbr -sticky w -padx 8 -pady 1
    # grid configure $w.ftop.cbr -sticky ew
    # 
    # grid $w.ftop.rbOriginal -columnspan 2 -sticky ew -padx 8 -pady 1
    # 
    # grid $w.ftop.rbChange -columnspan 2 -sticky ew -padx 8 -pady 1
    # 
    # grid $w.ftop.fNewUnit -columnspan 2 -sticky news -padx 16 -pady 0
    # 
    # grid $w.ftop.cbSteps -columnspan 2 -sticky ew -padx 8 -pady 1
    # 
    # grid columnconfigure $w.ftop 1 -weight 1
    # grid rowconfigure $w.ftop 0 -weight 1
    # grid rowconfigure $w.ftop 1 -weight 1
    # grid rowconfigure $w.ftop 2 -weight 1
    # grid rowconfigure $w.ftop 3 -weight 1
    # grid rowconfigure $w.ftop 4 -weight 1

    
    gid_groups_conds::entry_units $w.ftop.u \
        -unit_magnitude_variable ::GidPriv(ChangeResultUnits,Magnitude) \
        -units_variable ::GidPriv(ChangeResultUnits,Variable)
    ttk::label $w.ftop.gpc_umvl -text "Unit magnitude variable:"
    ttk::entry $w.ftop.gpc_umvt -textvariable ::GidPriv(ChangeResultUnits,Magnitude)
    ttk::label $w.ftop.gpc_uvl -text "Units variable:"
    ttk::entry $w.ftop.gpc_uvt -textvariable ::GidPriv(ChangeResultUnits,Variable)

    grid $w.ftop.u -columnspan 2 -sticky ew
    grid $w.ftop.gpc_umvl $w.ftop.gpc_umvt -sticky e
    grid configure $w.ftop.gpc_umvt -sticky ew
    grid $w.ftop.gpc_uvl $w.ftop.gpc_uvt -sticky e
    grid configure $w.ftop.gpc_uvt -sticky ew
    
    # botones inferiores
    ttk::frame $w.fbut -style BottomFrame.TFrame
    ttk::button $w.fbut.apply -text [_ "Apply"] -command "ChangeResultUnitsApply $w" -takefocus 0 -style BottomFrame.TButton
    ttk::button $w.fbut.close -text [_ "Close"] -command [list destroy $w] -takefocus 0 -style BottomFrame.TButton

    grid $w.fbut.apply -sticky ews -padx 4 -pady 10
    grid $w.fbut.close -sticky ews -padx 4 -pady 10 -row 0 -column 1

    #enpaquetamos marcos
    grid $w.ftop -sticky news -padx 4 -pady 4
    grid $w.fbut -sticky wes
    grid anchor $w.fbut center

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    focus $w.fbut.apply
    bind $w <Return> "+$w.fbut.apply invoke"    
    bind $w <Destroy> "+ CRUDeleteTraces %W $w"

    #Default values
    CRUChangeUnitEntries
    set ::GidPriv(ChangeResultUnits,WhichSteps) AllSteps
    set ::GidPriv(ChangeResultUnits,WhichUnits) ChangeUnit

    # CRUSetTraces
}

proc ChangeResultUnits { { w .gid.wPostChangeResultUnits}} {
    if { [ catch { package require customLib }]} {        
        ChangeResultUnitsByHand $w
    } else {
        ChangeResultUnitsWithTable $w
    }
}

proc StatusBarSet { key value } {
    # NumberOfElements NumberOfNodes not used
    # if { [ lsearch [ list NumberOfElements NumberOfNodes] $key ] != -1} {
    #     W "StatusBarSet: not used status info about $key = $value"
    # }
    set keys {Coordinates CoordsUnits LayersOrSetsInfo MeshInfo PrePost ProblemTypeName RenderMode Units ZoomFactor}
    if { [lsearch -sorted -dictionary $keys $key] == -1 } {
        W "StatusBarSet: unexpected key=$key. Must be one of $keys"
    } else {
        set ::GiDStatus($key) $value
    }
}

InitStatusLabelVars
