
proc PickPointInSetCoord { } {
    global SetCoordPriv
    set p1 [::GidUtils::GetCoordinates [_ "Enter point (ESC to leave)"]]
    if { $p1 != "" } {
        lassign $p1 ::SetCoordPriv(xrel) ::SetCoordPriv(yrel) ::SetCoordPriv(zrel)
    }
}

proc ChangeCoordLA { w } {
    global SetCoordPriv

    set w $w.relcen

    if { $::SetCoordPriv(CoordTypeLA) == "-RelativeCenter-" } {
        InitWindow2 $w -title [_ "Relative center"] \
            -geometryvariable PreCoordinatesRelativeCenterWindowGeom \
            -onlygeometry -ontop
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

        ttk::frame $w.frmCoord
        set axes { x y z }
        foreach i $axes {
            if { ![info exists ::SetCoordPriv(${i}rel)] } {
                set ::SetCoordPriv(${i}rel) 0.0
            }
            ttk::label $w.${i}l -text $i:
            ttk::entry $w.${i}e -width 20 -textvariable ::SetCoordPriv(${i}rel)                  
            bind $w.${i}e <FocusIn> {
                if { [%W get] != "" } {
                    %W sel range 0 end
                }
            }
            bind $w.${i}e <FocusOut> { %W sel clear}
        }

        ttk::frame $w.frmButtons -style BottomFrame.TFrame

        ttk::button $w.frmButtons.btnpick -text [_ "Pick"] \
                -command "PickPointInSetCoord" \
                -underline 0 -takefocus 0 -style BottomFrame.TButton
        
        ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
            -command [list destroy $w] -underline 0 -takefocus 0 -style BottomFrame.TButton       

        grid $w.xl $w.xe -in $w.frmCoord -sticky ew
        grid $w.yl $w.ye -in $w.frmCoord -sticky ew
        grid $w.zl $w.ze -in $w.frmCoord -sticky ew
        grid columnconf $w.frmCoord "1" -weight 1

        grid $w.frmCoord -sticky ew -padx 3 -pady 3
        grid $w.frmButtons -sticky ews -columnspan 7
        grid anchor $w.frmButtons center
        grid $w.frmButtons.btnpick $w.frmButtons.btnclose -padx 5 -pady 6
        grid columnconf $w "0" -weight 1
        grid rowconfigure $w "1" -weight 1

        focus $w.xe

        bind $w <Return> "$w.frmButtons.btnpick invoke"        

    } elseif { $::SetCoordPriv(CoordTypeLA) == "-DefineNew-" } {
        GiD_Process escape escape escape escape data LocalAxes DefineLocAxes
        set ::SetCoordPriv(CoordTypeLA) "-Global-"
    }
}

proc ChangeCoordType { w } {
    global SetCoordPriv
    switch $::SetCoordPriv(CoordType) {
        Cartesian {
            $w.xl configure -text x:
            $w.yl configure -text y:
            $w.zl configure -text z:
        }
        Cilindrical {
            $w.xl configure -text r:
            $w.yl configure -text theta:
            $w.zl configure -text z:
        }
        Spherical {
            $w.xl configure -text r:
            $w.yl configure -text theta:
            $w.zl configure -text phi:
        }
    }
}

proc ChangeCreateNewPoint { w } {
    global SetCoordPriv
    switch $::SetCoordPriv(CreateNewPoint) {
        Always {
            set rr {1}
        }
        Ask {
            set rr {0}
        }
        Never {
            set rr {-2}
        }
        No {
            set rr {-1}
        }
        default {
            # problems
            set rr {-3}
        }
    }              
    GiD_Set CreateAlwaysNewPoint $rr
}


proc ApplyCmd { w } {
    global SetCoordPriv

    set axes { x y z }
    set retval ""
    if { $::SetCoordPriv(CoordTypeLA) == "-RelativeLast-" || \
        $::SetCoordPriv(CoordTypeLA) == "-RelativeCenter-" } {
        append retval @
    }
    if { ![regexp {^-[^-]*-$} $::SetCoordPriv(CoordTypeLA)] } {
        append retval '$::SetCoordPriv(CoordTypeLA)'
    }

    foreach i $axes {
        set number [string trim [$w.${i}e get]]
        if { ![string is double $number] } {
            WarnWin [_ "value '%s' is not a number" $number]
            focus $w.${i}e
            return
        }
        append retval $number
        if { $i == "x" } {
            if { $::SetCoordPriv(CoordType) == "Cartesian" } {
                append retval ,
            } else {
                append retval <
            }
        } elseif { $i == "y" } {
            if { $::SetCoordPriv(CoordType) == "Spherical"} {
                append retval <
            } else {
                append retval ,
            }
        }
    }

    if { $::SetCoordPriv(CoordTypeLA) == "-RelativeCenter-" } {
        set retvalLA ""
        foreach i $axes {
            set number $SetCoordPriv(${i}rel)
            if { ![string is double $number] } {
                WarnWin [_ "value '%s' in local center is not a number" $number]
                catch { focus $w.relcen.${i}e }
                return
            }
            append retvalLA $number
            if { $i != "z" } { append retvalLA , }
        }
        GiD_Process options EnterRelative $retvalLA FNoJoin $retval
    } else {
        GiD_Process FNoJoin $retval
    }
}


proc UpdateSetCoord { } {
    if { ![winfo exists .gid.wSetCoord] } {
        return
    }

    global SetCoordPriv
    set labels [list [_ "Global"] [_ "Relative center"]... [_ "Relative last"] [_ "Define new"]...]
    set values {-Global- -RelativeCenter- -RelativeLast- -DefineNew-}
    foreach i [GiD_Info localaxes] {
        lappend labels $i
        lappend values $i
    }
    if { [lsearch $values $::SetCoordPriv(CoordTypeLA)] == "-1" } {
        set ::SetCoordPriv(CoordTypeLA) -Global-
    }
    TTKComboBox_configure $::SetCoordPriv(LAcombobx) -labels $labels -values $values
}

proc SetCoordEnable { what { w .gid.wSetCoord } } {
    global SetCoordPriv
    if { $what == "yes" } {
        set ::SetCoordPriv(state) normal
    } else {
        set ::SetCoordPriv(state) disabled
    }
    if { [winfo exists $w] } {
        $w.frmButtons.btnApply configure -state $::SetCoordPriv(state)
    }
}

proc SetCoord { { w .gid.wSetCoord } } {
    global SetCoordPriv

    InitWindow2 $w -title [_ "Coordinates window"] \
        -geometryvariable PreCoordinatesWindowGeom \
        -initcommand SetCoord -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::frame $w.frmButtons -style BottomFrame.TFrame

    if { ![info exists ::SetCoordPriv(state)] } {
        set ::SetCoordPriv(state) disabled
    }
    ttk::button $w.frmButtons.btnApply -text [_ "Apply"] \
            -command "ApplyCmd $w" \
            -underline 0 -style BottomFrame.TButton -state $::SetCoordPriv(state) -takefocus 0

    ttk::button $w.frmButtons.btnclose -text [_ "Close"] \
            -command "GiD_Process escape ;  destroy $w" \
            -underline 0 -style BottomFrame.TButton -takefocus 0
   
    ttk::label $w.csl -text [_ "C. System"]:
    
    set ::SetCoordPriv(CoordTypeLA) ""        
    set ::SetCoordPriv(LAcombobx) [TTKComboBox $w.csla -textvariable ::SetCoordPriv(CoordTypeLA) \
        -labels [list [_ "Global"] [_ "Relative center"]... [_ "Relative last"] [_ "Define new"]...] \
        -values {-Global- -RelativeCenter- -RelativeLast- -DefineNew-} \
        -width 12 -state readonly ]
      
    ttk::label $w.lae -text [_ "Local axes"]:    
    set ::SetCoordPriv(CoordType) [_ "Cartesian"]
       
     TTKComboBox $w.cs -textvariable ::SetCoordPriv(CoordType) \
        -labels [list [_ "Cartesian"] [_ "Cilindrical"] [_ "Spherical"]] \
        -values {Cartesian Cilindrical Spherical} \
        -state readonly
                    
    ttk::frame $w.coord

    set axes { x y z }
    foreach i $axes {
        label $w.${i}l -text $i:
        ttk::entry $w.${i}e -width 20 -textvariable \
                ::SetCoordPriv(${i}axe)
        $w.${i}e delete 0 end
        $w.${i}e insert end 0.00000
        bind $w.${i}e <FocusIn> {
            if { [%W get] != "" } {
                %W sel range 0 end
            }
        }
        bind $w.${i}e <FocusOut> { %W sel clear}
        bind $w.${i}e <Return> [list $w.frmButtons.btnApply invoke]
    }

    ttk::frame $w.newpnt
    ttk::label $w.newpntl1 -text [_ "Create new point"]:
    
    TTKComboBox $w.newpntl2 -textvariable ::SetCoordPriv(CreateNewPoint) \
        -labels [list [_ "Always"] [_ "Ask"] [_ "Never"]] \
        -values {Always Ask Never}
    
    set input [GiD_Set CreateAlwaysNewPoint]
    if { $input == 1 } {
        set ::SetCoordPriv(CreateNewPoint) "Always"
    } elseif { $input == 0 } {
        set ::SetCoordPriv(CreateNewPoint) "Ask"
    } elseif { $input == -2 } {
        set ::SetCoordPriv(CreateNewPoint) "Never"
    } else {
        set ::SetCoordPriv(CreateNewPoint) "No"
    }
        
    grid $w.newpntl1 $w.newpntl2 -in $w.newpnt -padx 2 -pady 2
    grid configure $w.newpntl2 -ipadx 2 -ipady 2

    grid $w.csl $w.cs -sticky e -padx 2 -pady 2
    grid  $w.lae $w.csla -sticky e -padx 2 -pady 2

    grid $w.xl $w.xe -in $w.coord -sticky ew -padx 2 -pady 2
    grid configure $w.xl -sticky w
    grid $w.yl $w.ye -in $w.coord -sticky ew -padx 2 -pady 2
    grid configure $w.yl -sticky w
    grid $w.zl $w.ze -in $w.coord -sticky ew -padx 2 -pady 2
    grid configure $w.zl -sticky w
    grid columnconf $w.coord "1" -weight 1

    grid $w.coord -sticky ew -columnspan 7
    grid $w.newpnt -sticky e -columnspan 7    

    grid $w.frmButtons -sticky ews -columnspan 7
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnApply $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconf $w "0" -weight 1
    grid rowconfigure $w "4" -weight 1

    wm minsize $w 175 200

    focus $w.xe

    bind $w <Alt-c> [list $w.frmButtons.btnclose invoke]
    bind $w <Escape> [list $w.frmButtons.btnclose invoke]
    bind $w <Destroy> [list +DestroySetCoord %W $w] ;# + to add to previous script
    bind $w <${::acceleratorKey}-a> SelectJoinOrNoJoin

    UpdateSetCoord
    ChangeCoordType $w
    trace add variable ::SetCoordPriv(CoordType) write "ChangeCoordType $w ;#"
    trace add variable ::SetCoordPriv(CoordTypeLA) write "ChangeCoordLA $w ;#"
    trace add variable ::SetCoordPriv(CreateNewPoint) write "ChangeCreateNewPoint $w ;#"
}

proc DestroySetCoord { W w } {
    if { $W != $w } return
    global SetCoordPriv
    trace remove variable ::SetCoordPriv(CoordType) write "ChangeCoordType $w ;#"
    trace remove variable ::SetCoordPriv(CoordTypeLA) write "ChangeCoordLA $w ;#"
    trace remove variable ::SetCoordPriv(CreateNewPoint) write "ChangeCreateNewPoint $w ;#"
}
