#show must be 1 or 0
proc SeeFileInBatch { w show } {
    if { $show } {
        if { [FileReadBatchWin $w] == "error" } { return }
        $w.b1 configure -text [_ "Hide file"]
        $w.b1 configure -command [list SeeFileInBatch $w 0]
        grid $w.f6
    } else {
        $w.b1 configure -text [_ "See file"]
        $w.b1 configure -command [list SeeFileInBatch $w 1]
        grid remove $w.f6
    }
}

proc FileReadBatchWin { w } {

    global GIDDEFAULT ReadbPriv

    set text $w.fr.t
    set file [string trim $ReadbPriv(filename) " "]

    if { $file == "" } {
        WarnWin [_ "One correct batch file name is needed"]
        return error
    }
    if { $ReadbPriv(CurrentFileName) == $file } {
        if { [file mtime $file] != $ReadbPriv(CurrentFileNameMTime) } {
            set res [MessageBoxOptionsButtons [_ "information window"] \
                         [_ "File is more recent than last time read. Reread it?"] \
                         {0 1 2} [list [_ "Yes"] [_ "No#C#I don't want to do that"] [_ "Cancel"]] question ""]
            if { $res == 1 } {
                return
            } elseif { $res == 2 } { return error }
        } else { return }
    }
    if { ![file exists $file] } {
        WarnWin [_ "File '%s' does not exists" $file]
        $w.file select from 0
        $w.file select to end
        return error
    }

    GidUtils::WaitState $w   

    $text configure -state normal
    $text delete 1.0 end
    $text insert end "  "

    set fileid [open $file r]
    fconfigure $fileid -encoding utf-8
    set inum 0
    set iline 1
    while { ![eof $fileid] } {
        set input [gets $fileid]
        if { [string range $input 0 4] == "*****" } {
            if { [string range $input 5 8] == "STOP" || \
                    [string range $input 5 9] == "PAUSE" } {
                $text delete "end -3 c" end-1c
                $text insert end "S " tagbegin
                continue
            } elseif { [string range $input 5 7] == "TCL" } {
                #is a tcl command
            } else {
                continue
            }
        }
        if { $ReadbPriv(AreLineNumbers) } {
            $text insert end [format "%-5i " $iline]
        }
        foreach i [regexp -inline -all {\s*\S+\s*} $input] {
            if { ![regexp {\s*escape\s*} $i] } {
                $text insert end "$i"
            } else {
                regexp {([^.]*)} [$text index end] trash line
                incr line -1
                label $text.$inum -image [gid_themes::GetImage ArrowLeft.png small_icons] -text $line                
                set list [concat escapetagRB [bindtags $text.$inum]]
                bindtags $text.$inum $list
                
                regexp {(\s*)escape(\s*)} $i {} before after
                $text insert end $before
                $text window create end -padx 5 -window $text.$inum
                $text insert end $after
                incr inum
            }
        }
        $text insert end "\n  "
        incr iline
    }
    close $fileid
    regexp {([^.]*)} [$text index end] trash line
    $text delete [expr $line-2].0 end

    $text configure -state disabled

    set ReadbPriv(CurrentFileName) $file
    set ReadbPriv(CurrentFileNameMTime) [file mtime $file]
    set ReadbPriv(CurrentLine) 1
    regexp {^[^.]*} [$text index end] ReadbPriv(LastLine)

    RBatchSetCurrentLine $w
    RBatchProgressBar $w
   
    GidUtils::EndWaitState $w
}

proc FileWriteBatchWin { w } {
    global ReadbPriv

    if { $ReadbPriv(filename) == "" } {
        WarnWin [_ "There is no batch file read"]
        return
    }

    if { [FileReadBatchWin $w] == "error" } { return }

    set types [list [list [_ "Batch file"] ".bch"] [list [_ "All files"] ".*"]]
    set file [MessageBoxGetFilename file write [_ "write batch file"] \
            "" $types .bch 0]
    if { $file == "" } { return }
    FileWriteBatch $w $file
}

proc FileWriteBatch { w file  } {

    global GIDDEFAULT ReadbPriv

    set text $w.fr.t

    if { $file == "" } {
        WarnWin  [_ "One correct batch file name is needed"]
        return error
    }

    if { [catch {
        set fileid [open $file w]
        fconfigure $fileid -encoding utf-8
    }] } {
        WarnWin [_ "File cannot be written"]
        return error
    }

    GidUtils::WaitState $w    

    if { $ReadbPriv(AreLineNumbers) } { set ichar 8 } else { set ichar 2 }
    for {set i 1} {$i < $ReadbPriv(LastLine)} {incr i} {
        foreach {key value index} [$text dump -text -window \
                $i.$ichar "$i.0 lineend"] {
            switch $key {
                text {
                    puts -nonewline $fileid $value
                }
                window {
                    puts -nonewline $fileid "escape "
                }
            }
        }
        puts $fileid ""
        set cc [$text get [expr $i+1].0]
        if { $cc == "S" || $cc == "B" } {
            puts $fileid "*****STOP"
        }
    }

    close $fileid
    GidUtils::EndWaitState $w   
}

proc RBatchGo { w } {
    global ReadbPriv

    if { [FileReadBatchWin $w] == "error" } { return }

    if { $ReadbPriv(delay) && ![regexp {^[  ]*[+]?[0-9]*[1-9]+[0-9]*[  ]*$} \
            $ReadbPriv(delayMseconds)] } {
        WarnWin [_ "Time delay must be a positive integer"] 
        $w.f4.e1 select from 0
        $w.f4.e1 select to end
        return
    }
    if { $ReadbPriv(stopdelay) && ![regexp {^[  ]*[+]?[0-9]*[1-9]+[0-9]*[  ]*$} \
            $ReadbPriv(stopdelayMseconds)] } {
        WarnWin [_ "Time stop delay must be a positive integer"]
        $w.f5.e1 select from 0
        $w.f5.e1 select to end
        return
    }

    switch $ReadbPriv(stop) {
        end {
            set lineend $ReadbPriv(LastLine)
        }
        infloop {
            set lineend $ReadbPriv(LastLine)
        }
        Lnumber {
            if { ![regexp {^[  ]*[+]?[0-9]*[1-9]+[0-9]*[  ]*$} \
                    $ReadbPriv(stopLineNumber)] } {
                WarnWin [_ "Line number must be a positive integer"]
                $w.f3.e1 select from 0
                $w.f3.e1 select to end
                return
            }
            set lineend $ReadbPriv(stopLineNumber)
        }
        after {
            if { ![regexp {^[  ]*[+]?[0-9]*[1-9]+[0-9]*[  ]*$} \
                    $ReadbPriv(stopAfter)] } {
                WarnWin [_ "Line increment must be a positive integer"]
                $w.f3.e2 select from 0
                $w.f3.e2 select to end
                return
            }
            set lineend [expr $ReadbPriv(stopAfter)+$ReadbPriv(CurrentLine)]
        }
        Istop {
            set lineend $ReadbPriv(LastLine)
        }
    }

    set text $w.fr.t

    grab $w.stop   
    GidUtils::WaitState $w
    GiD_Project set disable_windows 1
    GiD_Project set disable_graphinput 1
    if { $ReadbPriv(showinfo) == 0 } { GiD_Project set disable_warnline 1 }
    set oldfocus [focus -lastfor $w]
    if { $oldfocus == "" } { set oldfocus $w.file }
    focus $w.stop
    update idletasks

    set ReadbPriv(MustBeStopped) 0
    if { $ReadbPriv(AreLineNumbers) } { set ichar 8 } else { set ichar 2 }
    while 1 {
        for {set i $ReadbPriv(CurrentLine)} {$i < $lineend} {incr i} {
        
            foreach {key value index} [$text dump -text -window \
                    $i.$ichar "$i.0 lineend"] {
                switch $key {
                    text {
                        set value [string trimright $value \n]
                        if { [string range $value 0 7] == "*****TCL" } {
                            eval [string range $value 8 end]
                        } elseif { [string range $value 0 3] == "-np-" } {
                            eval [string range $value 4 end]
                        } else {
                            # WarnWinText "GiD_Process-{*}$value-"
                            if { [ llength $value] > 0} {
                                GiD_Process {*}$value
                            }
                        }
                    }
                    window {
                        GiD_Process escape
                    }
                }
            }
            set ReadbPriv(CurrentLine) [expr $i+1]
            if { $ReadbPriv(stopdelay) } {
                set cc [$text get $ReadbPriv(CurrentLine).0]
                if { $cc == "S" || $cc == "B" } {
                    after $ReadbPriv(stopdelayMseconds)
                }
            }
            if { $ReadbPriv(delay) } {
                after $ReadbPriv(delayMseconds)
            }
        
            RBatchSetCurrentLine $w
            RBatchProgressBar $w
            update
            if { $ReadbPriv(MustBeStopped) } { break }
                
            if { $ReadbPriv(stop) == "Istop" } {
                set cc [$text get $ReadbPriv(CurrentLine).0]
                if { $cc == "S" || $cc == "B" } { break }
            }
        }
        if { $ReadbPriv(CurrentLine) == $ReadbPriv(LastLine) } {
            set ReadbPriv(CurrentLine) 1
            RBatchSetCurrentLine $w
            RBatchProgressBar $w
        }
        if { $ReadbPriv(stop) != "infloop" || $ReadbPriv(MustBeStopped) } { break }
    }

    after idle " \
            GiD_Project set disable_windows 0 ; \
            GiD_Project set disable_graphinput 0 ; \
            GidUtils::EndWaitState $w ; \
            grab release $w.stop ; \           
            focus $oldfocus"
    if { $ReadbPriv(showinfo) == 0 } { after idle GiD_Project set disable_warnline 0 }
}

proc RBatchStop { w } {
    global ReadbPriv
    set ReadbPriv(MustBeStopped) 1
}

proc RBatchRewind { w } {
    global ReadbPriv
    FileReadBatchWin $w
    set ReadbPriv(CurrentLine) 1
    RBatchSetCurrentLine $w
    RBatchProgressBar $w
}

proc RBatchFileWindow { w } {
    global ReadbPriv
    set types [list [list [_ "Batch file"] ".bch"] [list [_ "All files"] ".*"]]
    set ReadbPriv(filename) [MessageBoxGetFilename file read [_ "read batch file"] \
            $ReadbPriv(filename) $types .bch 0]
    if { $ReadbPriv(filename) == "" } { return }
    FileReadBatchWin $w
}

proc RBatchProgressBar { w } {
    global ReadbPriv
    if { ![info exists ReadbPriv(CurrentLine)] || ![info exists ReadbPriv(LastLine)] } {
        return
    }

    set rwidth [expr ($ReadbPriv(CurrentLine)-1.0)/($ReadbPriv(LastLine)-1.0)]

    place $w.f25.f -x 0 -y 0 -relheight 1 \
            -relwidth $rwidth
}

proc RBatchSetNumbers { w } {
    global ReadbPriv

    set text $w.fr.t
    $text configure -state normal
    if { !$ReadbPriv(AreLineNumbers) } {
        $w.f6.num configure -text [_ "No numbers"]
        set ReadbPriv(AreLineNumbers) 1
        if { [info exists ReadbPriv(LastLine)] } {
            for {set i 1} {$i < $ReadbPriv(LastLine)} {incr i} {
                $text insert $i.2 [format "%-5i " $i]
            }
        }
    } else {
        $w.f6.num configure -text [_ "Numbers"]
        set ReadbPriv(AreLineNumbers) 0
        if { [info exists ReadbPriv(LastLine)] } {
            for {set i 1} {$i < $ReadbPriv(LastLine)} {incr i} {
                $text delete $i.2 $i.8
            }
        }
    }
    $text configure -state disabled
}

proc RBatchSetCurrentLine { w } {
    global ReadbPriv
    set text $w.fr.t
    $text configure -state normal

    set trange [$text tag ranges tagcurrent]
    if { $trange != "" } {
        $text delete [lindex $trange 0]
        $text insert [lindex $trange 0] " "
    }
    for {set i 0} {$i < 2} {incr i} {
        if { [$text get $ReadbPriv(CurrentLine).$i] == " " } {
            $text delete $ReadbPriv(CurrentLine).$i
            $text insert $ReadbPriv(CurrentLine).$i C tagcurrent
            break
        }
    }
    $text see $ReadbPriv(CurrentLine).0
    $text configure -state disabled
}

proc RBatchMarkbreakSet { w x y { sel yes } { win "" } } {

    if { $sel == "yes" } {
        set text $w.fr.t
        if { $win == "" } {
            set y [expr $y-[winfo rooty $text]]
            regexp {([^.]*)} [$text index @$x,$y] trash line
        } else {
            set line [$win cget -text]
        }
        $text configure -state normal
        
        if { [$text get $line.0] == " " } {
            $text delete $line.0
            $text insert $line.0 B tagbreak
        } elseif { [$text get $line.0] == "C" } {
            $text delete $line.0 $line.2
            $text insert $line.0 B tagbreak
            $text insert $line.1 C tagcurrent
        } else {
            $text configure -state disabled
            return
        }
        $text configure -state disabled
    }
    grab release $w.fr
    bind $w.fr.t <1> ""
    bind $w.fr.t <B1-Motion> ""
    bind $w.fr.t <Key> ""
    bind escapetagRB <1> ""
    $w.fr.t configure -cursor ""
    $w.fr configure -cursor ""
    $w.fr.vscr configure -cursor ""
    $w.fr.hscr configure -cursor ""
    focus $w.file
}

proc RBatchMarkbreak { w } {

    grab $w.fr
    bind $w.fr.t <1> "RBatchMarkbreakSet $w %X %Y ; break"
    bind $w.fr.t <B1-Motion> "break"
    bind $w.fr.t <Key> "RBatchMarkbreakSet $w 0 0 no ; break"
    bind escapetagRB <1>  "RBatchMarkbreakSet $w 0 0 yes %W ; break"
    $w.fr.t configure -cursor hand2
    $w.fr configure -cursor pirate
    $w.fr.vscr configure -cursor arrow
    $w.fr.hscr configure -cursor arrow
    focus $w.fr.t

    catch { destroy $w.warn }
    ttk::label $w.warn -text [_ "Pick a line in the code to set a mark there"]
    place $w.warn -in $w -relx 0 -rely 1 -anchor sw
    after 1000 [list catch [list destroy $w.warn]]
}

proc RBatchClearbreakSet { w x y { sel yes }  { win "" } } {

    if { $sel == "yes" } {
        set text $w.fr.t
        if { $win == "" } {
            set y [expr $y-[winfo rooty $text]]
            regexp {([^.]*)} [$text index @$x,$y] trash line
        } else {
            set line [$win cget -text]
        }
        
        $text configure -state normal

        set trange [$text tag nextrange tagbreak $line.0 "$line.0 lineend"]
        if { $trange != "" } {
            $text delete [lindex $trange 0]
            $text insert [lindex $trange 0] " "
        }
        $text configure -state disabled
        if { $trange == "" } { return }
    }
    grab release $w.fr
    bind $w.fr.t <1> ""
    bind $w.fr.t <B1-Motion> ""
    bind $w.fr.t <Key> ""
    $w.fr.t configure -cursor ""
    $w.fr configure -cursor ""
    $w.fr.vscr configure -cursor ""
    $w.fr.hscr configure -cursor ""
    focus $w.file
}

proc RBatchClearbreak { w } {
    set text $w.fr.t
    set res [MessageBoxOptionsButtons [_ "information window"] [_ "Clear one break or all?"] \
                 {one all cancel} [list [_ "One"] [_ "All"] [_ "Cancel"]] question ""]
    if { $res == "all" } {
        $text configure -state normal
        foreach "i1 i2" [$text tag ranges tagbreak] {
            $text delete $i1
            $text insert $i1 " "
        }
        $text configure -state disabled
    } elseif { $res == "one" } {
        grab $w.fr
        bind $w.fr.t <1> "RBatchClearbreakSet $w %X %Y ; break"
        bind $w.fr.t <B1-Motion> "break"
        bind $w.fr.t <Key> "RBatchClearbreakSet $w 0 0 no ; break"
        bind escapetagRB <1>  "RBatchClearbreakSet $w 0 0 yes %W ; break"
        $w.fr.t configure -cursor hand2
        $w.fr configure -cursor pirate
        $w.fr.vscr configure -cursor arrow
        $w.fr.hscr configure -cursor arrow
        focus $w.fr.t
        catch { destroy $w.warn }
        ttk::label $w.warn -text [_ "Pick a line in the code to delete its mark"]
        place $w.warn -in $w -relx 0 -rely 1 -anchor sw
        after 1000 [list catch [list destroy $w.warn]]
    }
}

proc ReadBatch { { w .gid.wReadBatch } } {
    global GIDDEFAULT ReadbPriv
    InitWindow2 $w -title [_ "Read batch"] \
        -geometryvariable PrePostReadBatchWindowGeom -initcommand ReadBatch
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    ttk::frame $w.f1
    ttk::label $w.l -text [_ "File"]:
    if { ![info exists ReadbPriv(filename)] } { set ReadbPriv(filename) ""}
    ttk::entry $w.file -textvariable ReadbPriv(filename)

    bind $w.file <Return> "FileReadBatchWin $w"

    ttk::button $w.fileb -image [gid_themes::GetImage "folder.png" small_icons] -command [list RBatchFileWindow $w]

    grid columnconf $w.f1 1 -weight 1
    grid  $w.l $w.file $w.fileb -in $w.f1 -sticky ew

    ttk::frame $w.f2
    ttk::button $w.play -image [gid_themes::GetImage play.png medium_icons] -command [list RBatchGo $w]
    ttk::button $w.stop -image [gid_themes::GetImage stop.png medium_icons] -command [list RBatchStop $w]
    ttk::button $w.rewind -image [gid_themes::GetImage rewind.png medium_icons] -command [list RBatchRewind $w]
       
    grid  $w.play $w.stop $w.rewind -in $w.f2 -pady 2 -padx 2

    ttk::frame $w.f25 -relief sunken -borderwidth 2 -height 20
    tk::frame $w.f25.f -background blue

    place $w.f25.f -x 0 -y 0 -relheight 1 -relwidth 0

    ttk::frame $w.f3 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f3.l1 -text [_ "Stop at"]:
    ttk::radiobutton $w.f3.r1 -text [_ "End"] -variable ReadbPriv(stop) -value end
    ttk::radiobutton $w.f3.r2 -text [_ "Infinite loop"] -variable ReadbPriv(stop) -value infloop
    ttk::radiobutton $w.f3.r3 -text [_ "Line number"]: -variable ReadbPriv(stop) -value Lnumber
    ttk::entry $w.f3.e1 -width 4 -textvariable ReadbPriv(stopLineNumber)
    ttk::radiobutton $w.f3.r4 -text [_ "After"]: -variable ReadbPriv(stop) -value after
    ttk::entry $w.f3.e2 -width 4 -textvariable ReadbPriv(stopAfter)
    ttk::label $w.f3.l2 -text [_ "lines"]
    ttk::radiobutton $w.f3.r5 -text [_ "Internal stop"] -variable ReadbPriv(stop) -value Istop
    grid $w.f3.l1
    grid $w.f3.r1 - $w.f3.r2 -sticky w
    grid $w.f3.r3 -sticky w
    grid $w.f3.e1 -sticky ew -column 1 -row 2
    grid $w.f3.r5 -sticky w -column 2 -row 2
    grid $w.f3.r4 -sticky w
    grid $w.f3.e2 -sticky ew -column 1 -row 3
    grid $w.f3.l2 -sticky w -column 2 -row 3
    grid columnconf $w.f3 1 -weight 1

    ttk::frame $w.f4
    if { ![info exists ReadbPriv(delay)] } { set ReadbPriv(delay) 0 }
    ttk::checkbutton $w.f4.c1 -text [_ "Per command delay"]: -variable ReadbPriv(delay)
    ttk::entry $w.f4.e1 -width 5 -textvariable ReadbPriv(delayMseconds)
    ttk::label $w.f4.l1 -text [_ "miliseconds"]
    grid $w.f4.c1 $w.f4.e1 $w.f4.l1 -sticky ew
    grid columnconf $w.f4 1 -weight 1

    ttk::frame $w.f5
    if { ![info exists ReadbPriv(stopdelay)] } { set ReadbPriv(stopdelay) 0 }
    ttk::checkbutton $w.f5.c1 -text [_ "Per stop delay"]: -variable ReadbPriv(stopdelay)
    ttk::entry $w.f5.e1 -width 5 -textvariable ReadbPriv(stopdelayMseconds)
    ttk::label $w.f5.l1 -text [_ "miliseconds"]
    grid $w.f5.c1 $w.f5.e1 $w.f5.l1 -sticky ew
    grid columnconf $w.f5 1 -weight 1

    if { ![info exists ReadbPriv(showinfo)] } { set ReadbPriv(showinfo) 0 }
    ttk::checkbutton $w.f55 -text [_ "Show info"] -variable ReadbPriv(showinfo)

    ttk::button $w.b1 -text [_ "See file"] -command [list SeeFileInBatch $w 1] -width 8

    ttk::frame $w.f6 -style ridge.TFrame -borderwidth 2
    ttk::frame $w.fr -style sunken.TFrame -borderwidth 2

    text $w.fr.t -xscroll "$w.fr.hscr set" -yscroll "$w.fr.vscr set" \
            -wrap none -width 0 -height 8 -font FixedFont -relief flat
    ttk::scrollbar $w.fr.vscr -orient vertical -comm "$w.fr.t yview"
    ttk::scrollbar $w.fr.hscr -orient horizontal -comm "$w.fr.t xview"

    ttk::button $w.f6.num -text [_ "Numbers"] -command [list RBatchSetNumbers $w] -width 10
    ttk::button $w.f6.stop -text [_ "Mark break"] -command [list RBatchMarkbreak $w]
    ttk::button $w.f6.clear -text [_ "Clear"] -command [list RBatchClearbreak $w]

    grid $w.fr.t -sticky nsew -row 0 -column 0 -in $w.fr
    grid $w.fr.vscr -sticky ns -row 0 -column 1 -rowspan 2 -in $w.fr
    grid $w.fr.hscr -row 1 -column 0 -sticky ew -in $w.fr
    grid columnconf $w.fr 0 -weight 1
    grid rowconf $w.fr 0 -weight 1
    grid $w.fr - - -sticky nsew -in $w.f6
    grid $w.f6.num $w.f6.stop $w.f6.clear
    grid columnconf $w.f6 0 -weight 1
    grid columnconf $w.f6 1 -weight 1
    grid columnconf $w.f6 2 -weight 1
    grid rowconf $w.f6 0 -weight 1

    ttk::frame $w.f7 -style BottomFrame.TFrame
    ttk::button $w.f7.write -text [_ "Write.."] -command [list FileWriteBatchWin $w] -style BottomFrame.TButton
    ttk::button $w.f7.close -text [_ "Close"] -command [list destroy $w] -underline 0 -style BottomFrame.TButton

    grid $w.f7.write $w.f7.close -padx 5 -pady 5

    grid $w.f1 -sticky ew
    grid $w.f2 -sticky ew
    grid $w.f25 -sticky ew -padx 10 -pady 5
    grid $w.f3 -sticky ew -padx 3
    grid $w.f4 -sticky ew
    grid $w.f5 -sticky ew
    grid $w.f55 -sticky w
    grid $w.b1 -sticky w

    grid $w.f6 -sticky nsew
    grid $w.f7 -sticky sew
    grid anchor $w.f7 center

    grid remove $w.f6
    grid columnconf $w 0 -weight 1
    grid rowconf $w 8 -weight 1

    set ReadbPriv(stop) Istop
    set ReadbPriv(CurrentFileName) ""
    set ReadbPriv(AreLineNumbers) 0
    $w.fr.t tag configure tagbegin -foreground red
    $w.fr.t tag configure tagcurrent -foreground red
    $w.fr.t tag configure tagbreak -foreground red
    wm geometry $w ""
    focus $w.file
}
