
#---------------------------------------------------------------
# Sphere Size Options
#---------------------------------------------------------------

proc FillPostSphereOptionsWInfo { { primera_vez 0}} {
    global PSpherePriv GidPriv

    if { ![ info exists PSpherePriv(AvoidUpdate)]} {
	set PSpherePriv(AvoidUpdate) 0
    }
    if { ![ info exists PSpherePriv(DoingAccept)]} {
	set PSpherePriv(DoingAccept) 0
    }

    if { $PSpherePriv(AvoidUpdate) } { return }

    if { $PSpherePriv(DoingAccept) } { return }

    if { ![ info exists GidPriv(PostSphereOptionsWindow)] || ![winfo exists $GidPriv(PostSphereOptionsWindow)]} {
	set w ""
	return
    } else {
	set w $GidPriv(PostSphereOptionsWindow)
    }

    set info [ GiD_Info postprocess get info_sphere_size]
   
    if { $w != "" } {
	UpDownEntryConf $w.f1.fe -state normal
    }


    set PSpherePriv(Value) [ lindex $info 0]
    set opciones [ lindex $info 1]
    # quick options are limited by OpenGL, for instance minSize == 1.0f mostly
    set PSpherePriv(MinQuick) [ lindex $opciones 0]
    set PSpherePriv(MaxQuick) [ lindex $opciones 1]
    set PSpherePriv(StepQuick) [ lindex $opciones 2]
    set PSpherePriv(DefaultValue) [ lindex $opciones 3]

    # internal texture size options like the nice options, as they are not fixed by opengl
    set opciones [ lindex $info 2]
    set PSpherePriv(MinInternalTexture) [ lindex $opciones 0]
    set PSpherePriv(MaxInternalTexture) [ lindex $opciones 1]
    set PSpherePriv(StepInternalTexture) [ lindex $opciones 2]
    set PSpherePriv(MinNice) [ lindex $opciones 0]
    set PSpherePriv(MaxNice) [ lindex $opciones 1]
    set PSpherePriv(StepNice) [ lindex $opciones 2]

    set opciones [ lindex $info 3]
    set PSpherePriv(Detail) [ lindex $opciones 0]
    set PSpherePriv(DefaultDetail) [ lindex $opciones 1]

    set PSpherePriv(NiceValue) [ lindex $info 4]
    set opciones [ lindex $info 5]
    set PSpherePriv(MinDetail) [ lindex $opciones 0]
    set PSpherePriv(MaxDetail) [ lindex $opciones 1]
    set PSpherePriv(StepDetail) [ lindex $opciones 2]
    set PSpherePriv(DefaultNiceValue) [ lindex $opciones 3]

    set PSpherePriv(MinTexture) $PSpherePriv(MinNice)
    set PSpherePriv(MaxTexture) $PSpherePriv(MaxNice)
    set PSpherePriv(StepTexture) $PSpherePriv(StepNice)

    if { $primera_vez} {
	set PSpherePriv(OldValue) $PSpherePriv(Value)
	set PSpherePriv(OldDetail) $PSpherePriv(Detail)
    }
    set PSpherePriv(AccValue) $PSpherePriv(Value)
    set PSpherePriv(AccDetail) $PSpherePriv(Detail)
    if { $primera_vez} {
	set PSpherePriv(OldNiceValue) $PSpherePriv(NiceValue)
    }
    set PSpherePriv(AccNiceValue) $PSpherePriv(NiceValue)

    set PSpherePriv(WhichSize) Fixed
    ### set WhichValues [ lindex $info 6]
    ### 
    ### set PSpherePriv(WhichSize) [ lindex $WhichValues 0]
    ### if { $PSpherePriv(WhichSize) == "Variable"} {
    ### 	set PSpherePriv(SelectedResult) [ list [ lindex $WhichValues 1] [ lindex $WhichValues 2] [ lindex $WhichValues 3] [ lindex $WhichValues 4]]
    ### 	set PSpherePriv(ResultFactor) [ lindex $WhichValues 5]
    ### } else {
    ### 	set PSpherePriv(SelectedResult) ""
    ### 	set PSpherePriv(ResultFactor) 1.0
    ### }
    ### 
    ### if { $primera_vez} {
    ### 	set PSpherePriv(OldWhichSize) $PSpherePriv(WhichSize)
    ### 	set PSpherePriv(OldSelectedResult) $PSpherePriv(SelectedResult)
    ### 	set PSpherePriv(OldResultFactor) $PSpherePriv(ResultFactor)
    ### }
    set PSpherePriv(AccWhichSize) $PSpherePriv(WhichSize)
    ### set PSpherePriv(AccSelectedResult) $PSpherePriv(SelectedResult)
    ### set PSpherePriv(AccResultFactor) $PSpherePriv(ResultFactor)



    ### set TextureValues [ lindex $info 7]
    ### 
    ### set PSpherePriv(NumTextures) [ lindex $TextureValues 0]
    ### set PSpherePriv(MinTextures) [ lindex $TextureValues 1]
    ### set PSpherePriv(MaxTextures) [ lindex $TextureValues 2]
    ### set PSpherePriv(TexturesLst) [ lindex $TextureValues 3]
    ### 
    ### if { $primera_vez} {
    ### 	set PSpherePriv(OldNumTextures) $PSpherePriv(NumTextures)
    ### 	set PSpherePriv(OldTexturesLst) $PSpherePriv(TexturesLst)
    ### }
    ### set PSpherePriv(AccNumTextures) $PSpherePriv(NumTextures)
    ### set PSpherePriv(AccTexturesLst) $PSpherePriv(TexturesLst)

    #$w.f1.s configure -from $PSpherePriv(Min$PSpherePriv(Detail)) -to $PSpherePriv(Max$PSpherePriv(Detail)) -resolution $PSpherePriv(Step$PSpherePriv(Detail))
    #$w.f1.s set $PSpherePriv(Value)

    #$w.f2.s configure -from $PSpherePriv(MinDetail) -to $PSpherePriv(MaxDetail) -resolution $PSpherePriv(StepDetail)
    #$w.f2.s set $PSpherePriv(NiceValue)
    # para (des)habilitar la barrita del 'nice level'

#     set PerspPriv(DoIt) 0
#     if { $perspmode == "PERSPECTIVE" } {
#           set PerspPriv(DoIt) 1
#     }
#     if { $perspmode == "NORMAL" } {
#           set PerspPriv(DoIt) 0
#           $w.f1.s configure -state disabled
#           $w.f1.e configure -state disabled
#     }
#
    if { "$w" != "" } {
	EnableDisableSphereDetailOptions
	### EnableDisableSphereSizeOptions
    }

}

proc PostSphereAccept { } {
    global PSpherePriv

    set PSpherePriv(DoingAccept) 1

    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1
	
    switch $PSpherePriv(Detail) {
	"Quick" {
	    if { $PSpherePriv(Detail) != $PSpherePriv(AccDetail)} {
		GiD_Process Mescape Results Options SphereDetail $PSpherePriv(Detail)
	    }
	}
	"InternalTexture" {
	    if { $PSpherePriv(Detail) != $PSpherePriv(AccDetail)} {
		GiD_Process Mescape Results Options SphereDetail $PSpherePriv(Detail)
	    }
	}
	"Nice" {
	    ##if { $PSpherePriv(NiceValue) != $PSpherePriv(AccNiceValue) }
	    if { ( $PSpherePriv(Detail) != $PSpherePriv(AccDetail)) || ( $PSpherePriv(NiceValue) != $PSpherePriv(AccNiceValue))} {
		GiD_Process Mescape Results Options SphereDetail $PSpherePriv(Detail) $PSpherePriv(NiceValue)
		set PSpherePriv(AccNiceValue) $PSpherePriv(NiceValue)
	    }
	}
    }
	### "Texture" {
	###     # if { ( $PSpherePriv(Detail) != $PSpherePriv(AccDetail)) || ( $PSpherePriv(TextureValue) != $PSpherePriv(AccTextureValue))} {
	###     #           GiD_Process Mescape Results Options SphereDetail $PSpherePriv(Detail) 1 $PSpherePriv(TextureValue)
	###     # }
	###     # set PSpherePriv(AccTextureValue) $PSpherePriv(TextureValue)
	###     if { ( $PSpherePriv(AccNumTextures) != $PSpherePriv(NumTextures)) || ( $PSpherePriv(AccTexturesLst) != $PSpherePriv(TexturesLst))} {
	### 	if { $PSpherePriv(NumTextures) && ( [ llength $PSpherePriv(TexturesLst)] == $PSpherePriv(NumTextures))} {
	### 	    eval [ concat GiD_Process Mescape Results Options SphereDetail $PSpherePriv(Detail) $PSpherePriv(NumTextures) $PSpherePriv(TexturesLst)]
	### 	    set PSpherePriv(AccNumTextures) $PSpherePriv(NumTextures)
	### 	    set PSpherePriv(AccTexturesLst) $PSpherePriv(TexturesLst)
	### 	}
	###     }
	### }

    set PSpherePriv(AccDetail) $PSpherePriv(Detail)

    if { ( $PSpherePriv(WhichSize) != $PSpherePriv(AccWhichSize)) || ( $PSpherePriv(Value) != $PSpherePriv(AccValue))} {
	GiD_Process Mescape Results Options SphereSize fixed $PSpherePriv(Value)
	set PSpherePriv(AccValue) $PSpherePriv(Value)
    }

    ### switch $PSpherePriv(WhichSize) {
    ### 	"Fixed" {
    ### 	    if { ( $PSpherePriv(WhichSize) != $PSpherePriv(AccWhichSize)) || ( $PSpherePriv(Value) != $PSpherePriv(AccValue))} {
    ### 		GiD_Process Mescape Results Options SphereSize fixed $PSpherePriv(Value)
    ### 		set PSpherePriv(AccValue) $PSpherePriv(Value)
    ### 	    }
    ### 	}
    ### 	"Variable" {
    ### 	    if {  ( $PSpherePriv(WhichSize) != $PSpherePriv(AccWhichSize)) || \
    ### 		    ( $PSpherePriv(SelectedResult) != $PSpherePriv(AccSelectedResult)) || \
    ### 		    ( $PSpherePriv(ResultFactor) != $PSpherePriv(AccResultFactor)) } {
    ### 		if { [ llength $PSpherePriv(SelectedResult)] == 4} {
    ### 		    GiD_Process Mescape Results Options SphereSize Variable \
    ### 		            [ lindex $PSpherePriv(SelectedResult) 0] [ lindex $PSpherePriv(SelectedResult) 1] \
    ### 		            [ lindex $PSpherePriv(SelectedResult) 2] [ lindex $PSpherePriv(SelectedResult) 3] $PSpherePriv(ResultFactor)
    ### 		    set PSpherePriv(AccSelectedResult) $PSpherePriv(SelectedResult)
    ### 		    set PSpherePriv(AccResultFactor) $PSpherePriv(ResultFactor)
    ### 		}
    ### 	    }
    ### 	}
    ### }

    set PSpherePriv(AccWhichSize) $PSpherePriv(WhichSize)

    GiD_Set AutomaticRedraw $oldAutomaticRedraw

    set PSpherePriv(DoingAccept) 0

    set old $PSpherePriv(DynamicUpdate)
    set PSpherePriv(DynamicUpdate) 0
    # FillPostSphereOptionsWInfo
    set PSpherePriv(DynamicUpdate) $old
    GiD_Redraw
}

proc PostSphereOriginal { } {
    global PSpherePriv
    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1
    GiD_Process Mescape Results Options SphereDetail $PSpherePriv(DefaultDetail) $PSpherePriv(DefaultNiceValue)
    GiD_Process Mescape Results Options SphereSize fixed $PSpherePriv(DefaultValue)
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw  
    set old $PSpherePriv(DynamicUpdate)
    set PSpherePriv(DynamicUpdate) 0
    FillPostSphereOptionsWInfo
    set PSpherePriv(DynamicUpdate) $old
}

proc ChangeSphereSizeScale { name1 name2 op} {
    global PSpherePriv GidPriv

    if { $PSpherePriv(Value) == $PSpherePriv(OldValue)} { return}
    if { "$PSpherePriv(Value)" == ""} { return}

    set w $GidPriv(PostSphereOptionsWindow)

    set newval $PSpherePriv(Value)
    if { ![ IsWord real  $newval $w "no"]} {
	return
    }

    # Check for valid value when using Quick detail, otherwise it will generate an OpenGL error
    if { $PSpherePriv(Detail) == "Quick"} {
	set pp [ expr ($newval - $PSpherePriv(Min$PSpherePriv(Detail))) / $PSpherePriv(Step$PSpherePriv(Detail))]
	set ppi [ expr int($pp + 0.5)]
	if { [ expr abs( $ppi - $pp)] > 1e-5 } {
	    WarnWin [_ "Value not %1\$s %2\$s correct ( must be between %3\$s and %4\$s in steps of %5\$s)" \
		     $pp $ppi $PSpherePriv(Min$PSpherePriv(Detail)) \
		     $PSpherePriv(Max$PSpherePriv(Detail)) $PSpherePriv(Step$PSpherePriv(Detail))]
	    $w.f1.fe.e sel range 0 end
	    
	    set PSpherePriv(Value) $PSpherePriv(OldValue)
	    return error
	}
    }

    set PSpherePriv(OldValue) $PSpherePriv(Value)

    if { $PSpherePriv(DynamicUpdate) } { PostSphereAccept}
}

proc EnableDisableSphereDetailOptions { } {
    global GidPriv PSpherePriv

    set w $GidPriv(PostSphereOptionsWindow)

    switch $PSpherePriv(Detail) {
	"Quick" {
	    ### $w.f1.rd2 configure -state disabled
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state disabled
	    ### set PSpherePriv(OldWhichSize) $PSpherePriv(WhichSize)
	    ### set PSpherePriv(WhichSize) Fixed
	    ### # texture options
	    ### UpDownEntryConf $w.f3.e -state disabled
	    ### $w.f3.seltex configure -state disabled
	}
	"Nice" {
	    ### $w.f1.rd2 configure -state normal
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state normal
	    ### # texture options
	    ### UpDownEntryConf $w.f3.e -state disabled
	    ### $w.f3.seltex configure -state disabled
	}
	"InternalTexture" {
	    ### $w.f1.rd2 configure -state normal
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state disabled
	    ### # texture options
	    ### UpDownEntryConf $w.f3.e -state disabled
	    ### $w.f3.seltex configure -state disabled
	}
    }
	### "Texture" {
	###     $w.f1.rd2 configure -state disabled
	###     # nice detail level
	###     UpDownEntryConf $w.f2.s -state disabled
	###     ### set PSpherePriv(OldWhichSize) $PSpherePriv(WhichSize)
	###     ### set PSpherePriv(WhichSize) Fixed
	###     # texture options
	###     UpDownEntryConf $w.f3.e -state normal
	###     $w.f3.seltex configure -state normal
	### }
}

proc ChangeSphereDetail { n1 n2 op} {
    global GidPriv PSpherePriv

    if { $PSpherePriv(Detail) == $PSpherePriv(OldDetail)} { return}

    set PSpherePriv(OldDetail) $PSpherePriv(Detail)

    if { $PSpherePriv(Value) < $PSpherePriv(Min$PSpherePriv(Detail))} {
	set PSpherePriv(Value) $PSpherePriv(Min$PSpherePriv(Detail))
    }

    if { $PSpherePriv(Value) > $PSpherePriv(Max$PSpherePriv(Detail))} {
	set PSpherePriv(Value) $PSpherePriv(Max$PSpherePriv(Detail))
    }

    set w $GidPriv(PostSphereOptionsWindow)

    #$w.f1.s configure -from $PSpherePriv(Min$PSpherePriv(Detail)) -to $PSpherePriv(Max$PSpherePriv(Detail)) -resolution $PSpherePriv(Step$PSpherePriv(Detail))
    #$w.f1.s set $PSpherePriv(Value)

    ### if { "$PSpherePriv(Detail)" == "Texture"} {
    ### 	if { $PSpherePriv(NumTextures) < $PSpherePriv(MinTextures)} {
    ### 	    set PSpherePriv(NumTextures) $PSpherePriv(MinTextures)
    ### 	}
    ### 	if { $PSpherePriv(NumTextures) > $PSpherePriv(MaxTextures)} {
    ### 	    set PSpherePriv(NumTextures) $PSpherePriv(MaxTextures)
    ### 	}
    ### }
    ### 
    ### if { ( "$PSpherePriv(Detail)" != "Texture") || \
    ### 	    ( $PSpherePriv(NumTextures) && ( [ llength $PSpherePriv(TexturesLst)] == $PSpherePriv(NumTextures)))} {
    ### 	if { $PSpherePriv(DynamicUpdate)} { PostSphereAccept}
    ### }

    if { ( "$PSpherePriv(Detail)" != "Texture")} {
	if { $PSpherePriv(DynamicUpdate)} { PostSphereAccept}
    }

    EnableDisableSphereDetailOptions
}

### proc EnableDisableSphereSizeOptions { } {
###     global GidPriv PSpherePriv
### 
###     set w $GidPriv(PostSphereOptionsWindow)
### 
###     if { $PSpherePriv(WhichSize) == "Fixed"} {
### 	UpDownEntryConf $w.f1.fe -state normal
### 	$w.f1.selres configure -state disabled	
###     } else { # is "Variable"
### 	UpDownEntryConf $w.f1.fe -state disabled
### 	$w.f1.selres configure -state normal
###     }
### }

### proc ChangeSphereWhichSize { n1 n2 op} {
###     global GidPriv PSpherePriv
### 
###     if { $PSpherePriv(WhichSize) == $PSpherePriv(OldWhichSize)} { return}
### 
###     if { $PSpherePriv(SelectedResult) == ""} {
### 	set PSpherePriv(SelectedResult) $PSpherePriv(OldSelectedResult)
### 	set PSpherePriv(OldSelectedResult) ""
### 	ChangeSelectedResult PSpherePriv OldSelectedResult w
###     }
### 
###     set PSpherePriv(OldWhichSize) $PSpherePriv(WhichSize)
### 
###     set w $GidPriv(PostSphereOptionsWindow)
### 
###     if { $PSpherePriv(DynamicUpdate) && ( $PSpherePriv(SelectedResult) != "")} {
### 	PostSphereAccept
###     }
### 
###     EnableDisableSphereSizeOptions
### }

proc ChangeSphereDetailScale { name1 name2 op} {
    global PSpherePriv GidPriv

    if { $PSpherePriv(NiceValue) == $PSpherePriv(OldNiceValue)} { return}
    if { "$PSpherePriv(NiceValue)" == ""} { return}

    set w $GidPriv(PostSphereOptionsWindow)

    set newval $PSpherePriv(NiceValue)

    if { ( $newval < $PSpherePriv(MinDetail)) || ( $newval > $PSpherePriv(MaxDetail)) } {
	    WarnWin [_ "Value out of limits ( must be between %1\$s and %2\$s in steps of %3\$s)" \
		     $PSpherePriv(MinDetail) $PSpherePriv(MaxDetail) $PSpherePriv(StepDetail)]
        $w.f1.fe.e sel range 0 end
        set PSpherePriv(Value) $PSpherePriv(OldValue)
        return error
    }

    set PSpherePriv(OldNiceValue) $PSpherePriv(NiceValue)
    if { $PSpherePriv(DynamicUpdate) } { PostSphereAccept}
}

proc PostSphereOptionsTextureFile { w varname} {
    upvar $varname destination
    set destination [MessageBoxGetFilename file read [_ "Sphere texture file"]]
}

proc PostSphereOptionsIncrementaTamanno { step} {
    global PSpherePriv

    set tmp [ expr $PSpherePriv(Value) + $step * $PSpherePriv(Step$PSpherePriv(Detail))]
    set pp [ expr ($tmp - $PSpherePriv(Min$PSpherePriv(Detail))) / $PSpherePriv(Step$PSpherePriv(Detail))]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
	set tmp [ expr double( $ppi) * $PSpherePriv(Step$PSpherePriv(Detail)) + $PSpherePriv(Min$PSpherePriv(Detail))]
    }

    if { $tmp > $PSpherePriv(Max$PSpherePriv(Detail))} {
	set tmp $PSpherePriv(Max$PSpherePriv(Detail))
	bell
    }

    set PSpherePriv(Value) [ format %g $tmp]
}

proc PostSphereOptionsDecrementaTamanno { step} {
    global PSpherePriv

    set tmp [ expr $PSpherePriv(Value) - $step * $PSpherePriv(Step$PSpherePriv(Detail))]
    set pp [ expr ($tmp - $PSpherePriv(Min$PSpherePriv(Detail))) / $PSpherePriv(Step$PSpherePriv(Detail))]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
	set tmp [ expr double( $ppi) * $PSpherePriv(Step$PSpherePriv(Detail)) + $PSpherePriv(Min$PSpherePriv(Detail))]
    }

    if { $tmp < $PSpherePriv(Min$PSpherePriv(Detail))} {
	set tmp $PSpherePriv(Min$PSpherePriv(Detail))
	bell
    }

    set PSpherePriv(Value) [ format %g $tmp]
}

proc PostSphereOptionsIncrementaBonito { } {
    global PSpherePriv

    set tmp [ expr $PSpherePriv(NiceValue) + $PSpherePriv(StepDetail)]
    if { $tmp > $PSpherePriv(MaxDetail)} {
	set tmp $PSpherePriv(MaxDetail)
	bell
    }

    set PSpherePriv(NiceValue) [ format %g $tmp]
}

proc PostSphereOptionsDecrementaBonito { } {
    global PSpherePriv

    set tmp [ expr $PSpherePriv(NiceValue) - $PSpherePriv(StepDetail)]
    if { $tmp < $PSpherePriv(MinDetail)} {
	set tmp $PSpherePriv(MinDetail)
	bell
    }

    set PSpherePriv(NiceValue) [ format %g $tmp]
}

### proc PostSphereOptionsIncrementaNumTex { } {
###     global PSpherePriv
### 
###     set tmp [ expr $PSpherePriv(NumTextures) + 1]
###     if { $tmp > $PSpherePriv(MaxTextures)} {
### 	set tmp $PSpherePriv(MaxTextures)
### 	bell
###     }
### 
###     set PSpherePriv(NumTextures) [ format %g $tmp]
### }
### 
### proc PostSphereOptionsDecrementaNumTex { } {
###     global PSpherePriv
### 
###     set tmp [ expr $PSpherePriv(NumTextures) - 1]
###     if { $tmp < $PSpherePriv(MinTextures)} {
### 	set tmp $PSpherePriv(MinTextures)
### 	bell
###     }
### 
###     set PSpherePriv(NumTextures) [ format %g $tmp]
### }


proc PostFillSelecResultComponent { } {
    global GidPriv PostSelecResultComponent
# WarnWinText "PostFillSelecResultComponent"
    set w $GidPriv(PostSelecResultComponentWindow)

    set values [lsort -dictionary [GiD_Info postprocess get all_analysis]]
    set labels {}
    foreach j $values {	
	lappend labels [TranslateResultName $j]
    }
    $w.r.cba configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cba -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 0]
    #no traducir cur2 porque actualmente se usa el mensaje como comando interno!!
    if { $cur == "" } {
	regsub -all {_} [lindex $values 0] { } cur2
    } else {
	regsub -all {_} $cur { } cur2
    }
    set PostSelecResultComponent(Analysis) $cur2
}

proc PostFillChangedAnalysis { } {
    global GidPriv PostSelecResultComponent
    if { $PostSelecResultComponent(Analysis) == "" } {
	return
    }
# WarnWinText "PostFillChangedAnalysis A='$PostSelecResultComponent(Analysis)'"
    set w $GidPriv(PostSelecResultComponentWindow)

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    set values [GiD_Info postprocess get all_steps $analisis]
    set labels $values
    $w.r.cbs configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cbs -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 1]
    if { "$cur" == "" } {
	set cur [ lindex $values 0]
    }
    set PostSelecResultComponent(Step) $cur
}

proc PostFillChangedStep { } {
    global GidPriv PostSelecResultComponent
# WarnWinText "PostFillChangedStep A='$PostSelecResultComponent(Analysis)' S='$PostSelecResultComponent(Step)'"
    if { $PostSelecResultComponent(Analysis) == "" || $PostSelecResultComponent(Step) == "" } {
	return
    }
    set w $GidPriv(PostSelecResultComponentWindow)

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    set values [GiD_Info postprocess get results_list CONTOUR_FILL $analisis $PostSelecResultComponent(Step)]
    set labels {}
    foreach j $values {	
	lappend labels [TranslateResultName $j]
    }
    $w.r.cbr configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cbr -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 2]
    if { $cur == "" } {
	regsub -all {_} [ lindex $values 0] { } cur2
    } else {
	regsub -all {_} $cur { } cur2
    }
    set PostSelecResultComponent(Result) $cur2
}

proc PostFillChangedResult { } {
    global GidPriv PostSelecResultComponent
# WarnWinText "PostFillChangedResult A='$PostSelecResultComponent(Analysis)' R='$PostSelecResultComponent(Result)' S='$PostSelecResultComponent(Step)'"
    if { $PostSelecResultComponent(Analysis) == "" || $PostSelecResultComponent(Result) == "" ||
	 $PostSelecResultComponent(Step) == "" } {
	return
    }

    set w $GidPriv(PostSelecResultComponentWindow)

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    regsub -all { } $PostSelecResultComponent(Result) {_} resultado
    set values [ GiD_Info postprocess get components_list SPHERE_RADIUS $resultado $analisis $PostSelecResultComponent(Step)]
    set labels {}
    foreach j $values {
	lappend labels [TranslateResultComponentName $j]
    }
    $w.r.cbc configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cbc -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 3]
    if { $cur == "" } {
	regsub -all {_} [ lindex $values 0] { } cur2
    } else {
	regsub -all {_} $cur { } cur2
    }
    set PostSelecResultComponent(Component) $cur2
}

proc DestroyPostSelecResultComponent { W w } {
    if { $W != $w } return
    trace remove variable ::PostSelecResultComponent(Analysis) write "PostFillChangedAnalysis ;#"
    trace remove variable ::PostSelecResultComponent(Step) write "PostFillChangedStep ;#"
    trace remove variable ::PostSelecResultComponent(Result) write "PostFillChangedResult ;#"
}

proc PostSelecResultComponentAccept { w varname} {
    global PostSelecResultComponent
    upvar $varname destination

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    regsub -all { } $PostSelecResultComponent(Result) {_} resultado
    regsub -all { } $PostSelecResultComponent(Component) {_} componente
    set destination [ list $analisis \
	    $PostSelecResultComponent(Step) $resultado $componente]

    destroy $w
}

proc PostSelecResultComponent { w varname} {
    global GidPriv PostSelecResultComponent
    upvar $varname destination

    if { [ winfo exists $w] } {
	raise $w
	return
    }
    toplevel $w
    if { $::tcl_platform(platform) == "windows" } {        
	wm attributes $w -toolwindow 1
    }
    set parent_w [winfo toplevel [winfo parent $w]]
    wm transient $w $parent_w
    wm title $w [_ "Select result"]

    set GidPriv(PostSelecResultComponentWindow) $w

    ttk::frame $w.r
    ttk::label $w.r.la -text [_ "Analysis"]
    TTKComboBox $w.r.cba -textvariable ::PostSelecResultComponent(Analysis) -state readonly
    ttk::label $w.r.ls -text [_ "Step"]
    TTKComboBox $w.r.cbs -textvariable ::PostSelecResultComponent(Step) -state readonly
    ttk::label $w.r.lr -text [_ "Result"]
    TTKComboBox $w.r.cbr -textvariable ::PostSelecResultComponent(Result) -state readonly
    ttk::label $w.r.lc -text [_ "Component"]
    TTKComboBox $w.r.cbc -textvariable ::PostSelecResultComponent(Component) -state readonly

    grid $w.r.la $w.r.cba -sticky ew
    grid $w.r.ls $w.r.cbs -sticky ew
    grid $w.r.lr $w.r.cbr -sticky ew
    grid $w.r.lc $w.r.cbc -sticky ew


    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame
   
    ttk::button $w.but.accept -text [_ "Apply"] -command [list PostSelecResultComponentAccept $w $varname] \
	-style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] \
	-style BottomFrame.TButton

    grid $w.but.accept -padx 4 -pady 10 -sticky ew
    grid $w.but.close -row 0 -column 1 -padx 4 -pady 10 -sticky ew

    grid $w.r -sticky news
    grid $w.but -sticky wes
    grid columnconfigure $w.r {0 1} -weight 1
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    grid anchor $w.but center

#     trace add variable ::PostSelecResultComponent(Analysis) write "PostFillChangedAnalysis ;#"
#     trace add variable ::PostSelecResultComponent(Step) write "PostFillChangedStep ;#"
#     trace add variable ::PostSelecResultComponent(Result) write "PostFillChangedResult ;#"

    set PostSelecResultComponent(Current) $destination


    wm withdraw $w
    update idletasks

    set w2 [ expr [ winfo reqwidth $w] / 2]
    set h2 [ expr [ winfo reqheight $w] / 2]
    set x [ expr [ winfo pointerx $parent_w] - $w2]
    set y [ expr [ winfo pointery $parent_w] - $h2]

    # miramos si sale la X
    set off_scr_x [ expr ( $x + $w2 + $w2) - [ winfo screenwidth $w]]
    if { $off_scr_x >= 0} {
	set x [ expr $x - $off_scr_x - 10]
    }
    if { $x < 0} { set x 0}
    # miramos si sale la Y
    set off_scr_y [ expr ( $y + $h2 + $h2) - [ winfo screenheight $w]]
    if { $off_scr_y >= 0} {
	set y [ expr $y - $off_scr_y - 20]
    }
    if { $y < 0} { set y 0}
    wm geometry $w +$x+$y
    wm deiconify $w
   
    bind $w <Return> "$w.but.accept invoke"
    bind $w <Destroy> [list +DestroyPostSelecResultComponent %W $w]

    trace add variable ::PostSelecResultComponent(Analysis) write "PostFillChangedAnalysis ;#"
    trace add variable ::PostSelecResultComponent(Step) write "PostFillChangedStep ;#"
    trace add variable ::PostSelecResultComponent(Result) write "PostFillChangedResult ;#"

    PostFillSelecResultComponent
    #PostFillChangedAnalysis
    focus $w
}

### proc ChangeSelectedResult { name1 name2 op } {
###     global PSpherePriv
### 
###     if { $PSpherePriv(SelectedResult) == $PSpherePriv(OldSelectedResult)} { return}
### 
###     if { $PSpherePriv(SelectedResult) != ""} {
### 	set PSpherePriv(OldSelectedResult) $PSpherePriv(SelectedResult)
###     }
### 
###     set wtext $PSpherePriv(PostSphereOptionsResultTextW)
### 
###     if { $wtext != ""} {
### 	$wtext configure -state normal
### 	$wtext delete 0.0 end
### 	if { [llength $PSpherePriv(SelectedResult)] == 4} {
### 	    regsub -all {_} [ lindex $PSpherePriv(SelectedResult) 0] { } analisis
### 	    set step [ lindex $PSpherePriv(SelectedResult) 1]
### 	    regsub -all {_} [ lindex $PSpherePriv(SelectedResult) 2] { } resultado
### 	    regsub -all {_} [ lindex $PSpherePriv(SelectedResult) 3] { } componente
### 	    $wtext insert end "$analisis\n$step\n$resultado\n$componente"
### 	}
### 	$wtext configure -state disabled
###     }
### }

### proc PostSphereOptionsSelectResult { w { wtext ""}} {
###     global PSpherePriv
### 
###     set PSpherePriv(PostSphereOptionsResultTextW) $wtext
### #    set PSpherePriv(SelectedResult) ""
###     PostSelecResultComponent $w.sr PSpherePriv(SelectedResult)
###     tkwait window $w.sr
### 
###     # sugiere un factor
###     if { [llength $PSpherePriv(SelectedResult)] == 4} {
### 	set analisis [ lindex $PSpherePriv(SelectedResult) 0]
### 	set step [ lindex $PSpherePriv(SelectedResult) 1]
### 	set resultado [ lindex $PSpherePriv(SelectedResult) 2]
### 	set componente [ lindex $PSpherePriv(SelectedResult) 3]
### 	set PSpherePriv(ResultFactor) [ GiD_Info postprocess get info_sphere_size_factor $analisis $step $resultado $componente]
### 
### 	if { $PSpherePriv(DynamicUpdate) } { PostSphereAccept}
###     }
### }


proc PostSelecTexturesClose { w } {
    global PostSelecTextures

    destroy $w
}

proc PostSelecTexturesAccept { w varname} {
    global PostSelecTextures
    upvar $varname destination

    #regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    #regsub -all { } $PostSelecResultComponent(Result) {_} resultado
    #regsub -all { } $PostSelecResultComponent(Component) {_} componente
    #set $PostSelecResultComponent(ReturnVariable) [ list $analisis \
    #             $PostSelecResultComponent(Step) $resultado $componente]

    set vacios 0
    for { set it 0 } { $it < $PostSelecTextures(Num)} { incr it} {
	if { "$PostSelecTextures($it)" == ""} {
	    incr vacios
	}
    }
    if { $vacios != 0} {
	if { $vacios == 1} {
	    set msg [_ "Sorry, but there is one entry with no image file."]
	} else {
	    set msg [_ "Sorry, but there is %s entries with no image files." $vacios]
	}
	WarnWin $msg $w
	return
    }

    set destination ""
    for { set it 0 } { $it < $PostSelecTextures(Num)} { incr it} {
	lappend destination $PostSelecTextures($it)
    }

    PostSelecTexturesClose $w
}

proc PostSelecTextures { w num_entries varname } {
    global GidPriv PostSelecTextures
    upvar $varname text_lst

    if { [ winfo exists $w] } {
	raise $w
	return
    }

    toplevel $w
    set parent_w [winfo toplevel [winfo parent $w]]
    wm transient $w $parent_w
    wm withdraw $w

    set GidPriv(PostSelecTexturesWindow) $w
    #set PostSelecTextures(ReturnVariable) $varname

    set c [ CreateScrolledCanvas $w.c]
    $c configure -width 300 -height 200

    set min [ llength $text_lst]
    if { $num_entries < $min} {
	set min $num_entries
    }

    for { set it 0 } { $it < $min} { incr it} {
	set PostSelecTextures($it) [ lindex $text_lst $it]
    }
    for { set it $min} { $it < $num_entries} { incr it} {
	set PostSelecTextures($it) ""
    }

    set PostSelecTextures(Num) $num_entries
    for { set it 0 } { $it < $num_entries} { incr it} {
	ttk::frame $c.t$it -borderwidth 0
	label $c.t$it.l -text [concat [_ "Texture"] "[format %2d [expr $it + 1]]"]:

	ttk::button $c.t$it.b -image [gid_themes::GetImage "folder.png" small_icons] -command "PostSphereOptionsTextureFile $w PostSelecTextures($it)"
	ttk::entry $c.t$it.e -textvariable PostSelecTextures($it) -width 50	

	grid $c.t$it.l $c.t$it.b $c.t$it.e -sticky we -padx 0
	grid rowconfigure $c.t$it 0 -weight 1
	grid columnconfigure $c.t$it 0 -weight 1
	
	AddToScrolledCanvas $w.c $c.t$it
    }

    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame   
    ttk::button $w.but.accept -text [_ "Apply"] -command "PostSelecTexturesAccept $w $varname" \
	-style BottomFrame.TButton       
    ttk::button $w.but.close -text [_ "Close"] -command "PostSelecTexturesClose $w" \
	-style BottomFrame.TButton	

    grid $w.but.accept -padx 4 -pady 10 -sticky ew
    grid $w.but.close -row 0 -column 1 -padx 4 -pady 10 -sticky ew

    grid $w.c -sticky news
    grid $w.but -sticky wes
    grid anchor $w.but center

    #wm withdraw $w
    update idletasks

    set w2 [ expr [ winfo reqwidth $w] / 2]
    set h2 [ expr [ winfo reqheight $w] / 2]
    set x [ expr [ winfo pointerx $parent_w] - $w2]
    set y [ expr [ winfo pointery $parent_w] - $h2]

    # miramos si sale la X
    set off_scr_x [ expr ( $x + $w2 + $w2) - [ winfo screenwidth $w]]
    if { $off_scr_x >= 0} {
	set x [ expr $x - $off_scr_x - 10]
    }
    if { $x < 0} { set x 0}
    # miramos si sale la Y
    set off_scr_y [ expr ( $y + $h2 + $h2) - [ winfo screenheight $w]]
    if { $off_scr_y >= 0} {
	set y [ expr $y - $off_scr_y - 20]
    }
    if { $y < 0} { set y 0}

    wm geometry $w +$x+$y
    wm deiconify $w

    bind $w <Escape> "PostSelecTexturesClose $w"
}

### proc PostSphereOptionsSelectTextures { w} {
###     global PSpherePriv
### 
###     ##set PSpherePriv(SelectedResult) ""
###     PostSelecTextures $w.st $PSpherePriv(NumTextures) PSpherePriv(TexturesLst)
###     #PSpherePriv(SelectedResult)
###     tkwait window $w.st
### 
###     if { $PSpherePriv(DynamicUpdate) } { PostSphereAccept}
### }

proc DestroyPostSphereOptions { W w } {
    if { $W != $w } return
    global PSpherePriv
    trace remove variable PSpherePriv(Value) write ChangeSphereSizeScale
    trace remove variable PSpherePriv(Detail) write ChangeSphereDetail
    trace remove variable PSpherePriv(NiceValue) write ChangeSphereDetailScale
    ### trace remove variable PSpherePriv(WhichSize) write ChangeSphereWhichSize
    ### trace remove variable PSpherePriv(SelectedResult) write ChangeSelectedResult
}

proc PostSphereOptions { { w .gid.wPostSphereOptions } args } {
    global PSpherePriv

    InitWindow2 $w -title [_ "Sphere / circle options"] \
        -geometryvariable PostSphereOptionsWindowGeom \
        -initcommand PostSphereOptions -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set PSpherePriv(DynamicUpdate) 1

    ttk::frame $w.f0
    ttk::radiobutton $w.f0.rd1 -text [_ "Quick"] -value Quick -variable PSpherePriv(Detail)
    ttk::radiobutton $w.f0.rd11 -text [_ "Internal texture"] -value InternalTexture -variable PSpherePriv(Detail)
    ttk::radiobutton $w.f0.rd2 -text [_ "Nice"] -value Nice -variable PSpherePriv(Detail)
    ttk::radiobutton $w.f0.rd3 -text [_ "Texture"] -value Texture -variable PSpherePriv(Detail)
    if { ![info exists PSpherePriv(DynamicUpdate)] } { set PSpherePriv(DynamicUpdate) 0 }
    ttk::checkbutton $w.f0.din -text [_ "Dynamic update"]  -variable PSpherePriv(DynamicUpdate)
    grid $w.f0.rd1 $w.f0.rd11 $w.f0.rd2 $w.f0.rd3 -sticky w -padx 1
    grid $w.f0.din -row 0 -column 4 -sticky e -padx 3
    grid rowconfigure $w.f0 0 -weight 1

    ttk::frame $w.f1 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f1.l -text [_ "Sphere size factor"]:
    # ttk::checkbutton $w.f1.scb -text [_ "World fixed"] -onvalue World -offvalue Screen \
    # 	-variable ::PSpherePriv(SizeType)
    ### ttk::radiobutton $w.f1.rd1 -text [_ "Size"]: -value Fixed -variable ::PSpherePriv(WhichSize)
    ### ttk::radiobutton $w.f1.rd2 -text [_ "Result's size"]: -value Variable -variable PSpherePriv(WhichSize)

    UpDownEntry $w.f1.fe -variable PSpherePriv(Value) \
	    -up-command "PostSphereOptionsIncrementaTamanno 1" \
	    -down-command "PostSphereOptionsDecrementaTamanno 1" \
	    -entry-options "-width 10" \
	    -show-double-buttons  \
	    -up-up-command "PostSphereOptionsIncrementaTamanno 5" \
	    -down-down-command "PostSphereOptionsDecrementaTamanno 5" \
	    -up-color red -down-color blue\
	    -up-up-color red -down-down-color blue \

    text $w.f1.t -relief sunken -borderwidth 1 -width 15 -height 4 -state disabled
    ttk::button $w.f1.selres -text [_ "Select result"]...  \
	    -command "PostSphereOptionsSelectResult $w $w.f1.t"	   
    set PSpherePriv(PostSphereOptionsResultTextW) $w.f1.t
    ttk::frame $w.f1.ff -borderwidth 0
    ttk::label $w.f1.ff.l -text [_ "factor"]:
    if { ![info exists PSpherePriv(ResultFactor)] } { set PSpherePriv(ResultFactor) "" }
    ttk::entry $w.f1.ff.factor -textvariable PSpherePriv(ResultFactor) -width 10
    set PSpherePriv(NormalEntryBackground) [ $w.f1.ff.factor cget -background]
    set PSpherePriv(DisabledEntryBackground) [ $w cget -background]
    grid $w.f1.ff.l -sticky es
    grid $w.f1.ff.factor -sticky wes -row 0 -column 1
    grid rowconfigure $w.f1.ff 0 -weight 1
    grid columnconfigure $w.f1.ff 1 -weight 1

    grid $w.f1.l -sticky w -row 0 -column 0

    ### grid $w.f1.rd1 -sticky w
    grid $w.f1.fe -sticky w -row 1 -column 1
    # grid $w.f1.scb -sticky e -row 1 -column 2
    ### grid $w.f1.rd2 -sticky wn
    # grid $w.f1.t -sticky nsew -row 2 -column 1 -rowspan 3 -columnspan 2 -padx 4 -pady 2
    grid $w.f1.t -sticky nsew -row 2 -column 1 -rowspan 3 -padx 4 -pady 2
    grid $w.f1.selres -sticky en -row 3 -column 0 -padx 4
    grid $w.f1.ff -sticky wes -row 4 -column 0 -padx 4 -pady 2
    grid rowconfigure $w.f1 2 -weight 1
    grid columnconfigure $w.f1 1 -weight 1
    #grid rowconfigure $w.f1 4 -weight 1
    #grid columnconfigure $w.f1 0 -weight 1

    ttk::frame $w.f2 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f2.l -text [_ "Nice Detail"]:

    UpDownEntry $w.f2.s -variable PSpherePriv(NiceValue) \
	    -up-command PostSphereOptionsIncrementaBonito \
	    -down-command PostSphereOptionsDecrementaBonito \
	    -entry-options "-width 10" \
	    -up-color red -down-color blue\

    grid $w.f2.l -sticky w -padx 2
    grid $w.f2.s -row 0 -column 1 -sticky we -padx 4
    grid rowconfigure $w.f2 0 -weight 1
    grid columnconfigure $w.f2 1 -weight 1

    ### ttk::frame $w.f3 -style ridge.TFrame -borderwidth 2
    ### 
    ### ttk::label $w.f3.l -text [_ "Number of textures"]:
    ### 
    ### UpDownEntry $w.f3.e -variable PSpherePriv(NumTextures) \
    ### 	    -up-command PostSphereOptionsIncrementaNumTex \
    ### 	    -down-command PostSphereOptionsDecrementaNumTex \
    ### 	    -entry-options "-width 10" \
    ### 	    -up-color red -down-color blue
    ### 
    ### ttk::button $w.f3.seltex -text [_ "Pick images >>>"]  \
    ### 	    -command "PostSphereOptionsSelectTextures $w"   
    ### 
    ### grid $w.f3.l -sticky w -padx 2
    ### grid $w.f3.e -sticky e -padx 4
    ### grid $w.f3.seltex -sticky se -padx 4 -pady 2
    ### grid rowconfigure $w.f3 1 -weight 1
    ### grid rowconfigure $w.f3 2 -weight 1
    ### grid columnconfigure $w.f3 0 -weight 1


    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame   
    ttk::button $w.but.accept -text [_ "Apply"] -command PostSphereAccept \
	-style BottomFrame.TButton
    ttk::button $w.but.original -text [_ "Original"] -command PostSphereOriginal \
	-style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] \
	-style BottomFrame.TButton	

    grid $w.but.accept -row 0 -column 0 -padx 4 -pady 10 -sticky ew
    grid $w.but.original -row 0 -column 1 -padx 4 -pady 10 -sticky ew
    grid $w.but.close -row 0 -column 2 -padx 4 -pady 10 -sticky ew

    grid $w.f0 -sticky new -columnspan 2 -padx 3 -pady 3
    grid $w.f1 -sticky nsew -rowspan 2 -padx 3 -pady 3
    grid $w.f2 -sticky nsew -row 1 -column 1 -padx 3 -pady 3
    ### grid $w.f3 -sticky wes -row 2 -column 1 -padx 3 -pady 3
    grid $w.but -sticky nsew -row 3 -column 0 -columnspan 2
    grid anchor $w.but center
    grid columnconfigure $w 0 -weight 1
    grid columnconfigure $w 1 -weight 1
    grid rowconfigure $w 1 -weight 1
    grid rowconfigure $w 2 -weight 1

    set PSpherePriv(AvoidUpdate) 0

    set PSpherePriv(DoingAccept) 0
    FillPostSphereOptionsWInfo 1

    bind $w.f1.ff.factor <Return> PostSphereAccept

    trace add variable PSpherePriv(Value) write ChangeSphereSizeScale
    trace add variable PSpherePriv(Detail) write ChangeSphereDetail
    trace add variable PSpherePriv(NiceValue) write ChangeSphereDetailScale
    ### trace add variable PSpherePriv(WhichSize) write ChangeSphereWhichSize
    ### trace add variable PSpherePriv(SelectedResult) write ChangeSelectedResult

    ### set pp $PSpherePriv(SelectedResult)
    ### set PSpherePriv(SelectedResult) ""
    ### set PSpherePriv(SelectedResult) $pp

    focus $w.but.accept

    bind $w <Alt-c> "$w.but.close invoke"
    bind $w <Escape> "$w.but.close invoke"
    bind $w <Return> "$w.but.accept invoke"

    bind $w <Destroy> [list +DestroyPostSphereOptions %W $w]
}

