
#PostResults -*- TCL -*- Created: ramsan&miguel Jan-1997, Modified: ramsan Jan-1997

proc PostNoResults { } {
    GiD_Process Mescape Results Geometry NoResults Geometry Original Geometry HideTheShow escape escape escape escape 'Label Off
    FillPRInfo
    PostAnimateGetResultVisualizationState
}

proc PostIsoSurfacesToSets { } {
    # two steps: 1st turnIntoCuts and 2nd TurnCutIntoMesh/Set
    # GiD_Process Results isosurfaces TurnIntoCuts Mescape DoCut ConvertToSets ALL_CUTSETS
    # need to delte cut in between ...
    foreach cut [ GiD_Info postprocess get all_cutsets] {
        set CutsBefore($cut) 1
    }
    GiD_Process Mescape Results isosurfaces TurnIntoCuts Mescape Results Geometry NoResults
    set cuts_from_iso {}
    foreach cut [ GiD_Info postprocess get all_cutsets] {
        if { ![ info exists CutsBefore($cut)]} {
            lappend cuts_from_iso "$cut"
        }
    }
    GiD_Process Mescape DoCut ConvertToSets ALL_CUTSETS Mescape
    # now they are already deleted when doing ConvertToSets
    # now delete the temporary cuts
    # foreach cut $cuts_from_iso {
    #     GiD_Process Utilities Delete CutSets "$cut" Yes escape escape escape escape
    # }
}

set PRDebug     0
set PRDebugTree 0

proc PRToNode { node } {
    if { $::PRDebugTree} {
        WarnWinText "     ----> PRTONODE converting $node"
    }
    regsub -all {[^a-zA-Z0-9()_/-]} $node {_} node
    if { $::PRDebugTree} {
        WarnWinText "     ----> TO $node"
    }
    return $node
}

proc PRArbolNoResultado { arbol que_res} {
    global GidPriv

    set txt [_ "<No usable results found>"]
    if { $que_res == "No_Result"} {
        set txt [_ "<No result is drawn>"]
    } elseif { $que_res == "Contour_Ranges"} {
        set txt [_ "<No results with Result Range Table associated>"]
    }

    $arbol delete [ $arbol nodes root]
    $arbol insert end root "" -text $txt -data ""
    set GidPriv($arbol,cache) ""
}

proc AddFoldersTree { arbol path res_name } {
    set pp ""
    set lst_niveles [GidUtils::Split $path //]
    foreach iniv $lst_niveles {
        set padre $pp
        if { $pp != ""} { 
            append pp //
        } else {
            set padre root
        }
        append pp $iniv          
        set txt [TranslateResultName $iniv]
        set pp [PRToNode $pp]
        if { ![ $arbol exists $pp] } {
            if { $::PRDebugTree} {
                WarnWinText "   1:arbol insert end $padre $pp -text $txt -image {gid_themes::GetImage folder.png small_icons} -data nodo"
            }
            $arbol insert end $padre $pp -text $txt -image [ gid_themes::GetImage folder.png small_icons] -data nodo
        }
    }
}

proc PRConstruyeArbol { arbol lista_res res_view res_anal res_step} {
    global GidPriv

    if { $::PRDebug} {
        WarnWinText "PRconstruyeArbol $arbol $lista_res $res_view $res_anal $res_step"
    }

    if { ![ info exists GidPriv($arbol,cache)]} {
        set GidPriv($arbol,cache) ""
    }

    # miramos si tenemos que recostruir el arbol
    if { $GidPriv($arbol,cache) != ""} {
        # This is not correct:
        # if { $lista_res == $GidPriv($arbol,cache)} {
        #     return
        # }
        if { [ llength $lista_res] == [ llength $GidPriv($arbol,cache)]} {
            set iguales 1
            for { set i 0 } { $i < [ llength $lista_res]} { incr i} {
                if { ![ string equal [ lindex $lista_res $i] [ lindex $GidPriv($arbol,cache)]] } {
                    set iguales 0
                    break
                }
            }
            if { $iguales} { return}
        }
    }
    $arbol delete [ $arbol nodes root]

    # set res_view $GidPriv(PostResultsView)
    # set res_anal $GidPriv(PostResultsAnal)
    # set res_step $GidPriv(PostResultsStep)

    if { $::PRDebugTree} {
        WarnWinText "   arbol delete"
    }
    $arbol delete [ $arbol nodes root]

    #set l_res [ lsort $lista_res]
    set l_res $lista_res

    foreach i_res $l_res {
        set name_split [GidUtils::Split $i_res //]
        if { [llength $name_split] > 1 } {
            set path [join [lrange $name_split 0 end-1] //]
            set res_name [lindex $name_split end]
        } else {
            set path root          
            set res_name $i_res            
        }        
        AddFoldersTree $arbol $path $res_name        
        set txt [TranslateResultName $res_name]
        #$arbol insert end $path "$path->$res_name" -text $txt -image [ gid_themes::GetImage point.png small_icons]
        if { $i_res != ""} {
            set l_comp [GiD_Info postprocess get components_list $res_view $i_res $res_anal $res_step]
        } else {
            set l_comp {}
        }
        set n_comp [llength $l_comp]
        if { $n_comp > 1} {
            if { $::PRDebugTree} {
                WarnWinText "   2:arbol [ PRToNode $path] [PRToNode $i_res] -text $txt -data nodoinsert end"
            }
            $arbol insert end [ PRToNode $path] [ PRToNode $i_res] -text $txt -image [ gid_themes::GetImage prof1.png] -data nodo
            if { $i_res != ""} {
                set tmp_comp [GiD_Info postprocess get components_list $res_view $i_res $res_anal $res_step]
            } else {
                set tmp_comp {}
            }
            foreach comp $tmp_comp {
                set txt [TranslateResultComponentName $comp]
                if { $::PRDebugTree} {
                    WarnWinText "   3:arbol insert end [PRToNode $i_res] [PRToNode \"$i_res->$comp\"] -text $txt -image {gid_themes::GetImage point.png small_icons]} -data [ list hoja $i_res $comp]"
                }
                set name_split [GidUtils::Split $i_res//$comp //]
                set path [join [lrange $name_split 0 end-1] //]
                set res_name [lindex $name_split end]                
                AddFoldersTree $arbol $path $comp                
                set txt [TranslateResultComponentName $res_name]
                $arbol insert end [PRToNode $path] [PRToNode "$i_res->$comp"] \
                    -text $txt -image [ gid_themes::GetImage point.png small_icons] \
                    -data [list hoja $i_res $comp]
            }
        } else {
            set comp [lindex $l_comp 0]
            set txt [TranslateResultComponentName $comp]
            if { $::PRDebugTree} {
                WarnWinText "   4:arbol insert end [ PRToNode $path] [PRToNode \"$i_res->$comp\"] -text $txt -image { gid_themes::GetImage point.png small_icons} -data [ list hoja $i_res $comp]"
            }
            $arbol insert end [PRToNode $path] [PRToNode "$i_res->$comp"] \
                -text $txt -image [ gid_themes::GetImage point.png small_icons] \
                -data [list hoja $i_res $comp]
        }
        
    }
    set GidPriv($arbol,cache) $lista_res
    if { $::PRDebugTree} {
        WarnWinText "     done."
    }
}

proc FillPRInfo {} {
    global GidPriv

    if { $::PRDebug} {
        WarnWinText FillPRInfo----------------------------
    }

    if { ![info exists GidPriv(PostResultsWindow)] || \
            ![winfo exists $GidPriv(PostResultsWindow)] } { return }

    if { ![ info exists GidPriv(PRDoingAccept)]} {
        set GidPriv(PRDoingAccept) 0
    }

    if { $GidPriv(PRDoingAccept)} { return}

    set w $GidPriv(PostResultsWindow)

    if { $::PRDebug} {
        WarnWinText "FillPRInfo: getting info"
    }
    set all_analysis_values [lsort -dictionary [ GiD_Info postprocess get all_analysis]]
    set curr [ GiD_Info postprocess get cur_analysis]
    if { $all_analysis_values == ""} {
        if { $::PRDebug} {
            WarnWinText "FillPRInfo: no analysis found."
        }
        $w.rv.m1 configure -values ""
        $w.rv.m2 configure -values ""
        $GidPriv(Result_wid) delete [ $GidPriv(Result_wid) nodes root]
        set GidPriv($GidPriv(Result_wid),cache) ""
        return
    }
    # if { [ lsearch $all_analysis_values $curr] == -1} {
    #         ser curr [ lindex $all_analysis_values end]
    # }
    
    set max_len 0
    $w.rv.m1 configure -values ""   
    set all_analysis_labels {}
    foreach i $all_analysis_values {
        set var [TranslateResultName $i]
        lappend all_analysis_labels $var
        set l [ string length $var]
        if { $l > $max_len} {
            set max_len $l
        }
    }

    $w.rv.m1 configure -values $all_analysis_values -labels $all_analysis_labels
    if { $max_len > 20} {
        grid configure $w.rv.m1 -sticky ew
    }
    if { $curr == "" } {
        set curr [lindex $all_analysis_values 0]
    }
    if { $::PRDebug} {
        WarnWinText "FillPRInfo: set GidPriv(PostResultsAnal) -$curr-"
    }
    set GidPriv(PostResultsAnal) $curr
    if { $::PRDebug} {
        WarnWinText "FillPRInfo: done"
    }

    # Ahora los Steps:
    set analisis $GidPriv(PostResultsAnal)
    if { $analisis != ""} {
        set current [ GiD_Info postprocess get cur_step $analisis]
        set currentidx 0
        if { [ catch { set all_steps [ GiD_Info postprocess get all_steps $analisis]}]} {
            set all_steps {}
        }
        set mxw 0
        foreach st $all_steps {
            if { [ string length $st] > $mxw} {
                set mxw [ string length $st]
            }
        }
        if { $mxw < 6} { set mxw 6}
        $w.rv.cbstep configure -values $all_steps -width $mxw
        set GidPriv(PostResultsStep) $current
    } else {
        $w.rv.cbstep configure -values ""
    }

    if { [ catch { set all [ GiD_Info postprocess get all_steps $analisis]}]} {
        set all {}
    }
    set curr [ GiD_Info postprocess get cur_step]
    # if { ( $curr == "") || ( [ lsearch $all $curr] == -1)} {
    #         set curr [lindex $all end]
    # }
    if { $curr == ""} {
        set curr [lindex $all end]
    }
    if { $::PRDebug} {
        WarnWinText "FillPRInfo: set GidPriv(PostResultsStep) -$curr-"
    }
    set GidPriv(PostResultsStep) $curr
    if { $::PRDebug} {
        WarnWinText "FillPRInfo: done"
    }


    # Ahora la vista de resultados
    set all_views_values [ GiD_Info postprocess get all_results_views]
    set all_views_labels {}
    foreach j $all_views_values {
        regsub -all {_} $j { } var
        lappend all_views_labels [_ $var]
    }
    $w.rv.m2 configure -values $all_views_values -labels $all_views_labels
    
    set curr [ GiD_Info postprocess get cur_results_view]
    if { $curr == "Iso_Surfaces"} { set curr "No_Result"}
    if { $curr == "" } {
        set curr [ lindex $all_views_values 2]
    }
    set GidPriv(PostResultsView) $curr

    # Ahora los resultados
    set all [ GiD_Info postprocess get cur_results_list $curr ]

    set all [ lsort -dictionary $all]

    if { $all != "" } {        
        PRConstruyeArbol $GidPriv(Result_wid) $all \
            $::GidPriv(PostResultsView) $::GidPriv(PostResultsAnal) $::GidPriv(PostResultsStep)
        set curr [ GiD_Info postprocess get cur_result]
        if { $curr == "" || [lsearch $all $curr] == -1 } {
            set curr [lindex $all 0] 
        }
        set GidPriv(PostResultsRes) $curr

    } else {
        set GidPriv(PostResultsRes) ""
        PRArbolNoResultado $GidPriv(Result_wid) $GidPriv(PostResultsView)
    }
    focus $GidPriv(Result_wid)

    # y sus componentes
    if { $GidPriv(PostResultsRes) != "" } {
        set curr $GidPriv(PostResultsRes)
        set all [ GiD_Info postprocess get cur_components_list $curr]
        if { $all != "" } {        
            set curr [ GiD_Info postprocess get cur_component]
            if { $curr == "" } {
                set curr [lindex $all 0]
            }
            set GidPriv(PostResultsComp) $curr
        }
    } else {
        set GidPriv(PostResultsComp) ""
    }

    if { $GidPriv(PostResultsRes) != "" && $GidPriv(PostResultsComp) != ""} {
        set nodo "$GidPriv(PostResultsRes)->$GidPriv(PostResultsComp)"
        regsub -all { } $nodo {_} nodo
        set nodo [PRToNode $nodo]
        set arbol $GidPriv(Result_wid)
        if { $::PRDebugTree} {
            WarnWinText "     1:arbol selection set $nodo"
        }
        set err [ catch {
            $arbol selection set $nodo
        } errTxt ]
        if { !$err} {
            for { set p $nodo} { $p != "root"} { set p [ $arbol parent $p]} {
                if { $::PRDebugTree} {
                    WarnWinText "     1:arbol opentree $p"
                }
                $arbol opentree $p
            }
        } else {
            if { $::PRDebug} {
                WarnWinText "ERROR ( $arbol selection set $nodo) \n\t--> $errTxt"
            }
        }
        focus $arbol
    }

    if { ( $GidPriv(PostResultsView) != "Display_Vectors") && \
            ( $GidPriv(PostResultsView) != "Result_Surface") && \
            ( $GidPriv(PostResultsView) != "Line_Thickness") && \
            ( $GidPriv(PostResultsView) != "Scalar_Line_Diagram") && \
            ( $GidPriv(PostResultsView) != "Vector_Line_Diagram") } {
        #$w.rv.f.e2 delete 0 end
        $w.rv.f.e2 configure -foreground grey60
        $w.rv.f.e2 configure -state disabled
        $w.rv.f.l6 configure -foreground grey60
    } else {
        set res_view $GidPriv(PostResultsView)
        set res_anal $GidPriv(PostResultsAnal)
        set res_step $GidPriv(PostResultsStep)
        set res_res $GidPriv(PostResultsRes)
        set res_comp $GidPriv(PostResultsComp)
        # W "8: set GidPriv(PostResultsVfact) [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]"
        set GidPriv(PostResultsVfact) [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
    }
}

proc FillPRSteps {name1 name2 op} {
    global GidPriv

    if { $::PRDebug} {
        WarnWinText "FillPRSteps---------------------- $name1 $name2"
    }
    set w $GidPriv(PostResultsWindow)
    set analisis $GidPriv(PostResultsAnal)
    if { $::PRDebug} {
        WarnWinText "FillPRSteps: analisis = '$analisis'"
    }
    if { $analisis != ""} {
        if { [ catch { set all [ GiD_Info postprocess get all_steps $analisis]}]} {
            set all {}
        }
        set current [ GiD_Info postprocess get cur_step $analisis]

        if { $current == "" || [ lsearch $all $current] == -1 } {
            set current [lindex $all 0]
        }
        set mxw 0
        foreach st $all {
            if { [ string length $st] > $mxw} {
                set mxw [ string length $st]
            }
        }
        if { $mxw < 6} { set mxw 6}
        $w.rv.cbstep configure -values $all -width $mxw
        if { $::PRDebug} {
            WarnWinText "FillPRSteps: set GidPriv(PostResultsStep) -$current-"
        }
        set GidPriv(PostResultsStep) $current
    } else {
        $w.rv.cbstep configure -values ""
    }
}

proc PRChangedStep {name1 name2 op} {
    global GidPriv
    set w $GidPriv(PostResultsWindow)
    if { $::PRDebug} {
      WarnWinText "step cambiado: '$GidPriv(PostResultsStep)'"
    }
    if {  $GidPriv(PostResultsStep) == ""} { return }
    # # para que rehaga el menu
    # set GidPriv(PostResultsRes) ""
    FillPROtherMenusLazy $name1 $name2 $op
    if { [ info exists ::GidPriv(PostResultsWTree)]} {
        after idle [ list ::PostFillView_ShowResult $::GidPriv(PostResultsWTree) \
                         $::GidPriv(PostResultsRes) $::GidPriv(PostResultsComp) ]
    }
    #PRAccept
    return
}

proc FillPRGetCurrentResultViewFactor { res_view res_res res_comp res_anal res_step} {
    set ret_factor 1.0

    if { [GiD_Result exists [list $res_res $res_anal $res_step]] } {
        if { ( $res_view == "Display_Vectors")} {
            set  ret_factor [GiD_Info postprocess get cur_vector_factor Display_Vectors $res_res $res_anal $res_step]
        } elseif { ( $res_view == "Scalar_Line_Diagram") || ( $res_view == "Vector_Line_Diagram") } {
            if { ( $res_view == "Scalar_Line_Diagram") && ( $res_comp != "")} {
                set ret_factor [GiD_Info postprocess get cur_diagram_factor $res_res $res_comp $res_anal $res_step]
            } else {
                set ret_factor [GiD_Info postprocess get cur_diagram_factor $res_res $res_anal $res_step]
            }
        } elseif { ( $res_view == "Result_Surface") || ( $res_view == "Line_Thickness") } {
            set ret_factor [GiD_Info postprocess get cur_result_surface_factor \
                                $res_view $res_res $res_comp $res_anal $res_step]
        }
    }
    return $ret_factor
}

proc FillPROtherMenus {name1 name2 op} {
    global GidPriv
    set w $GidPriv(PostResultsWindow)
    
    #puts FillPROtherMenus-----------------------------
    if { $::PRDebug} {
        WarnWinText "FillPROtherMenus----------------- $name1 $name2 $op"
    }
    set vn {PostResultsStep PostResultsView PostResultsRes PostResultsComp}
    set i [lsearch $vn $name2]   
    
    switch $i {
        0 {
            set all [ GiD_Info postprocess get all_results_views]
            set curr [ GiD_Info postprocess get cur_results_view]
            if { $curr == "Iso_Surfaces"} { set curr "No_Result"}
        }
        1 {
            if { $::PRDebug} {
                WarnWinText "1 FillPROtherMenus: $GidPriv(PostResultsView)"
            }
            if { $GidPriv(PostResultsView) == "" } {
                set all ""
                set curr ""
            } else {
                set res_view $GidPriv(PostResultsView)                
                set res_anal $GidPriv(PostResultsAnal)
                set res_step $GidPriv(PostResultsStep)
                if { ( $res_view == "" ) || ( $res_anal == "") } {
                    set all ""
                    set curr ""
                } else {
                    if { [catch { set all [ GiD_Info postprocess get results_list $res_view $res_anal $GidPriv(PostResultsStep)] } err] } {
                        set all ""
                    }
              
                    
                    set all [ lsort -dictionary $all]
                    
                    if { $::PRDebug} {
                        WarnWinText "$res_view -> $all"
                    }
                    
                    set curr [ GiD_Info postprocess get cur_result]
                    if { $curr == "" || [ lsearch -exact $all $curr] == -1 } {
                        set curr [lindex $all 0]
                    }
                    set res_res $GidPriv(PostResultsRes)
                    set res_comp $GidPriv(PostResultsComp)
                    if { [ lsearch -exact $all $res_res] == -1} {
                        set res_res [ lindex $all 0]
                        if { $res_res != ""} {
                            set all_comp [GiD_Info postprocess get components_list $res_view $res_res $res_anal $GidPriv(PostResultsStep)]
                            set res_comp [lindex $all_comp 0]
                        } else {
                            set all_comp {}
                            set res_comp {}
                        }
                    }
                    if { $res_view == "Display_Vectors" } {
                        $w.rv.f.e2 configure -state normal
                        $w.rv.f.e2 configure -foreground black
                        $w.rv.f.l6 configure -foreground black
                        if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && \
                            ( $GidPriv(PostResultsStep) != "") } {
                            set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                            if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact)} {
                                set kk $GidPriv(PostResultsVfact)
                            }
                            if { $::PRDebug} {
                                WarnWinText "1: -$kk-$GidPriv(PostResultsVfact)"
                            }                          
                            if { $kk != 0} {
                                $w.rv.f.e2 delete 0 end
                                $w.rv.f.e2 insert end $kk
                                if { $::PRDebug} {
                                    WarnWinText "      entry = [ $w.rv.f.e2 get]"
                                }
                            }
                            focus $w.rv.f.e2
                        } else {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end "1.0"
                            focus $w.rv.f.e2
                        }
                    } elseif { ( $res_view == "Scalar_Line_Diagram") || ( $res_view == "Vector_Line_Diagram") } {
                        $w.rv.f.e2 configure -state normal
                        $w.rv.f.e2 configure -foreground black
                        $w.rv.f.l6 configure -foreground black
                        if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && ( $GidPriv(PostResultsStep) != "") } {
                            set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                            if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact)} {
                                set kk $GidPriv(PostResultsVfact)
                            }
                            if { $kk != 0 } {
                                $w.rv.f.e2 delete 0 end
                                $w.rv.f.e2 insert end $kk
                            }
                            focus $w.rv.f.e2
                        } else {
                            $w.rv.f.e2 insert end "1.0"
                            focus $w.rv.f.e2
                        }
                    } elseif { ( $res_view == "Result_Surface") || ( $res_view == "Line_Thickness")} {
                        $w.rv.f.e2 configure -state normal
                        $w.rv.f.e2 configure -foreground black
                        $w.rv.f.l6 configure -foreground black
                        if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && \
                            ( $GidPriv(PostResultsStep) != "") } {
                            if { $::PRDebug} {
                                WarnWinText "11 - -$res_view-$res_res-$res_comp-$res_anal-$GidPriv(PostResultsStep)-"
                            }
                            set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                            if { $::PRDebug} {
                                WarnWinText "01: -$kk-$GidPriv(PostResultsVfact)"
                            }
                            if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact)} {
                                set kk $GidPriv(PostResultsVfact)
                            }
                            if { $::PRDebug} {
                                WarnWinText "10: -$kk-$GidPriv(PostResultsVfact)"
                            }
                            if { $kk != 0 } {
                                $w.rv.f.e2 delete 0 end
                                $w.rv.f.e2 insert end $kk
                            }
                            focus $w.rv.f.e2
                        } else {
                            $w.rv.f.e2 insert end "1.0"
                            focus $w.rv.f.e2
                        }
                    } else {
                        #$w.rv.f.e2 delete 0 end
                        $w.rv.f.e2 configure -foreground grey60 -state disabled
                        $w.rv.f.l6 configure -foreground grey60
                    }
                }
            }
        }
        2 {
            if { $GidPriv(PostResultsView) == "" } {
                set all ""
                set curr ""
            } else {
                
                set res_view $GidPriv(PostResultsView)
                set res_res $GidPriv(PostResultsRes)
                set res_anal $GidPriv(PostResultsAnal)
                set res_step $GidPriv(PostResultsStep)
                if { $res_res != ""} {
                    if { [catch { set all [GiD_Info postprocess get components_list $res_view $res_res $res_anal $GidPriv(PostResultsStep)] } err] } {
                        set all ""
                    }
                    set curr [GiD_Info postprocess get cur_component]
                } else {
                    set all {}
                    set curr {}
                }

                if { $curr == "" || [ lsearch -exact $all $curr] == -1 } {
                    set curr [lindex $all 0]
                }
                set res_comp $curr
                if { $res_view == "Display_Vectors" } {
                    if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && \
                        ( $GidPriv(PostResultsStep) != "") } {
                        if { $::PRDebug} {
                            WarnWinText "2 --$res_view-$res_res-$curr-$res_anal-$GidPriv(PostResultsStep)-"
                        }
                        set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                        if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact) } {
                            set kk $GidPriv(PostResultsVfact)
                        }
                        if { $::PRDebug} {
                            WarnWinText "2: -$kk-$GidPriv(PostResultsVfact)"
                        }                       
                        if { $kk != 0} {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end $kk
                        } else {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end "1.0"
                        }
                    }
                } elseif { ( $res_view == "Scalar_Line_Diagram") || ( $res_view == "Vector_Line_Diagram") } {
                    if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && ( $GidPriv(PostResultsStep) != "") } {
                        set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                        #WarnWin "'$res_res' '$curr' '$res_anal' '$GidPriv(PostResultsStep)' -> '$kk'"
                        if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact) } {
                            set kk $GidPriv(PostResultsVfact)
                        }
                        if { $kk != 0 } {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end $kk
                        }
                    } else {
                        $w.rv.f.e2 delete 0 end
                        $w.rv.f.e2 insert end "1.0"
                    }
                } elseif { ( $res_view == "Result_Surface") || ( $res_view == "Line_Thickness")} {
                    if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && ( $GidPriv(PostResultsStep) != "") } {
                        set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                        if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact) } {
                            set kk $GidPriv(PostResultsVfact)
                        }
                        if { $kk != 0 } {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end $kk
                        } else {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end "1.0"
                        }
                    }
                }
            }
        }
        3 {
            if { $GidPriv(PostResultsView) == "" } {
                set all ""
                set curr ""
            } else {                
                set res_view $GidPriv(PostResultsView)               
                set res_res $GidPriv(PostResultsRes)
                set res_comp $GidPriv(PostResultsComp)
                set res_anal $GidPriv(PostResultsAnal)
                set res_step $GidPriv(PostResultsStep)
                if { $res_res != ""} {                    
                    if { [catch { set all [ GiD_Info postprocess get components_list $res_view $res_res $res_anal $GidPriv(PostResultsStep)] } err] } {
                        set all ""
                    }                                       
                    set curr [ GiD_Info postprocess get cur_component]
                } else {
                    set all {}
                    set curr {}
                }

                if { $curr == "" || [ lsearch -exact $all $curr] == -1 } {
                    set curr [lindex $all 0]
                }
                set res_comp $curr
                if { $res_view == "Display_Vectors" } {
                    if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && \
                        ( $GidPriv(PostResultsStep) != "") } {
                        set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                        if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact) } {
                            set kk $GidPriv(PostResultsVfact)
                        }
                        if { $::PRDebug} {
                            WarnWinText "3: -$kk-$GidPriv(PostResultsVfact)"
                        }
                        if { $kk != 0} {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end $kk
                        } else {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end "1.0"
                        }
                    }
                } elseif { ( $res_view == "Scalar_Line_Diagram") || ( $res_view == "Vector_Line_Diagram") } {
                    if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && ( $GidPriv(PostResultsStep) != "") } {
                        set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                        #WarnWin "'$res_res' '$res_comp' '$res_anal' '$GidPriv(PostResultsStep)' -> '$kk'"
                        if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact) } {
                            set kk $GidPriv(PostResultsVfact)
                        }
                        if { $kk != 0 } {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end $kk
                        }
                    } else {
                        $w.rv.f.e2 delete 0 end
                        $w.rv.f.e2 insert end "1.0"
                    }
                } elseif { ( $res_view == "Result_Surface") || ( $res_view == "Line_Thickness")} {
                    if { ( $res_res != "") && ( $res_anal != "") && ( $res_view != "") && \
                        ( $GidPriv(PostResultsStep) != "") } {
                        #WarnWin "3 -$res_view-$res_res-$res_comp-$res_anal-$GidPriv(PostResultsStep)-"
                        set kk [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
                        if { $GidPriv(PostResultsVfact) != "" && $kk != $GidPriv(PostResultsVfact) } {
                            set kk $GidPriv(PostResultsVfact)
                        }
                        if { $::PRDebug} {
                            WarnWinText "3: -$kk-$GidPriv(PostResultsVfact)"
                        }
                        if { $kk != 0 } {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end $kk
                        } else {
                            $w.rv.f.e2 delete 0 end
                            $w.rv.f.e2 insert end "1.0"
                        }
                    }
                }
            }
        }
    }

    if { [lindex $vn [expr $i+1]] != ""} {
        if { $::PRDebug} {
            WarnWinText "[lindex $vn [expr $i+1]] - $curr - -->"
            # WarnWinText "[lindex $vn [expr $i+1]] - $curr - $GidPriv([lindex $vn [expr $i+1]])"
        }
               
        #PostResultsStep PostResultsView PostResultsRes PostResultsComp

        if { $name2 == "PostResultsStep" } {            
            set labels {}
            foreach j $all {
                regsub -all {_} $j { } var
                lappend labels $var
            }
            $w.rv.m2 configure -values $all -labels $labels
        } elseif { $name2 == "PostResultsView" } {
            if { $::PRDebug} {
                WarnWinText "Contruyendo arbol $GidPriv(Result_wid) -> $all"
            }
            #$GidPriv(Result_wid) delete [ $GidPriv(Result_wid) nodes root]            
            if { $all != ""} {
                PRConstruyeArbol $GidPriv(Result_wid) $all \
                    $::GidPriv(PostResultsView) $::GidPriv(PostResultsAnal) $::GidPriv(PostResultsStep)
            } else {
                PRArbolNoResultado $GidPriv(Result_wid) $GidPriv(PostResultsView)
            }         
            set arbol $GidPriv(Result_wid)
        } else {
#             if { $::PRDebug} {
#                 WarnWinText "Contruyendo resto $m -> $all"
#             }
        }
        if { $::PRDebug} {
            WarnWinText "construyendo -> done"
        }
        if { [lindex $vn [expr $i+1]] == "PostResultsView"} {
            # set curr $GidPriv(PostResultsViewTrad,$curr)
        }
        if { $::PRDebug} {
            WarnWinText "Construyendo arbol set GidPriv([lindex $vn [expr $i+1]]) $curr"
        }
        set GidPriv([lindex $vn [expr $i+1]]) $curr
        
        if { $GidPriv(Result_actualizar) && $GidPriv(PostResultsRes) != "" && $GidPriv(PostResultsComp) != ""} {
            set nodo "$GidPriv(PostResultsRes)->$GidPriv(PostResultsComp)"
            regsub -all { } $nodo {_} nodo
            catch {
                set arbol $GidPriv(Result_wid)
                if { $::PRDebugTree} {
                    WarnWinText "     2:arbol selection set $nodo"
                }
                $arbol selection set $nodo
                for { set p $nodo} { $p != "root"} { set p [ $arbol parent $p]} {
                    if { $::PRDebugTree} {
                        WarnWinText "     2:arbol opentree $p"
                    }
                    $arbol opentree $p
                }
            }
        }
        
    }
    
    after idle "focus $GidPriv(Result_wid)"
}

proc FillPROtherMenusLazy { name1 name2 op} {
    global GidPriv
    set w $GidPriv(PostResultsWindow)
        
    set res_view $GidPriv(PostResultsView)
    set res_anal $GidPriv(PostResultsAnal)
    if { $::PRDebug} {
        WarnWinText "Lazy 1: '$res_view' $res_anal"
    }
    if { $res_view == "" } {
        FillPROtherMenus $name1 $name2 $op
        return
    }

    if { [catch { set all_results [GiD_Info postprocess get results_list $res_view $res_anal $GidPriv(PostResultsStep)] } err] } {
        set all_results ""
    }
    set res_res $GidPriv(PostResultsRes)

    if { $::PRDebug} {
        WarnWinText "Lazy 2: $res_view $res_anal $GidPriv(PostResultsStep) '$res_res'"
    }
    if { $res_res == "" } {
        #FillPROtherMenus $name1 $name2 $op
        FillPROtherMenus  GidPriv PostResultsView $op
        return
    }

    if { [lsearch $all_results $res_res] == -1 } {
        if { $::PRDebug} {
            WarnWinText "Lazy 3: $res_view $res_anal $GidPriv(PostResultsStep) $res_res"
        }
        # FillPROtherMenus $name1 $name2 $op
        # decimos que queremos otra vez el c.fill para que nos escoja el primero de la lista
        FillPROtherMenus GidPriv PostResultsView $op
        return
    } else {
        if { $res_res != ""} {
            set all_components [GiD_Info postprocess get components_list $res_view $res_res $res_anal $GidPriv(PostResultsStep)]
        } else {
            set all_components {}
        }
        set res_comp $GidPriv(PostResultsComp)
        if { $::PRDebug} {
            WarnWinText "Lazy 4: $res_view $res_anal $GidPriv(PostResultsStep) $res_res $res_comp"
        }
        if { [ lsearch $all_components $res_comp] == -1 } {
            if { $::PRDebug} {
                WarnWinText "Lazy 5: $res_view $res_anal $GidPriv(PostResultsStep) $res_res $res_comp"
            }
            #FillPROtherMenus $name1 $name2 $op
            # decimos que queremos otra vez el c.fill para que nos escoja el primero de la lista
            FillPROtherMenus GidPriv PostResultsView $op
            return
        } else {
            #must do this only if $all_results is different of fist level of current results tree
            FillPROtherMenus GidPriv PostResultsView $op
            return
        }
    }
}

proc PRAccept {} {
    global GidPriv

    set w $GidPriv(PostResultsWindow)
    set res_view $GidPriv(PostResultsView)
    
    # as VerificaReal has been changed, we need to do extra verifying !!!
    if { ( $res_view == "Scalar_Line_Diagram") || ( $res_view == "Vector_Line_Diagram") || 
         ( $res_view == "Display_Vectors") || ( $res_view == "Result_Surface") || ( $res_view == "Line_Thickness")} { 
        if { ![ VerificaReal [_ "Vector factor"]: $GidPriv(PostResultsVfact) $w]} {
            set res_anal $GidPriv(PostResultsAnal)
            set res_step $GidPriv(PostResultsStep)
            set res_res $GidPriv(PostResultsRes)
            set res_comp $GidPriv(PostResultsComp)
            W "9: set GidPriv(PostResultsVfact) [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]"
            set GidPriv(PostResultsVfact) [ FillPRGetCurrentResultViewFactor $res_view $res_res $res_comp $res_anal $res_step]
            return
        }
    }
        
    set quitar_resultado 0
    if { $res_view == "No_Result"} {
        set quitar_resultado 1
    }
    if { !$quitar_resultado && [$GidPriv(Result_wid) selection get] == "" } {
        return
    }

    set GidPriv(PRDoingAccept) 1
    if { !$quitar_resultado} {
        set entry_fact $GidPriv(PostResultsVfact)
        PRSeleccionResultado [$GidPriv(Result_wid) selection get]
        if { $::PRDebug} {
            W "10: set GidPriv(PostResultsVfact) $entry_fact"
        }
        set GidPriv(PostResultsVfact) $entry_fact
    }

    set oldAutomaticRedraw [ GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    set res_anal $GidPriv(PostResultsAnal) 
    set res_step $GidPriv(PostResultsStep)
    regsub -all {_} $GidPriv(PostResultsView) {} resviewcmd ;#because GiD_Process word and keyword returned by GiD_Info are different!!
    set postcmd [list MEscape Results AnalysisSel $res_anal $res_step]    
    if { $res_view == "No_Result"} {
        lappend postcmd Geometry $resviewcmd
    } else {
        set res_res $GidPriv(PostResultsRes)
        set res_comp $GidPriv(PostResultsComp)
        if { ( $res_view != "Scalar_Line_Diagram") && ( $res_view != "Vector_Line_Diagram") } {
            lappend postcmd $resviewcmd $res_res $res_comp
            if { $res_view == "Display_Vectors" } {
                if { $GidPriv(PostResultsVfact) != ""} {
                    lappend postcmd $GidPriv(PostResultsVfact)
                }
            }
            if { ( $res_view == "Result_Surface") || ( $res_view == "Line_Thickness")} {
                if { $GidPriv(PostResultsVfact) != ""} {
                    lappend postcmd $GidPriv(PostResultsVfact)
                }
            }
        } else {
            if { $res_view == "Scalar_Line_Diagram"} {
                lappend postcmd LineDiagram ScalarDiagram $res_res $res_comp $GidPriv(PostResultsVfact)
            } else {
                lappend postcmd LineDiagram VectorDiagram $res_res $GidPriv(PostResultsVfact)
            }
        }
    }
    GiD_Process {*}$postcmd
    # lo separamos por si lo de arriba da un error
    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw   
    set GidPriv(PRDoingAccept) 0
}

proc PRSeleccionResultado { nodo} {
    global GidPriv

    if { $nodo == ""} { return}
    set arbol $GidPriv(Result_wid)
    set datos [ $arbol itemcget $nodo -data]
    if { $::PRDebugTree} {
        WarnWinText "$nodo - [ $arbol itemcget $nodo -data]"
    }
    if { [lindex $datos 0] == "hoja"} {
        set res_name [ lindex $datos 1]
        set res_comp [ lindex $datos 2]
        $arbol selection set $nodo
        set GidPriv(Result_actualizar) 0
        set GidPriv(PostResultsRes) $res_name
        set GidPriv(PostResultsComp) $res_comp
        set GidPriv(Result_actualizar) 1
    } else {
        if { [ $arbol itemcget $nodo -open] } {
            $arbol closetree $nodo
        } else {
            for { set p $nodo} { $p != "root"} { set p [ $arbol parent $p]} {
                $arbol opentree $p
            }
        }
    }
    $arbol see $nodo
}

proc PRDoApply { nodo} {
    global GidPriv
    if { $nodo == ""} { return}
    set arbol $GidPriv(Result_wid)
    set datos [ $arbol itemcget $nodo -data]
    if { $::PRDebugTree} {
        WarnWinText "$nodo - [ $arbol itemcget $nodo -data]"
    }
    if { "[ lindex $datos 0]" == "hoja"} {
        PRAccept
    }
}

#proc PROpenCloseTree { nodo} {
#    global GidPriv
#
#    set arbol $GidPriv(Result_wid)
#    if { [ $arbol itemcget $nodo -open] } {
#         $arbol closetree $nodo
#    } else {
#         for { set p $nodo} { $p != "root"} { set p [ $arbol parent $p]} {
#             $arbol opentree $p
#         }
#    }
#}

proc PostResultsDeleteTraceVariables { w_evento w_padre} {
    if { $w_evento == $w_padre} {
        trace remove variable ::GidPriv(PostResultsAnal) write FillPRSteps
        ####trace remove variable ::GidPriv(PostResultsStep) write PRChangedEntry
        trace remove variable ::GidPriv(PostResultsStep) write PRChangedStep
        trace remove variable ::GidPriv(PostResultsView) write FillPROtherMenus
        trace remove variable ::GidPriv(PostResultsRes) write FillPROtherMenus
        trace remove variable ::GidPriv(PostResultsComp) write FillPROtherMenus
        if { $::PRDebug} {
            WarnWinText "PRDeleteTraceVariables"
        }
        if { [info exists ::GidPriv(Result_wid)] } {
            array unset ::GidPriv $::GidPriv(Result_wid),cache
        }
    }
}

proc PostResultsSetTraceVariables { } {
    trace add variable ::GidPriv(PostResultsAnal) write FillPRSteps
    ####trace add variable ::GidPriv(PostResultsStep) write PRChangedEntry
    trace add variable ::GidPriv(PostResultsStep) write PRChangedStep
    trace add variable ::GidPriv(PostResultsView) write FillPROtherMenus
    trace add variable ::GidPriv(PostResultsRes) write FillPROtherMenus
    trace add variable ::GidPriv(PostResultsComp) write FillPROtherMenus
    if { $::PRDebug} {
        WarnWinText "PRSetTraceVariables"
    }
}


proc PostResultsSetResultsView { nueva_vista} {
    global GidPriv
    if { $nueva_vista != ""} {
        set GidPriv(PostResultsView) $nueva_vista
    }
}

proc PostResults { { w .gid.wPostResults } { inside 0} } {
    global GidPriv

    #puts PostResults----------------------------
    if { !$inside} {
        InitWindow2 $w -title [_ "View Results"] \
        -geometryvariable PostResultsWindowGeom -initcommand PostResults
        if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    } else {
        set GidPriv(PostResultsWindow) $w
    }
    
    if { !$inside} {
        ttk::frame $w.rv -style ridge.TFrame -borderwidth 2
    } else {
        ttk::frame $w.rv -borderwidth 0
    }

    ttk::label $w.rv.l2 -text [_ "View"]:
    TTKComboBox $w.rv.m2 -textvariable ::GidPriv(PostResultsView) \
        -width 20 -state readonly

    ttk::label $w.rv.l1 -text [_ "Analysis"]:
    TTKComboBox $w.rv.m1 -textvariable ::GidPriv(PostResultsAnal) \
        -width 20 -state readonly

    ttk::label $w.rv.lstep -text [_ "Step"]:
    TTKComboBox $w.rv.cbstep -textvariable ::GidPriv(PostResultsStep) \
        -width 8 -state readonly

    ttk::label $w.rv.lres -text [_ "Results"]:

    set sw1 [ ScrolledWindow $w.rv.rtsw -relief sunken -borderwidth 1 -auto both]
    set tree1 [ Tree $sw1.tree -relief flat -borderwidth 0 \
                    -highlightthickness 0 -selectbackground "darkblue" \
                    -selectforeground yellow \
                    -highlightbackground yellow -width 30 -redraw 1]
    set ::GidPriv(PostResultsWTree) $tree1

    set GidPriv(Result_wid) $tree1
    set GidPriv(Result_actualizar) 1

    $tree1 bindImage <${::acceleratorKey}-1> {}
    $tree1 bindText <${::acceleratorKey}-1> {}
    $tree1 bindText <Double-Button-1> PRDoApply
    $tree1 bindImage <1> "focus $sw1.tree; PRSeleccionResultado"
    $tree1 bindText <1> "focus $sw1.tree; PRSeleccionResultado"

    $sw1 setwidget $tree1


    ttk::frame $w.rv.f
    ttk::label $w.rv.f.l6 -text [_ "factor"]:
    if { ![info exists GidPriv(PostResultsVfact)] } { set GidPriv(PostResultsVfact) "" } 
    ttk::entry $w.rv.f.e2 -width 12 -textvariable GidPriv(PostResultsVfact)   
    pack $w.rv.f.l6 $w.rv.f.e2 -side left

    if { !$inside} {
        ttk::frame $w.but -style BottomFrame.TFrame      
        ttk::button $w.but.accept -text [_ "Apply"] -command PRAccept -takefocus 0 -style BottomFrame.TButton
        ttk::button $w.but.close -text [_ "Close"] -command "destroy $w" -takefocus 0 -style BottomFrame.TButton       
        grid $w.but.accept $w.but.close -pady 12 -padx 6 -sticky ews
    }

    grid $w.rv.l2 -sticky e -row 0 -column 0 -padx 2 -pady 1
    grid $w.rv.m2 -sticky w -row 0 -column 1 -padx 2 -pady 1
    grid $w.rv.l1 -sticky e -row 1 -column 0 -padx 2 -pady 1
    grid $w.rv.m1 -sticky w -row 1 -column 1 -padx 2 -pady 1
    grid $w.rv.lstep -sticky w -row 0 -column 2 -padx 2 -pady 1
    grid $w.rv.cbstep -sticky e -row 1 -column 2 -padx 2 -pady 1
    grid $sw1 -sticky news -row 2 -column 0 -columnspan 3 -padx 2 -pady 1
    grid $w.rv.f -sticky w -row 4 -column 0 -columnspan 3 -padx 2 -pady 1
    grid columnconfigure $w.rv 1 -weight 1
    grid rowconfigure $w.rv 2 -weight 1

    if { !$inside} {
        grid $w.rv -sticky nsew
        grid $w.but -sticky sew
        grid anchor $w.but center
    } else {
        grid $w.rv -sticky nsew -padx 4 -pady 8
    }

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1


    FillPRInfo

    if { !$inside} {
        #bind $w <Return> "$w.but.accept invoke"
        bind $w <Alt-c> "$w.but.close invoke"
        bind $w <Escape> "$w.but.close invoke"
    }
    bind $w <Destroy> "+ PostResultsDeleteTraceVariables %W $w"
    
    PostResultsSetTraceVariables    
    focus $w
}

proc FillPostLegendInfo { } {
    global GIDDEFAULT PLegendPriv GidPriv

    if { ![ info exists GidPriv(PostLegendWindow)] || ![ winfo exists $GidPriv(PostLegendWindow)]} {
        return
    }
    set w $GidPriv(PostLegendWindow)
    #$PLegendPriv(w)

    set lst_colores [ GiD_Info postprocess get current_color_scale]
        
    set lst_info [ GiD_Info postprocess get info_legend]

    if { $lst_colores == "" || $lst_info == "" } {
        $PLegendPriv(CanvasLabel) configure -text {}
        $PLegendPriv(Canvas) delete all
        return
    }

    #WarnWin $lst_info

    set cv $PLegendPriv(Canvas)

    $PLegendPriv(CanvasLabel) configure -text {}
    $cv delete all

    set que_res [ lindex $lst_info 0]

    if { $que_res == "" || $que_res == "NOTHING" } {
        $PLegendPriv(CanvasLabel) configure -text {}
        $PLegendPriv(Canvas) delete all
        return
    }

    if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
             $que_res == "CONTOUR_LINES" || $que_res == "SMOOTH_CONTOUR_LINES" || \
             $que_res == "CONTOUR_RANGES" || \
             $que_res == "VECTORS" || $que_res == "ISO_SURFACES" } {
        set label_txt [ TranslateResultName [ lindex $lst_info 1]]
        $PLegendPriv(CanvasLabel) configure -text $label_txt
        
        if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" } {
            set n_info [ expr [ lindex $lst_info 2] + 1]
        } else {
            set n_info [ lindex $lst_info 2]
        }
        set entradas [ lindex $lst_info 3]
        
        set n_col [ lindex $lst_colores 0]
        if {  ( $n_col > 0) && ( $n_info > 0)} {
            # ajustamos parametros escala de color
            set margen_h 12.0
            set margen_w 8.0
            set max_v [ expr $PLegendPriv(CanvasHeight) - 2.0 * $margen_h]
            set incr_col 1.0
        
            if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
                     $que_res == "ISO_SURFACES" || $que_res == "CONTOUR_RANGES" } {
                set npix [ expr $max_v / $n_col]
            } else {
                set npix [ expr $max_v / [ expr $n_col - 1]]
            }
            if { $npix < 1.0} {
                set npix 1.0
                if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
                         $que_res == "ISO_SURFACES" || $que_res == "CONTOUR_RANGES"} {
                    set incr_col [ expr $n_col / $max_v]
                } else {
                    set incr_col [ expr [ expr $n_col - 1] / $max_v]
                }
            }

            set xi $margen_w
            set xo [ expr $xi + 16.0]
            set yi $margen_h
            if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
                     $que_res == "ISO_SURFACES" || $que_res == "CONTOUR_RANGES"} {
                set yo [ expr $yi + $npix]
            } else {
                set yo $yi
            }

            if { $que_res != "CONTOUR_RANGES" } {
                set alto_linea [ font metrics FixedFont -linespace]
                set num_lin [ expr round( $max_v / $alto_linea)]
            } else {
                set num_lin $n_info
            }
            if { $num_lin < 1.0} { set num_lin 1.0}
            #ajustamos parametros entradas de texto
            set incr_idx_txt 1.0
            set values_format [ GiD_Set Legend(Format)]
            if { $values_format == ""} {
                set values_format %.5g
            }
            if { $n_info > [ expr $num_lin + 1]} {
                if { $num_lin < 2.0} { set num_lin 2.0}
                set incr_idx_txt [ expr ( $n_info - 1.0) / ( $num_lin - 1.0)]
                set n_txt [ expr $num_lin - 1]
                set tmp ""
                lappend tmp [ format $values_format [ lindex $entradas 0]]
                set div [ expr ( [ lindex $entradas [ expr $n_info - 1]] - [ lindex $entradas 0]) / ( $num_lin - 1.0)]
                for { set i 1} { $i < $n_txt} { incr i} {
                    lappend tmp [ format $values_format [ expr [ lindex $tmp [ expr $i - 1]] + $div]]
                }
                lappend tmp [ format $values_format [ lindex $entradas [ expr $n_info - 1]]]
                set entradas $tmp
            } else {
                set n_txt [ expr $n_info - 1]
                if { $que_res != "CONTOUR_RANGES" } {
                    set tmp ""
                    for { set i 0} { $i <= $n_txt} { incr i} {
                        lappend tmp [ format $values_format [ lindex $entradas $i]]
                    }
                    set entradas $tmp
                }
            }

            # chapuza para alinear for la izquierda
            set ll 0
            set px 0.0
            foreach i $entradas {
                set il [ string length $i]
                if { $il > $ll} { set ll $il}
                set ix [ font measure FixedFont $i]
                if { $ix > $px} { set px $ix}
            }
            set tmp ""
            foreach i $entradas {
                lappend tmp [ format %-${ll}s $i]
            }
            set entradas $tmp

            if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
                     $que_res == "CONTOUR_LINES" || $que_res == "SMOOTH_CONTOUR_LINES" || \
                     $que_res == "VECTORS" } {
                set ntpix [ expr $max_v / $n_txt]
            } else {
                set ntpix [ expr $max_v / ( $n_txt + 1.0)]
            }
            set txi_linea $xo
            set txo_linea [ expr $txi_linea + 4.0]
            # fallo del canvas, el texto lo alinea centrado, ponga lo que se ponga
            #set txi_texto [ expr $txo_linea + 4.0]
            #set txi_texto [ expr ( $PLegendPriv(CanvasWidth) - $txo_linea) / 3.0 + $txo_linea]
            set txi_texto [ expr $txo_linea + 2.0 + $px / 2.0]
            set tyi_linea $yi
            set tyo_linea $yi
            # como es centered, no hace falta esto:
            #set tyi_texto [ expr $yi + 3.0]
            if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
                     $que_res == "CONTOUR_LINES" || $que_res == "SMOOTH_CONTOUR_LINES" || \
                     $que_res == "VECTORS" } {
                set tyi_texto $yi
            } else {
                set tyi_texto [ expr $yi + $ntpix * 0.5]
            }


            set x_sep [ expr $PLegendPriv(CanvasWidth) / 3.0]
            $cv create line [ expr round( $x_sep)] 1 [ expr round( $x_sep + $x_sep)] 1 -fill black
            if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" || \
                     $que_res == "CONTOUR_RANGES" || $que_res == "ISO_SURFACES"} {
                for { set i 1.0} { [ expr round( $i)] <= $n_col} { set i [ expr $i + $incr_col]} {
                    $cv create rectangle [ expr round( $xi)] [ expr $PLegendPriv(CanvasHeight) - round( $yi)] \
                            [ expr round( $xo)] [ expr $PLegendPriv(CanvasHeight) - round( $yo)] \
                            -fill [ lindex $lst_colores [ expr round( $i)]] -outline ""
                    set yi [ expr $yi + $npix]
                    set yo [ expr $yo + $npix]
                }
            } else {
                for { set i 1.0} { [ expr round( $i)] <= $n_col} { set i [ expr $i + $incr_col]} {
                    $cv create line [ expr round( $xi)] [ expr $PLegendPriv(CanvasHeight) - round( $yi)] \
                            [ expr round( $xo)] [ expr $PLegendPriv(CanvasHeight) - round( $yo)] \
                            -fill [ lindex $lst_colores [ expr round( $i)]]
                    set yi [ expr $yi + $npix]
                    set yo [ expr $yo + $npix]
                }
            }

            #set itexto 0.0
            for { set i 0} { $i <= $n_txt} { incr i} {
                #WarnWin "$i - $itexto - $n_txt"
                if { $que_res == "CONTOUR_FILL" || $que_res == "SMOOTH_CONTOUR_FILL" } {
                    $cv create line [ expr round( $txi_linea)] \
                            [ expr $PLegendPriv(CanvasHeight) - round( $tyi_linea)] \
                            [ expr round( $txo_linea)] \
                            [ expr $PLegendPriv(CanvasHeight) - round( $tyo_linea)] -fill black
                }
                $cv create text [ expr round( $txi_texto)] \
                        [ expr $PLegendPriv(CanvasHeight) - round( $tyi_texto)] \
                        -fill black -text [ lindex $entradas $i] -font FixedFont
                #[ lindex $entradas [ expr round( $itexto)]]
                set tyi_linea [ expr $tyi_linea + $ntpix]
                set tyo_linea [ expr $tyo_linea + $ntpix]
                set tyi_texto [ expr $tyi_texto + $ntpix]
                #set itexto [ expr $itexto + $incr_idx_txt]
            }
        }
    } else {
        # no es contour_fill ni contour_lines ni iso_surfaces
        if { $que_res == "LOCAL_AXES" } {
            set label_txt [ lindex $lst_info 1]
            $PLegendPriv(CanvasLabel) configure -text $label_txt

            if { ![ info exists PLegendPriv(ImagenEjesLocales)]} {
                set PLegendPriv(ImagenEjesLocales) [ gid_themes::GetImage localaxes.png]
            }

            $cv create image [ expr $PLegendPriv(CanvasWidth) / 2] [ expr $PLegendPriv(CanvasHeight) / 2]\
                    -anchor center -image $PLegendPriv(ImagenEjesLocales)
        }
    }

}

proc PostLegendResizeCanvas { width height } {
    global GIDDEFAULT PLegendPriv GidPriv

    set PLegendPriv(CanvasWidth) [ expr $width - 10]
    set PLegendPriv(CanvasHeight) [ expr $height - 10 - [ winfo reqheight $PLegendPriv(CanvasLabel)] - 4]
    $PLegendPriv(Canvas) configure -width $PLegendPriv(CanvasWidth) -height $PLegendPriv(CanvasHeight)

    FillPostLegendInfo
}

proc ExistPostLegend { } {
    global PLegendPriv
    set ret 0
    if { [ info exists PLegendPriv(window)] && [ winfo exists $PLegendPriv(window)]} {
        set ret 1
    } else {
        set ret 0
    }
    return $ret
}

proc DestroyPostLegend { } {
    global PLegendPriv
    if { [ExistPostLegend] } {
        destroy $PLegendPriv(window)
    }
}

proc PostLegendInside { w } {
    destroy $w
    GiD_Set Legend(DrawOutside) 0
    GiD_Redraw
}

proc PostLegend { { w .gid.wPostLegend } } {
    global GIDDEFAULT PLegendPriv

    set PLegendPriv(window) $w

    InitWindow2 $w -title [_ "Legend"] \
        -geometryvariable PostLegendWindowGeom -initcommand PostLegend \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    wm minsize $w 160 110

    ttk::frame $w.f1 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f1.l

    canvas $w.f1.c -width 128 -height 200
    set PLegendPriv(CanvasWidth) 128
    set PLegendPriv(CanvasHeight) 200
    grid $w.f1.l -sticky ew -padx 4 -pady 2
    grid $w.f1.c -sticky news -padx 2 -pady 2
    set PLegendPriv(Canvas) $w.f1.c
    set PLegendPriv(CanvasLabel) $w.f1.l

    ttk::frame $w.but -style BottomFrame.TFrame
    # button $w.but.accept -text [_ "Accept"] -borderwidth 1 -command PostPointAccept
    # button $w.but.original -text [_ "Original"] -borderwidth 1 -command PostPointOriginal
    ttk::button $w.but.inside -text [_ "Inside"] -style BottomFrame.TButton -command [list PostLegendInside $w]
    ttk::button $w.but.close -text [_ "Close"] -style BottomFrame.TButton -command [list destroy $w]

    # grid $w.but.accept -padx 4 -pady 2 -sticky ew
    # grid $w.but.original -padx 4 -pady 2 -sticky ew
    grid $w.but.inside $w.but.close -padx 4 -pady 2 -sticky ew

    grid $w.f1 -sticky nsew -padx 3 -pady 3
    grid $w.but -sticky nsew -padx 3 -pady 3
    grid anchor $w.but center
    
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    update
    set width [ winfo reqwidth $w.f1]
    set height [ winfo reqheight $w.f1]
    set PLegendPriv(CanvasWidth) [ expr $width - 10]
    set PLegendPriv(CanvasHeight) [ expr $height - 20 - [ winfo reqheight $PLegendPriv(CanvasLabel)] - 4]
    $PLegendPriv(Canvas) configure -width $PLegendPriv(CanvasWidth) -height $PLegendPriv(CanvasHeight)
    update idletasks

    bind $w.f1 <Configure> "PostLegendResizeCanvas %w %h"
    FillPostLegendInfo
}

set ::debugPostEvents 0
proc DebugPostEvents { msg} {
    if { $::debugPostEvents} {
        W $msg
    }
}

proc ::GiDPostResultsMenuRebuild { res_view} {
    # mark menus relative to res_view as to be rebuilt
    foreach submenu [ array names ::GiDPostResultsMenu Menu,$res_view,*] {
        set ::GiDPostResultsMenu($submenu) rebuild
        DebugPostEvents "rebuild $submenu"
    }
    # if res_view is Smooth_(...) two menus are to be updated:
    # base Contour_Fill + submenu Smooth_CF and menu Smooth_CF
    if { [ regsub {Smooth_} $res_view {} base_menu] == 1} {
        foreach submenu [ array names ::GiDPostResultsMenu Menu,$base_menu,*] {
            set ::GiDPostResultsMenu($submenu) rebuild
            DebugPostEvents "rebuild $submenu"
        }
    }
    # if it exists Smooth_$res_view the sub menu should be updated too
    foreach submenu [ array names ::GiDPostResultsMenu Menu,Smooth_$res_view,*] {
        set ::GiDPostResultsMenu($submenu) rebuild
        DebugPostEvents "rebuild $submenu"
    }
}

proc ::GiDPostResultsMenuChange { new_res_view} {
    if { [ info exists ::GiDPostResultsMenu(OldView)] } {
        # rebuild previous res_view menu: to get rid of the check image
        DebugPostEvents "rebuild old"
        ::GiDPostResultsMenuRebuild $::GiDPostResultsMenu(OldView)
    }

    # rebuild new res_view menu: to show the check image
    DebugPostEvents "rebuild new"
    ::GiDPostResultsMenuRebuild $new_res_view
    set ::GiDPostResultsMenu(OldView) $new_res_view
}

proc ::GiDPostResultsMenuChangeAll {} {
    foreach submenu [ array names ::GiDPostResultsMenu Menu,*] {
        set ::GiDPostResultsMenu($submenu) rebuild
    }
    DebugPostEvents "rebuild all"
}

proc ::GiDPostprocessUpdate { type args} {
    DebugPostEvents "::GiDPostprocessUpdate got '$type' $args"
    if { [GiD_Project set disable_windows]} {
        return
    }
    switch $type {
        "InitEvent" {
            ::GiDPostResultsMenuChangeAll
            PostAnimateGetResultVisualizationState
        }
        "FileEvent" {
            ::GiDPostResultsMenuChangeAll
            PostAnimateGetResultVisualizationState
        }
        "LoadSelectionEvent" {
            # update select & display style window
            # on multiple meshes, they may change between time-steps...
            FillPDInfo
            ::GiDPostResultsMenuChangeAll
            PostAnimateGetResultVisualizationState
        }
        "ResultViewEvent" {
            # result visualization type: Contour_Fill, ... No_Result, ...
            set res_view [ lindex $args 0]
            ::GiDPostResultsMenuChange $res_view
            # called from inside the 'c' code
            # PostAnimateGetResultVisualizationState
        }
        "ResultDeformationEvent" {
            set res_view "Deformation"
            ::GiDPostResultsMenuChange $res_view
            # called from inside the 'c' code
            # PostAnimateGetResultVisualizationState
        }
        default {
            DebugPostEvents "::GiDPostprocessUpdate UNKNOWN event '$type'"
        }
    }
}

# Fill view
proc ::PostFillView_ApplyResultFillView { result component surface_value fill_side} {
    if { ( $result == "") || ( $component == "")} {
        return
    }
    # GidUtils::DisableGraphics
    GiD_Process Mescape Results IsoSurfaces DisplayStyle Monochrome
    GiD_Process Mescape Results IsoSurfaces DisplayStyle ChangeMonoColour $::PostFillView(IsoColor)
    GiD_Process Mescape Results IsoSurfaces Exact $result $component 1 $surface_value
    GiD_Process Mescape Results ContOptions NumberOfColor 1
    GiD_Process Mescape Results ContourFill $result $component
    if { $fill_side == "Max"} {
        GiD_Process Mescape Results ContOptions SetMaxOptions OutMaxColor Material escape
        GiD_Process Mescape Results ContOptions SetMinOptions OutMinColor Transparent escape
    } else {
        GiD_Process Mescape Results ContOptions SetMaxOptions OutMaxColor Transparent escape
        GiD_Process Mescape Results ContOptions SetMinOptions OutMinColor Material escape
    }
    GiD_Process Mescape Results ContOptions SetMaxOptions SetValue $surface_value escape
    GiD_Process Mescape Results ContOptions SetMinOptions SetValue $surface_value escape
    # GidUtils::EnableGraphics
    GiD_Process Mescape Utilities Redisplay escape escape
}

proc ::PostFillView_SelectResult { w_tree nodo} {
    if { $nodo == ""} { return}
    set datos [ $w_tree itemcget $nodo -data]
    if { $::PRDebugTree} {
        WarnWinText "$nodo - [ $w_tree itemcget $nodo -data]"
    }
    if { [lindex $datos 0] == "hoja"} {
        set res_name [ lindex $datos 1]
        set res_comp [ lindex $datos 2]
        $w_tree selection set $nodo
        set ::PostFillView(PostResultsRes) $res_name
        set ::PostFillView(PostResultsComp) $res_comp
    } else {
        if { [ $w_tree itemcget $nodo -open] } {
            $w_tree closetree $nodo
        } else {
            for { set p $nodo} { $p != "root"} { set p [ $w_tree parent $p]} {
                $w_tree opentree $p
            }
        }
    }
    $w_tree see $nodo
}


proc ::PostFillView_ShowResult { w_tree res_name res_comp} {
    if { ![ winfo exists $w_tree] || ( $res_name == "") || ( $res_comp == "")} {
        return
    }
    set nodo "$res_name->$res_comp"
    regsub -all { } $nodo {_} nodo
    set nodo [PRToNode $nodo]
    if { $::PRDebugTree} {
        WarnWinText "     1:arbol selection set $nodo"
    }
    set err [ catch {
        $w_tree selection set $nodo
    } errTxt ]
    if { !$err} {
        for { set p $nodo} { $p != "root"} { set p [ $w_tree parent $p]} {
            if { $::PRDebugTree} {
                WarnWinText "     1:arbol opentree $p"
            }
            $w_tree opentree $p
        }
    } else {
        if { $::PRDebug} {
            WarnWinText "ERROR ( $w_tree selection set $nodo) \n\t--> $errTxt"
        }
    }
    focus $w_tree
}


# for exaple for mould filling visualization
proc ::PostFillView_window { { w .gid.wPostFillView}} {
    if { [ winfo exists $w]} {
        destroy $w
    }
    toplevel $w
    wm title $w [_ "Result Fill view"]
    # {W "$::PostFillView(PostResultsRes)//$::PostFillView(PostResultsComp) @ $::PostFillView(fill_value) + $::PostFillView(fill_side)"}
    CreateApplyCloseDecorationWindow $w $w.top $w.bot \
        {::PostFillView_ApplyResultFillView $::PostFillView(PostResultsRes) $::PostFillView(PostResultsComp) \
             $::PostFillView(fill_value) $::PostFillView(fill_side)} \
        "destroy $w"
    
    text $w.top.text -height 4 -width 50 -wrap word \
        -borderwidth 1 -relief sunken -background [ $w cget -background]
    $w.top.text insert end \
        [_ "Result Fill view combines the visualization of\
                 an iso-surface and the contour fill of a result\
                 to create a volume filling result view, like\
                 the water with a free surface visualization or\
                 material flowing inside a mould."]
    $w.top.text configure -state disabled
    ttk::label $w.top.l1 -justify left -text [_ "Select a result for the Fill view"]:
    # results tree:
    set f_tree [ ScrolledWindow $w.top.fres_tree -relief sunken -borderwidth 1 -auto both]
    set w_tree [ Tree $f_tree.tree -relief flat -borderwidth 0 \
                     -highlightthickness 0 -selectbackground "darkblue" \
                     -selectforeground yellow \
                     -highlightbackground yellow -width 30 -redraw 1]
    
    $w_tree bindImage <${::acceleratorKey}-1> {}
    $w_tree bindText <${::acceleratorKey}-1> {}
    # $w_tree bindText <Double-Button-1> PRDoApply
    $w_tree bindImage <1> "focus $w_tree; ::PostFillView_SelectResult $w_tree"
    $w_tree bindText <1> "focus $w_tree; ::PostFillView_SelectResult $w_tree"
    $f_tree setwidget $w_tree

    # get information to fill widgets
    set all_results [ GiD_Info postprocess get cur_results_list "Iso_Surfaces" ]
    set all_results [ lsort -dictionary $all_results]
    if { $all_results != "" } {
        set current_analysis [ GiD_Info postprocess get cur_analysis]
        set current_step [ GiD_Info postprocess get cur_step $current_analysis]
        # PRConstruyeArbol is in PostResults.tcl
        ::PRConstruyeArbol $w_tree $all_results "Iso_Surfaces" $current_analysis $current_step
        set current_result [ GiD_Info postprocess get cur_result]
        if { $current_result == "" || [lsearch $all_results $current_result] == -1 } {
            set current_result [lindex $all_results 0] 
        }
        set current_component [ GiD_Info postprocess get cur_component]
        if { $current_component == ""} {
            set all_comp [ GiD_Info postprocess get cur_components_list $current_result]
            set current_component [lindex $all_comp 0] 
        }
        if { ![ info exists ::PostFillView(PostResultsRes)]} {
            set ::PostFillView(PostResultsRes) $current_result
        }
        if { ![ info exists ::PostFillView(PostResultsComp)]} {
            set ::PostFillView(PostResultsComp) $current_result
        }
        ::PostFillView_ShowResult $w_tree $::PostFillView(PostResultsRes) $::PostFillView(PostResultsComp)
    } else {
        set ::PostFillView(PostResultsRes) ""
        set ::PostFillView(PostResultsComp) ""
        PRArbolNoResultado $w_tree "Iso_Surfaces"
    }
    
    # frontier frame
    ttk::frame $w.top.f_fill_threshold
    ttk::label $w.top.f_fill_threshold.label1 -text [_ "Fill limit value"]:
    ttk::entry $w.top.f_fill_threshold.entry -width 10 -textvariable ::PostFillView(fill_value)
    ttk::label $w.top.f_fill_threshold.label2 -text [_ "Fill side"]:
    ttk::radiobutton $w.top.f_fill_threshold.radio1 -text [_ "below value"] -variable ::PostFillView(fill_side) -value Min
    ttk::radiobutton $w.top.f_fill_threshold.radio2 -text [_ "above value"] -variable ::PostFillView(fill_side) -value Max

    # Isosurface color = #rrggbbaa
    set ::PostFillView(IsoColor) [ lindex [ GiD_Info postprocess get isosurface_options] 10]
    set but_color [ string range $::PostFillView(IsoColor) 0 6]
    set w_col_but $w.top.f_fill_threshold.col_but

    BotonPlano $w_col_but "   " [ list CreateWidgetsFromXml::selectEntityColor $w_col_but ::PostFillView(IsoColor)] \
        $but_color [ CCColorActivo $but_color]
    $w_col_but configure -width 3 
    if { $::tcl_platform(platform) == "windows"} {
        $w_col_but configure -borderwidth 1 -relief solid
    }

    grid $w.top.f_fill_threshold.label1 -sticky e \
        -padx 2 -pady 1
    grid $w.top.f_fill_threshold.entry -row 0 -column 1 -columnspan 2 -sticky ew \
        -padx 2 -pady 1
    grid $w.top.f_fill_threshold.label2 $w.top.f_fill_threshold.radio1 $w.top.f_fill_threshold.radio2 -sticky w \
        -padx 2 -pady 1
    grid configure $w.top.f_fill_threshold.label2 -sticky e \
        -padx 2 -pady 1
    grid $w_col_but -row 0 -column 3 -rowspan 2 -sticky news -padx 4 -pady 4
    grid columnconfigure $w.top.f_fill_threshold 1 -weight 1
    grid columnconfigure $w.top.f_fill_threshold 2 -weight 1
    grid columnconfigure $w.top.f_fill_threshold 3 -weight 1
    grid rowconfigure $w.top.f_fill_threshold 0 -weight 1
    grid rowconfigure $w.top.f_fill_threshold 1 -weight 1
    
    ttk::frame $w.top.f_finish
    label $w.top.f_finish.l2 -justify left \
        -text [_ "Remember to do \nUtilities-->Preferences-->Postprocess->Contour fill and lines-->Default values \nwhen you are finished with this visualization."]
    ttk::button $w.top.f_finish.breset -text [_ "Reset \noptions"] -command PostContourResetAll
    grid $w.top.f_finish.l2 $w.top.f_finish.breset -padx 2 -pady 1 -sticky ew
    grid columnconfigure $w.top.f_finish 0 -weight 1
    grid columnconfigure $w.top.f_finish 1 -weight 1
    grid rowconfigure $w.top.f_finish 0 -weight 1

    if { ![ info exists ::PostFillView(fill_value)]} {
        set ::PostFillView(fill_value) 0.5
    }
    if { ![ info exists ::PostFillView(fill_side)]} {
        set ::PostFillView(fill_side) Max
    }

    grid $w.top.text -sticky wens -padx 2 -pady 1
    grid $w.top.l1 -sticky w -padx 2 -pady 1
    grid $f_tree -sticky news -padx 2 -pady 1
    grid $w.top.f_fill_threshold -sticky ew -padx 2 -pady 1
    grid $w.top.f_finish -sticky w -padx 2 -pady 1
    grid columnconfigure $w.top 0 -weight 1
    grid rowconfigure $w.top 0 -weight 1
    grid rowconfigure $w.top 2 -weight 1
    grid rowconfigure $w.top 3 -weight 1
}

proc PostFillView {} {
    # for exaple for mould filling visualization
    ::PostFillView_window
}


