
#---------------------------------------------------------------
# Point Size Options
#---------------------------------------------------------------

proc FillPostPointOptionsWInfo { { primera_vez 0}} {
    global PPointPriv GidPriv

    if { ![ info exists PPointPriv(AvoidUpdate)]} {
	set PPointPriv(AvoidUpdate) 0
    }
    if { ![ info exists PPointPriv(DoingAccept)]} {
	set PPointPriv(DoingAccept) 0
    }

    if { $PPointPriv(AvoidUpdate) } { return }

    if { $PPointPriv(DoingAccept) } { return }

    if { ![ info exists GidPriv(PostPointOptionsWindow)] || ![winfo exists $GidPriv(PostPointOptionsWindow)]} {
	set w ""
	return
    } else {
	set w $GidPriv(PostPointOptionsWindow)
    }

    set info [ GiD_Info postprocess get info_point_size]
   
    if { $w != "" } {
	UpDownEntryConf $w.f1.fe -state normal
    }


    set PPointPriv(Value) [ lindex $info 0]
    set opciones [ lindex $info 1]
    # quick options are limited by OpenGL, for instance minSize == 1.0f mostly
    set PPointPriv(MinQuick) [ lindex $opciones 0]
    set PPointPriv(MaxQuick) [ lindex $opciones 1]
    set PPointPriv(StepQuick) [ lindex $opciones 2]
    set PPointPriv(DefaultValue) [ lindex $opciones 3]

    # internal texture size options like the nice options, as they are not fixed by opengl
    set opciones [ lindex $info 2]
    set PPointPriv(MinInternalTexture) [ lindex $opciones 0]
    set PPointPriv(MaxInternalTexture) [ lindex $opciones 1]
    set PPointPriv(StepInternalTexture) [ lindex $opciones 2]
    set PPointPriv(MinNice) [ lindex $opciones 0]
    set PPointPriv(MaxNice) [ lindex $opciones 1]
    set PPointPriv(StepNice) [ lindex $opciones 2]

    set opciones [ lindex $info 3]
    set PPointPriv(Detail) [ lindex $opciones 0]
    set PPointPriv(DefaultDetail) [ lindex $opciones 1]

    set PPointPriv(NiceValue) [ lindex $info 4]
    set opciones [ lindex $info 5]
    set PPointPriv(MinDetail) [ lindex $opciones 0]
    set PPointPriv(MaxDetail) [ lindex $opciones 1]
    set PPointPriv(StepDetail) [ lindex $opciones 2]
    set PPointPriv(DefaultNiceValue) [ lindex $opciones 3]

    set PPointPriv(MinTexture) $PPointPriv(MinNice)
    set PPointPriv(MaxTexture) $PPointPriv(MaxNice)
    set PPointPriv(StepTexture) $PPointPriv(StepNice)

    if { $primera_vez} {
	set PPointPriv(OldValue) $PPointPriv(Value)
	set PPointPriv(OldDetail) $PPointPriv(Detail)
    }
    set PPointPriv(AccValue) $PPointPriv(Value)
    set PPointPriv(AccDetail) $PPointPriv(Detail)
    if { $primera_vez} {
	set PPointPriv(OldNiceValue) $PPointPriv(NiceValue)
    }
    set PPointPriv(AccNiceValue) $PPointPriv(NiceValue)

    set WhichValues [ lindex $info 6]

    set PPointPriv(WhichSize) [ lindex $WhichValues 0]
    if { $PPointPriv(WhichSize) == "Variable"} {
	set PPointPriv(SelectedResult) [ list [ lindex $WhichValues 1] [ lindex $WhichValues 2] [ lindex $WhichValues 3] [ lindex $WhichValues 4]]
	set PPointPriv(ResultFactor) [ lindex $WhichValues 5]
    } else {
	set PPointPriv(SelectedResult) ""
	set PPointPriv(ResultFactor) 1.0
    }

    if { $primera_vez} {
	set PPointPriv(OldWhichSize) $PPointPriv(WhichSize)
	set PPointPriv(OldSelectedResult) $PPointPriv(SelectedResult)
	set PPointPriv(OldResultFactor) $PPointPriv(ResultFactor)
    }
    set PPointPriv(AccWhichSize) $PPointPriv(WhichSize)
    set PPointPriv(AccSelectedResult) $PPointPriv(SelectedResult)
    set PPointPriv(AccResultFactor) $PPointPriv(ResultFactor)



    set TextureValues [ lindex $info 7]

    set PPointPriv(NumTextures) [ lindex $TextureValues 0]
    set PPointPriv(MinTextures) [ lindex $TextureValues 1]
    set PPointPriv(MaxTextures) [ lindex $TextureValues 2]
    set PPointPriv(TexturesLst) [ lindex $TextureValues 3]

    if { $primera_vez} {
	set PPointPriv(OldNumTextures) $PPointPriv(NumTextures)
	set PPointPriv(OldTexturesLst) $PPointPriv(TexturesLst)
    }
    set PPointPriv(AccNumTextures) $PPointPriv(NumTextures)
    set PPointPriv(AccTexturesLst) $PPointPriv(TexturesLst)

    #$w.f1.s configure -from $PPointPriv(Min$PPointPriv(Detail)) -to $PPointPriv(Max$PPointPriv(Detail)) -resolution $PPointPriv(Step$PPointPriv(Detail))
    #$w.f1.s set $PPointPriv(Value)

    #$w.f2.s configure -from $PPointPriv(MinDetail) -to $PPointPriv(MaxDetail) -resolution $PPointPriv(StepDetail)
    #$w.f2.s set $PPointPriv(NiceValue)
    # para (des)habilitar la barrita del 'nice level'

#     set PerspPriv(DoIt) 0
#     if { $perspmode == "PERSPECTIVE" } {
#           set PerspPriv(DoIt) 1
#     }
#     if { $perspmode == "NORMAL" } {
#           set PerspPriv(DoIt) 0
#           $w.f1.s configure -state disabled
#           $w.f1.e configure -state disabled
#     }
#
    if { "$w" != "" } {
	EnableDisablePointDetailOptions
	EnableDisablePointSizeOptions
    }

}

proc PostPointAccept { } {
    global PPointPriv

    set PPointPriv(DoingAccept) 1

    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1
	
    switch $PPointPriv(Detail) {
	"Quick" {
	    if { $PPointPriv(Detail) != $PPointPriv(AccDetail)} {
		GiD_Process Mescape Results Options PointDetail $PPointPriv(Detail)
	    }
	}
	"InternalTexture" {
	    if { $PPointPriv(Detail) != $PPointPriv(AccDetail)} {
		GiD_Process Mescape Results Options PointDetail $PPointPriv(Detail)
	    }
	}
	"Nice" {
	    ##if { $PPointPriv(NiceValue) != $PPointPriv(AccNiceValue) }
	    if { ( $PPointPriv(Detail) != $PPointPriv(AccDetail)) || ( $PPointPriv(NiceValue) != $PPointPriv(AccNiceValue))} {
		GiD_Process Mescape Results Options PointDetail $PPointPriv(Detail) $PPointPriv(NiceValue)
		set PPointPriv(AccNiceValue) $PPointPriv(NiceValue)
	    }
	}
	"Texture" {
	    # if { ( $PPointPriv(Detail) != $PPointPriv(AccDetail)) || ( $PPointPriv(TextureValue) != $PPointPriv(AccTextureValue))} {
	    #           GiD_Process Mescape Results Options PointDetail $PPointPriv(Detail) 1 $PPointPriv(TextureValue)
	    # }
	    # set PPointPriv(AccTextureValue) $PPointPriv(TextureValue)
	    if { ( $PPointPriv(AccNumTextures) != $PPointPriv(NumTextures)) || ( $PPointPriv(AccTexturesLst) != $PPointPriv(TexturesLst))} {
		if { $PPointPriv(NumTextures) && ( [ llength $PPointPriv(TexturesLst)] == $PPointPriv(NumTextures))} {
		    GiD_Process Mescape Results Options PointDetail $PPointPriv(Detail) $PPointPriv(NumTextures) {*}$PPointPriv(TexturesLst)
		    set PPointPriv(AccNumTextures) $PPointPriv(NumTextures)
		    set PPointPriv(AccTexturesLst) $PPointPriv(TexturesLst)
		}
	    }
	}
    }

    set PPointPriv(AccDetail) $PPointPriv(Detail)

    switch $PPointPriv(WhichSize) {
	"Fixed" {
	    if { ( $PPointPriv(WhichSize) != $PPointPriv(AccWhichSize)) || ( $PPointPriv(Value) != $PPointPriv(AccValue))} {
		GiD_Process Mescape Results Options PointSize fixed $PPointPriv(Value)
		set PPointPriv(AccValue) $PPointPriv(Value)
	    }
	}
	"Variable" {
	    if {  ( $PPointPriv(WhichSize) != $PPointPriv(AccWhichSize)) || \
		    ( $PPointPriv(SelectedResult) != $PPointPriv(AccSelectedResult)) || \
		    ( $PPointPriv(ResultFactor) != $PPointPriv(AccResultFactor)) } {
		if { [ llength $PPointPriv(SelectedResult)] == 4} {
		    GiD_Process Mescape Results Options PointSize Variable \
		            [ lindex $PPointPriv(SelectedResult) 0] [ lindex $PPointPriv(SelectedResult) 1] \
		            [ lindex $PPointPriv(SelectedResult) 2] [ lindex $PPointPriv(SelectedResult) 3] $PPointPriv(ResultFactor)
		    set PPointPriv(AccSelectedResult) $PPointPriv(SelectedResult)
		    set PPointPriv(AccResultFactor) $PPointPriv(ResultFactor)
		}
	    }
	}
    }

    set PPointPriv(AccWhichSize) $PPointPriv(WhichSize)

    GiD_Set AutomaticRedraw $oldAutomaticRedraw

    set PPointPriv(DoingAccept) 0

    set old $PPointPriv(DynamicUpdate)
    set PPointPriv(DynamicUpdate) 0
    # FillPostPointOptionsWInfo
    set PPointPriv(DynamicUpdate) $old
    GiD_Redraw  
}

proc PostPointOriginal { } {
    global PPointPriv

    set oldAutomaticRedraw [GiD_Set AutomaticRedraw]
    GiD_Set AutomaticRedraw -1

    GiD_Process Mescape Results Options PointDetail $PPointPriv(DefaultDetail) $PPointPriv(DefaultNiceValue)
    GiD_Process Mescape Results Options PointSize fixed $PPointPriv(DefaultValue)

    GiD_Set AutomaticRedraw $oldAutomaticRedraw
    GiD_Redraw
    set old $PPointPriv(DynamicUpdate)
    set PPointPriv(DynamicUpdate) 0
    FillPostPointOptionsWInfo
    set PPointPriv(DynamicUpdate) $old
}

proc ChangePointSizeScale { name1 name2 op} {
    global PPointPriv GidPriv

    if { $PPointPriv(Value) == $PPointPriv(OldValue)} { return}
    if { "$PPointPriv(Value)" == ""} { return}

    set w $GidPriv(PostPointOptionsWindow)

    set newval $PPointPriv(Value)

    if { ![ IsWord real  $newval $w "no"]} {
	return
    }

    # Check for valid value when using Quick detail, otherwise it will generate an OpenGL error
    if { $PPointPriv(Detail) == "Quick"} {
	set pp [ expr ($newval - $PPointPriv(Min$PPointPriv(Detail))) / $PPointPriv(Step$PPointPriv(Detail))]
	set ppi [ expr int($pp + 0.5)]
	if { [ expr abs( $ppi - $pp)] > 1e-5 } {
	    WarnWin [_ "Value not %1\$s %2\$s correct ( must be between %3\$s and %4\$s in steps of %5\$s)" \
		     $pp $ppi $PPointPriv(Min$PPointPriv(Detail)) \
		     $PPointPriv(Max$PPointPriv(Detail)) $PPointPriv(Step$PPointPriv(Detail))]
	    $w.f1.fe.e sel range 0 end
	    
	    set PPointPriv(Value) $PPointPriv(OldValue)
	    return error
	}
    }

    set PPointPriv(OldValue) $PPointPriv(Value)
    if { $PPointPriv(DynamicUpdate) } { PostPointAccept}
}

proc EnableDisablePointDetailOptions { } {
    global GidPriv PPointPriv

    set w $GidPriv(PostPointOptionsWindow)

    switch $PPointPriv(Detail) {
	"Quick" {
	    $w.f1.rd2 configure -state disabled
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state disabled
	    set PPointPriv(OldWhichSize) $PPointPriv(WhichSize)
	    set PPointPriv(WhichSize) Fixed
	    # texture options
	    UpDownEntryConf $w.f3.e -state disabled
	    $w.f3.seltex configure -state disabled
	}
	"Nice" {
	    $w.f1.rd2 configure -state normal
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state normal
	    set PPointPriv(WhichSize) $PPointPriv(OldWhichSize)
	    # texture options
	    UpDownEntryConf $w.f3.e -state disabled
	    $w.f3.seltex configure -state disabled
	}
	"InternalTexture" {
	    $w.f1.rd2 configure -state normal
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state disabled
	    set PPointPriv(WhichSize) $PPointPriv(OldWhichSize)
	    # texture options
	    UpDownEntryConf $w.f3.e -state disabled
	    $w.f3.seltex configure -state disabled
	}
	"Texture" {
	    $w.f1.rd2 configure -state disabled
	    # nice detail level
	    UpDownEntryConf $w.f2.s -state disabled
	    set PPointPriv(OldWhichSize) $PPointPriv(WhichSize)
	    set PPointPriv(WhichSize) Fixed
	    # texture options
	    UpDownEntryConf $w.f3.e -state normal
	    $w.f3.seltex configure -state normal
	}
    }
}

proc ChangePointDetail { n1 n2 op} {
    global GidPriv PPointPriv

    if { $PPointPriv(Detail) == $PPointPriv(OldDetail)} { return}

    set PPointPriv(OldDetail) $PPointPriv(Detail)

    if { $PPointPriv(Value) < $PPointPriv(Min$PPointPriv(Detail))} {
	set PPointPriv(Value) $PPointPriv(Min$PPointPriv(Detail))
    }

    if { $PPointPriv(Value) > $PPointPriv(Max$PPointPriv(Detail))} {
	set PPointPriv(Value) $PPointPriv(Max$PPointPriv(Detail))
    }

    set w $GidPriv(PostPointOptionsWindow)

    #$w.f1.s configure -from $PPointPriv(Min$PPointPriv(Detail)) -to $PPointPriv(Max$PPointPriv(Detail)) -resolution $PPointPriv(Step$PPointPriv(Detail))
    #$w.f1.s set $PPointPriv(Value)

    if { "$PPointPriv(Detail)" == "Texture"} {
	if { $PPointPriv(NumTextures) < $PPointPriv(MinTextures)} {
	    set PPointPriv(NumTextures) $PPointPriv(MinTextures)
	}
	if { $PPointPriv(NumTextures) > $PPointPriv(MaxTextures)} {
	    set PPointPriv(NumTextures) $PPointPriv(MaxTextures)
	}
    }

    if { ( "$PPointPriv(Detail)" != "Texture") || \
	    ( $PPointPriv(NumTextures) && ( [ llength $PPointPriv(TexturesLst)] == $PPointPriv(NumTextures)))} {
	if { $PPointPriv(DynamicUpdate)} { PostPointAccept}
    }

    EnableDisablePointDetailOptions
}

proc EnableDisablePointSizeOptions { } {
    global GidPriv PPointPriv

    set w $GidPriv(PostPointOptionsWindow)

    if { $PPointPriv(WhichSize) == "Fixed"} {
	UpDownEntryConf $w.f1.fe -state normal
	$w.f1.selres configure -state disabled	
    } else { # is "Variable"
	UpDownEntryConf $w.f1.fe -state disabled
	$w.f1.selres configure -state normal
    }
}

proc ChangePointWhichSize { n1 n2 op} {
    global GidPriv PPointPriv

    if { $PPointPriv(WhichSize) == $PPointPriv(OldWhichSize)} { return}

    if { $PPointPriv(SelectedResult) == ""} {
	set PPointPriv(SelectedResult) $PPointPriv(OldSelectedResult)
	set PPointPriv(OldSelectedResult) ""
	ChangeSelectedResult PPointPriv OldSelectedResult w
    }

    set PPointPriv(OldWhichSize) $PPointPriv(WhichSize)

    set w $GidPriv(PostPointOptionsWindow)

    if { $PPointPriv(DynamicUpdate) && ( $PPointPriv(SelectedResult) != "")} {
	PostPointAccept
    }

    EnableDisablePointSizeOptions
}

proc ChangePointDetailScale { name1 name2 op} {
    global PPointPriv GidPriv

    if { $PPointPriv(NiceValue) == $PPointPriv(OldNiceValue)} { return}
    if { "$PPointPriv(NiceValue)" == ""} { return}

    set w $GidPriv(PostPointOptionsWindow)

    set newval $PPointPriv(NiceValue)

    if { ( $newval < $PPointPriv(MinDetail)) || ( $newval > $PPointPriv(MaxDetail)) } {
	    WarnWin [_ "Value out of limits ( must be between %1\$s and %2\$s in steps of %3\$s)" \
		    $PPointPriv(MinDetail) $PPointPriv(MaxDetail) $PPointPriv(StepDetail)]
	$w.f1.fe.e sel range 0 end
	set PPointPriv(Value) $PPointPriv(OldValue)
	return error
    }

    set PPointPriv(OldNiceValue) $PPointPriv(NiceValue)
    if { $PPointPriv(DynamicUpdate) } { PostPointAccept}
}

proc PostPointOptionsTextureFile { w varname} {
    upvar $varname destination
    set destination [MessageBoxGetFilename file read [_ "Point texture file"]]
}

proc PostPointOptionsIncrementaTamanno { step } {
    global PPointPriv

    set tmp [ expr $PPointPriv(Value) + $step * $PPointPriv(Step$PPointPriv(Detail))]
    set pp [ expr ($tmp - $PPointPriv(Min$PPointPriv(Detail))) / $PPointPriv(Step$PPointPriv(Detail))]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
	set tmp [ expr double( $ppi) * $PPointPriv(Step$PPointPriv(Detail)) + $PPointPriv(Min$PPointPriv(Detail))]
    }

    if { $tmp > $PPointPriv(Max$PPointPriv(Detail))} {
	set tmp $PPointPriv(Max$PPointPriv(Detail))
	bell
    }

    set PPointPriv(Value) [ format %g $tmp]
}

proc PostPointOptionsDecrementaTamanno { step} {
    global PPointPriv

    set tmp [ expr $PPointPriv(Value) - $step * $PPointPriv(Step$PPointPriv(Detail))]
    set pp [ expr ($tmp - $PPointPriv(Min$PPointPriv(Detail))) / $PPointPriv(Step$PPointPriv(Detail))]
    set ppi [ expr int($pp + 0.5)]
    if { [ expr abs( $ppi - $pp)] > 1e-5 } {
	set tmp [ expr double( $ppi) * $PPointPriv(Step$PPointPriv(Detail)) + $PPointPriv(Min$PPointPriv(Detail))]
    }

    if { $tmp < $PPointPriv(Min$PPointPriv(Detail))} {
	set tmp $PPointPriv(Min$PPointPriv(Detail))
	bell
    }

    set PPointPriv(Value) [ format %g $tmp]
}

proc PostPointOptionsIncrementaBonito { } {
    global PPointPriv

    set tmp [ expr $PPointPriv(NiceValue) + $PPointPriv(StepDetail)]
    if { $tmp > $PPointPriv(MaxDetail)} {
	set tmp $PPointPriv(MaxDetail)
	bell
    }

    set PPointPriv(NiceValue) [ format %g $tmp]
}

proc PostPointOptionsDecrementaBonito { } {
    global PPointPriv

    set tmp [ expr $PPointPriv(NiceValue) - $PPointPriv(StepDetail)]
    if { $tmp < $PPointPriv(MinDetail)} {
	set tmp $PPointPriv(MinDetail)
	bell
    }

    set PPointPriv(NiceValue) [ format %g $tmp]
}

proc PostPointOptionsIncrementaNumTex { } {
    global PPointPriv

    set tmp [ expr $PPointPriv(NumTextures) + 1]
    if { $tmp > $PPointPriv(MaxTextures)} {
	set tmp $PPointPriv(MaxTextures)
	bell
    }

    set PPointPriv(NumTextures) [ format %g $tmp]
}

proc PostPointOptionsDecrementaNumTex { } {
    global PPointPriv

    set tmp [ expr $PPointPriv(NumTextures) - 1]
    if { $tmp < $PPointPriv(MinTextures)} {
	set tmp $PPointPriv(MinTextures)
	bell
    }

    set PPointPriv(NumTextures) [ format %g $tmp]
}


proc PostFillSelecResultComponent { } {
    global GidPriv PostSelecResultComponent
# WarnWinText "PostFillSelecResultComponent"
    set w $GidPriv(PostSelecResultComponentWindow)

    set values [lsort -dictionary [GiD_Info postprocess get all_analysis]]
    set labels {}
    foreach j $values {	
	lappend labels [TranslateResultName $j]
    }
    $w.r.cba configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cba -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 0]
    #no traducir cur2 porque actualmente se usa el mensaje como comando interno!!
    if { $cur == "" } {
	regsub -all {_} [lindex $values 0] { } cur2
    } else {
	regsub -all {_} $cur { } cur2
    }
    set PostSelecResultComponent(Analysis) $cur2
}

proc PostFillChangedAnalysis { } {
    global GidPriv PostSelecResultComponent
    if { $PostSelecResultComponent(Analysis) == "" } {
	return
    }
# WarnWinText "PostFillChangedAnalysis A='$PostSelecResultComponent(Analysis)'"
    set w $GidPriv(PostSelecResultComponentWindow)

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    set values [GiD_Info postprocess get all_steps $analisis]
    set labels $values
    $w.r.cbs configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cbs -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 1]
    if { "$cur" == "" } {
	set cur [ lindex $values 0]
    }
    set PostSelecResultComponent(Step) $cur
}

proc PostFillChangedStep { } {
    global GidPriv PostSelecResultComponent
# WarnWinText "PostFillChangedStep A='$PostSelecResultComponent(Analysis)' S='$PostSelecResultComponent(Step)'"
    if { $PostSelecResultComponent(Analysis) == "" || $PostSelecResultComponent(Step) == "" } {
	return
    }
    set w $GidPriv(PostSelecResultComponentWindow)

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    set values [GiD_Info postprocess get results_list CONTOUR_FILL $analisis $PostSelecResultComponent(Step)]
    set labels {}
    foreach j $values {	
	lappend labels [TranslateResultName $j]
    }
    $w.r.cbr configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cbr -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 2]
    if { $cur == "" } {
	regsub -all {_} [ lindex $values 0] { } cur2
    } else {
	regsub -all {_} $cur { } cur2
    }
    set PostSelecResultComponent(Result) $cur2
}

proc PostFillChangedResult { } {
    global GidPriv PostSelecResultComponent
# WarnWinText "PostFillChangedResult A='$PostSelecResultComponent(Analysis)' R='$PostSelecResultComponent(Result)' S='$PostSelecResultComponent(Step)'"
    if { $PostSelecResultComponent(Analysis) == "" || $PostSelecResultComponent(Result) == "" ||
	 $PostSelecResultComponent(Step) == "" } {
	return
    }

    set w $GidPriv(PostSelecResultComponentWindow)

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    regsub -all { } $PostSelecResultComponent(Result) {_} resultado
    set values [ GiD_Info postprocess get components_list POINT_RADIUS $resultado $analisis $PostSelecResultComponent(Step)]
    set labels {}
    foreach j $values {
	lappend labels [TranslateResultComponentName $j]
    }
    $w.r.cbc configure -labels $labels -values $values
    #TTKComboBoxConfigure $w.r.cbc -labels $labels -values $values

    set cur [ lindex $PostSelecResultComponent(Current) 3]
    if { $cur == "" } {
	regsub -all {_} [ lindex $values 0] { } cur2
    } else {
	regsub -all {_} $cur { } cur2
    }
    set PostSelecResultComponent(Component) $cur2
}

proc DestroyPostSelecResultComponent { W w } {
    if { $W != $w } return
    trace remove variable ::PostSelecResultComponent(Analysis) write "PostFillChangedAnalysis ;#"
    trace remove variable ::PostSelecResultComponent(Step) write "PostFillChangedStep ;#"
    trace remove variable ::PostSelecResultComponent(Result) write "PostFillChangedResult ;#"
}

proc PostSelecResultComponentAccept { w varname} {
    global PostSelecResultComponent
    upvar $varname destination

    regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    regsub -all { } $PostSelecResultComponent(Result) {_} resultado
    regsub -all { } $PostSelecResultComponent(Component) {_} componente
    set destination [ list $analisis \
	    $PostSelecResultComponent(Step) $resultado $componente]

    destroy $w
}

proc PostSelecResultComponent { w varname} {
    global GidPriv PostSelecResultComponent
    upvar $varname destination

    if { [ winfo exists $w] } {
	raise $w
	return
    }
    toplevel $w
    if { $::tcl_platform(platform) == "windows" } {        
	wm attributes $w -toolwindow 1
    }
    set parent_w [winfo toplevel [winfo parent $w]]
    wm transient $w $parent_w
    wm title $w [_ "Select result"]

    set GidPriv(PostSelecResultComponentWindow) $w

    ttk::frame $w.r
    ttk::label $w.r.la -text [_ "Analysis"]
    TTKComboBox $w.r.cba -textvariable ::PostSelecResultComponent(Analysis) -state readonly
    ttk::label $w.r.ls -text [_ "Step"]
    TTKComboBox $w.r.cbs -textvariable ::PostSelecResultComponent(Step) -state readonly
    ttk::label $w.r.lr -text [_ "Result"]
    TTKComboBox $w.r.cbr -textvariable ::PostSelecResultComponent(Result) -state readonly
    ttk::label $w.r.lc -text [_ "Component"]
    TTKComboBox $w.r.cbc -textvariable ::PostSelecResultComponent(Component) -state readonly

    grid $w.r.la $w.r.cba -sticky ew
    grid $w.r.ls $w.r.cbs -sticky ew
    grid $w.r.lr $w.r.cbr -sticky ew
    grid $w.r.lc $w.r.cbc -sticky ew


    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame
   
    ttk::button $w.but.accept -text [_ "Apply"] -command [list PostSelecResultComponentAccept $w $varname] \
	-style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] \
	-style BottomFrame.TButton

    grid $w.but.accept -padx 4 -pady 10 -sticky ew
    grid $w.but.close -row 0 -column 1 -padx 4 -pady 10 -sticky ew

    grid $w.r -sticky news
    grid $w.but -sticky wes
    grid columnconfigure $w.r {0 1} -weight 1
    grid columnconfigure $w 0 -weight 1
    grid rowconfigure $w 0 -weight 1

    grid anchor $w.but center

#     trace add variable ::PostSelecResultComponent(Analysis) write "PostFillChangedAnalysis ;#"
#     trace add variable ::PostSelecResultComponent(Step) write "PostFillChangedStep ;#"
#     trace add variable ::PostSelecResultComponent(Result) write "PostFillChangedResult ;#"

    set PostSelecResultComponent(Current) $destination


    wm withdraw $w
    update idletasks

    set w2 [ expr [ winfo reqwidth $w] / 2]
    set h2 [ expr [ winfo reqheight $w] / 2]
    set x [ expr [ winfo pointerx $parent_w] - $w2]
    set y [ expr [ winfo pointery $parent_w] - $h2]

    # miramos si sale la X
    set off_scr_x [ expr ( $x + $w2 + $w2) - [ winfo screenwidth $w]]
    if { $off_scr_x >= 0} {
	set x [ expr $x - $off_scr_x - 10]
    }
    if { $x < 0} { set x 0}
    # miramos si sale la Y
    set off_scr_y [ expr ( $y + $h2 + $h2) - [ winfo screenheight $w]]
    if { $off_scr_y >= 0} {
	set y [ expr $y - $off_scr_y - 20]
    }
    if { $y < 0} { set y 0}
    wm geometry $w +$x+$y
    wm deiconify $w
   
    bind $w <Return> "$w.but.accept invoke"
    bind $w <Destroy> [list +DestroyPostSelecResultComponent %W $w]

    trace add variable ::PostSelecResultComponent(Analysis) write "PostFillChangedAnalysis ;#"
    trace add variable ::PostSelecResultComponent(Step) write "PostFillChangedStep ;#"
    trace add variable ::PostSelecResultComponent(Result) write "PostFillChangedResult ;#"

    PostFillSelecResultComponent
    #PostFillChangedAnalysis
}

proc ChangeSelectedResult { name1 name2 op } {
    global PPointPriv

    if { $PPointPriv(SelectedResult) == $PPointPriv(OldSelectedResult)} { return}

    if { $PPointPriv(SelectedResult) != ""} {
	set PPointPriv(OldSelectedResult) $PPointPriv(SelectedResult)
    }

    set wtext $PPointPriv(PostPointOptionsResultTextW)

    if { $wtext != ""} {
	$wtext configure -state normal
	$wtext delete 0.0 end
	if { [llength $PPointPriv(SelectedResult)] == 4} {
	    regsub -all {_} [ lindex $PPointPriv(SelectedResult) 0] { } analisis
	    set step [ lindex $PPointPriv(SelectedResult) 1]
	    regsub -all {_} [ lindex $PPointPriv(SelectedResult) 2] { } resultado
	    regsub -all {_} [ lindex $PPointPriv(SelectedResult) 3] { } componente
	    $wtext insert end "$analisis\n$step\n$resultado\n$componente"
	}
	$wtext configure -state disabled
    }
}

proc PostPointOptionsSelectResult { w { wtext ""}} {
    global PPointPriv

    set PPointPriv(PostPointOptionsResultTextW) $wtext
#    set PPointPriv(SelectedResult) ""
    PostSelecResultComponent $w.sr PPointPriv(SelectedResult)
    tkwait window $w.sr

    # sugiere un factor
    if { [llength $PPointPriv(SelectedResult)] == 4} {
	set analisis [ lindex $PPointPriv(SelectedResult) 0]
	set step [ lindex $PPointPriv(SelectedResult) 1]
	set resultado [ lindex $PPointPriv(SelectedResult) 2]
	set componente [ lindex $PPointPriv(SelectedResult) 3]
	set PPointPriv(ResultFactor) [ GiD_Info postprocess get info_point_size_factor $analisis $step $resultado $componente]

	if { $PPointPriv(DynamicUpdate) } { PostPointAccept}
    }
}


proc PostSelecTexturesClose { w } {
    global PostSelecTextures

    destroy $w
}

proc PostSelecTexturesAccept { w varname} {
    global PostSelecTextures
    upvar $varname destination

    #regsub -all { } $PostSelecResultComponent(Analysis) {_} analisis
    #regsub -all { } $PostSelecResultComponent(Result) {_} resultado
    #regsub -all { } $PostSelecResultComponent(Component) {_} componente
    #set $PostSelecResultComponent(ReturnVariable) [ list $analisis \
    #             $PostSelecResultComponent(Step) $resultado $componente]

    set vacios 0
    for { set it 0 } { $it < $PostSelecTextures(Num)} { incr it} {
	if { "$PostSelecTextures($it)" == ""} {
	    incr vacios
	}
    }
    if { $vacios != 0} {
	if { $vacios == 1} {
	    set msg [_ "Sorry, but there is one entry with no image file."]
	} else {
	    set msg [_ "Sorry, but there is %s entries with no image files." $vacios]
	}
	WarnWin $msg $w
	return
    }

    set destination ""
    for { set it 0 } { $it < $PostSelecTextures(Num)} { incr it} {
	lappend destination $PostSelecTextures($it)
    }

    PostSelecTexturesClose $w
}

proc PostSelecTextures { w num_entries varname } {
    global GidPriv PostSelecTextures
    upvar $varname text_lst

    if { [ winfo exists $w] } {
	raise $w
	return
    }

    toplevel $w
    set parent_w [winfo toplevel [winfo parent $w]]
    wm transient $w $parent_w
    wm withdraw $w

    set GidPriv(PostSelecTexturesWindow) $w
    #set PostSelecTextures(ReturnVariable) $varname

    set c [ CreateScrolledCanvas $w.c]
    $c configure -width 300 -height 200

    set min [ llength $text_lst]
    if { $num_entries < $min} {
	set min $num_entries
    }

    for { set it 0 } { $it < $min} { incr it} {
	set PostSelecTextures($it) [ lindex $text_lst $it]
    }
    for { set it $min} { $it < $num_entries} { incr it} {
	set PostSelecTextures($it) ""
    }

    set PostSelecTextures(Num) $num_entries
    for { set it 0 } { $it < $num_entries} { incr it} {
	ttk::frame $c.t$it -borderwidth 0
	label $c.t$it.l -text [concat [_ "Texture"] "[format %2d [expr $it + 1]]"]:

	ttk::button $c.t$it.b -image [gid_themes::GetImage "folder.png" small_icons] -command "PostPointOptionsTextureFile $w PostSelecTextures($it)"
	ttk::entry $c.t$it.e -textvariable PostSelecTextures($it) -width 50	

	grid $c.t$it.l $c.t$it.b $c.t$it.e -sticky we -padx 0
	grid rowconfigure $c.t$it 0 -weight 1
	grid columnconfigure $c.t$it 0 -weight 1
	
	AddToScrolledCanvas $w.c $c.t$it
    }

    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame   
    ttk::button $w.but.accept -text [_ "Apply"] -command "PostSelecTexturesAccept $w $varname" \
	-style BottomFrame.TButton       
    ttk::button $w.but.close -text [_ "Close"] -command "PostSelecTexturesClose $w" \
	-style BottomFrame.TButton	

    grid $w.but.accept -padx 4 -pady 10 -sticky ew
    grid $w.but.close -row 0 -column 1 -padx 4 -pady 10 -sticky ew

    grid $w.c -sticky news
    grid $w.but -sticky wes
    grid anchor $w.but center

    #wm withdraw $w
    update idletasks

    set w2 [ expr [ winfo reqwidth $w] / 2]
    set h2 [ expr [ winfo reqheight $w] / 2]
    set x [ expr [ winfo pointerx $parent_w] - $w2]
    set y [ expr [ winfo pointery $parent_w] - $h2]

    # miramos si sale la X
    set off_scr_x [ expr ( $x + $w2 + $w2) - [ winfo screenwidth $w]]
    if { $off_scr_x >= 0} {
	set x [ expr $x - $off_scr_x - 10]
    }
    if { $x < 0} { set x 0}
    # miramos si sale la Y
    set off_scr_y [ expr ( $y + $h2 + $h2) - [ winfo screenheight $w]]
    if { $off_scr_y >= 0} {
	set y [ expr $y - $off_scr_y - 20]
    }
    if { $y < 0} { set y 0}

    wm geometry $w +$x+$y
    wm deiconify $w

    bind $w <Escape> "PostSelecTexturesClose $w"
}

proc PostPointOptionsSelectTextures { w} {
    global PPointPriv

    ##set PPointPriv(SelectedResult) ""
    PostSelecTextures $w.st $PPointPriv(NumTextures) PPointPriv(TexturesLst)
    #PPointPriv(SelectedResult)
    tkwait window $w.st

    if { $PPointPriv(DynamicUpdate) } { PostPointAccept}
}

proc DestroyPostPointOptions { W w } {
    if { $W != $w } return
    global PPointPriv
    trace remove variable PPointPriv(Value) write ChangePointSizeScale
    trace remove variable PPointPriv(Detail) write ChangePointDetail
    trace remove variable PPointPriv(NiceValue) write ChangePointDetailScale
    trace remove variable PPointPriv(WhichSize) write ChangePointWhichSize
    trace remove variable PPointPriv(SelectedResult) write ChangeSelectedResult
}

proc PostPointOptions { { w .gid.wPostPointOptions } args } {
    # arsg is needded to discard addtional parameter added by the prferences window
    global PPointPriv

    InitWindow2 $w -title [_ "Point options"] \
        -geometryvariable PostPointOptionsWindowGeom \
        -initcommand PostPointOptions -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    set PPointPriv(DynamicUpdate) 1

    ttk::frame $w.f0
    ttk::radiobutton $w.f0.rd1 -text [_ "Quick"] -value Quick -variable PPointPriv(Detail)
    ttk::radiobutton $w.f0.rd11 -text [_ "Internal texture"] -value InternalTexture -variable PPointPriv(Detail)
    ttk::radiobutton $w.f0.rd2 -text [_ "Nice"] -value Nice -variable PPointPriv(Detail)
    ttk::radiobutton $w.f0.rd3 -text [_ "Texture"] -value Texture -variable PPointPriv(Detail)
    if { ![info exists PPointPriv(DynamicUpdate)] } { set PPointPriv(DynamicUpdate) 0 }
    ttk::checkbutton $w.f0.din -text [_ "Dynamic update"]  -variable PPointPriv(DynamicUpdate)
    grid $w.f0.rd1 $w.f0.rd11 $w.f0.rd2 $w.f0.rd3 -sticky w -padx 1
    grid $w.f0.din -row 0 -column 4 -sticky e -padx 3
    grid rowconfigure $w.f0 0 -weight 1

    ttk::frame $w.f1 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f1.l -text [_ "Point size"]:
    # ttk::checkbutton $w.f1.scb -text [_ "World fixed"] -onvalue World -offvalue Screen \
    # 	-variable ::PPointPriv(SizeType)
    ttk::radiobutton $w.f1.rd1 -text [_ "Size"]: -value Fixed -variable ::PPointPriv(WhichSize)
    ttk::radiobutton $w.f1.rd2 -text [_ "Result's size"]: -value Variable -variable PPointPriv(WhichSize)

    UpDownEntry $w.f1.fe -variable PPointPriv(Value) \
	    -up-command "PostPointOptionsIncrementaTamanno 1" \
	    -down-command "PostPointOptionsDecrementaTamanno 1" \
	    -entry-options "-width 10" \
	    -show-double-buttons  \
	    -up-up-command "PostPointOptionsIncrementaTamanno 5" \
	    -down-down-command "PostPointOptionsDecrementaTamanno 5" \
	    -up-color red -down-color blue\
	    -up-up-color red -down-down-color blue \

    text $w.f1.t -relief sunken -borderwidth 1 -width 15 -height 4 -state disabled
    ttk::button $w.f1.selres -text [_ "Select result"]...  \
	    -command "PostPointOptionsSelectResult $w $w.f1.t"	  
    set PPointPriv(PostPointOptionsResultTextW) $w.f1.t
    ttk::frame $w.f1.ff -borderwidth 0
    ttk::label $w.f1.ff.l -text [_ "factor"]:
    if { ![info exists PPointPriv(ResultFactor)] } { set PPointPriv(ResultFactor) "" }
    ttk::entry $w.f1.ff.factor -textvariable PPointPriv(ResultFactor) -width 10
    set PPointPriv(NormalEntryBackground) [ $w.f1.ff.factor cget -background]
    set PPointPriv(DisabledEntryBackground) [ $w cget -background]
    grid $w.f1.ff.l -sticky es
    grid $w.f1.ff.factor -sticky wes -row 0 -column 1
    grid rowconfigure $w.f1.ff 0 -weight 1
    grid columnconfigure $w.f1.ff 1 -weight 1

    grid $w.f1.l -sticky w -row 0 -column 0

    grid $w.f1.rd1 -sticky w
    grid $w.f1.fe -sticky w -row 1 -column 1
    # grid $w.f1.scb -sticky e -row 1 -column 2
    grid $w.f1.rd2 -sticky wn
    # grid $w.f1.t -sticky nsew -row 2 -column 1 -rowspan 3 -columnspan 2 -padx 4 -pady 2
    grid $w.f1.t -sticky nsew -row 2 -column 1 -rowspan 3 -padx 4 -pady 2
    grid $w.f1.selres -sticky en -row 3 -column 0 -padx 4
    grid $w.f1.ff -sticky wes -row 4 -column 0 -padx 4 -pady 2
    grid rowconfigure $w.f1 2 -weight 1
    grid columnconfigure $w.f1 1 -weight 1
    #grid rowconfigure $w.f1 4 -weight 1
    #grid columnconfigure $w.f1 0 -weight 1

    ttk::frame $w.f2 -style ridge.TFrame -borderwidth 2
    ttk::label $w.f2.l -text [_ "Nice Detail"]:

    UpDownEntry $w.f2.s -variable PPointPriv(NiceValue) \
	    -up-command PostPointOptionsIncrementaBonito \
	    -down-command PostPointOptionsDecrementaBonito \
	    -entry-options "-width 10" \
	    -up-color red -down-color blue\

    grid $w.f2.l -sticky w -padx 2
    grid $w.f2.s -row 0 -column 1 -sticky we -padx 4
    grid rowconfigure $w.f2 0 -weight 1
    grid columnconfigure $w.f2 1 -weight 1

    ttk::frame $w.f3 -style ridge.TFrame -borderwidth 2

    ttk::label $w.f3.l -text [_ "Number of textures"]:

    UpDownEntry $w.f3.e -variable PPointPriv(NumTextures) \
	    -up-command PostPointOptionsIncrementaNumTex \
	    -down-command PostPointOptionsDecrementaNumTex \
	    -entry-options "-width 10" \
	    -up-color red -down-color blue

    ttk::button $w.f3.seltex -text [_ "Pick images >>>"]  \
	    -command "PostPointOptionsSelectTextures $w"	

    grid $w.f3.l -sticky w -padx 2
    grid $w.f3.e -sticky e -padx 4
    grid $w.f3.seltex -sticky se -padx 4 -pady 2
    grid rowconfigure $w.f3 1 -weight 1
    grid rowconfigure $w.f3 2 -weight 1
    grid columnconfigure $w.f3 0 -weight 1


    set def_back [ $w cget -background]
    ttk::frame $w.but -style BottomFrame.TFrame   
    ttk::button $w.but.accept -text [_ "Apply"] -command PostPointAccept \
	-style BottomFrame.TButton
    ttk::button $w.but.original -text [_ "Original"] -command PostPointOriginal \
	-style BottomFrame.TButton
    ttk::button $w.but.close -text [_ "Close"] -command [list destroy $w] \
	-style BottomFrame.TButton	

    grid $w.but.accept -row 0 -column 0 -padx 4 -pady 10 -sticky ew
    grid $w.but.original -row 0 -column 1 -padx 4 -pady 10 -sticky ew
    grid $w.but.close -row 0 -column 2 -padx 4 -pady 10 -sticky ew

    grid $w.f0 -sticky new -columnspan 2 -padx 3 -pady 3
    grid $w.f1 -sticky nsew -rowspan 2 -padx 3 -pady 3
    grid $w.f2 -sticky nsew -row 1 -column 1 -padx 3 -pady 3
    grid $w.f3 -sticky wes -row 2 -column 1 -padx 3 -pady 3
    grid $w.but -sticky nsew -row 3 -column 0 -columnspan 2
    grid anchor $w.but center
    grid columnconfigure $w 0 -weight 1
    grid columnconfigure $w 1 -weight 1
    grid rowconfigure $w 1 -weight 1
    grid rowconfigure $w 2 -weight 1

    set PPointPriv(AvoidUpdate) 0

    set PPointPriv(DoingAccept) 0
    FillPostPointOptionsWInfo 1

    bind $w.f1.ff.factor <Return> PostPointAccept

    trace add variable PPointPriv(Value) write ChangePointSizeScale
    trace add variable PPointPriv(Detail) write ChangePointDetail
    trace add variable PPointPriv(NiceValue) write ChangePointDetailScale
    trace add variable PPointPriv(WhichSize) write ChangePointWhichSize
    trace add variable PPointPriv(SelectedResult) write ChangeSelectedResult

    set pp $PPointPriv(SelectedResult)
    set PPointPriv(SelectedResult) ""
    set PPointPriv(SelectedResult) $pp

    focus $w.but.accept
   
    bind $w <Return> "$w.but.accept invoke"
    bind $w <Destroy> [list +DestroyPostPointOptions %W $w]
}

