proc CustomizeRender { {w .gid.customizerender} } {
    global GIDDEFAULT GidPriv
    global CustomizeRenderPriv

    unset -nocomplain CustomizeRenderPriv

    InitWindow2 $w -title [_ "Customize Render"] \
        -geometryvariable PreCustomizeRenderWindowGeom \
        -initcommand CustomizeRender \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0

    ttk::frame $w.frm1
    ttk::combobox $w.frm1.cb1 -textvariable CustomizeRenderPriv(CustomRenderCurrent) \
	    -values [GiD_Info customrenders] -state readonly
    GidHelp $w.frm1.cb1 [_ "It set the current customized render mode"]
    ttk::button $w.frm1.b1 -image [gid_themes::GetImage check.png small_icons] -command [list NewCustomRender $w.frm1.cb1]
    GidHelp $w.frm1.b1 [_ "It creates a new customized render mode"]
    ttk::button $w.frm1.b2 -image [gid_themes::GetImage rename.png small_icons] -command [list RenameCustomRender $w.frm1.cb1]
    GidHelp $w.frm1.b2 [_ "It changes the customized render name"]
    ttk::button $w.frm1.b3 -image [gid_themes::GetImage delete.png small_icons] -command [list DeleteCustomRender $w.frm1.cb1]
    GidHelp $w.frm1.b3 [_ "It deletes the selected customized render mode."]

    ttk::frame $w.frm2
    ttk::label $w.frm2.l01 -text [_ "Show"]
    ttk::label $w.frm2.l02 -text [_ "Color by"]
    ttk::label $w.frm2.l03 -text [_ "Size"]
    ttk::label $w.frm2.l04 -text [_ "Render"]

    ttk::label $w.frm2.l10 -image [gid_themes::GetImage "point.png" small_icons]
    ttk::label $w.frm2.l20 -image [gid_themes::GetImage "line.png" small_icons]
    ttk::label $w.frm2.l30 -image [gid_themes::GetImage "surface.png" small_icons]
    ttk::label $w.frm2.l40 -image [gid_themes::GetImage "volume.png" small_icons]

    ttk::checkbutton $w.frm2.ck1 -variable CustomizeRenderPriv(Show,Point)
    ttk::checkbutton $w.frm2.ck2 -variable CustomizeRenderPriv(Show,Line)        
    ttk::checkbutton $w.frm2.ck3 -variable CustomizeRenderPriv(Show,Surface)    
    ttk::checkbutton $w.frm2.ck4 -variable CustomizeRenderPriv(Show,Volume)

    ttk::combobox $w.frm2.cb1 -values [list [_ "Layer"] [_ "EntityType"]] -state readonly
    ttk::combobox $w.frm2.cb2 -values [list [_ "Layer"] [_ "EntityType"] [_ "Black"]] -state readonly
    ttk::combobox $w.frm2.cb3 -values [list [_ "Layer"] [_ "EntityType"]] -state readonly
    ttk::combobox $w.frm2.cb4 -values [list [_ "Layer"] [_ "EntityType"]] -state readonly    

    #valid for OpenGL specification of point size and line width  -range "0.5 10 0.5"
    ttk::spinbox $w.frm2.sb1 -values "1 2 3 4 5 6 7 8 9 10" -textvariable CustomizeRenderPriv(Size,Point) -width 4 
    ttk::spinbox $w.frm2.sb2 -values "1 2 3 4 5 6 7 8 9 10" -textvariable CustomizeRenderPriv(Size,Line) -width 4
    ttk::spinbox $w.frm2.sb3 -values "1 2 3 4 5 6 7 8 9 10" -textvariable CustomizeRenderPriv(Size,Surface) -width 4
    ttk::spinbox $w.frm2.sb4 -values "1 2 3 4 5 6 7 8 9 10" -textvariable CustomizeRenderPriv(Size,Volume) -width 4
    
    ttk::frame $w.frm3
    if { ![info exists CustomizeRenderPriv(FillSurface)] } { set CustomizeRenderPriv(FillSurface) 0 }
    ttk::checkbutton $w.frm3.ck1 -variable CustomizeRenderPriv(FillSurface) -text [_ "Fill Surfaces"]
    
    if { ![info exists CustomizeRenderPriv(Lighting)] } { set CustomizeRenderPriv(Lighting) 0 }
    ttk::checkbutton $w.frm3.ck2 -variable CustomizeRenderPriv(Lighting) -text [_ "Lighting"]
    
    if { ![info exists CustomizeRenderPriv(Blend)] } { set CustomizeRenderPriv(Blend) 0 }
    ttk::checkbutton $w.frm3.ck3 -variable CustomizeRenderPriv(Blend) -text [_ "Blend"]

    
    ttk::frame $w.frmButtons -style BottomFrame.TFrame
    ttk::button $w.frmButtons.btnApply -text [_ "Apply"] -command CustomRenderSetTclValues \
	    -underline 0 -style BottomFrame.TButton
    ttk::button $w.frmButtons.btnReset -text [_ "Reset"] -command CustomRenderSetDefaultValues \
	    -underline 0 -style BottomFrame.TButton
    ttk::button $w.frmButtons.btnclose -text [_ "Close"] -command [list destroy $w] \
	    -underline 0 -style BottomFrame.TButton

    grid $w.frm1.cb1 $w.frm1.b1 $w.frm1.b2 $w.frm1.b3 -sticky w
    grid configure $w.frm1.cb1 -sticky ew
    grid columnconfigure $w.frm1 "0" -weight 1
    grid $w.frm1 -padx 5 -pady 5 -sticky ew

    grid      x     $w.frm2.l01 $w.frm2.l02 $w.frm2.l03 -sticky ew
    grid $w.frm2.l10 $w.frm2.ck1 $w.frm2.cb1 $w.frm2.sb1 -sticky ew
    grid $w.frm2.l20 $w.frm2.ck2 $w.frm2.cb2 $w.frm2.sb2 -sticky ew
    grid $w.frm2.l30 $w.frm2.ck3 $w.frm2.cb3 $w.frm2.sb3 -sticky ew
    grid $w.frm2.l40 $w.frm2.ck4 $w.frm2.cb4 $w.frm2.sb4 -sticky ew
    grid columnconfigure $w.frm2 "2" -weight 1
    grid $w.frm2 -padx 5 -pady 5 -sticky ew

    grid $w.frm3.ck1 $w.frm3.ck2 $w.frm3.ck3 -sticky ew
    grid $w.frm3 -padx 5 -pady 5 -sticky ew

    grid $w.frmButtons -sticky ews -columnspan 7
    grid anchor $w.frmButtons center
    grid $w.frmButtons.btnApply $w.frmButtons.btnReset $w.frmButtons.btnclose -padx 5 -pady 6
    grid columnconfigure $w "0" -weight 1
    grid rowconfigure $w "3" -weight 1

    focus $w.frmButtons.btnApply
        
    bind $w <Return> "$w.frmButtons.btnApply invoke"
    # sign + is necessary because this binding is necessary for InitWindow
    bind $w <Destroy> [list +DestroyCustomizeRender %W $w] ;# + to add to previous script
    wm minsize $w 140 175
    
    bind $w.frm2.cb1 <<ComboboxSelected>> "CustomRenderModifyComboBoxCommand %W Point"
    bind $w.frm2.cb2 <<ComboboxSelected>> "CustomRenderModifyComboBoxCommand %W Line"
    bind $w.frm2.cb3 <<ComboboxSelected>> "CustomRenderModifyComboBoxCommand %W Surface"
    bind $w.frm2.cb4 <<ComboboxSelected>> "CustomRenderModifyComboBoxCommand %W Volume"
	
    trace add variable CustomizeRenderPriv(CustomRenderCurrent) write "SetCustomRenderCurrent ;#"
    trace add variable CustomizeRenderPriv(Show,Point) write "CustomRenderUpdateState $w Point ;#"
    trace add variable CustomizeRenderPriv(Show,Line) write "CustomRenderUpdateState $w Line ;#"
    trace add variable CustomizeRenderPriv(Show,Surface) write "CustomRenderUpdateState $w Surface ;#"
    trace add variable CustomizeRenderPriv(Show,Volume) write "CustomRenderUpdateState $w Volume ;#"
    
    trace add variable CustomizeRenderPriv(ColorBy,Point) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb1 Point ;#"
    trace add variable CustomizeRenderPriv(ColorBy,Line) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb2 Line ;#"
    trace add variable CustomizeRenderPriv(ColorBy,Surface) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb3 Surface ;#"
    trace add variable CustomizeRenderPriv(ColorBy,Volume) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb4 Volume ;#"
    
    trace add variable CustomizeRenderPriv(Size,Point) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb1 Point ;#"
    trace add variable CustomizeRenderPriv(Size,Line) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb2 Line ;#"
    trace add variable CustomizeRenderPriv(Size,Surface) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb3 Surface ;#"
    trace add variable CustomizeRenderPriv(Size,Volume) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb4 Volume ;#"            
    
    CustomRenderSetGidValues
}


proc DestroyCustomizeRender { W w } {
    if { $W != $w } return
    #avoid reenter multiple times, one by child
    global CustomizeRenderPriv

    trace remove variable CustomizeRenderPriv(CustomRenderCurrent) write "SetCustomRenderCurrent ;#"
    trace remove variable CustomizeRenderPriv(Show,Point) write "CustomRenderUpdateState $w Point ;#"
    trace remove variable CustomizeRenderPriv(Show,Line) write "CustomRenderUpdateState $w Line ;#"
    trace remove variable CustomizeRenderPriv(Show,Surface) write "CustomRenderUpdateState $w Surface ;#"
    trace remove variable CustomizeRenderPriv(Show,Volume) write "CustomRenderUpdateState $w Volume ;#"

    trace remove variable CustomizeRenderPriv(ColorBy,Point) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb1 Point ;#"
    trace remove variable CustomizeRenderPriv(ColorBy,Line) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb2 Line ;#"
    trace remove variable CustomizeRenderPriv(ColorBy,Surface) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb3 Surface ;#"
    trace remove variable CustomizeRenderPriv(ColorBy,Volume) write "CustomRenderSetComboBoxTextColorBy $w.frm2.cb4 Volume ;#"    

    trace remove variable CustomizeRenderPriv(Size,Point) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb1 Point ;#"
    trace remove variable CustomizeRenderPriv(Size,Line) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb2 Line ;#"
    trace remove variable CustomizeRenderPriv(Size,Surface) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb3 Surface ;#"
    trace remove variable CustomizeRenderPriv(Size,Volume) write "CustomRenderSetSpinBoxTextSize $w.frm2.sb4 Volume ;#"                

    #if face is not necessary remove remove traces because unsettting the variable will be removed
    unset -nocomplain CustomizeRenderPriv
}

proc SetCustomRenderCurrent { } {
    global CustomizeRenderPriv
    if { $CustomizeRenderPriv(CustomRenderCurrent) == "" } return
    GiD_Process Mescape View Render Customized Changecustom $CustomizeRenderPriv(CustomRenderCurrent) escape
    GiD_Redraw
    CustomRenderSetGidValues
}

proc CustomRenderExists { name } {
    set exists 0    
    if { [lsearch [GiD_Info customrenders] $name] != -1 } { 
        set exists 1
    }
    return $exists
}

proc NewCustomRender { w } {
    global CustomizeRenderPriv
    set name [MessageBoxEntry [_ "New customized render mode"] [_ "Enter new render mode name"] any "" 0 question.png]
    if { $name != "" } { 
        if { [CustomRenderExists $name] } {
            WarnWin [_ "Custom render '%s' already exists" $name ]            
        } else {
            GiD_Process Mescape View Render Customized NewCustom $name escape
            $w configure -values [GiD_Info customrenders]
            set CustomizeRenderPriv(CustomRenderCurrent) $name
        }                
    }    
}

proc RenameCustomRender { w } {
    global CustomizeRenderPriv
    set oldname [$w get]
    if { $oldname == "" } {
        return
    }
    set name [MessageBoxEntry [_ "Rename customized render"] [_ "Enter new name for rende mode"] any $oldname 0 question.png]
    if { $name == "" } { 
        return
    }
    if { $name == $oldname } {
        return
    }
    if { [CustomRenderExists $name] } {
        WarnWin [_ "Custom render '%s' already exists" $name ]
        return
    }
    GiD_Process Mescape View Render Customized RenameCustom $oldname $name escape
    $w configure -values [GiD_Info customrenders]
    set CustomizeRenderPriv(CustomRenderCurrent) $name
}

proc DeleteCustomRender { w } {
    global CustomizeRenderPriv
    if { $CustomizeRenderPriv(CustomRenderCurrent) == "" } return

    set retval [MessageBoxOptionsButtons [_ "Delete customized render mode"] \
	    [_ "Are you sure to delete\n custom render '%s'?" $CustomizeRenderPriv(CustomRenderCurrent)] \
	     {0 1} [list [_ "Yes"] [_ "No#C#I don't want to do that"]] question ""]
    if { $retval == 1 } { return }

    GiD_Process Mescape View Render Customized DeleteCustom $CustomizeRenderPriv(CustomRenderCurrent) escape

    set customrenders [GiD_Info customrenders]
    $w configure -values $customrenders

    set CustomizeRenderPriv(CustomRenderCurrent) [lindex $customrenders 0]
    if { $CustomizeRenderPriv(CustomRenderCurrent) == "" } {
	GiD_Redraw
    }
}

proc CustomRenderUpdateState { w EntityType } {
    global CustomizeRenderPriv
    if { $EntityType == "Point" } {
	if { $CustomizeRenderPriv(Show,Point) } {
	    $w.frm2.cb1 configure -state normal
	    $w.frm2.sb1 configure -state normal
	} else {
	    $w.frm2.cb1 configure -state disabled
	    $w.frm2.sb1 configure -state disabled
	}
    } elseif { $EntityType == "Line" } {
	if { $CustomizeRenderPriv(Show,Line) } {
	    $w.frm2.cb2 configure -state normal
	    $w.frm2.sb2 configure -state normal
	} else {
	    $w.frm2.cb2 configure -state disabled
	    $w.frm2.sb2 configure -state disabled
	}
    } elseif { $EntityType == "Surface" } {
	if { $CustomizeRenderPriv(Show,Surface) } {
	    $w.frm2.cb3 configure -state normal
	    $w.frm2.sb3 configure -state normal
	    $w.frm3.ck1 configure -state normal
	} else {
	    $w.frm2.cb3 configure -state disabled
	    $w.frm2.sb3 configure -state disabled
	    $w.frm3.ck1 configure -state disabled
	}
    } elseif { $EntityType == "Volume" } {
	if { $CustomizeRenderPriv(Show,Volume) } {
	    $w.frm2.cb4 configure -state normal
	    $w.frm2.sb4 configure -state normal
	} else {
	    $w.frm2.cb4 configure -state disabled
	    $w.frm2.sb4 configure -state disabled
	}
    }
}

proc CustomRenderModifyComboBoxCommand { w entitytype } {
    global CustomizeRenderPriv
    set CustomizeRenderPriv(ColorBy,$entitytype) [$w current]
}

proc CustomRenderSetComboBoxTextColorBy { w entitytype } {
    global CustomizeRenderPriv
    if { $CustomizeRenderPriv(ColorBy,$entitytype) != -1 } {
	$w current $CustomizeRenderPriv(ColorBy,$entitytype)
    }
}

proc CustomRenderSetSpinBoxTextSize { w entitytype } {
    global CustomizeRenderPriv
    $w set $CustomizeRenderPriv(Size,$entitytype)    
}

proc CustomRenderSetDefaultValues { } {
    global CustomizeRenderPriv
    set CustomizeRenderPriv(Show,Point) 1
    set CustomizeRenderPriv(Show,Line) 1
    set CustomizeRenderPriv(Show,Surface) 1
    set CustomizeRenderPriv(Show,Volume) 1
    #0 color by layer
    #1 color by entity type
    set CustomizeRenderPriv(ColorBy,Point) 1
    set CustomizeRenderPriv(ColorBy,Line) 0
    set CustomizeRenderPriv(ColorBy,Surface) 1
    set CustomizeRenderPriv(ColorBy,Volume) 1

    set CustomizeRenderPriv(Size,Point) 3
    set CustomizeRenderPriv(Size,Line) 1
    set CustomizeRenderPriv(Size,Surface) 1
    set CustomizeRenderPriv(Size,Volume) 1

    set CustomizeRenderPriv(FillSurface) 0
    set CustomizeRenderPriv(Lighting) 0
    set CustomizeRenderPriv(Blend) 0
}

proc CustomRenderSetGidValues { } {
    global CustomizeRenderPriv  
    
    if { [GiD_Info Project RenderMode] == "custom" } {
	set CustomizeRenderPriv(CustomRenderCurrent) [GiD_Info customrenders current]
    } else {
	set CustomizeRenderPriv(CustomRenderCurrent) ""
    }
    
    if { [GiD_Info customrenders current] == "" } return

    set CustomizeRenderPriv(Show,Point) [GiD_Set CustomRender(Show,Point)]
    set CustomizeRenderPriv(Show,Line) [GiD_Set CustomRender(Show,Line)]
    set CustomizeRenderPriv(Show,Surface) [GiD_Set CustomRender(Show,Surface)]
    set CustomizeRenderPriv(Show,Volume) [GiD_Set CustomRender(Show,Volume)]
    #0 color by layer
    #1 color by entity type
    set CustomizeRenderPriv(ColorBy,Point) [GiD_Set CustomRender(ColorBy,Point)]
    set CustomizeRenderPriv(ColorBy,Line) [GiD_Set CustomRender(ColorBy,Line)]
    set CustomizeRenderPriv(ColorBy,Surface) [GiD_Set CustomRender(ColorBy,Surface)]
    set CustomizeRenderPriv(ColorBy,Volume) [GiD_Set CustomRender(ColorBy,Volume)]

    set CustomizeRenderPriv(Size,Point) [expr int([GiD_Set CustomRender(Size,Point)])]
    set CustomizeRenderPriv(Size,Line) [expr int([GiD_Set CustomRender(Size,Line)])]
    set CustomizeRenderPriv(Size,Surface) [expr int([GiD_Set CustomRender(Size,Surface)])]
    set CustomizeRenderPriv(Size,Volume) [expr int([GiD_Set CustomRender(Size,Volume)])]

    set CustomizeRenderPriv(FillSurface) [GiD_Set CustomRender(FillSurface)]
    set CustomizeRenderPriv(Lighting) [GiD_Set CustomRender(Lighting)]
    set CustomizeRenderPriv(Blend) [GiD_Set CustomRender(Blend)]
}

proc CustomRenderSetTclValues { } {
    global CustomizeRenderPriv
    if { [GiD_Info customrenders current] == "" } return
    foreach entitytype {Point Line Surface Volume} {
	foreach item {Show ColorBy Size} {
	    GiD_Set CustomRender($item,$entitytype) $CustomizeRenderPriv($item,$entitytype)
	}
    }

    foreach item {FillSurface Blend} {
	GiD_Set CustomRender($item) $CustomizeRenderPriv($item)
    }

    set item Lighting
    if { [GiD_Set CustomRender($item)] != $CustomizeRenderPriv($item) } {
	GiD_Set CustomRender($item) $CustomizeRenderPriv($item)
	GiD_Process Mescape View Render Customized ChangeCustom [GiD_Info customrenders current] escape
    }
    GiD_Redraw
}
