
namespace eval Comparator {
    variable pid
    variable port
}

proc Comparator::StartGiD { } {    
    variable pid
    variable port

    package require commR

    set filename [file join $::GIDDEFAULT gid]
    set pid [exec $filename &]
    set port [Comparator::GetPortFromPID $pid]
    return $pid
}

proc Comparator::EndGiD { } {
    Comparator::Send GiD_Process escape escape escape quit no escape   
}

proc Comparator::GetPortFromPID { pid } {    
    variable port
    for { set i 12350 } { $i < 12360 } { incr i } {	
	catch { set remotepid [::commR::comm send $i pid] }
	if { $remotepid == $pid } {
	    set port $i
	    return $i
	}
    }
    return 0
}

proc Comparator::Send { cmd } {
    variable port   
    ::commR::comm send $port $cmd
}

proc Comparator::SendAsync { cmd } {
    variable port  
    ::commR::comm send -async $port $cmd   
}

proc Comparator::SendCommand { cmd } {
    variable port   
    ::commR::comm send -command ::Comparator::CallBack $port $cmd   
}

proc Comparator::CallBack { args } {
    WarnWinText $args
}

proc Comparator::GiD_Event_AfterProcess { words is_rotation } {
	if { [catch {Comparator::Send [list GiD_Process {*}$words]} msg] } {
	    WarnWinText $msg
	    after idle {GiD_UnRegisterEvent GiD_Event_AfterProcess ::Comparator::GiD_Event_AfterProcess}
	}
}

proc Comparator::Attach { } {   
    variable prev_UseMoreWindows
    GiD_RegisterEvent GiD_Event_AfterProcess ::Comparator::GiD_Event_AfterProcess
    set prev_UseMoreWindows [Comparator::Send [list GiD_Set UseMoreWindows]]
    Comparator::Send [list GiD_Set UseMoreWindows 0]    
}

proc Comparator::Detach { } {
    variable prev_UseMoreWindows
    Comparator::Send [list GiD_Set UseMoreWindows $prev_UseMoreWindows]
    GiD_UnRegisterEvent GiD_Event_AfterProcess ::Comparator::GiD_Event_AfterProces
}

#GiD_Event_AfterProcess is an event raised by GiD after a word has been processed
#if variable WriteRotationsInBatch is true then also dynamic rotations raise this event.

#Comparator::StartGiD  
#Comparator::Attach 
#Comparator::Detach
#Comparator::EndGiD   
