
proc CommentsFillFromGiD { w } {
    global CommentsPriv    
    lassign [GiD_Info postprocess get comments] active automatic CommentsPriv(comm1) CommentsPriv(comm2) CommentsPriv(comm3)    
    if { $active == "yes" } {
        set CommentsPriv(active) 1
    } else {
        set CommentsPriv(active) 0
    }
    if { $automatic == "yes" } {
        set CommentsPriv(automatic) 1
        if { $CommentsPriv(donde) == "PRE" } {
            set CommentsPriv(automatic) 0
        }
    } else {
        set CommentsPriv(automatic) 0
    }
}

proc AcceptComments { w } {
    global CommentsPriv
    # Now setting this setting is done through the preferences window and not
    # through this windows. so enabling comments always when this window is displayed

    GiD_Process Mescape Utilities Comments Line1 $CommentsPriv(comm1) Line2 $CommentsPriv(comm2) Line3 $CommentsPriv(comm3) escape
    GiD_Set Comments(Show) $::CommentsPriv(active)
    
    # Now setting this setting is done through the preferences window and not
    # through this windows. So to avoid confusions when the users sets the lines, then automatic comments are disabled.
    GiD_Set Comments(Automatic) 0
    destroy $w
}

proc CommentsActiveChange { w what} {
    global CommentsPriv
    switch $what {
        main {
            if { $CommentsPriv(active) == 0 } {
                $w.ch2 configure -state disabled
                for { set i 1 } { $i<=3 } { incr i } {
                    $w.fr1.l$i configure -state disabled 
                }
            } else {
                $w.ch2 configure -state normal
                CommentsAutomaticChange $w $what
                for { set i 1 } { $i<=3 } { incr i } {
                    $w.fr1.l$i configure -state normal
                }
            }
        }
        default {
        }
    }
}

proc CommentsAutomaticChange { w what} {
    global CommentsPriv
    switch $what {
        main {
            if { $CommentsPriv(automatic) == 0 } {
                for { set i 1 } { $i<=3 } { incr i } {
                    $w.fr1.l$i configure -state normal
                }
                TipWin::Close "Comments fields"
            } else {
                for { set i 1 } { $i<=3 } { incr i } {
                    $w.fr1.l$i configure -state disabled
                }
            }
        }
        default {
        }
    }
}

# args is needed because it's called from the preferences window
proc CommentsW { { w .gid.wCommentsWW } args } {
    global CommentsPriv
    #default values
    if { ![info exists ::CommentsPriv(active)] } {
        set ::CommentsPriv(active) 1
    }
    if { ![info exists ::CommentsPriv(automatic)] } {
        set ::CommentsPriv(automatic) 1
    }
    InitWindow2 $w -title [_ "Comments"] \
        -geometryvariable PrePostCommentsWindowGeom \
        -initcommand CommentsW \
        -ontop
    if { ![winfo exists $w] } return ;# windows disabled || UseMoreWindows == 0
    
    set def_back [ $w cget -background]
    
    set CommentsPriv(donde) [GetCurrentPrePostMode]
    if { $CommentsPriv(donde) == "PRE" } {
        if { ![info exists CommentsPriv(active)] } { 
            set CommentsPriv(active) 0 
        }
        ttk::checkbutton $w.ch1 -text [_ "Active"] -variable ::CommentsPriv(active)
    }
    if { ![info exists CommentsPriv(automatic)] } { set CommentsPriv(automatic) 0 }
    ttk::checkbutton $w.ch2 -text [_ "Automatic"] -variable ::CommentsPriv(automatic)
    
    set title [_ "Automatic fields"]
    
    set text "[_ "When using automatic comments (in Post)"]\n\
        [_ "you can use following fields"]:\n\
        [_ "%an - analysis name"]\n \
        [_ "%sv - step value in analysis"]\n \
        [_ "%sn - step number in analysis"]\n \
        [_ "%ns - total number of steps value in analysis"]\n \
        [_ "%vt - result visualization type"]\n \
        [_ "%vf - vector factor"]\n \
        [_ "%rn - result name"]\n \
        [_ "%cn - component name"]\n \
        [_ "%da - deformation used analysis"]\n \
        [_ "%ds - deformation used step value"]\n \
        [_ "%dr - deformation used result"]\n \
        [_ "%df - deformation used factor"]\n \
        [_ "%tcl() - evaluate a tcl expression, \n\tfor instance \"Correct step value: %tcl( expr %sv * 2.5 + 3)\""]"
    
    
    ttk::frame $w.fr1
    ttk::frame $w.but -style BottomFrame.TFrame 
    
    if { "$CommentsPriv(donde)" == "PRE" } {
        grid $w.ch1 -sticky w -column 1 -row 1
    }
    
    grid $w.fr1 -sticky nsew -padx 3 -pady 3 -column 1 -row 2 -columnspan 3
    grid $w.but -sticky nsew -column 1 -row 3 -columnspan 3
    grid anchor $w.but center
    grid columnconf $w 1 -weight 1
    grid rowconf $w 2 -weight 1
    
    
    for { set i 1 } { $i<=3 } { incr i } {
        ttk::label $w.fr1.txt$i -text [ concat [_ "Line"] " $i: "]
        ttk::entry $w.fr1.l$i -textvariable CommentsPriv(comm$i)
        
        grid $w.fr1.txt$i -column 1 -row $i
        grid $w.fr1.l$i -column 2 -row $i -sticky we
        
        grid columnconf $w.fr1 2 -weight 1
        grid rowconf $w.fr1 $i -weight 1
    }
    
    # marco de los botones    
    ttk::button $w.but.apply -text [_ "Apply"] -style BottomFrame.TButton -command "AcceptComments $w" -takefocus 0
    if { "$CommentsPriv(donde)" == "POST" } {
        ttk::button $w.but.help -text [_ "Help"] -style BottomFrame.TButton -command [list TipWin::CreateWindow .gid 0 $title $text] -takefocus 0     
    }
    ttk::button $w.but.close -text [_ "Close"] -style BottomFrame.TButton -command "destroy $w" -takefocus 0 
    
    if { "$CommentsPriv(donde)" == "PRE" } {
        grid $w.but.apply $w.but.close -sticky ews -padx 5 -pady 5
    } else {
        grid $w.but.apply $w.but.help $w.but.close -sticky ews -padx 5 -pady 5
    }
    
    focus $w.fr1.l1
    
    CommentsFillFromGiD $w
    
    bind $w <Return> "$w.but.apply invoke"   
}
