#!/home/miguel/GID-git/gidproject/run_gid.sh -tclsh
package require tdom

proc show_usage { msg } {
    puts "usage $::argv0 \[ -N\] file_in.svg file_out.svg"
    puts "      -N : adjust svg to NxN, default 24."
    puts "      $msg"
    return
}

set adj_size 24
if { $::argc == 3} {
    set opt_size [ lindex $::argv 0]
    if { [ scan $opt_size "-%d" adj_size] != 1} {
        show_usage "bad option '$opt_size', should be an integer, for instance -32."
        return
    }
    set xmlfile [ lindex $::argv 1]
    set xmlfile_out [ lindex $::argv 2]
    puts "adjusting to size $adj_size"
} elseif { $::argc == 2} {
    set xmlfile [ lindex $::argv 0]
    set xmlfile_out [ lindex $::argv 1]
} else {
    show_usage "unknown options '$::argv'."
    return
}

if { ![ file exists $xmlfile]} {
    puts "file $xmlfile does not exist."
    return
}
set xml_data [ tDOM::xmlReadFile $xmlfile]
set doc [ dom parse $xml_data]
set root [ $doc documentElement]

if { [ $root nodeName] != "svg"} {
    $doc delete
    return
}

foreach attr [ list viewBox width height] {
    set $attr ""
    if { [ $root hasAttribute $attr]} {
        set $attr [ $root getAttribute $attr]
    }
}

# puts "$xmlfile viewBox = $viewBox"
# puts "$xmlfile width   = $width"
# puts "$xmlfile height  = $height"

# N = 24
# sep_hori is 24x8 and sep_ver is 8x24  ( width x height )
set adjusted 0
if { ( $width != $adj_size) && ( $height != $adj_size)} {
    # puts "from  ( width = $width, height = $height, viewBox = $viewBox)"
    if { $viewBox == ""} {
        set viewBox "0 0 $width $height"
    }
    set width $adj_size
    set height $adj_size
    foreach attr [ list viewBox width height] {
        $root setAttribute $attr [ set $attr]
    }
    # puts "to    ( width = $width, height = $height, viewBox = $viewBox)"
    set adjusted 1
} else {
    if  { ( $width != $adj_size) || ( $height != $adj_size)} {
        puts "check ( width = $width, height = $height, viewBox = $viewBox)"
    }
}

set fo [ open $xmlfile_out w]
puts $fo "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
$doc asXML -indent 2 -channel $fo
close $fo
if { $adjusted} {
    puts "$xmlfile_out adjusted."
} else {
    puts "$xmlfile_out copied."
}
