file_input=$1
output_prefix=$2

if [ "$file_input" = "" ] || [ "$output_prefix" = "" ]; then
    echo "Usage: $0 input.svg output_prefix"
    echo "    will create 'images/size_16/output_prefix.png"
    echo "    will create 'images/size_24/output_prefix.png"
    echo "    will create 'images/size_32/output_prefix.png"
    echo "    will create 'images/size_64/output_prefix.png"
    exit
fi

if [ ! -f $file_input ] ; then
    echo "File $file_input does not exist."
    exit
fi

for sz in 64 32 24 16 ; do
    file_output=images/size_$sz/${output_prefix}.png
    inkscape -w $sz -h $sz $file_input -e $file_output
done
