#######################################################################################
#GiD Raised events
#######################################################################################

proc GiD_Event_InitProblemtype { dir } {
    global ProblemTypePriv
    set ::ProblemTypePriv(dir) $dir
    FEniCS::RegisterGiDEvents

    array set problemtype_local [GidUtils::ReadProblemtypeXml [file join $dir FEniCS.xml] Infoproblemtype {Name Version MinimumGiDVersion}]
    if { [GidUtils::VersionCmp $problemtype_local(MinimumGiDVersion)] < 0 } {  
            W [= "This problemtype requires GiD %s or later" $problemtype_local(MinimumGiDVersion)]
    }
    set ::ProblemTypePriv(name) $problemtype_local(Name)
    set ::ProblemTypePriv(version) $problemtype_local(Version)

    #GiD_DataBehaviour materials Isotropic geomlist {surfaces}     
    FEniCS::Splash
    FEniCS::ChangeMenus
}

proc GiD_Event_EndProblemtype {} {
    global ProblemTypePriv
    FEniCS::UnRegisterGiDEvents
    array unset ::ProblemTypePriv
}

proc GiD_Event_LoadModelSPD { filespd } {
    global ProblemTypePriv
    set problemtype_current [GiD_Info project ProblemType]
    if { [file tail $problemtype_current] == $::ProblemTypePriv(name) } {
        set model_problemtype_version_number [GidUtils::ReadXmlWithNameAndVersion [file rootname $filespd].xml $::ProblemTypePriv(name)]
        if { $model_problemtype_version_number != $::ProblemTypePriv(version) } {
            set must_transform 1
        } else {
            set must_transform 0
        }
        if { $must_transform } {
            GiD_Project transform_problemtype $problemtype_current
        }
    }
}

proc GiD_Event_SaveModelSPD { filespd } {
    global ProblemTypePriv    
    GidUtils::SaveXmlWithNameAndVersion [file rootname $filespd].xml $::ProblemTypePriv(name) $::ProblemTypePriv(version)
}


#to automatically convert results file to .post.res
#proc GiD_Event_AfterRunCalculation { basename dir problemtypedir where error errorfilename } {
#    if { $error == 0 } {
#        set filename [file join [lindex $dir 0] $basename].xxx
#        if { [file exists $filename] } {
#            FEniCS::ConvertResultsToGiD $filename
#        }
#    }
#    return 0
#}


#######################################################################################
#FEniCS namespace procedures
#######################################################################################

namespace eval FEniCS {
}

proc FEniCS::RegisterGiDEvents {} {
    GiD_RegisterPluginAddedMenuProc FEniCS::ChangeMenus
}

proc FEniCS::UnRegisterGiDEvents {} {
    GiD_UnRegisterPluginAddedMenuProc FEniCS::ChangeMenus
}

proc FEniCS::ShowHelp { } {
    global ProblemTypePriv 
    set help_dir [file join $::ProblemTypePriv(dir) html [GiD_Set Language]]
    if { ![file exists $help_dir] } {
        set help_dir [file join $::ProblemTypePriv(dir) html en]
    }
    GiDCustomHelp -dir $help_dir -start "FEniCS_toc.html"
}

proc FEniCS::ChangeMenus {} {
    global ProblemTypePriv
    ::GiDMenu::InsertOption Help [list [concat [= "Help on"] $::ProblemTypePriv(name)]...] 0 PREPOST [list FEniCS::ShowHelp] "" "" insert =      
    ::GiDMenu::InsertOption Help [list [concat [= "About"] $::ProblemTypePriv(name) ...]] end PREPOST FEniCS::About "" "" insert =
    ::GiDMenu::UpdateMenus
}

proc FEniCS::Splash { {self_close 1} } {
    global ProblemTypePriv
    set prev_splash_state [GiD_Set SplashWindow]
    GiD_Set SplashWindow 1 ;#set temporary to 1 to force show splash without take care of the GiD splash preference
    set txt "$::ProblemTypePriv(name) Version $::ProblemTypePriv(version)"
    ::GidUtils::Splash [file join $::ProblemTypePriv(dir) images splash.png] .splash $self_close [list $txt 180 280]
    GiD_Set SplashWindow $prev_splash_state
}

proc FEniCS::About { } {
    set self_close 0
    FEniCS::Splash $self_close
}    
