
###################################################################################
#      print data in the .dat calculation file (instead of a classic .bas template)
proc Cmas2d::WriteCalculationFile { filename } {
    GiD_WriteCalculationFile init $filename
    set elements_conditions [list "Shells"]
    # This instruction is mandatory for using materials
    customlib::InitMaterials $elements_conditions active
    GiD_WriteCalculationFile puts "=================================================================="
    GiD_WriteCalculationFile puts "                        General Data File"    
    GiD_WriteCalculationFile puts "=================================================================="
    GiD_WriteCalculationFile puts "Units:"
    GiD_WriteCalculationFile puts "length [gid_groups_conds::give_active_unit L] mass [gid_groups_conds::give_active_unit M]"
    GiD_WriteCalculationFile puts "Number of elements and nodes:"
    GiD_WriteCalculationFile puts "[GiD_Info Mesh NumElements] [GiD_Info Mesh NumNodes]"    
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "................................................................."    
    #################### COORDINATES ############################ 
    set units_mesh [gid_groups_conds::give_mesh_unit]
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "Coordinates:"
    GiD_WriteCalculationFile puts "  Node        X $units_mesh               Y $units_mesh"
    # Write all nodes of the model, and it's coordinates
    # Check documentation to write nodes from an specific condition
    # 2D case, do not print z with the tricky format %.0s
    set mesh_factor [lindex [gid_groups_conds::give_unit_factor L [gid_groups_conds::give_mesh_unit]] 0]
    GiD_WriteCalculationFile coordinates -factor $mesh_factor "%5d %14.5e %14.5e%.0s\n"
    
    #################### CONNECTIVITIES ############################    
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "................................................................."
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "Connectivities:"
    GiD_WriteCalculationFile puts "    Element    Node(1)   Node(2)   Node(3)     Material"
    set element_formats [list {"%10d" "element" "id"} {"%10d" "element" "connectivities"} {"%10d" "material" "MID"}]
    customlib::WriteConnectivities $elements_conditions $element_formats active 

    #################### MATERIALS ############################
    set num_materials [customlib::GetNumberOfMaterials used]
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "................................................................."
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "Materials:"
    GiD_WriteCalculationFile puts $num_materials
    GiD_WriteCalculationFile puts "Material      Surface density [gid_groups_conds::give_active_unit M/L^2]"
    customlib::WriteMaterials [list {"%4d" "material" "MID"} {"%13.5e" "material" "Density"}] used active
    #################### CONCENTRATE WEIGHTS ############################
    GiD_WriteCalculationFile puts ""
    GiD_WriteCalculationFile puts "................................................................."
    GiD_WriteCalculationFile puts ""
    set method 2 ;# 2 to allow condition repeat group and without require change the solver to read multiple time the same node id with different weights
    if { $method == 0 } {
        # 0 if condition cannot repeat group
        set condition_list [list "Point_Weight"]
        set condition_formats [list {"%1d" "node" "id"} {"%13.5e" "property" "Weight"}]
        set number_of_conditions [customlib::GetNumberOfNodes $condition_list]        
        GiD_WriteCalculationFile puts "Concentrate Weights:"
        GiD_WriteCalculationFile puts $number_of_conditions
        GiD_WriteCalculationFile puts "Node   Mass [gid_groups_conds::give_active_unit M]"
        customlib::WriteNodes $condition_list $condition_formats "" active 
    } elseif { $method == 1 } {
        # 1 if condition can repeat group then print repeated (but the solver must be ready to read repetitions)
        set condition_list [list "Point_Weight"]
        set condition_formats [list {"%1d" "node" "id"} {"%13.5e" "property" "Weight"}]
        set number_of_conditions [customlib::GetNumberOfNodesByGroup $condition_list]
        GiD_WriteCalculationFile puts "Concentrate Weights:"
        GiD_WriteCalculationFile puts $number_of_conditions
        GiD_WriteCalculationFile puts "Node   Mass [gid_groups_conds::give_active_unit M]"
        customlib::WriteNodesByGroup $condition_list $condition_formats "" active
    } else {
        # 2 if condition can repeat group then print without repeat weights summed
        set rootNode [$::gid_groups_conds::doc documentElement]
        set dict_format_groups [dict create]
        foreach gNode [$rootNode selectNodes {//condition[@n="Point_Weight"]//group}] {
            set group_name [$gNode @n]
            set v [[lindex [$gNode selectNodes {.//value[@n="Weight"]}] 0] @v]
            if { [info exists weights_same_group_summed($group_name)] } {
                set v [expr $v+$weights_same_group_summed($group_name)]
            }
            set weights_same_group_summed($group_name) $v
            dict set dict_format_groups $group_name "%1d [format "%13.5e" $v]\n"
        }
        set number_of_conditions 0
        foreach group_name [dict keys $dict_format_groups] {
            incr number_of_conditions [GiD_EntitiesGroups get $group_name nodes -count]
        }
        GiD_WriteCalculationFile puts "Concentrate Weights:"
        GiD_WriteCalculationFile puts $number_of_conditions
        GiD_WriteCalculationFile puts "Node   Mass [gid_groups_conds::give_active_unit M]"
        GiD_WriteCalculationFile nodes $dict_format_groups
    }
    GiD_WriteCalculationFile end ;#finish writting
}
