
proc test_tohil { } {
    set fail 0
    set debug 1

    set err [ catch {
        GiD_Python_Exec {
            import tohil;
            tcl = tohil.import_tcl(); # here maps all EXISTING tcl commands
            # not using W, if it is called the 1st time, W does not exists in Tcl
            # tcl.W( "This is a test of gid-tcl's W inside pyhon");
            import sys;
            str1 = "This is a test of gid-tcl's W inside pyhon version " + sys.version;
            tcl.eval( "W {" + str1 + "}");
            # or tohil.call( "W", "This is a test of gid-tcl's W inside pyhon");
        }
    } err_txt]
    if { $err} {
        incr fail
        if { $debug} {
            W "wanted to display an welcome message"
            W "but got ="
            WV err_txt "    "

        }
    }

    # test loading of objarray_numpy_tools
    # but numpy is not installed with GiD, do not try this test if numpy is currently missing
    if { [ GiD_Python_PipGetExistingPackages [ list numpy]] != "" } {
        incr fail [ test_tohil_objarray_numpy_tools ]
    } else {
        W "... numpy python module not installed, test_tohil_objarray_numpy_tool not run."
    }
    
    # TODO add test with meshio import export,
    # 1st with mdpa, 2nd xdmf (xml+hf5)
    # may be in test_import ?
    return $fail
}

proc test_tohil_objarray_numpy_tools { } {
    set fail 0
    set debug 1

    set err [ catch {
        GiD_Python_Exec {
            import tohil;
            tcl = tohil.import_tcl(); # here maps all EXISTING tcl commands
            # not using W, if it is called the 1st time, W does not exists in Tcl
            # tcl.W( "This is a test of gid-tcl's W inside pyhon");
            import sys;
            import numpy;
            import objarray_numpy_tools;
            from objarray_numpy_tools import nparray_to_objarray;
            str1 = "... tohil-python numpy and objarray_numpy_tools imported.";
            tcl.eval( "W {" + str1 + "}");
            # or tohil.call( "W", "This is a test of gid-tcl's W inside pyhon");
        }
    } err_txt]
    if { $err} {
        incr fail
        if { $debug} {
            W "wanted to display an welcome message"
            W "but got ="
            WV err_txt "    "

        }
    }
    # W "pythonpath = \n[ join [ split $::env(PYTHONPATH) :] \n]"

    # TODO add test with meshio import export,
    # 1st with mdpa, 2nd xdmf (xml+hf5)
    # may be in test_import ?
    return $fail
}
