
import numpy as np
import tohil 
result=tohil.call('package','require','objarray')

# warning, depending on the platform sizes of int, long, long long can change!!
def get_equivalent_objarray_type(dtype):
    objarray_type=None
    if dtype==np.float64:
        objarray_type='doublearray'
    elif dtype==np.float32:
        objarray_type='floatarray'
    elif dtype==np.int64 or dtype==np.uint64:
        objarray_type='longlongarray'
    elif dtype==np.int32 or dtype==np.uint32:
        objarray_type='intarray'
    elif dtype==np.int16 or dtype==np.uint16:
        objarray_type='shortarray'
    elif dtype==np.int8 or dtype==np.uint8:
        objarray_type='chararray'
    else:
        objarray_type=None
    return objarray_type

# warning, depending on the platform sizes of int, long, long long can change!!
def get_equivalent_numpy_type(objarray_type):
    dtype=None
    if objarray_type=='doublearray':
        dtype=np.float64        
    elif objarray_type=='floatarray':
        dtype=np.float32        
    elif objarray_type=='longarray' or objarray_type=='longlongarray':
        dtype=np.int64        
    elif objarray_type=='intarray':
        dtype=np.int32        
    elif objarray_type=='shortarray':
        dtype=np.int16
    elif objarray_type=='chararray':
        dtype=np.int8        
    else:
        objarray_type=None
    return dtype

# similar result to nparray_xyzs=np.fromiter(xyzs,dtype=np.double) (but without casting of each item)
# dtype=np.double, np.int32, ...
def objarray_to_nparray(obj_array):    
    obj_bytearray=tohil.call('objarray','get_binary',obj_array)
    nparray_byte=np.array(obj_bytearray.as_byte_array(),dtype=np.uint8)
    objarray_type=tohil.call('objarray','type',obj_array)
    dtype=get_equivalent_numpy_type(objarray_type)
    result=nparray_byte.view(dtype)
    return result

# convert big endian
def nparray_big_endian_to_little_endian(nparray):
    # > prefix mean big endian
    string_dtype=str(nparray.dtype)
    if string_dtype[0]=='>':
        if string_dtype=='>f8':
            nparray = nparray.astype(np.float64)
        elif string_dtype=='>f4':
            nparray = nparray.astype(np.float32)
        elif string_dtype=='>i8':
            nparray = nparray.astype(np.int64)
        elif string_dtype=='>i4':
            nparray = nparray.astype(np.int32)
        elif string_dtype=='>i2':
            nparray = nparray.astype(np.int16)
        elif string_dtype=='>i1':
            nparray = nparray.astype(np.int8)
    return nparray

# objarray_type : 'intarray', 'doublearray', ...
def nparray_to_objarray(nparray,required_objarray_type=None):
    result=None
    if isinstance(nparray,np.ndarray):        
        nparray=nparray_big_endian_to_little_endian(nparray)
        objarray_type=get_equivalent_objarray_type(nparray.dtype)        
        if objarray_type:
            result=tohil.call('objarray','new',objarray_type,'-binary',nparray.tobytes())            
            if required_objarray_type and required_objarray_type!=objarray_type:
                # must cast
                result=tohil.call('objarray','new',required_objarray_type,'-values',result)
        else:
            # return the same input...
            result=nparray
    else:
        # return the same input...
        result=nparray
    return result

def check_and_convert_numpy_ndarray_to_list(data):
    if isinstance(data,np.ndarray):
        result=data.tolist()
    else:
        result=data
    return result
