# to be used by gid_cross_platform::run_as_administrator gid.exe -tclsh run_as_administrator_procs.tcl command ... to do this action as administrator
# run_as_administrator_procs.tcl usually define the procs to be evaluated by this tclsh started as administrator

proc gid_zip { zipfile file_to_add } {
  package require zipfile::mkzip
  ::zipfile::mkzip::mkzip $zipfile -prepend-base-directory -directory $file_to_add
}

proc gid_unzip { zipfile extraction_dir } {
    package require zipfile::decode
    zipfile::decode::unzipfile $zipfile $extraction_dir
}

proc gid_write_text { filename text } {
	set found 0
	if { [file exists $filename] } {
		set fp [open $filename "r"]
		if { $fp != "" }  {
			while { ![eof $fp] } {
				gets $fp line
				if { $line == $text } {
					set found 1
					break
				}
			}
			close $fp
		}
	}
	if { !$found } {
		#append
		set fp [open $filename "a"]
		if { $fp != "" }  {
			puts $fp $text
			close $fp
		}
	}
}

if { [llength $::argv] > 1 } {
    set proc_name [lindex $::argv 0]
    if { [info procs $proc_name] == "" && [info commands $proc_name] == ""} {
        # error "Error: proc $proc_name not found. argv0 = $::argv0 argv = $::argv"
		# do not raise this error because using source could were ::argv -b +w of gid.exe and must not be considered here as a tcl command
		#                         and using -tclsh filename x? this filename is sourced and x? are provided as argv
    } else {
      if { [llength [info args $proc_name]] != [llength [lrange $::argv 1 end]] } {
        error "Error: proc $proc_name has wrong number of arguments"
      } else {
        eval $::argv
      }
    }
}
