
namespace eval percentencoding {
    # variables
    variable _init 0
    variable _map_to_percent
    variable _map_from_percent
    variable _unreserved_chars

    proc init { } {
        variable _init
        variable _map_to_percent
        variable _map_from_percent
        variable _unreserved_chars
        if { $_init} { return}
        for { set i 0} { $i < 255} { incr i} {
            set txt [ format "%%%02x" $i]
            set _map_to_percent($i) $txt
            set _map_from_percent($txt) $i
        }
        set _unreserved_chars \
            [ list A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \
            a b c d e f g h i j k l m n o p q r s t u v w x y z \
            0 1 2 3 4 5 6 7 8 9 - _ . ~]
        foreach c $_unreserved_chars {
            binary scan $c c num
            set num [expr { $num & 0xff }]
            set _map_to_percent($num) $c
        }
        set _init 1
    }

    proc encode_byte { b} {
        variable _init
        variable _map_to_percent
        variable _map_from_percent
        variable _unreserved_chars
        if { !$_init} { init}
        return $_map_to_percent($b)
    }

    #procedures
    # encodes a string using legal chars: [a-z] [A-Z] [0-9] and - _ . ~
    # rest is encoded as %xx, for example ' ' will be %20
    proc encode { txt} {
        if { [ string length $txt] == 0} { return ""}
        set ret {}
        binary scan $txt c* bytes
        # returns in range -128..127
        foreach c $bytes {
            # from -127...127 to range 0..255
            set b [expr { $c & 0xff }]
            append ret [ encode_byte $b]
        }
        return $ret
    }

    # returns empty string if text can not be converted:
    # contains not legal characters
    # can not parse %xx substrings
    # check_legal_chars: chars which are not %xx-encoded
    #                    should be check if they are legal
    #                    ( are in _unreserved_chars)
    proc decode { txt {check_legal_chars 0}} {
        variable _init
        variable _map_to_percent
        variable _map_from_percent
        variable _unreserved_chars
        if { !$_init} { init}
        set str_len [ string length $txt]
        set ret {}
        for { set i 0} { $i < $str_len} { incr i} {
            set c [ string index $txt $i]
            if { $c == "%"} {
                # check and substitude %xx
                set end_percent [ expr $i + 2]
                if { $end_percent >= $str_len} {
                    # WarnWinText "$end_percent >= $str_len"
                    return {}
                }
                set percent [ string tolower [ string range $txt $i $end_percent]]
                set err [ catch { set b $_map_from_percent($percent)}]
                if { $err} {
                    # WarnWinText "err = $err"
                    return {}
                }
                # WarnWinText "$percent = $b = '[ binary format c $b]'"
                append ret [ binary format c $b]
                set i $end_percent
            } else {
                # verify that character is in list of legal chars
                if { $check_legal_chars && \
                    ( [ lsearch $_unreserved_chars $c] == -1)} {
                    # WarnWinText "Character not allowed"
                    return {}
                } else {
                    append ret $c
                }
            }
        }
        return $ret
    }
}

package provide percentencoding 1.0
