#procedures to set at runtime the aspect normal/disabled of menus

proc GetColorTrueFalse { cond } {
    if { $cond } {
        return black
    } else {
        return $::GidPriv(Color,DisabledForegroundMenu)
    }
}

#changes also children's color recursivelly
proc ChangeMenuForegroundColor { menuname pos color } {
    if { [$menuname type $pos] == {separator} } {
        return
    }
    $menuname entryconfigure $pos -foreground $color
    if { [$menuname type $pos] == {cascade} } {
        set submenuname [$menuname entrycget $pos -menu]
        set ni [$submenuname index end]
        if { $ni == "none" } { set ni -1 }
        for {set i 0} {$i <= $ni} {incr i} {
            ChangeMenuForegroundColor $submenuname $i $color
        }
    }
}

proc SetMenusStates { } {    
    if { $::tcl_platform(platform) == "windows" } {
        if { [GetCurrentPrePostMode] == "PRE" } {
            SetFilesMenuState
            SetViewMenuState
            SetGeometryMenuState
            SetUtilitiesMenuState
            SetDataMenuState
            SetMeshMenuState
            SetCalculateMenuState            
        } else {
            #MENUS DE POST
        }
    } else {
        #LINUX
    }
    
}

#
proc SetMenusStatesPostCommands { w } {    
    if { [GetCurrentPrePostMode] == "PRE" } {
        set names [list "Files#C#menu" "View#C#menu" "Geometry#C#menu" "Utilities#C#menu" "Mesh#C#menu" "Calculate#C#menu"]
        set commands [list SetFilesMenuState SetViewMenuState SetGeometryMenuState SetUtilitiesMenuState SetMeshMenuState SetCalculateMenuState]
        foreach name $names command $commands {
            set i [GiDMenu::_FindIndex $name PRE]
            if { $i != -1 } {
                if { [winfo exists $w.button$i.m.m] } {
                    $w.button$i.m.m configure -postcommand $command
                }
            }
        }            
    } else {
        #MENUS DE POST            
    }
}

#the problem to use a procedure like this recursivelly is to recursivelly provide the tree of optionstochange and optionsrequire
#maybe should be stored in a global array MenuRequire similar to MenuEntries
#set MenuEntries(2,2,16) [list [_ "One node-one point#C#menu"] --- [_ "One element-one line#C#menu"] --- [_ "NURBS patches#C#menu"] [_ "One element-one surface#C#menu"] --- [_  "One element-one volume#C#menu"] --- [_ "Nodes->grid surfaces"] [_ "Triangles->grid surfaces"] ]
#set MenuRequire(2,2,16) [list nodes "" elements elements "" nodes elements]
#but also need to know the index "2,2,16" associated to a menu name, maybe stored in other global array (one for pre and other for post menus)
#to be implemented in the future...
proc SetMenuState { menuname pos optionstochange optionsrequire num_data } {
    set color(disabled) [GetColorTrueFalse 0]
    set color(normal) [GetColorTrueFalse 1]
    $menuname entryconfigure $pos -foreground $color(normal)
    set submenuname "$menuname.$pos"
    if { ![winfo exists $submenuname] } {
        return 1
    }
    set ni [$submenuname index end]
    if { $ni == "none" } {
        return 1
    }
    
    lassign $num_data npoints nlines nsurfaces nvolumes nnodes nelements    
    set nnothing 1
    
    for {set i 0} {$i <= $ni} {incr i} {
        set submenu_type [$submenuname type $i]
        if { $submenu_type != "command" && $submenu_type != "cascade" } { 
            continue 
        } 
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        set require [lindex $optionsrequire $option]
        set satisfies [set n$require]
        if { $satisfies } {
            set color_satisfies $color(normal)
        } else {
            set color_satisfies $color(disabled)
        }
        ChangeMenuForegroundColor $submenuname $i $color_satisfies
    }
    return 0
}

proc SetFilesMenuState { } {
    #all always normal
}

proc SetViewMenuState { } {
    set menu_name "View#C#menu,verb"
    set i [GiDMenu::_FindIndex $menu_name PRE]
    if { $i == -1 } return
    
    set menuname [GetMenuName $i]
    
    set ViewMode [GiD_Info Project ViewMode]
    
    if { $ViewMode == "GEOMETRYUSE" } {
        set npoints [GiD_Info Geometry NumPoints]
        set nlines [GiD_Info Geometry NumLines]
        set nsurfaces [GiD_Info Geometry NumSurfaces]
        set nvolumes [GiD_Info Geometry NumVolumes]
    } else {
        set npoints 0
        set nlines 0
        set nsurfaces 0
        set nvolumes 0
    }
    
    set option_name [list "Label#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        if { $ViewMode == "GEOMETRYUSE" } {
            ChangeMenuForegroundColor $menuname $position [GetColorTrueFalse $npoints]        
        } elseif { $ViewMode == "MESHUSE" } {
            set nnodes [GiD_Info Mesh NumNodes]
            ChangeMenuForegroundColor $menuname $position [GetColorTrueFalse $nnodes]        
        }
    }
    
    set option_name [list "Normals#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        if { $ViewMode == "GEOMETRYUSE" } {
            SetViewNormalsSubMenusState $menuname $position $nlines $nsurfaces
        } elseif { $ViewMode == "MESHUSE" } {
            set nlines [GiD_Info Mesh NumElements Linear]
            set nsurfaces [expr {[GiD_Info Mesh NumElements Triangle]+[GiD_Info Mesh NumElements Quadrilateral]+[GiD_Info Mesh NumElements Circle]}]
            ChangeMenuForegroundColor $menuname $position [GetColorTrueFalse [expr $nlines+$nsurfaces]]
        }
    }
    
    set option_name [list "Higher entities#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        if { $ViewMode == "GEOMETRYUSE" } {
            SetViewHigherEntitiesSubMenusState $menuname $position $npoints $nlines $nsurfaces
        } elseif { $ViewMode == "MESHUSE" } {
            set nnodes [GiD_Info Mesh NumNodes]
            ChangeMenuForegroundColor $menuname $position [GetColorTrueFalse $nnodes] 
        }
    }
    
    set option_name [list "Curvatures#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        if { $ViewMode == "GEOMETRYUSE" } {
            SetCurvaturesSubMenusState $menuname $position $nlines $nsurfaces    
        } elseif { $ViewMode == "MESHUSE" } {
            ChangeMenuForegroundColor $menuname $position [GetColorTrueFalse 0]             
        }
    }
}

proc SetCurvaturesSubMenusState { menuname pos nlines nsurfaces } {
    
    ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse $nlines]    
    
    set optionstochange [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"]]
    
    set submenuname $menuname.$pos
    if { ![winfo exists $submenuname] } {
        return
    }
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse $nlines]
    set colors(1) [GetColorTrueFalse $nsurfaces]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)        
    }
}

proc SetViewNormalsSubMenusState { menuname pos nlines nsurfaces } {
    ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse $nlines]   
    
    set optionstochange [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"]]
    
    set submenuname $menuname.$pos
    if { ![winfo exists $submenuname] } {
        return
    }
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse $nlines]
    set colors(1) [GetColorTrueFalse $nsurfaces]
    
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetViewHigherEntitiesSubMenusState  { menuname pos npoints nlines nsurfaces } {
    ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse $npoints]      
    
    set optionstochange [list [_ "Points"] [_ "Lines"] [_ "Surfaces"] [_ "All"] ]
    
    set submenuname $menuname.$pos
    if { ![winfo exists $submenuname] } {
        return
    }
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse $npoints]
    set colors(1) [GetColorTrueFalse $nlines]
    set colors(2) [GetColorTrueFalse $nsurfaces]
    set colors(3) [GetColorTrueFalse $npoints]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetGeometryMenuState { } {
    set menu_name "Geometry#C#menu"
    set i [GiDMenu::_FindIndex $menu_name PRE]
    if { $i == -1 } return
    
    set menuname [GetMenuName $i]
    
    set npoints [GiD_Info Geometry NumPoints]
    set nlines [GiD_Info Geometry NumLines]
    set nsurfaces [GiD_Info Geometry NumSurfaces]
    set nvolumes [GiD_Info Geometry NumVolumes]
    set nnodes [GiD_Info Mesh NumNodes]
    set nelements [GiD_Info Mesh NumElements]
    set num_data [list $npoints $nlines $nsurfaces $nvolumes $nnodes $nelements]
    
    set option_name [list "Create#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {       
        SetGeometryCreateSubMenusState $menuname $position $num_data
    }
    
    set option_name [list "Delete#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        SetGeometryDeleteSubMenusState $menuname $position $num_data
    }
    
    set option_name [list "Edit#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        SetGeometryEditSubMenusState $menuname $position $num_data
    }
}

proc SetGeometryCreateSubMenusState { menuname pos num_data } {
    set color(disabled) [GetColorTrueFalse 0]
    set color(normal) [GetColorTrueFalse 1]
    $menuname entryconfigure $pos -foreground $color(normal)
    set submenuname $menuname.$pos
    if { ![winfo exists $submenuname] } {
        return
    }
    set ni [$submenuname index end]
    if { $ni == "none" } { 
        return 
    }
    set optionstochange [list [_ "Polyline#C#menu"] [_ "NURBS surface#C#menu"] [_ "Volume#C#menu"] \
            [_ "Contact#C#menu"] [_ "Arc#C#menu"] [_ "Surface mesh#C#menu"] [_ "Geometry from mesh#C#menu"]]
    set optionsrequire [list lines points surfaces lines nothing elements nodes]
    lassign $num_data npoints nlines nsurfaces nvolumes nnodes nelements
    set nnothing 1
    for {set i 0} {$i <= $ni} {incr i} {
        set submenu_type [$submenuname type $i]
        if { $submenu_type != "command" && $submenu_type != "cascade" } { 
            continue 
        }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        set require [lindex $optionsrequire $option]
        set satisfies [set n$require]
        if { $satisfies } {
            set color_satisfies $color(normal)
        } else {
            set color_satisfies $color(disabled)
        }
        switch $option {
            0 {
                ChangeMenuForegroundColor $submenuname $i $color_satisfies
            }
            1 {
                if { !$satisfies } {
                    ChangeMenuForegroundColor $submenuname $i $color_satisfies
                } else {
                    set optionstochange2 [list [_ "By contour#C#menu"] [_ "Automatic#C#menu"] [_ "Trimmed#C#menu"] [_ "Untrimmed#C#menu"] \
                            [_ "Parallel Lines#C#menu"] [_ "By Points#C#menu"] [_ "By LinePoints#C#menu"] [_ "Search#C#menu"]]
                    set optionsrequire2 [list lines lines surfaces surfaces lines points lines lines]
                    SetMenuState $submenuname $i $optionstochange2 $optionsrequire2 $num_data
                }
            }
            2 {
                if { !$satisfies } {
                    ChangeMenuForegroundColor $submenuname $i $color_satisfies 
                } else {
                    set optionstochange2 [list [_ "By contour#C#menu"] [_ "Automatic 6-sided volumes#C#menu"] \
                            [_ "Search#C#menu"]]
                    set optionsrequire2 [list surfaces surfaces surfaces]
                    SetMenuState $submenuname $i $optionstochange2 $optionsrequire2 $num_data
                }
            }
            3 {
                if { !$satisfies } {
                    ChangeMenuForegroundColor $submenuname $i $color_satisfies 
                } else {
                    set optionstochange2 [list [_ "Surface#C#menu"] [_ "Automatic surfaces#C#menu"] [_ "Volume#C#menu"] [_ "Separated volume#C#menu"] [_ "Automatic volumes#C#menu"]]
                    set optionsrequire2 [list lines lines surfaces surfaces surfaces]
                    SetMenuState $submenuname $i $optionstochange2 $optionsrequire2 $num_data
                }
            }
            4 {
                set optionstochange2 [list [_ "Fillet curves#C#menu"] ]
                set optionsrequire2 [list lines]
                SetMenuState $submenuname $i $optionstochange2 $optionsrequire2 $num_data
            }
            5 { 
                ChangeMenuForegroundColor $submenuname $i $color_satisfies 
            }
            6 { 
                if { !$satisfies } {
                    ChangeMenuForegroundColor $submenuname $i $color_satisfies 
                } else {
                    set optionstochange2 [list [_ "One node-one point#C#menu"] [_ "One element-one line#C#menu"] [_ "NURBS patches#C#menu"] [_ "One element-one surface#C#menu"] \
                            [_  "One element-one volume#C#menu"] [_ "Nodes->grid surfaces"] [_ "Triangles->grid surfaces"]]
                    set optionsrequire2 [list nodes elements elements elements elements nodes elements]
                    SetMenuState $submenuname $i $optionstochange2 $optionsrequire2 $num_data
                }
            }
            default { 
            }
        }
    }
    return 0
}

proc SetGeometryEditSubMenusState { menuname pos num_data } {
    lassign $num_data npoints nlines nsurfaces nvolumes nnodes nelements
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Move point#C#menu"] [_ "Divide#C#menu"] [_ "Join#C#menu"] [_ "Lines operations#C#menu"] \
            [_ "Swap arc#C#menu"] [_ "Polyline#C#menu"] [_ "SurfMesh#C#menu"] \
            [_ "Rebuild surface by boundary#C#menu"]  [_ "Edit NURBS#C#menu"] [_ "Convert to NURBS#C#menu"] [_ "Simplify NURBS#C#menu"] \
            [_ "Hole surface#C#menu"] [_ "Hole volume#C#menu"] [_ "Collapse#C#menu"] [_ "Uncollapse#C#menu"] [_ "Snap to plane"] \
            [_ "Intersection#C#menu"] [_ "Surface boolean op.#C#menu"] [_ "Volume boolean op.#C#menu"]]
    
    set submenuname "$menuname.$pos"
    if { ![winfo exists $submenuname] } {
        return
    }
    if { [$submenuname index end] == "none" } {
        return
    }
    
    set colors(0) [GetColorTrueFalse $npoints]
    set colors(1) [GetColorTrueFalse $nlines]
    set colors(2) [GetColorTrueFalse $nsurfaces]
    set colors(3) [GetColorTrueFalse $nvolumes]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        switch $option {
            0 { ChangeMenuForegroundColor $submenuname $i $colors(0) }
            1 { SetDivideSubMenusState $submenuname $i $nlines $nsurfaces $nvolumes }
            2 { SetGeometryEditJoinSubMenusState $submenuname $i $nlines $nsurfaces $nvolumes }
            3 { ChangeMenuForegroundColor $submenuname $i $colors(1) }
            4 { ChangeMenuForegroundColor $submenuname $i $colors(1) }
            5 { ChangeMenuForegroundColor $submenuname $i $colors(1) }
            6 { ChangeMenuForegroundColor $submenuname $i $colors(2) }
            7 { ChangeMenuForegroundColor $submenuname $i $colors(2) }            
            8 { SetEditNurbSubMenusState $submenuname $i $nlines $nsurfaces }
            9 { SetLineSurfaceSubMenusState $submenuname $i $nlines $nsurfaces }
            10 { SetSimplifySubMenusState $submenuname $i $nlines $nsurfaces }
            11 { SetGeometryEditHoleSurfaceSubMenusState $submenuname $i $nlines $nsurfaces }
            12 { ChangeMenuForegroundColor $submenuname $i $colors(3) }
            13 { SetCollapseGeomMenusState $submenuname $i $npoints $nlines $nsurfaces $nvolumes}            
            14 { SetUnCollapseSubMenusState $submenuname $i $nlines $nsurfaces $nvolumes }
            15 { ChangeMenuForegroundColor $submenuname $i $colors(0) }
            16 { SetIntersectionSubMenusState $submenuname $i $nlines $nsurfaces }                            
            17 { ChangeMenuForegroundColor $submenuname $i $colors(2) }
            18 { ChangeMenuForegroundColor $submenuname $i $colors(3) }           
            default { }
        }
    }
}

proc SetCollapseGeomMenusState { menuname pos npoints nlines nsurfaces nvolumes } {
    
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Model"]]
    lappend optionstochange {*}[GetGeometryLabels]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse $npoints]
    set colors(1) [GetColorTrueFalse $npoints]
    set colors(2) [GetColorTrueFalse $nlines]
    set colors(3) [GetColorTrueFalse $nsurfaces]
    set colors(4) [GetColorTrueFalse $nvolumes]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetUnCollapseSubMenusState { menuname pos nlines nsurfaces nvolumes } {
    
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Lines#C#menu"] [_ "Surfaces#C#menu"] [_ "Volumes#C#menu"]]
    
    set submenuname $menuname.$pos
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse $nlines]
    set colors(1) [GetColorTrueFalse $nsurfaces]
    set colors(2) [GetColorTrueFalse $nvolumes]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetIntersectionSubMenusState { menuname pos nlines nsurfaces } {
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
    } else {
        $menuname entryconfigure $pos -foreground black
        set submenuname $menuname.$pos
        set optionstochange [list [_ "Lines#C#menu"] [_ "Surface-2 points#C#menu"] \
                [_ "Surface-lines#C#menu"] [_ "Surfaces#C#menu"]]
        set colors(0) [GetColorTrueFalse $nlines]
        
        set colors(0) [GetColorTrueFalse $nlines]
        set colors(1) [GetColorTrueFalse $nsurfaces]
        set colors(2) [GetColorTrueFalse $nsurfaces]
        set colors(3) [GetColorTrueFalse $nsurfaces]
        
        set ni [$submenuname index end]
        if { $ni == "none" } { set ni -1 }
        for {set j 0} {$j <= $ni} {incr j} {
            if { [$submenuname type $j] != {command} && [$submenuname type $j] != {cascade} } { continue }
            set option [lsearch $optionstochange [$submenuname entrycget $j -label]]
            if { $option == -1 } { continue }
            ChangeMenuForegroundColor $submenuname $j $colors($option)            
        }
    }
}

proc SetDivideSubMenusState {  menuname pos nlines nsurfaces nvolumes } {
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set optionstochange [lrange [GetGeometryLabels] 1 end]
    lappend optionstochange {*}[list [_ "Polylines"]]
    set statecolors [lrange [GetGeometryStateColors 1 $nlines $nsurfaces $nvolumes] 1 end]
    lappend statecolors {*}[list [GetColorTrueFalse $nlines]]
    
    for {set i 0} {$i <= [$submenuname index end]} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

proc SetGeometryEditJoinSubMenusState {  menuname pos nlines nsurfaces nvolumes } {
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    $menuname entryconfigure $pos -foreground black
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }    
    set optionstochange [lrange [GetGeometryLabels] 1 end]    
    set statecolors [lrange [GetGeometryStateColors 1 $nlines $nsurfaces $nvolumes] 1 end]
    for {set i 0} {$i <= [$submenuname index end]} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

proc SetSimplifySubMenusState { menuname pos nlines nsurfaces } {
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Model#C#menu"] [_ "Line#C#menu"] [_ "Surface#C#menu"]]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nlines]
    set colors(2) [GetColorTrueFalse $nsurfaces]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetGeometryEditHoleSurfaceSubMenusState { menuname pos nlines nsurfaces } {
    if { !$nsurfaces } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    $menuname entryconfigure $pos -foreground black
    set optionstochange [list [_ "With lines#C#menu"] [_ "With surfaces#C#menu"]]
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    set colors(0) [GetColorTrueFalse $nlines]
    set colors(1) [GetColorTrueFalse $nsurfaces]    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetLineSurfaceSubMenusState {  menuname pos nlines nsurfaces } {
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Line#C#menu"] [_ "Surface#C#menu"]]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nsurfaces]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetEditNurbSubMenusState {  menuname pos nlines nsurfaces } {
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Line#C#menu"]... [_ "Surface#C#menu"]...]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nsurfaces]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetGeometryDeleteSubMenusState {  menuname pos num_data } {
    
    lassign $num_data npoints nlines nsurfaces nvolumes nnodes nelements    
    
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [GetGeometryLabels]
    lappend optionstochange {*}[list [_ "All types"]]
    
    set submenuname $menuname.$pos
    if { ![winfo exists $submenuname] } { return }
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nlines]
    set colors(2) [GetColorTrueFalse $nsurfaces]
    set colors(3) [GetColorTrueFalse $nvolumes]
    set colors(4) [GetColorTrueFalse 1]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetUtilitiesMenuState { } {
    set menu_name "Utilities#C#menu"
    set i [GiDMenu::_FindIndex $menu_name PRE]
    if { $i == -1 } return
    
    set menuname [GetMenuName $i]
    
    set npoints [GiD_Info Geometry NumPoints]
    set nlines [GiD_Info Geometry NumLines]
    set nsurfaces [GiD_Info Geometry NumSurfaces]
    set nvolumes [GiD_Info Geometry NumVolumes]
    
    set optionstochange [list [list "Copy#C#menu"] \
            [list "Move#C#menu"] [list "List#C#menu"] [list "Mass#C#menu"] [list "Renumber#C#menu"] [list "Id#C#menu"] \
            [list "Distance#C#menu"] [list "Repair model#C#menu"]]    
    
    if { [GiD_Info Project ViewMode] == "MESHUSE" } {
        set color black
        foreach option_name $optionstochange {
            set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
            if { $position != -1 } {
                ChangeMenuForegroundColor $menuname $position $color
            }
        }
        return
    }
    
    if { !$npoints } {
        set color [GetColorTrueFalse 0]
        foreach option_name $optionstochange {
            set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
            if { $position != -1 } {
                ChangeMenuForegroundColor $menuname $position $color
            }
        }
    } else {
        set color black
        foreach option_name $optionstochange {
            set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
            if { $position != -1 } {
                ChangeMenuForegroundColor $menuname $position $color
            }
        }
    }
}

proc SetDataMenuState { } {
    
    if { [GiD_Info Project ProblemType] != "UNKNOWN" } return
    
    set menu_name "Data#C#menu"
    set i [GiDMenu::_FindIndex $menu_name PRE]
    if { $i == -1 } return
    
    set menuname [GetMenuName $i]
    if { ![winfo exists $menuname] } {
        return
    }
    
    set colors(0) [GetColorTrueFalse [expr {[GiD_Info Project ProblemType] != "UNKNOWN"}]]
    
    set optionstochange [list [_ "Conditions#C#menu"] [_ "Materials#C#menu"] [_ "Interval data#C#menu"] [_ "Problem data#C#menu"]]
    set ni [$menuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$menuname type $i] == {command} } {
            if { [lsearch $optionstochange [$menuname entrycget $i -label]] != -1 } {
                ChangeMenuForegroundColor $menuname $i $colors(0)
            }
        }
    }
    
    if { ![GiD_Info unitssystems] || ![ModUnitWin::Init .gid.dataunits] } {
        set optionstochange [list [_ "Data units#C#menu"]]
        set ni [$menuname index end]
        if { $ni == "none" } { set ni -1 }
        for {set i 0} {$i <= $ni} {incr i} {
            if { [$menuname type $i] == {command} } {
                if { [lsearch $optionstochange [$menuname entrycget $i -label]] != -1 } {
                    ChangeMenuForegroundColor $menuname $i $colors(0)
                }
            }
        }
    }
}

proc SetMeshMenuState { } {
    set menu_name "Mesh#C#menu"
    set i [GiDMenu::_FindIndex $menu_name PRE]
    if { $i == -1 } return
    
    set menuname [GetMenuName $i]
    if { ![winfo exists $menuname] } {
        return
    }
    
    set npoints [GiD_Info Geometry NumPoints]
    set nlines [GiD_Info Geometry NumLines]
    set nsurfaces [GiD_Info Geometry NumSurfaces]
    set nvolumes [GiD_Info Geometry NumVolumes]
    
    if { !$npoints } {
        set color [GetColorTrueFalse 0]
        
        set optionstochange [list [list "Unstructured#C#menu"] [list "Structured#C#menu"]\
                [list "Semi-structured#C#menu"] [list "Assign cartesian size#C#menu"] \
                [list "Element type#C#menu"] [list "Reset mesh data#C#menu"] \
                [list "Mesh criteria#C#menu"] [list "Draw#C#menu"] [list "Generate mesh#C#menu"] \
                [list "Show errors#C#menu"] [list "Boundary layer#C#menu"]]
        
        foreach option_name $optionstochange {
            set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
            if { $position != -1 } {
                ChangeMenuForegroundColor $menuname $position $color
            }
        }
    } else {
        set option_name [list "Unstructured#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetUnstructuredSubMenusState $menuname $position $npoints $nlines $nsurfaces $nvolumes
        }
        
        set option_name [list "Structured#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetStructuredSubMenusState $menuname $position $nlines $nsurfaces $nvolumes
        }
        
        set option_name [list "Semi-structured#C#menu"]
        if { !$nvolumes } {
            set color [GetColorTrueFalse 0]
        } else {
            set color black
        }
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            ChangeMenuForegroundColor $menuname $position $color
        }
        
        set option_name [list "Assign cartesian size#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetCartesianSubMenusState $menuname $position $npoints $nlines $nsurfaces $nvolumes
        }
        
        set option_name [list "Boundary layer#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetBoundaryLayerSubMenusState $menuname $position $nsurfaces $nvolumes
        }
        
        set option_name [list "Element type#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetElementTypeSubMenusState $menuname $position $nlines $nsurfaces $nvolumes
        }
        
        set color black
        set option_name [list "Reset mesh data#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            ChangeMenuForegroundColor $menuname $position $color
        }
        
        set option_name [list "Mesh criteria#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetMeshCriteriaSubMenusState $menuname $position $npoints $nlines $nsurfaces $nvolumes
        }
        
        set option_name [list "Draw#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            SetDrawSubMenusState $menuname $position $npoints $nlines $nsurfaces $nvolumes
        }
        
        set color black
        set option_name [list "Generate mesh#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            ChangeMenuForegroundColor $menuname $position $color
        }
    }
    
    set optionstochange [list [list "Erase mesh#C#menu"] \
            [list "View mesh boundary#C#menu"] [list "Create boundary mesh#C#menu"] \
            [list "Mesh quality#C#menu"]]
    if { [GidUtils::ExistsMesh] } {
        set color black
    } else {
        set color [GetColorTrueFalse 0]
    }
    foreach option_name $optionstochange {
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            ChangeMenuForegroundColor $menuname $position $color
        }
    }
    
    set option_name [list "Show errors#C#menu"]
    if { [MeshErrors::ExistsMessages] } {
        set color black
    } else {
        set color [GetColorTrueFalse 0]
    }
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        ChangeMenuForegroundColor $menuname $position $color
    }
    
}

proc SetCartesianSubMenusState {  menuname pos npoints nlines nsurfaces nvolumes } {
    
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [GetGeometryLabels]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nlines]
    set colors(2) [GetColorTrueFalse $nsurfaces]
    set colors(3) [GetColorTrueFalse $nvolumes]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } continue
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
}

proc SetUnstructuredSubMenusState { menuname pos npoints nlines nsurfaces nvolumes } {
    
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Assign sizes on points#C#menu"] [_ "Assign sizes on lines#C#menu"] \
            [_ "Assign sizes on surfaces#C#menu"] [_ "Assign sizes on volumes#C#menu"] \
            [_ "Sizes by chordal error#C#menu"]... [_ "Correct sizes#C#menu"]... \
            [_ "Sizes by background mesh#C#menu"]... [_ "Assign entities#C#menu"]]
    
    set optionstochange2 [GetGeometryLabels]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nlines]
    set colors(2) [GetColorTrueFalse $nsurfaces]
    set colors(3) [GetColorTrueFalse $nvolumes]
    set colors(4) [GetColorTrueFalse 1]
    set colors(5) [GetColorTrueFalse 1]
    set colors(6) [GetColorTrueFalse 1]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        if { $option < 7 } {
            ChangeMenuForegroundColor $submenuname $i $colors($option)
        } else {
            if { !$nlines && !$nsurfaces && !$nvolumes } {
                ChangeMenuForegroundColor $submenuname $i [GetColorTrueFalse 0]
            } else {
                $submenuname entryconfigure $i -foreground black
                set subsubmenuname "$submenuname.$i"
                set nj [$subsubmenuname index end]
                if { $nj == "none" } { set nj -1 }
                for {set j 0} {$j <= $nj} {incr j} {
                    if { [$subsubmenuname type $i] != {command} && [$subsubmenuname type $i] != {cascade} } { continue }
                    set option [lsearch $optionstochange2 [$subsubmenuname entrycget $j -label]]
                    if { $option == -1 } { continue }
                    ChangeMenuForegroundColor $subsubmenuname $j $colors($option)
                }
            }
        }
    }
    
}

proc SetBoundaryLayerSubMenusState {  menuname pos nsurfaces nvolumes } {
    
    if { !$nsurfaces } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "2D#C#menu"] [_ "3D#C#menu"] [_ "Reset#C#menu"]]
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set colors(0) [GetColorTrueFalse 1]
    set colors(1) [GetColorTrueFalse $nvolumes]
    set colors(2) [GetColorTrueFalse 1]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i $colors($option)
    }
    
}

proc SetStructuredSubMenusState {  menuname pos nlines nsurfaces nvolumes } {
    
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set optionstochange [lrange [GetGeometryLabels] 1 end]
    set statecolors [lrange [GetGeometryStateColors 1 $nlines $nsurfaces $nvolumes] 1 end]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
    
}

proc SetElementTypeSubMenusState { menuname pos nlines nsurfaces nvolumes } {
    
    if { !$nlines } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Default#C#menu"] [_ "Linear#C#menu"] [_ "Triangle#C#menu"] \
            [_ "Quadrilateral#C#menu"] [_ "Tetrahedra#C#menu"] [_ "Hexahedra#C#menu"] \
            [_ "Prism#C#menu"] [_ "Only points#C#menu"] [_ "Sphere#C#menu"] [_ "Circle#C#menu"] ]
    
    set submenuname $menuname.$pos
    if { [$submenuname index end] == "none" } { return }
    
    set optionstochange2 [lrange [GetGeometryLabels] 1 end]
    set statecolors [lrange [GetGeometryStateColors 1 $nlines $nsurfaces $nvolumes] 1 end]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        if { $option == 0} {
            #Default
            $submenuname entryconfigure $i -foreground [GetColorTrueFalse $nsurfaces]
            set subsubmenuname $submenuname.$i
            set nj [$subsubmenuname index end]
            if { $nj == "none" } { set nj -1 }
            for {set j 0} {$j <= $nj} {incr j} {
                if { [$subsubmenuname type $i] != {command} && [$subsubmenuname type $i] != {cascade} } { continue }
                set option [lsearch $optionstochange2 [$subsubmenuname entrycget $j -label]]
                if { $option == -1 } { continue }
                ChangeMenuForegroundColor $subsubmenuname $j [lindex $statecolors $option]
            }
        } elseif { $option == 1} {
            #Linear
            if { !$nsurfaces } {
                ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
                continue
            }
            $submenuname entryconfigure $i -foreground black
            set subsubmenuname "$submenuname.$i"
            set nj [$subsubmenuname index end]
            if { $nj == "none" } { set nj -1 }
            for {set j 0} {$j <= $nj} {incr j} {
                if { [$subsubmenuname type $i] != {command} && [$subsubmenuname type $i] != {cascade} } { continue }
                set option [lsearch $optionstochange2 [$subsubmenuname entrycget $j -label]]
                if { $option == -1 } { continue }
                ChangeMenuForegroundColor $subsubmenuname $j [lindex $statecolors $option]
            }
        } elseif { $option == 2 || $option == 3 || $option == 9} {
            #surface elements
            set option [lsearch $optionstochange2 [_ "Surfaces"]]
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
        } else {
            #volume elements
            set option [lsearch $optionstochange2 [_ "Volumes"]]
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
        }
    }
}

proc SetMeshCriteriaSubMenusState { menuname pos npoints nlines nsurfaces nvolumes } {
    
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set optionstochange [list [_ "Default#C#menu"] [_ "Mesh#C#menu,verb"] [_ "No mesh#C#menu,verb"] [_ "Default mesh#C#menu,verb" ] \
            [_ "Skip#C#menu"] [_ "No skip#C#menu"] [_ "Automatic skip#C#menu"] [_ "Skip by...#C#menu"] [_ "Force points to#C#menu"] \
            [_ "Duplicate#C#menu"] [_ "No Duplicate#C#menu"] ]
    set optionstochange2 [GetGeometryLabels]
    if { $::GidPriv(HideSurfaceLevel) == 0 } {
        lappend optionstochange2 {*}[list [_ "Surface mesh"]]
    }
    if { $::GidPriv(HideVolumeLevel)==0 } {
        lappend optionstochange2 {*}[list [_ "Volume mesh"]]
    }
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    
    set statecolors [GetGeometryStateColors $npoints $nlines $nsurfaces $nvolumes]
    if { $::GidPriv(HideSurfaceLevel) == 0 } {
        lappend statecolors {*}[list [GetColorTrueFalse $nsurfaces]]
    }
    if { $::GidPriv(HideVolumeLevel)==0 } {
        lappend statecolors {*}[list [GetColorTrueFalse $nvolumes]]
    }
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        if  { $option ==1 || $option ==2 || $option ==3 || $option ==9 || $option ==10 } {
            if { !$nlines } {
                ChangeMenuForegroundColor $submenuname $i [GetColorTrueFalse 0]
                continue
            }
        }
        if  { $option ==7 } {#this is not cascade menu
            ChangeMenuForegroundColor $submenuname $i [GetColorTrueFalse $nsurfaces]
            continue
        }
        if  { $option ==8 } {
            if { !$nsurfaces } {
                ChangeMenuForegroundColor $submenuname $i [GetColorTrueFalse 0]
                continue
            }
        }
        $submenuname entryconfigure $i -foreground black
        set subsubmenuname "$submenuname.$i"
        set nj [$subsubmenuname index end]
        if { $nj == "none" } { set nj -1 }
        for {set j 0} {$j <= $nj} {incr j} {
            if { [$subsubmenuname type $j] != {command} && [$subsubmenuname type $j] != {cascade} } { continue }
            set option [lsearch $optionstochange2 [$subsubmenuname entrycget $j -label]]
            if { $option == -1 } { continue }
            ChangeMenuForegroundColor $subsubmenuname $j [lindex $statecolors $option]
        }
    }
    
}

proc SetDrawSubMenusState { menuname pos npoints nlines nsurfaces nvolumes} {
    if { !$npoints } {
        ChangeMenuForegroundColor $menuname $pos [GetColorTrueFalse 0]
        return
    }
    
    $menuname entryconfigure $pos -foreground black
    
    set submenuname "$menuname.$pos"
    if { [$submenuname index end] == "none" } { return }
    
    set optionstochange [list [_ "Num of divisions#C#menu"] [_ "Sizes#C#menu"] \
            [_ "Element type#C#menu"] [_ "Mesh / No mesh#C#menu,verb"] \
            [_ "Structured type#C#menu"] [_ "Skip entities (Rjump)#C#menu"] [_ "Duplicate#C#menu"] \
            [_ "Force points to#C#menu"] [_ "Boundary layer#C#menu"]]
    
    set statecolors [GetGeometryStateColors $npoints $nlines $nsurfaces $nvolumes]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        if { $option == 0 } {
            #Num of divisions            
        } elseif { $option == 1 } {
            #Sizes submenu is treated in DrawSize
            $submenuname entryconfigure $i -foreground black
            set subsubmenuname $submenuname.$i
            SetDrawSizeSubMenuState $subsubmenuname $npoints $nlines $nsurfaces $nvolumes
        } elseif { $option == 2 } {
            #Element Type            
            $submenuname entryconfigure $i -foreground [lindex $statecolors 0]
            set subsubmenuname $submenuname.$i
            SetDrawElementTypeSubMenuState $subsubmenuname $npoints $nlines $nsurfaces $nvolumes
        } elseif { $option == 3 } {
            #Mesh / No mesh
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors 0]
            set subsubmenuname $submenuname.$i
            SetDrawMeshNoMeshSubMenuState $subsubmenuname $npoints $nlines $nsurfaces $nvolumes
        } elseif { $option == 4 } {
            #Structured type
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors 0]
            set subsubmenuname $submenuname.$i
            SetDrawStructuredTypeSubMenuState $subsubmenuname $npoints $nlines $nsurfaces $nvolumes
        } elseif { $option == 5 } {
            #Skip entities (Rjump)
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors 0]
        } elseif { $option == 6 } {
            #Duplicate
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors 1]
        } elseif { $option == 7 } {
            #Force points to
            set subsubmenuname $submenuname.$i
            SetDrawForcePointsToMeshSubMenuState $subsubmenuname $npoints $nlines $nsurfaces $nvolumes
        } elseif { $option == 8 } {
            #Boundary layer
            ChangeMenuForegroundColor $submenuname $i [lindex $statecolors 2]
            #             set subsubmenuname $submenuname.$i
            #             SetDrawBoundaryLayerMeshSubMenuState $subsubmenuname $npoints $nlines $nsurfaces $nvolumes
        }
    }
}

proc SetDrawElementTypeSubMenuState { submenuname npoints nlines nsurfaces nvolumes } {
    set optionstochange [lrange [GetGeometryLabels] 1 end]
    lappend optionstochange {*}[list [_ "All types"]]    
    set statecolors [lrange [GetGeometryStateColors $npoints $nlines $nsurfaces $nvolumes] 1 end]
    lappend statecolors [GetColorTrueFalse [expr {$npoints+$nlines+$nsurfaces+$nvolumes}]]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

proc SetDrawStructuredTypeSubMenuState { submenuname npoints nlines nsurfaces nvolumes } {
    set optionstochange [lrange [GetGeometryLabels] 1 end]
    lappend optionstochange {*}[list [_ "All types"]]    
    set statecolors [lrange [GetGeometryStateColors $npoints $nlines $nsurfaces $nvolumes] 1 end]
    lappend statecolors [GetColorTrueFalse [expr {$npoints+$nlines+$nsurfaces+$nvolumes}]]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

proc SetDrawSizeSubMenuState { submenuname npoints nlines nsurfaces nvolumes } {
    if { [GiD_Info Project BackgroundFilename] != "" } {
        return
    }
    
    set optionstochange [GetGeometryLabels]
    lappend optionstochange {*}[list [_ "All types"]]    
    set statecolors [GetGeometryStateColors $npoints $nlines $nsurfaces $nvolumes]
    lappend statecolors [GetColorTrueFalse [expr {$npoints+$nlines+$nsurfaces+$nvolumes}]]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

proc SetDrawMeshNoMeshSubMenuState { submenuname npoints nlines nsurfaces nvolumes } {  
    set optionstochange [GetGeometryLabels]
    lappend optionstochange [_ "All types"]
    set statecolors [GetGeometryStateColors $npoints $nlines $nsurfaces $nvolumes]
    lappend statecolors [GetColorTrueFalse [expr {$npoints+$nlines+$nsurfaces+$nvolumes}]]
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

proc SetDrawForcePointsToMeshSubMenuState { submenuname npoints nlines nsurfaces nvolumes } {
    set optionstochange [list]
    set statecolors [list]
    if { $::GidPriv(HideSurfaceLevel)==0 } {
        lappend optionstochange [_ "Surface mesh"]
        lappend statecolors [GetColorTrueFalse $nsurfaces]
    }
    if { $::GidPriv(HideVolumeLevel)==0 } {
        lappend optionstochange [_ "Volume mesh"]
        lappend statecolors [GetColorTrueFalse $nvolumes]
    }    
    
    set ni [$submenuname index end]
    if { $ni == "none" } { set ni -1 }
    for {set i 0} {$i <= $ni} {incr i} {
        if { [$submenuname type $i] != {command} && [$submenuname type $i] != {cascade} } { continue }
        set option [lsearch $optionstochange [$submenuname entrycget $i -label]]
        if { $option == -1 } { continue }
        ChangeMenuForegroundColor $submenuname $i [lindex $statecolors $option]
    }
}

# proc SetDrawBoundaryLayerMeshSubMenuState { w npoints nlines nsurfaces nvolumes } {
    # }

proc SetCalculateMenuState { } {
    set menu_name "Calculate#C#menu"
    set i [GiDMenu::_FindIndex $menu_name PRE]
    if { $i == -1 } return
    
    set menuname [GetMenuName $i]
    
    if { 0 } {
        #if 0 to not do it, some programs like iso-geometric ones can calculate without have mesh
        if { [GidUtils::ExistsMesh] } {
            set color black            
        } else {
            set color [GetColorTrueFalse 0]
        }
        set option_name [list "Calculate#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            ChangeMenuForegroundColor $menuname $position $color
        }
        
        set option_name [list "Calculate remote#C#menu"]
        set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
        if { $position != -1 } {
            ChangeMenuForegroundColor $menuname $position $color
        }
    }
    
    if { [GiD_GetNumProcessesRunning] } {
        set color black
    } else {
        set color [GetColorTrueFalse 0]
    }
    set option_name [list "Cancel process#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        ChangeMenuForegroundColor $menuname $position $color
    }
    
    if { [PWFIndOutputFilenameCurrent] == "" } {
        set color [GetColorTrueFalse 0]
    } else {
        set color black
    }
    set option_name [list "View process info#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        ChangeMenuForegroundColor $menuname $position $color
    }
    
    if { [GiD_Info Project ProblemType] == "UNKNOWN" } {
        set color [GetColorTrueFalse 0]
    } else {
        set color black
    }
    set option_name [list "Calculate window#C#menu"]
    set position [lindex [split [GiDMenu::_FindOptionIndex $i $option_name PRE] ,] end]
    if { $position != -1 } {
        ChangeMenuForegroundColor $menuname $position $color
    }
}
